<?php
/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/

//
//$Id: license.php,v 1.0 2011/06/14 20:52:11
//License - License Script for Oorjit Deal System
//
require_once("Database.class.php");
$dbname	= DB_NAME;
$sql	= new MySQL_class;
$sql->Create("$dbname");

// To find the hardware address from the hardware configuration 
function get_between($input, $start, $end)
{ 
  $substr = substr($input, strlen($start)+strpos($input, $start), (strlen($input) - strpos($input, $end))*(-1));
  return $substr;
} 

/**************************** New Functions ***************************/

/**** Unique Key Generation To Pass The Result To Avoid Proxy Attack  ****/

/**** Generate Random Key  ****/
function generateKey($length)
{
	//generate a random key
	//$length =13;
	$randomkey = "0123456789abcdefghijklmnopqrstuvwxyz";    
	// set up a counter
	$i = 0; 
	// add random characters to $randomNumber until $length is reached
	while ($i < $length) 
  	{ 
    	// pick a random character from the possible ones
   		$char = substr($randomkey, mt_rand(0, strlen($randomkey)-1), 1);        
    	// we don't want this character if it's already in the password
   		if (!strstr($randomNumber, $char)) 
		{ 
      		$randomNumber = $randomNumber.$char;
      		$i++;
    	}
  	}
	return $randomNumber;		
}
/**** End Generate Random Key  ****/

/**** Encode domain name and host to apply with random key  ****/
function encodeDmhostip($data)
{
	$uid		= uniqid("", true);
	$encfirst	= str_rot13(base64_encode($data."~!".$uid));
	$encdata	= urlencode($encfirst);
	return $encdata;
}
/**** End Encode domain name and host to apply with random key  ****/

/**** Apply/Join Random Key With Result ****/
function applyrandomKey($domaininfo="",$msg,$custinfo="")
{
	$length			= 5;
	$randomKey		= generateKey($length); 
	$data			= "";
	$data 			.= $_SERVER['REQUEST_TIME']."~!";
	$data 			.= $domaininfo;
	$dmhostenc		= encodeDmhostip($data);
	$custinfoenc	= encodeDmhostip($custinfo);
	// Join it with random key
	$uniquekey		= $randomKey."&4&!2".$msg."&4&!2".$dmhostenc."&4&!2".$custinfoenc;	
	$uniquekeyenc	= encodeDmhostip($uniquekey);
	return $uniquekeyenc;
	
}
/**** End Apply/Join Random Key With Result ****/

/**** Decode Parameter ****/
function paramDecode($encresult)
{
	$encfirst	= urldecode($encresult);
	$decsecnd	= base64_decode($encfirst);
	$decdata	= str_rot13(convert_uudecode($decsecnd));
	return $decdata;
}
/**** End Decode Parameter ****/

/**** Get Hardware Address ****/
function getHardwareaddr($hdetails,$domainip)
{
	$haddr			= array();
	$iaddr			= array();
	// To check multiple hardware address	
	$scount		= substr_count($hdetails,"HWaddr"); 
	$inetcount	= substr_count($hdetails,"inet addr");
	$bcastcount	= substr_count($hdetails,"Bcast");
	if($scount>1)
	{
		//For multiple hardware address
		for($i=0;$i<$scount;$i++)
		{	
			$haddr[$i] = get_between($hdetails, "HWaddr ", "inet addr:");  
			$iaddr[$i] = get_between($hdetails, "inet addr:", "  Bcast:");
			$pos = strpos($hdetails, "Bcast:");
			$hdetails = substr($hdetails,($pos+7));
			if( ($iaddr[$i]==$domainip) || (strstr($iaddr[$i],$domainip)) )
			{
				$hardwareaddr = $haddr[$i];	
				if(($hardwareaddr=="") || (substr($hardwareaddr,0,8)=="00-00-00"))
				{
					$inetdmtest = strstr($iaddr[$i],$domainip);							
					$inetharr = preg_split("'/|:|-|\s|/'",$inetdmtest);
					
					for($g=0;$g<count($inetharr);$g++)
					{
						$inethadr = $inetharr[$g];
						
						if($inethadr==$domainip)
						{			
							$hardwareaddr = "00:00:00:00:00:00";	
						}		
					}
				}
			}
		}
	}
	else if($scount==1)
	{
		if(($inetcount>1) || ($bcastcount>1))
		{
			$pos = strpos($hdetails, "HWaddr ");
			$hdetails = substr($hdetails,($pos));
			//For single hardware address
			$hardwareaddr = get_between($hdetails, "HWaddr ", "inet addr:");  
			$inetaddr = get_between($hdetails, "inet addr:", "  Bcast:");
			if( ($inetaddr==$domainip) || (strstr($inetaddr,$domainip)) )
			{
				$hardwareaddr = $hardwareaddr;				
				if(($hardwareaddr=="") || (substr($hardwareaddr,0,8)=="00-00-00"))
				{
					$inetdmtest = $inetaddr;
					$inetharr = preg_split("'/|:|-|\s|/'",$inetdmtest);
					
					for($g=0;$g<count($inetharr);$g++)
					{
						$inethadr = $inetharr[$g];					
						if($inethadr==$domainip)
						{			
							$hardwareaddr = "00:00:00:00:00:00";	
						}		
					}		
				}
			}	
		}
		else
		{
			//For single hardware address
			$hardwareaddr = get_between($hdetails, "HWaddr ", "inet addr:");  
			$inetaddr = get_between($hdetails, "inet addr:", "  Bcast:");

			if( ($inetaddr==$domainip) || (strstr($inetaddr,$domainip)) )
			{
				$hardwareaddr = $hardwareaddr;			
				if(($hardwareaddr=="") || (substr($hardwareaddr,0,8)=="00-00-00"))
				{
					$inetdmtest = $inetaddr;
					$inetharr = preg_split("'/|:|-|\s|/'",$inetdmtest);
					
					for($g=0;$g<count($inetharr);$g++)
					{
						$inethadr = $inetharr[$g];					
						if($inethadr==$domainip)
						{			
							$hardwareaddr = "00:00:00:00:00:00";	
						}		
					}		
				}
			}
		}
	}
	else
	{		
		if($hdetails=="")
		{
			$hardwareaddr = "wopn";	
		}
		else if($scount<1)
		{
			$hardwareaddr = "wokey";
		}
		else
		{
			$hardwareaddr = "";
		}
	}
	return $hardwareaddr;
}
/**** End Get Hardware Address ****/

/**** Expiry Check ****/
function expiryCheckCommon($resultLic,$today,$data,$domainname,$licensekey,$prevaccessData,$serverpathtoLic,$new,$sql)
{
	if($resultLic['expiry']=="Yes")
	{
		$todays_date = strtotime($today); 
		$expiration_date = strtotime($resultLic['expiryDate']); 
		if($expiration_date < $todays_date)
		{
			$msg = 3;
			if($new==1)
			{
				$queryS = "insert into site_access_details set licenceID='".$sql->escape($resultLic['licenceID'])."', domainName='".$sql->escape($data[1])."', licenceKey='".$licensekey."', accessStatus='License Expired', accessData='License Expired', prevaccessData='".$sql->escape($prevaccessData)."', accessedPath='".$sql->escape($data[5])."', accessTime=now(), accessIP='".$sql->escape($data[10])."', accessTrack='No', section='".$sql->escape($data[7])."', module='".$sql->escape($data[8])."', moduleAction='".$sql->escape($data[9])."'";
			}
			else
			{
				$queryS = "insert into site_access_details set licenceID='".$sql->escape($resultLic['licenceID'])."', domainName='".$sql->escape($domainname)."', licenceKey='".$licensekey."', accessStatus='License Expired', accessData='License Expired', prevaccessData='".$sql->escape($prevaccessData)."', accessedPath='".$sql->escape($serverpathtoLic)."', accessTime=now(), accessIP='Old', accessTrack='No', section='Old', module='Old', moduleAction='Old'";
			}
			$sql->Insert("$queryS");
			return $msg;
		}
	}
}
/**** End Expiry Check ****/

/************************** End New Functions *************************/

/**************************** License Check For Old App Engine ***************************/

//Function To Create/Verify License Old
function verifyLicense($domainip,$domainname,$hostname,$hdetails,$licensekey,$serverpathtoLic,$fileContent,$create) 
{
	global $sql;
	$today = date("Y-m-d H:i:s");
	$licensekey = base64_encode($licensekey);
	if($create!=1)
	{
		$fileContentDec = base64_decode($fileContent);
		$dataToLic 		= explode("!~#!",$fileContentDec);
		$dataEncrypted 	= $dataToLic[0];
		$publickeyEncF 	= $dataToLic[1];
		$publickeyF		= base64_decode($publickeyEncF);
		$signature 		= $dataToLic[2];
		$dailycheck		= $dataToLic[3];
		$mdailycheck	= $dataToLic[4];
	}	

	$hardwareaddr	= getHardwareaddr($hdetails,$domainip);	
	if($hardwareaddr=="")
	{	
		$msg	= "";
		$queryS = "insert into site_access_details set licenceID='0', domainName='".$sql->escape($domainname)."', licenceKey='".$licensekey."', accessStatus='MacAddress Not Valid', accessData='MacAddress Not Valid', accessedPath='".$sql->escape($serverpathtoLic)."', accessTime=now(), accessIP='Old', accessTrack='No', section='Old', module='Old', moduleAction='Old'";
		$sql->Insert("$queryS");
		return $msg;	
	}		
		
	$queryLic = "select licenceID as licenceID, customerID as customerID, domainName as domainName, domainIP as domainIP, domainPrivateIP as domainPrivateIP, domainPublicIP as domainPublicIP, licenceKey as licenceKey, hardwareAddr as hardwareAddr, serverPath as serverPath, commonPath as commonPath, hostName as hostName, customerPrivateKey as customerPrivateKey, customerPublicKey as customerPublicKey, createDate as createDate, expiryDate as expiryDate, expiry as expiry, packageKey as packageKey, reqCount as reqCount, domainstatus as domainstatus, domainTypeDev as domainTypeDev, multiPackage as multiPackage, loadBalancer as loadBalancer from site_licences where licenceKey='".$sql->escape($licensekey)."' and domainName='".$sql->escape($domainname)."' AND domainstatus!='full blocked'";
	$sql->QueryRow("$queryLic");
	$resultLic = $sql->data;
	if($resultLic!="")
	{
		$dailydate		= time();
		$domainstatus	= $resultLic['domainstatus'];
		$dailyinfo		= $dailydate."~!".$domainstatus;
		$new			= 0;
		$prevaccessData	= $resultLic['domainName'].",".$resultLic['hostName'].",".$resultLic['domainIP'].",".$resultLic['serverPath'].",".$resultLic['hardwareAddr'];
		$msg			= expiryCheckCommon($resultLic,$today,$data,$domainname,$licensekey,$prevaccessData,$serverpathtoLic,$new,$sql);
		if($msg==3)
		{
			return $msg;
		}
		
		//Select information from customer table
		$queryCustomer = "select customerID as customerID, customerFirstName as customerFirstName, customerLastName as customerLastName, customerEmailID as customerEmailID, customerPhone as customerPhone, customerAddress1 as customerAddress1, customerAddress2 as customerAddress2, customerCity as customerCity, stateID as customerState, countryID as customerCountry from customer_info where customerID='".$sql->escape($resultLic['customerID'])."'";  
		$sql->QueryRow("$queryCustomer");
		$resultCustomer = $sql->data;

		$reqcount	= $resultLic['reqCount'];
		$reqcount++;
		
		$queryl = "update site_licences set reqCount='".$sql->escape($reqcount)."' "; 
		
		$serverPathAllowed	= $resultLic['serverPath'];
		if($serverPathAllowed!="")
		{
			$serverPathArray	= explode(",",$serverPathAllowed);
			$serverPathCount	= count($serverPathArray);
		}
		else
		{
			$serverPathCount 	= 0;
		}
		
		if( ($resultLic['domainTypeDev']=="Live") || ($resultLic['domainTypeDev']=="Shared") )
		{
			if($serverPathCount>0)
			{
				if(!in_array($serverpathtoLic,$serverPathArray))
				{
					$serverPath	= $serverPathAllowed.",".$serverpathtoLic;
					$newpath	= 1;
				}
				else
				{
					$serverPath	= $serverPathAllowed;
				}
			}
			else
			{
				$serverPath	= $serverpathtoLic;
			}
		}
		else
		{
			if($serverPathCount>0)
			{
				$serverPath	= $serverPathAllowed;
			}
			else
			{
				$serverPath	= $serverpathtoLic;
			}
		}
		if($resultLic['commonPath']=="")
		{
			$commonPath	= $serverpathtoLic;
		}
		else
		{
			$commonPath	= $resultLic['commonPath'];
		}
		if($resultLic['domainIP']=="")
		{
			$commonDomainIP	= $domainip;
		}
		else
		{
			$commonDomainIP	= $resultLic['domainIP'];
		}
		
		$publickeyEnc = trim($resultLic['customerPublicKey']);
		$publickey = base64_decode($publickeyEnc);
		$privatekeyEnc = trim($resultLic['customerPrivateKey']);
		$privatekey = base64_decode($privatekeyEnc);
		if( ($resultLic['domainTypeDev']=="Shared") || ($resultLic['loadBalancer']=="Yes") )
		{
			if($resultLic['hostName']!="") 
			{	$hostname	= $resultLic['hostName'];	} 
			if($resultLic['domainIP']!="") 
			{	$commonDomainIP	= $resultLic['domainIP'];	}
		}
		if($resultLic['loadBalancer']=="Yes")
		{
			if($resultLic['hardwareAddr']!="") 
			{	$hardwareaddr	= $resultLic['hardwareAddr'];	}	
		}
		$datatosign = trim($resultLic['domainName'])."~".trim($hostname)."~".trim($hardwareaddr)."~".trim($commonDomainIP)."~".trim($commonPath)."~".trim($resultLic['licenceKey'])."~".trim($resultCustomer['customerFirstName'])."~".trim($resultCustomer['customerLastName'])."~".trim($resultCustomer['customerEmailID'])."~".trim($resultLic['createDate'])."~".trim($publickey);
		
		$accessData	="";
		if(($create!=1) && ($fileContentDec!=""))
		{
			$verified = openssl_verify($datatosign, $signature, $publickey, OPENSSL_ALGO_SHA1);
			if ($verified == 1) 
			{
				$msg = 1;
			} 
			else
			{
				$msg = 2;
				$accessData	= $accessData."Bad Signature, ";
			}
			
			openssl_private_decrypt($dataEncrypted, $dataDecrypted, $privatekey);
			$dataForVerify = explode("~",$dataDecrypted);
			if( ($resultLic['domainTypeDev']!="Shared") && ($resultLic['loadBalancer']!="Yes") )
			{
				if((trim($resultLic['hostName']) == trim($dataForVerify[1])) && (trim($hostname) == trim($dataForVerify[1])))
				{
					$msgh = 1;
				}
				else
				{
					$msgh		= 2;
					$accessData	= $accessData."hostname, ";
				}
				
				$ipArray		= explode(".",$domainip);
				$ipArraySub		= $ipArray[0];
				$ipTestArray	= array("192","172","10");
				$domainPrivateIP	= $resultLic['domainPrivateIP'];
				$domainPublicIP		= $resultLic['domainPublicIP'];
				if(in_array($ipArraySub, $ipTestArray))
				{
					if($resultLic['domainPrivateIP']!="")
					{
						if((ip2long($resultLic['domainPrivateIP']))==(ip2long($domainip)))
						{
							$msgip = 1;
							$domainPrivateIP	=	$resultLic['domainPrivateIP'];
						}
						else
						{
							$msgip		= 2;
							$accessData	= $accessData."domainPrivateIP, ";
							$domainPrivateIP	=	$domainip;
						}
					}
					else
					{
						$domainPrivateIP	=	$domainip;
						$msgip = 1;
					}
				}
				else
				{
					if($resultLic['domainPublicIP']!="")
					{
						if((ip2long($resultLic['domainPublicIP']))==(ip2long($domainip)))
						{
							$msgip = 1;
							$domainPublicIP	=	$resultLic['domainPublicIP'];
						}
						else
						{
							$msgip		= 2;
							$accessData	= $accessData."domainPublicIP, ";
							$domainPublicIP	=	$domainip;
						}
					}
					else
					{
						$domainPublicIP	=	$domainip;
						$msgip = 1;
					}
				}
				$commonIP	= ip2long($resultLic['domainIP']);
				$domPrIP	= ip2long($domainPrivateIP);
				$domPubIP	= ip2long($domainPublicIP);
				$prpubArray	= array($domPrIP,$domPubIP);
				if((ip2long($resultLic['domainIP'])) == (ip2long($dataForVerify[3])))
				{		
					if(in_array($commonIP, $prpubArray)) 
					{
						$msgip = 1;
					}
					else
					{
						$msgip		= 2;
						$accessData	= $accessData."domainIP, ";
						if($domainPrivateIP!="")
						{
							$commonDomainIP	= $domainPrivateIP;
						}
						else 
						{
							$commonDomainIP	= $domainPublicIP;
						}
					}
				}
				else
				{
					$msgip		= 2;
					$accessData	= $accessData."domainIP, "; 
					if(in_array($commonIP, $prpubArray)) 
					{
						$commonDomainIP	= $resultLic['domainIP'];
					}
					else
					{
						if($domainPrivateIP!="")
						{
							$commonDomainIP	= $domainPrivateIP;
						}
						else 
						{
							$commonDomainIP	= $domainPublicIP;
						}
					}
				}
			}
			if($resultLic['loadBalancer']!="Yes")
			{
				if((trim($resultLic['hardwareAddr']) == trim($dataForVerify[2])) && (trim($hardwareaddr) == trim($dataForVerify[2])))
				{
						
					$msghw = 1;
				}
				else
				{
					$msghw		= 2;
					$accessData	= $accessData."hardwareAddr, ";
				}
			}
			if((trim($resultLic['domainName']) == trim($dataForVerify[0])) && (trim($domainname) == trim($dataForVerify[0])))
			{						
				$msgd = 1;
			}
			else
			{
				$msgd = 2;
				$accessData	= $accessData."domainName, ";
				$accessStat	= "Unauthorized";
			}
			if( ($resultLic['domainTypeDev']=="Live") || ($resultLic['domainTypeDev']=="Shared") )
			{
				if((in_array(trim($serverpathtoLic),$serverPathArray)) && (trim($resultLic['commonPath']) == trim($dataForVerify[4])))
				{
					$msgs = 1;
				}
				else
				{
					$msgs = 2;
					$accessData	= $accessData."serverPath, ";
				}
			}
			else
			{
				if(trim($resultLic['commonPath']) == trim($dataForVerify[4]))
				{
					$msgs = 1;
				}
				else
				{
					$msgs = 2;
					$accessData	= $accessData."serverPath, ";
				}
			}
				
			if((trim($resultLic['licenceKey']) == trim($dataForVerify[5])) && (trim($licensekey) == trim($dataForVerify[5])))
			{
				$msgl = 1;
			}
			else
			{
				$msgl = 2;
				$accessData	= $accessData."licenceKey, ";
				$accessStat	= "Unauthorized";
			}
		}
		else
		{
			$accessData	= $accessData."Install Action, ";
		}
		$accessData	= rtrim($accessData, ', ');
		if ( ($msg == 2) || ($msgh == 2) || ($msghw == 2) || ($msgip == 2) || ($msgd == 2) || ($msgs == 2) || ($msgl == 2) || ($create == 1) ) 
		{	
			if( ($resultLic['domainTypeDev']=="Live") || ($resultLic['domainTypeDev']=="Shared") )
			{
				if(($publickey=="")|| ($privatekey==""))
				{
					//Create Private and Publickey
					$res=openssl_pkey_new(array('digest_alg' => 'sha1', 'private_key_type' => OPENSSL_KEYTYPE_RSA, 'private_key_bits' => 4096));
				
					// Get private key
					openssl_pkey_export($res, $privatekey);
						
					// Get public key
					$publickey=openssl_pkey_get_details($res);
					$publickey=$publickey["key"];
						
					$privatekeyEnc = base64_encode($privatekey);
					$publickeyEnc = base64_encode($publickey);
			
					//Update to License table
					$queryl = $queryl.", hardwareAddr='".$sql->escape($hardwareaddr)."', hostName='".$sql->escape($hostname)."', customerPrivateKey='".$sql->escape($privatekeyEnc)."', customerPublicKey='".$sql->escape($publickeyEnc)."', serverPath='".$sql->escape($serverPath)."', domainIP='".$sql->escape($commonDomainIP)."' ";
				}
				else
				{
					if($newpath==1)
					{
						//Update to License table
						$queryl = $queryl.", hardwareAddr='".$sql->escape($hardwareaddr)."', hostName='".$sql->escape($hostname)."', serverPath='".$sql->escape($serverPath)."', domainIP='".$sql->escape($commonDomainIP)."' ";
					}
					else
					{
						//Create Private and Publickey
						$res=openssl_pkey_new(array('digest_alg' => 'sha1', 'private_key_type' => OPENSSL_KEYTYPE_RSA, 'private_key_bits' => 4096));
					
						// Get private key
						openssl_pkey_export($res, $privatekey);
							
						// Get public key
						$publickey=openssl_pkey_get_details($res);
						$publickey=$publickey["key"];
							
						$privatekeyEnc = base64_encode($privatekey);
						$publickeyEnc = base64_encode($publickey);
				
						//Update to License table
						$queryl = $queryl.", hardwareAddr='".$sql->escape($hardwareaddr)."', hostName='".$sql->escape($hostname)."', customerPrivateKey='".$sql->escape($privatekeyEnc)."', customerPublicKey='".$sql->escape($publickeyEnc)."', serverPath='".$sql->escape($serverPath)."', domainIP='".$sql->escape($commonDomainIP)."' ";
					}
				}
								
				if($resultLic['commonPath']=="")
				{
					$queryl = $queryl.", commonPath='".$sql->escape($serverpathtoLic)."' ";
				}
				
				if($domainPrivateIP!="")
				{
					$queryl = $queryl.", domainPrivateIP='".$sql->escape($domainPrivateIP)."' ";
				}
				
				if($domainPublicIP!="")
				{
					$queryl = $queryl.", domainPublicIP='".$sql->escape($domainPublicIP)."' ";
				}
			}
			else
			{	
				if(($publickey=="")|| ($privatekey==""))
				{
					//Create Private and Publickey
					$res=openssl_pkey_new(array('digest_alg' => 'sha1', 'private_key_type' => OPENSSL_KEYTYPE_RSA, 'private_key_bits' => 4096));
				
					// Get private key
					openssl_pkey_export($res, $privatekey);
						
					// Get public key
					$publickey=openssl_pkey_get_details($res);
					$publickey=$publickey["key"];
						
					$privatekeyEnc = base64_encode($privatekey);
					$publickeyEnc = base64_encode($publickey);
			
					//Update to License table
					$queryl = $queryl.", hardwareAddr='".$sql->escape($hardwareaddr)."', hostName='".$sql->escape($hostname)."', customerPrivateKey='".$sql->escape($privatekeyEnc)."', customerPublicKey='".$sql->escape($publickeyEnc)."', serverPath='".$sql->escape($serverPath)."', domainIP='".$sql->escape($commonDomainIP)."' ";
				}
				else
				{
					//Update to License table
					$queryl = $queryl.", hardwareAddr='".$sql->escape($hardwareaddr)."', hostName='".$sql->escape($hostname)."', serverPath='".$sql->escape($serverPath)."', domainIP='".$sql->escape($commonDomainIP)."'";
				}
				if($resultLic['commonPath']=="")
				{
					$queryl = $queryl.", commonPath='".$sql->escape($serverpathtoLic)."' ";
				}
				if($domainPrivateIP!="")
				{
					$queryl = $queryl.", domainPrivateIP='".$sql->escape($domainPrivateIP)."' ";
				}
				
				if($domainPublicIP!="")
				{
					$queryl = $queryl.", domainPublicIP='".$sql->escape($domainPublicIP)."' ";
				}
			} 		
			
			$datatoencrypt = trim($resultLic['domainName'])."~".trim($hostname)."~".trim($hardwareaddr)."~".trim($commonDomainIP)."~".trim($commonPath)."~".trim($resultLic['licenceKey'])."~".trim($resultCustomer['customerFirstName'])."~".trim($resultCustomer['customerLastName'])."~".trim($resultCustomer['customerEmailID'])."~".trim($resultLic['createDate']);
			
			//$length=strlen($datatoencrypt);
			
			$datatosign = trim($resultLic['domainName'])."~".trim($hostname)."~".trim($hardwareaddr)."~".trim($commonDomainIP)."~".trim($commonPath)."~".trim($resultLic['licenceKey'])."~".trim($resultCustomer['customerFirstName'])."~".trim($resultCustomer['customerLastName'])."~".trim($resultCustomer['customerEmailID'])."~".trim($resultLic['createDate'])."~".trim($publickey);
			
			//Encrypt data with publickey
			openssl_public_encrypt($datatoencrypt, $crypttext, $publickey);
			//Create signature with privatekey
			openssl_sign($datatosign, $signature, $privatekey, OPENSSL_ALGO_SHA1);	
			//Install
			if($accessStat!="")
			{
				$accessStatus	= "Install, ".$accessStat;
			}
			else
			{
				$accessStatus	= "Install";
			}

			$queryS = "insert into site_access_details set licenceID='".$sql->escape($resultLic['licenceID'])."', domainName='".$sql->escape($domainname)."', licenceKey='".$licensekey."', accessStatus='".$sql->escape($accessStatus)."', accessData='".$sql->escape($accessData)."', prevaccessData='".$sql->escape($prevaccessData)."', accessedPath='".$sql->escape($serverpathtoLic)."', accessTime=now(), accessIP='', accessTrack='No', section='Old', module='Old', moduleAction='Old'";
			$sql->Insert("$queryS");

			
			$mdailycheck	= encodeDmhostip($dailyinfo);
			$dataToLicense	= $crypttext."!~#!".$publickeyEnc."!~#!".$signature."!~#!".$mdailycheck."!~#!".$mdailycheck;

			//$dataToLicense = $crypttext . "!~#!" . $publickeyEnc . "!~#!". $signature;
			$dataToLicEnc = base64_encode($dataToLicense);
			$msg = $dataToLicEnc;
		} 
		$queryl = $queryl." where licenceKey='".$sql->escape($licensekey)."' and domainName='".$sql->escape($domainname)."'";
		$sql->Update($queryl);
	}
	else 
	{
		$msg = "";
		$queryS = "insert into site_access_details set licenceID='0', domainName='".$sql->escape($domainname)."', licenceKey='".$licensekey."', accessStatus='License Not Valid', accessData='License Not Valid', accessedPath='".$sql->escape($serverpathtoLic)."', accessTime=now(), accessIP='Old', accessTrack='No', section='Old', module='Old', moduleAction='Old'";
		$sql->Insert("$queryS");
	}
	return $msg;
}

/**************************** License Check For Old App Engine ***************************/


/**************************** License Check For New App Engine ***************************/

/**** Verify License Common Function ****/
function licenseCheckCommon($data,$licensekey,$resultLic,$hardwareaddr,$dataEncrypted,$publickeyEncF,$publickeyF,$signature,$dailycheck,$mdailycheck,$today,$reqcount,$sql)
{
	$dailydate		= time();
	$domainstatus	= $resultLic['domainstatus'];
	$dailyinfo		= $dailydate."~!".$domainstatus;
	$new			= 1;
	$prevaccessData		= $resultLic['domainName'].",".$resultLic['hostName'].",".$resultLic['domainIP'].",".$resultLic['serverPath'].",".$resultLic['hardwareAddr'];
	$msg			= expiryCheckCommon($resultLic,$today,$data,$domainname,$licensekey,$prevaccessData,$serverpathtoLic,$new,$sql);
	$hosttopass	= $data[2];
	if($msg==3)
	{
		$msgtopass	= ""."#$#".$msg;
		return $msgtopass;
	}
		//Select information from customer table
		$queryCustomer = "select customerID as customerID, customerFirstName as customerFirstName, customerLastName as customerLastName, customerEmailID as customerEmailID, customerPhone as customerPhone, customerAddress1 as customerAddress1, customerAddress2 as customerAddress2, customerCity as customerCity, stateID as customerState, countryID  as customerCountry from customer_info where customerID='".$sql->escape($resultLic['customerID'])."'";  
		$sql->QueryRow("$queryCustomer");
		$resultCustomer 	= $sql->data;
		$reqcount			= $resultLic['reqCount'];
		$reqcount++;
		$queryl 			= "update site_licences set reqCount='".$sql->escape($reqcount)."'";
		$serverPathAllowed	= $resultLic['serverPath'];
		if($serverPathAllowed!="")
		{
			$serverPathArray	= explode(",",$serverPathAllowed);
			$serverPathCount	= count($serverPathArray);
		}
		else
		{
			$serverPathCount 	= 0;
		}
		
		if( ($resultLic['domainTypeDev']=="Live") || ($resultLic['domainTypeDev']=="Shared") )
		{
			if($serverPathCount>0)
			{
				if(!in_array($data[5],$serverPathArray))
				{
					$serverPath	= $serverPathAllowed.",".$data[5];
					$newpath	= 1;
				}
				else
				{
					$serverPath	= $serverPathAllowed;
				}
			}
			else
			{
				$serverPath	= $data[5];
			}
		}
		else
		{
			if($serverPathCount>0)
			{
				$serverPath	= $serverPathAllowed;
			}
			else
			{
				$serverPath	= $data[5];
			}
		}
		
		if($resultLic['commonPath']=="")
		{
			$commonPath	= $data[5];
		}
		else
		{
			$commonPath	= $resultLic['commonPath'];
		}
		if($resultLic['domainIP']=="")
		{
			$commonDomainIP	= $data[0];
		}
		else
		{
			$commonDomainIP	= $resultLic['domainIP'];
		}
		
		$publickeyEnc = trim($resultLic['customerPublicKey']);
		$publickey = base64_decode($publickeyEnc);
		$privatekeyEnc = trim($resultLic['customerPrivateKey']);
		$privatekey = base64_decode($privatekeyEnc);
		if($data[11]=="")
		{
			$accessData	="";
			
			if($data[6]!="")
			{		
				if( ($resultLic['domainTypeDev']=="Shared") || ($resultLic['loadBalancer']=="Yes") )
				{
					if($resultLic['hostName']!="") 
					{	
						$data[2]	= $resultLic['hostName'];	
					} 
					if($resultLic['domainIP']!="") 
					{	$commonDomainIP	= $resultLic['domainIP'];	}
				}
				if($resultLic['loadBalancer']=="Yes")
				{
					if($resultLic['hardwareAddr']!="") 
					{	$hardwareaddr	= $resultLic['hardwareAddr'];	}	
				}
				$datatosign = trim($resultLic['domainName'])."~".trim($data[2])."~".trim($hardwareaddr)."~".trim($commonDomainIP)."~".trim($commonPath)."~".trim($resultLic['licenceKey'])."~".trim($resultCustomer['customerFirstName'])."~".trim($resultCustomer['customerLastName'])."~".trim($resultCustomer['customerEmailID'])."~".trim($resultLic['createDate'])."~".trim($publickey);	
				$verified = openssl_verify($datatosign, $signature, $publickey, OPENSSL_ALGO_SHA1);	
				if ($verified == 1) 
				{
					$msg = 1;
				} 
				else
				{
					$msg = 2;
					$accessData	= $accessData."Bad Signature, ";
				}
				openssl_private_decrypt($dataEncrypted, $dataDecrypted, $privatekey);
				$dataForVerify = explode("~",$dataDecrypted);
				if( ($resultLic['domainTypeDev']!="Shared") && ($resultLic['loadBalancer']!="Yes") )
				{
					if((trim($resultLic['hostName']) == trim($dataForVerify[1])) && (trim($data[2]) == trim($dataForVerify[1])))
					{
						$msgh = 1;
					}
					else
					{
						$msgh		= 2;
						$accessData	= $accessData."hostname, ";
					}

					$ipArray		= explode(".",$data[0]);
					$ipArraySub		= $ipArray[0];
					$ipTestArray	= array("192","172","10");
					$domainPrivateIP	= $resultLic['domainPrivateIP'];
					$domainPublicIP		= $resultLic['domainPublicIP'];
					if(in_array($ipArraySub, $ipTestArray))
					{
						if($resultLic['domainPrivateIP']!="")
						{
							if((ip2long($resultLic['domainPrivateIP']))==(ip2long($data[0])))
							{
								$msgip = 1;
								$domainPrivateIP	=	$resultLic['domainPrivateIP'];
							}
							else
							{
								$msgip		= 2;
								$accessData	= $accessData."domainPrivateIP, ";
								$domainPrivateIP	=	$data[0];
							}
						}
						else
						{
							$domainPrivateIP	=	$data[0];
							$msgip = 1;
						}
					}
					else
					{
						if($resultLic['domainPublicIP']!="")
						{
							if((ip2long($resultLic['domainPublicIP']))==(ip2long($data[0])))
							{
								$msgip = 1;
								$domainPublicIP	=	$resultLic['domainPublicIP'];
							}
							else
							{
								$msgip		= 2;
								$accessData	= $accessData."domainPublicIP, ";
								$domainPublicIP	=	$data[0];
							}
						}
						else
						{
							$domainPublicIP	=	$data[0];
							$msgip = 1;
						}
					}
					$commonIP	= ip2long($resultLic['domainIP']);
					$domPrIP	= ip2long($domainPrivateIP);
					$domPubIP	= ip2long($domainPublicIP);
					$prpubArray	= array($domPrIP,$domPubIP);
					if((ip2long($resultLic['domainIP'])) == (ip2long($dataForVerify[3])))
					{		
						if(in_array($commonIP, $prpubArray)) 
						{
							$msgip = 1;
						}
						else
						{
							$msgip		= 2;
							$accessData	= $accessData."domainIP, ";
							if($domainPrivateIP!="")
							{
								$commonDomainIP	= $domainPrivateIP;
							}
							else 
							{
								$commonDomainIP	= $domainPublicIP;
							}
						}
					}
					else
					{
						$msgip		= 2;
						$accessData	= $accessData."domainIP, "; 
						if(in_array($commonIP, $prpubArray)) 
						{
							$commonDomainIP	= $resultLic['domainIP'];
						}
						else
						{
							if($domainPrivateIP!="")
							{
								$commonDomainIP	= $domainPrivateIP;
							}
							else 
							{
								$commonDomainIP	= $domainPublicIP;
							}
						}
					}
				}
				if($resultLic['loadBalancer']!="Yes")
				{
					if((trim($resultLic['hardwareAddr']) == trim($dataForVerify[2])) && (trim($hardwareaddr) == trim($dataForVerify[2])))
					{
							
						$msghw = 1;
					}
					else
					{
						$msghw		= 2;
						$accessData	= $accessData."hardwareAddr, ";
					}
				}	
				if((trim($resultLic['domainName']) == trim($dataForVerify[0])) && (trim($data[1]) == trim($dataForVerify[0])))
				{						
					$msgd = 1;
				}
				else
				{
					$msgd = 2;
					$accessData	= $accessData."domainName, ";
					$accessStat	= "Unauthorized";
				}
				
				if( ($resultLic['domainTypeDev']=="Live") || ($resultLic['domainTypeDev']=="Shared") )
				{
					if((in_array(trim($data[5]),$serverPathArray)) && (trim($resultLic['commonPath']) == trim($dataForVerify[4])))
					{
						$msgs = 1;
					}
					else
					{
						$msgs = 2;
						$accessData	= $accessData."serverPath, ";
					}
				}
				else
				{
					if(trim($resultLic['commonPath']) == trim($dataForVerify[4]))
					{
						$msgs = 1;
					}
					else
					{
						$msgs = 2;
						$accessData	= $accessData."serverPath, ";
					}	
				}
				
				if((trim($resultLic['licenceKey']) == trim($dataForVerify[5])) && (trim($licensekey) == trim($dataForVerify[5])))
				{
					$msgl = 1;
				}
				else
				{
					$msgl = 2;
					$accessData	= $accessData."licenceKey, ";
					$accessStat	= "Unauthorized";
				}
			}	
			else
			{
				$accessData	= $accessData."Install Action, ";
			}
			$accessData	= rtrim($accessData, ', ');
			
			if ( ($msg == 2) || ($msgh == 2) || ($msghw == 2) || ($msgip == 2) || ($msgd == 2) || ($msgs == 2) || ($msgl == 2) || ($data[6]=="")) 
			{		
				if( ($resultLic['domainTypeDev']=="Live") || ($resultLic['domainTypeDev']=="Shared") )
				{	
					if(($publickey=="")|| ($privatekey==""))
					{
						//Create Private and Publickey
						$res=openssl_pkey_new(array('digest_alg' => 'sha1', 'private_key_type' => OPENSSL_KEYTYPE_RSA, 'private_key_bits' => 4096));
					
						// Get private key
						openssl_pkey_export($res, $privatekey);
							
						// Get public key
						$publickey=openssl_pkey_get_details($res);
						$publickey=$publickey["key"];
							
						$privatekeyEnc = base64_encode($privatekey);
						$publickeyEnc = base64_encode($publickey);
				
						//Update to License table
						$queryl = $queryl.", hardwareAddr='".$sql->escape($hardwareaddr)."', hostName='".$sql->escape($data[2])."', customerPrivateKey='".$sql->escape($privatekeyEnc)."', customerPublicKey='".$sql->escape($publickeyEnc)."', serverPath='".$sql->escape($serverPath)."', domainIP='".$sql->escape($commonDomainIP)."' ";
					}
					else
					{
						if($newpath==1)
						{
							//Update to License table
							$queryl = $queryl.", hardwareAddr='".$sql->escape($hardwareaddr)."', hostName='".$sql->escape($data[2])."', serverPath='".$sql->escape($serverPath)."', domainIP='".$sql->escape($commonDomainIP)."' ";
						}
						else
						{
							//Create Private and Publickey
							$res=openssl_pkey_new(array('digest_alg' => 'sha1', 'private_key_type' => OPENSSL_KEYTYPE_RSA, 'private_key_bits' => 4096));
						
							// Get private key
							openssl_pkey_export($res, $privatekey);
								
							// Get public key
							$publickey=openssl_pkey_get_details($res);
							$publickey=$publickey["key"];
								
							$privatekeyEnc = base64_encode($privatekey);
							$publickeyEnc = base64_encode($publickey);
					
							//Update to License table
							$queryl = $queryl.", hardwareAddr='".$sql->escape($hardwareaddr)."', hostName='".$sql->escape($data[2])."', customerPrivateKey='".$sql->escape($privatekeyEnc)."', customerPublicKey='".$sql->escape($publickeyEnc)."', serverPath='".$sql->escape($serverPath)."', domainIP='".$sql->escape($commonDomainIP)."' ";
						}
					}
					if($resultLic['commonPath']=="")
					{
						$queryl = $queryl.", commonPath='".$sql->escape($data[5])."' ";
					}
					if($domainPrivateIP!="")
					{
						$queryl = $queryl.", domainPrivateIP='".$sql->escape($domainPrivateIP)."' ";
					}
					
					if($domainPublicIP!="")
					{
						$queryl = $queryl.", domainPublicIP='".$sql->escape($domainPublicIP)."' ";
					}
				}
				else
				{	
					if(($publickey=="")|| ($privatekey==""))
					{
						//Create Private and Publickey
						$res=openssl_pkey_new(array('digest_alg' => 'sha1', 'private_key_type' => OPENSSL_KEYTYPE_RSA, 'private_key_bits' => 4096));
					
						// Get private key
						openssl_pkey_export($res, $privatekey);
							
						// Get public key
						$publickey=openssl_pkey_get_details($res);
						$publickey=$publickey["key"];
							
						$privatekeyEnc = base64_encode($privatekey);
						$publickeyEnc = base64_encode($publickey);
				
						//Update to License table
						$queryl = $queryl.", hardwareAddr='".$sql->escape($hardwareaddr)."', hostName='".$sql->escape($hostname)."', customerPrivateKey='".$sql->escape($privatekeyEnc)."', customerPublicKey='".$sql->escape($publickeyEnc)."', serverPath='".$sql->escape($serverPath)."', domainIP='".$sql->escape($commonDomainIP)."' ";
					}
					else
					{
						//Update to License table
						$queryl = $queryl.", hardwareAddr='".$sql->escape($hardwareaddr)."', hostName='".$sql->escape($data[2])."', serverPath='".$sql->escape($serverPath)."', domainIP='".$sql->escape($data[0])."' ";
					}
					if($resultLic['commonPath']=="")
					{
						$queryl = $queryl.", commonPath='".$sql->escape($data[5])."' ";
					}
					if($domainPrivateIP!="")
					{
						$queryl = $queryl.", domainPrivateIP='".$sql->escape($domainPrivateIP)."' ";
					}
					
					if($domainPublicIP!="")
					{
						$queryl = $queryl.", domainPublicIP='".$sql->escape($domainPublicIP)."' ";
					}
				} 
				
				$datatoencrypt = trim($resultLic['domainName'])."~".trim($data[2])."~".trim($hardwareaddr)."~".trim($commonDomainIP)."~".trim($commonPath)."~".trim($resultLic['licenceKey'])."~".trim($resultCustomer['customerFirstName'])."~".trim($resultCustomer['customerLastName'])."~".trim($resultCustomer['customerEmailID'])."~".trim($resultLic['createDate']);
								
				$datatosign = trim($resultLic['domainName'])."~".trim($data[2])."~".trim($hardwareaddr)."~".trim($commonDomainIP)."~".trim($commonPath)."~".trim($resultLic['licenceKey'])."~".trim($resultCustomer['customerFirstName'])."~".trim($resultCustomer['customerLastName'])."~".trim($resultCustomer['customerEmailID'])."~".trim($resultLic['createDate'])."~".trim($publickey);
	
				//Encrypt data with publickey
				openssl_public_encrypt($datatoencrypt, $crypttext, $publickey);
				//Create signature with privatekey
				openssl_sign($datatosign, $signature, $privatekey, OPENSSL_ALGO_SHA1);

				//Install
				if($accessStat!="")
				{
					$accessStatus	= "Install, ".$accessStat;
				}
				else
				{
					$accessStatus	= "Install";
				}
				$queryS = "insert into site_access_details set licenceID='".$sql->escape($resultLic['licenceID'])."', domainName='".$sql->escape($data[1])."', licenceKey='".$licensekey."', accessStatus='".$sql->escape($accessStatus)."', accessData='".$sql->escape($accessData)."', prevaccessData='".$sql->escape($prevaccessData)."', accessedPath='".$sql->escape($data[5])."', accessTime=now(), accessIP='".$sql->escape($data[10])."', accessTrack='No', section='".$sql->escape($data[7])."', module='".$sql->escape($data[8])."', moduleAction='".$sql->escape($data[9])."'";
				$sql->Insert("$queryS");
				if($data[7]!=$data[13])
				{
					$dailycheck		= encodeDmhostip($dailyinfo);
					$dataToLicense	= $crypttext."!~#!".$publickeyEnc."!~#!".$signature."!~#!".$dailycheck."!~#!".$mdailycheck;
				}
				else
				{
					$mdailycheck	= encodeDmhostip($dailyinfo);
					$dataToLicense	= $crypttext."!~#!".$publickeyEnc."!~#!".$signature."!~#!".$dailycheck."!~#!".$mdailycheck;
				}
				
				$dataToLicEnc	= base64_encode($dataToLicense);
				$msg			= $dataToLicEnc;					
			}
			else if($data[7]!=$data[13])
			{
				$dailycheck		= encodeDmhostip($dailyinfo);
				$dataToLicense	= $dataEncrypted."!~#!" .$publickeyEnc."!~#!".$signature."!~#!".$dailycheck."!~#!".$mdailycheck;
				$dataToLicEnc	= base64_encode($dataToLicense);
				$msg			= $dataToLicEnc;
			}
			else if($mdailycheck=="")
			{
				$mdailycheck	= encodeDmhostip($dailyinfo);
				$dataToLicense	= $dataEncrypted."!~#!" .$publickeyEnc."!~#!".$signature."!~#!".$dailycheck."!~#!".$mdailycheck;
				$dataToLicEnc	= base64_encode($dataToLicense);
				$msg			= $dataToLicEnc;
			}
		}
		if($data[11]!="")
		{
			$accessData		= $data[12];
			$accessStatus	= $data[11];
			$queryS = "insert into site_access_details set licenceID='".$sql->escape($resultLic['licenceID'])."', domainName='".$sql->escape($data[1])."', licenceKey='".$licensekey."', accessStatus='".$sql->escape($accessStatus)."', accessData='".$sql->escape($accessData)."', prevaccessData='".$sql->escape($prevaccessData)."', accessedPath='".$sql->escape($data[5])."', accessTime=now(), accessIP='".$sql->escape($data[10])."', accessTrack='No', section='".$sql->escape($data[7])."', module='".$sql->escape($data[8])."', moduleAction='".$sql->escape($data[9])."'";
			$sql->Insert("$queryS");
		}			
			$queryc = "select siteaccessID as siteaccessID,licenceID as licenceID, domainName as domainName, accessStatus as accessStatus, accessData as accessData, accessTime as accessTime, accessIP as accessIP, accessTrack as accessTrack from site_access_details where licenceID='".$sql->escape($resultLic['licenceID'])."' and accessStatus!='Success' and accessTrack='No' and section='".$sql->escape($data[7])."'";     
			$sql->Query("$queryc");
			$rowsac = $sql->rows;	
			for ($i=0;$i<$rowsac;$i++) 
			{
				$sql->Fetch($i);
				$resultAccess	= $sql->data;
				$siteaccessID	= $resultAccess['siteaccessID'];
				$licenceID		= $resultAccess['licenceID'];
				$accessData		= $resultAccess['accessData'];
				if((strpos($accessData,'domainname')!==false) || (strpos($accessData,'WrongPlatform')!==false) || (strpos($accessData,'NoCookie')!==false))
				{
					if($accessStatus=='Success')
					{
						$queryU = "update site_access_details set accessTrack='Yes' where siteaccessID='".$sql->escape($siteaccessID)."' and licenceID='".$sql->escape($licenceID)."' and section='".$sql->escape($data[7])."'";
						$sql->Update("$queryU");
					}
					else
					{
						$check	= 5;
					}
				}			
			}
			if($rowsac>=1)
			{
				if($accessStatus=='Success')
				{
					$queryU = "update site_access_details set accessTrack='Yes' where licenceID='".$sql->escape($resultLic['licenceID'])."' and accessStatus!='Success' and section='".$sql->escape($data[7])."'";
					$sql->Update("$queryU");	
				}
				else
				{
					$check	= 6;
				}
			}
		$domaininfo	= $resultLic['domainName']."~!".$hosttopass."~!".$data[0]."~!".$data[5]."~!".$reqcount."~!".$acstat."~!".$rowsac."~!".$check."~!".$resultLic['packageKey']."~!".$resultLic['multiPackage'];
		$queryl = $queryl." where licenceKey='".$sql->escape($licensekey)."' and domainName='".$sql->escape($data[1])."'";
		$sql->Update($queryl);
		$resultreturn	= $domaininfo."#$#".$msg;
		return $resultreturn;
}
/**** End Verify License Common Function ****/


//Function To Verify New License
function verifyLicenseNew($dataToken) 
{
	global $sql;
	$today			= date("Y-m-d H:i:s");
	$datadec		= paramDecode($dataToken);
	$data			= explode("~!~",$datadec);
	$licensekey		= base64_encode($data[4]);
	if($data[11]=="")
	{
		if($data[6]!="")
		{
			$fileContentDec = base64_decode($data[6]);
			$dataToLic		= explode("!~#!",$fileContentDec);
			$dataEncrypted	= $dataToLic[0];
			$publickeyEncF	= $dataToLic[1];
			$publickeyF		= base64_decode($publickeyEncF);
			$signature		= $dataToLic[2];
			$dailycheck		= $dataToLic[3];
			$mdailycheck	= $dataToLic[4];
		}
		$hardwareaddr	= getHardwareaddr($data[3],$data[0]);	
		if($hardwareaddr=="")
		{
			$msg	= "";
			$queryS = "insert into site_access_details set licenceID='0', domainName='".$sql->escape($data[1])."', licenceKey='".$licensekey."', accessStatus='MacAddress Not Valid', accessData='MacAddress Not Valid', accessedPath='".$sql->escape($data[5])."', accessTime=now(), accessIP='".$sql->escape($data[10])."', accessTrack='No', section='".$sql->escape($data[7])."', module='".$sql->escape($data[8])."', moduleAction='".$sql->escape($data[9])."'";
			$sql->Insert("$queryS");
			$msgtopass	= applyrandomKey('',$msg); 
			return $msgtopass;
		}	
	}
	$queryLic = "select licenceID as licenceID, customerID as customerID, domainName as domainName, domainIP as domainIP, domainPrivateIP as domainPrivateIP, domainPublicIP as domainPublicIP, licenceKey as licenceKey, hardwareAddr as hardwareAddr, serverPath as serverPath, commonPath as commonPath, hostName as hostName, customerPrivateKey as customerPrivateKey, customerPublicKey as customerPublicKey, createDate as createDate, expiryDate as expiryDate, expiry as expiry, packageKey as packageKey, reqCount as reqCount, domainstatus as domainstatus, domainTypeDev as domainTypeDev, multiPackage as multiPackage, loadBalancer as loadBalancer from site_licences where licenceKey='".$sql->escape($licensekey)."' and domainName='".$sql->escape($data[1])."' AND (domainstatus!='full blocked' AND domainstatus!='".$sql->escape($data[7])." blocked')";
	$sql->QueryRow("$queryLic");
	$resultLic	= $sql->data;
	$reqcount	= 0;
	if($resultLic!="")
	{
		$resultreturn	= licenseCheckCommon($data,$licensekey,$resultLic,$hardwareaddr,$dataEncrypted,$publickeyEncF,$publickeyF,$signature,$dailycheck,$mdailycheck,$today,$reqcount,$sql);
		$result			= explode("#$#",$resultreturn);
		$domaininfo		= $result[0];
		$msg			= $result[1];	
	}
	else 
	{
		if($data[7]!=$data[13])
		{
			$queryLic = "select licenceID as licenceID, customerID as customerID, domainName as domainName, domainIP as domainIP, domainPrivateIP as domainPrivateIP, domainPublicIP as domainPublicIP, licenceKey as licenceKey, hardwareAddr as hardwareAddr, serverPath as serverPath, commonPath as commonPath, hostName as hostName, customerPrivateKey as customerPrivateKey, customerPublicKey as customerPublicKey, createDate as createDate, expiryDate as expiryDate, expiry as expiry, packageKey as packageKey, reqCount as reqCount, domainstatus as domainstatus, domainTypeDev as domainTypeDev, multiPackage as multiPackage, loadBalancer as loadBalancer from site_licences where licenceKey='".$sql->escape($licensekey)."' and multipleDomainFrontend='Yes' and (domainstatus!='full blocked' AND domainstatus!='".$sql->escape($data[7])." blocked')";
			$sql->QueryRow("$queryLic");
			$resultLic	= $sql->data;
			if($resultLic!="")
			{
				$resultreturn	= licenseCheckCommon($data,$licensekey,$resultLic,$hardwareaddr,$dataEncrypted,$publickeyEncF,$publickeyF,$signature,$dailycheck,$mdailycheck,$today,$reqcount,$sql);
				$result			= explode("#$#",$resultreturn);
				$domaininfo		= $result[0];
				$msg			= $result[1];
			}	
			else
			{
				$msg = "";
				$queryS = "insert into site_access_details set licenceID='".$sql->escape($resultLic['licenceID'])."', domainName='".$sql->escape($data[1])."', licenceKey='".$licensekey."', accessStatus='License Not Valid', accessData='License Not Valid', accessedPath='".$sql->escape($data[5])."', accessTime=now(), accessIP='".$sql->escape($data[10])."', accessTrack='No', section='".$sql->escape($data[7])."', module='".$sql->escape($data[8])."', moduleAction='".$sql->escape($data[9])."'";
				$sql->Insert("$queryS");
			}
		}
		else
		{
			$msg = "";
			$queryS = "insert into site_access_details set licenceID='".$sql->escape($resultLic['licenceID'])."', domainName='".$sql->escape($data[1])."', licenceKey='".$licensekey."', accessStatus='License Not Valid', accessData='License Not Valid', accessedPath='".$sql->escape($data[5])."', accessTime=now(), accessIP='".$sql->escape($data[10])."', accessTrack='No', section='".$sql->escape($data[7])."', module='".$sql->escape($data[8])."', moduleAction='".$sql->escape($data[9])."'";
			$sql->Insert("$queryS");
		}
	}
	$msgtopass	= applyrandomKey($domaininfo,$msg); 				
	return $msgtopass;
}
?>