<?
/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/

//
//$Id: Database.class.php,v 1.0 2011/06/14 20:52:11
//Database Class - Database Class of License for Oorjit Deal System
//

require_once("config.php");

class MySQL_class 
{ 
	var $db, $id, $result, $rows, $data, $a_rows;
    var $user, $pass, $host,$port;
	
	function Setup ($user, $pass, $host,$port) 
	{
        $this->user = $user;
        $this->pass = $pass;
		$this->host=$host;
		$this->port=$port;
    }
	
	function Create ($db) 
	{
        if (!$this->user) {
            $this->user = DB_USER;
        }
        if (!$this->pass) {
            $this->pass = DB_PASSWORD;
        }
		if (!$this->host) {
            $this->host = DB_HOST;
        }

 		$this->db ="$db";
        $this->id = @mysqli_connect($this->host, $this->user, $this->pass,$db) or
            MySQL_ErrorMsg("Unable to connect to MySQL server: $this->host : '$SERVER_NAME'");
        $this->selectdb($db);
    }
	
	function SelectDB ($db) {
        @mysqli_select_db($this->id,$db) or
            MySQL_ErrorMsg ("Unable to select database: $db");
    }

    # Use this function is the query will return multiple rows.  Use the Fetch
    # routine to loop through those rows.
    function Query ($query) {
        $this->result = @mysqli_query($this->id,$query) or
            MySQL_ErrorMsg ("Unable to perform query: $query");
        $this->rows = @mysqli_num_rows($this->result);
        $this->a_rows = @mysqli_affected_rows($this->result);
$this->fields=@mysqli_fetch_fields($this->result);


    }

    # Use this function if the query will only return a
    # single data element.
    function QueryItem ($query) {
        $this->result = @mysqli_query($this->id,$query) or
            MySQL_ErrorMsg ("Unable to perform query: $query");
        $this->rows = @mysqli_num_rows($this->result);
        $this->a_rows = @mysqli_affected_rows($this->result);
        $this->data = @mysqli_fetch_array($this->result) or
            MySQL_ErrorMsg ("Unable to fetch data from query: $query");
        return($this->data[0]);
    }

    # This function is useful if the query will only return a
    # single row.
    function QueryRow ($query) {
        $this->result = @mysqli_query($this->id,$query) or
            MySQL_ErrorMsg ("Unable to perform query: $db: $query");
        $this->rows = @mysqli_num_rows($this->result);
        $this->a_rows = @mysqli_affected_rows($this->result);
        $this->data = @mysqli_fetch_array($this->result,MYSQLI_ASSOC) or
            MySQL_ErrorMsg ("Unable to fetch data from query: $query");
        return($this->data);
    }

    function Fetch ($row) {
        @mysqli_data_seek($this->result, $row) or
            MySQL_ErrorMsg ("Unable to seek data row: $row");
        $this->data = @mysqli_fetch_array($this->result) or
            MySQL_ErrorMsg ("Unable to fetch row: $row");
    }

    function FetchA ($row) {
        @mysqli_data_seek($this->result, $row) or
            MySQL_ErrorMsg ("Unable to seek data row: $row");
        $this->data = @mysqli_fetch_array($this->result,MYSQLI_ASSOC) or
            MySQL_ErrorMsg ("Unable to fetch row: $row");
    }

    function Insert ($query) {
        $this->result = @mysqli_query($this->id,$query) or
            MySQL_ErrorMsg ("Unable to perform insert: $query");
        $this->a_rows = @mysqli_affected_rows($this->result);
    }

    function Update ($query) {
        $this->result = @mysqli_query($this->id,$query) or
            MySQL_ErrorMsg ("Unable to perform update: $query");
        $this->a_rows = @mysqli_affected_rows($this->result);
    }

    function UpdateA ($query) {
        $this->result = @mysqli_query($this->id,$query) or
            MySQL_ErrorMsg2 ("Unable to perform update: $query",$this->id);
        $this->a_rows = @mysqli_affected_rows($this->result);
    }
    function Delete ($query) {
        $this->result = @mysqli_query($this->id,$query) or
            MySQL_ErrorMsg ("Unable to perform Delete: $query");
        $this->a_rows = @mysqli_affected_rows($this->result);
    }	
	//To escape data 
	function escape($valueString)
	{
		return  $this->id->real_escape_string(trim(stripslashes($valueString)));
	}
}

/* ********************************************************************
 * MySQL_ErrorMsg
 *
 * Print out an MySQL error message
 *
 */

function MySQL_ErrorMsg ($msg) {
    # Close out a bunch of HTML constructs which might prevent
    # the HTML page from displaying the error text.
    /* echo("</ul></dl></ol>\n"); */
    /* echo("</table></script>\n"); */

    # Display the error message
    $text  = "<font color=\"#ff0000\" size=+2><p>Error: $msg :";
    $text .= mysql_error();
    $text .= "</font>\n";
//echo("$text"); 


$fp=fopen("util.log","a");
fputs($fp,$text);
fclose($fp);

}

function MySQL_ErrorMsg2 ($msg,$link) {
    # Close out a bunch of HTML constructs which might prevent
    # the HTML page from displaying the error text.
    /* echo("</ul></dl></ol>\n"); */
    /* echo("</table></script>\n"); */

    # Display the error message
    $text  = "<font color=\"#ff0000\" size=+2><p>Error: $msg :";
    $text .= mysqli_error($link);
    $text .= "</font>\n";
die("$text"); 


$fp=fopen("util.log","a");
fputs($fp,$text);
fclose($fp);

}


?>
