<?php 

#	Description	:	Database Abstraction Layer class. The following class is a PHP4 compatible class

require_once('defines.php');

class Database
{
	var 		$DbLink; 
	var 		$HostName;
	var			$UserName;
	var			$Password;
	var			$DatabaseName;
	var			$ErrorInfo;
                private  $numRows;
	function Database()
	{
		$this->HostName			=	DB_HOST;
		$this->UserName			=	DB_USER;
		$this->Password			=	DB_PASSWORD;
		$this->DatabaseName		=	DB_NAME;
	}
	#	The following method establish a connection with the database server and on success return TRUE, on failure return FALSE
	#	On failure ErrorInfo property contains the error information.
	function dbConnect()
	{
		$this->DbLink 	= 	mysqli_connect($this->HostName, $this->UserName, $this->Password,$this->DatabaseName);
                
		if(!$this->DbLink) { 
			$this->ErrorInfo	=	mysqli_error();
                        
			return FALSE;
		} else {
                
			if(mysqli_select_db($this->DbLink,$this->DatabaseName)) {
				return TRUE; 
			} else {
                          
				$this->ErrorInfo	=	mysqli_error();
				return FALSE;
			}
		}
	} # Close method dbConnect
	# The following method closes database connection
	function dbClose()
	{
		mysqli_close($this->DbLink);
	}
	# On insert, update it returns TRUE,  and on select it returns result set object
	function setQuery($Query)
	{
		$ExecStatus		=	@mysqli_query($this->DbLink,$Query);
		if($ExecStatus	===	FALSE) {
			$this->ErrorInfo	= mysqli_errno()." ".	mysql_error();
			return FALSE;
		} else {
			return $ExecStatus;
		} 
	} # Close method setQuery			
	# The following method returns a row corresponding to a query
	function readValue($Query)
	{
		$Row	=	array();
		$Rs		=	@mysqli_query($this->DbLink,$Query);	
		     
                $this->numRows=  mysqli_num_rows($Rs) ; 
                                if(!$Rs) {
		$this->ErrorInfo	=	mysqli_error();
                               
                                 return $Row;	 
		} else {
			$Row	=	@mysqli_fetch_array($Rs);
			@mysqli_free_result($Rs);
			return $Row;  		
		}
                
                
	}
	# The following method returns a set of rows as database query result
	function readValues($Query)
	{	
		$Rows	=	array();
		$Rs		=	@mysqli_query($this->DbLink,$Query);	
    
                $this->numRows=  mysqli_num_rows($Rs) ;   
		if(!$Rs) {
			$this->ErrorInfo	=	mysqli_error();
			return $Rows;	 		
		} else {
			$ArrInx	=	0;
			while($Row	=	@mysqli_fetch_array($Rs)) {
				$Rows[$ArrInx]	=	$Row;	
				$ArrInx++;
			}
		}
		mysqli_free_result($Rs);
		return $Rows;
	} # Close method definition
	# The following method return the affected rows during database operation
	function getAffectedRows()
	{
		$AffectedRows	=	@mysqli_affected_rows($this->DbLink);
		return $AffectedRows;
	}
	# Method returns the last id	
	function GenerateId($query)
	{	
		$result = mysql_query($query);
		$CreateId	=	@mysqli_fetch_row($result);
		if($CreateId=='' || $CreateId==0){
				
			$CreateId = 1;
			return $CreateId; 
		}
		else {			
			$id = $CreateId[0] + 1;
			return $id; 		
		}
	}
	# Method returns the last insert Id of this connection	
	function getInsertId()
	{
		$InsertId	=	@mysqli_insert_id($this->DbLink);
		return $InsertId; 		
	}
	function getFieldName($Query,$i)
	{
		$Qry = mysqli_field_name($Query,$i);
		return $Qry;
	}
	function getNumFields($Query)
	{
		$SqlQry = @mysqli_num_fields($Query);
		return $SqlQry;
	}
	function fetchRows($Query)
	{
		$fetchRow = @mysqli_fetch_row($Query);
		return $fetchRow;
	}
	function fetchArray($Query)
	{
		$fetchRow = @mysqli_fetch_array($Query);
		return $fetchRow;
	}
	
	function MysqlQry($Query)
	{
		$QryReturn = @mysqli_query($Query);
		return $QryReturn;
	}
	function RecordCount($rs)
	{
		if($rs && @mysqli_num_rows($rs)>0)
			$result	=	 @mysql_num_rows($rs);
		else 
			$result	=	0;
		return $result;
	}
	function numRows()
	{
		return $this->numRows;
	}
	function fetchAssoc($rs)
	{
		return	mysqli_fetch_assoc($rs);
	}
//Additional functions Added
	# The following method returns a set of rows as database query result (object)
	function readValuesObject($Query)
	{	
		$Rows	=	array();
		$Rs		=	@mysqli_query($Query);	
		if(!$Rs) {
			$this->ErrorInfo	=	mysqli_error();
			return $Rows;	 		
		} else {
			$ArrInx	=	0;
			while($Row	=	@mysqli_fetch_object($Rs)) {
				$Rows[$ArrInx]	=	$Row;	
				$ArrInx++;
			}
		}
		mysqli_free_result($Rs);
		return $Rows;
	} # Close method definition
	# The following method returns a row corresponding to a query (object)
	function readValueObject($Query)
	{
		$Row	=	array();
		$Rs		=	@mysqli_query($this->DbLink,$Query);	
		if(!$Rs) {
			$this->ErrorInfo	=	mysqli_error();
			return $Row;	 
		} else {
			$Row	=	@mysqli_fetch_object($Rs);
			@mysqli_free_result($Rs);
			return $Row;  		
		}
	}
} # Close class definition
?>