<?php
/***************************************************************************
 *                                                                          *
 * Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
 *                                                                          *
 * This  is  commercial  software,  only  users  who have purchased a valid *
 * license  and  accept  to the terms of the  License Agreement can install *
 * and use this program.                                                    *
 *                                                                          *
 ****************************************************************************
 * PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
 * "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
 ****************************************************************************/
//
//$Id: CustomerController, v 1.0 2014/05/02 12:11:15
//
class CustomerController extends Controller 
{
	/* Customer Listing */
	public function indexAction()    
	{
		$ObjCustomer    	= 	new CustomerModel();
		$ObjCountry     	=   new CountryModel();
		$ObjAdminlog		= 	new AdminlogModel();
		$languageIDs		= 	$this->ObjView->languageIDs;	
		$adminId			=	$this->ObjCommon->manageUserID; 
		$branchCodeSes		=	$this->ObjCommon->manageBranchCode; 
		$transID			=	$this->ObjCommon->transSession; 
		$resListCountryOptions     = $ObjCountry->listCountries($languageIDs,'');
		$settingsDateFormat = $this->getSettingValue("site_settings", "date_format");
		$settingsTimeFormat = $this->getSettingValue("site_settings", "time_format");
		if (isset($_POST['select_status']))
		{
			if(($transID=="") || ($transID!=$adminId))
			{
				$this->setRedirect("adminuser/transPwd/urlback/ajax/ctrlpath/customer/");
			}
			else
			{
				$customerNames		= array();
				$customerIDs		= array();
				foreach($_POST['customerID'] as $key=>$customerValues)
				{
					$customerNames[]	= $key;
					$customerIDs[]		= $customerValues[0];
				}
				$ObjLicense			=	new LicenseModel();
				$params=array(
					'customerStatus'=>$_POST['select_status'],
					'customerIDs'=>$customerIDs
				);
				$custIDStr		= implode(",",$customerIDs);
				$custNameStr	= implode(",",$customerNames);
				if(($_POST['select_status']=="Inactive") || ($_POST['select_status']=="Deleted"))
				{
					$customerUsed	= $ObjLicense->checkCustomerUsed($customerIDs);
					if(count($customerUsed)>0)
					{
						$this->setMessage('language.lblCustomerNotUpdate','message_info');
						/* Adminlog */
						$adminAccessIP		= $this->ObjCommon->getClientIP();
						$i									= 0;
						$adminActionData					= array();
						$adminActionData[$i]['status']		= "Status Updation Failed";
						$adminActionData[$i]['response']	= "Customer Have Active License, So Cannot Change its Status";
						$adminActionData[$i]['message']		= "No Changes Found For Customers: <b>".$custNameStr."</b>";
						$i++;
						$adminActionDataStr					= serialize($adminActionData);
						$params =array(
						'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Bulk Status', 'adminActionObject'=>'Customer', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
						);
						$ObjAdminlog->insertAdminlog($params);
						/* End Adminlog */
					}
					else
					{
						$changeStatus = $ObjCustomer->changeStatus($params);
						$this->setMessage('language.lblCustomerstatusUpdatedSuccess','success');
						/* Adminlog */
						$adminAccessIP						= $this->ObjCommon->getClientIP();
						$i									= 0;
						$adminActionData					= array();
						$adminActionData[$i]['status']		= "Updated The Status";
						$adminActionData[$i]['response']	= "Customer Bulk Status Updated Successfully";
						$adminActionData[$i]['message']		= "Updated Status of Customer<br/>";
						$adminActionData[$i]['message']		.= "<div class='grid_table00'>
						<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>CustomerID</td><td width='50%' height='15%' align='left'>Customer Name</td><td width='30%' height='15%' align='left'>Customer Status</td></tr>";
						for($s=0;$s<count($customerIDs);$s++)
						{
							$adminActionData[$i]['message']		.= "<tr><td align='left'><b>".$customerIDs[$s]."</b></td><td align='left'><b>".$customerNames[$s]."</b></td><td align='left'><b>".$_POST['select_status']."</b></td></tr>";
						}
						$adminActionData[$i]['message']		.= "</table></div><br/>";
						$i++;
						
						$adminActionDataStr					= serialize($adminActionData);

						$params =array(
						'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Bulk Status', 'adminActionObject'=>'Customer', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
						);
						$ObjAdminlog->insertAdminlog($params);
						/* End Adminlog */
					}
				}
				else
				{
					$ObjCustomer->changeStatus($params);
					$this->setMessage('language.lblCustomerstatusUpdatedSuccess','success');
					/* Adminlog */
					$adminAccessIP						= $this->ObjCommon->getClientIP();
					$i									= 0;
					$adminActionData					= array();
					$adminActionData[$i]['status']		= "Updated The Status";
					$adminActionData[$i]['response']	= "Customer Bulk Status Updated Successfully";
					$adminActionData[$i]['message']		= "Updated Status of Customer<br/>";
					$adminActionData[$i]['message']		.= "<div class='grid_table00'>
					<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>CustomerID</td><td width='50%' height='15%' align='left'>Customer Name</td><td width='30%' height='15%' align='left'>Customer Status</td></tr>";
					for($s=0;$s<count($customerIDs);$s++)
					{
						$adminActionData[$i]['message']		.= "<tr><td align='left'><b>".$customerIDs[$s]."</b></td><td align='left'><b>".$customerNames[$s]."</b></td><td align='left'><b>".$_POST['select_status']."</b></td></tr>";
					}
					$adminActionData[$i]['message']		.= "</table></div><br/>";
					$i++;
					
					$adminActionDataStr					= serialize($adminActionData);

					$params =array(
					'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Bulk Status', 'adminActionObject'=>'Customer', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
					);
					$ObjAdminlog->insertAdminlog($params);
					/* End Adminlog */
				}
				$this->setRedirect();
			}
		}		
		$link	=	'customer/index/';
		if (isset($_POST['search']))
		{			
			if ($_POST['customerFirstName'] != ""){
				$link .= "customerFirstName/" . $this->encodeUrlString($_POST['customerFirstName']) . "/";
			}			
			if ($_POST['customerLastName'] != ""){
				$link .= "customerLastName/" . $this->encodeUrlString($_POST['customerLastName']) . "/";
			}			
			if ($_POST['customerEmailID'] != ""){
				$link .= "customerEmailID/" . $this->encodeUrlString($_POST['customerEmailID']) . "/";
			}			
			if ($_POST['customerPhone'] != ""){
				$link .= "customerPhone/" . $this->encodeUrlString($_POST['customerPhone']) . "/";
			}			
			if ($_POST['customerCompany'] != ""){
				$link .= "customerCompany/" . $this->encodeUrlString($_POST['customerCompany']) . "/";
			}			
			if ($_POST['customerAddress1'] != ""){
				$link .= "customerAddress1/" . $this->encodeUrlString($_POST['customerAddress1']) . "/";
			}			
			if ($_POST['customerAddress2'] != ""){
				$link .= "customerAddress2/" . $this->encodeUrlString($_POST['customerAddress2']) . "/";
			}			
			if ($_POST['customerCity'] != ""){
				$link .= "customerCity/" . $this->encodeUrlString($_POST['customerCity']) . "/";
			}			
			if ($_POST['customerPincode'] != ""){
				$link .= "customerPincode/" . (int)$_POST['customerPincode'] . "/";
			}			
			if ($_POST['countryID'] != ""){
				$link .= "countryID/" . (int)$_POST['countryID'] . "/";
			}			
			if ($_POST['stateID'] != ""){
				$link .= "stateID/" . (int)$_POST['stateID'] . "/";
			}			
			if ($_POST['registerDate'] != ""){
				list($fromDate, $toDate) = split(' - ', $_POST['registerDate']);
				$link .= (($fromDate != "") ? "from/" . $this->urlDate($fromDate, 'set', $settingsDateFormat) . "/" :"");
				$link .= (($toDate != "") ? "to/" . $this->urlDate($toDate, 'set', $settingsDateFormat) . "/" :"");
			}			
			if ($_POST['customerFax'] != ""){
				$link .= "customerFax/" . $this->encodeUrlString($_POST['customerFax']) . "/";
			}
			$this->setRedirect($link);
		}
		else
		{
			$sortby		=	$this->getRequestValue("sortby");
			$orderby	=	($this->getRequestValue("orderby")=="")?"asc":$this->getRequestValue("orderby");
					
			if($this->getRequestValue('customerFirstName')){
				$customerFirstName		= 	$this->decodeUrlString($this->getRequestValue('customerFirstName'));
				$link.="/customerFirstName/".$customerFirstName;
			}			
			if($this->getRequestValue('customerLastName')){
				$customerLastName		= 	$this->decodeUrlString($this->getRequestValue('customerLastName'));
				$link.="/customerLastName/".$customerLastName;
			}			
			if($this->getRequestValue('customerEmailID')){
				$customerEmailID		= 	$this->decodeUrlString($this->getRequestValue('customerEmailID'));
				$link.="/customerEmailID/".$customerEmailID;
			}			
			if($this->getRequestValue('customerPhone')){
				$customerPhone		= 	$this->decodeUrlString($this->getRequestValue('customerPhone'));
				$link.="/customerPhone/".$customerPhone;
			}			
			if($this->getRequestValue('customerCompany')){
				$customerCompany		= 	$this->decodeUrlString($this->getRequestValue('customerCompany'));
				$link.="/customerCompany/".$customerCompany;
			}			
			if($this->getRequestValue('customerAddress1')){
				$customerAddress1		= 	$this->decodeUrlString($this->getRequestValue('customerAddress1'));
				$link.="/customerAddress1/".$customerAddress1;
			}			
			if($this->getRequestValue('customerAddress2')){
				$customerAddress2		= 	$this->decodeUrlString($this->getRequestValue('customerAddress2'));
				$link.="/customerAddress2/".$customerAddress2;
			}			
			if($this->getRequestValue('customerCity')){
				$customerCity		= 	$this->decodeUrlString($this->getRequestValue('customerCity'));
				$link.="/customerCity/".$customerCity;
			}			
			if($this->getRequestValue('customerPincode')){
				$customerPincode		= 	$this->getRequestValue('customerPincode');
				$link.="/customerPincode/".$customerPincode;
			}			
			if($this->getRequestValue('countryID')){
				$countryID		= 	$this->getRequestValue('countryID');
				$link.="/customerCountry/".$countryID;
			}			
			if($this->getRequestValue('stateID')){
				$stateID		= 	$this->getRequestValue('stateID');
				$link.="/stateID/".$stateID;
			}			
			if($this->getRequestValue('from')){
				$fromDate 		= $this->urlDate($this->getRequestValue('from'), 'get', $settingsDateFormat);
				$link .= (($fromDate != "") ? "from/" . $this->urlDate($fromDate, 'set', $settingsDateFormat) . "/" :"");
			}
			if($this->getRequestValue('to')){
				$toDate 		= $this->urlDate($this->getRequestValue('to'), 'get', $settingsDateFormat);
				$link .= (($toDate != "") ? "to/" . $this->urlDate($toDate, 'set', $settingsDateFormat) . "/" :	"");
			}
			if($this->getRequestValue('customerFax')){
				$customerFax		= 	$this->decodeUrlString($this->getRequestValue('customerFax'));
				$link.="/customerFax/".$customerFax;
			}	
		}
		list($limitFrom, $limitTo) = $this->getPageSettings($key = 'page', $rows = 10); 
		
		/*assigning from and to values for search*/
		$assignFromDate =  $fromDate; 
        $assignToDate = $toDate;
        if (!$toDate && $fromDate){
           	 $toDate   = $fromDate; 
       	}
		$fromDate	= $this->convertDateForSQL($fromDate, $settingsDateFormat);
		$toDate		= $this->convertDateForSQL($toDate, $settingsDateFormat);
        /*assigning from and to values for search*/
			
		$params =array(
			'limitFrom'=>$limitFrom,
			'limitTo'=>$limitTo,
			'languageIDs'=>$languageIDs,
			'sortby'=>$sortby,
			'orderby'=>$orderby,
			'customerFirstName'=>$customerFirstName ,'customerLastName'=>$customerLastName ,'customerEmailID'=>$customerEmailID ,'customerPhone'=>$customerPhone ,'customerCompany'=>$customerCompany ,'customerAddress1'=>$customerAddress1 ,'customerAddress2'=>$customerAddress2 ,'customerCity'=>$customerCity ,'customerPincode'=>$customerPincode ,'countryID'=>$countryID ,'stateID'=>$stateID ,'fromDate'=>$fromDate , 'toDate'=>$toDate , 'customerFax'=>$customerFax 
		);
		if($adminId>1)
		{
			$listCustomer    = $ObjCustomer->listCustomer($params,$branchCodeSes);	
		}
		else
		{
			$listCustomer    = $ObjCustomer->listCustomer($params);	
		}

		$resPagesCount	= $this->setPagesCount($key = 'page');
		$this->ObjView->assign("page", $page);	
		$this->ObjView->assign("sortby", $sortby); $this->ObjView->assign("orderby", ($orderby=="asc")?'desc':'asc'); $this->ObjView->assign("customerFirstName", $customerFirstName); $this->ObjView->assign("customerLastName", $customerLastName); $this->ObjView->assign("customerEmailID", $customerEmailID); $this->ObjView->assign("customerPhone", $customerPhone); $this->ObjView->assign("customerCompany", $customerCompany); $this->ObjView->assign("customerAddress1", $customerAddress1); $this->ObjView->assign("customerAddress2", $customerAddress2); $this->ObjView->assign("customerCity", $customerCity); $this->ObjView->assign("customerPincode", $customerPincode); $this->ObjView->assign("countryID", $countryID); $this->ObjView->assign("stateID", $stateID); $this->ObjView->assign("customerFax", $customerFax);
		$this->ObjView->assign('listCustomer', $listCustomer);	
		if($assignFromDate && $assignToDate==''){
			$this->ObjView->assign('registerDate', $assignFromDate);
		}else if($assignFromDate && $assignToDate){
			$this->ObjView->assign('registerDate', $assignFromDate.' - '.$assignToDate);
		}else{
			$this->ObjView->assign('registerDate','');
		}
		
		$editPrivilege		=	$this->ObjCommon->hasPrivilege('customer/edit/');
		$this->ObjView->assign("editPrivilege", $editPrivilege);
		$deletePrivilege	=	$this->ObjCommon->hasPrivilege('customer/destroy/');
		$this->ObjView->assign("deletePrivilege", $deletePrivilege);
		$this->ObjView->assign('resCountry', $resListCountryOptions);
		$this->ObjView->assign('settingsDateFormat', $settingsDateFormat);
		$this->ObjView->assign('settingsTimeFormat', $settingsTimeFormat);
		$this->ObjView->assign("link", $link);
		$this->ObjView->assign("adminId", $adminId);
		$this->ObjView->assign("branchCodeSes", $branchCodeSes);
		$this->ObjView->display('CustomerList.tpl');
	}

	/* Customer Add */
	public function newAction()    
	{		
		$ObjCustomer    	= new CustomerModel();
		$ObjCountry     	= new CountryModel();
		$ObjAdminlog		= new AdminlogModel();
		$languageIDs        = $this->ObjView->languageIDs;
		$adminId			= $this->ObjCommon->manageUserID; 
		$branchCodeSes		= $this->ObjCommon->manageBranchCode; 
		$resListCountryOptions     = $ObjCountry->listCountries($languageIDs,'');
		if($this->ObjForm->isValid('formCustomer','submitCustomer'))
		{
			$ObjCustomer->insert($languageIDs,$adminId);
			/* Adminlog */
			$adminAccessIP						= $this->ObjCommon->getClientIP();
			$i									= 0;
			$adminActionData					= array();
			$adminActionData[$i]['status']		= "New";
			$adminActionData[$i]['response']	= "Successfully Added";
			$i++;

			$adminActionData[$i]['field']	= "CustomerFirstName";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $_POST['customerFirstName'];
			$i++;

			$adminActionData[$i]['field']	= "CustomerLastName";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $_POST['customerLastName'];
			$i++;
			
			$adminActionData[$i]['field']	= "CustomerEmailID";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $_POST['customerEmailID'];
			$i++;

			$adminActionData[$i]['field']	= "CustomerPhone";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $_POST['customerPhone'];
			$i++;
			
			$adminActionData[$i]['field']	= "CustomerAddress1";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $_POST['customerAddress1'];
			$i++;


			$adminActionData[$i]['field']	= "CustomerStatus";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $_POST['customerStatus'];
			$i++;

			$adminActionDataStr				= serialize($adminActionData);

			$params =array(
			'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'New', 'adminActionObject'=>'Customer', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
			);
			$ObjAdminlog->insertAdminlog($params);
			/* End Adminlog */
			$this->setMessage('language.lblCustomeraddSuccess','success');
			$this->setRedirect('customer/index/');
		} 
		else
		{
			if(isset($_POST['submitCustomer']))
			{
				if(!$this->ObjForm->isValid('formCustomer','submitCustomer'))
				{
					/* Adminlog */
					$adminAccessIP		= $this->ObjCommon->getClientIP();
					$i									= 0;
					$adminActionData					= array();
					$adminActionData[$i]['status']		= "Insert Failed";
					$adminActionData[$i]['response']	= "Error found in form element";
					$adminActionData[$i]['message']		= "Data Cannot Be Added";
					$i++;
					$adminActionDataStr					= serialize($adminActionData);
					$params =array(
					'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'New', 'adminActionObject'=>'Customer', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
					);
					$ObjAdminlog->insertAdminlog($params);
					/* End Adminlog */
				}
			}
		}
		$this->ObjView->assign('resCountry', $resListCountryOptions);
		$this->ObjView->display('CustomerAdd.tpl');

	}

	public function editAction()    
	{
		$customerID			=   $this->getRequestValue('id');
		$ObjCustomer    	= 	new CustomerModel();
		$ObjCountry     	=   new CountryModel();
		$ObjAdminlog		= 	new AdminlogModel();
		$languageIDs        = 	$this->ObjView->languageIDs;
		$adminId			=	$this->ObjCommon->manageUserID; 
		$branchCodeSes		=	$this->ObjCommon->manageBranchCode;
		$resListCountryOptions 		= $ObjCountry->listCountries($languageIDs, "Yes");
		$params=array(
			'customerID'=>$customerID 
		);
		$getCustomer	= $ObjCustomer->getCustomer($params);
		if(empty($getCustomer)){
			 $this->setRedirect('customer');
		}
		
		$stateValue = (($getCustomer['stateID'] > 0) ? $getCustomer['stateID'] : $getCustomer['province']);
		if($this->ObjForm->isValid('formCustomer','submitCustomer')){
			
			
			$ObjCustomer->insert($languageIDs,$adminId,$customerID);
			
			/* Adminlog */
			$adminAccessIP						= $this->ObjCommon->getClientIP();
			$i									= 0;
			$adminActionData					= array();
			$adminActionData[$i]['status']		= "Updated";
			$adminActionData[$i]['response']	= "Successfully Updated";
			$i++;
			if($getCustomer['customerFirstName']!=$_POST['customerFirstName'])
			{
				$adminActionData[$i]['field']	= "CustomerFirstName";
				$adminActionData[$i]['Old']		= $getCustomer['customerFirstName'];
				$adminActionData[$i]['New']		= $_POST['customerFirstName'];
				$i++;
			}
			if($getCustomer['customerLastName']!=$_POST['customerLastName'])
			{
				$adminActionData[$i]['field']	= "CustomerLastName";
				$adminActionData[$i]['Old']		= $getCustomer['customerLastName'];
				$adminActionData[$i]['New']		= $_POST['customerLastName'];
				$i++;
			}
			if($getCustomer['customerEmailID']!=$_POST['customerEmailID'])
			{
				$adminActionData[$i]['field']	= "CustomerEmailID";
				$adminActionData[$i]['Old']		= $getCustomer['customerEmailID'];
				$adminActionData[$i]['New']		= $_POST['customerEmailID'];
				$i++;
			}
			if($getCustomer['customerPhone']!=$_POST['customerPhone'])
			{
				$adminActionData[$i]['field']	= "CustomerPhone";
				$adminActionData[$i]['Old']		= $getCustomer['customerPhone'];
				$adminActionData[$i]['New']		= $_POST['customerPhone'];
				$i++;
			}
			if($getCustomer['customerAddress1']!=$_POST['customerAddress1'])
			{
				$adminActionData[$i]['field']	= "CustomerAddress1";
				$adminActionData[$i]['Old']		= $getCustomer['customerAddress1'];
				$adminActionData[$i]['New']		= $_POST['customerAddress1'];
				$i++;
			}
			if($getCustomer['customerStatus']!=$_POST['customerStatus'])
			{
				$adminActionData[$i]['field']	= "CustomerStatus";
				$adminActionData[$i]['Old']		= $getCustomer['customerStatus'];
				$adminActionData[$i]['New']		= $_POST['customerStatus'];
				$i++;
			}
			if(count($adminActionData)==1)
			{
				$adminActionData[0]['message']	= "No Changes With Form Elements OR Minor Changes For Customer: <b>".$getCustomer['customerFirstName']." ".$getCustomer['customerLastName']."</b>";
			}
			$adminActionDataStr					= serialize($adminActionData);

			$params =array(
			'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Edit', 'adminActionObject'=>'Customer', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
			);
			$ObjAdminlog->insertAdminlog($params);
			/* End Adminlog */
			
			$this->setMessage('language.lblCustomerupdatedSuccess','success');
			$this->setRedirect('customer/index/');
			
		} 
		else 
		{
			if(isset($_POST['submitCustomer']))
			{
				if(!$this->ObjForm->isValid('formCustomer','submitCustomer'))
				{
					/* Adminlog */
					$adminAccessIP		= $this->ObjCommon->getClientIP();
					$i									= 0;
					$adminActionData					= array();
					$adminActionData[$i]['status']		= "Update Failed";
					$adminActionData[$i]['response']	= "Error found in form element";
					$adminActionData[$i]['message']		= "No Changes Found For Customer: <b>".$getCustomer['customerFirstName']." ".$getCustomer['customerLastName']."</b>";
					$i++;
					$adminActionDataStr					= serialize($adminActionData);
					$params =array(
					'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Edit', 'adminActionObject'=>'Customer', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
					);
					$ObjAdminlog->insertAdminlog($params);
					/* End Adminlog */
				}
			}
		}
		$this->ObjView->assignValues($getCustomer);
		$this->ObjView->assign('customerID', $customerID);
		$this->ObjView->assign('resCountry', $resListCountryOptions);
		$this->ObjView->assign('stateID', $stateValue);
        $this->ObjView->assign('statehidValue', $stateValue);
		$this->ObjView->display('CustomerAdd.tpl');
		
	}

	/* To Show the Customer */
	public function viewAction()    
	{
		$customerID  		= $this->getRequestValue('id');
		$ObjCustomer    	= new CustomerModel();
		$ObjLicense    		= new LicenseModel();
		$adminId			= $this->ObjCommon->manageUserID; 
		$branchCodeSes		= $this->ObjCommon->manageBranchCode;
		$params=array(
			'customerID'=>$customerID, 
			'adminId'=>$adminId, 
			'branchCodeSes'=>$branchCodeSes  
		);
		$getCustomer	= $ObjCustomer->getCustomer($params);
		if(empty($getCustomer)){
			 $this->setRedirect('customer/index/');
		}
		if($adminId>1)
		{
			$customerLic	= $ObjCustomer->getCustomerLicDetails($customerID,$branchCodeSes);
		}
		else
		{
			$customerLic	= $ObjCustomer->getCustomerLicDetails($customerID);
		}
		
		$this->ObjView->assign('getCustomer', $getCustomer);
		$this->ObjView->assign('customerLic', $customerLic);
		$this->ObjView->assign('customerID', $customerID);
		$editPrivilege	=	$this->ObjCommon->hasPrivilege('customer/edit/');
		$this->ObjView->assign("editPrivilege", $editPrivilege);
		$this->ObjView->assign("previousURl", $this->getPreviousURL());
		$this->ObjView->display('CustomerView.tpl');
		
	}

	/* Ajax Status Change */
	public function ajaxstatusAction()    
	{
		$customerID 	=   $this->getRequestValue('id');
		$customerIDs 	= 	array($customerID);
		$status			=   $this->getRequestValue('status');
		$name		  	= 	$this->getRequestValue('name');
		$ObjCustomer   	= 	new CustomerModel();
		$ObjLicense		=	new LicenseModel();
		$ObjAdminlog	= 	new AdminlogModel();
		$adminId		= 	$this->ObjCommon->manageUserID;
		$params=array(
			'customerStatus'=>$status,
			'customerIDs'=>array($customerID)
		);
		if($status=="Inactive")
		{
			$customerUsed	= $ObjLicense->checkCustomerUsed($customerIDs);
			if(count($customerUsed)>0)
			{
				$this->setMessage('language.lblCustomerNotUpdate','message_info');
				/* Adminlog */
				$adminAccessIP		= $this->ObjCommon->getClientIP();
				$i									= 0;
				$adminActionData					= array();
				$adminActionData[$i]['status']		= "Status Updation Failed";
				$adminActionData[$i]['response']	= "Customer Have Active License, So Cannot Change its Status";
				$adminActionData[$i]['message']		= "No Changes Found For Customer: <b>".$name."</b>";
				$i++;
				$adminActionDataStr					= serialize($adminActionData);
				$params =array(
				'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Status', 'adminActionObject'=>'Customer', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
				);
				$ObjAdminlog->insertAdminlog($params);
				/* End Adminlog */
			}
			else
			{
				$changeStatus = $ObjCustomer->changeStatus($params);
				$this->setMessage('language.lblCustomerstatusUpdatedSuccess','success');
				/* Adminlog */
				$adminAccessIP						= $this->ObjCommon->getClientIP();
				$i									= 0;
				$adminActionData					= array();
				$adminActionData[$i]['status']		= "Updated The Status";
				$adminActionData[$i]['response']	= "Customer Status Updated Successfully";
				$adminActionData[$i]['message']		= "Updated Status of States<br/>";
				$adminActionData[$i]['message']		.= "<div class='grid_table00'>
				<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>CustomerID</td><td width='50%' height='15%' align='left'>Customer Name</td><td width='30%' height='15%' align='left'>Customer Status</td></tr><tr><td align='left'><b>".$customerID."</b></td><td align='left'><b>".$name."</b></td><td align='left'><b>".$status."</b></td></tr></table></div><br/>";
				$i++;
				$adminActionDataStr					= serialize($adminActionData);

				$params =array(
				'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Status', 'adminActionObject'=>'Customer', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
				);
				$ObjAdminlog->insertAdminlog($params);
				/* End Adminlog */
			}
		}
		else
		{
			$changeStatus = $ObjCustomer->changeStatus($params);
			$this->setMessage('language.lblCustomerstatusUpdatedSuccess','success');
			/* Adminlog */
			$adminAccessIP						= $this->ObjCommon->getClientIP();
			$i									= 0;
			$adminActionData					= array();
			$adminActionData[$i]['status']		= "Updated The Status";
			$adminActionData[$i]['response']	= "Customer Status Updated Successfully";
			$adminActionData[$i]['message']		= "Updated Status of States<br/>";
			$adminActionData[$i]['message']		.= "<div class='grid_table00'>
			<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>CustomerID</td><td width='50%' height='15%' align='left'>Customer Name</td><td width='30%' height='15%' align='left'>Customer Status</td></tr><tr><td align='left'><b>".$customerID."</b></td><td align='left'><b>".$name."</b></td><td align='left'><b>".$status."</b></td></tr></table></div><br/>";
			$i++;
			$adminActionDataStr					= serialize($adminActionData);

			$params =array(
			'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Edit', 'adminActionObject'=>'Customer', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
			);
			$ObjAdminlog->insertAdminlog($params);
			/* End Adminlog */
		}

	}

	/* Delete Action */
	public function destroyAction()    
	{
		$customerID  	= $this->getRequestValue('id');
		$customerIDs	= array($customerID);
		$name		  	= $this->getRequestValue('name');
		$adminId		= $this->ObjCommon->manageUserID; 
		$branchCodeSes	= $this->ObjCommon->manageBranchCode;
		$ObjAdminlog	= new AdminlogModel();
		if(isset($customerID))
		{
			$ObjCustomer    	= 	new CustomerModel();
			$ObjLicense			=	new LicenseModel();
			$params=array(
				'customerStatus'=>'Deleted',
				'customerIDs'=>array($customerID)
			);
			$customerUsed	= $ObjLicense->checkCustomerUsed($customerIDs);
			if(count($customerUsed)>0)
			{
				/* Adminlog */
				$adminAccessIP		= $this->ObjCommon->getClientIP();
				$i									= 0;
				$adminActionData					= array();
				$adminActionData[$i]['status']		= "Delete Failed";
				$adminActionData[$i]['response']	= "Customer Have Active License, So Cannot Change its Status";
				$adminActionData[$i]['message']		= "No Changes Found For Customer: <b>".$name."</b>";
				$i++;
				$adminActionDataStr					= serialize($adminActionData);
				$params =array(
				'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Delete', 'adminActionObject'=>'Customer', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
				);
				$ObjAdminlog->insertAdminlog($params);
				/* End Adminlog */
				$this->setMessage('language.lblCustomerNotUpdate','message_info');
			}
			else
			{
				$changeStatus = $ObjCustomer->changeStatus($params);
				/* Adminlog */
				$adminAccessIP						= $this->ObjCommon->getClientIP();
				$i									= 0;
				$adminActionData					= array();
				$adminActionData[$i]['status']		= "Deleted";
				$adminActionData[$i]['response']	= "Customer Deleted Successfully";
				$adminActionData[$i]['message']		= "Deleted Customer<br/>";
				$adminActionData[$i]['message']		.= "<div class='grid_table00'>
				<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>CustomerID</td><td width='50%' height='15%' align='left'>Customer Name</td><td width='30%' height='15%' align='left'>Customer Status</td></tr><tr><td align='left'><b>".$customerID."</b></td><td align='left'><b>".$name."</b></td><td align='left'><b>Deleted</b></td></tr></table></div><br/>";
				$i++;
				
				$adminActionDataStr					= serialize($adminActionData);

				$params =array(
				'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Delete', 'adminActionObject'=>'Customer', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
				);
				$ObjAdminlog->insertAdminlog($params);
				/* End Adminlog */
				$this->setMessage('language.lblCustomerdeletedSuccess','success');
			}
			$this->setRedirect('customer/index/');
			
		}
	}
	
	/* AJAX ACTION FOR LIST COUNTRY STATE */
    public function ajaxStateAction()
    {
		$ObjState    = new StateModel();
        $languageIDs = $this->ObjView->languageIDs;
		$countryID   = $_POST['countryID'];
        $stateID     = $_POST['stateID'];
        if ($countryID > 0)
        {
           $statesList = $ObjState->listStates($languageIDs, $countryID);
        }
        $this->ObjView->assign('stateID', $stateID);
        $this->ObjView->assign('statesList', $statesList);
        $this->ObjView->display('CityState.tpl');
    }
	
	/* Check EmailID Already Exist Before Customer Add */
	public function customerEmailExist()
	{
		$customerID 	=   $this->getRequestValue('id');
		$ObjCustomer   	= 	new CustomerModel();
		$customerEmailExist	= $ObjCustomer->checkCustomerEmailExist($customerID);
		if(count($customerEmailExist)>0)
		{
			return false;
		}
		return true;
	}
	
	/* Check Phone Number Already Exist Before Customer Add */
	public function customerPhoneExist()
	{
		$customerID 	=   $this->getRequestValue('id');
		$ObjCustomer   	= 	new CustomerModel();
		$customerPhoneExist	= $ObjCustomer->checkCustomerPhoneExist($customerID);
		if(count($customerPhoneExist)>0)
		{
			return false;
		}
		return true;
	}
	
	/* Send Mail To Customer*/
	public function ajaxCustomerMailPreviewAction()    
	{
		$ObjEmailtemplate	= new EmailtemplateModel();
		$languageIDs		= $this->ObjView->languageIDs;		
		$customerID       	= $this->getRequestValue('customerID'); 
		$emailTempDet     	= $ObjEmailtemplate->getEmailTemlateDetails($languageIDs, '', 'mail-to-customer');
		$fromEmailName 		= $emailTempDet['emailFromName'];
        $fromEmailId   		= $emailTempDet['emailFromEmail'];
        $Subject       		= $emailTempDet['emailSubject'];
        $Body          		= $emailTempDet['emailHtml'];
		
		$this->ObjView->assign('Body', $Body);
		$this->ObjView->assign('customerID', $customerID);
		$this->ObjView->display('CustomerMailPrev.tpl');
	}
	
	/* Send Mail To Customer */
	public function ajaxSendMailAction()    
	{
		$ObjEmailtemplate	= new EmailtemplateModel();
		$languageIDs		= $this->ObjView->languageIDs;		
		$mail_settings   	= $this->getSettingValue('mail_settings');
        $ObjMail          	= new Mail($mail_settings);
		$status 			= $_POST['status'];
		$customerID       	= $_POST['customerID'];
		$companyLogo   		= $this->getSettingValue('company_information', 'company_logo');
        $siteName      		= $this->getSettingValue('site_settings', 'site_name');
        $siteUrl       		= $this->getSettingValue('site_settings', 'global_http_url');
		$sendCount			= 0;
		$totalSendCount		= 0;
		$emailTempDet     	= $ObjEmailtemplate->getEmailTemlateDetails($languageIDs, '', 'mail-to-customer');
		$ObjCustomer    	= new CustomerModel();
		$adminId			= $this->ObjCommon->manageUserID; 
		$branchCodeSes		= $this->ObjCommon->manageBranchCode;
		$params=array(
			'customerID'=>$customerID, 
			'adminId'=>$adminId, 
			'branchCodeSes'=>$branchCodeSes  
		);
		$getCustomer	= $ObjCustomer->getCustomer($params);

		$fromEmailName 		= $emailTempDet['emailFromName'];
		$fromEmailId   		= $emailTempDet['emailFromEmail'];
		$Subject       		= $emailTempDet['emailSubject'];
		//$Subject       		.=  "Mail To Customer";
		$Body          		= $emailTempDet['emailHtml'];
		$this->ObjView->assign('emailBottom',$emailBottom);						
		$this->ObjView->assign('companyLogo', $companyLogo);
		$this->ObjView->assign('siteName', $siteName);
		$this->ObjView->assign('siteUrl', $siteUrl);
		$customerEmailID 	= $getCustomer['customerEmailID'];
		$customerName  		= $getCustomer['customerFirstName'] . ' ' . $getCustomer['customerLastName'];
		$Body         		= str_replace('{$customerName}', $getCustomer['customerFirstName'] . " " . $customer['customerLastName'], $Body);
		$Body				.= "<br/>".$_POST['mailContent'];
		
		$this->ObjView->assign('emailbody', $Body);
		$email_body = $this->ObjCommon->fetch("email_templates/Layout.tpl",$languageIDs);
		$ObjMail->IsHTML();
		$send      			= $ObjMail->sendMail(array(
																$fromEmail,
																$fromName
																), 
														 array(
																array(
																		$customerEmailID,
																		$customerName
																	 )
														
															  ),$Subject, $email_body);
		if (!$ObjMail->Send()) 
		{
			$message					.= '<br>Sending failed for '.$customerEmailID;	
			$this->setMessage($message, 'error');
		}
		else
		{
			$sendEmails .= $customerName.',';
			$this->setMessage('Mails send to '.$customerName, 'success');
		}
		$ObjMail->clearAddresses();
		echo '<script type="text/javascript">parent.location.reload();parent.$.colorbox.close(); </script>';
		exit;
	}
}
