<?php
	/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/	//
//$Id: IndexController.php, v 1.0 2014/06/04 20:52:11
//
class IndexController extends Controller 
{
	public function indexAction() 
	{
		$ObjLicense    	= new LicenseModel();
		$ObjCustomer	= new CustomerModel();
		$languageIDs	= $this->ObjView->languageIDs;	                                      
		$date_format 	= $this->getSettingValue('site_settings','date_format');
		$languageIDs	= $this->ObjView->languageIDs;
		$adminId		= $this->ObjCommon->manageUserID; 
		$branchCodeSes	= $this->ObjCommon->manageBranchCode;
		$limitTo 		= 5;
		//User List Privilege
		$userPrivilege=$this->ObjCommon->hasPrivilege('license/index/');
		if($userPrivilege)
		{
			$totLicenseCount 		= $ObjLicense->getLicenseCount($adminId,$branchCodeSes);		
			$totLicenseBlckCount 	= $ObjLicense->getLicenseBlockCount($adminId,$branchCodeSes);	
			$fullblockValue			= "full blocked";
			$totLicensePtBlckCount 	= $ObjLicense->getLicensePartBlockCount($adminId,$branchCodeSes);	
			$partblockValue			= "partially blocked";
			$totLicenseMultiCount 	= $ObjLicense->getLicenseMultiCount($adminId,$branchCodeSes);
			$multipleDom			= "both";
			$userShowPrivilege		= $this->ObjCommon->hasPrivilege('license/show/'); 
		}	
		$restotCustomerCount 		= $ObjCustomer->getCustomerCount($adminId,$branchCodeSes);
		$totCustomerCount 			= count($restotCustomerCount);
		
		/*get from and to date*/
		$toDay 			= date("Y-m-d");
		$thisWeek		= date("Y-m-d", strtotime("-7 days"));
		$monthToDate	= date("Y-m-01");
		$prevFromDate	= date("Y-m-01", strtotime("-1 months"));
		$prevToDate		= date("Y-m-30", strtotime("-1 months"));
		/*get from and to date*/
			
		//Edit License Privilege
		$editPrivilege=$this->ObjCommon->hasPrivilege('license/edit/');
		if($editPrivilege && $adminId==1)
		{
			// Todays's Count
			list($listInstall, $listExpired, $listInvalid, $listUnauth)    = $ObjLicense->licenseUnauthInstDayCount('today');
			$unauthCount          			= count($listUnauth);
			$invalidCount          			= count($listInvalid);
			$installCount          			= count($listInstall);
			$expiredCount          			= count($listExpired);
			
			// Thisweek Count
			list($listInstallThisWeek, $listExpiredThisWeek, $listInvalidThisWeek, $listUnauthThisWeek)    = $ObjLicense->licenseUnauthInstDayCount('thisweek');
			$unauthCountThisWeek     		= count($listUnauthThisWeek);
			$invalidCountThisWeek  			= count($listInvalidThisWeek);
			$installCountThisWeek  			= count($listInstallThisWeek);
			$expiredCountThisWeek  			= count($listExpiredThisWeek);

			// MonthToDate Count
			list($listInstallMonth, $listExpiredMonth, $listInvalidMonth, $listUnauthMonth)    = $ObjLicense->licenseUnauthInstDayCount('MonthToDate',$monthToDate);
			$unauthCountMonthToDate	   		= count($listUnauthMonth);
			$invalidCountMonthToDate		= count($listInvalidMonth);
			$installCountMonthToDate		= count($listInstallMonth);
			$expiredCountMonthToDate		= count($listExpiredMonth);
			
			// MonthToDate Count
			list($listInstallLMonth, $listExpiredLMonth, $listInvalidLMonth, $listUnauthLMonth)    = $ObjLicense->licenseUnauthInstDayCount('LastMonth',$prevFromDate,$prevToDate);
			$unauthCountLastMonth	   		= count($listUnauthLMonth);
			$invalidCountLastMonth			= count($listInvalidLMonth);
			$installCountLastMonth			= count($listInstallLMonth);
			$expiredCountLastMonth			= count($listExpiredLMonth);
			
			$totalUnauthAccessCount			= $unauthCount+$unauthCountThisWeek+$unauthCountMonthToDate+$unauthCountLastMonth;
			$totalInvalidAccessCount		= $invalidCount+$invalidCountThisWeek+$invalidCountMonthToDate+$invalidCountLastMonth;
			$totalInstallAccessCount		= $installCount+$installCountThisWeek+$installCountMonthToDate+$installCountLastMonth;
			$totalExpiredAccessCount		= $expiredCount+$expiredCountThisWeek+$expiredCountMonthToDate+$expiredCountLastMonth;
			$licenseshowPrivilege			= $this->ObjCommon->hasPrivilege('license/show/'); 
			
			$listLicenseUnauthDashboard		= $ObjLicense->listLicenseInstallDashboard('0','5','Unauthorized');
			$listLicenseInvalidDashboard	= $ObjLicense->listLicenseInvalidDashboard('0','5');
			$listLicenseInstallDashboard	= $ObjLicense->listLicenseInstallDashboard('0','5','Install');
			$listLicenseExpiredDashboard	= $ObjLicense->listLicenseInstallDashboard('0','5','Expired');
			
			$listLicenseUnauthDashboard		= array_merge($listLicenseUnauthDashboard, $listLicenseInvalidDashboard);
			
		}		
		$this->ObjView->assign("totLicenseCount", $totLicenseCount);			
		$this->ObjView->assign("totCustomerCount", $totCustomerCount);
		$this->ObjView->assign("totLicenseBlckCount", $totLicenseBlckCount);
		$this->ObjView->assign("fullblock", $this->encodeUrlString($fullblockValue));
		$this->ObjView->assign("partblock", $this->encodeUrlString($partblockValue));
		$this->ObjView->assign("multipleDom", $this->encodeUrlString($multipleDom));
		$this->ObjView->assign("totLicensePtBlckCount", $totLicensePtBlckCount);			
		$this->ObjView->assign("totLicenseMultiCount", $totLicenseMultiCount);	
		$this->ObjView->assign("installCount", $installCount);						
		$this->ObjView->assign("unauthCount", $unauthCount);
		$this->ObjView->assign("invalidCount", $invalidCount);
		$this->ObjView->assign("expiredCount", $expiredCount);
		$this->ObjView->assign("unauthCountThisWeek", $unauthCountThisWeek);
		$this->ObjView->assign("invalidCountThisWeek", $invalidCountThisWeek);
		$this->ObjView->assign("installCountThisWeek", $installCountThisWeek);
		$this->ObjView->assign("expiredCountThisWeek", $expiredCountThisWeek);
		$this->ObjView->assign("unauthCountMonthToDate", $unauthCountMonthToDate);	
		$this->ObjView->assign("invalidCountMonthToDate", $invalidCountMonthToDate);
		$this->ObjView->assign("installCountMonthToDate", $installCountMonthToDate);
		$this->ObjView->assign("expiredCountMonthToDate", $expiredCountMonthToDate);		
		$this->ObjView->assign("unauthCountLastMonth", $unauthCountLastMonth);
		$this->ObjView->assign("invalidCountLastMonth", $invalidCountLastMonth);
		$this->ObjView->assign("installCountLastMonth", $installCountLastMonth);	
		$this->ObjView->assign("expiredCountLastMonth", $expiredCountLastMonth);
		$this->ObjView->assign("totalUnauthAccessCount", $totalUnauthAccessCount);
		$this->ObjView->assign("totalInvalidAccessCount", $totalInvalidAccessCount);
		$this->ObjView->assign("totalInstallAccessCount", $totalInstallAccessCount);
		$this->ObjView->assign("totalExpiredAccessCount", $totalExpiredAccessCount);		
		$this->ObjView->assign("listLicenseUnauthDashboard", $listLicenseUnauthDashboard);	
		$this->ObjView->assign("listLicenseInstallDashboard", $listLicenseInstallDashboard);	
		$this->ObjView->assign("listLicenseExpiredDashboard", $listLicenseExpiredDashboard);
		$this->ObjView->assign("toDay", $toDay);
		$this->ObjView->assign("thisWeek", $thisWeek);
		$this->ObjView->assign("monthToDate", $monthToDate);
		$this->ObjView->assign("thisWeek", $thisWeek);
		$this->ObjView->assign("prevFromDate", $prevFromDate);
		$this->ObjView->assign("prevToDate", $prevToDate);
		$this->ObjView->assign("editPrivilege", $editPrivilege);
		$this->ObjView->assign("adminId", $adminId);
		$this->ObjView->display('Index.tpl');                
	}
	//END OF FUNCTION
	
	
}
