<?php
/***************************************************************************
 *                                                                          *
 * Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
 *                                                                          *
 * This  is  commercial  software,  only  users  who have purchased a valid *
 * license  and  accept  to the terms of the  License Agreement can install *
 * and use this program.                                                    *
 *                                                                          *
 ****************************************************************************
 * PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
 * "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
 ****************************************************************************/
//
//$Id: PackageController, v 1.0 2014/05/06 17:03:29
//
class PackageController extends Controller 
{
	public function indexAction()    
	{
		$ObjPackage    	= 	new PackageModel();
		$ObjLicense    	= 	new LicenseModel();
		$ObjAdminlog	= 	new AdminlogModel();
		$languageIDs	= 	$this->ObjView->languageIDs;
		$adminId		=	$this->ObjCommon->manageUserID; 
		$branchCodeSes	=	$this->ObjCommon->manageBranchCode; 
		$transID		=	$this->ObjCommon->transSession; 		
		if (isset($_POST['select_status']))
		{
			if(($transID=="") || ($transID!=$adminId))
			{
				$this->setRedirect("adminuser/transPwd/urlback/ajax/ctrlpath/package/");
			}
			else
			{
				$packageKeys		= array();
				$packageIDAr		= array();
				foreach($_POST['packageID'] as $key=>$packageValues)
				{
					$packageKeys[]	= $key;
					$packageIDAr[]	= $packageValues[0];
				}
				$params=array(
					'status'=>$_POST['select_status'],
					'packageIDs'=>$packageIDAr
				);
				if(($_POST['select_status']=="Inactive") || ($_POST['select_status']=="Deleted"))
				{
					$packageUsed	= $ObjLicense->checkPackageUsed($packageKeys);
					$packIDStr	= implode(",",$packageIDAr);
					$packKeyStr	= implode(",",$packageKeys);
					if(count($packageUsed)>0)
					{
						$this->setMessage('language.lblPackageNotUpdate','message_info');
						/* Adminlog */
						$adminAccessIP		= $this->ObjCommon->getClientIP();
						$i									= 0;
						$adminActionData					= array();
						$adminActionData[$i]['status']		= "Status Updation Failed";
						$adminActionData[$i]['response']	= "Package is Using in the License, So Cannot Change its Status";
						$adminActionData[$i]['message']		= "No Changes Found For PackageKeys: <b>".$packKeyStr."</b>";
						$i++;
						$adminActionDataStr					= serialize($adminActionData);
						$params =array(
						'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Bulk Status', 'adminActionObject'=>'Package', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
						);
						$ObjAdminlog->insertAdminlog($params);
						/* End Adminlog */
					}
					else
					{
						$ObjPackage->changeStatus($params);
						$this->setMessage('language.lblPackagestatusUpdatedSuccess','success');
						/* Adminlog */
						$adminAccessIP						= $this->ObjCommon->getClientIP();
						$i									= 0;
						$adminActionData					= array();
						$adminActionData[$i]['status']		= "Updated The Status";
						$adminActionData[$i]['response']	= "Package Bulk Status Updated Successfully";
						$adminActionData[$i]['message']		= "Updated Status of Packages<br/>";
						$adminActionData[$i]['message']		.= "<div class='grid_table00'>
						<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>PackageID</td><td width='50%' height='15%' align='left'>Package Key</td><td width='30%' height='15%' align='left'>Package Status</td></tr>";
						for($s=0;$s<count($packageIDAr);$s++)
						{
							$adminActionData[$i]['message']		.= "<tr><td align='left'><b>".$packageIDAr[$s]."</b></td><td align='left'><b>".$packageKeys[$s]."</b></td><td align='left'><b>".$_POST['select_status']."</b></td></tr>";
						}
						$adminActionData[$i]['message']		.= "</table></div><br/>";
						$i++;
						
						$adminActionDataStr					= serialize($adminActionData);

						$params =array(
						'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Bulk Status', 'adminActionObject'=>'Package', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
						);
						$ObjAdminlog->insertAdminlog($params);
						/* End Adminlog */
					}
				}
				else
				{
					$ObjPackage->changeStatus($params);
					$this->setMessage('language.lblPackagestatusUpdatedSuccess','success');
					/* Adminlog */
					$adminAccessIP						= $this->ObjCommon->getClientIP();
					$i									= 0;
					$adminActionData					= array();
					$adminActionData[$i]['status']		= "Updated The Status";
					$adminActionData[$i]['response']	= "Package Bulk Status Updated Successfully";
					$adminActionData[$i]['message']		= "Updated Status of Packages<br/>";
					$adminActionData[$i]['message']		.= "<div class='grid_table00'>
					<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>PackageID</td><td width='50%' height='15%' align='left'>Package Key</td><td width='30%' height='15%' align='left'>Package Status</td></tr>";
					for($s=0;$s<count($packageIDAr);$s++)
					{
						$adminActionData[$i]['message']		.= "<tr><td align='left'><b>".$packageIDAr[$s]."</b></td><td align='left'><b>".$packageKeys[$s]."</b></td><td align='left'><b>".$_POST['select_status']."</b></td></tr>";
					}
					$adminActionData[$i]['message']		.= "</table></div><br/>";
					$i++;
					
					$adminActionDataStr					= serialize($adminActionData);

					$params =array(
					'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Bulk Status', 'adminActionObject'=>'Package', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
					);
					$ObjAdminlog->insertAdminlog($params);
					/* End Adminlog */
				}
				$this->setRedirect();
			}
		}		
		$link	=	'package/index/';
		if (isset($_POST['search'])){			
			if ($_POST['packageName'] != ""){
				$link .= "packageName/" . $this->encodeUrlString($_POST['packageName']) . "/";
			}	
			if ($_POST['packageKey'] != ""){
				$link .= "packageKey/" . $this->encodeUrlString($_POST['packageKey']) . "/";
			}
			if ($_POST['packageSpModule'] != ""){
				$link .= "packageSpModule/" . $this->encodeUrlString($_POST['packageSpModule']) . "/";
			}			
			$this->setRedirect($link);
		}
		else{
			$sortby		=	$this->getRequestValue("sortby");
			$orderby	=	($this->getRequestValue("orderby")=="")?"asc":$this->getRequestValue("orderby");
					
			if($this->getRequestValue('packageName')){
				$packageName		= 	$this->decodeUrlString($this->getRequestValue('packageName'));
				$link.="/packageName/".$packageName;
			}		
			if($this->getRequestValue('packageKey')){
				$packageKey		= 	$this->decodeUrlString($this->getRequestValue('packageKey'));
				$link.="/packageKey/".$packageKey;
			}
			if($this->getRequestValue('packageSpModule')){
				$packageSpModule		= 	$this->decodeUrlString($this->getRequestValue('packageSpModule'));
				$link.="/packageSpModule/".$packageSpModule;
			}			
		}
		list($limitFrom, $limitTo) = $this->getPageSettings($key = 'page', $rows = 10); 
		
		$params =array(
			'limitFrom'=>$limitFrom,
			'limitTo'=>$limitTo,
			'languageIDs'=>$languageIDs,
			'sortby'=>$sortby,
			'orderby'=>$orderby,
			'packageName'=>$packageName ,'packageKey'=>$packageKey ,'packageSpModule'=>$packageSpModule 
		);
		$listPackage    = $ObjPackage->listPackage($params);	

		$resPagesCount = $this->setPagesCount($key = 'page');
		$this->ObjView->assign("page", $page);	
		$this->ObjView->assign("sortby", $sortby); $this->ObjView->assign("orderby", ($orderby=="asc")?'desc':'asc'); $this->ObjView->assign("packageName", $packageName); $this->ObjView->assign("packageKey", $packageKey); $this->ObjView->assign("packageSpModule", $packageSpModule); $this->ObjView->assign("packageStatus", $packageStatus);
		$this->ObjView->assign('listPackage', $listPackage);	
		
		$editPrivilege	=	$this->ObjCommon->hasPrivilege('package/edit/');
		$this->ObjView->assign("editPrivilege", $editPrivilege);
		$deletePrivilege	=	$this->ObjCommon->hasPrivilege('package/destroy/');
		$this->ObjView->assign("deletePrivilege", $deletePrivilege);
		
		$this->ObjView->assign("link", $link);
		$this->ObjView->display('PackageList.tpl');
	}

	public function newAction()    
	{
		$ObjPackage    	= 	new PackageModel();
		$languageIDs    = 	$this->ObjView->languageIDs;
		$ObjAdminlog	= 	new AdminlogModel();
		$adminId		=	$this->ObjCommon->manageUserID;
		if($this->ObjForm->isValid('formPackage','submitPackage'))
		{
			$ObjPackage->insert($languageIDs);
			$this->setMessage('language.lblPackageaddSuccess','success');
			/* Adminlog */
			$adminAccessIP						= $this->ObjCommon->getClientIP();
			$i									= 0;
			$adminActionData					= array();
			$adminActionData[$i]['status']		= "New";
			$adminActionData[$i]['response']	= "Successfully Added";
			$i++;

			$adminActionData[$i]['field']	= "PackageName";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $_POST['packageName'];
			$i++;

			$adminActionData[$i]['field']	= "PackageKey";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $_POST['packageKey'];
			$i++;
			
			$adminActionData[$i]['field']	= "PackageSpModule";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $_POST['packageSpModule'];
			$i++;

			$adminActionData[$i]['field']	= "PackageStatus";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $_POST['packageStatus'];
			$i++;
			
			$adminActionDataStr				= serialize($adminActionData);

			$params =array(
			'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'New', 'adminActionObject'=>'Package', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
			);
			$ObjAdminlog->insertAdminlog($params);
			/* End Adminlog */
			$this->setRedirect('package/index/');
		} 
		else
		{
			if(isset($_POST['submitCustomer']))
			{
				if(!$this->ObjForm->isValid('formPackage','submitPackage'))
				{
					/* Adminlog */
					$adminAccessIP		= $this->ObjCommon->getClientIP();
					$i									= 0;
					$adminActionData					= array();
					$adminActionData[$i]['status']		= "Insert Failed";
					$adminActionData[$i]['response']	= "Error found in form element";
					$adminActionData[$i]['message']		= "Data Cannot Be Added";
					$i++;
					$adminActionDataStr					= serialize($adminActionData);
					$params =array(
					'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'New', 'adminActionObject'=>'Package', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
					);
					$ObjAdminlog->insertAdminlog($params);
					/* End Adminlog */
				}
			}
		}
		$this->ObjView->display('PackageAdd.tpl');
	}

	public function editAction()    
	{
		$packageID =   $this->getRequestValue('id');
		$ObjPackage    	= 	new PackageModel();
		$ObjAdminlog	= 	new AdminlogModel();
		$languageIDs    = 	$this->ObjView->languageIDs;
		$adminId		=	$this->ObjCommon->manageUserID;
		$params=array(
			'packageID'=>$packageID,
			'languageIDs'=>$languageIDs
		);
		$getPackage	= $ObjPackage->getPackage($params);
		if(empty($getPackage)){
			 $this->setRedirect('package');
		}
		
		
		if($this->ObjForm->isValid('formPackage','submitPackage'))
		{	
			$ObjPackage->insert($languageIDs,$packageID);
			$this->setMessage('language.lblPackageupdatedSuccess','success');
			/* Adminlog */
			$adminAccessIP						= $this->ObjCommon->getClientIP();
			$i									= 0;
			$adminActionData					= array();
			$adminActionData[$i]['status']		= "Updated";
			$adminActionData[$i]['response']	= "Successfully Updated The Package: <b>".$getPackage['packageName']."</b>";
			$i++;
			if($getPackage['packageName']!=$_POST['packageName'])
			{
				$adminActionData[$i]['field']	= "PackageName";
				$adminActionData[$i]['Old']		= $getPackage['packageName'];
				$adminActionData[$i]['New']		= $_POST['packageName'];
				$i++;
			}
			if($getPackage['packageKey']!=$_POST['packageKey'])
			{
				$adminActionData[$i]['field']	= "PackageKey";
				$adminActionData[$i]['Old']		= $getPackage['packageKey'];
				$adminActionData[$i]['New']		= $_POST['packageKey'];
				$i++;
			}
			if($getPackage['packageStatus']!=$_POST['packageStatus'])
			{
				$adminActionData[$i]['field']	= "PackageStatus";
				$adminActionData[$i]['Old']		= $getPackage['packageStatus'];
				$adminActionData[$i]['New']		= $_POST['packageStatus'];
				$i++;
			}
			if(count($adminActionData)==1)
			{
				$adminActionData[0]['message']	= "No Changes With Form Elements OR Minor Changes For Package: <b>".$getPackage['packageName']."</b>";
			}
			$adminActionDataStr					= serialize($adminActionData);

			$params =array(
			'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Edit', 'adminActionObject'=>'Package', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
			);
			$ObjAdminlog->insertAdminlog($params);
			/* End Adminlog */
			$this->setRedirect('package/index/');
			
		} 
		else 
		{
			if(isset($_POST['submitPackage']))
			{
				if(!$this->ObjForm->isValid('formPackage','submitPackage'))
				{
					/* Adminlog */
					$adminAccessIP		= $this->ObjCommon->getClientIP();
					$i									= 0;
					$adminActionData					= array();
					$adminActionData[$i]['status']		= "Update Failed";
					$adminActionData[$i]['response']	= "Error found in form element";
					$adminActionData[$i]['message']		= "Package: <b>".$getPackage['packageName']."</b> Cannot Be Updated";
					$i++;
					$adminActionDataStr					= serialize($adminActionData);
					$params =array(
					'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Edit', 'adminActionObject'=>'Package', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
					);
					$ObjAdminlog->insertAdminlog($params);
					/* End Adminlog */
				}
			}
		}
		$this->ObjView->assignValues($getPackage);
		$this->ObjView->assign('packageID', $packageID);
		$this->ObjView->display('PackageAdd.tpl');
		
	}

	public function viewAction()    
	{
		$packageID  =   $this->getRequestValue('id');
		$ObjPackage    	= 	new PackageModel();
		$languageIDs        = $this->ObjView->languageIDs;
		$params=array(
			'packageID'=>$packageID,
			'languageIDs'=>$languageIDs
		);
		$getPackage	= $ObjPackage->getPackage($params);
		if(empty($getPackage)){
			 $this->setRedirect('package/index/');
		}
		$this->ObjView->assign('getPackage', $getPackage);
		$this->ObjView->assign('packageID', $packageID);
		$editPrivilege	=	$this->ObjCommon->hasPrivilege('package/edit/');
		$this->ObjView->assign("editPrivilege", $editPrivilege);
		$this->ObjView->assign("previousURl", $this->getPreviousURL());
		$this->ObjView->display('PackageView.tpl');
		
	}

	public function ajaxstatusAction()    
	{
		$packageID 		=   $this->getRequestValue('id');
		$packageKey		=   $this->getRequestValue('key');
		$packageKeys	= 	array($packageKey);
		$status			=   $this->getRequestValue('status');
		$ObjPackage    	= 	new PackageModel();
		$ObjLicense    	= 	new LicenseModel();
		$ObjAdminlog	= 	new AdminlogModel();
		$adminId		=	$this->ObjCommon->manageUserID;
		$params=array(
			'status'=>$status,
			'packageIDs'=>array($packageID)
		);
		if($status=="Inactive")
		{
			$packageUsed	= $ObjLicense->checkPackageUsed($packageKeys);
			if(count($packageUsed)>0)
			{
				$this->setMessage('language.lblPackageNotUpdate','message_info');
				/* Adminlog */
				$adminAccessIP		= $this->ObjCommon->getClientIP();
				$i									= 0;
				$adminActionData					= array();
				$adminActionData[$i]['status']		= "Status Updation Failed";
				$adminActionData[$i]['response']	= "Package is Using in the License, So Cannot Change its Status";
				$adminActionData[$i]['message']		= "No Changes Found For Package: <b>".$packageKey."</b>";
				$i++;
				$adminActionDataStr					= serialize($adminActionData);
				$params =array(
				'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Status', 'adminActionObject'=>'Package', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
				);
				$ObjAdminlog->insertAdminlog($params);
				/* End Adminlog */
			}
			else
			{
				$changeStatus	= $ObjPackage->changeStatus($params);
				$this->setMessage('language.lblPackagestatusUpdatedSuccess','success');
				/* Adminlog */
				$adminAccessIP						= $this->ObjCommon->getClientIP();
				$i									= 0;
				$adminActionData					= array();
				$adminActionData[$i]['status']		= "Updated The Status";
				$adminActionData[$i]['response']	= "Package Status Updated Successfully";
				$adminActionData[$i]['message']		= "Updated Status of Package<br/>";
				$adminActionData[$i]['message']		.= "<div class='grid_table00'>
				<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>PackageID</td><td width='50%' height='15%' align='left'>Package Key</td><td width='30%' height='15%' align='left'>Package Status</td></tr><tr><td align='left'><b>".$packageID."</b></td><td align='left'><b>".$packageKey."</b></td><td align='left'><b>".$status."</b></td></tr></table></div><br/>";
				$i++;
				$adminActionDataStr					= serialize($adminActionData);

				$params =array(
				'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Status', 'adminActionObject'=>'Package', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
				);
				$ObjAdminlog->insertAdminlog($params);
				/* End Adminlog */
			}
		}
		else
		{
			$changeStatus	= $ObjPackage->changeStatus($params);
			$this->setMessage('language.lblPackagestatusUpdatedSuccess','success');
			/* Adminlog */
			$adminAccessIP						= $this->ObjCommon->getClientIP();
			$i									= 0;
			$adminActionData					= array();
			$adminActionData[$i]['status']		= "Updated The Status";
			$adminActionData[$i]['response']	= "Package Status Updated Successfully";
			$adminActionData[$i]['message']		= "Updated Status of Package<br/>";
			$adminActionData[$i]['message']		.= "<div class='grid_table00'>
			<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>PackageID</td><td width='50%' height='15%' align='left'>Package Key</td><td width='30%' height='15%' align='left'>Package Status</td></tr><tr><td align='left'><b>".$packageID."</b></td><td align='left'><b>".$packageKey."</b></td><td align='left'><b>".$status."</b></td></tr></table></div><br/>";
			$i++;
			$adminActionDataStr					= serialize($adminActionData);

			$params =array(
			'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Status', 'adminActionObject'=>'Package', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
			);
			$ObjAdminlog->insertAdminlog($params);
			/* End Adminlog */
		}

	}

	public function destroyAction()    
	{
		$packageID  	= $this->getRequestValue('id');
		$packageKey		= $this->getRequestValue('key');
		$packageKeys	= array($packageKey);
		$ObjAdminlog	= new AdminlogModel();
		$adminId		= $this->ObjCommon->manageUserID;
		if(isset($packageID))
		{
			$ObjPackage    	= 	new PackageModel();
			$ObjLicense    	= 	new LicenseModel();
			$params=array(
				'status'=>'Deleted',
				'packageIDs'=>array($packageID)
			);
			$packageUsed	= $ObjLicense->checkPackageUsed($packageKeys);
			if(count($packageUsed)>0)
			{
				$this->setMessage('language.lblPackageNotUpdate','message_info');
				/* Adminlog */
				$adminAccessIP		= $this->ObjCommon->getClientIP();
				$i									= 0;
				$adminActionData					= array();
				$adminActionData[$i]['status']		= "Delete Failed";
				$adminActionData[$i]['response']	= "Package is Using in the License, So Cannot Change its Status";
				$adminActionData[$i]['message']		= "No Changes Found For Package: <b>".$packageKey."</b>";
				$i++;
				$adminActionDataStr					= serialize($adminActionData);
				$params =array(
				'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Delete', 'adminActionObject'=>'Package', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
				);
				$ObjAdminlog->insertAdminlog($params);
				/* End Adminlog */
			}
			else
			{
				$changeStatus = $ObjPackage->changeStatus($params);
				$this->setMessage('language.lblPackagedeletedSuccess','success');
				/* Adminlog */
				$adminAccessIP						= $this->ObjCommon->getClientIP();
				$i									= 0;
				$adminActionData					= array();
				$adminActionData[$i]['status']		= "Deleted";
				$adminActionData[$i]['response']	= "Package Deleted Successfully";
				$adminActionData[$i]['message']		= "Deleted Package<br/>";
				$adminActionData[$i]['message']		.= "<div class='grid_table00'>
				<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>PackageID</td><td width='50%' height='15%' align='left'>Package Key</td><td width='30%' height='15%' align='left'>Package Status</td></tr><tr><td align='left'><b>".$packageID."</b></td><td align='left'><b>".$packageKey."</b></td><td align='left'><b>Deleted</b></td></tr></table></div><br/>";
				$i++;
				
				$adminActionDataStr					= serialize($adminActionData);

				$params =array(
				'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Delete', 'adminActionObject'=>'Package', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
				);
				$ObjAdminlog->insertAdminlog($params);
				/* End Adminlog */
			}
			$this->setRedirect('package/index/');
			
		}
	}
}
