<?php
/***************************************************************************
 *                                                                          *
 * Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
 *                                                                          *
 * This  is  commercial  software,  only  users  who have purchased a valid *
 * license  and  accept  to the terms of the  License Agreement can install *
 * and use this program.                                                    *
 *                                                                          *
 ****************************************************************************
 * PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
 * "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
 ****************************************************************************/
//
//$Id: RolesController.php, v 1.0 2011/06/14 20:52:11
//
class RolesController extends Controller
{
    //LISTING ROLES
    public function indexAction()
    {
		$ObjRoles = new RolesModel();
        $this->ObjView->assign("editPrivilege", $this->ObjCommon->hasPrivilege('roles/edit/'));
        $deletePrivilege = $this->ObjCommon->hasPrivilege('roles/destroy/');
        $this->ObjView->assign("deletePrivilege", $deletePrivilege);
        list($limitFrom, $limitTo) = $this->getPageSettings($key = 'page', $rows = 10);
        $resListUserTypes = $ObjRoles->listUserTypes($limitFrom, $limitTo);
        $resPagesCount    = $this->setPagesCount($key = 'page');
		$ObjAdminlog		= new AdminlogModel();
		$adminId			= $this->ObjCommon->manageUserID; 
        if (isset($_POST['userTypeStatus']))
        {
			$userTypeNames		= array();
			$userTypeIDs		= array();
			foreach($_POST['userTypeIDs'] as $key=>$userTypeValues)
			{
				$userTypeNames[]	= $key;
				$userTypeIDs[]		= $userTypeValues[0];
			}
            if(($checkMainAdmin = array_search('1',$userTypeIDs)) !== false) 
			{
				//Remove if main admin typeid is present
				unset($userTypeIDs[$checkMainAdmin]);
			}
			//Check current loggedin Admin typeidid 
			if(($checkCurrentAdmin = array_search($this->ObjCommon->mangeUserTypeID,$userTypeIDs)) !== false) 
			{
				//Remove if current admin id is present
				unset($userTypeIDs[$checkCurrentAdmin]);
			}
			if(!empty($userTypeIDs))
			{
				$resUserTypeStatus = $ObjRoles->changeUserTypeStatus($userTypeIDs, $_POST['userTypeStatus'], $deletePrivilege);
				/* Adminlog */
				$adminAccessIP						= $this->ObjCommon->getClientIP();
				$i									= 0;
				$adminActionData					= array();
				
				if ($_POST['userTypeStatus'] == "Deleted")
				{
					if ($resUserTypeStatus)
					{
						$msgRoleNoDeleteMultiple = $this->getLanguageValue("msgRoleNoDeleteMultiple");
						$msgRoleNoDeleteMultiple = $resUserTypeStatus . " " . $msgRoleNoDeleteMultiple;
						$this->setMessage($msgRoleNoDeleteMultiple, "message_success");
						
						$adminActionData[$i]['status']		= "Status Updation Failed";
						$adminActionData[$i]['response']	= "Cannot be deleted, Users exists under this Role";
						$adminActionData[$i]['message']		= "No Changes Found";
						$i++;
						$adminActionDataStr					= serialize($adminActionData);
						$params =array(
						'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Bulk Status', 'adminActionObject'=>'Roles', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
						);
						$ObjAdminlog->insertAdminlog($params);
						/* End Adminlog */

					}
					else
					{
						$this->setMessage("language.msgRolesDelete", "message_success");
						
						$adminActionData[$i]['status']		= "Updated The Status";
						$adminActionData[$i]['response']	= "Roles Bulk Status Updated Successfully";
						$adminActionData[$i]['message']		= "Updated Status of UserType<br/>";
						$adminActionData[$i]['message']		.= "<div class='grid_table00'>
						<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>UserTypeIDs</td><td width='50%' height='15%' align='left'>UserType Name</td><td width='30%' height='15%' align='left'>UserType Status</td></tr>";
						for($s=0;$s<count($userTypeIDs);$s++)
						{
							$adminActionData[$i]['message']		.= "<tr><td align='left'><b>".$userTypeIDs[$s]."</b></td><td align='left'><b>".$userTypeNames[$s]."</b></td><td align='left'><b>".$_POST['userTypeStatus']."</b></td></tr>";
						}
						$adminActionData[$i]['message']		.= "</table></div><br/>";
						$i++;
							
						$adminActionDataStr					= serialize($adminActionData);

						$params =array(
						'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Bulk Status', 'adminActionObject'=>'Roles', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
						);
						$ObjAdminlog->insertAdminlog($params);
						/* End Adminlog */
					}
				}
				else
				{
					$this->setMessage("language.msgRolesUpdateStatus", "message_success");
					
					$adminActionData[$i]['status']		= "Updated The Status";
					$adminActionData[$i]['response']	= "Roles Bulk Status Updated Successfully";
					$adminActionData[$i]['message']		= "Updated Status of UserType<br/>";
					$adminActionData[$i]['message']		.= "<div class='grid_table00'>
					<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>UserTypeIDs</td><td width='50%' height='15%' align='left'>UserType Name</td><td width='30%' height='15%' align='left'>UserType Status</td></tr>";
					for($s=0;$s<count($userTypeIDs);$s++)
					{
						$adminActionData[$i]['message']		.= "<tr><td align='left'><b>".$userTypeIDs[$s]."</b></td><td align='left'><b>".$userTypeNames[$s]."</b></td><td align='left'><b>".$_POST['userTypeStatus']."</b></td></tr>";
					}
					$adminActionData[$i]['message']		.= "</table></div><br/>";
					$i++;
						
					$adminActionDataStr					= serialize($adminActionData);

					$params =array(
					'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Bulk Status', 'adminActionObject'=>'Roles', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
					);
					$ObjAdminlog->insertAdminlog($params);
					/* End Adminlog */
				}
			}	
            $PreviousURL = $this->getPreviousURL();
            $this->setRedirect($PreviousURL);
        }
        $this->ObjView->assign("curr_page", $this->getRequestValue('page'));
        $this->ObjView->assign("resListUserTypes", $resListUserTypes);
        $this->ObjView->display('Roles.tpl');
    }
    //ADD ROLES
    public function newAction()
    {
		$ObjRoles    	= new RolesModel();
        $languageIDs  	= $this->ObjView->languageIDs;
        $userTypeID  	= $this->getRequestValue("id");
        $this->ObjView->assign('PreviousURL', $this->getPreviousURL());	
		$ObjAdminlog	= new AdminlogModel();
		$adminId		= $this->ObjCommon->manageUserID; 
        if ($this->ObjForm->isValid('formRoles', 'submitRoles'))
        {
            $ObjRoles->saveUserRoles();
            $objCache    = new Cache("file");
            foreach($languageIDs['All'] as $langIds)
            {
                $objCache->delete('m_menu_list_' . $userTypeID . '_' . $langIds);
            }
            $this->setMessage("language.msgAdminRoleAdd", "message_success");
			/* Adminlog */
			$adminAccessIP						= $this->ObjCommon->getClientIP();
			$i									= 0;
			$adminActionData					= array();
			$adminActionData[$i]['status']		= "New";
			$adminActionData[$i]['response']	= "Successfully Added";
			$i++;

			$adminActionData[$i]['field']	= "UserTypeName";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $_POST['userTypeName'];
			$i++;
			
			$adminActionData[$i]['field']	= "UserTypeStatus";
			$adminActionData[$i]['Old']		= "";
			$adminActionData[$i]['New']		= $_POST['userTypeStatus'];
			$i++;

			$adminActionDataStr				= serialize($adminActionData);

			$params =array(
			'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'New', 'adminActionObject'=>'Roles', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
			);
			$ObjAdminlog->insertAdminlog($params);
			/* End Adminlog */
            $this->setRedirect("/roles/index/");
        }
		else
		{
			if(isset($_POST['submitRoles']))
			{
				if(!$this->ObjForm->isValid('formRoles','submitRoles'))
				{
					/* Adminlog */
					$adminAccessIP		= $this->ObjCommon->getClientIP();
					$i									= 0;
					$adminActionData					= array();
					$adminActionData[$i]['status']		= "Insert Failed";
					$adminActionData[$i]['response']	= "Error found in form element";
					$adminActionData[$i]['message']		= "Data Cannot Be Added";
					$i++;
					$adminActionDataStr					= serialize($adminActionData);
					$params =array(
					'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'New', 'adminActionObject'=>'Roles', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
					);
					$ObjAdminlog->insertAdminlog($params);
					/* End Adminlog */
				}
			}
		}
		$resTreeRolesModules = $this->listRolesData();
        $this->ObjView->assign("resTreeRolesModules", $resTreeRolesModules);
        $this->ObjView->display('RolesAdd.tpl');
    }
    //EDIT ROLES
    public function editAction()
    {     
		$ObjRoles    = new RolesModel();
        $languageIDs = $this->ObjView->languageIDs;
        $userTypeID  = $this->getRequestValue("id");
        $this->ObjView->assign("userTypeID", $userTypeID);
        $resUserTypeDetails = $ObjRoles->getUserTypeDetails($userTypeID);
		$ObjAdminlog	= new AdminlogModel();
		$adminId		= $this->ObjCommon->manageUserID; 
        if (empty($resUserTypeDetails))
        {
            $this->setRedirect("/roles/index/");
        }
		//Restriction Admin User type & Current user edit
		if(($userTypeID != 1 && $userTypeID == $this->ObjCommon->mangeUserTypeID) || ($userTypeID == 1 &&  $this->ObjCommon->mangeUserTypeID!=1)) 
		{
			$this->setRedirect("/roles/index/");
		}			
        $this->ObjView->assign('PreviousURL', $this->getPreviousURL());
        if ($this->ObjForm->isValid('formRoles', 'submitRoles'))
        {
            if ($userTypeID == 1 || $userTypeID == $this->ObjCommon->mangeUserTypeID)
            {
                if ($userTypeID == 1)
				$_POST['adminMode'] = 'Administrator';
				
				$_POST['userTypeStatus'] = 'Active';
            }
			$_POST['userTypeID'] = $userTypeID;
			$ObjRoles->saveUserRoles();
            $objCache    = new Cache("file");
            foreach($languageIDs['All'] as $langIds)
            {
                $objCache->delete('m_menu_list_' . $userTypeID . '_' . $langIds);
            }
            $this->setMessage("language.msgAdminRoleUpdate", "message_success");
			/* Adminlog */
			$adminAccessIP						= $this->ObjCommon->getClientIP();
			$i									= 0;
			$adminActionData					= array();
			$adminActionData[$i]['status']		= "Updated";
			$adminActionData[$i]['response']	= "Successfully Updated The UserType: <b>".$resUserTypeDetails['userTypeName']."<b>";
			$i++;
			if($resUserTypeDetails['userTypeName']!=$_POST['userTypeName'])
			{
				$adminActionData[$i]['field']	= "UserTypeName";
				$adminActionData[$i]['Old']		= $resUserTypeDetails['userTypeName'];
				$adminActionData[$i]['New']		= $_POST['userTypeName'];
				$i++;
			}
			if($resUserTypeDetails['userTypeStatus']!=$_POST['userTypeStatus'])
			{
				$adminActionData[$i]['field']	= "UserTypeStatus";
				$adminActionData[$i]['Old']		= $resUserTypeDetails['userTypeStatus'];
				$adminActionData[$i]['New']		= $_POST['userTypeStatus'];
				$i++;
			}
			
			if(count($adminActionData)==1)
			{
				$adminActionData[0]['message']	= "No Changes for Form Elements OR Minor Changes";
			}
			$adminActionDataStr					= serialize($adminActionData);

			$params =array(
			'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Edit', 'adminActionObject'=>'Roles', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
			);
			$ObjAdminlog->insertAdminlog($params);
			/* End Adminlog */
            $this->setRedirect("/roles/index/");
        }
		else 
		{
			if(isset($_POST['submitRoles']))
			{
				if(!$this->ObjForm->isValid('formRoles','submitRoles'))
				{
					/* Adminlog */
					$adminAccessIP		= $this->ObjCommon->getClientIP();
					$i									= 0;
					$adminActionData					= array();
					$adminActionData[$i]['status']		= "Update Failed";
					$adminActionData[$i]['response']	= "Error found in form element";
					$adminActionData[$i]['message']		= "UserType: <b>".$resUserTypeDetails['userTypeName']."<b> Cannot Be Updated";
					$i++;
					$adminActionDataStr					= serialize($adminActionData);
					$params =array(
					'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Edit', 'adminActionObject'=>'Roles', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
					);
					$ObjAdminlog->insertAdminlog($params);
					/* End Adminlog */
				}
			}
		}
        $resPrivileges = $ObjRoles->getPrivilageFile($resUserTypeDetails['userTypeID']);
		$params		= array
						(
							'privilegeData' 	=> $resPrivileges
						);
		$resTreeRolesModules = $this->listRolesData($params);	
		$this->ObjView->assignValues($resUserTypeDetails);
        $this->ObjView->assign("resTreeRolesModules", $resTreeRolesModules);
        $this->ObjView->assign("resPrivileges", json_encode($resPrivileges));
        $this->ObjView->assign("userTypeID", $userTypeID);
        $this->ObjView->display('RolesAdd.tpl');
    }
    //DELETE ROLES
    public function destroyAction()
    {
		$ObjRoles       = new RolesModel();
        $userTypeID     = $this->getRequestValue("id");
		$name       	= $this->getRequestValue("name");
		$ObjAdminlog	= new AdminlogModel();
		$adminId		= $this->ObjCommon->manageUserID; 
		if($userTypeID>1 && $userTypeID!=$this->ObjCommon->mangeUserTypeID)
		{
			$resUserTypeStatus = $ObjRoles->changeUserTypeStatus(array($userTypeID), $userTypeStatus = "Deleted", $this->ObjCommon->hasPrivilege('roles/destroy/'));
			/* Adminlog */
			$adminAccessIP						= $this->ObjCommon->getClientIP();
			$i									= 0;
			$adminActionData					= array();
			$adminActionData[$i]['status']		= "Deleted";
			$adminActionData[$i]['response']	= "Role Deleted Successfully";
			$adminActionData[$i]['message']		= "Deleted UserType<br/>";
			$adminActionData[$i]['message']		.= "<div class='grid_table00'>
			<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>UserTypeID</td><td width='50%' height='15%' align='left'>UserType Name</td><td width='30%' height='15%' align='left'>UserType Status</td></tr><tr><td align='left'><b>".$userTypeID."</b></td><td align='left'><b>".$name."</b></td><td align='left'><b>Deleted</b></td></tr></table></div><br/>";
			$i++;
			
			$adminActionDataStr					= serialize($adminActionData);

			$params =array(
			'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Delete', 'adminActionObject'=>'Roles', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
			);
			$ObjAdminlog->insertAdminlog($params);
			/* End Adminlog */
			$this->setMessage("language.msgRoleDelete", "message_success");
		}	
		else
		{
			/* Adminlog */
			$adminAccessIP		= $this->ObjCommon->getClientIP();
			$i									= 0;
			$adminActionData					= array();
			$adminActionData[$i]['status']		= "Status Updation Failed";
			$adminActionData[$i]['response']	= "The Role: <b>".$name."<b> is Currently Active";
			$adminActionData[$i]['message']		= "No Changes Found";
			$i++;
			$adminActionDataStr					= serialize($adminActionData);
			$params =array(
			'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Delete', 'adminActionObject'=>'Roles', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
			);
			$ObjAdminlog->insertAdminlog($params);
			/* End Adminlog */
		}
        $this->setRedirect($this->getPreviousURL());
    }
    //FUNCTION to change the status of user type
    public function ajaxstatusAction()
    {
        $ObjRoles            	= new RolesModel();
        $POST['changeStatus']	= $_POST['newstatus'];
		$name					= $_POST['name'];
		$ObjAdminlog			= new AdminlogModel();
		$adminId				= $this->ObjCommon->manageUserID; 
		if($_POST['id']>1 && $_POST['id']!=$this->ObjCommon->mangeUserTypeID)
		{
			$changestatus         = $ObjRoles->changeRoleStatus($_POST['id'], $POST['changeStatus']);
			/* Adminlog */
			$adminAccessIP						= $this->ObjCommon->getClientIP();
			$i									= 0;
			$adminActionData					= array();
			$adminActionData[$i]['status']		= "Updated The Status";
			$adminActionData[$i]['response']	= "Roles Status Updated Successfully";
			$adminActionData[$i]['message']		= "Updated Status of UserType<br/>";
			$adminActionData[$i]['message']		.= "<div class='grid_table00'>
			<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>UserTypeID</td><td width='50%' height='15%' align='left'>UserType Name</td><td width='30%' height='15%' align='left'>UserType Status</td></tr><tr><td align='left'><b>".$_POST['id']."</b></td><td align='left'><b>".$name."</b></td><td align='left'><b>".$POST['changeStatus']."</b></td></tr></table></div><br/>";
			$i++;
			$adminActionDataStr					= serialize($adminActionData);

			$params =array(
			'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Status', 'adminActionObject'=>'Roles', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
			);
			$ObjAdminlog->insertAdminlog($params);
			/* End Adminlog */
			$this->setMessage("language.msgStatus", "message_success");
			if ($changestatus)
				echo 1;
		}		
		else
		{
			/* Adminlog */
			$adminAccessIP		= $this->ObjCommon->getClientIP();
			$i									= 0;
			$adminActionData					= array();
			$adminActionData[$i]['status']		= "Status Updation Failed";
			$adminActionData[$i]['response']	= "The Role: <b>".$name."<b> is Currently Active";
			$adminActionData[$i]['message']		= "No Changes Found";
			$i++;
			$adminActionDataStr					= serialize($adminActionData);
			$params =array(
			'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Status', 'adminActionObject'=>'Roles', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
			);
			$ObjAdminlog->insertAdminlog($params);
			/* End Adminlog */
		}
    }
    //END of function 		
    function checkRoleSelect()
    {
        if (empty($_POST['moduleIDs']))
            return false;
        return true;
    }
	//List Roles Data
	public function listRolesData($params=array())
	{
		extract($params);
		$ObjRoles             = new RolesModel();
		//Roles Schema
		$schemaRoles = $ObjRoles->includeRolesSchema();
		$params		= array
						(
							'schemaData' 	=> $schemaRoles['permissions'],								
							'languageXml' 	=> $this->ObjView->_languageXML,
							'treeString' 	=> '',
							'treeLevel' 	=> 0,
							'parent' 		=> 0,
							'parents' 		=> array(),
							'privilegeData' => $privilegeData
						);
		return $this->listRolesItems($params);
	}
	//List Roles Items
	private function listRolesItems($params)
	{
		extract($params);
		
		if($treeLevel==0)
		{
			$treeString 		= '<ul class="roles_listing treeview" id="tree">';
		}
		else 
		{
			$treeString 		= '<ul style="display: none;">';
		}		
		$treeLevel++;
		if(!empty($schemaData))
		{
			foreach($schemaData as $arrayKey => $schema)	
			{
				$currMenuURL					= $schema['adminModuleURLKey'];
				$currAdminModuleLabel			= $schema['adminModuleLabel'];
				$currRootLevel					= $schema['rootLevel'];
				$currAdminSectionKey			= $schema['adminSectionKey'];
				$inputType						= $schema['inputType'];
				$subText						= $schema['subText'];
				$adminModuleStatus				= $schema['adminModuleStatus'];
				$xmlLabel						= $languageXml[$currAdminModuleLabel];
				$currAdminModuleCaption 		= ($xmlLabel!='')?$xmlLabel:$currAdminModuleLabel;				
				$currAdminModuleCaption 		= $xmlLabel;				
				$resSubRolesCount 				= count($schema['adminSubMenu']);
				$checked						= '';	
				//Checking Addon Module
				if($currAdminSectionKey!='' && !constant($currAdminSectionKey))
				{
					continue;
				}
				//Checking Status
				if($adminModuleStatus!='Active')
				{
					continue;
				}
				if($privilegeData && $resSubRolesCount==0 && in_array($currMenuURL,$privilegeData))
				{
					$checked = 'checked';
				}
				if($resSubRolesCount>0)
				{
		   			$treeString 	   	   .= '<li>';
					$checkboxClass = "module_parent";
				}
				else 
				{
					//For the last Element
				    if($schema==$schema[count($schema)-1])
					{
						$treeString   .= '<li class="last">';
					}
					else 
					{
					   $treeString   .= '<li>';
					}
					$checkboxClass = "module_child";
				}	
				if(!in_array("roleID_".$parent,$parents))
				{
					$parents[]  = "roleID_".$parent;
				}	
				if($inputType=='')
				{
					$inputField = "checkbox";
				}
				elseif($inputType=='radio')
				{
					$inputField = "radio";
				}
				$treeString 	   		   .= '<input class="moduleGroupClass_all '.$checkboxClass.'" parents="'.implode(",",$parents).'" id="roleID_'.$parent."_".$arrayKey.'" name="moduleIDs[]" type="checkbox" attrtype="'.$inputField.'" value="'.$currMenuURL.'"'.$checked.'/>';
				$treeString 	  		   .= '&nbsp;'.$currAdminModuleCaption.'';
				if($subText)
				{
					if($resSubRolesCount>0)
					{
						$treeString 	  		   .= '[ '.$languageXml[$subText].' ]';
					}
					else
					{
						$treeString 	  		   .= '<span class="sub-text">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;( '.$languageXml[$subText].' )</span>';
					}	
				}
				if($resSubRolesCount>0)
				{																				
					$params	= array
								(
									'schemaData' 		=> $schema['adminSubMenu'],				
									'treeString' 		=> $treeString,				
									'treeLevel' 		=> $treeLevel,				
									'languageXml' 		=> $languageXml,				
									'campignEnable' 	=> $campignEnable,	
									'parent' 			=> $parent."_".$arrayKey,
									'parents' 			=> $parents,
									'privilegeData' 	=> $privilegeData
								);
					
					$treeString 		.= $this->listRolesItems($params);
					//$parent = $arrayKey;
				}
				$treeString 			   .= '</li>';					
			}					
		}			
		$treeString 				   .= '</ul>';	
		return $treeString;
	}	
}