<?php
/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/
//
//$Id: SettingsController.php, v 1.0 2011/06/14 20:52:11
//
class SettingsController extends Controller {

    private $campaignSync = TRUE;

    public function indexAction() 
	{
		$ObjSettings	= new SettingsModel();       
		$groupID = $this->getRequestValue("id");
		$languageIDs	=   $this->ObjView->languageIDs;
		$languageIDs	= $languageIDs['AllList'];
		$ObjAdminlog	= new AdminlogModel();
		$adminId		= $this->ObjCommon->manageUserID; 
        if (!$groupID)
            $this->setRedirect("settings/index/id/1/");
		//Privilege	
		$this->ObjCommon->askPrivilege('settings/index/id/'.$groupID.'/');

        $rsSettings = $ObjSettings->listSettingsByGroupId($groupID);
        $rsSettingsGroup = $ObjSettings->getSettingsGroupDetails($groupID);
        $rsAllSettingsGroup = $ObjSettings->listSettingsGroup();
				
		if (!$rsSettingsGroup)
            $this->setRedirect("settings/index/id/1/");			
		
		if(($groupID==8)||($groupID==9)||($groupID==10)){
			$check=isset($_POST['submitSettings']) ? $_POST['submitSettings']  : '';	
		}else{
			$check=$this->ObjForm->isValid('formSettings', 'submitSettings');
		}
                
        if ($check && $groupID)
		{   
            $ObjSettings->saveSettingsDetails($_POST, $groupID);
            $ObjSettings->writeSettingsToXMLFile();            
            $this->setMessage("language.msgSettingsUpdate", "success");   			
			/* Adminlog */
			$adminAccessIP						= $this->ObjCommon->getClientIP();
			$i									= 0;
			$adminActionData					= array();
			$adminActionData[$i]['status']		= "Updated";
			$adminActionData[$i]['response']	= "Settings Details Successfully Updated";
			$i++;
			
			$keyArray	= array();
			$valueArray	= array();
			foreach($rsSettings as $key=>$values)
			{
				$keyArray[$key]	= $values['settingsKey'];
				$valueArray[$key]	= $values['settingsValue'];  				
			}
			for($k=0;$k<count($keyArray);$k++)
			{
				if($valueArray[$k]!=$_POST[$keyArray[$k]])
				{
					$adminActionData[$i]['field']	= $keyArray[$k];
					$adminActionData[$i]['Old']		= $valueArray[$k];
					$adminActionData[$i]['New']		= $_POST[$keyArray[$k]];
					$i++;
				}
			}
			
			if(count($adminActionData)==1)
			{
				$adminActionData[0]['message']	= "No Changes for Form Elements OR Minor Changes";
			}
			$adminActionDataStr					= serialize($adminActionData);

			$params =array(
			'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Edit', 'adminActionObject'=>'Settings', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
			);
			$ObjAdminlog->insertAdminlog($params);
			/* End Adminlog */
            $this->setRedirect("settings/index/id/" . $groupID . "/");
        }
		else 
		{
			if(isset($_POST['submitSettings']))
			{
				if(!$this->ObjForm->isValid('formSettings','submitSettings'))
				{
					/* Adminlog */
					$adminAccessIP		= $this->ObjCommon->getClientIP();
					$i									= 0;
					$adminActionData					= array();
					$adminActionData[$i]['status']		= "Update Failed";
					$adminActionData[$i]['response']	= "Error found in form element";
					$adminActionData[$i]['message']		= "No Changes for Form Elements";
					$i++;
					$adminActionDataStr					= serialize($adminActionData);
					$params =array(
					'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Edit', 'adminActionObject'=>'Settings', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
					);
					$ObjAdminlog->insertAdminlog($params);
					/* End Adminlog */
				}
			}
		}

        $this->ObjView->assignValues($rsSettingsGroup);
        $this->ObjView->assign("rsSettings", $rsSettings);
        $this->ObjView->assign("rsSettingsGroup", $rsAllSettingsGroup);
        $this->ObjView->assign("groupID", $groupID);
        $this->ObjView->display('Settings.tpl');
    }

   
}
