<?php
/***************************************************************************
 *                                                                          *
 * Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
 *                                                                          *
 * This  is  commercial  software,  only  users  who have purchased a valid *
 * license  and  accept  to the terms of the  License Agreement can install *
 * and use this program.                                                    *
 *                                                                          *
 ****************************************************************************
 * PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
 * "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
 ****************************************************************************/
//
//$Id: CustomerModel, v 1.0 2014/05/02 12:11:15
//All functions 
//
class CustomerModel extends Model
{
	
	/* List Customer */
	public function listCustomer($params=array(),$branchCodeSes="")
	{
		extract($params);
		if ($limitTo)
			$selectFields .= " SQL_CALC_FOUND_ROWS ";	
		if($branchCodeSes!="")
		{
			$sql=" 
				SELECT 
					".$selectFields."
					customer.customerID as customerID, customer.customerFirstName as customerFirstName, customer.customerLastName as customerLastName, customer.customerEmailID as customerEmailID, customer.customerPhone as customerPhone, customer.customerAddress1 as customerAddress1, customer.customerAddress2 as customerAddress2, customer.customerCity as customerCity, customer.stateID as stateID, customer.countryID  as countryID, customer.customerPincode  as customerPincode, customer.registerDate as registerDate, customer.customerAssociate as customerAssociate, customer.customerAddEmailID as customerAddEmailID, customer.customerOtherNotes as customerOtherNotes, customer.customerCompany as customerCompany, customer.province as province, customer.customerFax as customerFax, customer.customerStatus as customerStatus, 
					cntryDet.countryName as customerCountry, 
					staDet.stateName as customerState 
				FROM 
						customer_info AS customer 
						LEFT	JOIN	
							site_licences AS license ON customer.customerID=license.customerID 
						LEFT	JOIN	
							".DB_PREFIX."countries AS cntry ON customer.countryID=cntry.countryID 
						LEFT	JOIN	
							".DB_PREFIX."country_details AS	cntryDet ON	cntryDet.countryID=cntry.countryID 
						LEFT	JOIN	
							".DB_PREFIX."state_details AS staDet ON staDet.stateID=customer.stateID 
				WHERE 1 AND license.branchCode='".$branchCodeSes."' ";		
		}
		else
		{
			$sql=" 
			SELECT 
				".$selectFields."
				customer.customerID as customerID, customer.customerFirstName as customerFirstName, customer.customerLastName as customerLastName, customer.customerEmailID as customerEmailID, customer.customerPhone as customerPhone, customer.customerAddress1 as customerAddress1, customer.customerAddress2 as customerAddress2, customer.customerCity as customerCity, customer.stateID as stateID, customer.countryID  as countryID, customer.customerPincode  as customerPincode, customer.registerDate as registerDate, customer.customerAssociate as customerAssociate, customer.customerAddEmailID as customerAddEmailID, customer.customerOtherNotes as customerOtherNotes, customer.customerCompany as customerCompany, customer.province as province, customer.customerFax as customerFax, customer.customerStatus as customerStatus, 
				cntryDet.countryName as customerCountry, 
				staDet.stateName as customerState 
			FROM 
					customer_info AS customer 
					LEFT	JOIN	
						".DB_PREFIX."countries AS cntry ON customer.countryID=cntry.countryID 
					LEFT	JOIN	
						".DB_PREFIX."country_details AS	cntryDet ON	cntryDet.countryID=cntry.countryID 
					LEFT	JOIN	
						".DB_PREFIX."state_details AS staDet ON staDet.stateID=customer.stateID 
			WHERE 1 ";		
		}
		if(isset($customerFirstName) && $customerFirstName!='')
		{
			$sql.= "AND customerFirstName like '%".$customerFirstName."%' ";
		}			
		if(isset($customerLastName) && $customerLastName!='')
		{
			$sql.= "AND customerLastName like '%".$customerLastName."%' ";
		}			
		if(isset($customerEmailID) && $customerEmailID!='')
		{
			$sql.= "AND customerEmailID like '%".$customerEmailID."%' ";
		}			
		if(isset($customerPhone) && $customerPhone!='')
		{
			$sql.= "AND customerPhone like '%".$customerPhone."%' ";
		}								
		if(isset($countryID) && $countryID!='')
		{
			$sql.= "AND customer.countryID ='".$countryID."' ";
		}			
		if ((isset($fromDate) && isset($toDate)) && ($fromDate != '' && $toDate != ''))
		{
			$sql .= "AND ( DATEDIFF('" . $fromDate . "',registerDate)<=0 AND DATEDIFF('" . $toDate . "',registerDate)>=0 )";
		}
		else if ((isset($fromDate)) && ($fromDate!= ''))
		{
			$sql .= " 	AND ( DATEDIFF( '" . $fromDate . "',registerDate)<=0 ) ";
		}
		else if ((isset($toDate)) && ($toDate != ''))
		{
			$sql .= " AND ( DATEDIFF('" . $toDate . "',registerDate)>=0 )  ";
		}
		if(isset($customerStatus) && $customerStatus!='')
		{
			$sql.= "AND customerStatus ='".$customerStatus."' ";
		}
		else 
		{
			$sql.= "AND customerStatus !='Deleted' ";
		}	
	
		if($branchCodeSes!="")
		{
			$sql .= "Group by customer.customerID ";
		}
		if($orderby && $sortby)
		{
			$sql.="ORDER BY ".substr($sortby, 5)." ".$orderby." ";
		}
		if ($limitTo)
		{
			$sql .= "LIMIT " . $limitFrom . ", " . $limitTo . "
			";
		}
		return  $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);
	}

	/* To Get Customer Details */
	public function getCustomer($params=array())
	{
		extract($params);
		if($adminId>1)
		{
			$sql=" 
				SELECT 
					customer.customerID as customerID, customer.customerFirstName as customerFirstName, customer.customerLastName as customerLastName, customer.customerEmailID as customerEmailID, customer.customerPhone as customerPhone, customer.customerAddress1 as customerAddress1, customer.customerAddress2 as customerAddress2, customer.customerCity as customerCity, customer.stateID as stateID, customer.countryID  as countryID, customer.customerPincode  as customerPincode, customer.registerDate as registerDate, customer.customerAssociate as customerAssociate, customer.customerAddEmailID as customerAddEmailID, customer.customerOtherNotes as customerOtherNotes, customer.customerCompany as customerCompany, customer.province as province, customer.customerFax as customerFax, customer.customerStatus as customerStatus,    
					cntryDet.countryName as customerCountry, 
					staDet.stateName as customerState 
				FROM 
						customer_info AS customer 
						LEFT JOIN	
							site_licences as license ON customer.customerID=license.customerID 
						LEFT JOIN	
							".DB_PREFIX."countries AS cntry ON customer.countryID=cntry.countryID 
						LEFT JOIN	
							".DB_PREFIX."country_details AS	cntryDet ON	cntryDet.countryID=cntry.countryID 
						LEFT JOIN	
							".DB_PREFIX."state_details AS staDet ON staDet.stateID=customer.stateID 
				WHERE 
					customer.customerID = '".$customerID."' AND license.branchCode='".$branchCodeSes."' ";	
			$sql.= "AND customerStatus !='Deleted' 
					Group by customer.customerID ";

			$sql .= "LIMIT 1 ";
		}
		else
		{
			$sql=" 
				SELECT 
					customer.customerID as customerID, customer.customerFirstName as customerFirstName, customer.customerLastName as customerLastName, customer.customerEmailID as customerEmailID, customer.customerPhone as customerPhone, customer.customerAddress1 as customerAddress1, customer.customerAddress2 as customerAddress2, customer.customerCity as customerCity, customer.stateID as stateID, customer.countryID  as countryID, customer.customerPincode  as customerPincode, customer.registerDate as registerDate, customer.customerAssociate as customerAssociate, customer.customerAddEmailID as customerAddEmailID, customer.customerOtherNotes as customerOtherNotes, customer.customerCompany as customerCompany, customer.province as province, customer.customerFax as customerFax, customer.customerStatus as customerStatus,    
					cntryDet.countryName as customerCountry, 
					staDet.stateName as customerState 
				FROM 
						customer_info AS customer 
						LEFT JOIN	
							".DB_PREFIX."countries AS cntry ON customer.countryID=cntry.countryID 
						LEFT JOIN	
							".DB_PREFIX."country_details AS	cntryDet ON	cntryDet.countryID=cntry.countryID 
						LEFT JOIN	
							".DB_PREFIX."state_details AS staDet ON staDet.stateID=customer.stateID 
				WHERE 
					customer.customerID = '".$customerID."' ";	
			$sql.= "AND customerStatus !='Deleted' ";

			$sql .= "LIMIT 1 ";
		}
		
		return  $this->ObjDatabase->readValue($sql, MYSQL_ASSOC);			
	}

	/* To Change the Status */
	public function changeStatus($params=array())
	{
		extract($params);
		$sql="
			UPDATE  
				customer_info 
			SET 
				customerStatus = '".$customerStatus."' 
			WHERE
				customerID IN ('".implode("','",$customerIDs)."') "; 
		$this->ObjDatabase->setQuery($sql);					
	}

	/* To Insert or Update the Customer Details */
	public function insert($languageIDs,$adminId,$customerID=0)
	{
		if($customerID>0){
			$sql="
				UPDATE 
					customer_info 
				SET
					customerFirstName = '".$this->escape($_POST['customerFirstName'])."',customerLastName = '".$this->escape($_POST['customerLastName'])."',customerEmailID = '".$this->escape($_POST['customerEmailID'])."',customerPhone = '".$this->escape($_POST['customerPhone'])."',customerCompany = '".$this->escape($_POST['customerCompany'])."',customerAddress1 = '".$this->escape($_POST['customerAddress1'])."',customerAddress2 = '".$this->escape($_POST['customerAddress2'])."',customerCity = '".$this->escape($_POST['customerCity'])."',customerPincode = '".$this->escape($_POST['customerPincode'])."',countryID = '".$this->escape($_POST['countryID'])."',stateID = '".$this->escape($_POST['stateID'])."',province = '".$this->escape($_POST['province'])."',customerAddEmailID = '".$this->escape($_POST['customerAddEmailID'])."',customerFax = '".$this->escape($_POST['customerFax'])."',customerOtherNotes = '".$this->escape($_POST['customerOtherNotes'])."',customerAssociate = '".$this->escape($_POST['customerAssociate'])."',adminId = '".$this->escape($adminId)."',customerStatus = '".$this->escape($_POST['customerStatus'])."'
				WHERE
					customerID = '".$customerID."' "; 
			$this->ObjDatabase->setQuery($sql);
		}
		else
		{
			$sql="
				INSERT INTO customer_info 
					(
					customerFirstName,customerLastName,customerEmailID,customerPhone,customerCompany,customerAddress1,customerAddress2,customerCity,customerPincode,countryID,stateID,province,registerDate,customerAddEmailID,customerFax,customerOtherNotes,customerAssociate,adminId,customerStatus
					)
				VALUES
					(
					'".$this->escape($_POST['customerFirstName'])."','".$this->escape($_POST['customerLastName'])."','".$this->escape($_POST['customerEmailID'])."','".$this->escape($_POST['customerPhone'])."','".$this->escape($_POST['customerCompany'])."','".$this->escape($_POST['customerAddress1'])."','".$this->escape($_POST['customerAddress2'])."','".$this->escape($_POST['customerCity'])."','".$this->escape($_POST['customerPincode'])."','".$this->escape($_POST['countryID'])."','".$this->escape($_POST['stateID'])."','".$this->escape($_POST['province'])."',now(),'".$this->escape($_POST['customerAddEmailID'])."','".$this->escape($_POST['customerFax'])."','".$this->escape($_POST['customerOtherNotes'])."','".$this->escape($_POST['customerAssociate'])."','".$this->escape($adminId)."','".$this->escape($_POST['customerStatus'])."'
					) "; 
			$this->ObjDatabase->setQuery($sql);	
			$customerID = $this->ObjDatabase->getInsertId();
		}
		return $customerID;
				
	}

	/* List Customer in Dropdown */
	public function listCustomerOptions()
	{
		$sql=" 
			SELECT 
				customer.customerID as customerID, CONCAT(customer.customerFirstName, ' ', customer.customerLastName, ' ', customer.customerEmailID) as customerName 
			FROM 
					customer_info AS customer 
			WHERE 
				1 AND customerStatus !='Deleted' ";								
		return  $this->ObjDatabase->readValues($sql);
	}

	/* Get Total Customer Count From Database */
	public function getCustomerCount($adminId,$branchCodeSes)
	{
		if($adminId>1)
		{
			$sql="SELECT 
					customer.customerID as customerID 
				FROM 
					customer_info AS customer 
				LEFT JOIN	
					site_licences as license ON customer.customerID=license.customerID
				WHERE 
					customerStatus !='Deleted' AND license.branchCode='".$branchCodeSes."' 
				Group by customer.customerID ";	
		}
		else
		{
			$sql="SELECT 
					customer.customerID as customerID 
				FROM 
					customer_info AS customer 
				WHERE 
					customerStatus !='Deleted' ";
		}
		return  $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);
	}
	
	/* To Get the Customer And License Details */
	public function getCustomerLicDetails($customerID,$branchCodeSes="")
	{
		if($branchCodeSes!="")
		{
			$sql=" 
				SELECT 
					license.licenceID as licenceID, license.customerID as customerID, license.domainName as domainName, license.licenceKey as licenceKey, license.multipleDomainFrontend as multipleDomainFrontend, license.multipleDomainBackend as multipleDomainBackend, license.domainstatus as domainstatus, license.packageKey as packageKey, license.packageVersion as packageVersion, license.branchCode as branchCode, license.parentDomain as parentDomain, license.expiry as expiry, license.createDate as createDate, license.expiryDate as expiryDate, license.addons as addons, license.licenseType as licenseType, license.hardwareAddr as hardwareAddr, license.serverPath as serverPath, license.domainIP as domainIP, license.hostName as hostName, license.orderID as orderID, 
					package.packageName as packageName
				FROM 
					site_licences AS license
					LEFT JOIN package_info AS package ON license.packageKey=package.packageKey
				WHERE
					license.customerID = '".$customerID."' AND license.branchCode='".$branchCodeSes."' ";	
		}
		else
		{
			$sql=" 
				SELECT 
					license.licenceID as licenceID, license.customerID as customerID, license.domainName as domainName, license.licenceKey as licenceKey, license.multipleDomainFrontend as multipleDomainFrontend, license.multipleDomainBackend as multipleDomainBackend, license.domainstatus as domainstatus, license.packageKey as packageKey, license.packageVersion as packageVersion, license.branchCode as branchCode, license.parentDomain as parentDomain, license.expiry as expiry, license.createDate as createDate, license.expiryDate as expiryDate, license.addons as addons, license.licenseType as licenseType, license.hardwareAddr as hardwareAddr, license.serverPath as serverPath, license.domainIP as domainIP, license.hostName as hostName, license.orderID as orderID, 
					package.packageName as packageName
				FROM 
					site_licences AS license
					LEFT JOIN package_info AS package ON license.packageKey=package.packageKey
				WHERE
					license.customerID = '".$customerID."' ";	
		}
		return  $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);			
	}

	/* Check EmailID Already Exist Before Customer Add */
	public function checkCustomerEmailExist($customerID="")
	{
		$sql="	SELECT 
					customer.customerID as customerID
				FROM 
					customer_info AS customer
				WHERE
					customer.customerEmailID='".$this->escape($_POST['customerEmailID'])."' AND customer.customerStatus!='Deleted' ";
		if($customerID!="")
		{
			$sql.="	AND customer.customerID!='".$customerID."' ";
		}
		$sql.="	limit 1";	
		return $this->ObjDatabase->getFields($sql);
	}
	
	/* Check Phone Number Already Exist Before Customer Add */
	public function checkCustomerPhoneExist($customerID="")
	{
		if($_POST['customerPhone']!="")
		{
			$sql="	SELECT 
						customer.customerID as customerID
					FROM 
						customer_info AS customer
					WHERE
						customer.customerPhone='".$this->escape($_POST['customerPhone'])."' AND customer.customerStatus!='Deleted' ";
			if($customerID!="")
			{
				$sql.="	AND customer.customerID!='".$customerID."' ";
			}
			$sql.="	limit 1";				
			return $this->ObjDatabase->getFields($sql);
		}
		else
		{
			return array();
		}
	}
}
