<?php
/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/	//
//$Id: LanguageModel.php, v 1.0  2013/03/14 14:14:14
class LanguageModel extends Model {
	//FETCHING ALL LANGUAGES
	public function listLanguages($order=NULL,$status=NULL,$start=NULL,$limit=NULL)
	{
		//$resSelectLanguages	= $this->ObjCache->get('languages.'.$status);
		//if(!$resSelectLanguages){
			$append	='';
			if($status) 
				$append			= " AND `languageStatus`='".$status."' ";
			if($order)
				$append        .= " ORDER BY ".$order;
			else 
				$append        .= "ORDER BY `languageID` ASC";
			if($start && $limit)
				$append        .= "LIMIT ".$start.",".$limit."";
			$sql = "
			SELECT 
				* 
			FROM 
				`".DB_PREFIX."languages` 
			WHERE 
				`languageStatus` != 'Delete' ".$append."";
			$resSelectLanguages	= $this->ObjDatabase->readValues($sql);
			//$this->ObjCache->set('languagesActive', $resSelectLanguages, false, 3600);	
		//}
		return $resSelectLanguages;
	}
	//DELETING THE DETAILS  OF A LANGUAGE
	public function changeLanguageStatus($languageID,$status=NULL)
	{
		if(!$status)
			$status             = 'Delete';
		$resLanguageDetails    =$this->getLanguageDetails($languageID);
		$languagefilePath=$resLanguageDetails['LanguageLCIDstring'].'.xml';
		$sql =  "
		UPDATE 
			".DB_PREFIX."languages 
		SET 
			`languageStatus` = '".$status."'  
		WHERE 
			languageID = '".$languageID."'";
		$resUpdateLanguage    =  $this->ObjDatabase->setQuery($sql);
		unlink(__CORE_PUBLIC_MANAGE_PATH."/languages/".$languagefilePath);
		unlink(__CORE_PUBLIC_AFFILIATE_PATH."/languages/".$languagefilePath);
                unlink(__CORE_PUBLIC_BUSINESS_PATH."/languages/".$languagefilePath);
                unlink(__CORE_PUBLIC_SALESREP_PATH."/languages/".$languagefilePath);
                unlink(__CORE_PUBLIC_COMMON_FRONTEND_PATH."/languages/".$languagefilePath);
		$this->recursivelyRmDir(__CORE_PUBLIC_FRONTEND_CACHE_PATH."/".$languageID."/");
		if($this->isDefaultLanguage($languageID) && $status!="Active")
			$this->changeDefaultLanguage(1);
		return  $resUpdateLanguage;
	}
	private function  recursivelyRmDir($dir) {
		foreach(glob($dir . '/*') as $file) {
			if(is_dir($file))
				$this->recursivelyRmDir($file);
			else
				unlink($file);
		}
		rmdir($dir);
	}
	//SETTING A LANGUAGE AS DEFAULT
	public function changeDefaultLanguage($languageID)
	{
		$resLanguageDetails   =$this->getLanguageDetails($languageID);
		$languageLCIDstring    = $resLanguageDetails['LanguageLCIDstring'];
		$sql   = "
		UPDATE  
			`".DB_PREFIX."languages` 
		SET 
			`languageDefault` = 'No'";
		$RowResult       = $this->ObjDatabase->setQuery($sql);
		$sql        = "
		UPDATE  
			`".DB_PREFIX."languages` 
		SET 
			`languageDefault` = 'Yes' 
		WHERE 
			`languageID` ='".$languageID."' 
			AND `languageStatus` = 'Active'";
		$RowResult       = $this->ObjDatabase->setQuery($sql);
		$this->setSettingsDefaultLanguage($languageLCIDstring);
		$ObjSettings          = new SettingsModel();
		$ObjSettings->writeSettingsToXMLFile();
	}
	//Set Settings Default Language
	public function setSettingsDefaultLanguage($languageLCIDstring)    {
		$sql = "
		UPDATE 
			`".DB_PREFIX."settings` 
		SET 
			`settingsValue`='".$languageLCIDstring."' 
		WHERE 
			`settingsKey` = 'custom_language'";
		$this->ObjDatabase->setQuery($sql);
	}
	//GET DEFAULT LANGUAGE ID
	public function getDefaultLanguageID(){
		$sql = "
		SELECT 
			languageID 
		FROM 
			`".DB_PREFIX."languages` 
		WHERE 
			`languageDefault` = 'Yes' 
			AND `languageStatus` != 'Delete'";
		$resSelectLanguage	= $this->ObjDatabase->readValue($sql);
		return $resSelectLanguage['languageID'];
	}
	//GET CONTENT LANGUAGE ID
	public function getContentlanguageID($defaultLangID='',$languageList='')
	{
		$ObjFilter          =   new Filter();
		$ObjSession         =   $ObjFilter->getSessionInstance();
		$contentLanguageID  =   $ObjSession->getSession($this->getSection().'_ContentLanguageID');
		$contentLanguageID  = 	$contentLanguageID>0 ? $contentLanguageID :$ObjSession->getSession($this->getSection().'_CurrentLanguageID');
		//If current Content Language is inactive, set default as Content Language
		if($languageList && $contentLanguageID>0 && !in_array($contentLanguageID,$languageList['All']))
		{
			//Set Default Language as Content Language
			$contentLanguageID = $languageList['Default'];
		}
		if($defaultLangID=='' && $contentLanguageID<1)
		{
			$defaultLangID = $this->getDefaultLanguageID();
		}
		$contentLanguageID  = $contentLanguageID>0 ? $contentLanguageID : $defaultLangID;
		return $contentLanguageID;
	}       
	//Get language by LCID
	public function getLanguageByLCID($languageLCIDstring)   {
		$sql =   "
		SELECT 
			languageID,
			languageDefault,
			languageCode,
			LanguageLCIDstring 
	    FROM 
			".DB_PREFIX."languages 
		WHERE 
			LanguageLCIDstring = '".$languageLCIDstring."'
			AND languageStatus = 'Active'
		LIMIT 1" ;
		return $this->ObjDatabase->readValue($sql);
	}
	//TO SET CONTENT LANGUAGE ID
	public function setContentLanguageID($LanguageID)   {
		
		$ObjFilter          =   new Filter();
		$ObjSession         =   $ObjFilter->getSessionInstance();		
		$ObjSession->setSession($this->getSection().'_ContentLanguageID',$LanguageID) ;		
		$sql =   "
		SELECT 			
			LanguageLCIDstring 
	    FROM 
			".DB_PREFIX."languages 
		WHERE 
			languageID = '".$LanguageID."'
			AND languageStatus = 'Active'" ;
		$result=$this->getContentLCID($LanguageID);
		$ObjSession->setSession($this->getSection().'_ContentLCID',$result);	
			return $ObjSession->getSession[$this->getSection().'_ContentLanguageID'];
	}
	public function getContentLCID($LanguageID)   {
			$sql =   "
		SELECT 			
			LanguageLCIDstring 
	    FROM 
			".DB_PREFIX."languages 
		WHERE 
			languageID = '".$LanguageID."'
			AND languageStatus = 'Active'" ;
		$result=$this->ObjDatabase->readValue($sql);
		return $result['LanguageLCIDstring'];
	}
	//TO GET CURRENT LANGUAGE KEY
	public function getLanguageKey(){
		$sql = "
		SELECT 
			languageKey 
		FROM 
			`".DB_PREFIX."languages` 
		WHERE 
			`languageDefault` = 'Yes' 
			AND `languageStatus` != 'Delete'";
		return $this->ObjDatabase->readValue($sql);
	}
	//FETCHING A PARTICLUAR LANGUAGE BY LANGUAGE ID
	public function getLanguageDetails($languageID){
		$sql    = "
		SELECT 
			* 
		FROM 
			`".DB_PREFIX."languages` 
		WHERE 
			`languageID` =".$languageID."
		LIMIT 1";
		return  $this->ObjDatabase->readValue($sql);
	}
	//CHECKING WHETHER A LANGUAGE WITH SAME CODE EXISTS
	public function isLanguageCodeExixts($LanguageLCIDstring,$languageID=NULL)
	{
		if($languageID)  
			$append         = "AND `languageID` != '".$languageID."'";
		$sql       = "
		SELECT 
			* 
		FROM 
			`".DB_PREFIX."languages` 
		WHERE 
			`LanguageLCIDstring` = '".$LanguageLCIDstring."' 
			AND `languageStatus` != 'Delete' ".$append."";
		$result          = $this->ObjDatabase->numberOfRecords($sql);
		if($result != 0)return true; else return false;
	}
	//CHECKING IS DEFAULT LANGUAGE
	public function isDefaultLanguage($languageID){
		$sql   = "
		SELECT 
			* 
		FROM 
			`".DB_PREFIX."languages` 
		WHERE 
			`languageID` = '".$languageID."' 
			AND `languageStatus`!='Delete'  
			AND `languageDefault` = 'Yes'";
		$resSelectLanguage       =  $this->ObjDatabase->numberOfRecords($sql);
		if($resSelectLanguage)return true; else return false;
	}
	//EDITING OR ADDING A NEW LANGUAGE
	public function saveLanguageDetails($POST,$languageID=NULL)
	{	
		$name           		=	$this->escape($POST['languageName']);
		$code           		=	$this->escape($POST['languageCode']);
		$LCIDString     		=	$this->escape($POST['LanguageLCIDstring']);
		$locale              	=	$this->escape($POST['languageLocale']);
		$status              	=	$this->escape($POST['languageStatus']);
		$image 					=	stripslashes($POST['LanguageLCIDstring']).substr($_POST['languageImage'], strpos($_POST['languageImage'], "."));
		$languageFileExt     	=	strtolower(end(explode(".",$_FILES["languageFile"]['name'])));
		$languageFileExtFrontEnd=	strtolower(end(explode(".",$_FILES["languageFileFrontEnd"]['name'])));
		$languageFileExtBusiness=	strtolower(end(explode(".",$_FILES["languageFileBusiness"]['name'])));	
		$languageFileExtAffiliate=	strtolower(end(explode(".",$_FILES["languageFileAffiliate"]['name'])));	
		$languageFileExtSalesRep=	strtolower(end(explode(".",$_FILES["languageFileSalesRep"]['name'])));	
		if($languageID){
			$resSelectlanguage		= $this->getLanguageDetails($languageID);
			$oldLCIDstr				= stripslashes($resSelectlanguage['LanguageLCIDstring']);
			$image 					=	$resSelectlanguage['languageImage'];
			$oldFileName			= __CORE_PUBLIC_MANAGE_PATH."/languages/".$oldLCIDstr.".xml";
			//$this->ObjCache->delete(preg_replace("/[^A-Za-z0-9]/", "", $oldFileName));
			$oldFileNameFrontEnd	= __CORE_PUBLIC_COMMON_FRONTEND_PATH."/languages/".$oldLCIDstr.".xml";
			//$this->ObjCache->delete(preg_replace("/[^A-Za-z0-9]/", "", $oldFileNameFrontEnd));
			$oldFileNameBusiness	= __CORE_PUBLIC_BUSINESS_PATH."/languages/".$oldLCIDstr.".xml";
			//$this->ObjCache->delete(preg_replace("/[^A-Za-z0-9]/", "", $oldFileNameBusiness));
			$oldFileNameAffiliate	= __CORE_PUBLIC_AFFILIATE_PATH."/languages/".$oldLCIDstr.".xml";
			//$this->ObjCache->delete(preg_replace("/[^A-Za-z0-9]/", "", $oldFileNameAffiliate));
			$oldFileNameSalesRep	= __CORE_PUBLIC_SALESREP_PATH."/languages/".$oldLCIDstr.".xml";
			//$this->ObjCache->delete(preg_replace("/[^A-Za-z0-9]/", "", $oldFileNameSalesRep));
			
			if(file_exists($oldFileName) && $languageFileExt==""){
				rename($oldFileName,__CORE_PUBLIC_MANAGE_PATH."/languages/".$POST['LanguageLCIDstring'].".xml");
			}				
			if(file_exists($oldFileNameFrontEnd) && $languageFileExtFrontEnd==""){
				rename($oldFileNameFrontEnd,__CORE_PUBLIC_COMMON_FRONTEND_PATH."/languages/".$POST['LanguageLCIDstring'].".xml");
			}
			if(file_exists($oldFileNameBusiness) && $languageFileExtBusiness==""){
				rename($oldFileNameBusiness,__CORE_PUBLIC_BUSINESS_PATH."/languages/".$POST['LanguageLCIDstring'].".xml");
			}
			if(file_exists($oldFileNameAffiliate) && $languageFileExtAffiliate==""){
				rename($oldFileNameAffiliate,__CORE_PUBLIC_AFFILIATE_PATH."/languages/".$POST['LanguageLCIDstring'].".xml");
			}
			if(file_exists($oldFileNameSalesRep) && $languageFileExtSalesRep==""){
				rename($oldFileNameSalesRep,__CORE_PUBLIC_SALESREP_PATH."/languages/".$POST['LanguageLCIDstring'].".xml");
			}
		}
		if($languageFileExtFrontEnd=='xml'){
			copy($_FILES["languageFileFrontEnd"]['tmp_name'],__CORE_PUBLIC_COMMON_FRONTEND_PATH."/languages/".$POST['LanguageLCIDstring'].".xml");
			if($languageID){
				//reset frontend language listing cache variable
				$objCache	= new Cache(CACHE_DRIVER); 
				$objCache->delete('f_lng_xml_'.$languageID); 
			}
		}
		if($languageFileExt=='xml'){
			copy($_FILES["languageFile"]['tmp_name'],__CORE_PUBLIC_MANAGE_PATH."/languages/".$POST['LanguageLCIDstring'].".xml");
		}
		if($languageFileExtBusiness=='xml'){
			copy($_FILES["languageFileBusiness"]['tmp_name'],__CORE_PUBLIC_BUSINESS_PATH."/languages/".$POST['LanguageLCIDstring'].".xml");
		}
		if($languageFileExtSalesRep=='xml'){
			copy($_FILES["languageFileSalesRep"]['tmp_name'],__CORE_PUBLIC_SALESREP_PATH."/languages/".$POST['LanguageLCIDstring'].".xml");
		}
		if($languageFileExtAffiliate=='xml'){
			copy($_FILES["languageFileAffiliate"]['tmp_name'],__CORE_PUBLIC_AFFILIATE_PATH."/languages/".$POST['LanguageLCIDstring'].".xml");
		}
		if($POST["HiddenImageUrl"] && $POST["languageImage_temp"] && $image){
			copy($POST["languageImage_temp"],__CORE_PUBLIC_PATH."/uploads/languages/".$image);
			$ObjImage			=	new ImageModel();
			$imagePath			=	__CORE_PUBLIC_PATH."/uploads/languages/".$image;
			$ObjImage->resizeImage($imagePath,16,11);
		}
		if(!$languageID){
			$sql =	"
			INSERT INTO 
				`".DB_PREFIX."languages` (
					`languageName`, 
					`languageCode`, 
					`LanguageLCIDstring`,
					`languageLocale`, 
					`languageImage`,
					`languageStatus`
				) VALUES (
					'".$name."', 
					'".$code."', 
					'".$LCIDString."',
					'".$locale."', 
					'".$image."',
					'".$status."'
				)";
			$resInsertLanguage	=	$this->ObjDatabase->setQuery($sql);
			$defaultLanguageID	=	$this->getLanguageID();
			$currentLanguageID	=	$this->ObjDatabase->getInsertId();
			$this->makeCacheDirectoryForLanguage($currentLanguageID);
			$this->syncCountriesAndStateLanguages($defaultLanguageID,$currentLanguageID);
			$this->syncBusTypeAndDealTypeLanguages($defaultLanguageID,$currentLanguageID);
			$this->syncemailtemplateLanguages($defaultLanguageID,$currentLanguageID);
			$this->syncDealCategoryLanguages($defaultLanguageID,$currentLanguageID);
			$this->syncBusinessLanguages($defaultLanguageID,$currentLanguageID);
			$this->syncActiveDealLanguages($defaultLanguageID,$currentLanguageID);
			$this->syncUrlLanguages($defaultLanguageID,$currentLanguageID);			
			$this->syncStatusesLanguages($defaultLanguageID,$currentLanguageID);
			$this->syncRmaPropertiesLanguages($defaultLanguageID,$currentLanguageID);
			$this->syncDeliveryZones($defaultLanguageID,$currentLanguageID);
			$this->syncStaticBlocks($defaultLanguageID,$currentLanguageID);
			$this->syncBanners($defaultLanguageID,$currentLanguageID);                        
			$this->syncNewsletterTemplates($defaultLanguageID,$currentLanguageID);                        
			$this->syncMenuLanguages($defaultLanguageID,$currentLanguageID);
			$this->syncBlogCategoryLanguages($defaultLanguageID,$currentLanguageID);
			$this->syncBlogTagLanguages($defaultLanguageID,$currentLanguageID);
			$this->syncBlogCustomFieldLanguages($defaultLanguageID,$currentLanguageID);
			$this->syncBlogCustomFieldOptLanguages($defaultLanguageID,$currentLanguageID);	
			$this->syncForms($defaultLanguageID,$currentLanguageID);			
		}else{
			$sql =	"
			UPDATE 
				`".DB_PREFIX."languages` 
			SET 
				`languageName` = '".$name."', 
				`languageCode` = '".$code."', 
				`LanguageLCIDstring`='".$LCIDString."',
				`languageLocale` = '".$locale."', 
				`languageImage` = '".$image."',
				`languageStatus` = '".$status."' 
			WHERE 
				`languageID` = '".$languageID."'";
			$resUpdateLanguage	=	$this->ObjDatabase->setQuery($sql);
			if($status =="Inactive" && $this->isDefaultLanguage($languageID)){
				$this->changeLanguageStatus(1,"Active");
				$this->changeDefaultLanguage(1);
			}
		}
		$this->saveLanguageToSettings();
	}
	//Function to create directory for each languageID
	private function makeCacheDirectoryForLanguage($languageID)
	{
		mkdir(__CORE_PUBLIC_FRONTEND_CACHE_PATH."/".$languageID."/");
		chmod(__CORE_PUBLIC_FRONTEND_CACHE_PATH."/".$languageID."/", 0777);
	}
	// these function is used in settings model also
	public function updateDefaultLanguage($languageLCIDstring)
	{
		$sql		=	"
		UPDATE 
			`".DB_PREFIX."languages` 
		SET 
			`languageDefault` = 'No'";
		$RowResult  =	$this->ObjDatabase->setQuery($sql);
		$sql        =	"
		UPDATE 
			`".DB_PREFIX."languages` 
		SET 
			`languageDefault` = 'Yes' 
		WHERE 
			`LanguageLCIDstring` ='".$languageLCIDstring."' 
			AND `languageStatus` = 'Active'";
		$RowResult  =	$this->ObjDatabase->setQuery($sql);
	}
   //function to save language changes in settings table    
	public function saveLanguageToSettings()    {
		$resListLanguages       = $this->listLanguages("", 'Active');
		$sep                    = '';
		$settingsString         = '';
		foreach($resListLanguages as $language) {
			$settingsString     .=  $sep . $language['LanguageLCIDstring']. '->' .$language['languageName'];
			$sep                = '~*';
		}
		$sql = "
		UPDATE 
			".DB_PREFIX."settings 
		SET 
			settingsOptions='".$settingsString."' 
        WHERE 
			settingsKey LIKE 'custom_language'";
		$this->ObjDatabase->setQuery($sql);
	}
        public function syncMenuLanguages($defaultLanguageID,$currentLanguageID)
	{
		$sql =  "INSERT INTO ".DB_PREFIX."menu_details(
				  menuID, 
				  languageID, 
				  menuName, 
				  MenuDesc
				) 
				SELECT 
				  menu.menuID, 
				  '".$currentLanguageID."' AS languageID, 
				  menDet.menuName, 
				  menDet.MenuDesc 
				FROM 
				  ".DB_PREFIX."menu menu 
				  LEFT JOIN ".DB_PREFIX."menu_details menDet 
				  ON menu.menuID = menDet.menuID 
				WHERE 
				  menDet.languageID = '".$defaultLanguageID."' 
				  AND menu.status != 'Deleted'";
		$this->ObjDatabase->setQuery($sql);
        }
	//Synchronize countries and states
	public function syncCountriesAndStateLanguages($defaultLanguageID,$currentLanguageID)
	{
		$sql = "
		INSERT INTO 
			".DB_PREFIX."country_details (
				countryID,
				countryName,
				languageID
			) 
             SELECT 
			 	countryID,
				countryName,
				'".$currentLanguageID."' AS languageID 
             FROM 
			 	".DB_PREFIX."country_details 
			WHERE 
				languageID = '".$defaultLanguageID."'";
		$this->ObjDatabase->setQuery($sql);
		$sql  = "
		INSERT INTO 
			".DB_PREFIX."state_details(
				stateID,
				languageID,
				stateName
			)
             SELECT 
			 	staDet.stateID,
				'".$currentLanguageID."' AS languageID,
				staDet.stateName 
            FROM 
				".DB_PREFIX."state_details staDet
			LEFT JOIN 
				".DB_PREFIX."states sta ON staDet.stateID =sta.stateID
			WHERE 
				staDet.languageID = '".$defaultLanguageID."'";
		$this->ObjDatabase->setQuery($sql);
	}
	public function syncemailtemplateLanguages($defaultLanguageID,$currentLanguageID)
	{
		$sql = "
		INSERT INTO 
			".DB_PREFIX."email_template_details(
				emailTempID,
				languageID,
				emailSubject,
				emailHtml,
				emailText
			)
            SELECT 
				emailTempID,
				'".$currentLanguageID."' AS languageID,
				emailSubject,
				emailHtml,
				emailText 
            FROM 
				".DB_PREFIX."email_template_details 
			WHERE 
				languageID = '".$defaultLanguageID."'";
		$this->ObjDatabase->setQuery($sql);
		$sql 	= "
		INSERT INTO 
			".DB_PREFIX."email_template_sectons(
				sectionName,
				sectionUniqueString,
				languageID,
				sectionContent
			)
            SELECT 
				sectionName,
				sectionUniqueString,
				'".$currentLanguageID."' AS languageID,
				sectionContent
            FROM 
				".DB_PREFIX."email_template_sectons 
			WHERE 
				languageID = '".$defaultLanguageID."'";
		$this->ObjDatabase->setQuery($sql);
	}
	/********* Synchronise BusinessType And Deal Type **********/
	public function syncBusTypeAndDealTypeLanguages($defaultLanguageID,$currentLanguageID)
	{
		$sql	= "
		INSERT INTO 
			".DB_PREFIX."business_type_details(
				businessTypeID,
				businessTypeName,
				languageID,
				businessTypeDescription
			) 
            SELECT 
				busTypDet.businessTypeID,
				busTypDet.businessTypeName,
				'".$currentLanguageID."' AS languageID,
				busTypDet.businessTypeDescription 
			FROM 
			 	".DB_PREFIX."business_types busTyp
			LEFT JOIN 
				".DB_PREFIX."business_type_details busTypDet ON busTypDet.businessTypeId=busTyp.businessTypeId
			WHERE 
				busTypDet.languageID='".$defaultLanguageID."' 
				AND busTyp.businessTypeStatus<>'Delete'";
		$this->ObjDatabase->setQuery($sql);
		$sql = "
		INSERT INTO 
			".DB_PREFIX."deal_type_details(
				dealTypeID,
				languageID,
				dealTypeName,
				dealTypeDescription
			)
            SELECT 
				dealTypDet.dealTypeID,
				'".$currentLanguageID."' AS languageID,
				dealTypDet.dealTypeName,
				dealTypDet.dealTypeDescription 
			FROM 
				".DB_PREFIX."deal_types dealTyp
			LEFT JOIN 
				".DB_PREFIX."deal_type_details dealTypDet ON dealTypDet.dealTypeID=dealTyp.dealTypeID
			WHERE 
				dealTypDet.languageID='".$defaultLanguageID."' 
				AND dealTyp.dealTypeStatus<>'Deleted'";
		$this->ObjDatabase->setQuery($sql);
	}
        public function syncUrlLanguages($defaultLanguageID,$currentLanguageID)
        {
            //for product & categories
            $sqlCcmmon = "INSERT INTO 
			".DB_PREFIX."url_rewrite(
				objectID,
				parentID,
				type,
				idPath,
                                requestPath,
                                targetPath,
                                languageID,
                                redirectOption,
                                isSystem,
                                description
			) 
                        SELECT 
				url.objectID,
				url.parentID,
				url.type,
				url.idPath,
                                url.requestPath,
                                url.targetPath,
                                '".$currentLanguageID."' AS languageID,
                                '' AS redirectOption,
                                url.isSystem,
                                description
				
			FROM 
				".DB_PREFIX."url_rewrite url
			
			WHERE languageID='".$defaultLanguageID."'  AND  isSystem=1 ";
                $sql = $sqlCcmmon."	AND (type='catalog' OR type='product' OR type='blogCategory' )    ";
		$this->ObjDatabase->setQuery($sql);
                
                //sync page
                $sql = "SELECT contentID FROM ".DB_PREFIX."content_pages
				WHERE 
				  languages='0'";
                $results =  $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);
                foreach($results as $result){
                     $sql = $sqlCcmmon."	AND type='page' AND objectID='".$result['contentID']."'  ";
		$this->ObjDatabase->setQuery($sql);
                }
                 //sync menu
                $sql = "SELECT menuItemID FROM ".DB_PREFIX."menu_item
				WHERE 
				  availableLang='0'";
                $results =  $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);
                foreach($results as $result){
                     $sql = $sqlCcmmon." AND type='menu' AND objectID='".$result['menuItemID']."'  ";
		$this->ObjDatabase->setQuery($sql);
                }
                 //sync blogs
                $sql = "SELECT blogID FROM ".DB_PREFIX."blog_posts
				WHERE 
				 languages='0'";
                $results =  $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);
                foreach($results as $result){
                     $sql = $sqlCcmmon." AND type='blog' AND objectID='".$result['blogID']."'  ";
		$this->ObjDatabase->setQuery($sql);
                }
        }
	/********* Synchronise Business **********/
	public function syncBusinessLanguages($defaultLanguageID,$currentLanguageID)
	{
		$sql = "
		INSERT INTO 
			".DB_PREFIX."business_details(
				businessID,
				businessName,
				languageID,
				businessProfile
			) 
            SELECT 
				busDet.businessID,
				busDet.businessName,
				'".$currentLanguageID."' AS languageID,
				busDet.businessProfile 
			FROM 
				".DB_PREFIX."business_details busDet
			LEFT JOIN 
				".DB_PREFIX."business bus ON busDet.businessID=bus.businessID 
			WHERE 
				busDet.languageID='".$defaultLanguageID."'";
		$this->ObjDatabase->setQuery($sql);
		$sql = "
		INSERT INTO 
			".DB_PREFIX."business_location_details(
				businessLocID,
				languageID,
				locName,
				locAddress1,
				locAddress2,
				locCity,
				locProvince
			)
            SELECT 
				busLocDet.businessLocID,'".$currentLanguageID."' AS languageID,
				busLocDet.locName,
				busLocDet.locAddress1,
				busLocDet.locAddress2,
				busLocDet.locCity,
				busLocDet.locProvince
			FROM 
				".DB_PREFIX."business_locations busLoc
			LEFT JOIN 
				".DB_PREFIX."business_location_details busLocDet ON busLoc.businessLocID=busLocDet.businessLocID
			WHERE 
				busLocDet.languageID='".$defaultLanguageID."' 
				AND busLoc.locStatus<>'Deleted'";
		$this->ObjDatabase->setQuery($sql);
	}
	/********* Synchronise Deal Categories **********/
	public function syncDealCategoryLanguages($defaultLanguageID,$currentLanguageID)
	{
		$sql =	"
		INSERT INTO 
			".DB_PREFIX."deal_category_details(
				dealCategoryID,
				languageID,
				dealCategoryName,
				dealCategoryDescription,
				productCategoryMetaTitle,
				productCategoryMetaKeywords,
				productCategoryMetaDescription
			) 
            SELECT 
				dealCatDet.dealCategoryID,
				'".$currentLanguageID."' AS languageID,
				dealCatDet.dealCategoryName,
				dealCatDet.dealCategoryDescription,
				productCategoryMetaTitle,
				productCategoryMetaKeywords,
				productCategoryMetaDescription 
          	FROM 
				".DB_PREFIX."deal_categories dealCat
			LEFT JOIN 
				".DB_PREFIX."deal_category_details dealCatDet ON dealCat.dealCategoryID=dealCatDet.dealCategoryID 
			WHERE 
				dealCatDet.languageID='".$defaultLanguageID."' 
				AND dealCat.dealCategoryStatus!='Delete'";
		$this->ObjDatabase->setQuery($sql);
	}
	/********* Synchronise Upcoming / Current Deals **********/
	public function syncActiveDealLanguages($defaultLanguageID,$currentLanguageID)
	{
		
		$sql =	"
		INSERT INTO 
			".DB_PREFIX."deal_details(
				languageID,
				dealID,
				dealTitle,				
				dealFinePrint,
				dealHighlights,
				dealDescription,								
				dealMetaTitle,
				dealMetaDescription,
				dealMetaKeywords,
				searchTags
			) 
            SELECT 
				'".$currentLanguageID."' AS languageID,
				dealID,
				dealTitle,
				dealFinePrint,
				dealHighlights,
				dealDescription,							
				dealMetaTitle,
				dealMetaDescription,
				dealMetaKeywords,
				searchTags
             FROM 
			 	".DB_PREFIX."deal_details 
			WHERE 
				languageID ='".$defaultLanguageID."' 
				AND dealID IN (
								SELECT 
									deal.dealID 
								FROM 
									".DB_PREFIX."deals deal								 
								WHERE 
									deal.dealStatus != 'Deleted'
								GROUP BY deal.dealID
								)";
		$this->ObjDatabase->setQuery($sql);
		$sql	=	"
		INSERT INTO 
			".DB_PREFIX."deal_option_details(
				dealOptionID,
				languageID,
				dealOptionName
				) 
            SELECT 
				dealOptDet.dealOptionID,
				'".$currentLanguageID."' AS languageID,
				dealOptDet.dealOptionName
            FROM 
				".DB_PREFIX."deal_options dealOpt 
			LEFT JOIN 
				".DB_PREFIX."deal_option_details dealOptDet 
				ON dealOpt.dealOptionID=dealOptDet.dealOptionID
			WHERE 
				dealOptDet.languageID ='".$defaultLanguageID."' 
				AND dealOpt.dealOptionStatus<>'Delete' 
				AND dealOpt.dealID IN (
					SELECT 
						deal.dealID 
					FROM 
						".DB_PREFIX."deals deal					 
					WHERE 
						deal.dealStatus  != 'Deleted'
					GROUP BY deal.dealID
				)";
		$this->ObjDatabase->setQuery($sql);
	//Custom Option Details
		$sql	=	"
		INSERT INTO 
			".DB_PREFIX."product_custom_option_details(
				customOptionID,
				languageID,
				customOptionName,
				validationMessage,
				helpText
				)
		SELECT 
				customOptDet.customOptionID,
				'".$currentLanguageID."' AS languageID,
				customOptDet.customOptionName,
				customOptDet.validationMessage,
				customOptDet.helpText
		FROM 
				".DB_PREFIX."product_custom_option_details customOptDet
			WHERE 
				customOptDet.languageID ='".$defaultLanguageID."'";
		$this->ObjDatabase->setQuery($sql);
		
		
		//variant Details
		
		
		$sql	=	"
		INSERT INTO 
			".DB_PREFIX."product_custom_option_variant_details(
				customOptionVariantID,
				languageID,
				value
				)
		SELECT 
				customOptionVariantID,
				'".$currentLanguageID."' AS languageID,
				value
		FROM 
				".DB_PREFIX."product_custom_option_variant_details 
			WHERE 
				languageID ='".$defaultLanguageID."'";
		$this->ObjDatabase->setQuery($sql);		
		
		//Attribute Details
		
		$sql	=	"
		INSERT INTO 
			".DB_PREFIX."attribute_details(
				attributeID,
				languageID,
				attrName
				) 
			SELECT 
				attrDet.attributeID,
				'".$currentLanguageID."' AS languageID,
				attrDet.attrName
			FROM 
				
				".DB_PREFIX."attribute_details attrDet
			WHERE 
				attrDet.languageID ='".$defaultLanguageID."'";
					
		$this->ObjDatabase->setQuery($sql);
		
		//Attribute Option Details
		
		$sql	=	"
		INSERT INTO 
			".DB_PREFIX."attribute_option_details(
				attrOptionID,
				languageID,
				attrOptName
				) 
			SELECT 
				attrOptionID,
				'".$currentLanguageID."' AS languageID,
				attrOptName
			FROM 
				
				".DB_PREFIX."attribute_option_details
			WHERE 
				languageID ='".$defaultLanguageID."'";
					
		$this->ObjDatabase->setQuery($sql);
		
		//Attribute Group Details
		
		$sql	=	"
		INSERT INTO 
			".DB_PREFIX."attribute_group_details(
				attributeGroupID,
				languageID,
				name
				) 
			SELECT 
				attributeGroupID,
				'".$currentLanguageID."' AS languageID,
				name
			FROM 
				
				".DB_PREFIX."attribute_group_details
			WHERE 
				languageID ='".$defaultLanguageID."'";
					
		$this->ObjDatabase->setQuery($sql);
		
		//Attribute Value Details
		$sql	="
		INSERT INTO 
			".DB_PREFIX."deal_attribute_value_details(
				attrValueID,
				languageID,
				attrDetValue
				)
		SELECT 
				attrValDet.attrValueID,
				'".$currentLanguageID."' AS languageID,
				attrDetValue
		FROM 
				".DB_PREFIX."deal_attribute_value_details attrValDet 
			LEFT JOIN 
				".DB_PREFIX."deal_attribute_values attrVal 
				ON attrVal.attrValueID=attrValDet.attrValueID
			WHERE 
				attrValDet.languageID ='".$defaultLanguageID."' 				
				AND attrVal.dealID IN (
					SELECT 
						deal.dealID 
					FROM 
						".DB_PREFIX."deals deal					 
					WHERE

						deal.dealStatus != 'Deleted')";
		$this->ObjDatabase->setQuery($sql);		

	}
	
	/********* Synchronise Blog Categories **********/
	public function syncBlogCategoryLanguages($defaultLanguageID,$currentLanguageID)
	{
		$sql =	"
		INSERT INTO 
			".DB_PREFIX."blog_category_details(
				blogCategoryID,
				languageID,
				blogCategoryName,
				blogCategoryDescription
			) 
            SELECT 
				blogCatDet.blogCategoryID,
				'".$currentLanguageID."' AS languageID,
				blogCatDet.blogCategoryName,
				blogCatDet.blogCategoryDescription 
          	FROM 
				".DB_PREFIX."blog_categories blogCat
			LEFT JOIN 
				".DB_PREFIX."blog_category_details blogCatDet ON blogCat.blogCategoryID=blogCatDet.blogCategoryID 
			WHERE 
				blogCatDet.languageID='".$defaultLanguageID."' 
				AND blogCat.blogCategoryStatus!='Delete'";
		$this->ObjDatabase->setQuery($sql);
	}
	/********* Synchronise Blog Categories **********/
	public function syncBlogTagLanguages($defaultLanguageID,$currentLanguageID)
	{
		$sql =	"
		INSERT INTO 
			".DB_PREFIX."blog_tag_details(
				blogTagID,
				languageID,
				blogTagName,
				blogTagDescription
			) 
            SELECT 
				blogTagDet.blogTagID,
				'".$currentLanguageID."' AS languageID,
				blogTagDet.blogTagName,
				blogTagDet.blogTagDescription 
          	FROM 
				".DB_PREFIX."blog_tags blogTag
			LEFT JOIN 
				".DB_PREFIX."blog_tag_details blogTagDet ON blogTag.blogTagID=blogTagDet.blogTagID 
			WHERE 
				blogTagDet.languageID='".$defaultLanguageID."' 
				AND blogTag.blogTagStatus!='Delete'";
		$this->ObjDatabase->setQuery($sql);
	}
	/********* Synchronise Blog Custom Fields **********/
	public function syncBlogCustomFieldLanguages($defaultLanguageID,$currentLanguageID)
	{
		$sql =	"
		INSERT INTO 
			".DB_PREFIX."blog_custom_field_details(
				blogFieldID,
				languageID,
				blogFieldName
			) 
            SELECT 
				bCustDet.blogFieldID,
				'".$currentLanguageID."' AS languageID,
				bCustDet.blogFieldName
          	FROM 
				".DB_PREFIX."blog_custom_fields bCust
			LEFT JOIN 
				".DB_PREFIX."blog_custom_field_details bCustDet ON bCust.blogFieldID=bCustDet.blogFieldID 
			WHERE 
				bCustDet.languageID='".$defaultLanguageID."' 
				AND bCust.blogFieldStatus!='D'";
		$this->ObjDatabase->setQuery($sql);
	}
	public function syncBlogCustomFieldOptLanguages($defaultLanguageID,$currentLanguageID)
	{
		$sql	=	"
		INSERT INTO 
			".DB_PREFIX."blog_custom_field_option_details(
				blogFieldOptID,
				languageID,
				blogFieldOptName
				) 
            SELECT 
				bCustOptDet.blogFieldOptID,
				'".$currentLanguageID."' AS languageID,
				bCustOptDet.blogFieldOptName
            FROM 
				".DB_PREFIX."blog_custom_field_options bCustOpt 
			LEFT JOIN 
				".DB_PREFIX."blog_custom_field_option_details bCustOptDet 
				ON bCustOpt.blogFieldOptID=bCustOptDet.blogFieldOptID
			WHERE 
				bCustOptDet.languageID ='".$defaultLanguageID."'";
		$this->ObjDatabase->setQuery($sql);
		
		$sql	=	"
		INSERT INTO 
			".DB_PREFIX."blog_custom_field_value_details(
				blogFieldValueID,
				languageID,
				blogFieldDetValue
				)
		SELECT 
				blogFieldValueID,
				'".$currentLanguageID."' AS languageID,
				blogFieldDetValue
		FROM 
				".DB_PREFIX."blog_custom_field_value_details 
			WHERE 
				languageID ='".$defaultLanguageID."'";
		$this->ObjDatabase->setQuery($sql);	
	}
	public function currentLanguageLCIDstring()
	{
		$ObjFilter          		=   new Filter();
        $ObjSession         		=   $ObjFilter->getSessionInstance(); 
        $CurrentLanguageLCIDstring  =   $ObjSession->getSession($this->getSection().'_CurrentLanguageCode');
		if($CurrentLanguageLCIDstring==""){
			$CurrentLanguageLCIDstring = $this->LanguageLCIDstring();
		}	
		return $CurrentLanguageLCIDstring;
	}
	public function LanguageLCIDstring()
	{
		$sql  = "
		SELECT 
			LanguageLCIDstring 
		FROM 
			`".DB_PREFIX."languages` 
		WHERE 
			`languageDefault` = 'Yes' 
			AND `languageStatus` != 'Delete'";
		$resSelectLanguage     =  $this->ObjDatabase->readValue($sql);
		return $resSelectLanguage['LanguageLCIDstring'];
	}
	// function to update User,Business,Salesrep language preference
    public function resetThisLanguagePreferences($inactiveLanguageID, $defaultLanguageID)
    {
    	$sql = "
		UPDATE 
			".DB_PREFIX."users 
		SET 
			userDefaultLanguage=".$defaultLanguageID." 
		WHERE 
			userDefaultLanguage='".$inactiveLanguageID."'";
        $resUserLanguage 	= $this->ObjDatabase->setQuery($sql);
		$sql		= "
		UPDATE 
			".DB_PREFIX."business 
		SET 
			businessDefaultLanguageID=".$defaultLanguageID." 
		WHERE 
			businessDefaultLanguageID='".$inactiveLanguageID."'";
        $resBizLanguage 	= $this->ObjDatabase->setQuery($sql);
		if(__SALESREP_MODULE){
			$sql	= "
			UPDATE 
				".DB_PREFIX."representative 
			SET 
				languageID=".$defaultLanguageID." 
			WHERE 
				languageID='".$inactiveLanguageID."'";
        	$resRepLanguage = $this->ObjDatabase->setQuery($sql);
		}
    }
	public function getSettingsValue($settingsGroupId, $settingsKey)
	{
		$sql= "
		SELECT 
			settingsValue 
		FROM 
			".DB_PREFIX."settings 
		WHERE 
			settingsGroupID='".$settingsGroupId."' 
			AND settingsKey='".$settingsKey."'";
		$resSettingsValue		= $this->ObjDatabase->readValue($sql);
		return $resSettingsValue['settingsValue'];
	}
	
	public function loadLanguageXMLtoArray($file)
	{
			$xmlArray			= array();	
			foreach(simplexml_load_file($file) as $key => $node) {
				$nodeArray		= (array)$node;
				//$xmlArray[$key]	= ($nodeArray['@attributes']['custom']) ? $nodeArray['@attributes']['custom'] : $nodeArray['@attributes']['default'];
				if(isset($nodeArray['@attributes']['custom']))
					$xmlArray[$key]	= $nodeArray['@attributes']['custom'];
				else if(isset($nodeArray['@attributes']['default']))
					$xmlArray[$key]	= $nodeArray['@attributes']['default'];				
			}
		return $xmlArray;
	}
	
	//GET LANGUAGE ID
	public function getLanguageID(){
			$sql  = "
			SELECT 
				languageID 
			FROM 
				`".DB_PREFIX."languages` 
			WHERE 
				`languageDefault` = 'Yes' 
				AND `languageStatus` != 'Delete'";
			$resSelectLanguage     =  $this->ObjDatabase->readValue($sql);
			return $resSelectLanguage['languageID'];
	}
	//GET LanguageLCIDstring
	public function getLanguageLCIDstring($languageID)
	{
		$sql    = "
		SELECT 
			LanguageLCIDstring 
		FROM 
			".DB_PREFIX."languages 
		WHERE 
			languageID =".$languageID."
		LIMIT 1";
		$resSelectLanguage     =  $this->ObjDatabase->readValue($sql);
		return $resSelectLanguage['LanguageLCIDstring'];
	}
	public function syncRmaPropertiesLanguages($defaultLanguageID,$currentLanguageID)
	{
		$sql =  "INSERT INTO ".DB_PREFIX."rma_properties_details(
				  actionReasonID, 
				  languageID, 
				  actionReason 
				  
				) 
				SELECT 
				  rmaPro.actionReasonID, 
				  '".$currentLanguageID."' AS languageID, 
				  rmaProDet.actionReason 
				   
				FROM 
				  ".DB_PREFIX."rma_properties AS rmaPro 
				LEFT  JOIN ".DB_PREFIX."rma_properties_details AS rmaProDet 
				  ON rmaPro.actionReasonID = rmaProDet.actionReasonID 
				WHERE 
				  rmaProDet.languageID = '".$defaultLanguageID."' 
				  AND rmaPro.actionReasonStatus != 'D'";
		$this->ObjDatabase->setQuery($sql);
	}
	public function syncStatusesLanguages($defaultLanguageID,$currentLanguageID)
	{
		$sql =  "INSERT INTO ".DB_PREFIX."status_details(
				  statusesID, 
				  languageID, 
				  statusDescription,
				  emailSubject,
				  emailHeader	
				  
				) 
				SELECT 
				  sta.statusesID, 
				  '".$currentLanguageID."' AS languageID, 
				  staDet.statusDescription,
				  staDet.emailSubject,
				  staDet.emailHeader	
				   
				FROM 
				  ".DB_PREFIX."statuses AS sta 
				LEFT  JOIN ".DB_PREFIX."status_details AS staDet 
				  ON staDet.statusesID = sta.statusesID 
				WHERE 
					staDet.languageID = '".$defaultLanguageID."' 
				  AND sta.statusesStatus != 'D'";
		$this->ObjDatabase->setQuery($sql);
	}
	public function syncDeliveryZones($defaultLanguageID,$currentLanguageID)
	{         
		$sql =  "INSERT INTO ".DB_PREFIX."deliveryzone_details(
			  deliveryZoneID, 
			  languageID, 
			  deliveryZoneName,
			  deliveryZoneDescription
			) 
			SELECT 
			  delzon.deliveryZoneID, 
			  '".$currentLanguageID."' AS languageID, 
			  delzonDet.deliveryZoneName,
			  delzonDet.deliveryZoneDescription
			FROM 
			  ".DB_PREFIX."deliveryzones delzon
			LEFT  JOIN ".DB_PREFIX."deliveryzone_details delzonDet 
			  ON delzonDet.deliveryZoneID = delzon.deliveryZoneID
			WHERE 
				delzonDet.languageID = '".$defaultLanguageID."' 
			  AND delzon.deliveryZoneStatus != 'Deleted'";
		$this->ObjDatabase->setQuery($sql);
	}
	public function syncStaticBlocks($defaultLanguageID,$currentLanguageID)
	{         
		$sql =  "INSERT INTO ".DB_PREFIX."static_blocks_details(
			  blockID, 
			  languageID, 
			  blockTitle,
			  blockContent
			) 
			SELECT 
			  staBlo.blockID, 
			  '".$currentLanguageID."' AS languageID, 
			  staBloDet.blockTitle,
			  staBloDet.blockContent
			FROM 
			  ".DB_PREFIX."static_blocks AS staBlo
			LEFT  JOIN ".DB_PREFIX."static_blocks_details AS staBloDet
			  ON staBlo.blockID = staBloDet.blockID 
			WHERE 
				staBloDet.languageID = '".$defaultLanguageID."' 
			  AND staBlo.status != 'Deleted'";
		$this->ObjDatabase->setQuery($sql);
	}
	public function syncBanners($defaultLanguageID,$currentLanguageID)
	{         
		$sql =  "INSERT INTO ".DB_PREFIX."banner_details(
			  bannerID, 
			  languageID, 
			  bannerTitle,
			  bannerContent
			) 
			SELECT 
			  ban.bannerID, 
			  '".$currentLanguageID."' AS languageID, 
			  banDet.bannerTitle,
			  banDet.bannerContent
			FROM 
			  ".DB_PREFIX."banner AS ban
			LEFT  JOIN ".DB_PREFIX."banner_details	AS	banDet
			  ON banDet.bannerID	=	ban.bannerID
			WHERE 
				banDet.languageID = '".$defaultLanguageID."' 
			  AND ban.bannerStatus != 'Deleted'";
		$this->ObjDatabase->setQuery($sql);
	}
	public function setLanguageFromURL($LCIDString)
	{
		$sql    = "
		SELECT 
			languageID,LanguageLCIDstring 
		FROM 
			".DB_PREFIX."languages 
		WHERE 
			LanguageLCIDstring ='".$LCIDString."'
                            AND `languageStatus` != 'Delete'
		LIMIT 1";
		$resSelectLanguage     =  $this->ObjDatabase->readValue($sql);             
				$ObjFilter			=	new Filter();
				$ObjCookie          =	$ObjFilter->getCookieInstance();               
				if($resSelectLanguage){                                
				   $ObjCookie->setCookie($this->getSection().'_CurrentLanguageID',$resSelectLanguage['languageID']);
				   $ObjCookie->setCookie($this->getSection().'_LanguageLCIDstring',$resSelectLanguage['LanguageLCIDstring']);                    
				}               
		return $resSelectLanguage['languageID'];
	}
	public function syncNewsletterTemplates($defaultLanguageID,$currentLanguageID)
	{         
		$sql =  "INSERT INTO ".DB_PREFIX."newsletter_template_details(
			  nlTemplateID, 
			  languageID, 
			  nlTemplateName,
			  nlTemplateContent
			) 
			SELECT 
			  newTem.nlTemplateID, 
			  '".$currentLanguageID."' AS languageID, 
			  newTemDet.nlTemplateName,
			  newTemDet.nlTemplateContent
			FROM 
			  ".DB_PREFIX."newsletter_templates AS newTem
			LEFT  JOIN ".DB_PREFIX."newsletter_template_details	AS	newTemDet
			  ON newTem.nlTemplateID	=	newTemDet.nlTemplateID
			WHERE 
				newTemDet.languageID = '".$defaultLanguageID."' 
				AND newTem.nltStatus != 'deleted'";
		$this->ObjDatabase->setQuery($sql);
	}
	
	public function syncForms($defaultLanguageID,$currentLanguageID){
	
		$sql="
			INSERT INTO ".DB_PREFIX."form_entity_details
				(
				formID,
				languageID,
				formName,
				formDesc,
				submitButtonValue,
				afterFormSubmissionAction,
				disableFormMessage,
				agreementText,
				adminEmailSubject,
				adminEmailContent,
				userEmailSubject,
				userEmailContent
				)
			(
				SELECT
					formID,
					'".$currentLanguageID."',
					formName,
					formDesc,
					submitButtonValue,
					afterFormSubmissionAction,
					disableFormMessage,
					agreementText,
					adminEmailSubject,
					adminEmailContent,
					userEmailSubject,
					userEmailContent
				FROM
					".DB_PREFIX."form_entity_details
				WHERE
					languageID = '".$defaultLanguageID."' 
			)
		";
		
		$this->ObjDatabase->setQuery($sql);
		
		$sql="
			INSERT INTO ".DB_PREFIX."form_element_details
				(
				formElementID,
				languageID,
				formElementLabel,
				formElementDesc,
				formElementSubText,
				formElementPlaceHolder,
				formElementValue,
				formValidationMessage
				)
			(
				SELECT
					formElementID,
					'".$currentLanguageID."',
					formElementLabel,
					formElementDesc,
					formElementSubText,
					formElementPlaceHolder,
					formElementValue,
					formValidationMessage
				FROM
					".DB_PREFIX."form_element_details
				WHERE
					languageID = '".$defaultLanguageID."' 
			)
		";
		$this->ObjDatabase->setQuery($sql);
		
		
		$sql="
			INSERT INTO ".DB_PREFIX."form_options_details
				(
				formElementOptionID,
				languageID,
				optionDesc
				)
			(
				SELECT
					formElementOptionID,
					'".$currentLanguageID."',
					optionDesc
				FROM
					".DB_PREFIX."form_options_details
				WHERE
					languageID = '".$defaultLanguageID."' 
			)
		";
		$this->ObjDatabase->setQuery($sql);
	
	}
}
