<?php
/***************************************************************************
 *                                                                          *
 * Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
 *                                                                          *
 * This  is  commercial  software,  only  users  who have purchased a valid *
 * license  and  accept  to the terms of the  License Agreement can install *
 * and use this program.                                                    *
 *                                                                          *
 ****************************************************************************
 * PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
 * "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
 ****************************************************************************/
//
//$Id: LicenseModel, v 1.0 2014/05/07 16:18:26
//All functions 
//
class LicenseModel extends Model
{
	/* list License For All Domains and Sub domains */
	public function listLicense($params=array())
	{
		extract($params);
		if ($limitTo)
			$selectFields .= "SQL_CALC_FOUND_ROWS ";	
		if($adminId>1)
		{
			$sql=" 
				SELECT ".$selectFields."
					license.licenceID as licenceID, license.customerID as customerID, license.domainName as domainName, license.licenceKey as licenceKey, license.multipleDomainFrontend as multipleDomainFrontend, license.multipleDomainBackend as multipleDomainBackend, license.domainstatus as domainstatus, license.packageKey as packageKey, license.packageVersion as packageVersion, license.branchCode as branchCode, license.parentDomain as parentDomain, license.expiry as expiry, license.createDate as createDate, license.comments as comments, 
					package.packageName as packageName, 
					customer.customerFirstName as customerFirstName, customer.customerLastName as customerLastName, customer.customerEmailID as customerEmailID, customer.customerPhone as customerPhone, customer.customerAddress1 as customerAddress1, customer.customerAddress2 as customerAddress2, customer.customerCity as customerCity, customer.stateID as stateID, customer.countryID  as countryID, customer.customerPincode  as customerPincode, 
					state_details.stateName as stateName, 
					country_details.countryName as countryName  
				FROM 
					site_licences AS license
					LEFT JOIN customer_info AS customer ON license.customerID=customer.customerID
					LEFT JOIN package_info AS package ON license.packageKey=package.packageKey
					LEFT JOIN dp_state_details AS state_details ON customer.stateID=state_details.stateID
					LEFT JOIN dp_country_details AS country_details ON customer.countryID=country_details.countryID
				WHERE
					1 AND license.branchCode='".$branchCodeSes."'";		
		}
		else
		{
			$sql=" 
				SELECT ".$selectFields."
					license.licenceID as licenceID, license.customerID as customerID, license.domainName as domainName, license.licenceKey as licenceKey, license.multipleDomainFrontend as multipleDomainFrontend, license.multipleDomainBackend as multipleDomainBackend, license.domainstatus as domainstatus, license.packageKey as packageKey, license.packageVersion as packageVersion, license.branchCode as branchCode, license.parentDomain as parentDomain, license.expiry as expiry, license.createDate as createDate, license.comments as comments, 
					package.packageName as packageName, 
					customer.customerFirstName as customerFirstName, customer.customerLastName as customerLastName, customer.customerEmailID as customerEmailID, customer.customerPhone as customerPhone, customer.customerAddress1 as customerAddress1, customer.customerAddress2 as customerAddress2, customer.customerCity as customerCity, customer.stateID as stateID, customer.countryID  as countryID, customer.customerPincode  as customerPincode, 
					state_details.stateName as stateName, 
					country_details.countryName as countryName  
				FROM 
					site_licences AS license
					LEFT JOIN customer_info AS customer ON license.customerID=customer.customerID
					LEFT JOIN package_info AS package ON license.packageKey=package.packageKey
					LEFT JOIN dp_state_details AS state_details ON customer.stateID=state_details.stateID
					LEFT JOIN dp_country_details AS country_details ON customer.countryID=country_details.countryID
				WHERE
					1 ";		
		}
		if(isset($customerID) && $customerID!='')
		{
			$sql.= "AND (customer.customerFirstName like '%".$customerID."%' OR customer.customerLastName like '%".$customerID."%') ";
		}			
		if(isset($domainName) && $domainName!='')
		{
			$sql.= "AND license.domainName like '%".$domainName."%' ";
		}			
		if(isset($licenceKey) && $licenceKey!='')
		{
			$sql.= "AND license.licenceKey like '%".base64_encode($licenceKey)."%' ";
		}			
		if(isset($packageKey) && $packageKey!='')
		{
			$sql.= "AND license.packageKey like '%".$packageKey."%' ";
		}			
		if(isset($packageVersion) && $packageVersion!='')
		{
			$sql.= "AND license.packageVersion ='".$packageVersion."' ";
		}			
		if(isset($parentDomain) && $parentDomain!='')
		{
			$sql.= "AND license.parentDomain ='".$parentDomain."' ";
		}			
		if(isset($licenseType) && $licenseType!='')
		{
			$sql.= "AND license.licenseType ='".$licenseType."' ";
		}			
		if(isset($expiry) && $expiry!='')
		{
			$sql.= "AND license.expiry ='".$expiry."' ";
		}			
		if(isset($packageName) && $packageName!='')
		{
			$sql.= "AND package.packageName ='".$packageName."' ";
		}		
		if(isset($domainstatus1) && $domainstatus1!='')
		{
			if($domainstatus1=="partially blocked")
			{
				$sql.= "AND (license.domainstatus ='manage blocked' OR license.domainstatus ='frontend blocked' OR license.domainstatus ='other blocked') ";
			}
			else
			{
				$sql.= "AND license.domainstatus ='".$domainstatus1."' ";
			}
		}	
		if(isset($multipleDom) && $multipleDom!='')
		{
			if($multipleDom=="multipledomainfrontend")
			{
				$sql.= "AND license.multipleDomainFrontend ='Yes' ";
			}
			else if($multipleDom=="multipledomainbackend")
			{
				$sql.= "AND license.multipledomainbackend ='Yes' ";
			}
			else if($multipleDom=="both")
			{
				$sql.= "AND (license.multipleDomainFrontend ='Yes' OR license.multipleDomainBackend ='Yes') ";
			}
		}
		if(isset($addons) && $addons!='')
		{
			$sql.= "AND license.addons like '%".$addons."%' ";
		}			
		if(isset($branchCode) && $branchCode!='')
		{
			$sql.= "AND license.branchCode ='".$branchCode."' ";
		}	
		if ((isset($fromDate) && isset($toDate)) && ($fromDate != '' && $toDate != ''))
		{
			$sql .= " 	AND ( DATEDIFF('" . $fromDate . "',license.createDate)<=0 AND DATEDIFF('" . $toDate . "',license.createDate)>=0 ) ";
		}
		else if ((isset($fromDate)) && ($fromDate!= ''))
		{
			$sql .= " 	AND ( DATEDIFF( '" . $fromDate . "',license.createDate)<=0 ) ";
		}
		else if ((isset($toDate)) && ($toDate != ''))
		{
			$sql .= " 	AND	( DATEDIFF('" . $toDate . "',license.createDate)>=0 ) ";
		}
		$sql.= "AND license.domainstatus !='Deleted' ";
		if($orderby && $sortby)
		{
			if((substr($sortby, 5))=="customerID") 
			{
				$sql.="ORDER BY customer.customerFirstName ".$orderby."
				";
			}				
			else 
			{
				$sql.="ORDER BY ".substr($sortby, 5)." ".$orderby." ";
			}
		}
		if ($limitTo)
		{
			$sql .= " LIMIT " . $limitFrom . ", " . $limitTo . " ";
		}
		//return  $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);
		$listlicense	= $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);
		$listParent		= array();
		$listSub		= array();
		$j				= 0;
		$k				= 0;
		for($i=0;$i<count($listlicense);$i++)
		{
			if($listlicense[$i]['parentDomain']=='0')
			{
				$listParent[$j]	= $listlicense[$i];
				$j++;
			}
			else
			{
				$listSub[$k]	= $listlicense[$i];
				$k++;
			}
		}
		return array($listParent, $listSub);
	}
	
	/* list License Recently Installed and Unauthorized */
	public function listLicenseInstUnauth($params=array(),$status)
	{
		extract($params);
		if ($limitTo)
			$selectFields .= "SQL_CALC_FOUND_ROWS ";	
		if($adminId>1)
		{
			$sql=" 
				SELECT ".$selectFields."
					license.licenceID as licenceID, license.customerID as customerID, license.domainName as domainName, license.licenceKey as licenceKey, license.multipleDomainFrontend as multipleDomainFrontend, license.multipleDomainBackend as multipleDomainBackend, license.domainstatus as domainstatus, license.packageKey as packageKey, license.packageVersion as packageVersion, license.branchCode as branchCode, license.parentDomain as parentDomain, license.expiry as expiry, license.createDate as createDate, license.comments as comments,  
					package.packageName as packageName, 
					customer.customerFirstName as customerFirstName, customer.customerLastName as customerLastName, customer.customerEmailID as customerEmailID, customer.customerPhone as customerPhone, customer.customerAddress1 as customerAddress1, customer.customerAddress2 as customerAddress2, customer.customerCity as customerCity, customer.stateID as stateID, customer.countryID as countryID, customer.customerPincode  as customerPincode, 
					state_details.stateName as stateName, 
					country_details.countryName as countryName, 
					site_access.accessTime as accessTime, site_access.accessIP as accessIP, count(site_access.licenceID) as accessCount 
				FROM 
					site_licences AS license
					LEFT JOIN customer_info AS customer ON license.customerID=customer.customerID
					LEFT JOIN package_info AS package ON license.packageKey=package.packageKey
					LEFT JOIN dp_state_details AS state_details ON customer.stateID=state_details.stateID
					LEFT JOIN dp_country_details AS country_details ON customer.countryID=country_details.countryID
					LEFT JOIN site_access_details AS site_access ON license.licenceID=site_access.licenceID
				WHERE
					1 AND license.branchCode='".$branchCodeSes."'";
		}
		else
		{
			$sql=" 
				SELECT ".$selectFields."
					license.licenceID as licenceID, license.customerID as customerID, license.domainName as domainName, license.licenceKey as licenceKey, license.multipleDomainFrontend as multipleDomainFrontend, license.multipleDomainBackend as multipleDomainBackend, license.domainstatus as domainstatus, license.packageKey as packageKey, license.packageVersion as packageVersion, license.branchCode as branchCode, license.parentDomain as parentDomain, license.expiry as expiry, license.createDate as createDate, license.comments as comments,  
					package.packageName as packageName, 
					customer.customerFirstName as customerFirstName, customer.customerLastName as customerLastName, customer.customerEmailID as customerEmailID, customer.customerPhone as customerPhone, customer.customerAddress1 as customerAddress1, customer.customerAddress2 as customerAddress2, customer.customerCity as customerCity, customer.stateID as stateID, customer.countryID as countryID, customer.customerPincode  as customerPincode, 
					state_details.stateName as stateName, 
					country_details.countryName as countryName, 
					site_access.accessTime as accessTime, site_access.accessIP as accessIP, site_access.accessTrack as accessTrack, count(site_access.licenceID) as accessCount 
				FROM 
					site_licences AS license
					LEFT JOIN customer_info AS customer ON license.customerID=customer.customerID
					LEFT JOIN package_info AS package ON license.packageKey=package.packageKey
					LEFT JOIN dp_state_details AS state_details ON customer.stateID=state_details.stateID
					LEFT JOIN dp_country_details AS country_details ON customer.countryID=country_details.countryID
					LEFT JOIN site_access_details AS site_access ON license.licenceID=site_access.licenceID
				WHERE
					1 ";	
		}
		if(isset($customerID) && $customerID!='')
		{
			$sql.= "AND (customer.customerFirstName like '%".$customerID."%' OR customer.customerLastName like '%".$customerID."%') ";
		}			
		if(isset($domainName) && $domainName!='')
		{
			$sql.= "AND license.domainName like '%".$domainName."%' ";
		}			
		if(isset($licenceKey) && $licenceKey!='')
		{
			$sql.= "AND license.licenceKey like '%".base64_encode($licenceKey)."%' ";
		}			
		if(isset($packageKey) && $packageKey!='')
		{
			$sql.= "AND license.packageKey like '%".$packageKey."%' ";
		}			
		if(isset($packageVersion) && $packageVersion!='')
		{
			$sql.= "AND license.packageVersion ='".$packageVersion."' ";
		}			
		if(isset($parentDomain) && $parentDomain!='')
		{
			$sql.= "AND license.parentDomain ='".$parentDomain."' ";
		}			
		if(isset($licenseType) && $licenseType!='')
		{
			$sql.= "AND license.licenseType ='".$licenseType."' ";
		}			
		if(isset($expiry) && $expiry!='')
		{
			$sql.= "AND license.expiry ='".$expiry."' ";
		}			
		if(isset($packageName) && $packageName!='')
		{
			$sql.= "AND package.packageName ='".$packageName."' ";
		}					
		if(isset($domainstatus1) && $domainstatus1!='')
		{
			$sql.= "AND license.domainstatus ='".$domainstatus1."' ";
		}				
		if(isset($addons) && $addons!='')
		{
			$sql.= "AND license.addons like '%".$addons."%' ";
		}			
		if(isset($branchCode) && $branchCode!='')
		{
			$sql.= "AND license.branchCode ='".$branchCode."' ";
		}	
		if ((isset($fromDate) && isset($toDate)) && ($fromDate != '' && $toDate != ''))
		{
			$sql .= " 	AND ( DATEDIFF('" . $fromDate . "',license.createDate)<=0 AND DATEDIFF('" . $toDate . "',license.createDate)>=0 ) ";
		}
		else if ((isset($fromDate)) && ($fromDate!= ''))
		{
			$sql .= " 	AND ( DATEDIFF( '" . $fromDate . "',license.createDate)<=0 ) ";
		}
		else if ((isset($toDate)) && ($toDate != ''))
		{
			$sql .= " 	AND	( DATEDIFF('" . $toDate . "',license.createDate)>=0 ) ";
		}
		
		if ((isset($fromDate1) && isset($toDate1)) && ($fromDate1 != '' && $toDate1 != ''))
		{
			$sql .= " 	AND ( DATEDIFF('" . $fromDate1 . "',site_access.accessTime)<=0 AND DATEDIFF('" . $toDate1 . "',site_access.accessTime)>=0 ) ";
		}
		else if ((isset($fromDate1)) && ($fromDate1!= ''))
		{
			$sql .= " 	AND ( DATEDIFF( '" . $fromDate1 . "',site_access.accessTime)<=0 ) ";
		}
		else if ((isset($toDate1)) && ($toDate1 != ''))
		{
			$sql .= " 	AND	( DATEDIFF('" . $toDate1 . "',site_access.accessTime)>=0 ) ";
		}
		
		$sql.= " AND license.domainstatus !='Deleted' ";
		if($status=="Install")
		{
			$sql.= " AND (site_access.accessStatus='Install' OR site_access.accessStatus='Install, Unauthorized') ";
		}
		else if($status=="Expired")
		{
			$sql.= " AND site_access.accessStatus='License Expired' ";
		}
		else
		{
			$sql.= " AND site_access.accessStatus='".$status."' ";
		}
		$sql.= " Group By license.licenceID ";
				
		if(isset($accessCount) && $accessCount!='')
		{
			$sql.= "having count(site_access.licenceID)=".$accessCount." ";
		}	
		
		if($orderby && $sortby)
		{
			if((substr($sortby, 5))=="customerID") 
			{
				$sql.="ORDER BY customer.customerFirstName ".$orderby.", site_access.accessTime desc ";
			}				
			else 
			{
				$sql.="ORDER BY ".substr($sortby, 5)." ".$orderby.", site_access.accessTime desc ";
			}
		}
		else
		{
			$sql.="ORDER BY site_access.accessTime desc ";
		}
		if ($limitTo)
		{
			$sql .= " LIMIT " . $limitFrom . ", " . $limitTo . " ";
		}
		return  $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);
	}

		
	/* To Get the License Details For All Domains, Install and Unauthorized View*/
	public function getLicenseDetails($params=array())
	{
		extract($params);
		if($adminId>1)
		{
			$sql=" 
			SELECT 
				license.licenceID as licenceID, license.customerID as customerID, license.domainName as domainName, license.licenceKey as licenceKey, license.multipleDomainFrontend as multipleDomainFrontend, license.multipleDomainBackend as multipleDomainBackend, license.domainTypeDev as domainTypeDev, license.multiPackage as multiPackage, license.domainstatus as domainstatus, license.packageKey as packageKey, license.packageVersion as packageVersion, license.branchCode as branchCode, license.parentDomain as parentDomain, license.expiry as expiry, license.createDate as createDate, license.expiryDate as expiryDate, license.addons as addons, license.licenseType as licenseType, license.hardwareAddr as hardwareAddr, license.serverPath as serverPath, license.domainIP as domainIP, license.hostName as hostName, license.orderID as orderID, license.comments as comments, 
				package.packageName as packageName, 
				customer.customerFirstName as customerFirstName, customer.customerLastName as customerLastName, customer.customerEmailID as customerEmailID, customer.customerPhone as customerPhone, customer.customerAddress1 as customerAddress1, customer.customerAddress2 as customerAddress2, customer.customerCity as customerCity, customer.stateID as stateID, customer.countryID as countryID, customer.customerPincode  as customerPincode, customer.customerFax as customerFax, customer.customerAddEmailID as customerAddEmailID, customer.customerOtherNotes as customerOtherNotes, customer.customerCompany as customerCompany,  
				state_details.stateName as stateName, 
				country_details.countryName as countryName, 
				CONCAT(admin_users.adminUserFirstName, ' ', admin_users.adminUserLastName) as adminUserName 
			FROM 
				site_licences AS license
				LEFT JOIN customer_info AS customer ON license.customerID=customer.customerID
				LEFT JOIN package_info AS package ON license.packageKey=package.packageKey
				LEFT JOIN dp_state_details AS state_details ON customer.stateID=state_details.stateID
				LEFT JOIN dp_country_details AS country_details ON customer.countryID=country_details.countryID 
				LEFT JOIN dp_admin_users AS admin_users ON license.adminId=admin_users.adminUserID 
			WHERE
				license.licenceID = '".$licenceID."' AND license.branchCode='".$branchCodeSes."'";	
		}
		else
		{
			$sql=" 
				SELECT 
					license.licenceID as licenceID, license.customerID as customerID, license.domainName as domainName, license.licenceKey as licenceKey, license.multipleDomainFrontend as multipleDomainFrontend, license.multipleDomainBackend as multipleDomainBackend, license.domainTypeDev as domainTypeDev, license.multiPackage as multiPackage, license.domainstatus as domainstatus, license.packageKey as packageKey, license.packageVersion as packageVersion, license.branchCode as branchCode, license.parentDomain as parentDomain, license.expiry as expiry, license.createDate as createDate, license.expiryDate as expiryDate, license.addons as addons, license.licenseType as licenseType, license.hardwareAddr as hardwareAddr, license.serverPath as serverPath, license.domainIP as domainIP, license.hostName as hostName, license.orderID as orderID, license.comments as comments,     
					package.packageName as packageName, 
					customer.customerFirstName as customerFirstName, customer.customerLastName as customerLastName, customer.customerEmailID as customerEmailID, customer.customerPhone as customerPhone, customer.customerAddress1 as customerAddress1, customer.customerAddress2 as customerAddress2, customer.customerCity as customerCity, customer.stateID as stateID, customer.countryID as countryID, customer.customerPincode  as customerPincode, customer.customerFax as customerFax, customer.customerAddEmailID as customerAddEmailID, customer.customerOtherNotes as customerOtherNotes, customer.customerCompany as customerCompany, 
					state_details.stateName as stateName, 
					country_details.countryName as countryName, 
					CONCAT(admin_users.adminUserFirstName, ' ', admin_users.adminUserLastName) as adminUserName 
				FROM 
					site_licences AS license
					LEFT JOIN customer_info AS customer ON license.customerID=customer.customerID
					LEFT JOIN package_info AS package ON license.packageKey=package.packageKey
					LEFT JOIN dp_state_details AS state_details ON customer.stateID=state_details.stateID
					LEFT JOIN dp_country_details AS country_details ON customer.countryID=country_details.countryID 
					LEFT JOIN dp_admin_users AS admin_users ON license.adminId=admin_users.adminUserID 
				WHERE
					license.licenceID = '".$licenceID."' ";	
		}

		$sql .= " LIMIT 1 ";
		$result			= $this->ObjDatabase->readValue($sql, MYSQL_ASSOC);
		$parent	="";
		if($result['parentDomain']!=0)
		{
			$parent	= $this->ObjDatabase->getField("SELECT domainName 
													FROM 
														site_licences
													WHERE 
														licenceID = '".$result['parentDomain']."' LIMIT 1 ");
		}
		return array_merge($result,array('parentName'=>$parent));
	}
	
	/* To Get the License Site Access Details For Install and Unauthorized View */
	public function getLicenseAccessDetails($params=array(),$status)
	{
		extract($params);
		$sql=" 
			SELECT 
				site_access.licenceID as licenceID, site_access.domainName as domainName, site_access.licenceKey as licenceKey, site_access.accessStatus as accessStatus, site_access.accessData as accessData, site_access.accessTime as accessTime, site_access.prevaccessData as prevaccessData, site_access.accessedPath as accessedPath, site_access.accessIP as accessIP, site_access.section as section, site_access.module as module, site_access.moduleAction as moduleAction 			
			FROM 
				site_access_details AS site_access 
				LEFT JOIN site_licences AS license ON site_access.licenceID=license.licenceID 
			WHERE
				site_access.licenceID = '".$licenceID."' ";
		if($status=="Install")
		{
			$sql.= " AND (site_access.accessStatus='Install' OR site_access.accessStatus='Install, Unauthorized') ";
		}
		else if($status=="Expired")
		{
			$sql.= " AND site_access.accessStatus='License Expired' ";
		}
		else
		{
			$sql.="	AND site_access.accessStatus='".$status."' ";
		}
		$sql.="	ORDER BY site_access.accessTime desc ";	
		return  $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);		
	}

	/* list License Unauthorized */
	public function listLicenseUnknUnauth($params=array())
	{
		extract($params);
		if ($limitTo)
			$selectFields .= "SQL_CALC_FOUND_ROWS ";	
		$sql=" 
			SELECT ".$selectFields."
				site_access.licenceID as licenceID, site_access.domainName as domainName, site_access.licenceKey as licenceKey, site_access.accessStatus as accessStatus, site_access.accessData as accessData, site_access.accessTime as accessTime, site_access.prevaccessData as prevaccessData, site_access.accessedPath as accessedPath, site_access.accessIP as accessIP, site_access.section as section, site_access.module as module, site_access.moduleAction as moduleAction, count(site_access.licenceKey) as totAccessCount  
			FROM 
				site_access_details AS site_access 
			WHERE
				site_access.licenceID = '0' ";			
				
		if(isset($domainName) && $domainName!='')
		{
			$sql.= "AND site_access.domainName like '%".$domainName."%' ";
		}			
		if(isset($licenceKey) && $licenceKey!='')
		{
			$sql.= "AND site_access.licenceKey like '%".base64_encode($licenceKey)."%' ";
		}																								
		if(isset($section) && $section!='')
		{
			$sql.= "AND site_access.section like '%".$section."%' ";
		}	
		if(isset($accessIP) && $accessIP!='')
		{
			$sql.= "AND site_access.accessIP like '%".$accessIP."%' ";
		}	
		
		if ((isset($fromDate) && isset($toDate)) && ($fromDate != '' && $toDate != ''))
		{
			$sql .= " 	AND ( DATEDIFF('" . $fromDate . "',site_access.accessTime)<=0 AND DATEDIFF('" . $toDate . "',site_access.accessTime)>=0 ) ";
		}
		else if ((isset($fromDate)) && ($fromDate!= ''))
		{
			$sql .= " 	AND ( DATEDIFF( '" . $fromDate . "',site_access.accessTime)<=0 ) ";
		}
		else if ((isset($toDate)) && ($toDate != ''))
		{
			$sql .= " 	AND	( DATEDIFF('" . $toDate . "',site_access.accessTime)>=0 ) ";
		}

		$sql.= "Group by site_access.licenceKey ";
		if(isset($accessCount) && $accessCount!='')
		{
			$sql.= "having count(site_access.licenceKey)=".$accessCount." ";
		}	
		$sql.= "ORDER BY site_access.accessTime desc ";
		if ($limitTo)
		{
			$sql .= " LIMIT " . $limitFrom . ", " . $limitTo . " ";
		}
		
		$listLicenseUnkn	= $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);
		$lisKey		= array();
		$listDomain	= array();
		$listIP		= array();
		$j=0;
		for($i=0;$i<count($listLicenseUnkn);$i++)
		{
			$listKey[$j]	= $listLicenseUnkn[$i]['licenceKey'];
			$listDomain[$j]	= $listLicenseUnkn[$i]['domainName'];
			$listIP[$j]		= $listLicenseUnkn[$i]['accessIP'];
			$j++;
		}
		$sqlKeyDom	= " SELECT 
					license.licenceID, license.domainName, license.licenceKey, license.domainIP  
					FROM 
						site_licences AS license 
					WHERE 
						( (license.licenceKey IN ('".@implode("','",$listKey)."')) OR (license.domainName IN ('".@implode("','",$listDomain)."')) OR (license.domainIP IN ('".@implode("','",$listIP)."')) )";
		$keydomList	= $this->ObjDatabase->readValues($sqlKeyDom);
		
		return array($listLicenseUnkn, $keydomList);
	}
	
	/* list License Unauthorized Details */
	public function listLicenseUnknDetail($params=array())
	{
		extract($params);
		if ($limitTo)
			$selectFields .= "SQL_CALC_FOUND_ROWS ";	
		$sql=" 
			SELECT ".$selectFields."
				site_access.licenceID as licenceID, site_access.domainName as domainName, site_access.licenceKey as licenceKey, site_access.accessStatus as accessStatus, site_access.accessData as accessData, site_access.accessTime as accessTime, site_access.prevaccessData as prevaccessData, site_access.accessedPath as accessedPath, site_access.accessIP as accessIP, site_access.section as section, site_access.module as module, site_access.moduleAction as moduleAction
			FROM 
				site_access_details AS site_access 
			WHERE
				site_access.licenceID = '0' AND site_access.licenceKey = '".base64_encode($licenceKey)."' ";			


		$sql.= "ORDER BY site_access.accessTime desc ";
		if ($limitTo)
		{
			$sql .= " LIMIT " . $limitFrom . ", " . $limitTo . " ";
		}
				
		return  $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);
	}

	/* To Change the Status*/
	public function changeStatus($params=array())
	{
		extract($params);
		$sql="
			UPDATE  
				site_licences 
			SET 
				domainstatus = '".$status."' 
			WHERE
				licenceID IN ('".implode("','",$licenceIDs)."') "; 
		$this->ObjDatabase->setQuery($sql);	
				
	}

	/* To Insert and Update License*/
	public function insert($languageIDs,$resultlicenc="",$licenceID=0,$adminId="")
	{
		if($licenceID>0)
		{
			$sql="	UPDATE 
						site_licences 
					SET ";
			if($adminId>1)
			{
				
				$sql.="licenseType = '".$this->escape($_POST['licenseType'])."',expiry = '".$this->escape($_POST['expiry'])."',adminId = '".$this->escape($adminId)."' ";
			}
			else
			{
				$sql.="customerID = '".$this->escape($_POST['customerID'])."',domainName = '".$this->escape($_POST['domainName'])."',packageKey = '".$this->escape($_POST['packageKey'])."',packageVersion = '".$this->escape($_POST['packageVersion'])."',orderID = '".$this->escape($_POST['orderID'])."',parentDomain = '".$this->escape($_POST['parentDomain'])."',licenseType = '".$this->escape($_POST['licenseType'])."',expiry = '".$this->escape($_POST['expiry'])."',multipleDomainFrontend = '".$this->escape($_POST['multipleDomainFrontend'])."',multipleDomainBackend = '".$this->escape($_POST['multipleDomainBackend'])."',domainTypeDev = '".$this->escape($_POST['domainTypeDev'])."',multiPackage = '".$this->escape($_POST['multiPackage'])."',domainstatus = '".$this->escape($_POST['domainstatus'])."',addons = '".$this->escape($_POST['addons'])."',branchCode = '".$this->escape($_POST['branchCode'])."',comments = '".$this->escape($_POST['comments'])."',adminId = '".$this->escape($adminId)."' "; 
			}
			if($_POST['expiry']=="Yes")
			{
				$sql.=", expiryDate = '".$this->escape($_POST['expiryDate'])."' ";
			}
			else if($_POST['expiry']=="No")
			{
				$sql.=", expiryDate = '0000-00-00' ";
			}
			$sql.="WHERE
						licenceID = '".$licenceID."' "; 			
			$this->ObjDatabase->setQuery($sql);
		}
		else
		{
			$sql="
				INSERT INTO site_licences 
					(
					customerID,domainName,licenceKey,packageKey,packageVersion,orderID,parentDomain,licenseType,expiry,multipleDomainFrontend,multipleDomainBackend,domainTypeDev,multiPackage,domainstatus,addons,branchCode,CreateDate,comments,adminId,expiryDate
					)
				VALUES
					(
					'".$this->escape($_POST['customerID'])."','".$this->escape($_POST['domainName'])."','".$resultlicenc."','".$this->escape($_POST['packageKey'])."','".$this->escape($_POST['packageVersion'])."','".$this->escape($_POST['orderID'])."','".$this->escape($_POST['parentDomain'])."','".$this->escape($_POST['licenseType'])."','".$this->escape($_POST['expiry'])."','".$this->escape($_POST['multipleDomainFrontend'])."','".$this->escape($_POST['multipleDomainBackend'])."','".$this->escape($_POST['domainTypeDev'])."','".$this->escape($_POST['multiPackage'])."','".$this->escape($_POST['domainstatus'])."','".$this->escape($_POST['addons'])."','".$this->escape($_POST['branchCode'])."',now(),'".$this->escape($_POST['comments'])."','".$this->escape($adminId)."'";
			
			if($_POST['expiry']=="Yes")
			{
				$sql.=",'".$this->escape($_POST['expiryDate'])."' ";
			}
			else if($_POST['expiry']=="No")
			{
				$sql.=",'0000-00-00' ";
			}			
			$sql.=") "; 
			$this->ObjDatabase->setQuery($sql);	
			$licenceID = $this->ObjDatabase->getInsertId();
		}
		return $licenceID;				
	}

	public function getParentLicense()
	{
		$sql=" 
			SELECT 
				license.licenceID, license.domainName
			FROM 
				site_licences AS license
			WHERE
				license.parentDomain='0'; ";			
		return  $this->ObjDatabase->readValues($sql);
	}
	
	/* To Get the License Details To Send Mail*/
	public function getLicenseDetailsForMail($licenceIDs,$status)
	{
		$sql=" 
			SELECT 
				license.licenceID as licenceID, license.customerID as customerID, license.domainName as domainName, license.licenceKey as licenceKey, license.domainstatus as domainstatus, license.packageKey as packageKey, license.packageVersion as packageVersion, license.branchCode as branchCode, license.parentDomain as parentDomain, license.expiry as expiry, license.createDate as createDate, license.expiryDate as expiryDate, license.addons as addons, license.licenseType as licenseType, license.hardwareAddr as hardwareAddr, license.serverPath as serverPath, license.domainIP as domainIP, license.hostName as hostName, license.orderID as orderID, license.comments as comments, 
				package.packageName as packageName, 
				customer.customerFirstName as customerFirstName, customer.customerLastName as customerLastName, customer.customerEmailID as customerEmailID, 
				site_access.accessTime as accessTime, site_access.accessIP as accessIP, count(site_access.licenceID) as accessCount
			FROM 
				site_licences AS license
				LEFT JOIN customer_info AS customer ON license.customerID=customer.customerID
				LEFT JOIN package_info AS package ON license.packageKey=package.packageKey
				LEFT JOIN site_access_details AS site_access ON license.licenceID=site_access.licenceID 
			WHERE
				license.licenceID IN (".$licenceIDs.") ";	
		$sql.= "AND license.domainstatus !='Deleted' AND site_access.accessStatus='".$status."'  
				Group By license.licenceID ";
		return  $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);			
	}
	
	//Function to Get Total Licensed Domains
	public function getLicenseCount($adminId,$branchCodeSes)
	{
		if($adminId>1)
		{
			$sql = "SELECT 
						COUNT(license.licenceID) AS licenseCount 
					FROM 
						site_licences AS license 
					WHERE 
						license.domainstatus !='Deleted' AND license.branchCode='".$branchCodeSes."' ";
		}
		else
		{
			$sql = "SELECT 
						COUNT(license.licenceID) AS licenseCount 
					FROM 
						site_licences AS license 
					WHERE 
						license.domainstatus !='Deleted' ";
		}
		return $this->ObjDatabase->readValue($sql);
	}
	//End of function
	
	//Function to Get Total Blocked Licensed Domains
	public function getLicenseBlockCount($adminId,$branchCodeSes)
	{
		if($adminId>1)
		{
			$sql = "SELECT 
						COUNT(license.licenceID) AS licenseCount 
					FROM 
						site_licences AS license 
					WHERE 
						license.domainstatus ='full blocked' AND license.branchCode='".$branchCodeSes."' ";
		}
		else
		{
			$sql = "SELECT 
						COUNT(license.licenceID) AS licenseCount 
					FROM 
						site_licences AS license 
					WHERE 
						license.domainstatus ='full blocked' ";
		}
		return $this->ObjDatabase->readValue($sql);
	}
	//End of function
	
	//Function to Get Total Partial Blocked Licensed Domains
	public function getLicensePartBlockCount($adminId,$branchCodeSes)
	{
		if($adminId>1)
		{
			$sql = "SELECT 
						COUNT(license.licenceID) AS licenseCount 
					FROM 
						site_licences AS license 
					WHERE 
						( (license.domainstatus ='manage blocked') OR (license.domainstatus ='frontend blocked') OR (license.domainstatus ='other blocked')) AND license.branchCode='".$branchCodeSes."'";
		}
		else
		{
			$sql = "SELECT 
						COUNT(license.licenceID) AS licenseCount 
					FROM 
						site_licences AS license 
					WHERE 
						( (license.domainstatus ='manage blocked') OR (license.domainstatus ='frontend blocked') OR (license.domainstatus ='other blocked'))";
		}
		return $this->ObjDatabase->readValue($sql);
	}
	//End of function
	
	//Function to Get Multiple Domain Licensed Domains
	public function getLicenseMultiCount($adminId,$branchCodeSes)
	{
		if($adminId>1)
		{
			$sql = "SELECT 
						COUNT(license.licenceID) AS licenseCount 
					FROM 
						site_licences AS license 
					WHERE 
						( (license.multipleDomainFrontend ='Yes') OR (license.multipleDomainBackend ='Yes') ) AND license.branchCode='".$branchCodeSes."'";
		}
		else
		{
			$sql = "SELECT 
						COUNT(license.licenceID) AS licenseCount 
					FROM 
						site_licences AS license 
					WHERE 
						( (license.multipleDomainFrontend ='Yes') OR (license.multipleDomainBackend ='Yes') )";
		}
		return $this->ObjDatabase->readValue($sql);
	}
	//End of function
	/* list License Recent Invalid Access For Dashboard*/	
	public function listLicenseInvalidDashboard($limitFrom="",$limitTo="")
	{
		if ($limitTo)
			$selectFields .= "SQL_CALC_FOUND_ROWS ";	
		$sql=" 
			SELECT ".$selectFields."
				site_access.licenceID as licenceID, site_access.domainName as domainName, site_access.licenceKey as licenceKey, site_access.accessStatus as accessStatus, site_access.accessData as accessData, site_access.accessTime as accessTime, site_access.prevaccessData as prevaccessData, site_access.accessedPath as accessedPath, site_access.accessIP as accessIP, site_access.section as section, site_access.module as module, site_access.moduleAction as moduleAction, count(site_access.licenceKey) as invalidCount 
			FROM 
				site_access_details AS site_access 
			WHERE 
				site_access.accessStatus='License Not Valid' 
			Group By site_access.licenceKey ";			


		$sql.= "ORDER BY site_access.accessTime desc ";
		if ($limitTo)
		{
			$sql .= " LIMIT " . $limitFrom . ", " . $limitTo . " ";
		}
				
		return  $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);
	}
	
	/* list License Recently Installed, Unauthorized, Expired For Dashboard*/
	public function listLicenseInstallDashboard($limitFrom="",$limitTo="",$status)
	{
		if ($limitTo)
			$selectFields .= "SQL_CALC_FOUND_ROWS ";	
		$sql=" 
			SELECT ".$selectFields."
				site_access.licenceID as licenceID, site_access.domainName as domainName, site_access.licenceKey as licenceKey, site_access.accessStatus as accessStatus, site_access.accessData as accessData, site_access.accessTime as accessTime, site_access.prevaccessData as prevaccessData, site_access.accessedPath as accessedPath, site_access.accessIP as accessIP, site_access.section as section, site_access.module as module, site_access.moduleAction as moduleAction, count(site_access.licenceKey) as accessCount
			FROM 
				site_access_details AS site_access 
			WHERE 1 ";
		if($status=="Install")
		{
			$sql.= " AND (site_access.accessStatus='Install' OR site_access.accessStatus='Install, Unauthorized') ";			
		}
		else if($status=="Expired")
		{
			$sql.= " AND site_access.accessStatus='License Expired' ";	
		}
		else if($status=="Unauthorized")
		{
			$sql.= " AND site_access.accessStatus='Unauthorized' ";	
		}
		$sql.= " Group By site_access.licenceKey ORDER BY site_access.accessTime desc ";
		if ($limitTo)
		{
			$sql .= " LIMIT " . $limitFrom . ", " . $limitTo . " ";
		}
				
		return  $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);
	}
	
	/* list License Unauthorized Dashboard Details */
	public function listUnauthDashboardDetail($licenceKey)
	{
		$sql=" 
			SELECT 
				site_access.licenceID as licenceID, site_access.domainName as domainName, site_access.licenceKey as licenceKey, site_access.accessStatus as accessStatus, site_access.accessData as accessData, site_access.accessTime as accessTime, site_access.prevaccessData as prevaccessData, site_access.accessedPath as accessedPath, site_access.accessIP as accessIP, site_access.section as section, site_access.module as module, site_access.moduleAction as moduleAction
			FROM 
				site_access_details AS site_access 
			WHERE
				site_access.accessStatus='Unauthorized' AND site_access.licenceKey = '".base64_encode($licenceKey)."' ";			


		$sql.= "ORDER BY site_access.accessTime desc ";
						
		return  $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);
	}
	
	/* list License Install Dashboard Details */
	public function listInstallDashboardDetail($licenceKey)
	{
		$sql=" 
			SELECT 
				site_access.licenceID as licenceID, site_access.domainName as domainName, site_access.licenceKey as licenceKey, site_access.accessStatus as accessStatus, site_access.accessData as accessData, site_access.accessTime as accessTime, site_access.prevaccessData as prevaccessData, site_access.accessedPath as accessedPath, site_access.accessIP as accessIP, site_access.section as section, site_access.module as module, site_access.moduleAction as moduleAction
			FROM 
				site_access_details AS site_access 
			WHERE
				(site_access.accessStatus='Install' OR site_access.accessStatus='Install, Unauthorized') AND site_access.licenceKey = '".base64_encode($licenceKey)."' ";			


		$sql.= "ORDER BY site_access.accessTime desc ";
						
		return  $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);
	}
	
	/* list License Expired Dashboard Details */
	public function listExpiredDashboardDetail($licenceKey)
	{
		$sql=" 
			SELECT 
				site_access.licenceID as licenceID, site_access.domainName as domainName, site_access.licenceKey as licenceKey, site_access.accessStatus as accessStatus, site_access.accessData as accessData, site_access.accessTime as accessTime, site_access.prevaccessData as prevaccessData, site_access.accessedPath as accessedPath, site_access.accessIP as accessIP, site_access.section as section, site_access.module as module, site_access.moduleAction as moduleAction
			FROM 
				site_access_details AS site_access 
			WHERE
				site_access.accessStatus='License Expired' AND site_access.licenceKey = '".base64_encode($licenceKey)."' ";			


		$sql.= "ORDER BY site_access.accessTime desc ";
						
		return  $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);
	}
	
	//Function to Get Access Count
	public function licenseUnauthInstDayCount($day,$fromDate="",$toDate="")
	{
		$sql = "SELECT 
					site_access.siteaccessID AS siteaccessID, site_access.accessStatus as accessStatus, site_access.licenceID as licenceID  
				FROM 
					site_access_details AS site_access 
				WHERE 1 ";
		if($day=="today")
		{
			$sql.= "AND DATE_FORMAT(site_access.accessTime,'%Y-%m-%d')='".date('Y-m-d')."' ";
		}
		else if($day=="thisweek")
		{
			$sql.= "AND site_access.accessTime BETWEEN DATE_SUB( CURDATE( ),INTERVAL 7 DAY ) AND CURDATE( ) ";
		}
		else if($day=="MonthToDate")
		{
			$sql.= "AND site_access.accessTime BETWEEN '".$fromDate."' AND '".date('Y-m-d')."' ";
		}
		else if($day=="LastMonth")
		{
			$sql.= "AND site_access.accessTime BETWEEN '".$fromDate."' AND '".$toDate."' ";
		}
		$listDashboard	= $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);
		$listInstall	= array();
		$listUnauth		= array();
		$listInvalid	= array();
		$listExpired	= array();
		for($i=0;$i<count($listDashboard);$i++)
		{
			if(($listDashboard[$i]['accessStatus']=="Install") || ($listDashboard[$i]['accessStatus']=="Install, Unauthorized"))
			{
				$listInstall[$i]	= $listDashboard[$i]['siteaccessID'];
			}
			else if($listDashboard[$i]['accessStatus']=="License Expired")
			{
				$listExpired[$i]	= $listDashboard[$i]['siteaccessID'];
			}
			else if($listDashboard[$i]['accessStatus']=="Unauthorized")
			{
				$listUnauth[$i]	= $listDashboard[$i]['siteaccessID'];
			}
			else if($listDashboard[$i]['licenceID']==0)
			{
				$listInvalid[$i]	= $listDashboard[$i]['siteaccessID'];
			}
		}
		
		return array($listInstall, $listExpired, $listInvalid, $listUnauth);
	}
	//End of function
	
	
	//Function to Get Today's Unauthorized Access Details
	public function unauthInstDayDetails($status,$day)
	{
		$sql = "SELECT 
					site_access.licenceID as licenceID, site_access.domainName as domainName, site_access.licenceKey as licenceKey, site_access.accessStatus as accessStatus, site_access.accessData as accessData, site_access.accessTime as accessTime, site_access.prevaccessData as prevaccessData, site_access.accessedPath as accessedPath, site_access.accessIP as accessIP, site_access.section as section, site_access.module as module, site_access.moduleAction as moduleAction 
				FROM 
					site_access_details AS site_access 
				WHERE 1 ";
		if($day=="today")
		{
			$sql.= "AND DATE_FORMAT(site_access.accessTime,'%Y-%m-%d')='".date('Y-m-d')."' ";
		}
		else if($day=="thisweek")
		{
			$sql.= "AND site_access.accessTime BETWEEN DATE_SUB( CURDATE( ),INTERVAL 7 DAY ) AND CURDATE( ) ";
		}
		else if($day=="MonthToDate")
		{
			$sql.= "AND site_access.accessTime BETWEEN '".date('Y-m-01')."' AND '".date('Y-m-d')."' ";
		}
		else if($day=="LastMonth")
		{
			$sql.= "AND site_access.accessTime BETWEEN DATE_SUB( CURDATE( ),INTERVAL 1 MONTH ) AND '".date('Y-m-30')."' ";
		}

		if($status=="Unauthorized")
		{					
			$sql.= "AND site_access.accessStatus='Unauthorized' ";
		}
		else if($status=="Invalid")
		{					
			$sql.= "AND site_access.accessStatus='License Not Valid' ";
		}
		else
		{
			$sql.= "AND (site_access.accessStatus='Install' OR site_access.accessStatus='Install, Unauthorized') ";
		}
		$sql.= "ORDER BY site_access.accessTime desc ";
		return $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);
	}
	//End of function
	
	/* To Get the License Details For All Domains, Install and Unauthorized View*/
	public function getLicenseSub($params=array())
	{
		extract($params);
		if($adminId>1)
		{
			$sql=" 
			SELECT 
				license.licenceID as licenceID, license.customerID as customerID, license.domainName as domainName, license.licenceKey as licenceKey, license.multipleDomainFrontend as multipleDomainFrontend, license.multipleDomainBackend as multipleDomainBackend, license.domainstatus as domainstatus, license.packageKey as packageKey, license.packageVersion as packageVersion, license.branchCode as branchCode, license.parentDomain as parentDomain, license.expiry as expiry, license.createDate as createDate, license.expiryDate as expiryDate, license.addons as addons, license.licenseType as licenseType, license.hardwareAddr as hardwareAddr, license.serverPath as serverPath, license.domainIP as domainIP, license.hostName as hostName, license.orderID as orderID, 
				package.packageName as packageName, 
				CONCAT(admin_users.adminUserFirstName, ' ', admin_users.adminUserLastName) as adminUserName 
			FROM 
				site_licences AS license
				LEFT JOIN package_info AS package ON license.packageKey=package.packageKey 
				LEFT JOIN dp_admin_users AS admin_users ON license.adminId=admin_users.adminUserID 
			WHERE
				license.parentDomain = '".$licenceID."' AND license.branchCode='".$branchCodeSes."'";	
		}
		else
		{
			$sql=" 
				SELECT 
					license.licenceID as licenceID, license.customerID as customerID, license.domainName as domainName, license.licenceKey as licenceKey, license.multipleDomainFrontend as multipleDomainFrontend, license.multipleDomainBackend as multipleDomainBackend, license.domainstatus as domainstatus, license.packageKey as packageKey, license.packageVersion as packageVersion, license.branchCode as branchCode, license.parentDomain as parentDomain, license.expiry as expiry, license.createDate as createDate, license.expiryDate as expiryDate, license.addons as addons, license.licenseType as licenseType, license.hardwareAddr as hardwareAddr, license.serverPath as serverPath, license.domainIP as domainIP, license.hostName as hostName, license.orderID as orderID,     
					package.packageName as packageName,  
					CONCAT(admin_users.adminUserFirstName, ' ', admin_users.adminUserLastName) as adminUserName 
				FROM 
					site_licences AS license
					LEFT JOIN package_info AS package ON license.packageKey=package.packageKey 
					LEFT JOIN dp_admin_users AS admin_users ON license.adminId=admin_users.adminUserID 
				WHERE
					license.parentDomain = '".$licenceID."' ";	
		}

		return $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);
	}
	
	/* Check Package is Used before Status updated */
	public function checkPackageUsed($packageKeys=array())
	{
		$sql="	SELECT 
					license.licenceID as licenceID
				FROM 
					site_licences AS license
				WHERE
					license.packageKey IN ('".implode("','",$packageKeys)."') AND license.domainstatus!='Deleted' ";	
		return $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);
	}
	
	/* Check Customer is Used before Status updated */
	public function checkCustomerUsed($customerIDs=array())
	{
		$sql="	SELECT 
					license.licenceID as licenceID
				FROM 
					site_licences AS license
				WHERE
					license.customerID IN ('".implode("','",$customerIDs)."') AND license.domainstatus!='Deleted' ";	
		return $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);
	}
	
	/* Check License Domain Is a Parent before Status update */
	public function checkLicenseParent($licenseIDs=array())
	{
		$sql="	SELECT 
					license.licenceID as licenceID
				FROM 
					site_licences AS license
				WHERE
					license.parentDomain IN ('".implode("','",$licenseIDs)."') AND license.domainstatus!='Deleted' ";	
		return $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);
	}
	
	/* Check Domain name Already Exist Before License Add */
	public function checkLicenseExist($licenseID="")
	{
		$sql="	SELECT 
					license.licenceID as licenceID
				FROM 
					site_licences AS license
				WHERE
					license.domainName='".$_POST['domainName']."' AND license.domainstatus!='Deleted' ";
		if($_POST['packageKey']!="")
		{
			$sql.="	AND license.packageKey='".$_POST['packageKey']."' ";
		}			
		$sql.="	limit 1";
		if($licenseID!="")
		{
			$result	= $this->ObjDatabase->getFields($sql);
			if($result[0]!=$licenseID)
			{
				return $result;
			}
			else if($result[0]==$licenseID)
			{
				return array();
			}
		}
		else
		{
			return $this->ObjDatabase->getFields($sql);
		}
	}
	
	/* Update the Tracked Access details of Recently Installed */
	public function updateAccessTrack($licenceIDs=array(),$status)
	{
		$sql="	UPDATE 
					site_access_details 
				SET 
					accessTrack='Yes'
				WHERE
					site_access_details.licenceID IN ('".implode("','",$licenceIDs)."') ";
		if($status=="Install")
		{
			$sql	.="AND (site_access_details.accessStatus='".$status."' OR site_access_details.accessStatus='Install, Unauthorized') ";
		}
		else if($status=="Expired")
		{
			$sql	.="AND site_access_details.accessStatus='License Expired' ";
		}
		else
		{
			$sql	.="AND site_access_details.accessStatus='".$status."' ";
		}
		$this->ObjDatabase->setQuery($sql);
	}
	
	// Clean Tracked Install Access
	public function cleanTrackedAccess($status)
	{
		$sql	= "	DELETE 
					FROM 
						site_access_details 
					WHERE
						site_access_details.accessTrack='Yes' ";
		if($status=="Install")
		{
			$sql	.=	"AND (site_access_details.accessStatus='".$status."' OR 
						site_access_details.accessStatus='Install, Unauthorized') ";
		}
		else if($status=="Expired")
		{
			$sql	.=	"AND site_access_details.accessStatus='License Expired' ";
		}
		else
		{
			$sql	.=	"AND site_access_details.accessStatus='".$status."' ";
		}
		$this->ObjDatabase->setQuery($sql);
	}
	
}
