<?php
/****************************************************************************
*																			*
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.	*
*																			*
* This  is  commercial  software,  only  users  who have purchased a valid	*
* license  and  accept  to the terms of the  License Agreement can install	*
* and use this program.														*
*																			*
* ***************************************************************************
* PLEASE READ THE FULL TEXT OF THE SOFTWARE LICENSE AGREEMENT IN THE		*
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.				*
* ***************************************************************************/
//
//$Id: LogModel.php, v 1.0 2012/05/10 20:52:11
//
class LogModel extends Model
{
	//FUNCTION TO SAVE VISITOR DETAILS
	public function saveVisitorDetails($userType = 'manage', $currentURL = '', $httpReferer,$languageIDs=array())
	{
		$userAgent		=	$_SERVER['HTTP_USER_AGENT']; //BROWSER USER AGENT		
		$remoteAddress	=	$this->getIpAddress(); //REMOTE IP ADDRESS
		$languageID		=	isset($languageIDs['Current']) ? $languageIDs['Current']  : '';
		if($userType=="manage")
		{
			$tableName			=	DB_PREFIX."visitor_info_log_admin";
		}
		else
		{
			$tableName			=	DB_PREFIX."visitor_info_log";
		}
		
		$sql			=	"	INSERT INTO
									" .$tableName."
										(
											entryPage,
											entryTime,
											userAgent,
											httpReferer,
											remoteAddress,
											userType,
											languageID
										)
								VALUES
										(
											'".$this->escape($currentURL, false). "',
											NOW(),
											'".$userAgent."',
											'".$this->escape($httpReferer, false)."',
											'".$remoteAddress."',
											'".$userType."',
											'".$languageID."'
										)";
		$this->ObjDatabase->setQuery($sql);		
		$visitorID		=	$this->ObjDatabase->getInsertId();
		return $visitorID;
	}
	
	//FUNCTION TO SAVE EACH AND EVERY URLS
	public function saveURLInfo($visitorID, $currentURL, $now = "", $httpReferer = '',$userType)
	{
		if($visitorID>0){
			if ($now == 1){
				$sql			=	"	SELECT 
											currentUrl
										FROM
											". DB_PREFIX."visitor_url_log
										WHERE
											visitorID=
												(
													SELECT
														MAX(visitorID)
													FROM 
														" . DB_PREFIX ."visitor_url_log
													WHERE 
														visitorID='" .$visitorID."'
													LIMIT 1
												)";
				$resURLs		=	$this->ObjDatabase->readValue($sql);
				$dbCurrentURL	=	$resURLs['currentUrl'];
			}
			if ((!$now || $now == '') || ($now == 1 && $dbCurrentURL != $currentURL)) {
				if($userType=='manage')
				{
					$tableName	=	DB_PREFIX."visitor_url_log_admin";
				}
				else
				{
					$tableName	=	DB_PREFIX."visitor_url_log";
				}
				$sql			=	"	INSERT INTO
											" . $tableName."
												(
													visitorID,
													currentUrl,
													refererUrl,
													visitTime
												)
										VALUES
												(
													'" . $visitorID . "',
													'" . $this->escape($currentURL, false) . "',
													'" . $this->escape($httpReferer, false) . "',
													NOW()
												)";
				$this->ObjDatabase->setQuery($sql);
			}
		}
		return true;
	}
	//FUNCTION TO UPDATE VISITOR TO USER DETAILS
	public function updateVisitorDetails($visitorID, $userID = 0, $currentURL = "", $visitorType = '', $refType = '', $hostName = '',$refDetails='')
	{			
		if($visitorType=='manage')
		{
			$tableName	=	DB_PREFIX."visitor_info_log_admin";
		}
		else
		{
			$tableName	=	DB_PREFIX."visitor_info_log";
		}
		$sql				=	"	SELECT
										referrerType,
										referrerDetails,
										referrerWebSite
									FROM 
										".$tableName."
									WHERE
										visitorID='".$visitorID."'
									LIMIT 1";
		$resAllRefValues	=	$this->ObjDatabase->readValue($sql);
		$dbRefType			=	$resAllRefValues['referrerType'];	
		$dbRefDetails		=	$resAllRefValues['referrerDetails'];
		$dbRefWebsite		=	$resAllRefValues['referrerWebSite'];
		if($visitorID>0){
			$sql	=	"	UPDATE
								" .$tableName. "
							SET ";
			if($userID >0){
				$sql.= "userID='" . $userID . "',
							loginTime=NOW()";
				if ($visitorType){
					$sql.= " ,userType='" . $visitorType . "'";
				}
			} else {
				if ($refType){
					if($dbRefType==''&&($refType!='' &&$refDetails!='')){
						$sql.="referrerType='".$refType."'";
					}
					if($dbRefDetails==''&&($refType!='' &&$refDetails!='')){
						$sql.=",referrerDetails='".$refDetails."'";
					}
					if($dbRefWebsite==''){
						$sql.=",referrerWebSite='".$hostName."'";
					}
					/*$sqlUpdateVisitorDetails .= " referrerType='" . $refType . "',
					referrerWebSite='" . $hostName . "',referrerDetails='".$refDetails."'";*/
				} else{
					$sql .= "logoutTime=NOW()";
				}
			}
			$sql .= " WHERE
						visitorID=" .(int)$visitorID . "
					LIMIT 1";	
								
			$this->ObjDatabase->setQuery($sql);
			
		}
		return true;
	}
	//FUNCTION TO RETRIVE VISITOR DETAILS
	public function getDetails($visitorID = '')
	{
		$sql	=	"	SELECT 
							userID,
							doneSubscribe,
							orderAmount
						FROM
							" . DB_PREFIX . "visitor_info_log ";
		if($visitorID){
			$sql .=	"
						WHERE
							visitorID=" .(int)$visitorID . "";
		}
		$sql .=	" LIMIT 1";
		$resVisitorDetails = $this->ObjDatabase->readValue($sql);
		return $resVisitorDetails;
	} 

	//FUNCTION TO RETRIEVE BOUNCE RATE DETAIL PAGE
	public function getBounceRateInPages($limitFrom = 0, $limitTo, $cityArr, $refIDString, $fromDate, $toDate = '', $countryQueryString = '', $cityQueryString = '', $platform = '')
	{
		if ($limitTo && (!$nolimit || $nolimit = '')) {
			$paginationText = " SQL_CALC_FOUND_ROWS ";
		}
		$sql	=	"	SELECT " . $paginationText . "
							visInfLog.visitorID,
							visInfLog.entryPage,
							(
								CASE 
									WHEN 
										((visInfLog.entryPage='') OR (SUBSTRING(visInfLog.entryPage FROM 1 FOR (LOCATE ('/',visInfLog.entryPage)-1)))IN('" . $cityArr . "')OR (SUBSTRING(visInfLog.entryPage FROM 1 FOR (LOCATE('/',visInfLog.entryPage)-1)))IN('" . $refIDString . "') )
									THEN 
										'index' 
									ELSE 
										SUBSTRING(visInfLog.entryPage FROM 1 FOR (LOCATE ('/',visInfLog.entryPage)-1)) 
								END 
							) AS controlername,						
							COUNT(visInfLog.visitorID) AS totalvisits
						FROM 
							" . DB_PREFIX . "visitor_info_log visInfLog 
						WHERE 
							visInfLog.pageCount>0 
							AND 
								(visInfLog.userType='guest' OR visInfLog.userType='user') 
							AND 
								referrerType!='Crawlers'";
		if ($fromDate && !$toDate) {
			$sql .= "AND DATE(entryTime)='" . $fromDate . "'";
		} else {
			$sql .= "AND DATE(entryTime)>='" . $fromDate . "'";
		}
		if ($toDate) {
			$sql .= " AND DATE(entryTime)<='" . $toDate . "'";
		}
		if ($countryQueryString) {
			$sql .= " AND country IN('" . $countryQueryString . "')";
		}
		if ($cityQueryString) {
			$sql .= " AND city IN('" . $cityQueryString . "')";
		}
		if (!$platform || $platform != 'All') {
			if ($platform == 'Web') {
				$sql .= " AND isMobileWeb='No'";
			} else if ($platform == 'Apps') {
				$sql .= " AND isMobileWeb='Yes'";
			}
		}
		$sql .= "  GROUP BY controlername";
		if ($limitTo && (!$nolimit || $nolimit = '')) {
			$sql .= " LIMIT  " . $limitFrom . "," . $limitTo . " ";
		}		
		$resBounceInPages = $this->ObjDatabase->readValues($sql);
		return $resBounceInPages;
	}
	//FUNCTION TO FETCH BOUNCERATE UPON DIFFERENT CRITERIA
	public function getBounceCount($extended_controllerName, $fromDate, $toDate, $countryQueryString, $cityQueryString, $platform, $bounceType, $referralOrgin = '', $refdetails = '')
	{
		if ($bounceType == 'page') {
			$resRefKeyArr	=	$this->listAllRefIDs();
			$sql			=	"	SELECT 
										visitorID 
									FROM 
										".DB_PREFIX."visitor_info_log
									WHERE 
										(
											(entryPage LIKE '" . $extended_controllerName . "%')";
			if ($extended_controllerName == 'index'){
				$sql .= " OR (entryPage='')";
				foreach ($resRefKeyArr as $refKey) {
					$refControllerName = $refKey;
					$sql .= " OR (entryPage LIKE '" . $refControllerName . "%') ";
				}
			}
			$sql .= " 					)
									AND
										pageCount=1
									AND 
										( `userType`='user' OR `userType`='guest')
									AND referrerType!='Crawlers'";
		} else if ($bounceType == 'browser') {
			$sql	=	"	SELECT
								visitorID
							FROM 
								".DB_PREFIX."visitor_info_log
							WHERE 
								pageCount=1 
								AND 
									( `userType`='user' OR `userType`='guest') 
								AND 
									referrerType!='Crawlers' 
								AND ";
			if ($extended_controllerName != 'Unknown') {
				$sql .= " browserName ='" . $extended_controllerName . "'";
			} else {
				$sql .= "browserName=''";
			}
		} else if ($bounceType == 'os') {
			$sql	=	"	SELECT 
								visitorID 
							FROM 
								".DB_PREFIX."visitor_info_log
							WHERE 
								pageCount=1
								AND
									( `userType`='user' OR `userType`='guest') 
								AND
									referrerType!='Crawlers' ";
			if ($extended_controllerName != 'Unknown') {
				$sql .= " AND operatingSystem ='" . $extended_controllerName . "'";
			} else {
				$sql .= " AND 
							(
								( operatingSystem= '" . $extended_controllerName . "')
								OR 
								(!operatingSystem)
							)";
			}
		} else if ($bounceType == 'ref') {
			$extended_controllerNameArr = explode("~*", $extended_controllerName);
			$extended_controllerName	= $extended_controllerNameArr[0];
			$isSearchEngine			 = $extended_controllerNameArr[1];
			if ($extended_controllerName == 'Direct') {
				//commented the above query to include the referrtype=affiliate and referrer eqauls direct to consider as direct
				$sql	=	"	SELECT 
									visitorID
								FROM 
									".DB_PREFIX."visitor_info_log 
								WHERE 
									pageCount=1 
									AND 
										( `userType`='user' OR `userType`='guest')
									AND 
										referrerType!='Crawlers' 
									AND 
										(referrerType='' OR referrerType='affiliate' )
									AND 
										referrerWebSite=''  
									AND 
										referrerDetails='' 
									AND 
										(
											(httpReferer LIKE 'direct') 
											OR 
											(!httpReferer)
										) 
									AND 
										searchEngineName=''";
			} else if ($extended_controllerName == 'user') {
				$sql	=	"	SELECT
									visitorID
								FROM 
									".DB_PREFIX."visitor_info_log
								WHERE 
									pageCount=1 
									AND 
										( `userType`='user' OR `userType`='guest')
									AND 
										referrerType!='Crawlers' 
									AND 
										referrerType='user'";
				if ($refdetails != '' && $refdetails != 'NULL') {
					$sql .= " AND referrerDetails='" . $refdetails . "'";
				}
				if ($referralOrgin != '' && $referralOrgin != 'NULL') {
					$sql .= " AND referrerWebSite='" . $referralOrgin . "'";
				}				
			} else if ($extended_controllerName == 'affiliate'){
				$sql	=	"	SELECT
									visitorID
								FROM 
									".DB_PREFIX."visitor_info_log 
								WHERE 
									pageCount=1 
									AND 
										( `userType`='user' OR `userType`='guest')
									AND 
										referrerType!='Crawlers'
									AND 
										referrerType='affiliate' 
									AND 
										referrerDetails!=''";
				if ($refdetails != '' && $refdetails != 'NULL') {
					$sql .= " AND referrerDetails='" . $refdetails . "'";
				}
				if ($referralOrgin != '' && $referralOrgin != 'NULL') {
					$sql .= " AND referrerWebSite='" . $referralOrgin . "'";
				}
			} else if ($isSearchEngine == 'search_engine'){
				$sql	=	"	SELECT
									visitorID 
								FROM 
									".DB_PREFIX."visitor_info_log
								WHERE 
									pageCount=1 
									AND 
										( `userType`='user' OR `userType`='guest') 
									AND 
										referrerType!='Crawlers' 
									AND 
										searchEngineName LIKE '%" . $extended_controllerName . "%'";
			} else {
				$sql	=	"	SELECT 
									visitorID 
								FROM 
									".DB_PREFIX ."visitor_info_log 
								WHERE 
									pageCount=1 
									AND 
										( `userType`='user' OR `userType`='guest') 
									AND 
										referrerType!='Crawlers' 
									AND 
										httpReferer LIKE '" . $extended_controllerName . "%'";
			}
		}
		//COMMON SEARCHING CRITERIA
		if ($fromDate && !$toDate) {
			$sql .= " AND DATE(entryTime)='" . $fromDate . "'";
		} else {
			$sql .= " AND DATE(entryTime)>='" . $fromDate . "'";
		}
		if ($toDate) {
			$sql .= " AND DATE(entryTime)<='" . $toDate . "'";
		}
		if ($countryQueryString) {
			$sql .= " AND country IN('" . $countryQueryString . "')";
		}
		if ($cityQueryString) {
			$sql .= " AND city IN('" . $cityQueryString . "')";
		}
		if (!$platform || $platform != 'All') {
			if ($platform == 'Web') {
				$sql .= " AND isMobileWeb='No'";
			} else if ($platform == 'Apps') {
				$sql .= " AND isMobileWeb='Yes'";
			}
		}
		$resBounceCount = $this->ObjDatabase->readValues($sql);
		return $resBounceCount;
	}
	//FUNCTION TO  BOUNCE RATE DETAIL PAGE
	public function getBounceRateDetail($fromDate = '', $toDate = '', $cityString = '', $countryList = '', $platform = '')
	{
		$sql	=	"	SELECT 
							visitorID,
							entryPage,
							browserName,
							operatingSystem,
							httpReferer,
							city,
							pageCount,
							searchEngineName,
							referrerType,
							referrerDetails,
							searchKeyWord
						FROM 
							".DB_PREFIX."visitor_info_log 
						WHERE ";
		if ($cityString) {
			$sql .= " city IN('" . $cityString . "') AND ";
		}
		if ($countryList) {
			$sql .= " country IN('" . $countryList . "') AND ";
		}
		if ($fromDate && !$toDate) {
			$sql .= " DATE(entryTime)='" . $fromDate . "'";
		} else {
			$sql .= "DATE(entryTime)>='" . $fromDate . "' AND DATE(entryTime)<='" . $toDate . "'";
		}
		if (!$platform || $platform != 'All') {
			if ($platform == 'Web') {
				$sql .= " AND isMobileWeb='No'";
			} else if ($platform == 'Apps') {
				$sql .= " AND isMobileWeb='Yes'";
			}
		}
		$sql .= " AND 
					pageCount>0
				AND 
					(userType='user' OR userType='guest') 
				AND 
					referrerType!='Crawlers'";
		$resBounceDetails = $this->ObjDatabase->readValuesObject($sql);
		return $resBounceDetails;
	}
	//FUNCTION TO FETCH ALL PAGE NAMES
	public function listPageNames()
	{
		$sql	=	"	SELECT 
							* FROM 
								".DB_PREFIX."page_name";
		$resAllPages			=	$this->ObjDatabase->readValuesObject($sql);
		$pageCount				=	$resAllPages->num_rows;
		for ($pg = 0; $pg < $pageCount; $pg++) {
			$pageResultSet		=	$resAllPages->fetch_array(MYSQL_ASSOC);
			$pageDetails[$pg]['keyword']	=	$pageResultSet['pageKeyword'];
			$pageDetails[$pg]['name']	=	$pageResultSet['pageName'];
		}
		unset($pageResultSet);
		return $pageDetails;
	}
	//FUNCTION TO LIST ALL REFERRAL IDS OF USER
	public function listAllRefIDs()
	{
		$sql	=	"	SELECT 
							userReferralID 
						FROM 
							".DB_PREFIX."users";
		$resRefID	=	$this->ObjDatabase->readValuesObject($sql);
		$referalsCount = $resRefID->num_rows;
		for ($refCount = 0; $refCount < $referalsCount; $refCount++) {
			$refResultSet		=	$resRefID->fetch_array(MYSQL_ASSOC);
			$refIDarray[$refCount]=	$refResultSet['userReferralID'];
		}
		return $refIDarray;
	}
	//FUNCTION TO DISPLAY BOUNCE RATE DISTRIBUTION IN BROWSERS
	public function listBrowserBounce($limitFrom = 0, $limitTo, $fromDate, $toDate = '', $countryQueryString = '', $cityQueryString = '', $platform = '')
	{
		if ($limitTo) {
			$paginationText = " SQL_CALC_FOUND_ROWS ";
		}
		$sql	=	"	SELECT " . $paginationText . " 
							IF
								(visInfLog.browserName='','Unknown',visInfLog.browserName) AS browsers,
							COUNT(visInfLog.visitorID) AS totalvisits
						FROM 
							" . DB_PREFIX . "visitor_info_log visInfLog 
						WHERE 
								visInfLog.pageCount>0 
								AND 
									(visInfLog.userType='user' OR visInfLog.userType='guest')
								AND 
									referrerType!='Crawlers'";
		if ($fromDate && !$toDate) {
			$sql .= "AND DATE(entryTime)='" . $fromDate . "'";
		} else {
			$sql .= "AND DATE(entryTime)>='" . $fromDate . "'";
		}
		if ($toDate) {
			$sql .= " AND DATE(visInfLog.entryTime)<='" . $toDate . "'";
		}
		if ($countryQueryString) {
			$sql .= "AND visInfLog.country IN('" . $countryQueryString . "')";
		}
		if ($cityQueryString) {
			$sql .= " AND visInfLog.city IN('" . $cityQueryString . "')";
		}
		if (!$platform || $platform != 'All') {
			if ($platform == 'Web') {
				$sql .= " AND isMobileWeb='No'";
			} else if ($platform == 'Apps') {
				$sql .= " AND isMobileWeb='Yes'";
			}
		}
		$sql .= "GROUP BY browserName";
		if ($limitTo) {
			$sql .= " LIMIT  " . $limitFrom . "," . $limitTo . " ";
		}
		$resBrowserBounce = $this->ObjDatabase->readValues($sql);
		return $resBrowserBounce;
	}
	//FUNCTION TO FETCH BOUNCE RATE IN OPERATING SYSTEM
	public function listOsBounce($limitFrom = 0, $limitTo, $fromDate, $toDate, $countryQueryString, $cityQueryString, $platform = '')
	{
		if ($limitTo) {
			$paginationText = " SQL_CALC_FOUND_ROWS ";
		}
		$sql	=	"	SELECT " . $paginationText . " 
							IF
								(visInfLog.operatingSystem!='',visInfLog.operatingSystem,'unknown') AS os,
							COUNT(visInfLog.visitorID) AS totalvisits
						FROM 
							" . DB_PREFIX . "visitor_info_log visInfLog 
						WHERE 
							visInfLog.pageCount>0 
							AND 
								(visInfLog.userType='user' OR visInfLog.userType='guest')
							AND 
								referrerType!='Crawlers' ";
		if ($fromDate && !$toDate) {
			$sql .= "AND DATE(entryTime)='" . $fromDate . "'";
		} else {
			$sql .= "AND DATE(entryTime)>='" . $fromDate . "'";
		}
		if ($toDate) {
			$sql .= " AND DATE(visInfLog.entryTime)<='" . $toDate . "'";
		}
		if ($countryQueryString) {
			$sql .= "AND visInfLog.country IN('" . $countryQueryString . "')";
		}
		if ($cityQueryString) {
			$sql .= " AND visInfLog.city IN('" . $cityQueryString . "')";
		}
		if (!$platform || $platform != 'All') {
			if ($platform == 'Web') {
				$sql .= " AND isMobileWeb='No'";
			} else if ($platform == 'Apps') {
				$sql .= " AND isMobileWeb='Yes'";
			}
		}
		$sql .= "GROUP BY os";
		if ($limitTo) {
			$sql .= " LIMIT  " . $limitFrom . "," . $limitTo . " ";
		}
		$resOSBounce = $this->ObjDatabase->readValues($sql);
		return $resOSBounce;
	}
	//FUNCTION TO FETCH BOUNCE RATE IN REFFERS
	public function listRefferlBounce($limitFrom = 0, $limitTo, $fromDate, $toDate = '', $countryQueryString = '', $cityQueryString = '', $platform = '')
	{
		if ($limitTo) {
			$paginationText = " SQL_CALC_FOUND_ROWS ";
		}
		$sql	=	"	SELECT" . $paginationText . "
										( 
											CASE 
												WHEN 
													(
														visInfLog.httpReferer='' AND visInfLog.referrerType='' AND visInfLog.referrerDetails=''
													)
												THEN 'Direct'
												WHEN 
													(
														visInfLog.httpReferer='direct' AND visInfLog.referrerType='' AND visInfLog.referrerDetails=''
													) 
												THEN 'Direct'
												WHEN 
													(
														visInfLog.httpReferer='direct'  AND visInfLog.referrerDetails=''  AND referrerType!=''
													) 
												THEN 'Direct'
												WHEN 
													(
														visInfLog.httpReferer=''  AND visInfLog.referrerDetails=''  AND referrerType!=''
													) 
												THEN 'Direct'
												WHEN 
													(
														visInfLog.referrerType!='' AND visInfLog.referrerDetails!='' 
													)	
												THEN visInfLog.referrerType
												WHEN 
													(
														visInfLog.searchEngineName!=''AND visInfLog.searchKeyWord!=''
													)
												THEN  
													CONCAT_WS('~*',visInfLog.searchEngineName,'search_engine') 
												WHEN 
													(
														visInfLog.httpReferer!='' AND visInfLog.httpReferer!='direct' AND visInfLog.referrerType='' AND visInfLog.referrerDetails=''
													)
												THEN  visInfLog.httpReferer
												WHEN 
													(
														visInfLog.httpReferer!='' AND visInfLog.httpReferer!='direct' AND visInfLog.referrerType!='' AND visInfLog.referrerDetails=''
													)
												THEN  visInfLog.httpReferer			
											END
										) AS refType,
										( 
											CASE
												WHEN 
													visInfLog.referrerDetails!='' 
												THEN 
													visInfLog.referrerDetails
												WHEN 
													visInfLog.referrerDetails='' 
												THEN 
													'NULL' 
											END
										)AS refdetails,
										(
											CASE
												WHEN  
													visInfLog.referrerWebSite='' 
												THEN 
													'NULL'
												WHEN 
													visInfLog.referrerWebSite!='' 
												THEN 
													visInfLog.referrerWebSite
											END
										) AS refsite, 
										COUNT(visInfLog.visitorID) AS totalvisits
									FROM  
										".DB_PREFIX ."visitor_info_log visInfLog
								 WHERE visInfLog.pageCount>0 AND (visInfLog.userType='user' OR visInfLog.userType='guest') AND referrerType!='Crawlers'";
		if ($fromDate && !$toDate) {
			$sql .= "AND DATE(entryTime)='" . $fromDate . "'";
		} else {
			$sql .= "AND DATE(entryTime)>='" . $fromDate . "'";
		}
		if ($toDate) {
			$sql .= " AND DATE(visInfLog.entryTime)<='" . $toDate . "'";
		}
		if ($cityQueryString) {
			$sql .= " AND visInfLog.city IN('" . $cityQueryString . "')";
		}
		if ($countryQueryString) {
			$sql .= " AND visInfLog.country IN('" . $countryQueryString . "') ";
		}
		if (!$platform || $platform != 'All') {
			if ($platform == 'Web') {
				$sql .= " AND isMobileWeb='No'";
			} else if ($platform == 'Apps') {
				$sql .= " AND isMobileWeb='Yes'";
			}
		}
		$sql .= "GROUP BY refType,refdetails,refsite";
		if ($limitTo) {
			$sql .= " LIMIT  " . $limitFrom . "," . $limitTo . " ";
		}		
		$resRefBounce = $this->ObjDatabase->readValues($sql);
		return $resRefBounce;
	}

	//FUNCTION TO LIST ALL TRAFFIC DETAILS	
	public function listAllTraffic($limitFrom = 0, $limitTo, $fromDate, $toDate = '', $countryQueryString = '', $cityQueryString = '', $platform = '')
	{
		if ($limitTo) {
			$paginationText = " SQL_CALC_FOUND_ROWS ";
		}		
		$sql	=	"	SELECT " . $paginationText . "
							(
								CASE								 
									WHEN 
										(visInfLog.httpReferer='' AND referrerType='') 
									THEN 
										'direct'
									WHEN 
										(visInfLog.httpReferer='direct' AND referrerType='') 
									THEN 
										'direct'
									WHEN 
										(visInfLog.httpReferer='direct' AND referrerType!='' AND referrerDetails='') 
									THEN 
										'direct'
									WHEN 
										(visInfLog.httpReferer='direct' AND referrerType!='' AND referrerDetails!='') 
									THEN 
										'direct'
									WHEN 
										(visInfLog.httpReferer='' AND referrerType!='' AND referrerDetails='') 
									THEN 
										'direct'
									WHEN 
										visInfLog.referrerType!='' AND referrerDetails!=''  
									THEN 
										referrerType
									WHEN 
										visInfLog.searchEngineName!='' AND searchKeyWord!='' 
									THEN  
										'search engine'	
									WHEN 
										(visInfLog.httpReferer!='direct' AND visInfLog.httpReferer!='' AND visInfLog.referrerType='') 
									THEN
									'unknown'		 								
								 END
							) AS refType,
							COUNT(visInfLog.visitorID) AS totalvisits,
							ROUND((SUM(pageCount)/COUNT(visitorID))) AS avgpagevisits,	
							SUM(doneSubscribe)AS totalsubscriptions,			
							SUM(doneSignUp) AS totalsignup,
							SUM(orderPlaced) AS totalorderplaced,
							SUM(orderAmount) AS totalrevenue,
							IF
								(
								SUM(TIMESTAMPDIFF(SECOND,entryTime,exitTime))> 	0,SEC_TO_TIME(sum(TIMESTAMPDIFF(SECOND,entryTime,exitTime))/count(visitorID))
					,'00:00:00') AS avgPageVisitDuration
						FROM 
							" . DB_PREFIX . "visitor_info_log  visInfLog
						WHERE 
								 visInfLog.pageCount>0
								 AND
									(visInfLog.userType='user' OR visInfLog.userType='guest')
								 AND
									referrerType!='Crawlers'
								";
		if ($fromDate && $toDate) {
			$sql .= "AND DATE(entryTime)>='" . $fromDate . "' ";
		} else {
			$sql .= "AND DATE(entryTime)='" . $fromDate . "' ";
		}
		if ($toDate) {
			$sql .= " AND DATE(entryTime)<='" . $toDate . "'";
		}
		if ($cityQueryString) {
			$sql .= " AND city IN('" . $cityQueryString . "')";
		}
		if ($countryQueryString) {
			$sql .= " AND country IN('" . $countryQueryString . "') ";
		}
		if (!$platform || $platform != 'All') {
			if ($platform == 'Web') {
				$sql .= " AND isMobileWeb='No'";
			} else if ($platform == 'Apps') {
				$sql .= " AND isMobileWeb='Yes'";
			}
		}
		$sql .= " GROUP BY refType";
		if ($limitTo) {
			$sql .= " LIMIT  " . $limitFrom . "," . $limitTo . " ";
		}
		$resAllTraffic = $this->ObjDatabase->readValues($sql);
		return $resAllTraffic;
	}
	//FUNCTION TO DISPLAY ALL REFERRALS
	public function listAllRefferals($limitFrom, $limitTo, $httpsURL, $httpURL, $fromDate, $toDate, $countryQueryString, $cityQueryString, $platform)
	{
		if ($limitTo) {
			$paginationText = " SQL_CALC_FOUND_ROWS ";
		}
		$sql	=	"	SELECT " . $paginationText . "
							(
								 CONCAT_WS('~*',referrerDetails,referrerWebSite)
							) AS reftype,
							COUNT(visInfLog.visitorID) AS totalvisits,
							ROUND(SUM(visInfLog.pageCount)/COUNT(visInfLog.visitorID)) AS avgpagevisits,
							IF
								(
									AVG(TIMESTAMPDIFF(SECOND,visInfLog.entryTime,visInfLog.exitTime))>0,SEC_TO_TIME(avg(TIMESTAMPDIFF(SECOND,visInfLog.entryTime,visInfLog.exitTime))),'00:00:00'
								) AS averagevisitduration,
							SUM(doneSignUp) AS totalregistration,
							SUM(doneSubscribe) AS totalsubscription,
							SUM(orderPlaced) AS totalorderplaced,
							SUM(orderAmount) AS totalrevenue			
						FROM 
							".DB_PREFIX."visitor_info_log visInfLog 
						WHERE 
							visInfLog.pageCount>0 
							AND 
								referrerType!='Crawlers'
							AND 
								(visInfLog.userType='user' OR visInfLog.userType='guest') 
							AND 
								referrerType='user'";
		if ($fromDate && $toDate) {
			$sql .= "AND DATE(entryTime)>='" . $fromDate . "' ";
		} else {
			$sql .= "AND DATE(entryTime)='" . $fromDate . "' ";
		}
		if ($toDate) {
			$sql .= " AND DATE(entryTime)<='" . $toDate . "'";
		}
		if ($cityQueryString) {
			$sql .= " AND city IN('" . $cityQueryString . "')";
		}
		if ($countryQueryString) {
			$sql .= " AND country IN('" . $countryQueryString . "') ";
		}
		if (!$platform || $platform != 'All') {
			if ($platform == 'Web') {
				$sql .= " AND isMobileWeb='No'";
			} else if ($platform == 'Apps') {
				$sql .= " AND isMobileWeb='Yes'";
			}
		}
		$sql .= " GROUP BY reftype";		
		if ($limitTo) {
			$sql .= " LIMIT  " . $limitFrom . "," . $limitTo . " ";
		}
		$resAllReferrels = $this->ObjDatabase->readValues($sql);
		return $resAllReferrels;
	}
	//FUNCTION TO FETCH ALL AFFILIATE REFERRALS
	public function listAllAffRefferals($limitFrom, $limitTo, $httpsURL, $httpURL, $fromDate, $toDate, $countryQueryString, $cityQueryString, $platform)
	{
		if ($limitTo) {
			$paginationText = " SQL_CALC_FOUND_ROWS ";
		}
		$sql	=	"	SELECT " . $paginationText . "
							(
								 CONCAT_WS('~*',referrerDetails,referrerWebSite)
							) AS reftype,
							COUNT(visInfLog.visitorID) AS totalvisits,
							ROUND(SUM(visInfLog.pageCount)/COUNT(visInfLog.visitorID)) AS avgpagevisits,
							IF
								(
									AVG(TIMESTAMPDIFF(SECOND,visInfLog.entryTime,visInfLog.exitTime))>0,SEC_TO_TIME(avg(TIMESTAMPDIFF(SECOND,visInfLog.entryTime,visInfLog.exitTime))),'00:00:00'
								) AS averagevisitduration,
							SUM(doneSignUp) AS totalregistration,
							SUM(doneSubscribe) AS totalsubscription,
							SUM(orderPlaced) AS totalorderplaced,
							SUM(orderAmount) AS totalrevenue			
						FROM 
							".DB_PREFIX."visitor_info_log visInfLog
						WHERE 
							visInfLog.pageCount>0 
							AND 
								referrerType!='Crawlers'
							AND 
								(visInfLog.userType='user' OR visInfLog.userType='guest') 
							AND 
								referrerType='affiliate' 
							AND 
								referrerDetails!=''
									";
		if ($fromDate && $toDate) {
			$sql .= "AND DATE(entryTime)>='" . $fromDate . "' ";
		} else {
			$sql .= "AND DATE(entryTime)='" . $fromDate . "' ";
		}
		if ($toDate) {
			$sql .= " AND DATE(entryTime)<='" . $toDate . "'";
		}
		if ($cityQueryString) {
			$sql .= " AND city IN('" . $cityQueryString . "')";
		}
		if ($countryQueryString) {
			$sql .= " AND country IN('" . $countryQueryString . "') ";
		}
		if (!$platform || $platform != 'All') {
			if ($platform == 'Web') {
				$sql .= " AND isMobileWeb='No'";
			} else if ($platform == 'Apps') {
				$sql .= " AND isMobileWeb='Yes'";
			}
		}
		$sql .= " GROUP BY reftype";
		if ($limitTo) {
			$sql .= " LIMIT  " . $limitFrom . "," . $limitTo . " ";
		}
		$resAllReferrels = $this->ObjDatabase->readValues($sql);
		return $resAllReferrels;
	}

	//FUNCTION TO LIST ALL SEARCH ENGINES
	public function listAllSearchEngine($limitFrom, $limitTo, $fromDate, $toDate, $countryQueryString, $cityQueryString, $platform)
	{
		if ($limitTo) {
			$paginationText = " SQL_CALC_FOUND_ROWS ";
		}
		$sql	=	"	SELECT " . $paginationText . "
							searchEngineName AS searchEngineName,								
							COUNT(visInfLog.visitorID) AS totalvisits,
							ROUND(SUM(visInfLog.pageCount)/COUNT(visInfLog.visitorID)) AS avgpagevisits,
							IF
								(
									AVG(TIMESTAMPDIFF(SECOND,visInfLog.entryTime,visInfLog.exitTime))>0,SEC_TO_TIME(avg(TIMESTAMPDIFF(SECOND,visInfLog.entryTime,visInfLog.exitTime))),'00:00:00'
								) AS averagevisitduration,
							SUM(doneSignUp) AS totalregistration,
							SUM(doneSubscribe) AS totalsubscription,
							SUM(orderPlaced) AS totalorderplaced,
							SUM(orderAmount) AS totalrevenue
						FROM 
							".DB_PREFIX."visitor_info_log visInfLog 
						WHERE 
							visInfLog.pageCount>0 
							AND 
								(visInfLog.userType='user' OR visInfLog.userType='guest') 
							AND 
								searchEngineName!='' 
							AND 
								`pageCount`>0 
							AND	
								referrerType!='Crawlers' 
							AND 
								searchKeyWord!=''";
		if ($fromDate && $toDate) {
			$sql .= "AND DATE(entryTime)>='" . $fromDate . "' ";
		} else {
			$sql .= "AND DATE(entryTime)='" . $fromDate . "' ";
		}
		if ($toDate) {
			$sql .= " AND DATE(entryTime)<='" . $toDate . "'";
		}
		if ($cityQueryString) {
			$sql .= " AND city IN('" . $countryQueryString . "')";
		}
		if ($countryQueryString) {
			$sql .= " AND country IN('" . $countryQueryString . "') ";
		}
		if (!$platform || $platform != 'All') {
			if ($platform == 'Web') {
				$sql .= " AND isMobileWeb='No'";
			} else if ($platform == 'Apps') {
				$sql .= " AND isMobileWeb='Yes'";
			}
		}
		$sql .= " GROUP BY searchEngineName";
		if ($limitTo) {
			$sql .= " LIMIT  " . $limitFrom . "," . $limitTo . " ";
		}
		//echo $searchEngineName;
		$resAllSearchEngines = $this->ObjDatabase->readValues($sql);
		return $resAllSearchEngines;
	}
	public function listAllKeywords($limitFrom, $limitTo, $fromDate, $toDate, $countryQueryString, $cityQueryString, $platform)
	{
		if ($limitTo) {
			$paginationText = " SQL_CALC_FOUND_ROWS ";
		}
		$sql	=	"	SELECT " . $paginationText."	
							searchKeyWord AS searchKeyWord,								
							COUNT(visInfLog.visitorID) AS totalvisits,
							ROUND(SUM(visInfLog.pageCount)/COUNT(visInfLog.visitorID)) AS avgpagevisits,
							IF
								(
									AVG(TIMESTAMPDIFF(SECOND,visInfLog.entryTime,visInfLog.exitTime))>0,SEC_TO_TIME(avg(TIMESTAMPDIFF(SECOND,visInfLog.entryTime,visInfLog.exitTime))),'00:00:00'
								)AS averagevisitduration,
							SUM(doneSignUp) AS totalregistration,
							SUM(doneSubscribe) AS totalsubscription,
							SUM(orderPlaced) AS totalorderplaced,
							SUM(orderAmount) AS totalrevenue
						FROM 
							".DB_PREFIX."visitor_info_log visInfLog
						WHERE 
							visInfLog.pageCount>0 
						AND 
							(visInfLog.userType='user' OR visInfLog.userType='guest') 
						AND 
							searchKeyWord!='' 
						AND 
							`pageCount`>0 
						AND 
							referrerType!='Crawlers'";
		if ($fromDate && $toDate) {
			$sql .= "AND DATE(entryTime)>='" . $fromDate . "' ";
		} else {
			$sql .= "AND DATE(entryTime)='" . $fromDate . "' ";
		}
		if ($toDate) {
			$sql .= " AND DATE(entryTime)<='" . $toDate . "'";
		}
		if ($cityQueryString) {
			$sql .= " AND city IN('" . $countryQueryString . "')";
		}
		if ($countryQueryString) {
			$sql .= " AND country IN('" . $countryQueryString . "') ";
		}
		if (!$platform || $platform != 'All') {
			if ($platform == 'Web') {
				$sql .= " AND isMobileWeb='No'";
			} else if ($platform == 'Apps') {
				$sql .= " AND isMobileWeb='Yes'";
			}
		}
		$sql .= " GROUP BY searchKeyWord";
		if ($limitTo) {
			$sql .= " LIMIT  " . $limitFrom . "," . $limitTo . " ";
		}
		$resAllSearchEngines = $this->ObjDatabase->readValues($sql);
		return $resAllSearchEngines;
	}
	//FUNCTION TO FETCH VISIT ATTRIBUTES OF ALL TRAFFIC PAGE
	public function getAllTrafficVisitAttributes($dateRange, $finalString, $countryQueryString = '', $cityString = '', $platform = '')
	{
		$allTrafficArray = explode(",", $finalString);
		//DATE FIELD MANIPULATION		
		if (strpos($dateRange, 'to') > 0) {
			$dateArray	   = explode("to", $dateRange);
			$fromDate		= $dateArray[0];
			$toDate		  = $dateArray[1];
			$appendDateQuery = " AND DATE(entryTime)>='" . $fromDate . "' AND DATE(entryTime)<='" . $toDate . "'";
		} else {
			$fromDate		= $dateRange;
			$appendDateQuery = " AND DATE(entryTime)='" . $fromDate . "'";
		}
		$nestedAppendDateQuery = " AND DATE(entryTime)<'" . $fromDate . "'";
		if ($countryQueryString) {
			$appendDateQuery .= " AND country IN('" . $countryQueryString . "')";
			$nestedAppendDateQuery .= " AND country IN('" . $countryQueryString . "')";
		}
		if ($cityString) {
			$appendDateQuery .= " AND city IN('" . $cityString . "')";
			$nestedAppendDateQuery .= " AND city IN('" . $cityString . "')";
			//echo $nestedAppendDateQuery;
		}
		if (!$platform || $platform != 'All') {
			if ($platform == 'Web') {
				$appendDateQuery .= " AND isMobileWeb='No'";
				$nestedAppendDateQuery .= " AND isMobileWeb='No'";
			} else if ($platform == 'Apps') {
				$appendDateQuery .= " AND isMobileWeb='Yes'";
				$nestedAppendDateQuery .= " AND isMobileWeb='Yes'";
			}
		}
		//DATE FIELD MANIPULATION ENDS HERE	
		$count = 0;
		foreach ($allTrafficArray as $allTraffic) {
			if ($allTraffic == 'direct') {
				//FETCHING OF NOT IN/IN STRING 
				//DISTINCT USER ID
				$sql	=	"	SELECT 
									DISTINCT(userID) AS disuser 
								FROM 
									".DB_PREFIX."visitor_info_log 
								WHERE 
									`userType`='user' 
									AND 
										`pageCount`>0 
									AND 
										referrerType!='Crawlers' 
									AND
									(
										(httpReferer='') OR (httpReferer='direct')
									)
									AND 
										referrerType='' 
									AND 
										referrerWebSite='' 
									AND 
										userID>0";
				$sql .= $nestedAppendDateQuery;
				//echo $sqlselectNotInQuery;
				$resNotInString = $this->ObjDatabase->readValuesObject($sql);
				$rowCount	   = $resNotInString->num_rows;
				for ($i = 0; $i < $rowCount; $i++) {
					$resultSet	= $resNotInString->fetch_array(MYSQL_ASSOC);
					$singleUserID = $singleUserID . "'" . $resultSet['disuser'] . "',";
					unset($resultSet);
				}
				$resNotInString->free();
				if ($rowCount > 0) {
					$finalNotInString = substr($singleUserID, 0, -1);
				}
				//DISTINCT IP ADDRESS												
				$sql	=	"	SELECT 
									DISTINCT(visitorCookieID) AS disip 
								FROM 
									" . DB_PREFIX . "visitor_info_log
								WHERE 
									`userType`='guest' 
									AND 
										`pageCount`>0 
									AND 
										referrerType!='Crawlers' 
									AND
									(
										(httpReferer='') OR (httpReferer='direct')
									)
									AND 
										referrerType=''
									AND 
										referrerWebSite='' 
									AND 
										userID=''";
				$sql .= $nestedAppendDateQuery;
				$resNotInStringOfIp = $this->ObjDatabase->readValuesObject($sql);
				$rowCountIp		 = $resNotInStringOfIp->num_rows;
				for ($ip = 0; $ip < $rowCountIp; $ip++) {
					$resultSet	   = $resNotInStringOfIp->fetch_array(MYSQL_ASSOC);
					$singleIPAddress = $singleIPAddress . "'" . $resultSet['disip'] . "',";
					unset($resultSet);
				}
				if ($rowCountIp) {
					$finalNotInStringIP = substr($singleIPAddress, 0, -1);
				}
				//FETCHING OF NOT IN/IN STRING ENDS HERE
				//FETCHING OF NEW VISIORS 
				$sql	=	"	SELECT
									COUNT(DISTINCT(userID)) AS newuserIdCount
								FROM 
									" . DB_PREFIX . "visitor_info_log
								WHERE
									`userType`='user' 
									AND 
										`pageCount`>0 
									AND 
										referrerType!='Crawlers'
									AND
									(
										(httpReferer='') OR (httpReferer='direct')
									)
									AND 
										referrerType='' 
									AND 
										referrerWebSite='' 
									AND 
										userID>0";
				$sql .= $appendDateQuery;
				if ($rowCount > 0) {
					$sql .= " AND userID NOT IN(" . $finalNotInString . ")";
				}
				$newCountArr			 = $this->ObjDatabase->readValue($sql); //New Visitor Based On User ID
				$sql	=	"	SELECT 
									COUNT(DISTINCT(visitorCookieID)) AS newIpCount 
								FROM 
									" . DB_PREFIX . "visitor_info_log 
								WHERE 
									`userType`='guest' 
									AND 
										`pageCount`>0 
									AND 
										referrerType!='Crawlers'
									AND
										(
											(httpReferer='') OR (httpReferer='direct')
										)
									AND 
										referrerType='' 
									AND 
										referrerWebSite='' 
									AND 
										userID=''";
				$sql .= $appendDateQuery;
				if ($rowCountIp > 0) {
					$sql .= " AND visitorCookieID NOT IN(" . $finalNotInStringIP . ")";
				}
				$newCountIPArr							= $this->ObjDatabase->readValue($sql); //New Visitor Based On User ID
				$allTrafficdetailArr[$count]['newvisits'] = $newCountArr['newuserIdCount'] + $newCountIPArr['newIpCount'];
				//FETCHING OF DISTINCT VISITORS
				$sql	=	"	SELECT 
									COUNT(DISTINCT(userID)) AS uniqueuser 
								FROM 
									" . DB_PREFIX . "visitor_info_log 
								WHERE
									`userType`='user' 
									AND 
										`pageCount`>0 
									AND 
										referrerType!='Crawlers'
									AND
										(
											(httpReferer='') OR (httpReferer='direct')
										)
									AND 
										referrerType='' 
									AND 
										referrerWebSite='' 
									AND 
										userID>0 ";
				$sql .= $appendDateQuery;
				$retArrUser		= $this->ObjDatabase->readValue($sql);
				$sql	=	"	SELECT 
									COUNT(DISTINCT(visitorCookieID)) AS uniqueIP 
								FROM 
									" . DB_PREFIX . "visitor_info_log 
								WHERE 
									(`userType`='user' OR `userType`='guest') 
									AND 
										`pageCount`>0 
									AND 
										referrerType!='Crawlers'
									AND
										(
											(httpReferer='') OR (httpReferer='direct')
										)
									AND 
										referrerType='' 
									AND 
										referrerWebSite='' 
									AND userID=''";
				$sql .= $appendDateQuery;
				$retArrIP									= $this->ObjDatabase->readValue($sql);
				$allTrafficdetailArr[$count]['uniquevisits'] = $retArrUser['uniqueuser'] + $retArrIP['uniqueIP'];
				$allTrafficdetailArr[$count]['retvisits']	= $allTrafficdetailArr[$count]['uniquevisits'] - $allTrafficdetailArr[$count]['newvisits'];
				//FETCHING OF DISTINCT VISITORS ENDS HERE
			} else if ($allTraffic == 'user') {
				//FETCHING OF NOT IN/IN STRING 
				//DISTINCT USER ID
				$sql	=	"	SELECT 
									DISTINCT(userID) AS disuser 
								FROM 
									" . DB_PREFIX . "visitor_info_log 
								WHERE 
									`userType`='user' 
									AND 
										`pageCount`>0 
									AND 
										referrerType!='Crawlers'
									AND 
										referrerType='user' 
									AND 
										userID>0";
				$sql.=$nestedAppendDateQuery;
				$resNotInString = $this->ObjDatabase->readValuesObject($sql);
				$rowCount	   = $resNotInString->num_rows;
				for ($i = 0; $i < $rowCount; $i++) {
					$resultSet	= $resNotInString->fetch_array(MYSQL_ASSOC);
					$singleUserID = $singleUserID . "'" . $resultSet['disuser'] . "',";
					unset($resultSet);
				}
				$resNotInString->free();
				if ($rowCount > 0) {
					$finalNotInString = substr($singleUserID, 0, -1);
				}
				//DISTINCT IP ADDRESS												
				$sql	=	"	SELECT 
									DISTINCT(visitorCookieID) AS disip 
								FROM 
									" . DB_PREFIX . "visitor_info_log 
								WHERE 
									`userType`='guest' 
									AND 
										`pageCount`>0 
									AND 
										referrerType!='Crawlers'
									AND 
										referrerType='user' 
									AND 
										userID=''";
				$sql .= $nestedAppendDateQuery;
				$resNotInStringOfIp = $this->ObjDatabase->readValuesObject($sql);
				$rowCountIp		 = $resNotInStringOfIp->num_rows;
				for ($ip = 0; $ip < $rowCountIp; $ip++) {
					$resultSet	   = $resNotInStringOfIp->fetch_array(MYSQL_ASSOC);
					$singleIPAddress = $singleIPAddress . "'" . $resultSet['disip'] . "',";
					unset($resultSet);
				}
				$resNotInStringOfIp->free();
				if ($rowCountIp) {
					$finalNotInStringIP = substr($singleIPAddress, 0, -1);
				}
				//FETCHING OF NOT IN/IN STRING ENDS HERE
				//FETCHING OF NEW VISIORS 
				$sql	=	"	SELECT
									COUNT(DISTINCT(userID)) AS newuserIdCount
								FROM 
									" .DB_PREFIX ."visitor_info_log
								WHERE
									`userType`='user' 
									AND
										`pageCount`>0 
									AND 
										referrerType='user' 
									AND 
										userID>0";
				$sql .= $appendDateQuery;
				if ($rowCount > 0) {
					$sql .= " AND userID NOT IN(" . $finalNotInString . ")";
				}
				$newCountArr			 = $this->ObjDatabase->readValue($sql); //New Visitor Based On User ID
				$sql	=	"	SELECT 
									COUNT(DISTINCT(visitorCookieID)) AS newIpCount 
								FROM 
									" . DB_PREFIX . "visitor_info_log 
								WHERE 
									`userType`='guest' 
									AND 
										`pageCount`>0 			
									AND 
										referrerType='user' 
									AND 
										userID=''";
				$sql .= $appendDateQuery;
				if ($rowCountIp > 0) {
					$sql .= " AND visitorCookieID NOT IN(" . $finalNotInStringIP . ")";
				}
				$newCountIPArr							= $this->ObjDatabase->readValue($sql); //New Visitor Based On User ID
				$allTrafficdetailArr[$count]['newvisits'] = $newCountArr['newuserIdCount'] + $newCountIPArr['newIpCount'];
				//FETCHING OF DISTINCT VISITORS
				$sql	=	"	SELECT 
									COUNT(DISTINCT(userID)) AS uniqueuser 
								FROM 
									" . DB_PREFIX . "visitor_info_log 
								WHERE
									`userType`='user' 
									AND 
										`pageCount`>0 
									AND 
										referrerType!='Crawlers'				
									AND 
										referrerType='user' 
									AND 
										userID>0 ";
				$sql .= $appendDateQuery;
				$retArrUser		= $this->ObjDatabase->readValue($sql);
				$sql	=	"	SELECT 
									COUNT(DISTINCT(visitorCookieID)) AS uniqueIP 
								FROM 
									" . DB_PREFIX . "visitor_info_log 
								WHERE 
									(`userType`='user' OR `userType`='guest') 
									AND 
										`pageCount`>0 
									AND 
										referrerType!='Crawlers'	
									AND 
										referrerType='user' 
									AND 
										userID=''";
				$sql .= $appendDateQuery;
				$retArrIP									= $this->ObjDatabase->readValue($sql);
				$allTrafficdetailArr[$count]['uniquevisits'] = $retArrUser['uniqueuser'] + $retArrIP['uniqueIP'];
				$allTrafficdetailArr[$count]['retvisits']	= $allTrafficdetailArr[$count]['uniquevisits'] - $allTrafficdetailArr[$count]['newvisits'];
				$allTrafficdetailArr[$count]['uniquevisits'] = $retArrUser['uniqueuser'] + $retArrIP['uniqueIP'];			   
				//FETCHING OF DISTINCT VISITORS ENDS HERE
			} else if ($allTraffic == 'search engine') {
				//FETCHING OF NOT IN/IN STRING 
				//DISTINCT USER ID
				$sql	="	SELECT 
								DISTINCT(userID) AS disuser 
							FROM 
								" . DB_PREFIX . "visitor_info_log 
							WHERE 
								`userType`='user' 
								AND 
									`pageCount`>0 
								AND 
									referrerType!='Crawlers' 
								AND 
									userID>0 
								AND 
									searchEngineName!='' 
								AND 
									searchKeyWord!=''";
				$sql .= $nestedAppendDateQuery;
				$resNotInString = $this->ObjDatabase->readValuesObject($sql);
				$rowCount	   = $resNotInString->num_rows;
				for ($i = 0; $i < $rowCount; $i++) {
					$resultSet	= $resNotInString->fetch_array(MYSQL_ASSOC);
					$singleUserID = $singleUserID . "'" . $resultSet['disuser'] . "',";
					unset($resultSet);
				}
				$resNotInString->free();
				if ($rowCount > 0) {
					$finalNotInString = substr($singleUserID, 0, -1);
				}

				//DISTINCT IP ADDRESS												
				$sql	=	"	SELECT 
									DISTINCT(visitorCookieID) AS disip 
								FROM 
									" . DB_PREFIX . "visitor_info_log 
								WHERE 
									`userType`='guest' 
									AND 
										`pageCount`>0 
									AND 
										referrerType!='Crawlers' 
									AND 
										userID='' 
									AND 
										searchEngineName!='' 
									AND 
										searchKeyWord!=''";
				$sql .= $nestedAppendDateQuery;
				$resNotInStringOfIp = $this->ObjDatabase->readValuesObject($sql);
				$rowCountIp		 = $resNotInStringOfIp->num_rows;
				for ($ip = 0; $ip < $rowCountIp; $ip++) {
					$resultSet	   = $resNotInStringOfIp->fetch_array(MYSQL_ASSOC);
					$singleIPAddress = $singleIPAddress . "'" . $resultSet['disip'] . "',";
					unset($resultSet);
				}
				if ($rowCountIp) {
					$finalNotInStringIP = substr($singleIPAddress, 0, -1);
				}
				//FETCHING OF NOT IN/IN STRING ENDS HERE
				//FETCHING OF NEW VISIORS 
				$sql	=	"	SELECT
									COUNT(DISTINCT(userID)) AS newuserIdCount
									FROM 
										" . DB_PREFIX . "visitor_info_log
									WHERE
										`userType`='user' 
										AND 
											`pageCount`>0 
										AND 
											referrerType!='Crawlers'				
										AND 
											userID>0 
										AND 
											searchEngineName!='' 
										AND 
											searchKeyWord!='' ";
				$sql .= $appendDateQuery;
				if ($rowCount > 0) {
					$sql .= " AND userID NOT IN(" . $finalNotInString . ")";
				}
				$newCountArr			 = $this->ObjDatabase->readValue($sql); //New Visitor Based On User ID
				$sql	=	"	SELECT 
									COUNT(DISTINCT(visitorCookieID)) AS newIpCount 
								FROM 
									" . DB_PREFIX . "visitor_info_log 
								WHERE 
										`userType`='guest' 
										AND 
											`pageCount`>0 
										AND 
											referrerType!='Crawlers'				
										AND 
											userID='' 
										AND 
											searchEngineName!='' 
										AND 
											searchKeyWord!=''";
				$sql .= $appendDateQuery;
				if ($rowCountIp > 0) {
					$sql .= " AND visitorCookieID NOT IN(" . $finalNotInStringIP . ")";
				}
				$newCountIPArr							= $this->ObjDatabase->readValue($sql); //New Visitor Based On User ID
				
				$allTrafficdetailArr[$count]['newvisits'] = $newCountArr['newuserIdCount'] + $newCountIPArr['newIpCount'];
				//FETCHING OF DISTINCT VISITORS
				$sql	=	"	SELECT 
									COUNT(DISTINCT(userID)) AS uniqueuser 
								FROM 
									" . DB_PREFIX . "visitor_info_log 
								WHERE
									`userType`='user' 
									AND 
										`pageCount`>0 
									AND 
										referrerType!='Crawlers'				
									AND 
										userID>0 
									AND 
										searchEngineName!='' 
									AND 
										searchKeyWord!=''";
				$sql .= $appendDateQuery;
				$retArrUser		= $this->ObjDatabase->readValue($sql);
				$sql	=	"	SELECT 
									COUNT(DISTINCT(visitorCookieID)) AS uniqueIP 
								FROM 
									" . DB_PREFIX . "visitor_info_log 
								WHERE 
									(`userType`='user' OR `userType`='guest')
									AND 
										`pageCount`>0 
									AND 
										referrerType!='Crawlers'
									AND
										userID='' 
									AND 
										searchEngineName!='' 
									AND 
										searchKeyWord!='' ";
				$sql .= $appendDateQuery;
				$retArrIP									= $this->ObjDatabase->readValue($sql);
				$allTrafficdetailArr[$count]['uniquevisits'] = $retArrUser['uniqueuser'] + $retArrIP['uniqueIP'];
				$allTrafficdetailArr[$count]['retvisits']	= $allTrafficdetailArr[$count]['uniquevisits'] - $allTrafficdetailArr[$count]['newvisits'];
				//FETCHING OF DISTINCT VISITORS ENDS HERE
			} else if ($allTraffic == "unknown") {
				
				//FETCHING OF NOT IN/IN STRING 
				//DISTINCT USER ID
				$sql	=	"	SELECT 
									DISTINCT(userID) AS disuser 
								FROM 
									" . DB_PREFIX . "visitor_info_log 
								WHERE 
									`userType`='user' 
									AND 
										`pageCount`>0 
									AND 
										referrerType!='Crawlers' 
									AND 
										(httpReferer!='')
									AND 
										referrerType='' 
									AND 
										httpReferer!='direct' 
									AND 
										userID>0";
				$sql .= $nestedAppendDateQuery;
				$resNotInString = $this->ObjDatabase->readValuesObject($sql);
				$rowCount	   = $resNotInString->num_rows;
				for ($i = 0; $i < $rowCount; $i++) {
					$resultSet	= $resNotInString->fetch_array(MYSQL_ASSOC);
					$singleUserID = $singleUserID . "'" . $resultSet['disuser'] . "',";
					unset($resultSet);
				}
				$resNotInString->free();
				if ($rowCount > 0) {
					$finalNotInString = substr($singleUserID, 0, -1);
				}
				//DISTINCT IP ADDRESS												
				$sql	=	"	SELECT 
									DISTINCT(visitorCookieID) AS disip 
								FROM 
									" . DB_PREFIX . "visitor_info_log 
								WHERE 
									`userType`='guest' 
									AND 
										`pageCount`>0 
									AND 
										referrerType!='Crawlers' 
									AND				
										(httpReferer!='')	
									AND 
										httpReferer!='direct'			
									AND 
										referrerType='' 
									AND userID=''";
				$sql .= $nestedAppendDateQuery;
				$resNotInStringOfIp = $this->ObjDatabase->readValuesObject($sql);
				$rowCountIp		 = $resNotInStringOfIp->num_rows;
				for ($ip = 0; $ip < $rowCountIp; $ip++) {
					$resultSet	   = $resNotInStringOfIp->fetch_array(MYSQL_ASSOC);
					$singleIPAddress = $singleIPAddress . "'" . $resultSet['disip'] . "',";
					unset($resultSet);
				}
				if ($rowCountIp) {
					$finalNotInStringIP = substr($singleIPAddress, 0, -1);
				}
				//FETCHING OF NOT IN/IN STRING ENDS HERE
				//FETCHING OF NEW VISIORS 
				$sql	=	"	SELECT
									COUNT(DISTINCT(userID)) AS newuserIdCount
								FROM 
									" . DB_PREFIX . "visitor_info_log
								WHERE
									`userType`='user' 
									AND 
										`pageCount`>0 
										AND 
											referrerType!='Crawlers'
										AND				
											(httpReferer!='')				
										AND 
											referrerType='' 
										AND 
											httpReferer!='direct' 
										AND 
											userID>0";
				$sql .= $appendDateQuery;
				if ($rowCount > 0) {
					$sql .= " AND userID NOT IN(" . $finalNotInString . ")";
				}
				$newCountArr			 = $this->ObjDatabase->readValue($sql); //New Visitor Based On User ID
				$sql	=	"	SELECT 
									COUNT(DISTINCT(visitorCookieID)) AS newIpCount 
								FROM 
									" . DB_PREFIX . "visitor_info_log 
							WHERE 
								`userType`='guest' 
								AND 
									`pageCount`>0 
								AND 
									referrerType!='Crawlers'
								AND (httpReferer!='')				
								AND 
									referrerType='' 
								AND 
									httpReferer!='direct' 
								AND userID=''";
				$sql .= $appendDateQuery;
				if ($rowCountIp > 0) {
					$sql .= " AND visitorCookieID NOT IN(" . $finalNotInStringIP . ")";
				}
				$newCountIPArr							= $this->ObjDatabase->readValue($sql); //New Visitor Based On User ID
				$allTrafficdetailArr[$count]['newvisits'] = $newCountArr['newuserIdCount'] + $newCountIPArr['newIpCount'];
				//FETCHING OF DISTINCT VISITORS
				$sql	=	"	SELECT 
									COUNT(DISTINCT(userID)) AS uniqueuser 
								FROM 
									" . DB_PREFIX . "visitor_info_log 
								WHERE
									`userType`='user' 
									AND 
										`pageCount`>0 
									AND 
										referrerType!='Crawlers'
									AND 
										(httpReferer!='')				
									AND 
										referrerType='' 
									AND 
										httpReferer!='direct' 
									AND 
										userID>0 ";
				$sql .= $appendDateQuery;
				$retArrUser		= $this->ObjDatabase->readValue($sql);
				$sql	=	"	SELECT 
									COUNT(DISTINCT(visitorCookieID)) AS uniqueIP 
								FROM 
									" . DB_PREFIX . "visitor_info_log 
								WHERE 
									(`userType`='user' OR `userType`='guest') 
									AND 
										`pageCount`>0 
									AND 
										referrerType!='Crawlers'
									AND
										(httpReferer!='')				
									AND 
										referrerType='' 
									AND 
										httpReferer!='direct' 
									AND 
										userID=''";
				$sql	.= $appendDateQuery;
				$retArrIP									= $this->ObjDatabase->readValue($sql);
				$allTrafficdetailArr[$count]['uniquevisits'] = $retArrUser['uniqueuser'] + $retArrIP['uniqueIP'];
				$allTrafficdetailArr[$count]['retvisits']	= $allTrafficdetailArr[$count]['uniquevisits'] - $allTrafficdetailArr[$count]['newvisits'];
				//FETCHING OF DISTINCT VISITORS ENDS HERE
			
				
				} else if ($allTraffic == 'affiliate') {
				//FETCHING OF NOT IN/IN STRING 
				//DISTINCT USER ID
				$sql	=	"	SELECT 
									DISTINCT(userID) AS disuser 
								FROM 
									" . DB_PREFIX . "visitor_info_log 
								WHERE 
									`userType`='user' 
									AND 
										`pageCount`>0 
									AND 
										referrerType!='Crawlers'
									AND 
										referrerType='affiliate' 
									AND 
										referrerDetails!='' 
									AND 
										userID>0";
				$sql .= $nestedAppendDateQuery;
				$resNotInString = $this->ObjDatabase->readValuesObject($sql);
				$rowCount	   = $resNotInString->num_rows;
				for ($i = 0; $i < $rowCount; $i++) {
					$resultSet	= $resNotInString->fetch_array(MYSQL_ASSOC);
					$singleUserID = $singleUserID . "'" . $resultSet['disuser'] . "',";
					unset($resultSet);
				}
				$resNotInString->free();
				if ($rowCount > 0) {
					$finalNotInString = substr($singleUserID, 0, -1);
				}
				//DISTINCT IP ADDRESS												
				$sql	=	"	SELECT 
									DISTINCT(visitorCookieID) AS disip 
								FROM 
									" . DB_PREFIX . "visitor_info_log 
								WHERE 
									`userType`='guest' 
									AND 
										`pageCount`>0 
									AND 
										referrerType!='Crawlers'				
									AND 
										referrerType='affiliate' 
									AND 
										referrerDetails!='' 
									AND 
										userID=''";
				$sql .= $nestedAppendDateQuery;
				$resNotInStringOfIp = $this->ObjDatabase->readValuesObject($sql);
				$rowCountIp		 = $resNotInStringOfIp->num_rows;
				for ($ip = 0; $ip < $rowCountIp; $ip++) {
					$resultSet	   = $resNotInStringOfIp->fetch_array(MYSQL_ASSOC);
					$singleIPAddress = $singleIPAddress . "'" . $resultSet['disip'] . "',";
					unset($resultSet);
				}
				$resNotInStringOfIp->free();
				if ($rowCountIp) {
					$finalNotInStringIP = substr($singleIPAddress, 0, -1);
				}
				//FETCHING OF NOT IN/IN STRING ENDS HERE
				//FETCHING OF NEW VISIORS 
				$sql	=	"	SELECT
									COUNT(DISTINCT(userID)) AS newuserIdCount
								FROM 
									" . DB_PREFIX . "visitor_info_log
								WHERE
									`userType`='user' 
									AND 
										`pageCount`>0 			
									AND 
										referrerType='affiliate' 
									AND 
										referrerDetails!='' 
									AND 
									userID>0";
				$sql .= $appendDateQuery;
				if ($rowCount > 0) {
					$sql .= " AND userID NOT IN(" . $finalNotInString . ")";
				}
				$newCountArr			 = $this->ObjDatabase->readValue($sql); //New Visitor Based On User ID
				$sql	=	"	SELECT 
									COUNT(DISTINCT(visitorCookieID)) AS newIpCount 
								FROM 
									" . DB_PREFIX . "visitor_info_log 
								WHERE 
									`userType`='guest' 
									AND 
										`pageCount`>0 			
									AND 
										referrerType='affiliate' 
									AND 
										referrerDetails!='' 
									AND
										userID=''";
				$sql .= $appendDateQuery;
				if ($rowCountIp > 0) {
					$sql .= " AND visitorCookieID NOT IN(" . $finalNotInStringIP . ")";
				}
				$newCountIPArr							= $this->ObjDatabase->readValue($sql); //New Visitor Based On User ID
				$allTrafficdetailArr[$count]['newvisits'] = $newCountArr['newuserIdCount'] + $newCountIPArr['newIpCount'];
				//FETCHING OF DISTINCT VISITORS
				$sql	=	"	SELECT 
									COUNT(DISTINCT(userID)) AS uniqueuser 
								FROM 
									" . DB_PREFIX . "visitor_info_log 
								WHERE
									`userType`='user' 
									AND 
										`pageCount`>0 
									AND 
										referrerType!='Crawlers'				
									AND 
										referrerType='affiliate' 
									AND 
										referrerDetails!='' 
									AND 
										userID>0 ";
				$sql .= $appendDateQuery;
				$retArrUser		= $this->ObjDatabase->readValue($sql);
				$sql	=	"	SELECT 
									COUNT(DISTINCT(visitorCookieID)) AS uniqueIP 
								FROM 
									" . DB_PREFIX . "visitor_info_log 
								WHERE 
									(`userType`='user' OR `userType`='guest') 
									AND 
										`pageCount`>0 
									AND 
										referrerType!='Crawlers'				
									AND 
										referrerType='affiliate' 
									AND 
										referrerDetails!='' 
									AND 
										userID=''";
				$sql .= $appendDateQuery;
				$retArrIP									= $this->ObjDatabase->readValue($sql);
				$allTrafficdetailArr[$count]['uniquevisits'] = $retArrUser['uniqueuser'] + $retArrIP['uniqueIP'];
				$allTrafficdetailArr[$count]['retvisits']	= $allTrafficdetailArr[$count]['uniquevisits'] - $allTrafficdetailArr[$count]['newvisits'];
				$allTrafficdetailArr[$count]['uniquevisits'] = $retArrUser['uniqueuser'] + $retArrIP['uniqueIP'];
				//FETCHING OF DISTINCT VISITORS ENDS HERE
			}
			$count++;
		}
		return $allTrafficdetailArr;
	}
	//FUNCTION TO FETCH VISIT ATTRIBUTES OF REFERRALS
	public function getReferralVisitAttributes($dateRange, $finalString, $countryString, $cityString, $platform)
	{
		$stringArr = explode(",", $finalString);
		if (strpos($dateRange, 'to') > 0) {
			$dateArray	   = explode("to", $dateRange);
			$fromDate		= $dateArray[0];
			$toDate		  = $dateArray[1];
			$appendDateQuery = " AND DATE(entryTime)>='" . $fromDate . "' AND DATE(entryTime)<='" . $toDate . "'";
		} else {
			$fromDate		= $dateRange;
			$appendDateQuery = " AND DATE(entryTime)='" . $fromDate . "'";
		}
		$nestedAppendDateQuery = " AND DATE(entryTime)<'" . $fromDate . "'";
		if ($countryString) {
			$appendDateQuery .= " AND country IN('" . $countryString . "')";
			$nestedAppendDateQuery .= " AND country IN('" . $countryString . "')";
		}
		if ($cityString) {
			$appendDateQuery .= " AND city IN('" . $cityString . "')";
			$nestedAppendDateQuery .= " AND city IN('" . $cityString . "')";
		}
		if (!$platform || $platform != 'All') {
			if ($platform == 'Web') {
				$appendDateQuery .= " AND isMobileWeb='No'";
				$nestedAppendDateQuery .= " AND isMobileWeb='No'";
			} else if ($platform == 'Apps') {
				$appendDateQuery .= " AND isMobileWeb='Yes'";
				$nestedAppendDateQuery .= " AND isMobileWeb='Yes'";
			}
		}
		$domainArr = $stringArr;
		for ($ref = 0; $ref < count($domainArr); $ref++) {
			$extractDetails	  = explode("~*", $domainArr[$ref]);
			$refdetail		   = $extractDetails[0];
			$domainName		  = $extractDetails[1];
			$sql	=	"	SELECT 
								DISTINCT(userID) AS disuser 
							FROM 
								".DB_PREFIX."visitor_info_log 
							WHERE 
								`userType`='user' 
								AND 
									`pageCount`>0 
								AND 
									referrerType='user' 
								AND 
									userID>0";
			if ($refdetail != '') {
				$sql .= " AND referrerDetails='" . $refdetail . "'";
			}
			if ($domainName != '') {
				$sql .= " AND referrerWebSite='" . $domainName . "'";
			}
			$sql .= $nestedAppendDateQuery;
			$resNotInString = $this->ObjDatabase->readValuesObject($sql);
			$rowCount	   = $resNotInString->num_rows;
			for ($i = 0; $i < $rowCount; $i++) {
				$resultSet	= $resNotInString->fetch_array(MYSQL_ASSOC);
				$singleUserID = $singleUserID . "'" . $resultSet['disuser'] . "',";
				unset($resultSet);
			}
			$resNotInString->free();
			if ($rowCount > 0) {
				$finalNotInString = substr($singleUserID, 0, -1);
			}
			//DISTINCT IP ADDRESS
			$sql	=	"	SELECT 
								DISTINCT(visitorCookieID) AS disip 
							FROM 
								".DB_PREFIX."visitor_info_log 
							WHERE 
								`userType`='guest' 
								AND 
									`pageCount`>0 
								AND 
									referrerType='user' 
								AND userID=''";
			if ($refdetail != '') {
				$sql .= " AND referrerDetails='" . $refdetail . "'";
			}
			if ($domainName != '') {
				$sql .= " AND referrerWebSite='" . $domainName . "'";
			}
			$sql .= $nestedAppendDateQuery;
			$resNotInStringOfIp = $this->ObjDatabase->readValuesObject($sql);
			$rowCountIp		 = $resNotInStringOfIp->num_rows;
			for ($ip = 0; $ip < $rowCountIp; $ip++) {
				$resultSet	   = $resNotInStringOfIp->fetch_array(MYSQL_ASSOC);
				$singleIPAddress = $singleIPAddress . "'" . $resultSet['disip'] . "',";
				unset($resultSet);
			}
			if ($rowCountIp) {
				$finalNotInStringIP = substr($singleIPAddress, 0, -1);
			}
			//FETCHING OF NOT IN/IN STRING ENDS HERE				
			//FETCHING OF NEW VISIORS 
			$sql	=	"	SELECT
								COUNT(DISTINCT(userID)) AS newuserIdCount
							FROM 
								".DB_PREFIX."visitor_info_log
						WHERE
							`userType`='user' 
							AND 
								`pageCount`>0 
							AND 
								referrerType='user' 
							AND 
								userID>0 ";
			if ($refdetail != '') {
				$sql .= " AND referrerDetails='" . $refdetail . "'";
			}
			if ($domainName != '') {
				$sql .= " AND referrerWebSite='" . $domainName . "'";
			}
			$sql .= $appendDateQuery;
			if ($rowCount > 0) {
				$sql .= " AND userID NOT IN(" . $finalNotInString . ")";
			}
			$newCountArr			 = $this->ObjDatabase->readValue($sql); //New Visitor Based On User ID	
			$sql	=	"	SELECT 
								COUNT(DISTINCT(visitorCookieID)) AS newIpCount 
							FROM 
								".DB_PREFIX."visitor_info_log 
							WHERE 
								`userType`='guest' 
								AND 
									`pageCount`>0
								AND 
									referrerType='user' 
								AND 
									userID=''";
			if ($refdetail != '') {
				$sql .= " AND referrerDetails='" . $refdetail . "'";
			}
			if ($domainName != '') {
				$sql .= " AND referrerWebSite='" . $domainName . "'";
			}
			$sql .= $appendDateQuery;
			if ($rowCountIp > 0) {
				$sql .= " AND visitorCookieID NOT IN(" . $finalNotInStringIP . ")";
			}
			$newCountIPArr						  = $this->ObjDatabase->readValue($sql); //New Visitor Based On User ID
			$allTrafficdetailArr[$ref]['newvisits'] = $newCountArr['newuserIdCount'] + $newCountIPArr['newIpCount'];
			unset($newCountArr);
			unset($newCountIPArr);
			//FETCHING OF DISTINCT VISITORS
			$sql	=	"	SELECT 
								COUNT(DISTINCT(userID)) AS uniqueuser 
							FROM 
								".DB_PREFIX."visitor_info_log 
							WHERE
								`userType`='user' 
								AND 
									`pageCount`>0				
								AND 
									referrerType='user' 
								AND 
									userID>0 ";
			if ($refdetail != '') {
				$sql .= " AND referrerDetails='" . $refdetail . "'";
			}
			if ($domainName != '') {
				$sql .= " AND referrerWebSite='" . $domainName . "'";
			}
			$sql .= $appendDateQuery;
			$uniqArrUser	   = $this->ObjDatabase->readValue($sql);
			$sql	=	"	SELECT 
								COUNT(DISTINCT(visitorCookieID)) AS uniqueIP 
							FROM 
								" . DB_PREFIX . "visitor_info_log 
							WHERE 
								`userType`='guest' 
								AND 
									`pageCount`>0 
								AND 
									referrerType='user' 
								AND 
									userID=''";
			if ($refdetail != '') {
				$sql .= " AND referrerDetails='" . $refdetail . "'";
			}
			if ($domainName != '') {
				$sql .= " AND referrerWebSite='" . $domainName . "'";
			}
			$sql .= $appendDateQuery;
			$uniqueArrIP							   = $this->ObjDatabase->readValue($sql);
			$allTrafficdetailArr[$ref]['uniquevisits'] = $uniqArrUser['uniqueuser'] + $uniqueArrIP['uniqueIP'];
			unset($uniqArrUser);
			unset($uniqueArrIP);
			$allTrafficdetailArr[$ref]['retvisits'] = $allTrafficdetailArr[$ref]['uniquevisits'] - $allTrafficdetailArr[$ref]['newvisits'];
		}
		return $allTrafficdetailArr;
	}
	
	public function getAffReferralVisitAttributes($dateRange, $finalString, $countryString, $cityString, $platform)
	{
		$stringArr = explode(",", $finalString);
		if (strpos($dateRange, 'to') > 0) {
			$dateArray	   = explode("to", $dateRange);
			$fromDate		= $dateArray[0];
			$toDate		  = $dateArray[1];
			$appendDateQuery = " AND DATE(entryTime)>='" . $fromDate . "' AND DATE(entryTime)<='" . $toDate . "'";
		} else {
			$fromDate		= $dateRange;
			$appendDateQuery = " AND DATE(entryTime)='" . $fromDate . "'";
		}
		$nestedAppendDateQuery = " AND DATE(entryTime)<'" . $fromDate . "'";
		if ($countryString) {
			$appendDateQuery .= " AND country IN('" . $countryString . "')";
			$nestedAppendDateQuery .= " AND country IN('" . $countryString . "')";
		}
		if ($cityString) {
			$appendDateQuery .= " AND city IN('" . $cityString . "')";
			$nestedAppendDateQuery .= " AND city IN('" . $cityString . "')";
		}
		if (!$platform || $platform != 'All') {
			if ($platform == 'Web') {
				$appendDateQuery .= " AND isMobileWeb='No'";
				$nestedAppendDateQuery .= " AND isMobileWeb='No'";
			} else if ($platform == 'Apps') {
				$appendDateQuery .= " AND isMobileWeb='Yes'";
				$nestedAppendDateQuery .= " AND isMobileWeb='Yes'";
			}
		}
		$domainArr = $stringArr;
		for ($ref = 0; $ref < count($domainArr); $ref++) {
			$extractDetails	  = explode("~*", $domainArr[$ref]);
			$refdetail		   = $extractDetails[0];
			$domainName		  = $extractDetails[1];
			$sql	=	"	SELECT 
								DISTINCT(userID) AS disuser 
							FROM 
								" . DB_PREFIX . "visitor_info_log 
							WHERE 
								`userType`='user' 
								AND 
									`pageCount`>0 
								AND 
									referrerType='affiliate' 
								AND 
									userID>0";
			if ($refdetail != '') {
				$sql .= " AND referrerDetails='" . $refdetail . "'";
			}
			if ($domainName != '') {
				$sql .= " AND referrerWebSite='" . $domainName . "'";
			}
			$sql .= $nestedAppendDateQuery;
			$resNotInString = $this->ObjDatabase->readValuesObject($sql);
			$rowCount	   = $resNotInString->num_rows;
			for ($i = 0; $i < $rowCount; $i++) {
				$resultSet	= $resNotInString->fetch_array(MYSQL_ASSOC);
				$singleUserID = $singleUserID . "'" . $resultSet['disuser'] . "',";
				unset($resultSet);
			}
			$resNotInString->free();
			if ($rowCount > 0) {
				$finalNotInString = substr($singleUserID, 0, -1);
			}
			//DISTINCT IP ADDRESS												

			$sql	=	"	SELECT 
								DISTINCT(visitorCookieID) AS disip 
							FROM 
								" . DB_PREFIX . "visitor_info_log 
							WHERE 
								`userType`='guest' 
							AND 
								`pageCount`>0 				
							AND 
								referrerType='affiliate' 
							AND 
								userID=''";
			if ($refdetail != '') {
				$sql .= " AND referrerDetails='" . $refdetail . "'";
			}
			if ($domainName != '') {
				$sql .= " AND referrerWebSite='" . $domainName . "'";
			}
			$sql .= $nestedAppendDateQuery;
			$resNotInStringOfIp = $this->ObjDatabase->readValuesObject($sql);
			$rowCountIp		 = $resNotInStringOfIp->num_rows;
			for ($ip = 0; $ip < $rowCountIp; $ip++) {
				$resultSet	   = $resNotInStringOfIp->fetch_array(MYSQL_ASSOC);
				$singleIPAddress = $singleIPAddress . "'" . $resultSet['disip'] . "',";
				unset($resultSet);
			}
			if ($rowCountIp) {
				$finalNotInStringIP = substr($singleIPAddress, 0, -1);
			}
			//FETCHING OF NOT IN/IN STRING ENDS HERE				
			//FETCHING OF NEW VISIORS 
			$sql	=	"	SELECT
								COUNT(DISTINCT(userID)) AS newuserIdCount
							FROM 
								" . DB_PREFIX . "visitor_info_log
							WHERE
								`userType`='user' 
								AND 
									`pageCount`>0 				
								AND 
									referrerType='affiliate' 
								AND 
									userID>0 ";
			if ($refdetail != '') {
				$sql .= " AND referrerDetails='" . $refdetail . "'";
			}
			if ($domainName != '') {
				$sql .= " AND referrerWebSite='" . $domainName . "'";
			}
			$sql .= $appendDateQuery;
			if ($rowCount > 0) {
				$sql .= " AND userID NOT IN(" . $finalNotInString . ")";
			}
			$newCountArr			 = $this->ObjDatabase->readValue($sql); //New Visitor Based On User ID	
			$sql	=	"	SELECT 
								COUNT(DISTINCT(visitorCookieID)) AS newIpCount 
							FROM 
								" . DB_PREFIX . "visitor_info_log 
							WHERE 
								`userType`='guest' 
								AND 
									`pageCount`>0 				
								AND 
									referrerType='affiliate' 
								AND 
									userID=''";
			if ($refdetail != '') {
				$sql .= " AND referrerDetails='" . $refdetail . "'";
			}
			if ($domainName != '') {
				$sql .= " AND referrerWebSite='" . $domainName . "'";
			}
			$sql .= $appendDateQuery;
			if ($rowCountIp > 0) {
				$sql .= " AND visitorCookieID NOT IN(" . $finalNotInStringIP . ")";
			}
			$newCountIPArr						  = $this->ObjDatabase->readValue($sql); //New Visitor Based On User ID
			$allTrafficdetailArr[$ref]['newvisits'] = $newCountArr['newuserIdCount'] + $newCountIPArr['newIpCount'];
			unset($newCountArr);
			unset($newCountIPArr);
			//FETCHING OF DISTINCT VISITORS
			$sql	=	"	SELECT 
								COUNT(DISTINCT(userID)) AS uniqueuser 
							FROM 
								" . DB_PREFIX . "visitor_info_log 
							WHERE
								`userType`='user' 
								AND 
									`pageCount`>0				
								AND 
									referrerType='affiliate' 
								AND 
									userID>0 ";
			if ($refdetail != '') {
				$sql .= " AND referrerDetails='" . $refdetail . "'";
			}
			if ($domainName != '') {
				$sql .= " AND referrerWebSite='" . $domainName . "'";
			}
			$sql .= $appendDateQuery;
			$uniqArrUser	   = $this->ObjDatabase->readValue($sql);
			$sql	=	"	SELECT 
								COUNT(DISTINCT(visitorCookieID)) AS uniqueIP
							FROM 
								" . DB_PREFIX . "visitor_info_log 
							WHERE 
								`userType`='guest' 
								AND 
									`pageCount`>0 
								AND 
									referrerType='affiliate' 
								AND 
									userID=''";
			if ($refdetail != '') {
				$sql .= " AND referrerDetails='" . $refdetail . "'";
			}
			if ($domainName != '') {
				$sql .= " AND referrerWebSite='" . $domainName . "'";
			}
			$sql .= $appendDateQuery;
			$uniqueArrIP							   = $this->ObjDatabase->readValue($sql);
			$allTrafficdetailArr[$ref]['uniquevisits'] = $uniqArrUser['uniqueuser'] + $uniqueArrIP['uniqueIP'];
			unset($uniqArrUser);
			unset($uniqueArrIP);
			$allTrafficdetailArr[$ref]['retvisits'] = $allTrafficdetailArr[$ref]['uniquevisits'] - $allTrafficdetailArr[$ref]['newvisits'];
		}
		return $allTrafficdetailArr;
	}

	//Function to get age from date of birth 
	//@date format mysql date
	public function getAge($dateOfBirth)
	{
		list($y, $m, $d) = explode("-", $dateOfBirth);
		$age = date('Y') - $y;
		date('md') < $m . $d ? $age-- : null;
		return $age;
	}
	//Function to get the time diffrance in days hours mins secs
	//@$fromDate,$toDate mysql date format
	//@return array $data(days=> , hours=> , mins=> , secs=>)
	public function getTimeDiffrance($fromDate, $toDate, $timeDiff = '')
	{
		if ($timeDiff == '') {
			$time		  = strtotime($fromDate) - strtotime($toDate);
			$days		  = intval($time / 86400);
			$remain		= $time % 86400;
			$hours		 = intval($remain / 3600);
			$remain		= $remain % 3600;
			$mins		  = intval($remain / 60);
			$secs		  = $remain % 60;
			$data['days']  = $days;
			$data['hours'] = $hours;
			$data['mins']  = $mins;
			$data['secs']  = $secs;
		} else {
			$time		  = round($timeDiff);
			$days		  = intval($time / 86400);
			$remain		= $time % 86400;
			$hours		 = intval($remain / 3600);
			$remain		= $remain % 3600;
			$mins		  = intval($remain / 60);
			$secs		  = round($remain) % 60;
			$data['days']  = $days;
			$data['hours'] = $hours;
			$data['mins']  = $mins;
			$data['secs']  = $secs;
		}
		return $data;
	}


	//Function to list out the current year data for the Anlytics dash board
	public function listDashBordData($platform = 'All', $dateRange = '')
	{
		if($dateRange){
			if (strpos($dateRange, 'to') > 0) {
				$queryString = explode(' to ', $dateRange);
				$firstDate   = date("Y-m-d", strtotime($queryString[0] . ' 00:00:00'));
				$lastDay	 = date("Y-m-d", strtotime($queryString[1] . ' 00:00:00'));
			} else {
				$firstDate = date("Y-m-d", strtotime($dateRange . ' 00:00:00'));
			}
		} else {
			$fromDate  = date("Y") . "-01" . "-01";
			$firstDate = date("Y-m-d", strtotime("-90 days"));
			$lastDay   = date("Y-m-d");
		}
		if ($platform && $platform != 'All') {
			$mobileWeb = ($platform == 'Web') ? 'No' : 'Yes';
		}
		$sql	=	"	SELECT 
							visitorID,
							referrerType,
							referrerWebSite,
							searchEngineName,
							isMobileWeb,
							widgetID,
							pageCount,
							orderPlaced,
							doneSubscribe,
							doneSignUp,
							city,
							browserName,
							userSex,
							userAge,
							YEAR(entryTime) AS year,
							MONTH(entryTime) AS month,
							HOUR(entryTime) AS hour,
							DATE(entryTime) AS date,
							referrerDetails,
							searchKeyWord 
						FROM 
							".DB_PREFIX."visitor_info_log 
						WHERE 
							(`userType`='user' OR `userType`='guest') 
							AND 
								`pageCount`>0 
							AND 
								referrerType!='Crawlers'";
		if ($firstDate && !$lastDay) {
			$sql .= " AND DATE(entryTime)='" . $firstDate . "'";
		} else {
			$sql .= " AND DATE(entryTime)>='" . $firstDate . "'";
		}
		if ($lastDay) {
			$sql .= " AND DATE(entryTime)<='" . $lastDay . "'";
		}
		if ($platform && $platform != 'All') {
			$sql .= " AND isMobileWeb='" . $mobileWeb . "'";
		}
		$resSelectLog = $this->ObjDatabase->readValuesObject($sql, MYSQL_ASSOC);
		return $resSelectLog;
	}
	//Function For list dash bord data with filtters
	
	public function listDashBordDataWithFilter($platform = 'All', $dateRange = '', $counter = 'Visit')
	{
		switch ($counter) {
			case 'Visit':
				break;
			case 'Bounce Rate':
				$filter = " and pageCount = 1";


				break;
			case 'Subscriptions':
				$filter = " and doneSubscribe = 1";
				break;
			case 'Registrations':
				$filter = " and doneSignUp = 1";
				break;
			case 'Orders':
				$filter = " and orderPlaced = 1";
				break;
			case 'Revenue':
				break;
		}
		if ($dateRange) {
			if (strpos($dateRange, 'to') > 0) {
				$queryString = explode(' to ', $dateRange);
				$firstDate   = date("Y-m-d", strtotime($queryString[0] . ' 00:00:00'));
				$lastDay	 = date("Y-m-d", strtotime($queryString[1] . ' 00:00:00'));
			} else {
				$firstDate = date("Y-m-d", strtotime($dateRange . ' 00:00:00'));
			}
		} else {
			$fromDate  = date("Y") . "-01" . "-01";
			$firstDate = date("Y-m-d", strtotime("-7 days"));
			$lastDay   = date("Y-m-d");
		}
		if ($platform && $platform != 'All') {
			$mobileWeb = ($platform == 'Web') ? 'No' : 'Yes';
		}
		$sqlSelectLog = "SELECT userSex,userAge FROM " . DB_PREFIX . "visitor_info_log where 
						(`userType`='user' OR `userType`='guest') AND `pageCount`>0 AND referrerType!='Crawlers'";
		if ($firstDate && !$lastDay) {
			$sqlSelectLog .= " AND DATE(entryTime)='" . $firstDate . "'";
		} else {
			$sqlSelectLog .= " AND DATE(entryTime)>='" . $firstDate . "'";
		}
		if ($lastDay) {
			$sqlSelectLog .= " AND DATE(entryTime)<='" . $lastDay . "'";
		}
		if ($platform && $platform != 'All') {
			$sqlSelectLog .= " AND isMobileWeb='" . $mobileWeb . "'";
		}
		$sqlSelectLog .= $filter;
		$resSelectLog = $this->ObjDatabase->readValuesObject($sqlSelectLog, MYSQL_ASSOC);
		return $resSelectLog;
	}
	//List new and returing visitors for dash bord over view
	
	public function listNewAndReturingVisitors($platform = 'Web', $dateRange = '')
	{
		if (strpos($dateRange, 'to') > 0) {
			$queryString = explode(' to ', $dateRange);
			$firstDate   = date("Y-m-d", strtotime($queryString[0] . ' 00:00:00'));
			$lastDay	 = date("Y-m-d", strtotime($queryString[1] . ' 00:00:00'));
		} else if (!$dateRange) {
			$firstDate = date("Y-m-d", strtotime("-7 days"));
			$lastDay   = date("Y-m-d");
		} else {
			$firstDate = date("Y-m-d", strtotime($dateRange . ' 00:00:00'));
		}
		if ($platform && $platform != 'All') {
			$mobileWeb = ($platform == 'Web') ? 'No' : 'Yes';
		}
		$sql	=	"	SELECT 
							newVisitorCount,
							returningVisitorCount,
							date 
						FROM 
							".DB_PREFIX."visitor_count_info 
						WHERE ";
		if ($firstDate && !$lastDay) {
			$sql .= " DATE(date)='" . $firstDate . "'";
		} else {
			$sql .= " DATE(date)>='" . $firstDate . "'";
		}
		if ($lastDay) {
			$sql .= " AND DATE(date)<='" . $lastDay . "'";
		}
		$resSelectLog = $this->ObjDatabase->readValuesObject($sql, MYSQL_ASSOC);
		return $resSelectLog;
	}
	//Function to list all details based on hour
	
	public function listHourlyVisitors()
	{
		$sqlSelectLog = "SELECT hour(entryTime) as hour , count(pageCount) as count FROM " . DB_PREFIX . "visitor_info_log vl 
		where YEAR(entryTime) = YEAR(NOW()) group by hour(entryTime)";
		$resSelectLog = $this->ObjDatabase->readValues($sqlSelectLog);
		return $resSelectLog;
	}
	//function for getting total sale , order count , reg. user count , subscription count for the dash board over view
	public function getOverViewDetails()
	{
		$sql	=	"	SELECT 
							userID,
							userType,
							remoteAddress,
							visitorCookieID,
							pageCount,
							orderPlaced,
							doneSubscribe,
							doneSignUp,
							exitTime,
							entryTime,
							orderAmount 
						FROM 
							".DB_PREFIX."visitor_info_log 
						WHERE 
							(`userType`='user' OR `userType`='guest') 
							AND 
								`pageCount`>0 
							AND 
								referrerType!='Crawlers'";
		$resSelectLog = $this->ObjDatabase->readValuesObject($sql);
		return $resSelectLog;
	}
	//Function to list details based on city
	public function getDemographicDetails($limitFrom = 0, $limitTo, $searchCity = array(), $searchCountry = array(), $searchAgeArray = array(), $searchGenderArray = array(), $date = '', $platform = 'All', $sortByOption = 'cityName', $sortByOrder = 'asc')
	{
		$filterStatus = false;
		if (count($searchCity) > 0) {
			$searchCities = "" . implode("','", $searchCity) . "";
			$filter .= " AND city IN('" . $searchCities . "')";
			$filter1 .= " AND city IN('" . $searchCities . "')";
			$filterStatus  = true;
			$filterStatus1 = true;
		}
		if (count($searchCountry) > 0) {
			$searchCountries = "" . implode("','", $searchCountry) . "";
			$filter .= " AND country IN('" . $searchCountries . "')";
			$filterStatus = true;
			$filter1 .= " AND country IN('" . $searchCountries . "')";
			$filterStatus1 = true;
		}
		if (count($searchAgeArray) > 0) {
			$filter .= " AND ( ";
			$filter1 .= " AND ( ";
			if (in_array("below17", $searchAgeArray)) {
				$filterTmp .= " OR userAge BETWEEN 1 AND 17 ";
			}
			if (in_array("18-24", $searchAgeArray)) {
				$filterTmp .= " OR userAge BETWEEN 18 AND 24 ";
			}
			if (in_array("25-34", $searchAgeArray)) {
				$filterTmp .= " OR userAge BETWEEN 25 AND 34 ";
			}
			if (in_array("35-54", $searchAgeArray)) {
				$filterTmp .= " OR userAge BETWEEN 35 AND 54 ";
			}
			if (in_array("above55", $searchAgeArray)) {
				$filterTmp .= " OR userAge >=55 ";
			}
			if (in_array("notage", $searchAgeArray)) {
				$filterTmp .= " OR userAge ='' ";
			}
			$filter .= substr($filterTmp, 3) . " )";
			$filterStatus = true;
			$filter1 .= substr($filterTmp, 3) . " )";
			$filterStatus1 = true;
		}
		if (count($searchGenderArray) > 0) {
			$searchGender = "" . implode("','", $searchGenderArray) . "";
			$filter .= " AND userSex IN('" . $searchGender . "')";
			$filterStatus = true;
			$filter1 .= " AND userSex IN('" . $searchGender . "')";
			$filterStatus1 = true;
		}
		if ($date) {
			if (strpos($date, 'to') > 0) {
				$queryString = explode('to', $date);
				$fromDate	= $queryString[0] . ' 00:00:00';
				if ($queryString[1] == date("Y-m-d")) {
					$filter .= " AND entryTime BETWEEN '" . $fromDate . "' AND NOW()";
				} else {
					$toDate = $queryString[1] . ' 23:59:59';
					$filter .= " AND entryTime BETWEEN '" . $fromDate . "' AND '" . $toDate . "'";
				}
				$filterStatus = true;
			} else {
				$fromDate = $date;
				$filter .= " AND DATE(entryTime)='" . $date . "'";
				$filterStatus = true;
			}
		} else {
			$fromDate = date("Y") . "-01-" . "01";
		}
		$mobileWeb = ($platform == 'Web') ? 'No' : 'Yes';
		if ($platform != 'All') {
			$filter .= ($platform == 'Web') ? " AND isMobileWeb='No'" : " AND isMobileWeb='Yes'";
			$filterStatus = true;
			$filter1 .= ($platform == 'Web') ? " AND isMobileWeb='No'" : " AND isMobileWeb='Yes'";
			$filterStatus1 = true;
		}
		if ($limitTo) {
			$paginationText = " SQL_CALC_FOUND_ROWS ";
		}
		$sqlSelectLog = "	SELECT " . $paginationText . " 
								city AS cityName,
								entryTime,
								COUNT(visitorID) AS visit,
								ROUND
									(
										SUM(pageCount)/COUNT(visitorID)
									) AS avgPageVisit,
								IF
									(
										SUM(TIMESTAMPDIFF(SECOND,entryTime,exitTime))>0,SEC_TO_TIME(SUM(TIMESTAMPDIFF(SECOND,entryTime,exitTime))/count(visitorID)
									)
					,'00:00:00') AS avgPageVisitDuration,
								IF
									(
										SUM(TIMESTAMPDIFF(SECOND,entryTime,exitTime))>0,SUM(TIMESTAMPDIFF(SECOND,entryTime,exitTime))/count(visitorID)
									,0) AS avgPageVisitDurationInSec,
								SUM(orderAmount) AS revenue,
								SUM(doneSignUp) AS registration,
								SUM(doneSubscribe) AS subscription,
								SUM(orderPlaced) AS orderCount
							FROM 
								".DB_PREFIX."visitor_info_log 
							WHERE
								(`userType`='user' OR `userType`='guest') 
								AND 
									`pageCount`>0 
								AND 
									referrerType!='Crawlers'";
		if ($filterStatus == true)
			$sqlSelectLog .= " AND " . substr($filter, 4);
		if($sortByOption=='avgPageVisitDuration')
		{
			$sortByOption='avgPageVisitDurationInSec';
		}
		
		$sqlSelectLog .=	"GROUP BY
								`city` 
							HAVING 
								city!='' 
							ORDER BY 
								" . $sortByOption . " " . $sortByOrder;
		if ($limitTo) {
			$sqlSelectLog .= " LIMIT  " . $limitFrom . "," . $limitTo . " ";
		}
		$filterArray['filter']   = $filter;
		$filterArray['filter1']  = $filter1;
		$filterArray['fromDate'] = $fromDate;
		$resSelectLog			= $this->ObjDatabase->readValues($sqlSelectLog, MYSQL_ASSOC);
		return (array(
			$resSelectLog,
			$filterArray
		));
	}
	//Function to csv details based on city
	public function getDemographicDetailsForCsv($searchCity = array(), $searchCountry = array(), $searchAgeArray = array(), $searchGenderArray = array(), $date = '', $platform = 'All', $sortByOption = 'cityName', $sortByOrder = 'asc')
	{
		$filterStatus = false;
		if (count($searchCity) > 0) {
			$searchCities = "" . implode("','", $searchCity) . "";
			$filter .= " AND city IN('" . $searchCities . "')";
			$filter1 .= " AND city IN('" . $searchCities . "')";
			$filterStatus  = true;
			$filterStatus1 = true;
		}
		if (count($searchCountry) > 0) {
			$searchCountries = "" . implode("','", $searchCountry) . "";
			$filter .= " AND country IN('" . $searchCountries . "')";
			$filterStatus = true;
			$filter1 .= " AND country IN('" . $searchCountries . "')";
			$filterStatus1 = true;
		}
		if (count($searchAgeArray) > 0) {

			$filter .= " AND ( ";
			$filter1 .= " AND ( ";
			if (in_array("below17", $searchAgeArray)) {
				$filterTmp .= " OR userAge BETWEEN 1 AND 17 ";
			}
			if (in_array("18-24", $searchAgeArray)) {
				$filterTmp .= " OR userAge BETWEEN 18 AND 24 ";
			}
			if (in_array("25-34", $searchAgeArray)) {
				$filterTmp .= " OR userAge BETWEEN 25 AND 34 ";
			}
			if (in_array("35-54", $searchAgeArray)) {
				$filterTmp .= " OR userAge BETWEEN 35 AND 54 ";
			}
			if (in_array("above55", $searchAgeArray)) {
				$filterTmp .= " OR userAge >=55 ";
			}
			if (in_array("notage", $searchAgeArray)) {
				$filterTmp .= " OR userAge ='' ";
			}
			$filter .= substr($filterTmp, 3) . " )";
			$filterStatus = true;

			$filter1 .= substr($filterTmp, 3) . " )";
			$filterStatus1 = true;
		}
		if (count($searchGenderArray) > 0) {
			$searchGender = "" . implode("','", $searchGenderArray) . "";
			$filter .= " AND userSex IN('" . $searchGender . "')";
			$filterStatus = true;
			$filter1 .= " AND userSex IN('" . $searchGender . "')";
			$filterStatus1 = true;
		}
		if ($date) {
			if (strpos($date, 'to') > 0) {
				$queryString = explode('to', $date);
				$fromDate	= $queryString[0] . ' 00:00:00';
				if ($queryString[1] == date("Y-m-d")) {
					$filter .= " AND entryTime BETWEEN '" . $fromDate . "' AND NOW()";
				} else {
					$toDate = $queryString[1] . ' 23:59:59';
					$filter .= " AND entryTime BETWEEN '" . $fromDate . "' AND '" . $toDate . "'";
				}
				$filterStatus = true;
			} else {
				$fromDate = $date;
				$filter .= " AND DATE(entryTime)='" . $date . "'";
				$filterStatus = true;
			}
		} else {
			$fromDate = date("Y") . "-01-" . "01";
		}
		$mobileWeb = ($platform == 'Web') ? 'No' : 'Yes';
		if ($platform != 'All') {
			$filter .= ($platform == 'Web') ? " AND isMobileWeb='No'" : " AND isMobileWeb='Yes'";
			$filterStatus = true;
			$filter1 .= ($platform == 'Web') ? " AND isMobileWeb='No'" : " AND isMobileWeb='Yes'";
			$filterStatus1 = true;
		}
		$sql	=	"	SELECT 
							city AS cityName,
							COUNT(visitorID) AS visit,
							ROUND
								(
									SUM(pageCount)/COUNT(visitorID)
								) AS avgPageVisit,
							IF
								(
									SUM(TIMESTAMPDIFF(SECOND,entryTime,exitTime))> 	0,SEC_TO_TIME(sum(TIMESTAMPDIFF(SECOND,entryTime,exitTime))/COUNT(visitorID))
					,'00:00:00'
								) AS avgPageVisitDuration,
							IF
								(
									SUM(TIMESTAMPDIFF(SECOND,entryTime,exitTime))> 	0,sum(TIMESTAMPDIFF(SECOND,entryTime,exitTime))/COUNT(visitorID)
								,0) AS avgPageVisitDurationInSec,	
							SUM(doneSignUp) AS registration,
							SUM(doneSubscribe) AS subscription,
							SUM(orderPlaced) AS orderCount,
							SUM(orderAmount) AS revenue
						FROM 
							".DB_PREFIX."visitor_info_log 
						WHERE 
								( `userType`='user' OR `userType`='guest')
								AND 
									`pageCount`>0 
								AND
									referrerType!='Crawlers'";
		if ($filterStatus == true)
			$sql .= " AND " . substr($filter, 4);
		if($sortByOption=='avgPageVisitDuration')
		{
			$sortByOption='avgPageVisitDurationInSec';
		}	
		$sql.="			GROUP BY 
							`city` 
						HAVING 
							city!='' 
						ORDER BY ".$sortByOption." " . $sortByOrder;
		$resSelectLog = $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);
		return $resSelectLog;
	}
	//Function ti get all unique cities and countries for filter optiopns
	public function getdistinctCitiesAndCountries()
	{
		$sql	=	"	SELECT 
							DISTINCT 
								CASE 
									WHEN 
										city = 'zOthers' 
									THEN 
										'OTHERS' 
									ELSE 
										city
								END 
							AS city,
								CASE 
									WHEN 
										city = 'zOthers' 
									THEN 
										'OTHERS' 
									ELSE 
										city
								END 
							AS city 
						FROM 
							".DB_PREFIX."visitor_info_log 
						WHERE 
							city!='' 
							AND
								(`userType`='user' OR `userType`='guest') 
							AND 
								`pageCount`>0 
							AND 
								referrerType!='Crawlers' 
						ORDER BY 
							city ASC";
		$resSelectCity	= $this->ObjDatabase->readValues($sql);
		$sql	=	"	SELECT
							DISTINCT country,
								CASE 
									WHEN 
										country = 'zOthers' 
									THEN 
										'OTHERS' 
									ELSE 
										country
								END 
							AS country
						FROM 
							".DB_PREFIX."visitor_info_log 
						WHERE 
						country!='' 
						AND 
							(`userType`='user' OR `userType`='guest') 
							AND 
								`pageCount`>0 
							AND 
								referrerType!='Crawlers' 
						ORDER BY 
							country ASC";
		$resSelectCountry = $this->ObjDatabase->readValues($sql);
		return (array(
			$resSelectCity,
			$resSelectCountry
		));
	}
	//Function to get all unique Os and browsers for filter options

	public function getdistinctOsAndBrowsers()
	{
		$sql	="	SELECT 
						DISTINCT 
							CASE 
								WHEN 
									browserName='' 
								THEN 
									'Unknown' 
								ELSE 
									browserName
						  	END AS browserName,
							CASE 
								WHEN 
									browserName = '' 
								THEN 
									'Unknown' 
								ELSE 
									browserName
						  	END AS browserName 
					FROM ".DB_PREFIX."visitor_info_log 
					WHERE 
						referrerType!='Crawlers' 
					ORDER BY 
						browserName ASC";
		$resSelectBrowser = $this->ObjDatabase->readValues($sql);
		$sql	=	"	SELECT 
							DISTINCT operatingSystem,
							operatingSystem 
						FROM 
							".DB_PREFIX."visitor_info_log 
						WHERE 
							operatingSystem!='' 
							AND 
								referrerType!='Crawlers' 
						ORDER BY 
							operatingSystem ASC";
		$resSelectOs	  = $this->ObjDatabase->readValues($sql);
		return (array(
			$resSelectOs,
			$resSelectBrowser
		));
	}
	//function to get details based on age
	public function getAgeGenderDetails($limitFrom = 0, $limitTo, $searchCity = array(), $searchCountry = array(), $searchAgeArray = array(), $searchGenderArray = array(), $date = '', $platform = 'All', $counter = 'Visit')
	{
		$filterStatus = false;
		if (count($searchCity) > 0) {
			$searchCities = "" . implode("','", $searchCity) . "";
			$filter .= " AND city IN('" . $searchCities . "')";
			$filterStatus = true;
		}
		if (count($searchCountry) > 0) {
			$searchCountries = "" . implode("','", $searchCountry) . "";
			$filter .= " AND country IN('" . $searchCountries . "')";
			$filterStatus = true;
		}
		if (count($searchAgeArray) > 0) {
			$filter .= " AND ( ";
			if (in_array("below17", $searchAgeArray)) {
				$filterTmp .= " OR userAge BETWEEN 1 and 17 ";
			}
			if (in_array("18-24", $searchAgeArray)) {
				$filterTmp .= " OR userAge BETWEEN 18 and 24 ";
			}
			if (in_array("25-34", $searchAgeArray)) {
				$filterTmp .= " OR userAge BETWEEN 25 and 34 ";
			}
			if (in_array("35-54", $searchAgeArray)) {
				$filterTmp .= " OR userAge BETWEEN 35 and 54 ";
			}
			if (in_array("above55", $searchAgeArray)) {
				$filterTmp .= " OR userAge >=55 ";
			}
			if (in_array("notage", $searchAgeArray)) {
				$filterTmp .= " OR userAge ='' ";
			}
			$filter .= substr($filterTmp, 3) . " )";
			$filterStatus = true;
		}
		if (count($searchGenderArray) > 0) {
			$searchGender = "" . implode("','", $searchGenderArray) . "";
			$filter .= " AND userSex IN('" . $searchGender . "')";
			$filterStatus = true;
		}
		if (strpos($date, 'to') > 0) {
			$queryString = explode('to', $date);
			$fromDate	= $queryString[0] . ' 00:00:00';
			if ($queryString[1] == date("Y-m-d")) {
				$filter .= " AND entryTime BETWEEN '" . $fromDate . "' AND NOW()";
			} else {
				$toDate = $queryString[1] . ' 23:59:59';
				$filter .= " AND entryTime BETWEEN '" . $fromDate . "' AND '" . $toDate . "'";
			}
			$filterStatus = true;
		} else {
			$filter .= " AND DATE(entryTime)='" . $date . "'";
			$filterStatus = true;
		}
		$mobileWeb = ($platform == 'Web') ? 'No' : 'Yes';
		if ($platform != 'All') {
			$filter .= ($platform == 'Web') ? " AND isMobileWeb='No'" : " AND isMobileWeb='Yes'";
			$filterStatus = true;
		}
		switch ($counter) {
			case 'Visit':
				break;
			case 'Bounce Rate':
				$filter .= " AND pageCount = 1";
				break;
			case 'Subscriptions':
				$filter .= " AND doneSubscribe = 1";
				break;
			case 'Registrations':
				$filter .= " AND doneSignUp = 1";
				break;
			case 'Orders':
				$filter .= " AND orderPlaced = 1";
				break;
		}
		$sql	=	"	SELECT 
							userSex,
							userAge,
							entryTime,
							DAYOFWEEK(entryTime) AS weekday 
						FROM 
							".DB_PREFIX."visitor_info_log  
						WHERE 
							( `userType`='user' OR `userType`='guest') 
						AND 
							`pageCount`>0 
						AND 
							referrerType!='Crawlers' 
						AND " . substr($filter, 4);
		$resSelectAgeGender = $this->ObjDatabase->readValuesObject($sql, MYSQL_ASSOC);
		return $resSelectAgeGender;
	}
	//Function to list all details based on hour
	public function getHourlyDetails($searchCity = array(), $searchCountry = array(), $searchAgeArray = array(), $searchGenderArray = array(), $date = '', $platform = 'All', $counter = 'Visit')
	{
		$filterStatus = false;
		if (count($searchCity) > 0) {
			$searchCities = "" . implode("','", $searchCity) . "";
			$filter .= " AND city IN('" . $searchCities . "')";
			$filterStatus = true;
		}
		if (count($searchCountry) > 0) {
			$searchCountries = "" . implode("','", $searchCountry) . "";
			$filter .= " AND country IN('" . $searchCountries . "')";
			$filterStatus = true;
		}
		if (count($searchAgeArray) > 0) {
			$filter .= " AND ( ";
			if (in_array("below17", $searchAgeArray)) {
				$filterTmp .= " OR userAge BETWEEN 1 AND 17 ";
			}
			if (in_array("18-24", $searchAgeArray)) {
				$filterTmp .= " OR userAge BETWEEN 18 AND 24 ";
			}
			if (in_array("25-34", $searchAgeArray)) {
				$filterTmp .= " OR userAge BETWEEN 25 AND 34 ";
			}
			if (in_array("35-54", $searchAgeArray)) {
				$filterTmp .= " OR userAge BETWEEN 35 AND 54 ";
			}
			if (in_array("above55", $searchAgeArray)) {
				$filterTmp .= " OR userAge >=55 ";
			}
			if (in_array("notage", $searchAgeArray)) {
				$filterTmp .= " OR userAge ='' ";
			}
			$filter .= substr($filterTmp, 3) . " )";
			$filterStatus = true;
		}
		if (count($searchGenderArray) > 0) {
			$searchGender = "" . implode("','", $searchGenderArray) . "";
			$filter .= " AND userSex IN('" . $searchGender . "')";
			$filterStatus = true;
		}
		if (strpos($date, 'to') > 0) {
			$queryString = explode('to', $date);
			$fromDate	= $queryString[0] . ' 00:00:00';
			if ($queryString[1] == date("Y-m-d")) {
				$filter .= " AND entryTime BETWEEN '" . $fromDate . "' and NOW()";
			} else {
				$toDate = $queryString[1] . ' 23:59:59';
				$filter .= " AND entryTime BETWEEN '" . $fromDate . "' AND '" . $toDate . "'";
			}
			$filterStatus = true;
		} 
		else {
			$filter .= " AND DATE(entryTime)='" . $date . "'";
			$filterStatus = true;
		}
		$mobileWeb = ($platform == 'Web') ? 'No' : 'Yes';
		if ($platform != 'All') {
			$filter .= ($platform == 'Web') ? " AND isMobileWeb='No'" : " AND isMobileWeb='Yes'";
			$filterStatus = true;
		}
		switch ($counter) {
			case 'Visit':
				break;
			case 'Bounce Rate':
				$filter .= " AND pageCount = 1";
				break;
			case 'Subscriptions':
				$filter .= " AND doneSubscribe = 1";
				break;
			case 'Registrations':
				$filter .= " AND doneSignUp = 1";
				break;
			case 'Orders':
				$filter .= " AND orderPlaced = 1";
				break;
		}
		$sql	=	"	SELECT 
							HOUR(entryTime) AS hour,
							visitorID AS visit,
							doneSignUp AS registration,
							doneSubscribe AS subscription,
							orderPlaced AS orderCount,
							orderAmount AS orderAmount,
							DAYOFWEEK(entryTime) AS weekday 
						FROM 
							".DB_PREFIX."visitor_info_log 
						";
		if ($filterStatus == true)
			$sql .= "	WHERE " . substr($filter, 4);
		$sql.=		" 
							AND
								( `userType`='user' OR `userType`='guest') 
							AND 
								`pageCount`>0 
							AND 
								referrerType!='Crawlers'";
		$resSelectLogTotal = $this->ObjDatabase->readValuesObject($sql, MYSQL_ASSOC);
		return $resSelectLogTotal;
	}
	//Function to list all details based on browser
	public function getBrowserDetails($searchCity = array(), $searchCountry = array(), $searchAgeArray = array(), $searchGenderArray = array(), $date = '', $platform = 'All', $searchOs = array(), $searchBrowser = array(), $sortByOption = 'browserName', $sortByOrder = 'asc')
	{	 
		$filterStatus = false;
		if (count($searchCity) > 0) {
			$searchCities = "" . implode("','", $searchCity) . "";
			$filter .= " AND city IN('" . $searchCities . "')";
			$filter1 .= " AND city IN('" . $searchCities . "')";
			$filterStatus  = true;
			$filterStatus1 = true;
		}
		if (count($searchCountry) > 0) {
			$searchCountries = "" . implode("','", $searchCountry) . "";
			$filter .= " AND country IN('" . $searchCountries . "')";
			$filter1 .= " AND country IN('" . $searchCountries . "')";
			$filterStatus  = true;
			$filterStatus1 = true;
		}
		if (count($searchAgeArray) > 0) {			
			$filter .= " AND ( ";
			$filter1.=" AND ( ";
			if (in_array("below17", $searchAgeArray)) {
				$filterTmp .= " OR userAge BETWEEN 1 AND 17 ";
			}
			if (in_array("18-24", $searchAgeArray)) {
				$filterTmp .= " OR userAge BETWEEN 18 AND 24 ";
			}
			if (in_array("25-34", $searchAgeArray)) {
				$filterTmp .= " OR userAge BETWEEN 25 AND 34 ";
			}
			if (in_array("35-54", $searchAgeArray)) {
				$filterTmp .= " OR userAge BETWEEN 35 AND 54 ";
			}
			if (in_array("above55", $searchAgeArray)) {
				$filterTmp .= " OR userAge >=55 ";
			}
			if (in_array("notage", $searchAgeArray)) {
				$filterTmp .= " OR userAge ='' ";
			}
			$filter .= substr($filterTmp, 3) . " )";
			$filter1 .= substr($filterTmp, 3) . " )";
			$filterStatus  = true;
			$filterStatus1 = true;		
		}
		if (count($searchGenderArray) > 0) {
			$searchGender = "" . implode("','", $searchGenderArray) . "";
			$filter .= " AND userSex IN('" . $searchGender . "')";
			$filter1 .= " AND userSex IN('" . $searchGender . "')";


			$filterStatus  = true;
			$filterStatus1 = true;
		}
		if (count($searchOs) > 0) {
			$searchOsStr = "" . implode("','", $searchOs) . "";
			$filter .= " AND operatingSystem IN('" . $searchOsStr . "')";
			$filter1 .= " AND operatingSystem IN('" . $searchOsStr . "')";
			$filterStatus  = true;
			$filterStatus1 = true;
		}
		if (count($searchBrowser) > 0) {
			$searchBrowserStr = "" . implode("','", $searchBrowser) . "";
			$searchBrowserStr = str_replace("Unknown", "", $searchBrowserStr);
			$filter .= " AND browserName IN('" . $searchBrowserStr . "')";
			$filter1 .= " AND browserName IN('" . $searchBrowserStr . "')";
			$filterStatus  = true;
			$filterStatus1 = true;
		}
		if (strpos($date, 'to') > 0) {
			$queryString = explode('to', $date);
			$fromDate	= $queryString[0] . ' 00:00:00';
			$toDate	  = $queryString[1] . ' 23:59:59';
			if ($queryString[1] == date("Y-m-d")) {
				$filter .= " AND entryTime BETWEEN '" . $fromDate . "' AND NOW()";
			} else {
				$toDate = $queryString[1] . ' 23:59:59';
				$filter .= " AND entryTime BETWEEN '" . $fromDate . "' AND '" . $toDate . "'";
			}
			$filterStatus = true;
		} else {
			$fromDate = $date;
			$filter .= " AND DATE(entryTime)='" . $date . "'";
			$filterStatus = true;
		}
		$mobileWeb = ($platform == 'Web') ? 'No' : 'Yes';
		if ($platform != 'All') {
			$filter .= ($platform == 'Web') ? " AND isMobileWeb='No'" : " AND isMobileWeb='Yes'";
			$filterStatus = true;
		}
		$sql	=	"	SELECT 
							CASE 
								WHEN 
									browserName='' 
								THEN 
									'Unknown' 
								ELSE 
									browserName
						  	END AS browserName,
							COUNT(visitorID) AS visit,
							ROUND(SUM(pageCount)/COUNT(visitorID)) AS avgPageVisit,
							IF
								(
									SUM(TIMESTAMPDIFF(SECOND,entryTime,exitTime))> 0,SEC_TO_TIME(sum(TIMESTAMPDIFF(SECOND,entryTime,exitTime))/count(visitorID))
								,'00:00:00'
								) AS avgPageVisitDuration,
							IF
								(
									SUM(TIMESTAMPDIFF(SECOND,entryTime,exitTime))> 0,sum(TIMESTAMPDIFF(SECOND,entryTime,exitTime))/count(visitorID)
								,0
								) AS avgPageVisitDurationInSec,	
							SUM(doneSignUp) AS registration,
							SUM(doneSubscribe) AS subscription,
							SUM(orderPlaced) AS orderCount,
							SUM(orderAmount) AS revenue
							FROM 
								".DB_PREFIX."visitor_info_log 
							WHERE 
								(`userType`='user' OR `userType`='guest') 
								AND 
									`pageCount`>0 
								AND 
									referrerType!='Crawlers'";
		if ($filterStatus == true)
			$sql.=	" AND " . substr($filter, 4);
		if($sortByOption=='avgPageVisitDuration')
		{
			$sortByOption='avgPageVisitDurationInSec';
		}		
		$sql .= 			"	GROUP BY 
									browserName
								ORDER BY " . $sortByOption . " " . $sortByOrder;
		$resSelectLog = $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);
		if (count($resSelectLog) > 0) {
			foreach ($resSelectLog as $key => $value) {
				$browserNameString .= $value['browserName'] . "->";
			}
		}
		$browserNameString = substr($browserNameString, 0, -2);
		$sql	=	"	SELECT 
							visitorID,
							pageCount,
							exitTime,
							entryTime,
							userID,
							remoteAddress,
							userType,
							orderAmount,
							visitorCookieID
						FROM 
							".DB_PREFIX."visitor_info_log
						WHERE 
							( `userType`='user' OR `userType`='guest')
							AND 
								`pageCount`>0 
							AND 
								referrerType!='Crawlers' 
							AND
								city!='' ";
		if ($filterStatus == true)
			$sql .= " AND " . substr($filter, 4);
		//$resSelectLogTotalValue					= $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);
		
		$resSelectLogTotalValue                 = $this->ObjDatabase->readValuesObject($sql);
		$tempCount                      		= $resSelectLogTotalValue->num_rows;
		
		$visitCount								= 0;
		$bounceCount							= 0;
		$totalPageCount							= 0;
		$visitorCount							= $tempCount;
		$resSelectLogTotal['visit']				= 0;
		$avgPageCount							= 0;
		$avgBounceCount							= 0;
		$revenue								= 0;
		$resSelectLogTotal['avgPageVisitDuration'] = '00 M : 00 S';
		$resSelectLogTotal['newVisit']			= 0;
		$resSelectLogTotal['returnVisit']		= 0;
		if ($visitorCount > 0) 
		{
			for ($i = 0; $i < $tempCount; $i++)
			{
				$valueTot       = $resSelectLogTotalValue->fetch_array(MYSQL_ASSOC);
				$bounceCount	= ($valueTot['pageCount'] == 1) ? $bounceCount + 1 : $bounceCount;
				$totalPageCount = $totalPageCount + $valueTot['pageCount'];
				if ($valueTot['exitTime'] != '0000-00-00 00:00:00' && $valueTot['exitTime'] != '') {
					$totalTimeSpend = $totalTimeSpend + (strtotime($valueTot['exitTime']) - strtotime($valueTot['entryTime']));
				}
				if ($valueTot['userID'] > 0 && $valueTot['userType'] == 'user') {
					$userIdArryCount[] = $valueTot['userID'];
				} else {
					$ipaddressAraayCount[] = $valueTot['visitorCookieID'];
				}
				$revenue = $revenue + $valueTot['orderAmount'];
				unset($valueTot);
			}
			$avgPageCount   = ($totalPageCount > 0 && $visitorCount > 0) ? round(($totalPageCount / $visitorCount), 2) : 0;
		  
			$totalTimeSpend = $totalTimeSpend / $visitorCount;
			if ($totalTimeSpend > 0) {
				$avgVisitDuration = $this->getTimeDiffrance('', '', $totalTimeSpend);
			}
			if ($bounceCount > 0) {
				$avgBounceCount = round(($bounceCount / $visitorCount) * 100, 2);
			}
			$UserIDData = (count($userIdArryCount) > 0) ? array_count_values($userIdArryCount) : array();
			$IpData	 = (count($ipaddressAraayCount) > 0) ? array_count_values($ipaddressAraayCount) : array();
			unset($resSelectLogTotalValue);
			$UserIDData	  = (count($userIdArryCount) > 0) ? array_count_values($userIdArryCount) : array();
			$IpData		  = (count($ipaddressAraayCount) > 0) ? array_count_values($ipaddressAraayCount) : array();
			$sql	=	"	SELECT 
								DISTINCT(visitorCookieID) 
							FROM 
								".DB_PREFIX."visitor_info_log 
							WHERE 
								(`userType`='user' OR `userType`='guest')	
								AND
									`pageCount`>0 
								AND
									referrerType!='Crawlers' 
								AND 
									entryTime < '" . $fromDate . "' 
								AND userID < 1";
			if ($filterStatus1 == true) {
				$sql .= " AND " . substr($filter1, 4);
			}
			$resSelectLogTotalValueOldIpObj = $this->ObjDatabase->readValuesObject($sql);
			$tempCount					  = $resSelectLogTotalValueOldIpObj->num_rows;
			if ($tempCount > 0) {
				for ($i = 0; $i < $tempCount; $i++) {
					$result						= $resSelectLogTotalValueOldIpObj->fetch_array(MYSQL_ASSOC);
					$resSelectLogTotalValueOldIp[] = $result['visitorCookieID'];
				}
			}
			$IpDataOld	   = (count($resSelectLogTotalValueOldIp) > 0) ? array_count_values($resSelectLogTotalValueOldIp) : array();
			$sql	=	"	SELECT
								DISTINCT(userID) 
							FROM 
								".DB_PREFIX."visitor_info_log 
							WHERE 
								(`userType`='user' OR `userType`='guest')
								AND 
									`pageCount`>0 
								AND 
									referrerType!='Crawlers' 
								AND 
									entryTime < '" . $fromDate . "' 
								AND 
									userID >0";
			if ($filterStatus1 == true) {				
				$sql .= " AND " . substr($filter1, 4);
			}			
			$resSelectLogTotalValueOldUserIdObj = $this->ObjDatabase->readValuesObject($sql);
			$tempCount						  = $resSelectLogTotalValueOldUserIdObj->num_rows;
			if ($tempCount > 0) {
				for ($i = 0; $i < $tempCount; $i++) {
					$result							= $resSelectLogTotalValueOldUserIdObj->fetch_array(MYSQL_ASSOC);
					$resSelectLogTotalValueOldUserId[] = $result['userID'];
				}
			}
			$UserIDDataOld   = (count($resSelectLogTotalValueOldUserId) > 0) ? array_count_values($resSelectLogTotalValueOldUserId) : array();
			$retunringUserID = 0;
			$retunringIp	 = 0;
			$newUserId	   = 0;
			$newIp		   = 0;
			if (count($UserIDData) > 0) {
				foreach ($UserIDData as $key => $value) {
					(isset($UserIDDataOld[$key])) ? $retunringUserID++ : $newUserId++;
				}
			}
			foreach ($IpData as $key => $value) {
				(isset($IpDataOld[$key])) ? $retunringIp++ : $newIp++;
			}
			$resSelectLogTotal['newVisit']	= $newUserId + $newIp;
			$resSelectLogTotal['returnVisit'] = $retunringUserID + $retunringIp;
		}
		if (count($avgVisitDuration) > 0) {
			if ($avgVisitDuration['days'] > 0) {
				$durationText = "<span style='font:bold 19px/19px Arial,Helvetica,sans-serif'>";
				$durationText .= ($avgVisitDuration['days'] > 0) ? " " . $avgVisitDuration['days'] . " Days <br>" : "";
				$durationText .= ($avgVisitDuration['hours'] > 0) ? " " . $avgVisitDuration['hours'] . " H :" : "";
				$durationText .= ($avgVisitDuration['mins'] > 0) ? " " . $avgVisitDuration['mins'] . " M :" : "";
				$durationText .= ($avgVisitDuration['secs'] > 0) ? " " . $avgVisitDuration['secs'] . " S :" : "";
				$resSelectLogTotal['avgPageVisitDuration'] = substr($durationText, 0, -1);
			} else {
				$durationText .= ($avgVisitDuration['days'] > 0) ? " " . $avgVisitDuration['days'] . " Days :" : "";
				$durationText .= ($avgVisitDuration['hours'] > 0) ? " " . $avgVisitDuration['hours'] . " H :" : "";
				$durationText .= ($avgVisitDuration['mins'] > 0) ? " " . $avgVisitDuration['mins'] . " M :" : "";
				$durationText .= ($avgVisitDuration['secs'] > 0) ? " " . $avgVisitDuration['secs'] . " S :" : "";
				$resSelectLogTotal['avgPageVisitDuration'] = substr($durationText, 0, -1);
			}
		}
		$resSelectLogTotal['visit']			 = $visitorCount;
		$resSelectLogTotal['avgPageVisit']	  = $avgPageCount;
		$resSelectLogTotal['bounceRate']		= $avgBounceCount;
		$resSelectLogTotal['revenue']		   = $revenue;
		$resSelectLogTotal['browserNameString'] = $browserNameString;
		$resSelectLogTotal['filter']			= $filter;
		$resSelectLogTotal['filter1']		   = $filter1;
		$resSelectLogTotal['fromDate']		  = $fromDate;
		return (array(
			$resSelectLog,
			$resSelectLogTotal
		));
	}
	
	public function getTotalCounts($searchCity = array(), $searchCountry = array(), $searchAgeArray = array(), $searchGenderArray = array(), $date = '', $platform = 'All', $counter = 'Visit')
	{
		$filterStatus = false;
		if (count($searchCity) > 0) {
			$searchCities = "" . implode("','", $searchCity) . "";
			$filter .= " AND city IN('" . $searchCities . "')";
			$filterStatus = true;
			$filter1 .= " AND city IN('" . $searchCities . "')";
			$filterStatus1 = true;
		}
		if (count($searchCountry) > 0) {
			$searchCountries = "" . implode("','", $searchCountry) . "";
			$filter .= " AND country IN('" . $searchCountries . "')";
			$filterStatus = true;
			$filter1 .= " AND country IN('" . $searchCountries . "')";
			$filterStatus1 = true;
		}
		if (count($searchAgeArray) > 0) {
			$filter .= " AND ( ";
			$filter1 .= " AND ( ";
			if (in_array("below17", $searchAgeArray)) {
				$filterTmp .= " OR userAge BETWEEN 1 AND 17 ";
			}
			if (in_array("18-24", $searchAgeArray)) {
				$filterTmp .= " OR userAge BETWEEN 18 AND 24 ";
			}
			if (in_array("25-34", $searchAgeArray)) {
				$filterTmp .= " OR userAge between 25 AND 34 ";
			}
			if (in_array("35-54", $searchAgeArray)) {
				$filterTmp .= " OR userAge between 35 AND 54 ";
			}
			if (in_array("above55", $searchAgeArray)) {
				$filterTmp .= " OR userAge >=55 ";
			}
			if (in_array("notage", $searchAgeArray)) {
				$filterTmp .= " OR userAge ='' ";
			}
			$filter .= substr($filterTmp, 3) . " )";
			$filterStatus = true;
			$filter1 .= substr($filterTmp, 3) . " )";
			$filterStatus1 = true;
		}
		if (count($searchGenderArray) > 0) {
			$searchGender = "" . implode("','", $searchGenderArray) . "";
			$filter .= " AND userSex IN('" . $searchGender . "')";
			$filterStatus = true;
			$filter1 .= " AND userSex IN('" . $searchGender . "')";
			$filterStatus1 = true;
		}
		if (strpos($date, 'to') > 0) {
			$queryString = explode('to', $date);
			$fromDate	= $queryString[0] . ' 00:00:00';
			if ($queryString[1] == date("Y-m-d")) {
				$filter .= " AND entryTime BETWEEN '" . $fromDate . "' AND NOW()";
			} else {
				$toDate = $queryString[1] . ' 23:59:59';
				$filter .= " AND entryTime BETWEEN '" . $fromDate . "' AND '" . $toDate . "'";
			}
			$filterStatus = true;
		} else {
			$fromDate = $date;
			$filter .= " AND DATE(entryTime)='" . $date . "'";
			$filterStatus = true;
		}
		$mobileWeb = ($platform == 'Web') ? 'No' : 'Yes';
		if ($platform != 'All') {
			$filter .= ($platform == 'Web') ? " AND isMobileWeb='No'" : " AND isMobileWeb='Yes'";
			$filterStatus = true;
			$filter1 .= ($platform == 'Web') ? " AND isMobileWeb='No'" : " AND isMobileWeb='Yes'";
			$filterStatus1 = true;
		}
		switch ($counter) {
			case 'Visit':
				break;
			case 'Bounce Rate':
				$filter .= " AND pageCount = 1";
				$filter1 .= " AND pageCount = 1";
				break;
			case 'Subscriptions':
				$filter .= " AND doneSubscribe = 1";
				$filter1 .= " AND doneSubscribe = 1";
				break;
			case 'Registrations':
				$filter .= " AND doneSignUp = 1";
				$filter1 .= " AND doneSignUp = 1";
				break;
			case 'Orders':
				$filter .= " AND orderPlaced = 1";
				$filter1 .= " AND orderPlaced = 1'";
				break;
		}
		$sql	=	"	SELECT 
							visitorID,
							pageCount,
							exitTime,
							entryTime,
							userID,
							remoteAddress,
							userType ,
							visitorCookieID
						FROM 
							".DB_PREFIX."visitor_info_log 
						WHERE  
							(`userType`='user' OR `userType`='guest') 
							AND 
								`pageCount`>0 
							AND 
								referrerType!='Crawlers' ";
		if ($filterStatus == true) {
			$sql .= " AND " . substr($filter, 4);
		}
		//$resSelectLogTotalValue					= $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);
		$resSelectLogTotalValue                 = $this->ObjDatabase->readValuesObject($sql);
		$tempCount                      		= $resSelectLogTotalValue->num_rows;
		$visitorCount							= 0;
		$bounceCount							= 0;
		$totalPageCount							= 0;
		$resSelectLogTotal['visit']				= 0;
		$avgPageCount							= 0;
		$avgBounceCount							= 0;
		$revenue								   = 0;
		$resSelectLogTotal['avgPageVisitDuration'] = '00 M : 00 S';
		$resSelectLogTotal['newVisit']			 = 0;
		$resSelectLogTotal['returnVisit']		 = 0;
		$visitorCount							 = $tempCount;
		if($visitorCount > 0) 
		{
			for ($i = 0; $i < $tempCount; $i++)
			{
				$valueTot       = $resSelectLogTotalValue->fetch_array(MYSQL_ASSOC);
				$bounceCount	= ($valueTot['pageCount'] == 1) ? $bounceCount + 1 : $bounceCount;
				$totalPageCount = $totalPageCount + $valueTot['pageCount'];
				if ($valueTot['exitTime'] != '0000-00-00 00:00:00' && $valueTot['exitTime'] != '') {
					$totalTimeSpend = $totalTimeSpend + (strtotime($valueTot['exitTime']) - strtotime($valueTot['entryTime']));
				}
				if ($valueTot['userID'] > 0 && $valueTot['userType'] == 'user') {
					$userIdArryCount[] = $valueTot['userID'];
				} else {
					$ipaddressAraayCount[] = $valueTot['visitorCookieID'];
				}
			}
			unset($resSelectLogTotalValue);
			$UserIDData	  = (count($userIdArryCount) > 0) ? array_count_values($userIdArryCount) : array();
			$IpData		  = (count($ipaddressAraayCount) > 0) ? array_count_values($ipaddressAraayCount) : array();
			$sqlSelectLogOld = "SELECT distinct(visitorCookieID) FROM " . DB_PREFIX . "visitor_info_log as vl WHERE (`userType`='user' OR `userType`='guest')		 AND `pageCount`>0 and referrerType!='Crawlers' and entryTime < '" . $fromDate . "' and userID < 1";
			if ($filterStatus1 == true) {
				$sqlSelectLogOld .= " and " . substr($filter1, 4);
			}
			$resSelectLogTotalValueOldIpObj = $this->ObjDatabase->readValuesObject($sqlSelectLogOld);
			$tempCount					  = $resSelectLogTotalValueOldIpObj->num_rows;
			if ($tempCount > 0) {
				for ($i = 0; $i < $tempCount; $i++) {
					$result						= $resSelectLogTotalValueOldIpObj->fetch_array(MYSQL_ASSOC);
					$resSelectLogTotalValueOldIp[] = $result['visitorCookieID'];
				}
			}
			$IpDataOld	   = (count($resSelectLogTotalValueOldIp) > 0) ? array_count_values($resSelectLogTotalValueOldIp) : array();
			$sqlSelectLogOld = "SELECT distinct(userID) FROM " . DB_PREFIX . "visitor_info_log as vl WHERE (`userType`='user' OR `userType`='guest')				 AND `pageCount`>0 and referrerType!='Crawlers' and entryTime < '" . $fromDate . "' and userID >0";
			if ($filterStatus1 == true) {
				$sqlSelectLogOld .= " and " . substr($filter1, 4);
			}
			$resSelectLogTotalValueOldUserIdObj = $this->ObjDatabase->readValuesObject($sqlSelectLogOld);
			$tempCount						  = $resSelectLogTotalValueOldUserIdObj->num_rows;
			if ($tempCount > 0) {
				for ($i = 0; $i < $tempCount; $i++) {
					$result							= $resSelectLogTotalValueOldUserIdObj->fetch_array(MYSQL_ASSOC);
					$resSelectLogTotalValueOldUserId[] = $result['userID'];
				}
			}
			$UserIDDataOld   = (count($resSelectLogTotalValueOldUserId) > 0) ? array_count_values($resSelectLogTotalValueOldUserId) : array();
			$retunringUserID = 0;
			$retunringIp	 = 0;
			$newUserId	   = 0;
			$newIp		   = 0;
			if (count($UserIDData) > 0) {
				foreach ($UserIDData as $key => $value) {
					(isset($UserIDDataOld[$key])) ? $retunringUserID++ : $newUserId++;
				}
			}
			foreach ($IpData as $key => $value) {
				(isset($IpDataOld[$key])) ? $retunringIp++ : $newIp++;
			}
			$avgPageCount   = ($totalPageCount > 0 && $visitorCount > 0) ? round(($totalPageCount / $visitorCount), 2) : 0;		   
			$totalTimeSpend = $totalTimeSpend / $visitorCount;
			if ($totalTimeSpend > 0) {
				$avgVisitDuration = $this->getTimeDiffrance('', '', $totalTimeSpend);
			}
			if ($bounceCount > 0) {
				$avgBounceCount = round(($bounceCount / $visitorCount) * 100, 2);
			}
			$resSelectLogTotal['newVisit']	= $newUserId + $newIp;
			$resSelectLogTotal['returnVisit'] = $retunringUserID + $retunringIp;

		}
		if (count($avgVisitDuration) > 0) {
			if ($avgVisitDuration['days'] > 0) {
				$durationText = "<span style='font:bold 19px/19px Arial,Helvetica,sans-serif'>";
				$durationText .= ($avgVisitDuration['days'] > 0) ? " " . $avgVisitDuration['days'] . " Days <br>" : "";
				$durationText .= ($avgVisitDuration['hours'] > 0) ? " " . $avgVisitDuration['hours'] . " H :" : "";
				$durationText .= ($avgVisitDuration['mins'] > 0) ? " " . $avgVisitDuration['mins'] . " M :" : "";
				$durationText .= ($avgVisitDuration['secs'] > 0) ? " " . $avgVisitDuration['secs'] . " S :" : "";
				$resSelectLogTotal['avgPageVisitDuration'] = substr($durationText, 0, -1);
			} else {
				$durationText .= ($avgVisitDuration['days'] > 0) ? " " . $avgVisitDuration['days'] . " Days :" : "";
				$durationText .= ($avgVisitDuration['hours'] > 0) ? " " . $avgVisitDuration['hours'] . " H :" : "";
				$durationText .= ($avgVisitDuration['mins'] > 0) ? " " . $avgVisitDuration['mins'] . " M :" : "";
				$durationText .= ($avgVisitDuration['secs'] > 0) ? " " . $avgVisitDuration['secs'] . " S :" : "";
				$resSelectLogTotal['avgPageVisitDuration'] = substr($durationText, 0, -1);
			}
		}
		$resSelectLogTotal['visit']		= $visitorCount;
		$resSelectLogTotal['avgPageVisit'] = $avgPageCount;
		$resSelectLogTotal['bounceRate']   = $avgBounceCount;
		$resSelectLogTotal['bouncevisits'] = $bounceCount;
		$resSelectLogTotal['totalvisits']  = $visitorCount;
		return $resSelectLogTotal;
	}
	
	public function arraySort(&$array, $key, $order)
	{
		$sorter = array();
		$ret	= array();
		reset($array);
		foreach ($array as $ii => $va) {
			$sorter[$ii] = $va[$key];
		}
		($order == 'asc') ? asort($sorter) : arsort($sorter);
		foreach ($sorter as $ii => $va) {
			$ret[$ii] = $array[$ii];
		}
		$array = $ret;
	}
	
	public function getLanguageDetailsByCityName($cityName = '', $filter = '')
	{
		$sql	=	"	SELECT 
							DISTINCT languageName,
							COUNT(*) as count 
						FROM 
							".DB_PREFIX."visitor_info_log AS visInfLog 
						LEFT JOIN 
							 ".DB_PREFIX."languages AS lan 
							 ON 
								(visInfLog.languageID=lan.languageID) 
						WHERE 
							(userType='guest' OR userType='user') 
							AND 
								pageCount>0 
							AND 
								referrerType!='Crawlers' 
							AND ";
		if ($cityName == '') {
			$sql.="				city!='' 
							AND 
								" . substr($filter, 4) . 
						"GROUP BY visInfLog.languageID";
		} else {
			$sql.=				"city='" . $cityName . "' 
							AND " . substr($filter, 4) . " 
						GROUP BY visInfLog.languageID";
		}
		$resSelectLanguage = $this->ObjDatabase->readValues($sql);
		return $resSelectLanguage;
	}
	
	public function getNewReturingUniqueVistorCounts($dataArray = '', $type = 'city', $filter = '', $filter1 = '', $fromDate = '')
	{
		if ($type == 'browserName' && $dataArray != '') {
			$dataArray = str_replace("Unknown", "", $dataArray);
		}
		$resSelectLog = explode("->", $dataArray);
		if (count($resSelectLog) > 0) {
			foreach ($resSelectLog as $key => $value) {
				$value = $this->encodeSplChar($value);
				$prevUserIDs	= '';
				$prevIPs		= '';
				$sql	=	"	SELECT 
									DISTINCT(`userID`) 
								FROM 
									".DB_PREFIX."visitor_info_log 
								WHERE 
									".$type . "='" . $value . "' 
									AND
										`userType`='user' 
									AND 
										`pageCount`>0 
									AND 
										referrerType!='Crawlers' 
									AND 
										`userID`!='' 
									AND 
										DATE(`entryTime`) <'" . $fromDate . "' ";
				if ($filter1 != '')
					$sql .= " AND " . substr($filter1, 4);
				$resPrevUSerIDs = $this->ObjDatabase->readValuesObject($sql, MYSQL_ASSOC);
				$Count		  = $resPrevUSerIDs->num_rows;
				if ($Count > 0) {
					for ($i = 0; $i < $Count; $i++) {
						$result = $resPrevUSerIDs->fetch_array(MYSQL_ASSOC);
						$prevUserIDs .= "'" . $result['userID'] . "',";
						unset($result);
					}
					$resPrevUSerIDs->free();

				}
				$prevUserIDs  = substr($prevUserIDs, 0, -1);
				$sql = "SELECT COUNT(DISTINCT(`userID`)) as newVisit FROM " . DB_PREFIX . "visitor_info_log WHERE " . $type . "='" . $value . "' 
			AND `userType`='user' AND `pageCount`>0 and referrerType!='Crawlers' AND `userID`!='' AND " . substr($filter, 4);
				if ($prevUserIDs != '') {
					$sql .= " AND `userID` NOT IN (" . $prevUserIDs . ") ";
				}
				$newVistCount				  = $this->ObjDatabase->readValue($sql, MYSQL_ASSOC);
				$totalResult[$key]['newVisit'] = $newVistCount['newVisit'];
				$sql	=	"	SELECT 
									DISTINCT(`visitorCookieID`) 
								FROM 
									".DB_PREFIX."visitor_info_log 
								WHERE 
									".$type."='" . $value . "' 
									AND
										`userType`='guest' 
									AND 
										`pageCount`>0 
									AND 
										referrerType!='Crawlers' 
									AND 
										DATE(`entryTime`) <'" . $fromDate . "' ";
				if ($filter1 != '')
					$sql .= " and " . substr($filter1, 4);
				$resPrevIPs = $this->ObjDatabase->readValuesObject($sql, MYSQL_ASSOC);
				$Count	  = $resPrevIPs->num_rows;
				if ($Count > 0) {
					for ($i = 0; $i < $Count; $i++) {
						$result = $resPrevIPs->fetch_array(MYSQL_ASSOC);
						$prevIPs .= "'" . $result['visitorCookieID'] . "',";
						unset($result);
					}
					$resPrevIPs->free();
				}
				$prevIPs	  = substr($prevIPs, 0, -1);
				$sql	=	"	SELECT 
									COUNT(DISTINCT(`visitorCookieID`)) AS newVisit 
								FROM 
									".DB_PREFIX."visitor_info_log 
								WHERE 
									".$type."='".$value."'
									AND 
										`userType`='guest' 
									AND 
										`pageCount`>0 
									AND 
										referrerType!='Crawlers' 
									AND 
										" . substr($filter, 4);
				if ($prevIPs != '') {
					$sql .= " AND `visitorCookieID` NOT IN (" . $prevIPs . ") ";
				}
				$newVistCount						= $this->ObjDatabase->readValue($sql, MYSQL_ASSOC);
				$totalResult[$key]['newVisit']	   = $totalResult[$key]['newVisit'] + $newVistCount['newVisit'];
				$sql	=	"	SELECT 
									COUNT(DISTINCT(`userID`)) AS uniqueVisit 
								FROM 
									`".DB_PREFIX. "visitor_info_log` 
								WHERE 
									" . $type . "='" . $value . "'
									AND 
										`userType`='user' 
									AND 
										`pageCount`>0 
									AND 
										referrerType!='Crawlers' 
									AND 
										`userID`!='' 
									AND " . substr($filter, 4);
				$uniueCountres1					  = $this->ObjDatabase->readValue($sql, MYSQL_ASSOC);
				$totalResult[$key]['uniqueVisit']	= $uniueCountres1['uniqueVisit'];
				$sql	=	"	SELECT 
									COUNT(DISTINCT(`visitorCookieID`)) AS uniqueVisit 
								FROM 
									`".DB_PREFIX."visitor_info_log` 
								WHERE 
									`userID`='' 
									AND 
										" . $type . "='" . $value . "' 
									AND 
										`userType`='guest' 
									AND 
										`pageCount`>0 
									AND 
										referrerType!='Crawlers' 
									AND " . substr($filter, 4);
				$uniueCountres2					  = $this->ObjDatabase->readValue($sql, MYSQL_ASSOC);
				$totalResult[$key]['uniqueVisit']	= $totalResult[$key]['uniqueVisit'] + $uniueCountres2['uniqueVisit'];
				$totalResult[$key]['returningVisit'] = $totalResult[$key]['uniqueVisit'] - $totalResult[$key]['newVisit'];
				$totalResult[$key][$type]			= ($value == 'zOthers') ? "OTHERS" : $value;
			}
			return $totalResult;
		}
	}
	//GET CRAWLER DATA
	
	public function getDistinctCrawlers($limitFrom = 0, $limitTo = "")
	{
		if ($limitTo) {
			$sqlSelectCrawlers .= " SELECT SQL_CALC_FOUND_ROWS ";
		}
		$sqlSelectCrawlers .= " userAgent  ,count(*) as count,visitorID FROM " . DB_PREFIX . "visitor_info_log  
							 		WHERE referrerType='Crawlers' AND pageCount='1' group by userAgent	";
		//IF PAGINATION REQUIRED	
		if ($limitTo) {
			$sqlSelectCrawlers .= "LIMIT  " . $limitFrom . "," . $limitTo . "";
		}
		$resSelectCrawlers = $this->ObjDatabase->readValues($sqlSelectCrawlers);
		return $resSelectCrawlers;
	}
	//DELETE CRAWLER DATA
	public function deleteCrawlers($POST = '')
	{
		if (is_array($POST['crawlers']))
			$userAgents = (count($POST['crawlers']) == 1) ? "'" . implode(",", $POST['crawlers']) . "'" : "'" . implode("','", $POST['crawlers']) . "'";
		else
			$userAgents = "'" . $POST['crawlers'] . "'";
		$sql	=	"	SELECT 
							visitorID 
						FROM 
							".DB_PREFIX. "visitor_info_log  
						WHERE 
							userAgent IN (" . $userAgents . ") 
							AND 
								referrerType='Crawlers' 
							AND 
								pageCount='1'";
		$resSelectCrawlerIDs = $this->ObjDatabase->readValues($sql);
		foreach ($resSelectCrawlerIDs as $crawler) {
			$sql	=	"	DELETE FROM 
								".DB_PREFIX."visitor_url_log 
							WHERE 
								visitorID ='" . $crawler['visitorID'] . "'
								AND EXISTS
								(
									SELECT 
										* 
									FROM 
										".DB_PREFIX."visitor_info_log 
									WHERE 
										".DB_PREFIX."visitor_url_log.visitorID = " . DB_PREFIX . "visitor_info_log.visitorID
								)";
			$resDeleteFromUrl  = $this->ObjDatabase->setQuery($sql);
			$sql	=	"	DELETE 
								FROM 
									".DB_PREFIX."visitor_info_log 
								WHERE 
									visitorID='" . $crawler['visitorID'] . "'";
			$resDeleteFromInfo = $this->ObjDatabase->setQuery($sql);
		}
		return true;
	}
	

	public function getSearchEngineVisitAttributes($dateRange, $finalString, $countryString, $cityString, $platform)
	{
		$stringArr = explode(",", $finalString);
		if (strpos($dateRange, 'to') > 0) {
			$dateArray	   = explode("to", $dateRange);
			$fromDate		= $dateArray[0];
			$toDate		  = $dateArray[1];
			$appendDateQuery = " AND DATE(entryTime)>='" . $fromDate . "' AND DATE(entryTime)<='" . $toDate . "'";
		} else {
			$fromDate		= $dateRange;
			$appendDateQuery = " AND DATE(entryTime)='" . $fromDate . "'";
		}
		$nestedAppendDateQuery = " AND DATE(entryTime)<'" . $fromDate . "'";
		if ($countryString) {
			$appendDateQuery .= " AND country IN('" . $countryString . "')";
			$nestedAppendDateQuery .= " AND country IN('" . $countryString . "')";
		}
		if ($cityString) {
			$appendDateQuery .= " AND city IN('" . $cityString . "')";
			$nestedAppendDateQuery .= " AND city IN('" . $cityString . "')";
		}
		if (!$platform || $platform != 'All') {
			if ($platform == 'Web') {
				$appendDateQuery .= " AND isMobileWeb='No'";
				$nestedAppendDateQuery .= " AND isMobileWeb='No'";
			} else if ($platform == 'Apps') {
				$appendDateQuery .= " AND isMobileWeb='Yes'";
				$nestedAppendDateQuery .= " AND isMobileWeb='Yes'";
			}
		}
		$domainArr = $stringArr;
		for ($ref = 0; $ref < count($domainArr); $ref++) {
			$domainName		  = $domainArr[$ref];
			$sql	=	"	SELECT 
								DISTINCT(userID) AS disuser 
							FROM 
								" . DB_PREFIX . "visitor_info_log 
							WHERE 
								`userType`='user' 
								AND 
									`pageCount`>0
								AND 
									searchEngineName='" . $domainName . "' 
								AND 
									userID>0";
			$sql .= $nestedAppendDateQuery;
			$resNotInString = $this->ObjDatabase->readValuesObject($sql);
			$rowCount	   = $resNotInString->num_rows;
			for ($i = 0; $i < $rowCount; $i++) {
				$resultSet	= $resNotInString->fetch_array(MYSQL_ASSOC);
				$singleUserID = $singleUserID . "'" . $resultSet['disuser'] . "',";
				unset($resultSet);
			}
			$resNotInString->free();
			if ($rowCount > 0) {
				$finalNotInString = substr($singleUserID, 0, -1);
			}
			//DISTINCT IP ADDRESS												
			$sql	=	"	SELECT 
								DISTINCT(visitorCookieID) AS disip 
							FROM 
								" . DB_PREFIX . "visitor_info_log 
							WHERE 
							`userType`='guest' 
								AND 
									`pageCount`>0
								AND 
									searchEngineName='" . $domainName . "' 
								AND 
									userID=''";
			$sql .= $nestedAppendDateQuery;
			$resNotInStringOfIp = $this->ObjDatabase->readValuesObject($sql);
			$rowCountIp		 = $resNotInStringOfIp->num_rows;
			for ($ip = 0; $ip < $rowCountIp; $ip++) {
				$resultSet	   = $resNotInStringOfIp->fetch_array(MYSQL_ASSOC);
				$singleIPAddress = $singleIPAddress . "'" . $resultSet['disip'] . "',";
				unset($resultSet);
			}
			if ($rowCountIp) {
				$finalNotInStringIP = substr($singleIPAddress, 0, -1);
			}
			//FETCHING OF NOT IN/IN STRING ENDS HERE				
			//FETCHING OF NEW VISIORS 
			$sql	=	"	SELECT
								COUNT(DISTINCT(userID)) AS newuserIdCount
							FROM 
								" . DB_PREFIX . "visitor_info_log
							WHERE
								`userType`='user' 
								AND 
									`pageCount`>0
								AND 
									searchEngineName='" . $domainName . "' 
								AND 
									userID>0 ";
			$sql .= $appendDateQuery;
			if ($rowCount > 0) {
				$sql .= " AND userID NOT IN(" . $finalNotInString . ")";
			}
			$newCountArr			 = $this->ObjDatabase->readValue($sql); //New Visitor Based On User ID	
			$sql	=	"	SELECT 
								COUNT(DISTINCT(visitorCookieID)) AS newIpCount 
							FROM 
								" . DB_PREFIX . "visitor_info_log 
							WHERE 
								`userType`='guest' 
								AND 
									`pageCount`>0
								AND 
									searchEngineName='" . $domainName . "' 
								AND 
									userID=''";
			$sql .= $appendDateQuery;
			if ($rowCountIp > 0) {
				$sql .= " AND visitorCookieID NOT IN(" . $finalNotInStringIP . ")";
			}
			$newCountIPArr						  = $this->ObjDatabase->readValue($sql); //New Visitor Based On User ID
			$allTrafficdetailArr[$ref]['newvisits'] = $newCountArr['newuserIdCount'] + $newCountIPArr['newIpCount'];
			unset($newCountArr);
			unset($newCountIPArr);
			//FETCHING OF DISTINCT VISITORS
			$sql	=	"	SELECT 
								COUNT(DISTINCT(userID)) AS uniqueuser 
							FROM 
								" . DB_PREFIX . "visitor_info_log 
							WHERE
								`userType`='user' 
								AND 
									`pageCount`>0
								AND 
									searchEngineName='" . $domainName . "' 
								AND 
									userID>0";
			$sql .= $appendDateQuery;
			$uniqArrUser	   = $this->ObjDatabase->readValue($sql);
			$sql	=	"	SELECT 
								COUNT(DISTINCT(visitorCookieID)) AS uniqueIP 
							FROM 
								" . DB_PREFIX . "visitor_info_log 
							WHERE 
								`userType`='guest' 
							AND 
								`pageCount`>0 
							AND 
								searchEngineName='" . $domainName . "' 
							AND 
								userID=''";
			$sql .= $appendDateQuery;
			$uniqueArrIP	   = $this->ObjDatabase->readValue($sql);
			$allTrafficdetailArr[$ref]['uniquevisits'] = $uniqArrUser['uniqueuser'] + $uniqueArrIP['uniqueIP'];
			unset($uniqArrUser);
			unset($uniqueArrIP);
			$allTrafficdetailArr[$ref]['retvisits'] = $allTrafficdetailArr[$ref]['uniquevisits'] - $allTrafficdetailArr[$ref]['newvisits'];
			//print_r($allTrafficdetailArr);
			//exit;
		}
		return $allTrafficdetailArr;
	}
	
	public function getSearchEngineKeywordVisitAttributes($dateRange, $finalString, $countryString, $cityString, $platform)
	{
		$stringArr = explode(",", $finalString);
		if (strpos($dateRange, 'to') > 0) {
			$dateArray	   = explode("to", $dateRange);
			$fromDate		= $dateArray[0];
			$toDate		  = $dateArray[1];
			$appendDateQuery = " AND DATE(entryTime)>='" . $fromDate . "' AND DATE(entryTime)<='" . $toDate . "'";
		} else {
			$fromDate		= $dateRange;
			$appendDateQuery = " AND DATE(entryTime)='" . $fromDate . "'";
		}
		$nestedAppendDateQuery = " AND DATE(entryTime)<'" . $fromDate . "'";
		if ($countryString) {
			$appendDateQuery .= " AND country IN('" . $countryString . "')";
			$nestedAppendDateQuery .= " AND country IN('" . $countryString . "')";
		}
		if ($cityString) {
			$appendDateQuery .= " AND city IN('" . $cityString . "')";
			$nestedAppendDateQuery .= " AND city IN('" . $cityString . "')";
		}
		if (!$platform || $platform != 'All') {
			if ($platform == 'Web') {
				$appendDateQuery .= " AND isMobileWeb='No'";
				$nestedAppendDateQuery .= " AND isMobileWeb='No'";
			} else if ($platform == 'Apps') {
				$appendDateQuery .= " AND isMobileWeb='Yes'";
				$nestedAppendDateQuery .= " AND isMobileWeb='Yes'";
			}
		}
		$domainArr = $stringArr;
		for ($ref = 0; $ref < count($domainArr); $ref++) {
			$keyword			 = $domainArr[$ref];
			$sql	=	"	SELECT 
								DISTINCT(userID) AS disuser 
							FROM " 
								. DB_PREFIX . "visitor_info_log 
							WHERE 
								`userType`='user' 
								AND 
									`pageCount`>0
								AND 
									searchEngineName!='' 
								AND 
									searchKeyWord='" . $keyword . "' 
								AND
									userID>0";
			$sql .= $nestedAppendDateQuery;
			$resNotInString = $this->ObjDatabase->readValuesObject($sql);
			$rowCount	   = $resNotInString->num_rows;
			for ($i = 0; $i < $rowCount; $i++) {
				$resultSet	= $resNotInString->fetch_array(MYSQL_ASSOC);
				$singleUserID = $singleUserID . "'" . $resultSet['disuser'] . "',";
				unset($resultSet);
			}
			$resNotInString->free();
			if ($rowCount > 0) {
				$finalNotInString = substr($singleUserID, 0, -1);
			}
			//DISTINCT IP ADDRESS												
			$sql	=	"	SELECT 
								DISTINCT(visitorCookieID) AS disip 
							FROM 
								" . DB_PREFIX . "visitor_info_log 
							WHERE 
								`userType`='guest' 
								AND 
									`pageCount`>0
								AND
									searchEngineName!='' 
								AND 
									searchKeyWord='" . $keyword . "' 
								AND 
									userID=''";
			$sql .= $nestedAppendDateQuery;
			$resNotInStringOfIp = $this->ObjDatabase->readValuesObject($sql);
			$rowCountIp		 = $resNotInStringOfIp->num_rows;
			for ($ip = 0; $ip < $rowCountIp; $ip++) {
				$resultSet	   = $resNotInStringOfIp->fetch_array(MYSQL_ASSOC);
				$singleIPAddress = $singleIPAddress . "'" . $resultSet['disip'] . "',";
				unset($resultSet);
			}
			if ($rowCountIp) {
				$finalNotInStringIP = substr($singleIPAddress, 0, -1);
			}
			//FETCHING OF NOT IN/IN STRING ENDS HERE				
			//FETCHING OF NEW VISIORS 
			$sql	=	"	SELECT
								COUNT(DISTINCT(userID)) AS newuserIdCount
							FROM 
								" . DB_PREFIX . "visitor_info_log
							WHERE
								`userType`='user' 
								AND 
									`pageCount`>0 				
								AND 
									searchEngineName!=''
								AND 
									searchKeyWord='" . $keyword . "' 
								AND 
									userID>0 ";
			$sql .= $appendDateQuery;
			if ($rowCount > 0) {
				$sql .= " AND userID NOT IN(" . $finalNotInString . ")";
			}
			$newCountArr			 = $this->ObjDatabase->readValue($sql); //New Visitor Based On User ID	
			$sql	="	SELECT 
							COUNT(DISTINCT(visitorCookieID)) AS newIpCount 
						FROM 
							" . DB_PREFIX . "visitor_info_log 
						WHERE 
							`userType`='guest' 
							AND 
								`pageCount`>0 				
							AND 
								searchEngineName!='' 
							AND 
								searchKeyWord='" . $keyword . "' 
							AND 
								userID=''";
			$sqlSelectNewAttributeIp .= $appendDateQuery;
			if ($rowCountIp > 0) {
				$sqlSelectNewAttributeIp .= " AND visitorCookieID NOT IN(" . $finalNotInStringIP . ")";
			}
			$newCountIPArr						  = $this->ObjDatabase->readValue($sqlSelectNewAttributeIp); //New Visitor Based On User ID
			$allTrafficdetailArr[$ref]['newvisits'] = $newCountArr['newuserIdCount'] + $newCountIPArr['newIpCount'];
			unset($newCountArr);
			unset($newCountIPArr);
			//FETCHING OF DISTINCT VISITORS
			$sql	=	"	SELECT 
								COUNT(DISTINCT(userID)) AS uniqueuser 
							FROM 
								" . DB_PREFIX . "visitor_info_log 
							WHERE
								`userType`='user' 
								AND 
									`pageCount`>0				
								AND 
									searchEngineName!='' 
								AND 
									searchKeyWord='" . $keyword . "' 
								AND 
									userID>0";
			$sql .= $appendDateQuery;
			$uniqArrUser	   = $this->ObjDatabase->readValue($sql);
			$sql	=	"	SELECT 
								COUNT(DISTINCT(visitorCookieID)) AS uniqueIP 
							FROM
								" . DB_PREFIX . "visitor_info_log 
							WHERE 
								`userType`='guest' 
								AND 
									`pageCount`>0 
								AND 
									searchEngineName!='' 
								AND 
									searchKeyWord='" . $keyword . "' 
								AND 
									userID=''";
			$sql .= $appendDateQuery;
			$uniqueArrIP							   = $this->ObjDatabase->readValue($sql);
			$allTrafficdetailArr[$ref]['uniquevisits'] = $uniqArrUser['uniqueuser'] + $uniqueArrIP['uniqueIP'];
			unset($uniqArrUser);
			unset($uniqueArrIP);
			$allTrafficdetailArr[$ref]['retvisits'] = $allTrafficdetailArr[$ref]['uniquevisits'] - $allTrafficdetailArr[$ref]['newvisits'];
		}
		return $allTrafficdetailArr;
	}
	
	//For setting the visitores language
	//@usage => frondend/language change
	public function setVisitorLanguage($LanguageID, $visitorID)
	{
		if($visitorID >0)
		{
			$sqlUpdate = "update " . DB_PREFIX . "visitor_info_log set languageID=" . $LanguageID . " WHERE 
			visitorID =" . $visitorID." limit 1";
			$resUpdate = $this->ObjDatabase->setQuery($sqlUpdate);
		}
	}
	
	//FUNCTION TO FETCH VISITORS LAST VISITED URL 
	public function getMaxURL($visitorID)
	{
		if($visitorID>0){
			$sql	=	"	SELECT
								currentUrl AS currentURL 
							FROM ".DB_PREFIX."visitor_url_log
							WHERE
								visitorID='".$visitorID."' 
							ORDER BY urlID 
								DESC LIMIT 0,1";			
			$resMaxURL	=	$this->ObjDatabase->readValue($sql);
		}
		return $resMaxURL['currentURL'];
	}
	//FUNCTION TO FETCH BROWSERS NAMES FROM DATABASE
	
	public function getDBBrowserNames($fromDate, $toDate, $cityString = '', $countryList = '', $platform = '')
	{
		$sql	=	"	SELECT 
							DISTINCT
								(
									(
										CASE 
											WHEN 
												(SUBSTRING(browserName FROM 1 FOR (LOCATE(' ',browserName)) ))=''  
											THEN browserName
											WHEN 
												(SUBSTRING(browserName FROM 1 FOR (LOCATE(' ',browserName)) ))!='' 
											THEN (SUBSTRING(browserName FROM 1 FOR (LOCATE(' ',browserName)) ))
										END
									)
								)
									browser 
						FROM 
							".DB_PREFIX."visitor_info_log 
						WHERE 
							( `userType`='user' OR `userType`='guest') 
							AND 
								`pageCount`>0 
							AND 
								referrerType!='Crawlers' 
							AND 
								browserName!=''";
		if ($cityString) {
			$sqlSelectBounceDetails .= " AND city IN('" . $cityString . "')";
		}
		if ($countryList) {
			$sqlSelectBounceDetails .= " AND country IN('" . $countryList . "')";
		}
		if ($fromDate && !$toDate) {
			$sqlSelectBounceDetails .= " AND DATE(entryTime)='" . $fromDate . "'";
		} else {
			$sqlSelectBounceDetails .= " AND DATE(entryTime)>='" . $fromDate . "' AND DATE(entryTime)<='" . $toDate . "'";
		}
		if (!$platform || $platform != 'All') {
			if ($platform == 'Web') {
				$sqlSelectBounceDetails .= " AND isMobileWeb='No'";
			} else if ($platform == 'Apps') {
				$sqlSelectBounceDetails .= " AND isMobileWeb='Yes'";
			}
		}
		$resDBBrowsers = $this->ObjDatabase->readValuesObject($sql);
		$countOfDb	 = $resDBBrowsers->num_rows;
		for ($b = 0; $b < $countOfDb; $b++) {
			$resultSet	  = $resDBBrowsers->fetch_array(MYSQL_ASSOC);
			$browserArr[$b] = $resultSet['browser'];
		}
		$resDBBrowsers->free();
		unset($resultSet);
		return $browserArr;
	}
	
	//FUNCTION TO GET LAST EXECUTED CRONE TIME
	public function getLastCronExecutedValue()
	{
		$sql	=	"	SELECT 
							executionTime AS lasttym 
						FROM 
							".DB_PREFIX. "crone_execution_details 
						ORDER BY 
							croneID 
							DESC LIMIT 0,1";
		$resLastCronXecutedValue	=	$this->ObjDatabase->readValue($sql);
		$lastExecutedTime			=	$resLastCronXecutedValue['lasttym'];
		return $lastExecutedTime;
	}
	
	//FUNCTION TO FETCH NUMBER OF PROCESSED ROWS IN URL TABLE
	public function rowsCountToDel()
	{
		$sql	=	"	SELECT 
							COUNT(urlID) AS rowscount 
						FROM 
							".DB_PREFIX . "visitor_url_log 
						WHERE 
							urlID<=
								(
									SELECT 
										MAX(lastAffectedID) 
									FROM 
										".DB_PREFIX ."crone_execution_details
								)";
		$resRowCount		= $this->ObjDatabase->readValue($sql);
		$rowCount		   = $resRowCount['rowscount'];
		return $rowCount;
	}
	//FUNCTION TO DELETE PROCESSED URLS FROM URL TABLE
	
	public function deleteUnwantedRows()
	{
		$sqlDeleteunwantedRows = "DELETE FROM " . DB_PREFIX . "visitor_url_log WHERE urlID<=(SELECT MAX(lastAffectedID) FROM " . DB_PREFIX . "crone_execution_details)";
		$this->ObjDatabase->setQuery($sqlDeleteunwantedRows);
		return true;
	}
  
	//FUNCTION TO FETCH CURRENT URLS AND DERIVE NAME OF THE PAGE VISITED
	public function getCurrentUrl($httpUrl,$httpsURL,$refrrer = '', $checkDirect = '')
	{		
		$pageURL= (@$_SERVER["HTTPS"] == "on") ? "https://" : "http://";
		$pageURL .= $_SERVER["SERVER_NAME"] . $_SERVER["REQUEST_URI"];
	   	$pageURL = rtrim($pageURL, "/") . "/";	
		$httpURL	 = rtrim($httpUrl,"/")."/";
	  	$httpsUrl	= rtrim($httpsURL,"/")."/";
		$position	=	strpos($pageURL,$httpURL);
		$positionType	=	gettype($position);
		if ((strpos($pageURL,$httpURL)== 0)&& is_int($positionType)) {
					
			$pageVisited = str_replace($httpURL, '', $pageURL);
		} 
		else if ((strpos($pageURL,$httpsUrl)== 0)) {
			$pageVisited = str_replace($httpsUrl, '', $pageURL);
		} 
		else {		
			$pageVisited = $pageURL;
		}		
		return $pageVisited;
	}	
	
	public function getCurrentReferrer($httpUrl,$httpsURL, $checkDirect = '',$sslEnable=0)
	{
		$httpReferer	=	(isset($_SERVER['HTTP_REFERER'])) ? $_SERVER['HTTP_REFERER'] : '';
		if($httpReferer)
		{
			$httpReferer	=	rtrim($httpReferer,"/")."/";
		}		
		$httpURL	 	=	rtrim($httpUrl,"/")."/";
	  	$httpsUrl		= 	rtrim($httpsURL,"/")."/";
		$isIframe		=	strpos($httpReferer,'/widget/ajaxWidget/');	
		$iframeType		=	gettype($isIframe);		
		if($sslEnable==1){$settingsSiteUrl	=	$httpsURL;}				
		else{$settingsSiteUrl	=	$httpURL;}		
		if ($httpReferer && $httpReferer != '') {			
			if ($checkDirect == 1) {
				if ($httpsURL) {
					$httpsPos = strpos($httpReferer, $httpsURL);
				}
				if ($httpUrl) {
					$httpPos = strpos($httpReferer, $httpUrl);
				}
				$httpType  = gettype($httpPos);
				$httpsType = gettype($httpsPos);
				if ((($httpType == integer && $httpPos == 0) || ($httpsType == integer && $httpsPos == 0))&&!$isIframe) {
					$referrer = "direct";
				}
				else if($isIframe>0)
				{
					$referrer='';
				}
				else {
					$referrer = $httpReferer;
				}
			} else {
											
				if((strpos($httpReferer,"https")==0)&&(gettype(strpos($httpReferer,"https"))=='integer'))
				{					
					$settingsSiteUrl=$httpsURL;
				}
				else
				{					
					$settingsSiteUrl=$httpURL;
				}				
				$referrer = str_replace($settingsSiteUrl, '', $httpReferer);
			}
		} else {
			$referrer = "";
		}			
		return $referrer;
	}
	
	public function pageEachUrl($nameOfController)
	{
		$sqlSelectPageName = "SELECT pageName FROM " . DB_PREFIX . "page_name WHERE pageKeyword='" . $nameOfController . "'";
		$resultSet		 = $this->ObjDatabase->readValue($sqlSelectPageName);
		if (!$resultSet['pageName'] || $resultSet['pageName'] == '') {
			return $nameOfController;
		} else {
			return $resultSet['pageName'];
		}
	}
	
	//Function for gettinf the user agent of unknown os and browser
	//@usage => for updating through api by admin
	public function getunknownBroswerAndOs($limitFrom = 0, $limitTo = "")
	{
		if ($limitTo) {
			$sql .= " SELECT SQL_CALC_FOUND_ROWS ";
		} else {
			$sql .= " SELECT ";
		}
		$sql .= "	DISTINCT(userAgent) 
									FROM 
										" . DB_PREFIX . "visitor_info_log 
									WHERE 
										`pageCount`>0 
									AND 
										referrerType!='Crawlers'
		 							AND 
										(browserName='' OR operatingSystem='' OR operatingSystem='unknown')";
		//IF PAGINATION REQUIRED	
		if ($limitTo) {
			$sql .= " LIMIT  " . $limitFrom . "," . $limitTo . "";
		}
		$resultSet = $this->ObjDatabase->readValues($sql);
		return $resultSet;
	}
	
	//function for update the browser and os through API
	public function updateBroswerAndOs($pattern, $browser, $Os)
	{
		$sql	=	"	UPDATE
							" . DB_PREFIX . "visitor_info_log 
						SET 
							browserName='" . $browser . "',
							operatingSystem='" . $Os . "' 
						WHERE
							userAgent ='" . $pattern . "'";
		$resUpdate = $this->ObjDatabase->setQuery($sql);
	}
	
	//Function for getting the city and country tracking failed ips
	//@usage => updating from API by admin
	public function getUntrackedIps($limitFrom,$limitTo)
	{
		if ($limitTo) {
			$sql .= " SELECT SQL_CALC_FOUND_ROWS ";
		} else {
			$sql .= " SELECT ";
		}
		$sql.=	"		DISTINCT(remoteAddress) 
					FROM 
						" . DB_PREFIX . "visitor_info_log 
					WHERE 
						`pageCount`>0 
					AND 
						referrerType!='Crawlers'
		 			AND
						(city='' OR country='' OR city='zOthers')";
		//IF PAGINATION REQUIRED	
		if ($limitTo) {
			$sql .= " LIMIT  " . $limitFrom . "," . $limitTo . "";
		}
		$resultSet = $this->ObjDatabase->readValues($sql);
		return $resultSet;
	}
	
	//function for update the city and country through API
	public function updateIpRecords($ip, $city, $country)
	{
		$sqlUpdate	=	"	UPDATE 
								" . DB_PREFIX . "visitor_info_log 
							SET 
								city='" . $city . "',
								country='" . $country . "' 
							WHERE 
								remoteAddress ='" . $ip . "' 
								AND 
									pageCount>0 
								AND 
									referrerType!='Crawlers'";
		$resUpdate = $this->ObjDatabase->setQuery($sqlUpdate);
	}
	
	public function fetchAffiliateVisitors()
	{
		$sql	=	"	SELECT 
							visInfLog.visitorID,
							visInfLog.remoteAddress,
							visInfLog.httpReferer,
							visInfLog.userAgent 
						FROM 
							".DB_PREFIX."visitor_info_log  visInfLog 
						LEFT JOIN ".DB_PREFIX."affiliate_visits affVis 
							ON 
								visInfLog.visitorID=affVis.visitorID 
						WHERE 
							visInfLog.city='' AND visInfLog.country=''";
	   // echo $sqlSelctAffiliateVisitorDetails;
		$resAffiliateVisitor = $this->ObjDatabase->readValues($sql);
		return $resAffiliateVisitor;
	}
	
	public function getPageVisitCount($visitorID)
	{
		if($visitorID > 0){
			$sql	=	"	SELECT 
								COUNT(urlID) AS vistedcount 
							FROM 
								" . DB_PREFIX . "visitor_url_log 
							WHERE
								visitorID='" . $visitorID . "'
							"
								;
			$resultSet		   = $this->ObjDatabase->readValue($sql);
			$countOfPagesVisited = $resultSet['vistedcount'];
		}
		return $countOfPagesVisited;		
	}
	
	public function updateEntryPage($currentURL, $visitorID, $refType = '', $refDetails = '',$nameOfHost)
	{
		if($visitorID >0){
			$sql	="	UPDATE 
							".DB_PREFIX."visitor_info_log 
						SET 
							entryPage='" . $currentURL . "'";
			if ($refType) {
		   		$sql .= ",referrerType='" . $refType . "'";
			}
			if ($refDetails) {
				$sql .= ",referrerDetails='" . $refDetails . "'";
			}
			if($nameOfHost)
			{
				$sql.=",referrerWebSite='".$nameOfHost."'";
			}
			$sql .= " WHERE 
						visitorID='" . $visitorID . "'
					LIMIT 1";			
			$this->ObjDatabase->setQuery($sql);
			$sql	=	"	UPDATE	
								".DB_PREFIX."visitor_url_log 
							SET 
								currentUrl='" . $currentURL . "' 
							WHERE
								visitorID='" . $visitorID . "'
							LIMIT 1";			
			$this->ObjDatabase->setQuery($sql);
		}
		return true;
	}
	
	
	//FUNCTION TO LIST ALL SEARCH ENGINES BASED ON KEYWORDS
	public function listSearchEngineKeywords($limitFrom, $limitTo, $keyValue, $fromDate, $toDate, $countryQueryString, $cityQueryString, $platform)
	{
		if ($limitTo) {
			$paginationText = " SQL_CALC_FOUND_ROWS ";
		}
		$sql	=	"	SELECT " . $paginationText . "
							searchEngineName AS searchengine,
							COUNT(visInfLog.visitorID) AS totalvisits,
							ROUND(SUM(visInfLog.pageCount)/COUNT(visInfLog.visitorID)) AS avgpagevisits,
							IF
								(
									AVG(TIMESTAMPDIFF(SECOND,visInfLog.entryTime,visInfLog.exitTime))>0,SEC_TO_TIME(avg(TIMESTAMPDIFF(SECOND,visInfLog.entryTime,visInfLog.exitTime))),'00:00:00'
								)AS averagevisitduration,
							SUM(doneSignUp) AS totalregistration,
							SUM(doneSubscribe) AS totalsubscription,
							SUM(orderPlaced) AS totalorderplaced,
							SUM(orderAmount) AS totalrevenue
						FROM 
							".DB_PREFIX."visitor_info_log visInfLog 
						WHERE 
							visInfLog.pageCount>0 
							AND 
								(visInfLog.userType='user' OR visInfLog.userType='guest') 
							AND 
								searchKeyWord='" . $keyValue . "' 
							AND 
								`pageCount`>0 
							AND 
								referrerType!='Crawlers'";
		if ($fromDate && $toDate) {
			$sql .= "AND DATE(entryTime)>='" . $fromDate . "' ";
		} else {
			$sql .= "AND DATE(entryTime)='" . $fromDate . "' ";
		}
		if ($toDate) {
			$sql .= " AND DATE(entryTime)<='" . $toDate . "'";
		}
		if ($cityQueryString) {
			$sql .= " AND city IN('" . $countryQueryString . "')";
		}
		if ($countryQueryString) {
			$sql .= " AND country IN('" . $countryQueryString . "') ";
		}
		if (!$platform || $platform != 'All') {
			if ($platform == 'Web') {
				$sql .= " AND isMobileWeb='No'";
			} else if ($platform == 'Apps') {
				$sql .= " AND isMobileWeb='Yes'";
			}
		}
		$sql .= " GROUP BY searchengine";

		if ($limitTo) {
			$sql .= " LIMIT  " . $limitFrom . "," . $limitTo . " ";
		}
		$resAllSearchEngines = $this->ObjDatabase->readValues($sql);
		return $resAllSearchEngines;
	}
	//FUNCTION TO GET VISIT ATTRIBUTES OF KEYWORD DISTRIBUTION IN SEARCH ENGINE
	
	public function getkeyWordeDetailsVisitAttributes($dateRange, $finalString, $countryString, $cityString, $platform, $keyvalue)
	{
		$stringArr = explode(",", $finalString);
		if (strpos($dateRange, 'to') > 0) {
			$dateArray	   = explode("to", $dateRange);
			$fromDate		= $dateArray[0];
			$toDate		  = $dateArray[1];
			$appendDateQuery = " AND DATE(entryTime)>='" . $fromDate . "' AND DATE(entryTime)<='" . $toDate . "'";
		} else {
			$fromDate		= $dateRange;
			$appendDateQuery = " AND DATE(entryTime)='" . $fromDate . "'";
		}
		$nestedAppendDateQuery = " AND DATE(entryTime)<'" . $fromDate . "'";
		if ($countryString) {
			$appendDateQuery .= " AND country IN('" . $countryString . "')";
			$nestedAppendDateQuery .= " AND country IN('" . $countryString . "')";
		}
		if ($cityString) {
			$appendDateQuery .= " AND city IN('" . $cityString . "')";
			$nestedAppendDateQuery .= " AND city IN('" . $cityString . "')";
		}
		if (!$platform || $platform != 'All') {
			if ($platform == 'Web') {
				$appendDateQuery .= " AND isMobileWeb='No'";
				$nestedAppendDateQuery .= " AND isMobileWeb='No'";
			} else if ($platform == 'Apps') {
				$appendDateQuery .= " AND isMobileWeb='Yes'";
				$nestedAppendDateQuery .= " AND isMobileWeb='Yes'";
			}
		}
		$domainArr = $stringArr;
		for ($ref = 0; $ref < count($domainArr); $ref++) {
			$keyword			 = $domainArr[$ref];
			$sql	=	"	SELECT 
								DISTINCT(userID) AS disuser 
							FROM 
								" . DB_PREFIX . "visitor_info_log 
							WHERE 
								`userType`='user' 
								AND 
									`pageCount`>0 
									AND
										searchEngineName='" . $keyword . "' 
									AND 
										searchKeyWord='" . $keyvalue . "' 
									AND 
										userID>0";
			$sql .= $nestedAppendDateQuery;
			$resNotInString = $this->ObjDatabase->readValuesObject($sql);
			$rowCount	   = $resNotInString->num_rows;
			for ($i = 0; $i < $rowCount; $i++) {
				$resultSet	= $resNotInString->fetch_array(MYSQL_ASSOC);
				$singleUserID = $singleUserID . "'" . $resultSet['disuser'] . "',";
				unset($resultSet);
			}
			$resNotInString->free();
			if ($rowCount > 0) {
				$finalNotInString = substr($singleUserID, 0, -1);
			}
			//DISTINCT IP ADDRESS												
			$sql	=	"	SELECT 
								DISTINCT(visitorCookieID) AS disip 
							FROM 
								" . DB_PREFIX . "visitor_info_log 
							WHERE 
								`userType`='guest' 
								AND 
									`pageCount`>0
								AND 
									searchEngineName='" . $keyword . "' 
								AND 
									searchKeyWord='" . $keyvalue . "' 
								AND 
									userID=''";
			$sql .= $nestedAppendDateQuery;
			$resNotInStringOfIp = $this->ObjDatabase->readValuesObject($sql);
			$rowCountIp		 = $resNotInStringOfIp->num_rows;
			for ($ip = 0; $ip < $rowCountIp; $ip++) {
				$resultSet	   = $resNotInStringOfIp->fetch_array(MYSQL_ASSOC);
				$singleIPAddress = $singleIPAddress . "'" . $resultSet['disip'] . "',";
				unset($resultSet);
			}
			if ($rowCountIp) {
				$finalNotInStringIP = substr($singleIPAddress, 0, -1);
			}
			//FETCHING OF NOT IN/IN STRING ENDS HERE				
			//FETCHING OF NEW VISIORS 
			$sql	=	"	SELECT
								COUNT(DISTINCT(userID)) AS newuserIdCount
							FROM 
								".DB_PREFIX."visitor_info_log
							WHERE
								`userType`='user' 
								AND 
									`pageCount`>0 				
								AND 
									searchEngineName='" . $keyword . "' 
								AND 
									searchKeyWord='" . $keyvalue . "' 
								AND 
									userID>0 ";
			$sql .= $appendDateQuery;
			if ($rowCount > 0) {
				$sql .= " AND userID NOT IN(" . $finalNotInString . ")";
			}
			$newCountArr			 = $this->ObjDatabase->readValue($sql); //New Visitor Based On User ID	
			$sql	=	"	SELECT 
								COUNT(DISTINCT(visitorCookieID)) AS newIpCount 
							FROM 
								" . DB_PREFIX . "visitor_info_log 
							WHERE 
								`userType`='guest' 
								AND 
									`pageCount`>0 
								AND 
									searchEngineName='" . $keyword . "' 
								AND 
									searchKeyWord='" . $keyvalue . "' 
								AND 
									userID=''";
			$sql .= $appendDateQuery;
			if ($rowCountIp > 0) {
				$sql .= " AND visitorCookieID NOT IN(" . $finalNotInStringIP . ")";
			}
			$newCountIPArr						  = $this->ObjDatabase->readValue($sql); //New Visitor Based On User ID
			$allTrafficdetailArr[$ref]['newvisits'] = $newCountArr['newuserIdCount'] + $newCountIPArr['newIpCount'];
			unset($newCountArr);
			unset($newCountIPArr);
			//FETCHING OF DISTINCT VISITORS
			$sql	=	"	SELECT 
								COUNT(DISTINCT(userID)) AS uniqueuser 
							FROM 
								" . DB_PREFIX . "visitor_info_log 
							WHERE
								`userType`='user' 
								AND 
									`pageCount`>0
								AND 
									searchEngineName='" . $keyword . "' 
								AND 
									searchKeyWord='" . $keyvalue . "'
								AND 
									userID>0";
			$sql .= $appendDateQuery;
			$uniqArrUser	   = $this->ObjDatabase->readValue($sql);
			$sql	=	"	SELECT 
								COUNT(DISTINCT(visitorCookieID)) AS uniqueIP 
							FROM 
								" . DB_PREFIX . "visitor_info_log 
							WHERE 
								`userType`='guest' 
								AND 
									`pageCount`>0 
								AND 
									searchEngineName='" . $keyword . "'
								AND 
									searchKeyWord='" . $keyvalue . "' 
								AND 
									userID=''";
			$sql .= $appendDateQuery;
			$uniqueArrIP							   = $this->ObjDatabase->readValue($sql);
			$allTrafficdetailArr[$ref]['uniquevisits'] = $uniqArrUser['uniqueuser'] + $uniqueArrIP['uniqueIP'];
			unset($uniqArrUser);
			unset($uniqueArrIP);
			$allTrafficdetailArr[$ref]['retvisits'] = $allTrafficdetailArr[$ref]['uniquevisits'] - $allTrafficdetailArr[$ref]['newvisits'];
		}
		return $allTrafficdetailArr;
	}
	
	//function to fetch the top users nominees from Log List
	public function getNomineesForTopUsers($searchFromDate,$searchToDate)
	{
		//Finding Search Affected Hours	Starts From Here
		if(!$searchToDate||$searchToDate==date("Y-m-d"))
		{
			$fromDate			=	$searchFromDate." 00:00:00";
			if(date("Y-m-d",strtotime($fromDate))==date("Y-m-d"))
			{				
				$todate				=	$searchFromDate.date("H:i:s");
			}
			else
			{
				$todate				=	$searchFromDate." 23:59:59";
			}
			$searchAffectecdHours	=	round(((strtotime($todate)-	strtotime($fromDate))/60)*0.0166667,3);				
		}
		else
		{				
			if(date("Y-m-d",strtotime($searchToDate))==date("Y-m-d"))
			{				
				$todate					=	$searchToDate.date("H:i:s");
			}
			else
			{
				$todate					=	$searchToDate." 23:59:59";
			}
			$fromDate				=	$searchFromDate."00:00:00";
			$searchAffectecdHours	=	round(((strtotime($todate)-	strtotime($fromDate))/60)*0.0166667,3);	
		}		
		//Finding Of Search Affected hours Ends Here
		//Query For Finding the Nominees For Top Beneficial Users		
		$sqlSelectNominees	=	"SELECT vl.userID as userIdentification,SUM(pageCount) 
		as totalpagecount,SUM(TIMESTAMPDIFF(MINUTE,loginTime,logoutTime)) 
		as tottaltymspent,COUNT(*) as totalvisits,(SELECT COUNT(masterOrderID) 
		FROM ".DB_PREFIX."order_masters o WHERE o.userID=vl.userID AND 
		orderCreatedDate<=(SELECT MAX(executionTime) FROM 
		".DB_PREFIX."crone_execution_details) AND orderType!='coupon' ";
		if($searchFromDate&&!$searchToDate)
		{
			$sqlSelectNominees.=" AND DATE(orderCreatedDate)='".$searchFromDate."'";
		}
		else
		{
			$sqlSelectNominees.=" AND DATE(orderCreatedDate) >='".$searchFromDate."' 
			AND DATE(orderCreatedDate)<='".$searchToDate."'";
		}
		$sqlSelectNominees.=" AND (orderStatus='Process' or
		orderStatus='Completed')) as totordersplaced,
		CONCAT_WS(' ',u.userFirstName,u.userLastName) as callingname,u.*  FROM "
		.DB_PREFIX."visitor_info_log vl LEFT JOIN ".DB_PREFIX."users u ON vl.userID=
		u.userID WHERE pageCount>0 AND userType='user' AND referrerType!='Crawlers'";
		if($searchFromDate&&!$searchToDate)
		{
			$sqlSelectNominees.=" AND DATE(loginTime)='".$searchFromDate."'";
		}
		else
		{
		$sqlSelectNominees.=" AND DATE(loginTime)>='".$searchFromDate."' AND DATE(loginTime)<='".$searchToDate."'";
		}
		$sqlSelectNominees.="GROUP BY vl.userID";
		//Top Beneficial Nominees Query Ends Here		
		$resNomineesSet				=	$this->ObjDatabase->readValuesObject($sqlSelectNominees);
		$nomineesCount				=	$resNomineesSet->num_rows;
		$topBenRankArray			=	array();
		for($i=0;$i<$nomineesCount;$i++)
		{
			$resultSet				=	$resNomineesSet->fetch_array(MYSQL_ASSOC);	
			$userID					=	$resultSet['userIdentification'];			
			//Fetching The Details Of Users First Visit To Our Site
			$sqlSelectTrafficSource	=	"SELECT httpReferer,searchKeyWord,searchEngineName,
			referrerType,referrerDetails,referrerWebSite FROM ".DB_PREFIX."visitor_info_log
			WHERE userID='".$userID."' AND userType='user' AND referrerType!='Crawlers' 
			ORDER BY visitorID ASC LIMIT 0,1";
			$resSelectTrafficDet	=	$this->ObjDatabase->readValue($sqlSelectTrafficSource);
			$httpReferrer			=	$resSelectTrafficDet['httpReferer'];
			$searchEngineName		=	$resSelectTrafficDet['searchEngineName'];
			$searchedparameter		=	$resSelectTrafficDet['searchKeyWord'];

			$referrerType			=	$resSelectTrafficDet['referrerType'];
			$referrerDetails		=	$resSelectTrafficDet['referrerDetails'];
			$referrerWebsite		=	$resSelectTrafficDet['referrerWebSite'];
			if($httpReferrer!='' && $searchEngineName!=''&&$searchedparameter!='')
			{
				$trafficDetails		=	$searchEngineName;
			}
			else if(($httpReferrer==''||$httpReferrer=='direct')&&!$referrerType&&!$referrerDetails)
			{
				$trafficDetails		=	"Direct Traffic";
			}
			else if($referrerWebsite!='' &&$httpReferrer!='direct')
			{
				$trafficDetails		=	$referrerWebsite;
			}
			else
			{	
				$trafficDetails		=	ucfirst($referrerType)." ".ucfirst($referrerDetails);
			}
			//Query For Selecting Total Amount Spend For Buying deals Within the specified date range
			$sqlSelectSearchTotalAmount	=	"SELECT SUM(convertedMasterOrderSubtotal) as
			totamountorderd FROM ".DB_PREFIX."order_masters WHERE userID='".$userID."' AND
			(orderStatus='Process' or orderStatus='Completed') 
			AND orderCreatedDate<=(SELECT MAX(executionTime) FROM ".DB_PREFIX.
			"crone_execution_details) AND orderType!='coupon'";
			$resTotalAmountWithNoCondition	=	$this->ObjDatabase->readValue($sqlSelectSearchTotalAmount);

			//Total Amount Placed With No Date Range Specified
			$totalAmountOrderdByUserInWhole	=	$resTotalAmountWithNoCondition['totamountorderd']!=''?$resTotalAmountWithNoCondition['totamountorderd']:0;
			if($searchFromDate&&!$searchToDate)
			{
				$sqlSelectSearchTotalAmount.="AND DATE(orderCreatedDate)='".
				$searchFromDate."'";
			}
			else
			{
				$sqlSelectSearchTotalAmount.=" AND DATE(orderCreatedDate)>='".
				$searchFromDate."' AND DATE(orderCreatedDate)<='".$searchToDate."'";
			}
			$resSubtotal	=	$this->ObjDatabase->readValue($sqlSelectSearchTotalAmount);
			//Total Amount Fetching query ends here
			//Fetching The Details of Each Users visits to the site ends here
			/*=========================================================Total Visits===================================================================*/
			$sqlSelectTotVisitDet	=	"SELECT COUNT(*) as totalvisitstillnow FROM ".
			DB_PREFIX."visitor_info_log WHERE userID='".$userID."' AND pageCount>0";
			$resVisititTotals		=	$this->ObjDatabase->readValue($sqlSelectTotVisitDet);	
			/*=====================================================Total Visits==================================================================*/
			/*==============================================Search Span Order Placed Visits======================================================*/
			$sqlSelectSearchSpanOrderPlacedVisits	=	"SELECT SUM(orderPlaced) as
			countoforderplacedvisit FROM ".DB_PREFIX."visitor_info_log WHERE userID='".
			$userID."' AND pageCount>0 AND lastorderplacedtime<=(SELECT MAX(executionTime)
			FROM ".DB_PREFIX."crone_execution_details)";
			if($searchFromDate&&!$searchToDate)
			{
				
				$sqlSelectSearchSpanOrderPlacedVisits.=" AND DATE(loginTime)='".$searchFromDate."'";
			}
			else
			{
				$sqlSelectSearchSpanOrderPlacedVisits.=" AND DATE(loginTime)>='".$searchFromDate."' AND DATE(loginTime)<='".$searchToDate."'";
			}						
			$resOrderPlacedVisits	=	$this->ObjDatabase->readValue($sqlSelectSearchSpanOrderPlacedVisits);
			/*==============================================Search Span Order Placed Visits Ends Here=============================================*/
			$sqlSelectTotOrders		=	"SELECT COUNT(*) as totalordersplacednow FROM ".
			DB_PREFIX."order_masters WHERE userID='".$userID."' AND (
			orderStatus='Process' or orderStatus='Completed') AND 
			orderCreatedDate<=(SELECT MAX(executionTime) FROM ".DB_PREFIX.
			"crone_execution_details) AND orderType!='coupon'";	
			$resTotOrders			=	$this->ObjDatabase->readValue($sqlSelectTotOrders);							
			$topBenRankArray[$userID]['userID']					=	$userID;
			$topBenRankArray[$userID]['userregistraionname']	=	$resultSet['callingname'];
			$topBenRankArray[$userID]['useremail']				=	$resultSet['userEmail'];
			$topBenRankArray[$userID]['userRegistredDate']		=	$resultSet['userRegistredDate'];
			$topBenRankArray[$userID]['userPhone']				=	$resultSet['userPhone'];
			$topBenRankArray[$userID]['userStatus']				=	$resultSet['userStatus'];
			$topBenRankArray[$userID]['pageCount']				=	$resultSet['totalpagecount'];
			$topBenRankArray[$userID]['timespentinminutes']		=	$resultSet['tottaltymspent'];
			$topBenRankArray[$userID]['countoforderplacedvisits']=	$resOrderPlacedVisits['countoforderplacedvisit']!=''?$resOrderPlacedVisits['countoforderplacedvisit']:0;
			$topBenRankArray[$userID]['ordertotalamount']		=	$resSubtotal['totamountorderd']!=''?$resSubtotal['totamountorderd']:0;
			$topBenRankArray[$userID]['searchsapntotalvisits']	=	$resultSet['totalvisits']!=''?$resultSet['totalvisits']:0;
			$topBenRankArray[$userID]['totalorderplaced']		=	$resultSet['totordersplaced']!=''?$resultSet['totordersplaced']:0;	
			$topBenRankArray[$userID]['totalvisitstillnow']		=	$resVisititTotals['totalvisitstillnow']!=''?$resVisititTotals['totalvisitstillnow']:0;
			$topBenRankArray[$userID]['totordersplacedvisits']	=	$resVisititTotals['totalvisitsplacedorders']!=''?$resVisititTotals['totalvisitsplacedorders']:0;			
			$topBenRankArray[$userID]['totalorderamount']		=	$totalAmountOrderdByUserInWhole;
			$topBenRankArray[$userID]['totalordersplacednow']	=	$resTotOrders['totalordersplacednow']!=''?$resTotOrders['totalordersplacednow']:0;
			$topBenRankArray[$userID]['firsttraffictosite']		=	$trafficDetails;			
			//Building The Algorithm For Finding the top Beneficial Users							
			$orderRatio			=	($topBenRankArray[$userID]['totalorderplaced']>0&&$searchAffectecdHours)>0?(round(($topBenRankArray[$userID]['totalorderplaced']/$searchAffectecdHours),3)):0;					
			$amountRatio		=	($topBenRankArray[$userID]['ordertotalamount']>0&&$searchAffectecdHours>0)?(round(($topBenRankArray[$userID]['ordertotalamount']/$searchAffectecdHours),3)):0;			
			$visitRatio			=	($topBenRankArray[$userID]['searchsapntotalvisits']>0&&$searchAffectecdHours>0)?(round(($topBenRankArray[$userID]['searchsapntotalvisits']/$searchAffectecdHours),3)):0;				
			$conversionRatio	=	$resultSet['totalvisits']>0?round(($resOrderPlacedVisits['countoforderplacedvisit']/$resultSet['totalvisits']),3):0;
							
			$performanceRatio	=	$orderRatio+$amountRatio+$conversionRatio;
			$topBenRankArray[$userID]['totalweigtage']		=	$performanceRatio;		
			//Algorithm of Top beneficial User Ends Here
			
		}				
		return $topBenRankArray;
	}
	//Function to get the top busy users
	public function getNomineesForTopBusyUsers($searchFromDate,$searchToDate)
	{
		//Finding Search Affected Hours	Starts From Here
		if(!$searchToDate||$searchToDate==date("Y-m-d"))
		{
			$fromDate			=	$searchFromDate." 00:00:00";
			if(date("Y-m-d",strtotime($fromDate))==date("Y-m-d"))
			{				
				$todate				=	$searchFromDate.date("H:i:s");
			}
			else
			{
				$todate				=	$searchFromDate." 23:59:59";
			}
			$searchAffectecdHours	=	round(((strtotime($todate)-	strtotime($fromDate))/60)*0.0166667,3);				
		}
		else
		{			
			if(date("Y-m-d",strtotime($searchToDate))==date("Y-m-d"))
			{				
				$todate					=	$searchToDate.date("H:i:s");
			}
			else
			{
				$todate					=	$searchToDate." 23:59:59";
			}
			$fromDate				=	$searchFromDate."00:00:00";
			$searchAffectecdHours	=	round(((strtotime($todate)-	strtotime($fromDate))/60)*0.0166667,3);	
		}		
		$sql	=	"	SELECT 
							visInfLog.visitorID AS visitorid,
							SUM(visInfLog.pageCount) AS searchspanpagecount ,
							COUNT(*) AS visitcount,
							SUM(TIMESTAMPDIFF(SECOND,loginTime,logoutTime)) AS tottaltymspent,
							SUM(visInfLog.doneSubscribe) AS subscriptioncount,
							visInfLog.userID AS useridentification,
							CONCAT_WS(' ',usr.userFirstName,usr.userLastName) AS callingname,
							usr.*
						FROM 
							".DB_PREFIX."visitor_info_log visInfLog 
						LEFT JOIN 
							".DB_PREFIX."users usr 
								ON 
									visInfLog.userID=usr.userID
						WHERE 
							visInfLog.userID>0 
							AND 
								visInfLog.referrerType!='Crawlers' 
							AND 
								visInfLog.pageCount>0 
							AND 
								visInfLog.userType='user'";
		if($searchFromDate&&!$searchToDate)
		{
			$sql.=" AND DATE(loginTime)='".$searchFromDate."'";
			$refQuery					= " AND (DATE(LastActDate)='".$searchFromDate."' OR DATE(referalRegActiveDate)='".$searchFromDate."' )";
		}
		else
		{
		$sql.=" AND DATE(loginTime)>='".$searchFromDate."' AND DATE(loginTime)<='".$searchToDate."'";
		$refQuery					=	" AND ((DATE(LastActDate)>='".$searchFromDate."' AND DATE(LastActDate)<='".$searchToDate."') OR(DATE(referalRegActiveDate)>='".$searchFromDate."' AND DATE(referalRegActiveDate)<='".$searchToDate."'))";
		}
		
		$sql.="GROUP BY visInfLog.userID";	
			
		$resNomineesSet				=	$this->ObjDatabase->readValuesObject($sql);
		$nomineesCount				=	$resNomineesSet->num_rows;
		for($count=0;$count<$nomineesCount;$count++)
		{
			$resultSet				=	$resNomineesSet->fetch_array(MYSQL_ASSOC);
			$userID					=	$resultSet['useridentification'];
			//Fetching Of Referrer Details Start From Here
			$sqlSelectRefDetails	=	"SELECT SUM(referralAmount) as refcommission FROM ".DB_PREFIX."users_referrals WHERE referedBY='".$userID."' AND referralStatus='Active' AND LastActDate<=(SELECT MAX(executionTime) FROM ".DB_PREFIX."crone_execution_details)";
			$sqlTotrefDetailQuery	=	$sqlSelectRefDetails;						
			$referrarDetailsSet		=	$this->ObjDatabase->readValue($sqlSelectRefDetails);
			$refCommisionInSearchSpan=	$referrarDetailsSet['refcommission']!=''?$referrarDetailsSet['refcommission']:0;			
			$wholeRefrrarsDetails	=	$this->ObjDatabase->readValue($sqlTotrefDetailQuery);
			$totRefCommision		=	$wholeRefrrarsDetails['refcommission']!=''?$wholeRefrrarsDetails['refcommission']:0;
			$sqlSimpleRefCounts		=	"SELECT COUNT(referrerID) as referralcount FROM ".DB_PREFIX."users_referrals WHERE referedBY='".$userID."'AND referralStatus='Active' AND LastActDate<=(SELECT MAX(executionTime) FROM ".DB_PREFIX."crone_execution_details)";	
			$basicCountQuery		=	$sqlSimpleRefCounts;
			$sqlSimpleRefCounts.=	$refQuery;
			$referralCountdetails	=	$this->ObjDatabase->readValue($sqlSimpleRefCounts);	
			$searchSpanRefCount		=	$referralCountdetails['referralcount'];		
			$referralCountDeatilsWhole=	$this->ObjDatabase->readValue($basicCountQuery);	
			$wholeReferralCount		=	$referralCountDeatilsWhole['referralcount'];
			//Referrar Details Fetching Ends Here
			//First Entry Visit Deatils of Each Visitor
			$trafficDetails			=	$this->getVeryFirstEntryToDealSite($userID);			
			//First Entry Visit Details Of Each Visitor Ends Here			
			$sqlSelctTotals			=	"SELECT COUNT(*)as wholevisitcount FROM ".DB_PREFIX."visitor_info_log WHERE pageCount>0 AND userID='".$userID."'";
			$resTotals				=	$this->ObjDatabase->readValue($sqlSelctTotals);	
			$wholeVisitCount		=	$resTotals['wholevisitcount'];
			$searchSpanPageCount	=	$resultSet['searchspanpagecount'];
			$searchSpanTimeSpent	=	$resultSet['tottaltymspent'];//In Seconds
			$searchSpanVisitCount	=	$resultSet['visitcount'];
			$ssSubscribeVisitsCount	=	$resultSet['subscriptioncount'];
			$srchSpancommisionratio	=	($refCommisionInSearchSpan>0&&$searchAffectecdHours>0)?round(($refCommisionInSearchSpan/$searchAffectecdHours),3):0;
			$srchSpanrefCountratio	=	($searchSpanRefCount>0&&$searchAffectecdHours>0)?round(($searchSpanRefCount/$searchAffectecdHours),3):0;
			if($wholeReferralCount==$searchSpanRefCount&&$wholeReferralCount!=0)
			{
				$alivePercentage	=	100;//In Percentage
			}
			else if ($wholeReferralCount>0&&$searchSpanRefCount>0)
			{
				//$alivePercentage	=	(($wholeReferralCount-$searchSpanRefCount)/$wholeReferralCount)*100;//In Percentage
				$alivePercentage	=	round(($searchSpanRefCount/$wholeReferralCount)*100,3);//In Percentage
			}
			else
			{
				$alivePercentage	=	0;
			}					
			$pageCountPercentage	=	($searchSpanPageCount>0&&$searchAffectecdHours>0)?round(($searchSpanPageCount/$searchAffectecdHours),3):0;
			$visitCountPercentage	=	($searchSpanVisitCount>0&&$searchAffectecdHours>0)?round(($searchSpanVisitCount/$searchAffectecdHours),3):0;
			$pageVisitsratio		=	($searchSpanPageCount>0&&$searchSpanVisitCount>0)?round(($searchSpanPageCount/$searchSpanVisitCount),3):0;
			$totalWeitage			=	$srchSpancommisionratio+$srchSpanrefCountratio+$alivePercentage+$visitCountPercentage;
			$topBusyUserArray[$userID]['usercallingname']		=	$resultSet['callingname'];
			$topBusyUserArray[$userID]['useremail']				=	$resultSet['userEmail'];
			$topBusyUserArray[$userID]['userPhone']				=	$resultSet['userPhone'];
			$topBusyUserArray[$userID]['userStatus']			=	$resultSet['userStatus'];
			$topBusyUserArray[$userID]['firstentrytraffic']		=	$trafficDetails;
			$topBusyUserArray[$userID]['searchrefcommision']	=	$refCommisionInSearchSpan;
			$topBusyUserArray[$userID]['wholerefcommision']		=	$totRefCommision;
			$topBusyUserArray[$userID]['searchrefcount']		=	$searchSpanRefCount;
			$topBusyUserArray[$userID]['wholerefcount']			=	$wholeReferralCount;
			$topBusyUserArray[$userID]['alivepercentage']		=	$alivePercentage;
			$topBusyUserArray[$userID]['totalweitage']			=	$totalWeitage;
			$topBusyUserArray[$userID]['userRegistredDate']		=	$resultSet['userRegistredDate'];
			$topBusyUserArray[$userID]['searchsapntotalvisits']	=	$searchSpanVisitCount;
			$topBusyUserArray[$userID]['wholevisitcount']		=	$wholeVisitCount;
			$topBusyUserArray[$userID]['searchpagecount']		=	$searchSpanPageCount;			
		}
		return $topBusyUserArray;
			
	}
	//End Of the Function
	
	//function to get the users Very first entry to the site
	public function getVeryFirstEntryToDealSite($userID)
	{
		$sqlSelectTrafficSource	=	"SELECT httpReferer,searchKeyWord,searchEngineName,referrerType,referrerDetails,referrerWebSite FROM ".DB_PREFIX."visitor_info_log WHERE userID='".$userID."' AND userType='user' AND referrerType!='Crawlers' ORDER BY visitorID ASC LIMIT 0,1";
			$resSelectTrafficDet	=	$this->ObjDatabase->readValue($sqlSelectTrafficSource);
			$httpReferrer			=	$resSelectTrafficDet['httpReferer'];
			$searchEngineName		=	$resSelectTrafficDet['searchEngineName'];
			$searchedparameter		=	$resSelectTrafficDet['searchKeyWord'];
			$referrerType			=	$resSelectTrafficDet['referrerType'];
			$referrerDetails		=	$resSelectTrafficDet['referrerDetails'];
			$referrerWebsite		=	$resSelectTrafficDet['referrerWebSite'];
			if($httpReferrer!='' && $searchEngineName!=''&&$searchedparameter!='')
			{
				$trafficDetails		=	$searchEngineName;
			}
			else if(($httpReferrer==''||$httpReferrer=='direct')&&!$referrerType&&!$referrerDetails)
			{
				$trafficDetails		=	"Direct Traffic";
			}
			else if($referrerWebsite!='' &&$httpReferrer!='direct')
			{
				$trafficDetails		=	$referrerWebsite;
			}
			else
			{	
				$trafficDetails		=	ucfirst($referrerType)." ".ucfirst($referrerDetails);
				
			}
			return $trafficDetails;
	}
	
	public function getDistinctDealTypes($languageIDs=array())
	{
		$languageID 	= $languageIDs['Current'];
		$sql	=	"	SELECT 
							DISTINCT(dealTypeKey),dealTypeName 
						FROM 
							".DB_PREFIX."deal_types dealTyp 
						LEFT JOIN 
							".DB_PREFIX."deal_type_details as dealTypDet
								ON
									(
										dealTypDet.dealTypeID=dealTyp.dealTypeID AND 
							dealTypDet.languageID='".$languageID."'
									)
						GROUP BY dealTypeKey";
		return $this->ObjDatabase->readValues($sql);
	}
	
	public function getDistinctProduct($languageIDs=array())
	{
		$languageID 	= $languageIDs['Current'];
		$sqlSelect		= "	SELECT dealID,dealTitle 
							FROM ".DB_PREFIX."deal_details deaDet 
							where  
							deaDet.languageID='".$languageID."'
							group by dealID";
		return $this->ObjDatabase->readValues($sqlSelect);
	}
	
	public function getCartDetails($languageIDs,$limitFrom=0, $limitTo, $searchDealType= array(),$searchCurrency= array(), $searchProduct= '',$date='',$userType= 'All',$status= 'All',$sortByOption= 'userName',$sortByOrder='asc')
	{
		$sortByOption  = ($sortByOption == 'userName') ? 'userFirstName' : "orderQty";
		$languageID 	= $languageIDs['Current'];
		if (count($searchDealType) > 0) {
			$searchDealTypes = "" . implode("','", $searchDealType) . "";
			$filter .= " and dealType in('" . $searchDealTypes . "')";
			$filterStatus = true;
		}
		if (count($searchCurrency) > 0) {
			$searchCurrencies = "" . implode("','", $searchCurrency) . "";
			$filter .= " and currencyID in('" . $searchCurrencies . "')";
			$filterStatus = true;
		}
		if ($searchProduct!='') {
			$searchProduct	= $this->escape($searchProduct);
			$filter .= " and (deal.dealKey LIKE '%".$searchProduct."%' 
			OR dealDet.dealTitle LIKE '%".$searchProduct."%') ";
			$filterStatus = true;
		}
		if (strpos($date, 'to') > 0) 
		{
			$queryString = explode('to', $date);
			$fromDate	= $queryString[0] . ' 00:00:00';
			if ($queryString[1] == date("Y-m-d")) {
				$filter .= " and addedTime between '" . $fromDate . "' and NOW()";
				$dateFiler = " addedTime between '" . $fromDate . "' and NOW()";
			} else {
				$toDate = $queryString[1] . ' 23:59:59';
				$filter .= " and addedTime between '".$fromDate."' and '" . $toDate . "'";
				$dateFiler = " addedTime between '".$fromDate."' and '" . $toDate . "'";
			}
			$filterStatus = true;
		} 
		else {
			$filter .= " and DATE(addedTime)='" . $date . "'";
			$dateFiler = " DATE(addedTime)='" . $date . "'";
			$filterStatus = true;
		}
		if ($userType != 'All') {
			$filter .=($userType == 'User') ? " and cart.userID >0 " : " and cart.userID=0 ";
			$filterStatus = true;
		}
		if ($status != 'All') {
			if($status == 'Online')
			{
				$filter .= " and addedTime between NOW() - INTERVAL 20 MINUTE and NOW() ";
				$dateFiler = " addedTime between NOW() - INTERVAL 20 MINUTE and NOW() ";
			}
			else
			{
				$filter .= " and addedTime < NOW() - INTERVAL 20 MINUTE ";

				$dateFiler = " addedTime < NOW() - INTERVAL 20 MINUTE ";
			}
			$filterStatus = true;
		}
		if ($limitTo) {
			$paginationText = " SQL_CALC_FOUND_ROWS ";
		}
		$sql	=	"	SELECT ".$paginationText." 
							cart.cartID,
							sum(orderItemQuantity) AS orderQty,
							currencyID,
							cart.userID,
							addedTime,
							userFirstName,
							userLastName,
							SUM(orderTotalAmount) AS orderTotalAmount,
							userEmail,
							userPhone
						FROM 
							".DB_PREFIX."cart cart
						LEFT JOIN  
							".DB_PREFIX."cart_items cartIte
							ON
								(cartIte.cartID=cart.cartID)
						LEFT JOIN  
							".DB_PREFIX."users usr
							ON
								(usr.userID=cart.userID)
						LEFT JOIN  ".DB_PREFIX."deals deal
							ON
								(deal.dealID=cartIte.dealID)
						LEFT JOIN 
							".DB_PREFIX."deal_details dealDet
							ON
								(dealDet.dealID=deal.dealID AND dealDet.languageID=
							'".$languageID."' )
						WHERE 
								cart.cartID >0 ".$filter." 
						GROUP BY 
							cart.userID 
						ORDER BY
							".$sortByOption." 
							".$sortByOrder."";
		if ($limitTo) {
			$sql .= " LIMIT  " . $limitFrom . "," . $limitTo . " ";
		}
		$result =  $this->ObjDatabase->readValues($sql);
		return array($result,$filter,$dateFiler);
	}
	
	public function getCartLastActiveDate($userID,$dateFilter='')
	{
		$sql	=	"	SELECT 
								addedTime 
							FROM 
								".DB_PREFIX."cart_items cartIte
							INNER JOIN 
								".DB_PREFIX."cart cart
								ON
									(cart.userID='".$userID."' AND cartIte.cartID=cart.cartID)
							WHERE 
								".$dateFilter." 
							ORDER BY 
								addedTime DESC";
		$result =  $this->ObjDatabase->readValue($sql);
		return $result['addedTime'];
	}
	
	public function getCartItemDetails($languageIDs,$userID,$filter='')
	{
		$ObjCountry	 = new CountryModel();
		$languageID 	= $languageIDs['Current'];
		$sql			=	"	SELECT 
									cart.*
								FROM 
									".DB_PREFIX."cart cart
								LEFT JOIN 
									".DB_PREFIX."cart_items cartIte
									ON
										(cartIte.cartID=cart.cartID)
								LEFT JOIN  ".DB_PREFIX."users usr
									ON
										(usr.userID=cart.userID)
								LEFT JOIN  
									".DB_PREFIX."deals deal
									ON
										(deal.dealID=cartIte.dealID)
								LEFT JOIN 
									".DB_PREFIX."deal_details dealDet
									ON
										(dealDet.dealID=deal.dealID AND dealDet.languageID=
							'".$languageID."')
								WHERE 
									cart.cartID >0 
									AND
										cart.userID='".$userID."' ".$filter." 
								GROUP BY cart.cartID ";
		$result =  $this->ObjDatabase->readValues($sql);
		if(count($result)>0)
		{
			foreach ($result as $key=> $res) {
				$extra = unserialize($res['extra']);
				$billingAdressFormat = '';
				if(count($extra['userBillingAddress'])>0 && 
				is_array($extra['userBillingAddress']))
				{
					$billingAdress	= array_slice(array_values($extra['userBillingAddress'])
					,0,-2);
					$billingAdressFormat =	$ObjCountry->getFormattedAddress($billingAdress,
					array(),', ');
					$result[$key]['billingAddress']=$billingAdressFormat;
				}
				$result[$key]['unserialized']=$extra;
				if(count($extra['userShippingAddress'])>0 && 
				is_array($extra['userShippingAddress']))
				{
					$shippingAdressFormat = '';
					$shippingAdress	= array_values($extra['userShippingAddress']);
					$shippingAdressFormat=$ObjCountry->getFormattedAddress($shippingAdress,
					array(),', ');
					$result[$key]['shippingAddress']=$shippingAdressFormat;	
				}
				
				$sql	=	"	SELECT 
									extra,
									sendTime
								FROM 
									".DB_PREFIX."cart_notifications cartNot
								WHERE
									cartNot.cartID='".$res['cartID']."'
								ORDER BY 
									sendTime DESC";
				$subResult =  $this->ObjDatabase->readValues($sql);
				$result[$key]['notifications']=$subResult;
				
				
				$sql	=	"	SELECT 
									cartIte.*
								FROM 
									".DB_PREFIX."cart_items cartIte
								WHERE
									cartIte.cartID='".$res['cartID']."'
								GROUP BY 
									cartIte.cartItemID 
								ORDER BY 
									addedTime DESC";
				$subResult =  $this->ObjDatabase->readValues($sql);
				$result[$key]['items']=$subResult;
			}
			
			return $result;
		}
		else
		{
			return array();	
		}
	}
	
	public function listCartUserEmails($userIDs,$from='campagain')
	{
		$searchUserIds 	= "" . implode("','", $userIDs) . "";
		if($from=='campagain')
		{
			$sql	=	"	SELECT 
								userEmail,
								userFirstName,
								userLastName,
								userDefaultLanguage
							FROM 
								".DB_PREFIX."users usr
							WHERE 
								usr.userID 
								IN 
									('".$searchUserIds."')";
		}
		else
		{
			$sql	=	"	SELECT 
								userEmail,
								userFirstName,
								userLastName,
								userDefaultLanguage
							FROM 
								".DB_PREFIX."users usr
							WHERE 
								usr.userID 
								IN 
									('".$searchUserIds."')";
		}
		$subResult =  $this->ObjDatabase->readValues($sql);
		return 	$subResult;
	}
	
	public function updateCampaignDetails($campaignID=0,$action='purchase',$orderAmount=0)
	{
		if($action=='purchase')
		{
			$orderAmount 	= number_format($orderAmount, 2, '.', '');
			$sql 	  	=  " UPDATE 
									" . DB_PREFIX . "campaigns 
								SET 
									revenue=revenue+" . 
			$orderAmount	. ",purchaseCount=purchaseCount+1
								WHERE 
									campaignID ='" . $campaignID . "'";
			$resUpdate = $this->ObjDatabase->setQuery($sql);
		}
		else if($action=='signup')
		{
			$orderAmount	= number_format($$orderAmount, 2, '.', '');
			$sql	  	= " UPDATE 
									" . DB_PREFIX . "campaigns 
								SET
									registrationCount=registrationCount+1 
								WHERE 
									campaignID ='" . $campaignID . "'";
			$resUpdate = $this->ObjDatabase->setQuery($sql);
		}
	}
	
	public function getCartRecoveryDetails($limitFrom,$limitTo,$title='',$date='',$campaignID=0)
	{
		if ($title!='') 
		{
			$title	= $this->escape($title);
			$filter .= " AND cam.title LIKE '%".$title."%'";
		}
		if (strpos($date, 'to') > 0) 
		{
			$queryString = explode('to', $date);
			$fromDate	= $queryString[0] . ' 00:00:00';
			if ($queryString[1] == date("Y-m-d"))
			{
				$filter .= " AND createdDate between '" . $fromDate . "' AND NOW()";
			} 
			else 
			{
				$toDate = $queryString[1] . ' 23:59:59';
				$filter .= " AND createdDate between '".$fromDate."' 
				AND '" . $toDate . "'";
			}
		} 
		else 
		{
			$filter .= " AND DATE(createdDate)='" . $date . "'";
			$filterStatus = true;
		}
		if ($limitTo) {
			$paginationText = " SQL_CALC_FOUND_ROWS ";
		}
		if($campaignID==0)
		{
			$sql	=	"	SELECT 
									".$paginationText."
									title,
									createdDate,
									userCount,
									uniqueOpenedCount,
									uniqueClickCount,
									purchaseCount,
									revenue,
									campaignID
								FROM 
									".DB_PREFIX."campaigns cam
								WHERE 
									campaignType='cart'  
									".$filter." 
								ORDER BY 
									createdDate DESC
								LIMIT  " . $limitFrom . "," . $limitTo . " ";
			$result =  $this->ObjDatabase->readValues($sql);						
		}
		else
		{
			$sql	=	"	SELECT 
									*
								FROM 
									".DB_PREFIX."campaigns cam
								WHERE 
									campaignType='cart'  
									AND campaignID=".(int)($campaignID)."
								ORDER BY 
									createdDate DESC";
			$result =  $this->ObjDatabase->readValue($sql);

		}
			
		return $result;
	}
	
	public function clearCartEntries($userIDS,$filter='',$languageIDs)
	{
		$languageID =  $languageIDs['Current'];
		if(count($userIDS)>0)
		{
			$searchuserIDS = "" . implode("','", $userIDS) . "";
			$sql		=	"	SELECT 
									cart.cartID 
								FROM 
									".DB_PREFIX."cart cart
								LEFT JOIN 
									".DB_PREFIX."cart_items cartIte
									ON
										(cartIte.cartID=cart.cartID)
								LEFT JOIN  ".DB_PREFIX."users usr
									ON
										(usr.userID=cart.userID)
								LEFT JOIN  
									".DB_PREFIX."deals deal
									ON
										(deal.dealID=cartIte.dealID)
								LEFT JOIN 
									".DB_PREFIX."deal_details dealDet
									ON
										(dealDet.dealID=deal.dealID AND 
										dealDet.languageID='".$languageID."')
								WHERE 
									cart.cartID >0 
									AND
										cart.userID IN ('" . $searchuserIDS . "') ".$filter." 
								GROUP BY cart.cartID ";
			$result =  $this->ObjDatabase->readValues($sql);
			if(count($result)>0)
			{
				foreach ($result as $key=>$items)
				{
					$cartIds	.="'".$items['cartID']."',";
				}
				$cartIds = substr($cartIds, 0, -1);
				$sql	=	"	DELETE FROM 
									".DB_PREFIX."cart 
								WHERE 
									cartID IN (" . $cartIds . ")";
				$resDeleteFromUrl  = $this->ObjDatabase->setQuery($sql);
			}
		}
	}
	
	public function getUserDetails($userID)
	{
		if($userID >0)
		{
			$sql	= "SELECT 
						usr.userDOB,
						userGender
					FROM 
						" . DB_PREFIX . "users as usr 
					WHERE 
						usr.userID='" . $userID . "' 
					LIMIT 1 ";
			return $this->ObjDatabase->readValue($sql);
		}
	
	}
	
	public function listDealsForTopDeals($languageIDs,$dateFrom,$dateTo,$merchantID=0)
	{	
		$defaultLanguageID  	= $languageIDs['Default'];
		$currentLanguageID  	= $languageIDs['Current'];	
		$stabledateFrom			=	$dateFrom;	
		$stabledateTo			=	$dateTo;	
		if(!$dateTo||$dateTo=='')
		{
			$searchDateFrom	=	$stabledateFrom." "."00:00:00";
			$searchDateTo	=	$stabledateFrom." "."23:59:59";			
		}
		else
		{
			$dateFrom	=	$dateFrom." "."00:00:00";
			$dateTo		=	$dateTo." "."23:59:59";
			$searchDateFrom	=	$dateFrom;
			$searchDateTo	=	$dateTo;
		}
		
		
		
		$sql						=	"	SET SESSION group_concat_max_len = 1000000";			
		$this->ObjDatabase->setQuery($sql);
		
		$sql =	" SELECT 
			sum(viewed) as viewed,
			sum(uniqueViewed) as uniqueViewed,
			sum(bought) as bought,
			sum(total) as totalweigtage,
			productID,
			dealDet.dealTitle
		FROM 
			". DB_PREFIX."product_popularity proPop";
                if($merchantID>0){
                 $sql .=	" JOIN ".DB_PREFIX."deals dea
                                    ON dea.dealID=proPop.productID ";   
                }
		$sql .=	" LEFT JOIN
			".DB_PREFIX."deal_details dealDet
							ON(proPop.productID=dealDet.dealID AND dealDet.languageID=".$currentLanguageID.")	
		WHERE 
			visitDate between '".$searchDateFrom."' AND '".$searchDateTo."' ";
                  if($merchantID>0){
                     $sql .=	" AND dea.businessID='".$merchantID."'";  
                  }
		 $sql .=	"GROUP BY proPop.productID	";	
		//echo $sql;
		$resultData				=	$this->ObjDatabase->readValuesObject($sql);
		$countOfresult			=	$resultData->num_rows;
		for($result=0;$result<$countOfresult;$result++)
		{
			$resultSet	=	$resultData->fetch_array(MYSQL_ASSOC);
			$resAllViews[$result]['dealID']=$resultSet['productID'];
			$resAllViews[$result]['dealTitle']=$resultSet['dealTitle'];
			$resAllViews[$result]['totalviews']=$resultSet['viewed'];
			$resAllViews[$result]['uniqueviews']=$resultSet['uniqueViewed'];
			$resAllViews[$result]['ordersinsearchspan']=$resultSet['bought'];
			$resAllViews[$result]['searchspanQty']=$resultSet['bought'];
			$resAllViews[$result]['totalweigtage']=$resultSet['totalweigtage'];
			
			$sql =	" SELECT 
						sum(viewed) as viewed,
						sum(uniqueViewed) as uniqueViewed,
						sum(bought) as bought,
						productID
					FROM 
						". DB_PREFIX."product_popularity proPop
					WHERE 
                                        visitDate between '".$searchDateFrom."' AND '".$searchDateTo."' 
                                            AND
						proPop.productID=".$resultSet['productID'];
			$resAllDet	=	$this->ObjDatabase->readValue($sql);
			
			$resAllViews[$result]['alltotalviews']=$resAllDet['viewed'];
			$resAllViews[$result]['alluniqueviews']=$resAllDet['uniqueViewed'];
			$resAllViews[$result]['allorders']=$resAllDet['bought'];
			$resAllViews[$result]['allqty']=$resAllDet['bought'];
			
			if($resAllViews[$result]['uniqueviews'] >0)
			{
				$viewToBuyRatio = ($resAllViews[$result]['ordersinsearchspan']/$resAllViews[$result]['uniqueviews'])*100;
			}
			if($viewToBuyRatio>60)
			{				
				$resAllViews[$result]['remarks']="High";				
			}
			else if($viewToBuyRatio>30)
			{				
				$resAllViews[$result]['remarks']="Stable";			
			}
			else
			{				
				$resAllViews[$result]['remarks']="Low";
			}
			$resultSet->free;
		}	
		return $resAllViews;	
	}
	
	public function getTopSearchDetails($dateFrom,$dateTo,$sortBy='updatedAt',$orderBy='desc',$limitFrom=0,$limitTo=0)
	{
		$stabledateFrom			=	$dateFrom;	
		$stabledateTo			=	$dateTo;	
		if(!$dateTo||$dateTo=='')
		{
			$searchDateFrom	=	$stabledateFrom." "."00:00:00";
			$searchDateTo	=	$stabledateFrom." "."23:59:59";			
		}
		else
		{
			$dateFrom	=	$dateFrom." "."00:00:00";
			$dateTo		=	$dateTo." "."23:59:59";
			$searchDateFrom	=	$dateFrom;
			$searchDateTo	=	$dateTo;
		}
		if ($limitTo>0) 
		{
			$paginationText = " SQL_CALC_FOUND_ROWS ";
		}
		$sql =	" SELECT 
					".$paginationText."
					queryText,
					numResults,
					popularity,
					updatedAt,
					catSea.queryID,
					count(catSeaVis.visitorID) as visitorCount,
					lan.languageCode,
					lan.languageName
		FROM 
			". DB_PREFIX."catalogsearch_query catSea
		LEFT JOIN 
			". DB_PREFIX."catalogsearch_query_visitor catSeaVis
			ON(catSeaVis.queryID=catSea.queryID AND  catSeaVis.searchTime between '".$searchDateFrom."' AND '".$searchDateTo."')
		LEFT JOIN 
			". DB_PREFIX."languages lan
			ON (lan.languageID=catSea.languageID)
		WHERE 
			updatedAt between '".$searchDateFrom."' AND '".$searchDateTo."'
			AND queryStatus='A' AND popularity>0 
		GROUP BY catSea.queryID	
		ORDER BY
			".$sortBy." ".$orderBy."";
		if($limitTo >0)
		{
			$sql .=" LIMIT ".$limitFrom." , ".$limitTo;
		}
		$resultData				=	$this->ObjDatabase->readValues($sql);
		
		$sqlForPagination =	" SELECT 
										".$paginationText."
										queryText,
										numResults,
										popularity,
										updatedAt,
										catSea.queryID,
										count(catSeaVis.visitorID) as visitorCount,
										lan.languageCode
							FROM 
								". DB_PREFIX."catalogsearch_query catSea
							LEFT JOIN 
								". DB_PREFIX."catalogsearch_query_visitor catSeaVis
								ON(catSeaVis.queryID=catSea.queryID AND  catSeaVis.searchTime between '".$searchDateFrom."' AND '".$searchDateTo."')
							LEFT JOIN 
								". DB_PREFIX."languages lan
								ON (lan.languageID=catSea.languageID)
							WHERE 
								updatedAt between '".$searchDateFrom."' AND '".$searchDateTo."'
								AND queryStatus='A' AND popularity>0 
							GROUP BY queryText	
							ORDER BY
								".$sortBy." ".$orderBy."";
		if($limitTo >0)
		{
			$sqlForPagination .=" LIMIT ".$limitFrom." , ".$limitTo;
		}
		$temResult		=	$this->ObjDatabase->readValues($sqlForPagination);
		

		return $resultData;
	}
	
	public function getTopSearchVisitorDetails($termID,$dateFrom,$dateTo,$sortBy='searchTime',$orderBy='desc',$limitFrom, $limitTo)
	{
		$stabledateFrom			=	$dateFrom;	
		$stabledateTo			=	$dateTo;	
		if(!$dateTo||$dateTo=='')
		{
			$searchDateFrom	=	$stabledateFrom." "."00:00:00";
			$searchDateTo	=	$stabledateFrom." "."23:59:59";			
		}
		else
		{
			$dateFrom	=	$dateFrom." "."00:00:00";
			$dateTo		=	$dateTo." "."23:59:59";
			$searchDateFrom	=	$dateFrom;
			$searchDateTo	=	$dateTo;
		}
		if ($limitTo>0) 
		{
			$paginationText = " SQL_CALC_FOUND_ROWS ";
		}
		$sql =	" SELECT
					".$paginationText."
					catSeaVis.searchTime,
					catSea.languageID,
					log.entryPage,
					log.userAgent,
					log.browserName,
					log.operatingSystem,
					log.httpReferer,
					log.remoteAddress,
					log.userType,
					log.orderPlaced,
					log.orderAmount,
					log.doneSubscribe,
					log.doneSignUp,
					log.city,
					log.country,
					log.pageCount,
					log.visitorID
		FROM 
			". DB_PREFIX."catalogsearch_query_visitor catSeaVis
		LEFT JOIN 
			". DB_PREFIX."catalogsearch_query catSea
			ON(catSea.queryID=catSeaVis.queryID)
		LEFT JOIN
			". DB_PREFIX."visitor_info_log log
			ON(log.visitorID=catSeaVis.visitorID)
		WHERE 
			searchTime between '".$searchDateFrom."' AND '".$searchDateTo."' 
			AND catSeaVis.queryID='".$termID."' 
		ORDER BY
			".$sortBy." ".$orderBy."";
		if($limitTo >0)
		{
			$sql .=" LIMIT ".$limitFrom." , ".$limitTo;
		}
		$resultData				=	$this->ObjDatabase->readValues($sql);
		return $resultData;
	}
	
	public function getVisitorAllUrls($visitorID)
	{
		$sql =	" SELECT
					*
		FROM 
			". DB_PREFIX."visitor_url_log log
		WHERE 
			log. visitorID = '".$visitorID."'
		ORDER BY urlID ASC";
		$resultData				=	$this->ObjDatabase->readValues($sql);
		return $resultData;
	}	
    
	//function to get details based on age - customer analytics - added on 07/08/2013
	public function getCustomerAgeGenderDetails($type="object", $merchantID=0, $searchAgeArray = array(), $searchGenderArray = array(), $date = '')
	{
		$filterStatus = false;		
		if (is_array($searchAgeArray) &&  count($searchAgeArray) > 0) {
			$filter .= " AND ( ";
			if (in_array("below17", $searchAgeArray)) {
				$filterTmp .= " OR TIMESTAMPDIFF(YEAR, STR_TO_DATE(usr.userDOB, '%d-%m-%Y'),CURDATE()) BETWEEN 1 and 17 ";
			}
			if (in_array("18-24", $searchAgeArray)) {
				$filterTmp .= " OR TIMESTAMPDIFF(YEAR, STR_TO_DATE(usr.userDOB, '%d-%m-%Y'),CURDATE()) BETWEEN 18 and 24 ";
			}
			if (in_array("25-34", $searchAgeArray)) {
				$filterTmp .= " OR TIMESTAMPDIFF(YEAR, STR_TO_DATE(usr.userDOB, '%d-%m-%Y'),CURDATE()) BETWEEN 25 and 34 ";
			}
			if (in_array("35-54", $searchAgeArray)) {
				$filterTmp .= " OR TIMESTAMPDIFF(YEAR, STR_TO_DATE(usr.userDOB, '%d-%m-%Y'),CURDATE()) BETWEEN 35 and 54 ";
			}
			if (in_array("above55", $searchAgeArray)) {
				$filterTmp .= " OR TIMESTAMPDIFF(YEAR, STR_TO_DATE(usr.userDOB, '%d-%m-%Y'),CURDATE()) >=55 ";
			}
			if (in_array("notage", $searchAgeArray)) {
				$filterTmp .= " OR usr.userDOB =''  OR usr.userDOB IS NULL ";
			}
			$filter .= substr($filterTmp, 3) . " )";
			$filterStatus = true;
		}
		if (is_array($searchGenderArray) && count($searchGenderArray) > 0) {
                        $filter .= " AND ";
                        if(in_array('Not Specified',$searchGenderArray)){
                            $filter .= " ( userGender='' OR userGender IS NULL OR ";
                        }
			$searchGender = "" . implode("','", $searchGenderArray) . "";
			$filter .= "  userGender IN('" . $searchGender . "')";
                         if(in_array('Not Specified',$searchGenderArray)){
                          $filter .= " )  ";   
                         }
			$filterStatus = true;
		}
              if($date!='')  {
		if (strpos($date, 'to') > 0) {
			$queryString = explode(' to ', $date);
			$fromDate	= $queryString[0] . ' 00:00:00';
			if ($queryString[1] == date("Y-m-d")) {
				$filter .= " AND orderCreatedDate BETWEEN '" . $fromDate . "' AND NOW()";
			} else {
				$toDate = $queryString[1] . ' 23:59:59';
				$filter .= " AND orderCreatedDate BETWEEN '" . $fromDate . "' AND '" . $toDate . "'";
			}
			$filterStatus = true;
		} else {
			$filter .= " AND DATE(orderCreatedDate)='" . $date . "'";
			$filterStatus = true;
		}
              }
             $sql    =	"SELECT 
                             IF (userGender!='',userGender,'Not Specified')  AS userSex,
                             IF (usr.userDOB!='', TIMESTAMPDIFF(YEAR, STR_TO_DATE(usr.userDOB, '%d-%m-%Y'),CURDATE()),'') AS userAge,
                             orderCreatedDate,
                             DAYOFWEEK(orderCreatedDate) AS weekday,
                             ordr.billingAddress AS billingAddress,
                             ordr.userID,
                             ordr.orderTotalAmount AS orderTotalAmount
                        FROM ".DB_PREFIX."order_masters ordr
                        JOIN ".DB_PREFIX."users usr
                        ON ordr.userID=usr.userID AND userStatus!='Deleted'    
                        WHERE businessID='".$merchantID."' AND orderStatus!='New'";
            if($filterStatus)
		$sql	.=	" AND " . substr($filter, 4);
          
       // echo $sql;exit;
           if($type=='object')
                $resSelectAgeGender = $this->ObjDatabase->readValuesObject($sql, MYSQL_ASSOC);
           else 
               $resSelectAgeGender = $this->ObjDatabase->readValues($sql, MYSQL_ASSOC); 
            return $resSelectAgeGender;
	}
	
	public function getTotalCountsCustomer($merchantID=0,$searchAgeArray = array(), $searchGenderArray = array(), $date = '')
	{
		$filterStatus = false;		
		if (is_array($searchAgeArray) && count($searchAgeArray) > 0) {
			$filter .= " AND ( ";			
			if (in_array("below17", $searchAgeArray)) {
				$filterTmp .= " OR TIMESTAMPDIFF(YEAR, STR_TO_DATE(usr.userDOB, '%d-%m-%Y'),CURDATE()) BETWEEN 1 AND 17 ";
			}
			if (in_array("18-24", $searchAgeArray)) {
				$filterTmp .= " OR TIMESTAMPDIFF(YEAR, STR_TO_DATE(usr.userDOB, '%d-%m-%Y'),CURDATE()) BETWEEN 18 AND 24 ";
			}
			if (in_array("25-34", $searchAgeArray)) {
				$filterTmp .= " OR TIMESTAMPDIFF(YEAR, STR_TO_DATE(usr.userDOB, '%d-%m-%Y'),CURDATE()) between 25 AND 34 ";
			}
			if (in_array("35-54", $searchAgeArray)) {
				$filterTmp .= " OR TIMESTAMPDIFF(YEAR, STR_TO_DATE(usr.userDOB, '%d-%m-%Y'),CURDATE()) between 35 AND 54 ";
			}
			if (in_array("above55", $searchAgeArray)) {
				$filterTmp .= " OR TIMESTAMPDIFF(YEAR, STR_TO_DATE(usr.userDOB, '%d-%m-%Y'),CURDATE()) >=55 ";
			}
			if (in_array("notage", $searchAgeArray)) {
				$filterTmp .= " OR usr.userDOB =''  OR usr.userDOB IS NULL";
			}
			$filter .= substr($filterTmp, 3) . " )";
			$filterStatus = true;			
		}
		if (is_array($searchGenderArray) && count($searchGenderArray) > 0) {
			 $filter .= " AND ";
                        if(in_array('Not Specified',$searchGenderArray)){
                            $filter .= " ( userGender='' OR userGender IS NULL OR ";
                        }
			$searchGender = "" . implode("','", $searchGenderArray) . "";
			$filter .= "  userGender IN('" . $searchGender . "')";
                         if(in_array('Not Specified',$searchGenderArray)){
                          $filter .= " )  ";   
                         }
			$filterStatus = true;			
		}
                 if($date!='')  {
                    if (strpos($date, 'to') > 0) {
                             $queryString = explode(' to ', $date);
                             $fromDate	= $queryString[0] . ' 00:00:00';
                             if ($queryString[1] == date("Y-m-d")) {
                                     $filter .= " AND orderCreatedDate BETWEEN '" . $fromDate . "' AND NOW()";
                             } else {
                                     $toDate = $queryString[1] . ' 23:59:59';
                                     $filter .= " AND orderCreatedDate BETWEEN '" . $fromDate . "' AND '" . $toDate . "'";
                             }
                             $filterStatus = true;
                     } else {
                             $filter .= " AND DATE(orderCreatedDate)='" . $date . "'";
                             $filterStatus = true;
                     }
                 }
                $sql    =   "SELECT                             
                             ordr.userID as user,
                             ordr.orderTotalAmount AS orderTotalAmount
                        FROM ".DB_PREFIX."order_masters ordr
                        JOIN ".DB_PREFIX."users usr
                        ON ordr.userID=usr.userID AND userStatus!='Deleted'    
                        WHERE businessID='".$merchantID."' AND orderStatus!='New'";
                 if($filterStatus)
                    $sql	.=	" AND " . substr($filter, 4);
              
		$resSelectLogTotalValue                 = $this->ObjDatabase->readValues($sql, MYSQL_ASSOC);
		$visitorCount				= 0;	
		$resSelectLogTotal['totalCustomers']		= 0;	
		$resSelectLogTotal['newVisit']		= 0;
		$resSelectLogTotal['returnVisit']	= 0;
                $resSelectLogTotal['totalRevenue']      = 0;
                $resSelectLogTotal['ordersplaced']      = 0;
                $newVisit                               = 0;
                $returnVisit                            = 0;  
                $totOrderAmount                         = 0;
                $uniqueArray    =   $userIDArray        = array();
		$visitorCount                           = count($resSelectLogTotalValue);
                if ($visitorCount > 0) {
                      foreach($resSelectLogTotalValue as $key=>$value){
                          $userIDArray[]=$value['user']; 
                          $totOrderAmount = $totOrderAmount+$value['orderTotalAmount'];
                      }                            
                    $uniqueArray = array_count_values($userIDArray);                 
                    foreach ($uniqueArray as $id) {
                        if($id==1){
                            $newVisit++;//echo $valueTot['user']."<br>";
                        }
                        else $returnVisit++;
                    }
                    unset($resSelectLogTotalValue);
                }
            
		$resSelectLogTotal['totalCustomers']		= $newVisit+$returnVisit;
		$resSelectLogTotal['newVisit']	= $newVisit;
		$resSelectLogTotal['returnVisit'] = $returnVisit;
                $resSelectLogTotal['ordersplaced'] = $visitorCount;
                $resSelectLogTotal['totalRevenue'] = $totOrderAmount;
		return $resSelectLogTotal;
	}
	
	public function getUserDiscountDetails($userID=0,$userEmail='')
	{
		$sql	=	"SELECT 
						cartNot.extra,
						cartNot.sendTime
					FROM 
						".DB_PREFIX."cart_notifications cartNot
					INNER JOIN  
						".DB_PREFIX."cart cart
						ON
							(cart.cartID=cartNot.cartID AND cart.userID='".$userID."')
					GROUP BY 
						cartNot.notificationID 
					ORDER BY
						sendTime DESC ";
		$result =  $this->ObjDatabase->readValues($sql);
		
		$return['notifications']= $result;
		
		$sql	=	"SELECT 
						cam.extra,
						cam.createdDate
					FROM 
						".DB_PREFIX."campaigns cam
					INNER JOIN  
						".DB_PREFIX."campaign_recipients camRec
						ON
							(camRec.campaignID=cam.campaignID AND camRec.emailID='".$userEmail."' AND (camRec.type='Send' OR camRec.type=''))
					WHERE
						cam.campaignType='cart'
					GROUP BY 
						cam.campaignID 
					ORDER BY
						createdDate DESC ";
		$result =  $this->ObjDatabase->readValues($sql);
		
		$return['campaigns']= $result;

		return $return;
	}
}
