<?php
/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/
//
//$Id: MenuModel.php, v 1.0 2013/03/14 17:30:11
//
class MenuModel extends Model {
    private $httpURLArr ;
    private $httpsURLArr ;
    private $httpImagePath;
    var $languageIDs;
     function __construct($params=array()) {
		parent::__construct();

		$this->httpURLArr   = isset($params[1]) ? $params[1] : '';
        $this->httpsURLArr  = isset($params[2]) ? $params[2] : '';
        $this->httpImagePath  = isset($params[3]) ? $params[3] : '';
        if(!empty($params[0])){
			$this->languageIDs		= $params[0];
		}
		
	}
	//LIST MENU TREES
	public function listMenusTree($languageID,$_url_path="",$userTypeID='',$languageXml='',$campignEnable,$manageUserID='')	
	{
		$tree_string	= "";
		return  $this->listMenusTreeItems($languageID,0,$_url_path,$tree_string,$tree_level=0,$userTypeID,'','','',$languageXml,$campignEnable,'','','',$manageUserID);
	}
	//LIST MENU BREAD CRUMB
	public function listMenusBreadcrumb($languageID,$_url_path="",$adminModuleID,$views_url_type="index",$views_url_found)	
	{
		$selectedUrlModuleID = $adminModuleID;
		$breadcrumb_array = "";
		$breadcrumb_array = $this->listMenuBreadcrumbItems($languageID,$adminModuleID,$_url_path,$breadcrumb_array,$tree_level=0,$views_url_type,$views_url_found,$selectedUrlModuleID);
		$breadcrumb_array = array_reverse($breadcrumb_array);
		return $breadcrumb_array;
	}
 //GET MENU DETAILS 
	public function getMenuDetails($languageID=1,$adminModuleID=0)	
	{
		if(!$adminModuleID)
			return array(); 
		$sql		=	"
						SELECT
							*
						FROM
							".DB_PREFIX."admin_modules AS admMod
						";
		$sql		.=	"
						LEFT JOIN
							".DB_PREFIX."admin_module_details AS admModDet 
							ON admMod.adminModuleID=admModDet.adminModuleID
						";
		$sql		.=	"
						WHERE
							admModDet.languageID='".$languageID."'";
		$sql		.=	"
							AND admMod.adminModuleID='".$adminModuleID."'";
		$sql		.=	"
							AND (
								admMod.adminModuleType='Menu'
								OR admMod.adminModuleType='ALL'
							) ";
		$sql		.=	"
							AND admMod.adminModuleStatus='Active'
                                                        LIMIT 1";
		return	$this->ObjDatabase->readValue($sql);
	}
	//GET MENU ID 
	public function getMenuID($menuURL,$menuURLType='Key')	
	{
		$sql		=	"
						SELECT
							admMod.adminModuleID
						FROM
							".DB_PREFIX."admin_modules AS admMod";
		if($menuURLType=="String") {
			$sql		.=	" WHERE
								admMod.adminModuleURLString='".$menuURL."'";
		}else{
			$sql		.=	" WHERE
								admMod.adminModuleURLKey='".$this->escape($menuURL)."' ";
		}
		$sql		.=	" 	AND admMod.adminModuleStatus='Active'";
		$sql		.=	" ORDER BY
							admMod.adminModuleOrder ASC,
							admMod.adminModuleID DESC
                                                        LIMIT 1";
		$resSelectMenus		 =	$this->ObjDatabase->readValue($sql);
		return $resSelectMenus['adminModuleID'];
  }
  //GET MENU BREAD CRUMB ITEMS
  public function listMenuBreadcrumbItems($languageID=1,$adminModuleID,$_url_path,$breadcrumb_array=array(),$tree_level=0,$views_url_type,$views_url_found,$selectedUrlModuleID="")	
  {
		$resMenuDetails				= $this->getMenuDetails($languageID,$adminModuleID);
		$curr_adminModuleID	 		= isset($resMenuDetails['adminModuleID']) ? $resMenuDetails['adminModuleID'] : '';
		$curr_adminModuleParentID	= isset($resMenuDetails['adminModuleParentID']) ? $resMenuDetails['adminModuleParentID'] : '';
		$curr_adminModuleURLKey		= isset($resMenuDetails['adminModuleURLKey']) ? $resMenuDetails['adminModuleURLKey'] : '';
		$curr_adminModuleURLString	= isset($resMenuDetails['adminModuleURLString']) ? $resMenuDetails['adminModuleURLString'] : '';
		$curr_adminModuleStyleClass	= isset($resMenuDetails['adminModuleStyleClass']) ? $resMenuDetails['adminModuleStyleClass'] : '';
		$curr_adminModuleStyleIcon	= isset($resMenuDetails['adminModuleStyleIcon']) ? $resMenuDetails['adminModuleStyleIcon'] : '';
		$curr_adminModuleCaption	= isset($resMenuDetails['adminModuleCaption']) ? $resMenuDetails['adminModuleCaption'] : '';
		$curr_menuURL				= (empty($curr_adminModuleURLString))?$curr_adminModuleURLKey:$curr_adminModuleURLString;		
		if($curr_menuURL!="" && $curr_menuURL!="#") {
			$curr_menuURL		 =  $_url_path.ltrim($curr_menuURL,"/");
		} else {
			$curr_menuURL 	 	  = "Javascript:void(0);";
		}
		if(($tree_level==0 && $views_url_found!=0) || $curr_menuURL=="#") {
			$breadcrumb_string		=  '<span>'.$curr_adminModuleCaption.'</span>';
		}else if($curr_adminModuleID==$selectedUrlModuleID){
			if($views_url_found==0) { 
				$breadcrumb_string		=  '<span>';
				$breadcrumb_string 	   .=  '<a href="'.$curr_menuURL.'">'.$curr_adminModuleCaption.'</a>';
				$breadcrumb_string 	   .=  '</span>';
			}else{
				$breadcrumb_string		=  '<span>'.$curr_adminModuleCaption.'</span>';
			}
		}else{
			$breadcrumb_string		=  '<span>';
			$breadcrumb_string 	   .=  '<a href="'.$curr_menuURL.'">'.$curr_adminModuleCaption.'</a>';
			$breadcrumb_string 	   .=  '</span>';
		}
		$tree_level++;
		$breadcrumb_array[]			=  $breadcrumb_string;
		if($curr_adminModuleParentID>0)	{
			$breadcrumb_array		= $this->listMenuBreadcrumbItems($languageID=1,$curr_adminModuleParentID,$_url_path,$breadcrumb_array,$tree_level,$views_url_type,$views_url_found,$selectedUrlModuleID);
		}
		return  $breadcrumb_array;
	}
 //GET SUB MENU COUNT
	public function getSubMenuCount($languageID=1,$adminModuleParentID=0)	
	{
		$sql		= "
					SELECT
						count(adminModuleID) AS cnt
					FROM
						".DB_PREFIX."admin_modules AS admMod 
					WHERE
						admMod.adminModuleParentID='".$adminModuleParentID."'";
		$sql		.= " AND(
						admMod.adminModuleType='Menu'
						OR admMod.adminModuleType='ALL'
						) ";
		$sql		.=	" AND admMod.adminModuleStatus='Active'
                    LIMIT 1";
		$resSelectMenus		= $this->ObjDatabase->readValue($sql);
		return $resSelectMenus['cnt'];
	}
  
 //LIST MENUS 
  public function listMenus($languageID=1,$adminModuleParentID,$userTypeID='')	
  {
		$sql	=	"
					SELECT
						*
					FROM
							".DB_PREFIX."admin_modules AS admMod
						LEFT JOIN ".DB_PREFIX."admin_module_details AS admModDet
							ON 
								(admMod.adminModuleID=admModDet.adminModuleID)";
		if($userTypeID&&$userTypeID!=1){
			$sql	.=	" 
						LEFT JOIN ".DB_PREFIX."admin_user_type_modules AS admUsrTypMod
							ON 
								(admMod.adminModuleID=admUsrTypMod.adminModuleID)";
		}
		$sql	.=	" 
					WHERE
						admModDet.languageID='".$languageID."'";
		if($adminModuleParentID>=0) {
			$sql.=	" 	AND 
						admMod.adminModuleParentID='".$adminModuleParentID."'";
		}
		$sql	.= " 	AND (
							admMod.adminModuleType='Menu'
							OR 
							admMod.adminModuleType='ALL'
							) ";
		if($userTypeID&&$userTypeID!=1)
		{
			$sql.= 	" 	AND  
						admUsrTypMod.userTypeID='".$userTypeID."' ";
		}
		$sql.=	" 		AND 
						admMod.adminModuleStatus='Active'";
		$sql.=	" 	GROUP BY
						admMod.adminModuleID
					ORDER BY
						admMod.adminModuleOrder,
						admMod.adminModuleID";
		$resSelectMenus	  =	$this->ObjDatabase->readValues($sql);
		return $resSelectMenus;
	}
	//LIST MENU TREE ITEMS
	public function listMenusTreeItems($languageID=1,$adminModuleParentID,$_url_path,$tree_string='',$tree_level=0,$userTypeID='',$blockLimit="",$lastMenuItem="",$endCurrentBlk="",$languageXml="",$campignEnable='',$singleBlockMenu='',$flag='',$maxBlkLimit='',$manageUserID='')	
	{
		$style	= '';
		$curr_adminModuleStyleClass	= '';
		$curr_adminModuleStyleClassLi = '';
		//last sublevel menu if its parent is in  root
		static $lastMenuItem;
		//Normal limit is 10 including parent,if subcount greater 9,$newBlkLmt=$resSubMenuCount+$blockLimit;
		static $blockLimit;
		//For inner treelevel ul li closing
		static $flag;
		//last sublevel menu if its paren having subcount greater 9
		static $endCurrentBlk;
		//If root parent having  one tree level,list sublevels in single block 
		static $singleBlockMenu;
		//blk limit exceeds default block length   
		static $maxBlkLimit	='';
		$resListMenus = $this->listMenus($languageID,$adminModuleParentID,$userTypeID);
		if($tree_level==0) {
			$tree_string 		= '<ul class="main_menu" >';
		} else {
			$tree_string 		= '<ul>';
		}
		$tree_level++;
                $menucount  =   count($resListMenus);
		for($menu_i=0;$menu_i<$menucount;$menu_i++)	{
			$curr_adminModuleID	 			= $resListMenus[$menu_i]['adminModuleID'];	
			$curr_adminModuleURLKey			= $resListMenus[$menu_i]['adminModuleURLKey'];
			$curr_adminModuleURLString		= $resListMenus[$menu_i]['adminModuleURLString'];
			$curr_adminModuleStyleClassDB	= $resListMenus[$menu_i]['adminModuleStyleClass'];
			$curr_adminModuleStyleIcon		= $resListMenus[$menu_i]['adminModuleStyleIcon'];
			$curr_adminModuleCaption		= $resListMenus[$menu_i]['adminModuleCaption'];
			$curr_adminModuleLabel			= $resListMenus[$menu_i]['adminModuleLabel'];
			$xmlLabel						= isset($languageXml[$curr_adminModuleLabel]) ? $languageXml[$curr_adminModuleLabel]  : '';
			$curr_menuURL					= (empty($curr_adminModuleURLString))?$curr_adminModuleURLKey:$curr_adminModuleURLString;
			$curr_adminModuleCaption 		= (!$xmlLabel)?$curr_adminModuleCaption:$xmlLabel;
			$curr_menuURL					= (empty($curr_adminModuleURLString))?$curr_adminModuleURLKey:$curr_adminModuleURLString;
			$resSubMenuCount 				= $this->getSubMenuCount($languageID,$curr_adminModuleID);
			if(($campignEnable!='' && $curr_menuURL=='emailqueue/index/') || ($manageUserID!=1 && $curr_menuURL=='report/adminrevenue/')) 
				 continue;
			if($curr_menuURL!="" && $curr_menuURL!="#" && $resSubMenuCount <1 || $adminModuleParentID==0) {
				$curr_menuURL		=	$_url_path.ltrim($curr_menuURL,"/");
				if($adminModuleParentID==0){
					$curr_adminModuleStyleClassLi='class="menudrop '.$curr_adminModuleStyleClassDB.'"';
					$curr_adminModuleStyleClass='menu_a';
				}
				$curr_menuURL 	   		= '<a href="'.$curr_menuURL.'" class="'.$curr_adminModuleStyleClass.'" >';
				$closeUrl				= '</a>';
			}else{
				$curr_menuURL			= '<h6>';
				$closeUrl				= '</h6>';
			}
			// if submenu count from 2nd tree level of a menu grater than 9,then thats sublevels also comes under same bloack
			if($resSubMenuCount>=10 && $tree_level>1 && $endCurrentBlk==''){
				 $endCurrentBlk			=	$this->getLastMenuItem($curr_adminModuleID);
			}
			//Normal limit is 10 including parent,if subcount greater 9,$newBlkLmt=$resSubMenuCount+$blockLimit;
			if($blockLimit!=0){
				$blockLimit				=     $blockLimit+1;
				$newBlkLmt					=	$resSubMenuCount+$blockLimit;
				// $blockLimit!=2 :for avoiding blank block when subcount >9 
				if(($newBlkLmt>$maxBlkLimit) && $blockLimit!=2 && $adminModuleParentID!=0 && $endCurrentBlk=='' && $singleBlockMenu!=0 && $tree_level==2){
					if($blockLimit>11 && $blockLimit>$maxBlkLimit){
						$maxBlkLimit	= $blockLimit-2;
					}
					$tree_string		.= 		'</ul>
													</div>
													<div  class="nav-block">
												<ul>';
					$blockLimit				=		1;
				}
			}
			if($curr_adminModuleID==$endCurrentBlk){
				$endCurrentBlk='';
			}
			if($adminModuleParentID==0)
				$flag					='';
			$tree_string		.= '<li  '.$curr_adminModuleStyleClassLi.'>';
			$tree_string		.= $curr_menuURL;
			$tree_string		.= ''.$curr_adminModuleCaption.'';
			$tree_string		.= $closeUrl;
			
			if($adminModuleParentID==0 && $resSubMenuCount>0){
				$maxBlkLimit=10;
				$lastMenuItem				=	$this->getLastMenuItem($curr_adminModuleID);
				//If root parent having  one tree level,list sublevels in single block 
				$singleBlockMenu			=	$this->checkMultipleBlockForMenu($curr_adminModuleID);
				$tree_string 				.= '<div  class="navigation-block '.$style.' "><div  class="nav-block">';
				$blockLimit				=	1;
			}
			if($resSubMenuCount>0) {
				$tree_string 		.= $this->listMenusTreeItems($languageID,$curr_adminModuleID,$_url_path,$tree_string,$tree_level,$userTypeID,$blockLimit,$lastMenuItem,$endCurrentBlk,$languageXml,$campignEnable,$singleBlockMenu,$flag,$maxBlkLimit,$manageUserID);
			}
			if($flag!=1)
				$tree_string 	.= '</li>';
		}
		if($flag!=1)
			$tree_string 		.= '</ul>';
		if($lastMenuItem==$curr_adminModuleID){
			for($k=2;$k<$tree_level;$k++){
				$flag		=	1;
				$tree_string		.=	' </li></ul>';
			}
			$tree_string		.=	' </div></div>';
		}
		return $tree_string;
	}
	public function getLastMenuItem($adminModuleID)	
	{
	 	$sql		= "
						SELECT
							adminModuleID
						FROM
							".DB_PREFIX."admin_modules AS admMod 
						WHERE
							admMod.adminModuleParentID='".$adminModuleID."'";
		$sql		.= " 	AND (
							admMod.adminModuleType='Menu'
							OR admMod.adminModuleType='ALL'
							) ";
		$sql		.=	"
							AND admMod.adminModuleStatus='Active'
						ORDER BY
							admMod.adminModuleOrder DESC,
							admMod.adminModuleID DESC
						LIMIT 0 , 1 ";
		$resSelectMenus	  = $this->ObjDatabase->readValue($sql);
		if(count($resSelectMenus)==0){
			return $adminModuleID;
		}
		$adminModuleID = $this->getLastMenuItem($resSelectMenus['adminModuleID']);
		return $adminModuleID;
	} 
  //If root parent having  one tree level,list sublevels in single block 
	public function checkMultipleBlockForMenu($adminModuleID)	
	{
		$sql		= "
					SELECT
						count(distinct adminModuleID) cnt
					FROM ".DB_PREFIX."admin_modules AS admMod 
					WHERE
						admMod.adminModuleParentID='".$adminModuleID."'";
		$sql		.= " AND (
							admMod.adminModuleType='Menu'
							OR admMod.adminModuleType='ALL'
							) ";
		$sql		.=	"
						AND admMod.adminModuleStatus='Active'
						AND  adminModuleID
						IN
						(
							SELECT
								adminModuleParentID
							FROM
								".DB_PREFIX."admin_modules AS admMod
							WHERE
								admMod.adminModuleType='Menu'
								OR admMod.adminModuleType='ALL'
								AND admMod.adminModuleStatus='Active'
						)
                                                LIMIT 1";
		$resSelectMenus	  = $this->ObjDatabase->readValue($sql);
		return $resSelectMenus['cnt'];
	} 
	//update and download  admin language  menu labels when they are not in database 
	public function saveMenuLabels($languageXml='')	{
		$sql		= "
						SELECT
							*
						FROM
							".DB_PREFIX."admin_module_details";
		$resSelectMenus		=	$this->ObjDatabase->readValues($sql);
		$xmlGenerate			.='<?xml version="1.0" encoding="ISO-8859-1"?><language>';
		foreach($resSelectMenus as $menu){
			$adminModuleCaption	=	$menu['adminModuleCaption'];
			$adminModuleLabel		=	$menu['adminModuleLabel'];
			if($adminModuleLabel==''){
				$stringReplace	= array("/","&","'"," ");
				$adminModuleCaption = str_replace($stringReplace, '', $adminModuleCaption);
				$adminModuleLabel		='lblMenu'.$adminModuleCaption;
				$xmlLabel					= $languageXml[$adminModuleLabel];
				if(!$xmlLabel){
					$xmlGenerate			.=	  '<'.$adminModuleLabel.' default="'.htmlentities(utf8_decode($menu['adminModuleCaption'])).'"/>';
				}
				$sql		= "
								UPDATE
									".DB_PREFIX."admin_module_details
								SET
									adminModuleLabel='".$adminModuleLabel."' 
								WHERE
									adminModuleID='".$menu['adminModuleID']."'";
				$resSaveLabel		= $this->ObjDatabase->setQuery($sql);
			}else if($languageXml[$adminModuleLabel]==''){
				$xmlGenerate			.=	  '<'.$adminModuleLabel.' default="'.htmlentities(utf8_decode($menu['adminModuleCaption'])).'"/>';			
			}
	  }
	 $xmlGenerate			.='</language>';
	 $fileName			='menu.xml';	
	  header("Content-Type: text/xml;charset=UTF-8");
	  header('Content-Disposition: attachment; filename='.$fileName);
	  echo $xmlGenerate;
	  exit;
 }    
 public function showMenu($params,$show=true)
	{
		$menuKey	=	$params['menukey'];
		$positionKey	=	isset($params['position'])?$params['position']:'';
		$checkParentActive	=	array();	
		$ObjSession 			= Registry::getInstance('Session');
		$registeredUserID 			    = $ObjSession->getSession("REGISTERED_USER_ID");
		$menuActive 	= $ObjSession->getSession("ACTIVE_MENUID");
		if($menuActive)
		$checkParentActive	=	$this->checkParentActive($menuActive);
		// get currrent language
	   $currentLanguageID	=	$this->languageIDs['Current'];
	   $bgImage	=	'';
		// language ends
		$menuDetailsAll	=	$this->getMenu($menuKey,$positionKey,$currentLanguageID);
		if($menuDetailsAll){			
			foreach($menuDetailsAll as $menuDetails){
				$menuID			=	$menuDetails['menuID'];			
			//check for class style
				if($menuDetails['cssStyle']!=''){$classvar	=	'class="'.$menuDetails['cssStyle'].'" ';}
				if($params['seperator']){			
					if($menuDetails['showBgImage']=='Yes'){
						$bgImage 	=	'style="background-repeat: no-repeat;background-image:url('.$this->httpImagePath.'/public/uploads/menus/'.$menuDetails['imageName'].')"';
					}					
				}
				$linkMenuShow	=	'';
				if($menuDetails['showTitle']=='Yes'){
					$linkMenuShow	=	 "<span $classvar>" ."<strong>".$menuDetails['menuName']."</strong></span>";	
				}		//show description
				if($menuDetails['showDesc']=='Yes'){$linkMenuShow	.=	'<p>'. $menuDetails['MenuDesc'].'</p>';}					
				$showItemStatus	=	false;
				// registered user only
				$menuAccess	=	explode(",",$menuDetails['access']);
				$menuUserAccess	=	explode(",",$menuDetails['defAccess']);
				if($menuDetails['access']=='')	$showItemStatus	=	true;	
				else if(in_array('registered',$menuUserAccess)){				
					if($registeredUserID>0){ $showItemStatus	=	true;}			
				}else if(in_array(0,$menuAccess) && count($menuAccess)==1){		// normal user only			
					if(!$registeredUserID){	 $showItemStatus	=	true;	}			
				} else $showItemStatus	=	true;	
				
				if($showItemStatus==true){
					echo $linkMenuShow;		
					$showSubItems	=	$menuDetails['showSubItems'];
				    if($showSubItems=='Yes'){
					 $noOfSubLevelsMenu	=	($menuDetails['numOfLevels']>0)?$menuDetails['numOfLevels']+1:0;
					 $resListMenus	=	 $this->listMenuTree($currentLanguageID,$menuID,0,'menu');
					 if(count($resListMenus)>0){
                                               if(($params['seperator'])!='')
						 echo $linkMenuShow	=	"<ul $classvar $bgImage>";                                                
						 $this->createMenu($currentLanguageID,$params,$resListMenus,$menuAccess,$menuUserAccess,$menuActive,$checkParentActive,$noOfSubLevelsMenu,1,$registeredUserID);
                                                   if(($params['seperator'])!='')
						 echo $linkMenuShow	=	 "</ul>";	//menu end
						 }
					 }//if end for $showSubItems
				}
			} //menu details loop ends
		}//if menudetails end
	}
	private function getSubmenu($menuArr,$relatedMenuLevel)
	{		
		$parra	=	array();
		$parra	=	$this->loopLevelArr($menuArr,$relatedMenuLevel);
		return $parra[0];
	}
	private function loopLevelArr($arr, $level,$i=2){
		$result	=	array();
		foreach($arr as $array){
			if($level==$i && !empty($array['submenu'])){
				$result[]	=	 $array['submenu'];	
				break;
			} else if($array['subItemCount']>0) {
				$results	=	$this->loopLevelArr($array['submenu'],$level,$i+1);				
			} 
			if($results)
			foreach($results as $row){ if(!empty($row)) $result[]=$row;}
		}
		return $result;
	}
	public function showSubMenuLevel($params){
		
		$ObjSession 			= Registry::getInstance('Session');
		$menuActive 	= $ObjSession->getSession("ACTIVE_MENUID");  
                $registeredUserID 			    = $ObjSession->getSession("REGISTERED_USER_ID");
		if($menuActive)
		$bgImage='';
		$parentDet	=	$this->getParentOfOrder($menuActive);
		$menuitemparams	=	 json_decode($parentDet['params'],true);	
		if($menuitemparams['showSectionSubMenu']=='Yes'){
			$checkParentActive	=	array();
			$parentID	=		$params['order']>0?$params['order']:$parentDet['parentID'];
			$menuID		=		$parentDet['menuID'];
			if($menuActive)
			$checkParentActive	=	$this->checkParentActive($menuActive);
			$currentLanguageID	=	$this->languageIDs['Current'];
			$noOfSubLevelsMenu	=	$params['level']>0 ? $params['level']:0;
			$relatedMenuLevel	=	 $parentDet['relatedMenuLevel'];
			$parentID	=		$relatedMenuLevel>0?$menuActive:$parentID;
			$resListMenus	=	 $this->listMenuTree($currentLanguageID,$menuID,$parentID,'menu');
                      //  echo "in".  array_search('19',array_keys($resListMenus));
			if($parentDet['relatedMenuLevel'] > 1){				
				$resListMenus	=	 $this->getSubmenu($resListMenus,$relatedMenuLevel);				
			} 
		 	if(count($resListMenus)>0){
                                if(($params['seperator'])!='')
				 echo $linkMenuShow	=	"<ul $classvar $bgImage>";
				 $this->createMenu($currentLanguageID,$params,$resListMenus,'','',$menuActive,$checkParentActive,$noOfSubLevelsMenu,1,$registeredUserID);
				if(($params['seperator'])!='')
                                 echo $linkMenuShow	=	 "</ul>";	//menu end
			 }
	}//parent>0			
	}
	public function breadcrumb($params){		
		$ObjSession 			= Registry::getInstance('Session');
	   $currentLanguageID	=	$this->languageIDs['Current'];
		$menuActive 	= $ObjSession->getSession("ACTIVE_MENUID");
                $registeredUserID 			    = $ObjSession->getSession("REGISTERED_USER_ID");
		if($menuActive)
		$parentDet	=	$this->getParentOfOrder($menuActive,'mod');
		if($parentDet['showBreadCrumb']=='Yes'){			 
			if($menuActive)
			$checkParentActive	=	($this->checkParentActive($menuActive));
                       
			$checkParentActive	=	(array_reverse(array_filter($checkParentActive)));
			$menuID		=		$parentDet['menuID'];			
			$resListMenus	=	 $this->listMenuTree($currentLanguageID,$menuID,0,'crumb',$menuActive,$checkParentActive);
			 if(count($resListMenus)>0){
				 $this->createBreadCrumb($currentLanguageID,$params,$resListMenus,$menuActive,$registeredUserID);
			 }			
		}
	}

	public function checkParentActive($activeID){
		$sql	=	"SELECT 
						menItmOrdr.parentID,
						(SELECT orderID 
							FROM ".DB_PREFIX."menu_item_order 
						WHERE orderID=menItmOrdr.parentID ) AS activeID,
						(SELECT count(*) 
							FROM ".DB_PREFIX."menu_item_order 
						WHERE orderID=menItmOrdr.parentID ) AS parentCount
					FROM ".DB_PREFIX."menu_item as menItm";
		$sql	.=	" LEFT JOIN " . DB_PREFIX . "menu_item_order as menItmOrdr 
						ON (menItmOrdr.menuItemID=menItm.menuItemID)";
		$sql .= " WHERE 1 AND menItmOrdr.orderID='$activeID' AND menItm.status='Active' ";	
		 $sql .= " ORDER BY menItm.itemOrder 
                    LIMIT 1";
		
		$resParentItems     = $this->ObjDatabase->readValue($sql);	
		$parentactiveIds[]	=	$resParentItems['parentID'];
	  	if($resParentItems['parentCount']>0)	{
			$parentactiveId	=	$this->checkParentActive($resParentItems['activeID']);	
			foreach($parentactiveId as $id)
			$parentactiveIds[]	=	$id;
		}
		
		return $parentactiveIds;
	}
	public function createBreadCrumb($currentLanguageID,$params,$resListMenus,$menuActive,$registeredUserID)
	{		
		
		foreach($resListMenus as $menuItem){
			$check	=	1;
			$menuitemparams	=	array();
			$urlForMenuItem = $linkMenuItem= '';
			//check for class style			
			$classvar	=	($menuActive==$menuItem['keyOrderID'])?'class="active" ':'';			
			//target
			$target	=	($menuItem['target']!='')?'target="'.$menuItem['target'].'" ':'';
			//item name
			$itemcaption =	$menuItem['menuItemName'];
			// create link			
			$hrefelmnt	=	$this->httpURLArr;
			$menuitemparams	=	 json_decode($menuItem['params'],true);	
			//reference id			
			 $sectionIDRef	=	 $menuitemparams['selectedID'];
			// get the module details & reference table details
                         $moduleDetails = array('moduleID'=>$menuItem['moduleID'],'moduleURLKey'=>$menuItem['moduleURLKey'],
                                                'moduleKey'=>$menuItem['moduleKey'],



                                                'moduleSectionKey'=>$menuItem['moduleSectionKey'],
                                                'referenceType'=>$menuItem['referenceType'],
                                                'referenceKey'=>   $menuItem['referenceKey'],
                                                'referenceIDField'=>$menuItem['referenceIDField'],
                                                'referenceField'=>$menuItem['referenceField'],
                                                'referenceValue'=>$menuItem['referenceValue']
                             );			
			$moduleKey	=	$moduleDetails['moduleKey'];
			if($menuItem['params']!='' ){
				//check the reference
				if($moduleDetails['referenceType']!=''){
					$check	=	$this->checkReferenceEnable($moduleDetails,$sectionIDRef);					
				}
				//check for SSL 				
				$hrefelmnt	=	($menuitemparams['enableSSL']=='Yes')?$this->httpsURLArr:$this->httpURLArr;
				//required parameter settings
				$showSectionName	=	$menuitemparams['showSectionName'];
				if($showSectionName=='Yes' && ($moduleKey=='singlepage'  || $moduleKey=='singledealtype' || $moduleKey=='blog')){
					$refDet	=	$this->getReferenceTableDetails($moduleDetails,$sectionIDRef,$currentLanguageID);					
					if($moduleKey=='singlepage'){$itemcaption	=	$refDet['contentTitle'];	
					}else if($moduleKey=='singledealtype'){	$itemcaption	=	$refDet['dealTypeName'];
                                        }else if ($moduleKey=='blog')	{	$itemcaption	=	$refDet['blogTitle'];}				
				}			
			}									//icon for menu item
			//create item link			
			if($moduleKey=='url')
				$urlForMenuItem	=	"http://".ltrim($menuItem['itemLink'],"http://,https://");	
			elseif($moduleKey=='productfilterurl')
				$urlForMenuItem	=	$menuItem['itemLink'];		
			else
				$urlForMenuItem	=	$hrefelmnt.$menuItem['requestPath'];
                        if($menuActive==$menuItem['keyOrderID']) 
                                $linkMenuItem	.=	$itemcaption;	
                        else {
                                $linkMenuItem	.=	" <a href='". $urlForMenuItem."' $classvar $target>".$itemcaption."</a>";
                                if($params['seperator']!='')
                                        $linkMenuItem	.=	"<span class='divider'>".$params['seperator']."</span>";
                        }
			if($check==0 ){		$linkMenuItem	=	'';	}
			// check the item seperator
			if($linkMenuItem!='')	$linkMenuItem	=	"<li $classvar>".$linkMenuItem. "</li>";	
			//check menu access, if menu access = all
			$showItemStatus	=	false;		
			if($menuItem['access']=='')	$showItemStatus	=	true;	
			else if(in_array('registered',(explode(",",$menuItem['defAccess']))) ){	if($registeredUserID>0){	$showItemStatus	=	true; 	}}
			else if(in_array(0,(explode(",",$menuItem['access']))) ){if(!$registeredUserID){$showItemStatus	=	true;}}
			else $showItemStatus	=	true;	
			if($showItemStatus==true && ($moduleKey!='text')){
				echo $linkMenuItem;			
			}
		}//for loop end		 	
	}
	public function createMenu($currentLanguageID,$params,$resListMenus,$menuAccess,$accessKeys,$menuActive,$checkParentActive=array(),$noOfSubLevelsMenu,$levels=1,$registeredUserID)
	{
                $target	=	'';    
		
		foreach($resListMenus as $menuItem){
			$check	=	1;
			$menuitemparams	=	$moduleDetails	=	array();
			$imageICon	=	'';
			$listoutput	=	'';
			$activeclass='';
			$classvar	=	'';
			$urlForMenuItem	='';
			$moduleKey	=	'';
			$moduleDetails='';
			$displayhide	=	'';
			$enableSSL	=	$itemcaption	=	$classvarActive=$hrefelmnt='';
			//check for class style
			if($menuActive==$menuItem['keyOrderID'] || in_array($menuItem['keyOrderID'],$checkParentActive)) {
				$activeclass='active';
				 $classvarActive	=	'class="'.$activeclass.'" ';
			}
			$menuItemStyle	=	($menuItem['cssStyle']!='')?$menuItem['cssStyle'].' ':'';
			if($menuItemStyle!='' || $activeclass!=''){
				 $classvar	=	'class="'.$menuItemStyle.(($activeclass!='')?'current':'').' " ';
                                 if(!($params['seperator'])){
                                    $classvar	=	'class="'.$menuItemStyle.$activeclass.' " ';  
                                 }
			}
			//target
			if($menuItem['target']!=''){$target	=	'target="'.$menuItem['target'].'" ';}
			//item name
			$itemcaption =	$menuItem['menuItemName'];
			$showTitle	=	$menuItem['ShowTitle'];
			//item desc
			$showDesc	=	$menuItem['showDesc'];
			$menuItemDesc	=	$menuItem['menuItemDesc'];
			
			$menuItemIcon	=	$menuItem['iconName'];
			$menuIconPath	=	'/public/uploads/menus/menu-items/';
			$showIcon	=	$menuItem['showIcon'];
			// create link
			
			$hrefelmnt	=	$this->httpURLArr;
			$menuitemparams	=	 json_decode($menuItem['params'],true);	
			//reference id			
			$sectionIDRef	=	 $menuitemparams['selectedID'];                        
			// get the module details & reference table details
			$moduleDetails['moduleID']=	$menuItem['moduleID'];
                        $moduleDetails['moduleURLKey']    =	isset($menuItem['moduleURLKey']) ? $menuItem['moduleURLKey'] : '';
                        $moduleDetails['moduleKey']		  =	isset($menuItem['moduleKey']) ? $menuItem['moduleKey'] : '';
                        $moduleDetails['moduleSectionKey']=	isset($menuItem['moduleSectionKey']) ? $menuItem['moduleSectionKey'] : '';
                        $moduleDetails['referenceType']	  =	isset($menuItem['referenceType']) ? $menuItem['referenceType'] : '';
                        $moduleDetails['referenceKey']	  =	isset($menuItem['referenceKey']) ? $menuItem['referenceKey'] : '';
                        $moduleDetails['referenceIDField']=	isset($menuItem['referenceIDField']) ? $menuItem['referenceIDField'] : '';
                        $moduleDetails['referenceField']  =	isset($menuItem['referenceField']) ? $menuItem['referenceField'] : '';
                        $moduleDetails['referenceValue']  =	isset($menuItem['referenceValue']) ? $menuItem['referenceValue'] : '';
                        
			$moduleKey	=	$moduleDetails['moduleKey'];
			$access	=	'';

			if($menuItem['params']!=''){
				//check the reference
				if($moduleDetails['referenceType']!=''){
					$check	=	$this->checkReferenceEnable($moduleDetails,$sectionIDRef);					
				}
				//check for SSL 

				 $enableSSL	=	isset($menuitemparams['enableSSL'])?$menuitemparams['enableSSL']:'';

				 $hrefelmnt	=	($enableSSL=='Yes')?$this->httpsURLArr:$this->httpURLArr;
				//required parameter settings

				$showTitle	=	($menuitemparams['showSectionName']=='Yes' && $showTitle=='Yes')?$menuitemparams['showSectionName']:$showTitle;
				$showDesc	=	($menuitemparams['showSectionDesc']=='Yes' && $showDesc=='Yes')?$menuitemparams['showSectionDesc']:$showDesc;
				$showIcon	=	($menuitemparams['showSectionImage']=='Yes' && $showIcon=='Yes')?$menuitemparams['showSectionImage']:$showIcon;					
				if($menuitemparams['showSectionName']=='Yes' || $menuitemparams['showSectionDesc']=='Yes' || $menuitemparams['showSectionImage']=='Yes'){
                                    if($moduleKey=='singlepage'  || $moduleKey=='singledealtype' || $moduleKey=='blog'){
                                    $refDet	=	$this->getReferenceTableDetails($moduleDetails,$sectionIDRef,$currentLanguageID);	
                                    }
                                    if($menuitemparams['showSectionName']=='Yes'){// CMS module
                                        if($moduleKey=='singlepage'){$itemcaption	=	$refDet['contentTitle'];	
                                        }else if($moduleKey=='singledealtype'){	$itemcaption	=	$refDet['dealTypeName'];
                                        }else if ($moduleKey=='blog')	{	$itemcaption	=	$refDet['blogTitle'];}	
                                    }
                                    if($menuitemparams['showSectionDesc']=='Yes') {
                                        if($moduleKey=='singlepage'){
                                            $menuItemDesc	=($refDet['introText']!='')?$this->decodeSplChar(substr($refDet['introText'],0,255)):$menuItemDesc;							
                                        }else if($moduleKey=='singledealtype'){
                                            $menuItemDesc	=($refDet['dealTypeDescription']!='')?substr($refDet['dealTypeDescription'],0,255):$menuItemDesc;
                                        }else if ($moduleKey=='blog')	{	$menuItemDesc	=	($refDet['blogContent'])?substr($refDet['blogContent'],0,255):$menuItemDesc;}	
                                    }
                                    if($menuitemparams['showSectionImage']=='Yes') {
                                        if($moduleKey=='singledealtype'){
                                               $menuIconPath	=	'/public/uploads/deal-icons/';
                                               $menuItemIcon	=	'type_'.$refDet['dealTypeID'].'.png';
                                        }
                                    }
				}		
						
			}									//icon for menu item
			if($showIcon=='Yes' && $menuItemIcon!=''){				
					$imageICon	=	'<img src="'.$this->httpImagePath.$menuIconPath.$menuItemIcon.'" />';				
			}
			//create item link
			$activelink	=	'/mkey/'.$menuItem['keyOrderID'].'/';
			$linkMenuItem	=	'';	
			if($showTitle!='Yes'){$itemcaption	=	'';}		
			if($moduleKey=='text' || $moduleKey=='seperator'){
				if($imageICon=='' && $showTitle!='Yes'){ $displayhide	=	'style="display:none;"'; }
				$linkMenuItem	=	"<span $classvar $displayhide> ".$imageICon.$itemcaption;
			} else {
				if($menuItem['iconLinkable']=='Yes'){	
					
					$itemcaption	=	$imageICon.$itemcaption;
				} else {$linkMenuItem	=	$imageICon;		}
				if($moduleKey=='url')
					$urlForMenuItem	=	"http://".ltrim($menuItem['itemLink'],"http://,https://");
				elseif($moduleKey=='productfilterurl')
					$urlForMenuItem	=	$menuItem['itemLink'];		
				else
					$urlForMenuItem	=	$hrefelmnt.$menuItem['requestPath'];
				if($menuItem['defaultPage']=='Yes')
					$urlForMenuItem	=	$hrefelmnt;
				if($showTitle=='Yes' || $imageICon!=''){
					 if($menuItem['descLinkable']=='Yes' && $showDesc=='Yes'){
						 $itemcaption	.=	"<br /><span>".$menuItemDesc."</span>";
					 }
					 $linkMenuItem	.=	" <a href='". $urlForMenuItem."' $classvarActive $target>".$itemcaption."</a>";					 
				} 
			}
                       
			if($check==0 ){		$linkMenuItem	=	'';	}
//show description
			if($showDesc=='Yes' && $check>0 && $menuItem['descLinkable']!='Yes'){
				$linkMenuItem	.=	'<span>'. $menuItemDesc.'</span>';
			}
			if($moduleKey=='text' || $moduleKey=='seperator'){
				$linkMenuItem	.=	"</span> ";
			}
			if(($linkMenuItem!=''))	$linkMenuItem	=	(($params['seperator'])?"<li $classvar>":'').$linkMenuItem;
			//check menu access, if menu access = all
			$showItemStatus	=	false;
			$menuItemAccess	=	explode(",",$menuItem['access']);
			$menuAccessKeys	=	explode(",",$menuItem['defAccess']);
                        if($menuItem['access']=='')	{ $showItemStatus	=	true;	}
			else if(in_array('registered',$menuAccessKeys) ){	if($registeredUserID>0){	$showItemStatus	=	true; 	}}
			else if(in_array(0,$menuItemAccess) ){if(!$registeredUserID){$showItemStatus	=	true;}}
			else $showItemStatus	=	true;	
                        
			if($showItemStatus==true){
				echo $linkMenuItem;
				if(isset($menuItem['submenu']) && count($menuItem['submenu'])>0){
					$showSubmenuItems	=	$menuItem['showSubMenu'];
					//check for sub menu
					if($showSubmenuItems=='Yes'){				
						$noOfSubLevelsMenuItem	=	($menuItem['numOfLevels']>0)?$menuItem['numOfLevels']+1:999;
						$noOfSubLevelsMenuItem	=	($noOfSubLevelsMenu>0)?$noOfSubLevelsMenu:$noOfSubLevelsMenuItem;				
						if($menuItem['subItemCount']>0 && $levels+1 <= $noOfSubLevelsMenuItem){
                                                    if(($params['seperator']!=''))
							echo "<ul>";
							$this->createMenu($currentLanguageID,$params,$menuItem['submenu'],$access,$accessKeys,$menuActive,$checkParentActive,$noOfSubLevelsMenuItem,$levels+1,$registeredUserID);
							if(($params['seperator']!=''))
                                                        echo "</ul>";	
						} 
					}
					
				}
				if($listoutput!='')
					echo $listoutput;
				if(($params['seperator']!=''))
					echo "</li>";	
				
			}
			//$levels++;
		}//for loop end		 	
	}
	public function listMenuTree($currentLanguageID,$menuID,$parentID,$type='menu',$menuActive=0,$crumbids=array())
	{
            $crumbids=array_filter($crumbids);
		$currDateTime  ="NOW()";
		$sql 		= 	"SELECT 
		SQL_CALC_FOUND_ROWS 
			menItm.*,menu_item_details.*,
                        menItmOrdr.orderID as keyOrderID,
                        menItmOrdr.parentID as keyParentID
			,menItmOrdr.defaultPage
		,(SELECT 
			CAST(group_concat(userGroupKey SEPARATOR ',') AS CHAR) 
			FROM ".DB_PREFIX."user_group 
			WHERE 
			FIND_IN_SET(userGroupID,(menItm.access) )) 
			AS defAccess
		,(SELECT count(*) 
			FROM ".DB_PREFIX."menu_item_order
			 WHERE parentID=menItmOrdr.orderID) 
			 AS subItemCount,
                         frnMod.moduleID
                         ,frnMod.moduleURLKey
                         ,frnMod.moduleKey
                         ,frnMod.referenceType
                        ,frnMod.referenceKey
                        ,frnMod.referenceIDField
                         ,frnMod.referenceField
                          ,frnMod.referenceValue
                           ,frnMod.setHomePage
                           ,urlRew.requestPath
		FROM " . DB_PREFIX . "menu_item_order 
			AS menItmOrdr
		JOIN  ".DB_PREFIX."menu_item 
			AS menItm 
		ON (menItmOrdr.menuItemID=menItm.menuItemID)
		JOIN 
			" . DB_PREFIX . "menu_item_details AS menu_item_details
			ON (menItm.menuItemID=menu_item_details.menuItemID 
			AND  (menu_item_details.languageID = ".$currentLanguageID."  OR menu_item_details.languageID = 0)) 
                JOIN 
                    ".DB_PREFIX."frontend_modules AS frnMod 
                        ON
                       (menItm.moduleID=frnMod.moduleID AND  frnMod.moduleStatus='Active')
               LEFT JOIN 
                ".DB_PREFIX."url_rewrite  AS urlRew
                                         ON (
                                            urlRew.objectID = menItm.menuItemID
                                            AND
                                            urlRew.type = 'menu'                                           
                                            AND
                                            isSystem=1
                                            AND
                                            urlRew.languageID =  '".$this->languageIDs['Current']."' 
                                            )
                    
                    
											";
		$sql .= " WHERE 
									IF(menItm.publishDateFrom != '0000-00-00 00:00:00', 
											menItm.publishDateFrom <= ".$currDateTime." 
											,1) 
											AND 
											IF( menItm.publishDateTo!='0000-00-00 00:00:00', 
											 menItm.publishDateTo >=".$currDateTime.",1) 	";
		 $sql .= "AND menItm.status='Active' 
		 					AND menItmOrdr.status='Active' ";
		if(count($crumbids)>0 && $menuActive){
			$sql .= "	AND (menItmOrdr.orderID IN(".implode(",",$crumbids).") 
								OR menItmOrdr.orderID='$menuActive' ) ";				
		}else if($menuActive)	
                    $sql .= "AND  menItmOrdr.orderID='$menuActive'";
                else if(count($crumbids)>0 ){
                     $sql .= " AND (menItmOrdr.orderID IN(".implode(",",$crumbids).")  )";
                }
                
		if($menuID)
			$sql .= "	AND menItmOrdr.menuID='$menuID' ";	
		if(count($crumbids)>0){
                    $crumbidsall = implode(",",$crumbids).','.$menuActive;
                }else {
                    $crumbidsall = $menuActive;
                }
                if($type=='crumb'){
				$sql .= " ORDER BY 
							FIND_IN_SET(menItmOrdr.orderID, '".$crumbidsall."')";
                }
                if(count($crumbids)==0 && $type!='crumb'){
		    $sql .= " GROUP BY menItmOrdr.orderID 
					ORDER BY menItmOrdr.order ";	
		}
                
                $reslistMenus =	$this->ObjDatabase->readValues($sql,MYSQLI_ASSOC);
		if($type=='crumb'){
		 return $reslistMenus;	
		}
		$levels	=	1;
		foreach($reslistMenus as $key=>$value){		
			$menuTree[$reslistMenus[$key]['keyParentID']][] = $reslistMenus[$key];			
		}// for loop end for menu item	
		if($parentID){
				$keyarr	=	$parentID;
		} else {
			$keyarr	=	0;
		}
		$mainTree = $this->createTree($menuTree, $menuTree[$keyarr]);
		//echo "<pre>";print_r($menuTree);	exit;
	return $mainTree;		
	}
	private function createTree(&$list, $parent){
		
		$tree = array();
		if(is_array($parent)) {
			foreach ($parent as $k=>$l){
				if(isset($list[$l['keyParentID']]) && isset($list[$l['keyOrderID']]) ){
					$l['submenu'] = $this->createTree($list, $list[$l['keyOrderID']]);
				}
				$tree[] = $l;
			} 
		}
		return $tree;
	}

	public function checkReferenceEnable($moduleDetails,$referenceIDValue)
	{
		if($moduleDetails['referenceType']=='Table'){
			$referenceTablesArr	=	explode(",",$moduleDetails['referenceKey']);
			$referenceTable	=	$referenceTablesArr[0];
			$sql	=	"SELECT 
								count(*) 
							FROM 
								".DB_PREFIX.$referenceTable." 
							WHERE ".$moduleDetails['referenceField']."='".$moduleDetails['referenceValue']."' ";
			if($moduleDetails['referenceIDField']!='')
				$sql	.=	" AND   ".$moduleDetails['referenceIDField']."='".$referenceIDValue."' ";
			
		} else {
			$sql	=	"SELECT 
								count(*) 
							FROM ".DB_PREFIX."settings 
							WHERE ".$moduleDetails['referenceField']."='".$moduleDetails['referenceValue']."' 
							AND   ".$moduleDetails['referenceIDField']."='".$moduleDetails['referenceKey']."' ";
			
		}
		$sql    .= "LIMIT 1";
		$count	=	 $this->ObjDatabase->readValue($sql);
		return $count[0];
	}
	public function getReferenceTableDetails($moduleDetails,$referenceIDValue,$currentLanguageID,$catList='',$all='')
	{
			$referenceTablesArr	=	explode(",",$moduleDetails['referenceKey']);
			if($catList) { 
				$referenceTable		=	$referenceTablesArr[1];
				$referenceTableDet	=	$referenceTablesArr[2];
			} 
			else {
				$referenceTable		=	$referenceTablesArr[0];
				$referenceTableDet	=	$referenceTablesArr[1];
			}
			$sql	=	"SELECT 
									* 
								FROM 
									".DB_PREFIX.$referenceTable." as table1 
								JOIN 
									".DB_PREFIX.$referenceTableDet."  as table2 
								ON 
									table1.".$moduleDetails['referenceIDField']."= table2.".$moduleDetails['referenceIDField']."
								WHERE 1 ";
			if(!$all) {				
				if($catList)  
				$sql	.=	" AND dealTypeStatus='".$moduleDetails['referenceValue']."' ";
				else					
				$sql	.=	" AND ".$moduleDetails['referenceField']."='".$moduleDetails['referenceValue']."' ";
			}
			$sql	.=	" AND table1.".$moduleDetails['referenceIDField']."='".$referenceIDValue."' 
								AND table2.".$moduleDetails['referenceIDField']."='".$referenceIDValue."' 
								AND   (table2.languageID = ".$currentLanguageID." OR  table2.languageID =0) ";
			$sql	.=	" LIMIT 1";
			$resDet	=	 $this->ObjDatabase->readValue($sql);//echo $sql;
			return $resDet;
	}
	// menu detail;s from menukey
	public function getMenu($menuKey='',$positionkey='',$currentLanguageID) {
		$currDateTime  ="NOW()";
		$sql 		= "SELECT 
							 menu.*,
                                        menDet.menuName,
                                        menDet.MenuDesc,
							(SELECt CAST(group_concat(userGroupKey SEPARATOR ',') AS CHAR) 
							FROM ".DB_PREFIX."user_group 
							WHERE 
							FIND_IN_SET(userGroupID,(menu.access) )) AS defAccess
		 				FROM ".DB_PREFIX."menu as menu
						JOIN " . DB_PREFIX . "menu_details AS menDet
                                        ON (menu.menuID=menDet.menuID 
										AND menDet.languageID = ".$currentLanguageID." )";
						 if($positionkey!='')
		$sql 		.= " LEFT JOIN " . DB_PREFIX . "menu_positions AS menu_positions
                                        ON (menu.positionID=menu_positions.positionID)";						






		$sql 		.= " WHERE                                        
                                        IF(menu.publishFrom != '0000-00-00 00:00:00', 
                                        menu.publishFrom <= ".$currDateTime." 
                                        ,1) 
                                        AND 
                                        IF( menu.publishTo!='0000-00-00 00:00:00', 
                                         menu.publishTo >=".$currDateTime.",1) 										
                                        AND menu.status='Active' ";
		if($menuKey!='')
		$sql .= 	"AND menu.menuKey='".$menuKey."' ";							
		if($positionkey!='')
		$sql .= 	"AND menu_positions.positionKey='".$positionkey."' ";
	
		$reslistMenus =	$this->ObjDatabase->readValues($sql);
		return $reslistMenus;
		}	
	public function getParentOfOrder($order,$mod='')
	{
            $field=$join= "";
            if($mod!=''){
                $field.=    ",frnMod.moduleURLKey";
                $join   =   "JOIN  ".DB_PREFIX."frontend_modules AS frnMod 
                        ON
                       (menItm.moduleID=frnMod.moduleID AND  frnMod.moduleStatus='Active')";
            }
            $sql	=	"SELECT 
						menItmOrdr.parentID,menItmOrdr.menuID,
						menItm.params,menItm.moduleID ,
                                                menItm.relatedMenuLevel,
                                                menItm.showBreadCrumb
                                                ".$field."
					 FROM 
					 	" . DB_PREFIX . "menu_item_order  AS menItmOrdr
					LEFT JOIN
						`".DB_PREFIX."menu_item` AS menItm 
							ON menItm.menuItemID=menItmOrdr.menuItemID
                                                        ".$join."
					WHERE menItmOrdr.orderID='$order' 
                    LIMIT 1";
		
		$resParentID     = $this->ObjDatabase->readValue($sql);	
		return $resParentID;
	}
		
	public function getPageMenuItemStatus($mkey,$languageIDs)
	{
		$currentLanguageID	=	$languageIDs['Current'];
		$sql	=	"SELECT
							menItm.menuItemID,
							menItm.showBreadCrumb
							FROM 
							" . DB_PREFIX . "menu_item AS menItm
							JOIN " . DB_PREFIX . "menu_item_order AS menItmOrdr 
								ON 
								(menItmOrdr.menuItemID=menItm.menuItemID 
								AND menItmOrdr.orderID='$mkey')							
							JOIN " . DB_PREFIX . "menu AS menu 
								ON menu.menuID=menItmOrdr.menuID                                                      
							WHERE 1
							AND menItmOrdr.status='Active' 
							AND menItm.status='Active'
                                                        AND menu.status='Active'
                                                        LIMIT 1";
		$resItem     = $this->ObjDatabase->readValue($sql);	
		return $resItem;
	}
        //added by sariya on 7/2/13
	public function listAllCategoryItems($languageIDs,$showEmptyCategory='',$rootID=0,$moduleKey='')
	{
		$currentLanguageID = $languageIDs['Current'];
		$defaultLanguageID = $languageIDs['Default'];
		$now=date('Y-m-d');
		$subcountlevel	=	0;
		if($moduleKey=='singlecategory'){
			$join   =   " ". DB_PREFIX . "deal_categories AS dealCat ";
		} else {
			$join   =    DB_PREFIX . "deals AS deals  
								INNER JOIN " . DB_PREFIX . "deal_to_category   AS dealToCat 
									ON (deals.dealID=dealToCat.dealID)    
								INNER JOIN ". DB_PREFIX . "deal_categories    AS dealCat 
									ON (dealCat.dealCategoryID=dealToCat.dealCategoryID) ";
		}
		 $sql   =   "SELECT  dealCatdet.dealCategoryName,
							 dealCatdet.dealCategoryDescription,
							 dealCat.dealCategoryImage,
							 dealCat.dealCategoryParent ,
							 dealCat.dealCategoryKey,
							 dealCat.dealCategoryID,
							 dealCat.categoryLevel,
							 (SELECT count(*) FROM " . DB_PREFIX . "deal_categories 
								 WHERE dealCategoryParent=dealCat.dealCategoryID) 
							AS subCount";
		 $sql   .=  " FROM   "  
					.$join.                        
					" JOIN " . DB_PREFIX . "deal_category_details AS dealCatdet 
						ON (dealCatdet.dealCategoryID=dealCat.dealCategoryID 
			AND  dealCatdet.languageID=" . $currentLanguageID . ")   ";
		if($moduleKey!='singlecategory'){ 
				$sql	.=	"INNER JOIN " . DB_PREFIX . "business AS business 
									ON (business.businessID=deals.businessID 
									AND business.businessStatus='Active') 
								LEFT JOIN " . DB_PREFIX . "timezones AS timez 
									ON (deals.dealTimeZone = timez.timeZoneID) 
								LEFT JOIN " . DB_PREFIX . "deal_types AS dealTyp 
									ON (dealTyp.dealTypeID = deals.dealTypeID)
								WHERE 
									deals.dealStatus='Active' 
									AND ((CONVERT_TZ(NOW(),@@session.time_zone,timez.timeZoneDiff) < deals.dealExpiryDate) 
									OR (deals.dealExpiryDate='0000-00-00 00:00:00')) 
									AND ('".$now."' > deals.dealStartTime) 
									AND ('".$now."' < deals.dealEndTime) 
									AND dealTyp.dealTypeStatus='Active' ";       
			   
				$sql .= " AND dealTyp.dealTypeID='" . $rootID . "' ";
			   
		$sql .=  "AND ";
		} else {
				 $sql .= " WHERE "; 
		}
		$sql .= " dealCat.dealCategoryStatus = 'Active'                
				 "; 	

		$sql .= " ORDER BY dealCatdet.dealCategoryName ASC";
		$resCategories = $this->ObjDatabase->readValues($sql);
		foreach($resCategories as $key=>$value){		
			$menuTree[$resCategories[$key]['dealCategoryParent']][] = $resCategories[$key];			
		}// for loop end for menu item			
				$keyarr	=	0;                
		$mainTree = $this->createCatTree($menuTree, $menuTree[$keyarr]);
		//echo "<pre>";print_r($mainTree);
				if($rootID>0 && ($moduleKey=='singlecategory'))
				 $resultArr[] =      $this->getSubCatmenu($mainTree,$rootID);
				else 
					return $mainTree;		
			  //  echo "<pre>";print_r($resultArr);
		return $resultArr;		
	}
    private function getSubCatmenu($menuArr,$rootID)
	{		
		$parra	=	array();
		$parra	=	$this->loopArr($menuArr,$rootID);
		return $parra[0];
	}
	private function loopArr($arr, $level){
		$result	=	array();
		foreach($arr as $key=>$array){
			if($level==$key){
				$result[]	=	 $array;	
				break;
			} else if($array['subCount']>0) {
				$results	=	$this->loopArr($array['subCategories'],$level);				
			} 
			if($results)
			foreach($results as $row){ if(!empty($row)) $result[]=$row;}
		}
		return $result;
	}
	private function createCatTree(&$list, $parent){
		
		$tree = array();
		if(is_array($parent)) {
			foreach ($parent as $k=>$l){                          
				if(isset($list[$l['dealCategoryParent']]) ){
					$l['subCategories'] = $this->createCatTree($list, $list[$l['dealCategoryID']]);
				}
				$tree[$l['dealCategoryID']] = $l;
                        }
			
		}
		return $tree;
	} 
	//Set Admin menu
	public function setAdminMenu($params)
	{
		extract($params);
		
		$treeString	= "";
		$treeLevel		= 0;
		//print_r($privilegeData);
		//MENU SCHEMA
		include_once(__CORE_PUBLIC_SCHEMA_PATH.'/menu.php');
		$params	= array
					(
						'schemaData' 	=> $schemaMenu,				
						'treeString' 	=> $treeString,				
						'treeLevel' 	=> $treeLevel,				
						'languageXml' 	=> $languageXml,				
						'campignEnable' => $campignEnable,			
						'userTypeID' 	=> $userTypeID,			
						'manageUserID' 	=> $manageUserID,
						'_url_path'		=> $_url_path,
						'privilegeData'	=> $privilegeData
					);
		return $this->setAdminMenuItems($params);
	}
	//Set menu Items
	private function setAdminMenuItems($params)
	{
		extract($params);
		
		//last sublevel menu if its parent is in  root
		static $lastMenuItem;
		//Normal limit is 10 including parent,if subcount greater 9,$newBlkLmt=$resSubMenuCount+$blockLimit;
		static $blockLimit;
		//For inner tree level ul li closing
		static $flag;
		//last sublevel menu if its paren having subcount greater 9
		static $endCurrentBlk;
		//If root parent having  one tree level,list sublevels in single block 
		static $singleBlockMenu;
		//blk limit exceeds default block length   
		static $maxBlkLimit	='';
		if($treeLevel==0) 
		{
			$treeString 		= '<ul class="main_menu">';
		}
		else 
		{
			$treeString 		= '<ul class="submenu-list">';
		}
		$treeLevel++;
		if(!empty($schemaData))
		{
			foreach($schemaData as $schema)	
			{
				//print_r($schema);	
				$currMenuURL					= $schema['adminModuleURLKey'];
				$currAdminModuleStyleClass		= $schema['adminModuleStyleClass'];
				$currAdminModuleLabel			= $schema['adminModuleLabel'];
				$currRootLevel					= $schema['rootLevel'];
				$currAdminSectionKey			= $schema['adminSectionKey'];
				$adminModuleStatus				= $schema['adminModuleStatus'];
				$xmlLabel						= $languageXml[$currAdminModuleLabel];
				$currAdminModuleCaption 		= ($xmlLabel!='')?$xmlLabel:$currAdminModuleLabel;				
				$resSubMenuCount 				= count($schema['adminSubMenu']);
				//Exceptions For Main Admin
				if($campignEnable!='' && $currMenuURL=='emailqueue/index/') 
				{
					continue;
				}	
				//Checking Addon Module
				if($currAdminSectionKey!='' && !constant($currAdminSectionKey))
				{
					continue;
				}
				//Checking Status
				if($adminModuleStatus!='Active')
				{
					continue;
				}
				//For Privilege Starts
				if($resSubMenuCount==0 && !empty($privilegeData))
				{
					//Checking Privilege Data. If no Privilege, skip current menu formation
					if($currMenuURL!="" && $currMenuURL!="index/" && !in_array($currMenuURL,$privilegeData))
					{
						continue;
					}
				}				
				//For Privilege ends
				if($currMenuURL!="" && $currMenuURL!="#" && $resSubMenuCount <1 || $currRootLevel=="Yes") 
				{
					$currMenuURL		=	$_url_path.ltrim($currMenuURL,"/");
					if($currRootLevel=="Yes")
					{
						$currAdminModuleStyleClassLi=' style="visibility:hidden;" class="menudrop '.$currAdminModuleStyleClass.'"';
						$currAdminModuleStyleClass='menu_a';
					}
					$currMenuURL 	   		= '<a href="'.$currMenuURL.'" class="'.$currAdminModuleStyleClass.'" >';
					$closeUrl				= '</a>';
				}
				else
				{
					$currMenuURL			= '<h6>';
					$closeUrl				= '</h6>';
				}
				// if submenu count from 2nd tree level of a menu grater than 9,then thats sublevels also comes under same bloack
				if($resSubMenuCount>=10 && $treeLevel>1 && $endCurrentBlk=='')
				{
					$endCurrentBlk			=	$schema[count($schema)-1];
				}
				//Normal limit is 10 including parent,if subcount greater 9,$newBlkLmt=$resSubMenuCount+$blockLimit;
				if($blockLimit!=0)
				{
					$blockLimit				=   $blockLimit+1;
					$newBlkLmt				=	$resSubMenuCount+$blockLimit;
					// $blockLimit!=2 :for avoiding blank block when subcount >9 
					if(($newBlkLmt>$maxBlkLimit) && $blockLimit!=2 && $currRootLevel!="Yes" && $endCurrentBlk=='' && $singleBlockMenu!=0 && $treeLevel==2)
					{
						if($blockLimit>11 && $blockLimit>$maxBlkLimit)
						{
							$maxBlkLimit	= $blockLimit-2;
						}
						$treeString		.= 		'</ul>
														</div>
														<div  class="nav-block">
													<ul>';
						$blockLimit				=		1;
					}
				}
				if($schema==$endCurrentBlk)
				{
					$endCurrentBlk='';
				}
				if($currRootLevel=="Yes")
				{
					$flag					='';
				}								
				$treeString		.= '<li'.$currAdminModuleStyleClassLi.'>';
				$treeString		.= $currMenuURL;
				$treeString		.= ''.$currAdminModuleCaption.'';
				$treeString		.= $closeUrl;	
				//echo $treeString;
				if($currRootLevel=="Yes" && $resSubMenuCount>0)
				{
					$maxBlkLimit=10;
					$lastMenuItem				=	$schema[count($schema)-1];
					//If root parent having  one tree level,list sublevels in single block 
					$singleBlockMenu			=	1;
					if($schema['singleLevel']=="Yes")
					{
						$singleBlockMenu		= 	0;
					}  
					$treeString 				.= '<div  class="navigation-block '.$style.' "><div  class="nav-block">';
					$blockLimit				=	1;
				}				
				if($resSubMenuCount>0)
				{										
					$params	= array
								(
									'schemaData' 		=> $schema['adminSubMenu'],				
									'treeString' 		=> $treeString,				
									'treeLevel' 		=> $treeLevel,				
									'languageXml' 		=> $languageXml,				
									'campignEnable' 	=> $campignEnable,			
									'userTypeID' 		=> $userTypeID,			
									'manageUserID' 		=> $manageUserID,
									'_url_path'			=> $_url_path,
									'blockLimit'		=> $blockLimit,	
									'lastMenuItem'		=> $lastMenuItem,
									'endCurrentBlk'		=> $endCurrentBlk,
									'singleBlockMenu'	=> $singleBlockMenu,
									'flag'				=> $flag,
									'maxBlkLimit'		=> $maxBlkLimit,
									'privilegeData'		=> $privilegeData
								);
					$treeString 		.= $this->setAdminMenuItems($params);						
				}				
				if($flag!=1)
				{
						$treeString	.= '</li>';
				}
				//echo $treeString;
			}
			//echo $treeString;	
		}
		if($flag!=1)
		{
			$treeString 		.= '</ul>';
		}	
		if($lastMenuItem==$schema)
		{
			for($k=2;$k<$treeLevel;$k++)
			{
				$flag		=	1;
				$treeString		.=	' </li></ul>';
			}
			$treeString		.=	' </div></div>';
		}		
		return $treeString;		
	}
}
