<?php
/**   
 * class ThirdPartyMailModel 
 *                                                                             
 * Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.             
 *                                                                                    
 * This  is  commercial  software,  only  users  who have purchased a valid           
 * license  and  accept  to the terms of the  License Agreement can install           
 * and use this program.                                                              
 *                                                                                    
 * PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE           
 * "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.                                                                               
 *                                                                                    
 * Model to manage third party mail integrations. Supported modules are the following 
 * 1) MailChimp                                                                       
 * 2) ExactTarget                                                                     
 * 3) CampaignMonitor                                                                 
 * 4) ConstantContact                                                                 
 *                                                                                    
 * SUPPORTED FUNCTIONS FOR EACH MODULES:                                              
 * 1) Subscribe : mailChimp, campaignMonitor,constantContact                          
 * 2) Create New List : SUPPORTS campaignMonitor & constantContact ONLY               
 * 3) Update List : SUPPORTS campaignMonitor & constantContact ONLY                   
 * 4) Unsubscribe : mailChimp & campaignMonitor ONLY                                  
 * 
 *                                                                                                                    
 * @author Nikhil Ben Kuruvilla <nikhil_ben@ispg.in>       
 * @copyright Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.    
 * @license Please read 'copyright.txt', proprietary License                                                         
 * @package Oorjit Deals   
 * @version ThirdPartyMailModel.PHP, v 1.0 2011/06/14 20:52:11    
 * @todo ExactTarget Integration not yet tested                                                        
 */
class ThirdPartyMailModel extends Model 
{
	private $settings = array();
	private $ObjCampaign;
	private $email;
	private $cityIDs;
	private $action;
	public $subscribeStatus;
	/**
	 * ThirdPartyMailModel
	 *
	 * Get settings value. Initialize campaign library.
	 */
	public function __construct() {

		parent::__construct();

		$this -> settings['api_key'] = $this -> getSettingsValue('campaign_api_key');
		$this -> settings['user_name'] = $this -> getSettingsValue('campaign_user_name');
		$this -> settings['password'] = $this -> getSettingsValue('campaign_password');
		$this -> settings['campaign'] = $this -> getSettingsValue('campaign_name');
		$this -> settings['api_client_id'] = $this -> getSettingsValue('campaign_client_id');
		$this -> settings['default_list_id'] = $this -> getSettingsValue('campaign_default_list_id');
		$this -> settings['newsletter_list_id'] = $this -> getSettingsValue('campaign_newsletter_list_id');
		if($this -> settings['default_list_id']='')
		$this -> settings['default_list_id'] =$this -> settings['newsletter_list_id'];
		$this -> ObjCampaign = new Campaign($this -> settings);
	}

	/**
	 * getSettingsValue
	 *
	 * @param string $settingsKey
	 * @return string $resSettingsValue
	 */
	public function getSettingsValue($settingsKey) {
		$sql	= " SELECT 
						settingsValue 
					FROM 
						" . DB_PREFIX . "settings  
                    WHERE 
                    	settingsKey = '" . $settingsKey . "' ";
		$resSettingsValue = $this -> ObjDatabase -> readValue($sql);
		return $resSettingsValue['settingsValue'];
	}

	/**
	 * thirdPartySubscribe
	 *
	 * NOTE : CONSTANTCONTACT FUNCTIONALITY IS DIFFERENT FROM OTHER SERVICES.
	 * AN EMAIL ID CANNOT BE SIMPLY ADDED TO MULTIPLE LIST, BUT SHOULD BE
	 * UPDATED (BY GIVING NEW AND CURRENT CAMPAIGNLISTIDS). IE, ONCE AN EMAIL ID
	 * IS PRESENT IN ANY OF THE LIST, FOR ADDING IT TO ANOTHER LIST - SHOULD
	 * USE 'UPDATE' THROUGH API INSTEAD OF 'ADD'.
	 * 
	 * mailChimp, campaignMonitor, constantContact
	 * 
	 * @param string $email
	 * @param string $cityID
	 * @return boolean true or false
	 */
	public function thirdPartySubscribe($email, $cityKeyID = '', $listID = '') 
	{

		// NOTE	$cityKeyID HERE CAN BE EITHER CITY_ID OR CITY_KEY_ID ITSELF, BOTH CASES WILL WORK
		if ($listID == '') 
		{
			$listID = $this -> getCurrentListID($cityKeyID);
		}
		if ($this -> settings['campaign'] == 'constant_contact') 
		{// CONSTANT CONTACT ONLY
			$checkContact = $this -> ObjCampaign -> checkContact($email);
			if (count($checkContact) > 1) 
			{// USE UPDATE
				$getContactDetails = $this -> ObjCampaign -> getContactDetails($checkContact['id']);
				// IF SUBSCRIBER IN 'DO NOT MAIL LIST'
				if ($getContactDetails['Status'] == 'Do Not Mail') 
				{
					// SENDS OPT-IN FORM
					$this -> doNotMailOptIn($email);
				} 
				else 
				{
					$campaignListID = $getContactDetails['lists'];
					if ($listID == NULL) 
					{
						$listID = $this -> settings['default_list_id'];
					}
					if (is_array($campaignListID)) 
					{
						array_push($campaignListID, $listID);
					} 
					else 
					{
						$campaignListID = array($listID);
					}
					$ccListID = array_unique($campaignListID);
					$ret= $this -> ObjCampaign -> updateSubscription($checkContact['id'], $email, $ccListID);
				}
			}
		}
// EXTD MAIL START	
		$objDealType	= 	new DealtypeModel();
		$ObjLanguage	= 	new LanguageModel();
        $dealTypeKeysArr= 	$objDealType->listDistinctDealTypeKeys();
		$dealTypeKeys	=	array();
		for($i=0;$i<count($dealTypeKeysArr);$i++)
		{
			$dealTypeKeys[]	=	$dealTypeKeysArr[$i][0];	
		}
		$languageLCIDstring	=   $ObjLanguage-> currentLanguageLCIDstring();
		if ($listID) 
		{
			if($listID==$this -> settings['newsletter_list_id'])
			{
				$sql	= " SELECT 
								lan.LanguageLCIDstring 
							FROM 
								`" . DB_PREFIX . "users` as usr
					 		LEFT JOIN 
					 			" . DB_PREFIX . "languages lan 
					 			ON (lan.languageID = usr.userDefaultLanguage)
                     		WHERE 
                     			userEmail = '".$email."'";
				$emailID = $this -> ObjDatabase -> readValue($sql);
				return $this -> ObjCampaign -> subscribe($listID, $email,array('language' => $emailID['LanguageLCIDstring']));
			}
			else
			{
				return $this -> ObjCampaign -> subscribe($listID, $email,array('subcribedTypes' => $dealTypeKeys,'language' => $languageLCIDstring),$languageLCIDstring);
			}
		} 
		else 
		{
			$defaultID = $this -> settings['default_list_id'];
			return $this -> ObjCampaign -> subscribe($defaultID, $email,array('subcribedTypes' =>$dealTypeKeys,'language' => $languageLCIDstring));
		}
// EXTD MAIL START

	}
	/**
	 * thirdPartyUnsubscribe
	 *
	 * CURRENTLY USED FOR UNSUBSCRIBING USER FROM NEWSLETTER LIST IN THIRDPARTY
	 * 
	 * campaignMonitor, mailCHimp
	 *
	 * @param string $email
	 * @param string $cityKeyID
	 */
	public function thirdPartyUnsubscribe($email, $cityKeyID = '', $listID = '') 
	{
		if ($listID == '') 
		{
			$listID = $this -> getCurrentListID($cityKeyID);
		}
		if ($listID) 
		{
			return $this -> ObjCampaign -> unsubscribe($email, $listID);
		}
		else
		{
			$defaultID = $this -> settings['default_list_id'];
			return $this -> ObjCampaign -> unsubscribe($email, $defaultID);
		}
	}
	/**
	 * manageSubscription
	 *
	 * MANAGES USER CITY SUBSCRIPTIONS AND NEWSLETTER
	 *
	 * subscribes/unsubscribe to list in remote server based
	 * on the requests from user page in 'edit' mode.
	 * 
	 * constantContact, campaignMonitor, mailChimp
	 *
	 * @link /manage/user/edit/
	 * @link /user/edit/
	 * @param string $email
	 * @param array $cityIDs
	 */
	public function manageSubscription($email, $cityIDs = '', $action = '',$subscriptionDealTypes = '') 
	{
		$activeCampaign 	= $this->settings['campaign'];
		$this->email 		= $email;
		$this->cityIDs 		= $cityIDs;
		$this->action 		= $action;
		if ($activeCampaign == 'constant_contact') 
		{// CONSTANT CONTACT
			$this -> manageConstantContactSubscription();
		} 
		elseif ($activeCampaign == 'campaign_monitor' || $activeCampaign == 'mail_chimp') 
		{
			// CAMPAIGN MONITOR AND MAIL CHIMP
			if ($action == 'Yes') 
			{// FOR SUBSCRIBE TO NEWSLETTER OPTION
				$this->thirdPartySubscribe($email);
			} 
			else 
			{
				$this->thirdPartyUnsubscribe($email);
			}
			$currentlySubscribedList 		= $this->getListIdByEmail($email,'Subscribed');
			$currentlySubscribedListCount 	= count($currentlySubscribedList);
			$subscribeList 					= array();
			$unsubscribeList 				= array();
			$currentList 					= array();
			if ($cityIDs == '' && $currentlySubscribedListCount > 0) 
			{// UNSUBSCRIBE ALL
				foreach ($currentlySubscribedList as $subscribedList) 
				{
					$this->thirdPartyUnsubscribe($email, NULL, $subscribedList['cityCampaignListID']);
				}
			} 
			else 
			{
				// GET ALL CAMPAIGN CITY IDS AS ARRAY BASED ON CITY IDS
				$campaignlistID = $this->getCampaignListIDs();
				$j = 0;
				foreach ($currentlySubscribedList as $currentListNew) 
				{// CHANGE TO 1-D ARRAY
					$currentList[$j] = $currentListNew['cityCampaignListID'];
					$j++;
				}
				// GET LISTS TO SUBSCRIBE AS NEW
				$subscribeList = array_diff($campaignlistID, $currentList);
				// GET LISTS TO UNSUBSCRIBE
				$unsubscribeList = array_diff($currentList, $campaignlistID);
				if (count($subscribeList) > 0) 
				{// SUBSCRIBE
					foreach ($subscribeList as $subscribeListNew) 
					{
						$this->thirdPartySubscribe($email, NULL, $subscribeListNew);
					}
				}
				if (count($unsubscribeList) > 0) 
				{// UNSUBSCRIBE
					foreach ($unsubscribeList as $unsubscribeListNew) 
					{
						$this->thirdPartyUnsubscribe($email, NULL, $unsubscribeListNew);
					}
				}
			}
			$this->thirdPartyUpdateCustomField($email,$cityIDs,$subscriptionDealTypes);
// EXTD MAIL END					
			return true;
		} 
		else 
		{
			// OTHER SERVICES LIKE 'EXACT TARGET' GOES HERE, IF WORKING IS UNIQUE TO OTHERS

		}
	}
	/**
	 * getCampaignListIDs
	 *
	 * @return array $campaignlistID
	 */
	private function getCampaignListIDs() 
	{
		$campaignlistID = array();
		$i = 0;
		if(!empty($this->cityIDs))
		{
			foreach ($this->cityIDs as $cityID)
			{
				$campaignlistID[$i] = $this -> getListIDByCityID($cityID);
				$i++;
			}
		}
		return $campaignlistID;
	}
	/**
	 * manageConstantContactSubscription
	 *
	 * MANAGES CONSTANT CONTACT CITY AND NEWSLETTER SUBSCRIPTIONS
	 *
	 * ConstantContact
	 */
	private function manageConstantContactSubscription() {
		$checkContact = $this -> ObjCampaign -> checkContact($this -> email);
		// CHECKS IF CONTACT EXISTS
		if ($checkContact == FALSE) 
		{// ADD AS NEW CONTACT TO 'GENERAL LIST'
			$checkContact['id'] = $this -> ObjCampaign -> subscribe('1', $this -> email);
		}
		$campaignlistID = $this -> getCampaignListIDs();
		$newsLetterID = $this -> settings['newsletter_list_id'];
		if ($this -> action == 'Yes') 
		{// TO UPDATE NEWSLETTER SUBSCRIPTION
			@array_push($campaignlistID, $newsLetterID);
		}
		if (count($campaignlistID) == 0) 
		{
			return $this -> ObjCampaign -> unsubscribe($this -> email);
		}
		// UPDATE ALL SUBSCRIPTIONS
		return $this -> ObjCampaign -> updateSubscription($checkContact['id'], $this -> email, $campaignlistID);
	}
	/**
	 * getListIdByEmail
	 *
	 * @param string $email
	 */
	private function getListIdByEmail($email,$status='All') {
		$cityID = array();
		$sql	= " SELECT 
						cityID 
					FROM 
						`" . DB_PREFIX . "subscribed_cities` AS subCit
    		         LEFT JOIN 
    		         	`" . DB_PREFIX . "subscribers` AS sub
    		          	ON subCit.subscID = sub.subscID
                     WHERE 
                     	sub.subscEmailID = '" . $email . "'";
		if($status!='All')
		{
			$sql	.= " AND subCit.subscStatus='".$status."' ";
		}			  
		$getCityIDs = $this -> ObjDatabase -> readValues($sql);
		foreach ($getCityIDs as $getCityID) 
		{
			$cityID[] = $getCityID['cityID'];
		}
		if(!empty($cityID)){
			$sql	= " SELECT 
							cityCampaignListID 
						FROM 
							`" . DB_PREFIX . "cities`
    		         	 WHERE 
    		         	 	cityID IN (" . implode(',', $cityID) . ")";
			$getListIDs = $this -> ObjDatabase -> readValues($sql);
			return $getListIDs;
		}
	}
	/**
	 * getCurrentListID
	 *
	 * NOTE : IN CASE OF NEWSLETTER, NEWSLETTER LIST ID WILL BE TAKEN INSTEAD OF CITYKEYID.
	 *
	 * @param string  $cityKeyID
	 * @return string $listID
	 */
	private function getCurrentListID($cityKeyID) 
	{
		if ($cityKeyID == '') 
		{
			$listID = $this -> settings['newsletter_list_id'];
		} 
		elseif (is_numeric($cityKeyID)) 
		{// IF CITY_ID INSTEAD OF CITY_KEY_ID
			$listID = $this -> getListIDByCityID($cityKeyID);
		} 
		else 
		{
			$listID = $this -> getListID($cityKeyID, 'Deleted');
			// STATUS EXCEPT 'DELETED'
		}
		return $listID;
	}
	/**
	 * searchExistingCampaigns
	 *
	 * Searches through an array based on key and value.
	 *
	 * @param array $array
	 * @param string $key
	 * @param string $value
	 * @return array $results
	 */
	private function searchExistingCampaigns($array, $key, $value) {

		$results = array();

		if (is_array($array)) 
		{
			if ($array[$key] == $value)
				$results[] = $array;
			foreach ($array as $subarray)
				$results = array_merge($results, $this -> searchExistingCampaigns($subarray, $key, $value));
		}
		return $results;
	}
	/**
	 * createList
	 *
	 * Creates and updates list in the name of cityKeyID
	 *
	 * campaignMonitor, constantContact
	 * @param string $cityKeyID
	 * @return array $listID
	 */
	public function createList($cityKeyID, $cityID = '') 
	{
		if ($this -> settings['campaign'] == 'campaign_monitor') 
		{// CAMPAIGN MONITOR
			$listID 	= $this -> getListIDByCityID($cityID);
			// Create List
			if ($listID == NULL) 
			{
				$listID 	= $this -> ObjCampaign -> createList($cityKeyID, 
							array('clientID' => $this -> settings['api_client_id']));
				if ($listID->http_status_code == 201) 
				{
// EXTD MAIL START					
					$this->createDealTypeCustomeFieldsAndSegments($listID->response);
// WEBHOOK	START			
					$sql	= " SELECT 
									settingsValue 
								FROM 
									" . DB_PREFIX . "settings  
								WHERE 
									settingsKey = 'global_http_url' ";
					$resSettingsValue 			= $this->ObjDatabase->readValue($sql);
					$this->ObjCampaign->createAndActivateWebhook($listID->response,
										$resSettingsValue['settingsValue']);
//WEBHOOK END						
// EXTD MAIL END					
				} 
				// Update List
			} 
			else 
			{
				$listID = $this -> ObjCampaign -> updateList($listID, $cityKeyID);
			}
			$listID = $listID -> response;

		} 
		elseif ($this -> settings['campaign'] == 'constant_contact') 
		{// CONSTANT CONTACT
			$listID = $this -> getListIDByCityID($cityID);
			if ($listID == NULL) 
			{
				$listID = $this -> ObjCampaign -> createList($cityKeyID);
				// Update List
			} 
			else {
				$listID = $this->ObjCampaign->updateList($listID, $cityKeyID);
			}
		}
		return $listID;
	}
	/**
	 * getListID
	 *
	 * Get listID for a given cityKeyID
	 *
	 * @param string $cityID
	 * @param string $status
	 * @return string $listID
	 */
	private function getListID($cityKeyID, $status = '') 
	{
		$sql	= " SELECT 
						cityCampaignListID 
					FROM 
						`" . DB_PREFIX . "cities`
                    WHERE 
                    	`cityKeyID` = '" . $cityKeyID . "'";
		if ($status) {
			$sql	.= " AND cityStatus != 'Deleted'";
		}

		$listID = $this -> ObjDatabase -> readValue($sql);
		return $listID['cityCampaignListID'];
	}

	/**
	 * getListIDByCityID
	 *
	 * Get listID for a given cityID
	 *
	 * @param string $cityID
	 * @return string $listID
	 */
	private function getListIDByCityID($cityID) {
		$sql	= " SELECT 
						cityCampaignListID 
					FROM 
						`" . DB_PREFIX . "cities`
                    WHERE 
                    	`cityID` = '" . $cityID . "'";

		$listID = $this -> ObjDatabase -> readValue($sql);
		return $listID['cityCampaignListID'];
	}
	/**
	 * ListSync
	 *
	 * Syncs the list of cities with list in the server. Invoked each time on
	 * updating/adding API Key details in admin settings.
	 *
     * campaignMonitor, mailChimp, constantContact
	 * 
	 * NOTE : MAIL CHIMP DOES NOT CREATE LISTS IN THEIR SERVER, SHOULD BE DONE 
	 * MANUALLY BEFORE SYNCING. ONLY THE LIST ID AND SUBSCRIBERS GET SYNCED
	 * 
	 * @todo exactTarget
	 * @return boolean true, false
	 */
	public function ListSync($from=0,$limitTo=0) 
	{
		if ($this -> settings['campaign'] == 'campaign_monitor') 
		{
			$listSync = $this -> campaignMonitorListSync($from,$limitTo);
		} 
		elseif ($this -> settings['campaign'] == 'mail_chimp') 
		{
			$listSync = $this -> mailChimpListSync($from,$limitTo);
		} 
		elseif ($this -> settings['campaign'] == 'constant_contact') 
		{
			$listSync = $this -> constantContactListSync($from,$limitTo);
		}
		if ($listSync == 201 || $listSync == 200) 
		{
			return TRUE;
		} else {
			return FALSE;
		}
	}

	/**
	 * campaignMonitorListSync
	 *
	 * SYNC DIRECTION : SYSTEM -> SERVER
	 *
	 * campaignMonitor
	 * 
	 * @uses ListSync()
	 * @return integer $listID->http_status_code
	 */
	public function campaignMonitorListSync($from=0,$limitTo=0) 
	{
		$param = array();
		$param['clientID'] = $this -> settings['api_client_id'];
		$cityKeyID = $this -> getCityKeyIDForList();
		if ($cityKeyID) 
		{
// EXTD MAIL START					
// WEBHOOK	START				
			$sql	= " SELECT 
							settingsValue 
						FROM 
							" . DB_PREFIX . "settings  
						WHERE 
							settingsKey = 'global_http_url' ";
			$resSettingsValue 			= $this->ObjDatabase->readValue($sql);
// WEBHOOK END
// EXTD MAIL END		
			foreach ($cityKeyID as $listName) 
			{
				$listID = $this->ObjCampaign->createList($listName['cityKeyID'], $param);	
				if ($listID -> http_status_code == 201) 
				{
// EXTD MAIL START					
					$this->createDealTypeCustomeFieldsAndSegments($listID->response);
// WEBHOOK	START			
					$this->ObjCampaign->createAndActivateWebhook($listID->response,$resSettingsValue['settingsValue']);
// WEBHOOK END					
// EXTD MAIL END	
					$this -> syncCityWithListID($listID -> response, $listName['cityKeyID']);
				} 
				else 
				{
					return $listID -> http_status_code;
				}
			}
			
		}
		//for newsletter language denpendanat
		$objLanguage	= 	new LanguageModel();
		$resLanguages	= $objLanguage->listLanguages("", "Active");
		for($i=0;$i<count($resLanguages);$i++)
		{
			$options[$i]=$resLanguages[$i][LanguageLCIDstring];
		}
		$fields			=	array(
						  'FieldName'=>'Language',
						  'DataType'=>'MultiSelectMany',
						  'Options'=>$options
						  );
	    $this->ObjCampaign->createListCustomeFields($this -> settings['newsletter_list_id'],$fields);
		
		for($j=0;$j<count($options);$j++)
			{
			$segment_details['Title']		=	$options[$j];
			$segment_details['Rules']		=	array(
														array(
													  		'Subject'=>'[Language]',
															'Clauses'=>array('EQUALS '.$options[$j])
													 		)	
													 );
			$this->ObjCampaign->createSegments($this -> settings['newsletter_list_id'],$segment_details);
			}
			
			
		return $this -> checkCampaignMonitorAPI($from,$limitTo);
	}

	/**
	 * constantContactListSync
	 *
	 * SYNC DIRECTION : SYSTEM -> SERVER
	 *
	 * constantContact
	 * 
	 * @uses ListSync()
	 * @return integer 201, 303
	 */
	public function constantContactListSync($from=0,$limitTo=0) {
		$cityKeyID = $this -> getCityKeyIDForList();

		if ($cityKeyID) {
			foreach ($cityKeyID as $listName) {
				$listID = $this -> ObjCampaign -> createList($listName['cityKeyID'], $param);

				if ($listID > 0) {
					$this -> syncCityWithListID($listID, $listName['cityKeyID']);
				} else {
					return 303;
					// Error
				}
			}
			//return 201;
		}
		return $this->subscriberSync('201',$from,$limitTo);
	}
	/**
	 * getCityKeyIDForList
	 *
	 * Gets all cityKeyIDs which is not synchronised with remote server.
	 *
	 * campaignMonitor
	 * 
	 * @return array  $listID
	 */
	private function getCityKeyIDForList() 
	{
		$sql	= " SELECT 
						cityKeyID 
					FROM 
						`" . DB_PREFIX . "cities`
                    WHERE 
                    	`cityStatus` != 'Deleted'
                      	AND cityCampaignListID = ''";
		$listID = $this -> ObjDatabase -> readValues($sql);
		return $listID;
	}

	/**
	 * syncCityWithListID
	 *
	 * Update table with list Id from server
	 *
	 * @subpackage campaignMonitor
	 * @param string $cityCampaignListID
	 */
	private function syncCityWithListID($cityCampaignListID, $cityKeyID) 
	{
		$sql	= " UPDATE 
						`" . DB_PREFIX . "cities` 
                     SET 
                     	cityCampaignListID = '" . $cityCampaignListID . "'
                    WHERE 
                    	cityKeyID = '" . $cityKeyID . "'";
		$result = $this -> ObjDatabase -> setQuery($sql);
	}

	/**
	 * function checkCampaignMonitorAPI
	 *
	 * Checks whether the API Key entered is correct.
	 *
	 * @return integer $list->http_status_code
	 */
	private function checkCampaignMonitorAPI($from=0,$limitTo=0) 
	{
		$list = $this -> ObjCampaign -> getList();
		return $this -> subscriberSync($list -> http_status_code,$from,$limitTo);

	}

	/**
	 * newsletterSubscriberSync
	 *
	 * Sync user table subscribers. unsubscribe all users in the user table, 
	 * with unsubscribed status in server.
	 *
	 * SYNC DIRECTION : SERVER -> USER TABLE
	 * 
	 * campaignMonitor, mailChimp
	 *
	 * @todo ConstantContact Sync
	 * @param string $email
	 */
	private function newsletterSubscriberSync() 
	{
		$getUnsubscriber = $this -> ObjCampaign -> getUnsubscriberList($this -> settings['newsletter_list_id']);
		if ($this -> settings['campaign'] == 'campaign_monitor') 
		{
			foreach ($getUnsubscriber->response->Results as $response) 
			{
				$result = $this -> updateNewsletterSubscription($response -> EmailAddress);
			}
			return $getUnsubscriber -> http_status_code;

		} 
		elseif ($this -> settings['campaign'] == 'mail_chimp') 
		{
			foreach ($getUnsubscriber as $response) 
			{
				$result = $this -> updateNewsletterSubscription($response['email']);
			}

			return $result;

		} 
		elseif ($this -> settings['campaign'] == 'constant_contact') 
		{

			// CANNOT SYNC WITH CONSTANT CONTACT
		}
	}

	/**
	 * updateNewsletterSubscription
	 *
	 * @param string $userEmail
	 */
	private function updateNewsletterSubscription($userEmail) 
	{
		$sql	= " UPDATE 
						`" . DB_PREFIX . "users`
                    SET 
                    	userNewsletterSubscribeStatus = 'No' 
                    WHERE 
                    	userEmail= '" . $userEmail . "'";

		$result = $this -> ObjDatabase -> setQuery($sql);
	}
	/**
	 * selectNewsletterSubscriberSyncService
	 *
     * campaignMonitor, mailChimp
	 * 
	 * @todo integrate constantContact
	 * @return boolean true,false
	 */
	public function selectNewsletterSubscriberSyncService() 
	{
		$campaign = $this -> settings['campaign'];

		switch ($campaign) 
		{
			case 'campaign_monitor' :
				$unsubscribedList = $this -> getUnsubscriberListForCampaignMonitor();
				break;
			case 'mail_chimp' :
				$unsubscribedList = $this -> getUnsubscriberListForMailChimp();
				break;
			default :
				return false;
				break;
		}
	}
	/**
	 * getUnsubscriberListForCampaignMonitor
	 *
	 *
	 * USED AS CRON TASK, COMPLETE SYNCHRONISATION FOR ALL USERS IN DB
	 *
	 * campaignMonitor
	 * 
	 * @return function  newsletterSubscriberSync
	 */
	private function getUnsubscriberListForCampaignMonitor() 
	{
		$listID = $this -> getAllCampaignListID();
		foreach ($listID as $campaignListID) 
		{
			$getUnsubscriber = $this -> ObjCampaign -> getUnsubscriberList($campaignListID['cityCampaignListID']);
			foreach ($getUnsubscriber->response->Results as $response) 
			{
				$this -> unSubscribeUser($response -> EmailAddress, $campaignListID['cityID']);
			}
		}
		// Newsletter unsubscribe
		return $this -> newsletterSubscriberSync();
	}
	/**
	 * getUnsubscriberListForMailChimp
	 *
	 * Will List all unsubscribers for mailChimp...
	 *
	 * mailChimp
	 * 
	 * @return function  newsletterSubscriberSync
	 */
	private function getUnsubscriberListForMailChimp() 
	{
		$listID = $this -> getAllCampaignListID();
		foreach ($listID as $campaignListID) 
		{
			$getUnsubscriber = $this -> ObjCampaign -> getUnsubscriberList($campaignListID['cityCampaignListID']);
			// Update admin table
			foreach ($getUnsubscriber as $response) 
			{
				$this -> unSubscribeUser($response['email'], $campaignListID['cityID']);
			}
		}
		// Newsletter unsubscribe
		return $this -> newsletterSubscriberSync();
	}
	/**
	 * getAllCampaignListID
	 *
	 * @return array  $listID
	 */
	private function getAllCampaignListID() 
	{
		$sql	= " SELECT 
						cityCampaignListID,
						cityID 
					FROM 
						`" . DB_PREFIX . "cities`
                    WHERE 
                    	`cityStatus` != 'Deleted'
                        AND cityCampaignListID != ''";
		$listID = $this -> ObjDatabase -> readValues($sql);

		return $listID;
	}

	/**
	 * unSubscribeUser
	 *
	 * @param string $subscEmailID
	 * @param integer $cityID
	 * @return integer $resUnsubscribeUser
	 */
	private function unSubscribeUser($subscEmailID, $cityID, $subscStatus = '') 
	{
		if ($subscStatus == '') 
		{
			$subscStatus = 'Unsubscribed';
		}
		$unsubscrDate = ' ,unsubscrDate = NOW() ';
		$sql	= " UPDATE 
						`" . DB_PREFIX . "subscribed_cities` 
                    SET 
                    	subscStatus='" . $subscStatus . "' 
                        " . $unsubscrDate . "
                    WHERE 
                    	subscID IN 
                        (
                        	SELECT 
                        		subscID 
                        	FROM 
                        		`" . DB_PREFIX . "subscribers` 
                            WHERE 
                            	subscEmailID='" . $subscEmailID . "' 
                        ) ";
		if ($cityID != '') 
		{
			$sql	.= " AND cityID IN ('" . $cityID . "')  ";
		}
		$resUnsubscribeUser = $this->ObjDatabase->setQuery($sql);
		return $resUnsubscribeUser;
	}

	/**
	 * mailChimpListSync
	 *
	 * Updates city table with campaign_list_id from server
	 *
	 * SYNC DIRECTION : SERVER -> SYSTEM
	 * 
	 * @uses ListSync()
	 * @return integer 201,303
	 */
	private function mailChimpListSync($from=0,$limitTo=0) 
	{
		$mailChimpList 	= $this -> ObjCampaign -> getList();
		$cityKeyID 		= $this -> getCityKeyIDForList();
		if ($mailChimpList) 
		{
			foreach ($mailChimpList as $list) 
			{
				$listName = $list['name'];
				foreach ($cityKeyID as $cityListName) 
				{
					if ($listName == $cityListName['cityKeyID']) 
					{
						$this -> syncCityWithListID($list['id'], $cityListName['cityKeyID']);
					}
				}
			}
			
		} 
		else 
		{
			return 303;
			// Failed code
		}
// synchronise Subscribers also
	   return $this -> subscriberSync(201,$from,$limitTo);

	}
	/**
	 * subscriberSync
	 * 
	 * Synchronises current system subscribers to ThirdParty
	 * in batch mode. Processed when updating API details in
	 * Admin - Settings for third party client.
	 *
	 * @uses ListSync()
	 * @param integer $statusCode, List Sync response status code. 201 : Success,303 : Failed
	 */
	private function subscriberSync($statusCode,$from=0,$limitTo=0) 
	{
		$campaign 			= $this->settings['campaign'];
		$cityIDs 			= $this->getAllCampaignListID();
		$dealTypeKeys		= array();	
		foreach ($cityIDs as $cityID) 
		{
			$emailIDs 	= $this->getEmailByCityID($cityID["cityID"],$from,$limitTo);
			$listID 	= $this->getListIDByCityID($cityID["cityID"]);
			// BATCH SUBSCRIBE
			$this->ObjCampaign->batchSubscribe($listID, $emailIDs);
		}
		// SYNC NEWSLETTER SUBSCRIBERS
		$newsletterEmailIDs = $this->getAllNewsletterSubscribers();
		$newsletterListID   = $this->settings['newsletter_list_id'];
		$this->ObjCampaign->batchSubscribe($newsletterListID, $newsletterEmailIDs);
		return $statusCode; 
	}
	/**
	 * getAllNewsletterSubscribers
	 * 
	 * @return array $emailIDs
	 */
	private function getAllNewsletterSubscribers() 
	{
		$sql	= " SELECT 
						userEmail AS subscEmailID,
						lan.LanguageLCIDstring 
					FROM 
						`" . DB_PREFIX . "users` as usr
					LEFT JOIN 
						" . DB_PREFIX . "languages lan 
						ON(lan.languageID = usr.userDefaultLanguage)
                    WHERE 
                    	`userNewsletterSubscribeStatus` = 'Yes'";
		$emailIDs = $this -> ObjDatabase -> readValues($sql);
		return $emailIDs;			 
	}
	
    /**
	 * getAllCityID
	 * 
	 * Get CityIDs of all cities with status != 'Deleted'
	 * 
	 * @return array $ciyID
	 */
	private function getAllCityID() 
	{
		$sql	= " SELECT 
						cityID 
					FROM 
						`" . DB_PREFIX . "cities`
                    WHERE 
                    	`cityStatus` != 'Deleted'";
		$cityID = $this -> ObjDatabase -> readValues($sql);
		return $cityID;
	}
	// EXTD MAIL START	- changes	
	/**
	 * getEmailByCityID
	 * 
	 * @param integer $cityID
	 * @return array (string) $emailID and Users subscribed deal type as csv
	 */
	private function getEmailByCityID($cityID,$from=0,$limitTo=0) 
	{
		$sql	= " SELECT 
						subscEmailID,
						language.LanguageLCIDstring,
						GROUP_CONCAT(DISTINCT SDT.dealTypeKey SEPARATOR ',') AS subcribedTypes
					FROM 
						`" . DB_PREFIX . "subscribers` AS sub
					LEFT JOIN 
						`" . DB_PREFIX . "subscribed_cities` AS subscribed_cities  
						ON (sub.subscID = subscribed_cities.subscID 
						AND  subscribed_cities.cityID = '".$cityID."') 
					LEFT JOIN 
						`" . DB_PREFIX . "subscribed_deal_types` AS SDT 
						ON (SDT.subscID = subscribed_cities.subscID)
					LEFT JOIN 
						" . DB_PREFIX . "languages language 
						ON(language.languageID = subscribed_cities.languageID) 
					WHERE 
						subscStatus = 'Subscribed'";
		if($email != '')		
				$sql	.=	" AND sub.subscEmailID = '".$email."' ";  
		$sql	.=  " GROUP BY 
							sub.subscEmailID";
		if($limitTo >0)
		{
			$sql	.=  " LIMIT ".$from." , ".$limitTo."";	
		}
		$emailID = $this -> ObjDatabase -> readValues($sql);
		return $emailID;
	}
// EXTD MAIL End	- changes
	/**
	 * getAllList
	 *
	 * Get all the listIDs as an array..
	 *
	 * @return array $listID
	 */
	public function getAllList() 
	{
		$list 	= $this -> ObjCampaign -> getList();
		$listID = array();
		if ($list) {
			if ($this -> settings['campaign'] == 'campaign_monitor') 
			{
				foreach ($list->response as $campaignMonitorList) 
				{
					$campaignMonitorListID = $campaignMonitorList -> ListID;
					array_push($listID, $campaignMonitorListID);
				}
			} elseif ($this -> settings['campaign'] == 'mail_chimp') 
			{
				foreach ($list as $mailChimpList) 
				{
					$mailChimpListID = $mailChimpList['id'];
					array_push($listID, $mailChimpListID);
				}
			}
			return $listID;
		} 
		else 
		{
			return FALSE;
		}
	}
	/**
	 * updateSubscribeStatus
	 *
	 * ADMIN BULK SUBSCRIBE/UNSUBSCRIBE FUNCTIONALITY
	 *
	 * For managing Subscribe & Unsubscribe functionalities, all unsubscribed or subscribed
	 * user emails get subscribed or unsubscribed in the remote third party server, upon changing
	 * the status in admin control panel.
	 * 
	 * campaignMonitor, mailChimp
	 *
	 * @link /manage/subscriber/
	 * @param string $email
	 * @param string $cityID
	 * @return boolean true or false
	 */
	public function updateSubscribeStatus($email, $status) 
	{
		if ($this -> settings['campaign'] == 'constant_contact') 
		{// FOR CONSTANT CONTACT ONLY
			return $this -> updateConstantContactSubscription($email, $status);
		} 
		else 
		{// FOR MAIL CHIMP AND CAMPAIGN MONITOR
			$getListIDs = $this -> getListIdByEmail($email);
			foreach ($getListIDs as $listID) 
			{
				// Unsubscribe
				if ($listID['cityCampaignListID'] != NULL && $status == 'Unsubscribed') 
				{
					$unsubscribeUser = $this -> ObjCampaign -> unsubscribe($email, $listID['cityCampaignListID']);
					// Re-subscribe
				} 
				elseif($listID['cityCampaignListID'] != NULL && $status == 'Subscribed') 
				{
					$SubscribeUser = $this -> ObjCampaign -> subscribe($listID['cityCampaignListID'], $email);
				}
			}
		}
	}
	/**
	 * updateConstantContactSubscription
	 *
	 * BULK UPDATING OF CONSTANT CONTACT SUBSCRIPTIONS
	 * 
	 * constantContact
	 *
	 * @uses called from $this->updateSubscribeStatus()
	 * @param type $email
	 * @param type $status
	 */
	private function updateConstantContactSubscription($email, $status) 
	{
		$getListIDs 	= $this -> getListIdByEmail($email);
		$checkContact 	= $this -> ObjCampaign -> checkContact($email);
		$getContactDetails 	= $this -> ObjCampaign -> getContactDetails($checkContact['id']);
		$campaignListID 	= $getContactDetails['lists'];
		$newsLetterID 	= $this -> settings['newsletter_list_id'];
		$isNewsletter 	= FALSE;
		if (@in_array($newsLetterID, $campaignListID)) 
		{
			$isNewsletter = TRUE;
			// CHECKS IF ALREADY SUBSCRIBED TO NEWSLETTER
		}
		$unsubscribeListIDs = array();
		$SubscribeListIDs = array();
		foreach ($getListIDs as $listID) 
		{
			// Unsubscribe
			if ($listID['cityCampaignListID'] != NULL && $status == 'Unsubscribed') 
			{
				$unsubscribeListIDs[] 	= $listID['cityCampaignListID'];
				// Re-subscribe
			} 
			elseif ($listID['cityCampaignListID'] != NULL && $status == 'Subscribed') 
			{
				$SubscribeListIDs[] 	= $listID['cityCampaignListID'];
			}
		}
		if (count($SubscribeListIDs) > 0) 
		{
			$this -> ObjCampaign -> updateSubscription($checkContact['id'], $email, $SubscribeListIDs);
		} 
		elseif (count($unsubscribeListIDs) > 0) 
		{
			$this -> ObjCampaign -> unsubscribe($email);
		}
		if ($isNewsletter == TRUE) 
		{// RE-SUBSCRIBES TO NEWSLETTER
			$this -> ObjCampaign -> updateSubscription($checkContact['id'], $email, array($newsLetterID));
		}
	}
	/**
	 * getAllSubscribedCampaignListID
	 *
	 * Returns all campaignListIDs for a particular emailId, Used for constantContact
	 * Subscription process only.
	 *
	 * DEPRECATED : NOT CURRENTLY USED
	 *
	 * @subpackage constantContact
	 * @deprecated deprecated since version 1.0
	 * @param char $emailID
	 * @return array $campaignListID
	 */
	private function getAllSubscribedCampaignListID($emailID) 
	{
		$sql	= " SELECT 
						cityCampaignListID 
					FROM 
						`" . DB_PREFIX . "cities` AS cit
                    LEFT JOIN 
                    	`" . DB_PREFIX . "subscribed_cities` AS subCit 
                        ON  cit.cityID = subCit.cityID
                    LEFT JOIN 
                    	`" . DB_PREFIX . "subscribers` AS sub
                        ON subCit.subscID = sub.subscID
                   	WHERE 
                   		sub.subscEmailID = '" . $emailID . "'
                        AND subCit.subscStatus = 'Subscribed'";
		$resCampaignListID = $this -> ObjDatabase -> readValues($sql);
		$campaignListID = array();
		for ($i = 0; $i < count($resCampaignListID); $i++) 
		{
			$campaignListID[$i] = $resCampaignListID[$i]['cityCampaignListID'];
		}
		return $campaignListID;
	}

	/**
	 * checkAlreadySubscribed
	 *
	 * Checks whether a user is already subscribed in constantcontact.
	 * 
	 * ONLY USED FOR CONSTANT CONTACT
	 *
	 * @param char $emailID
	 * @return char 'Active' or 'Removed'
	 */
	public function checkAlreadySubscribed($emailID, $cityKeyID) 
	{
		if ($this -> settings['campaign'] == 'constant_contact') 
		{// CONSTANT CONTACT ONLY
			$checkContact 		= $this -> ObjCampaign -> checkContact($emailID);
			$getContactDetails 	= $this -> ObjCampaign -> getContactDetails($checkContact['id']);
			$campaignListID 	= $this -> getListID($cityKeyID);
			$contactLists 		= $getContactDetails['lists'];
			$checkContactStatus = 'Removed';
			// CHECKS IF THE CONTACT IS ALREADY SUBSCRIBED TO THE LIST
			if (@in_array($campaignListID, $contactLists)) 
			{
				$checkContactStatus = 'Active';
			}
			return $checkContactStatus;
		}
	}

	/**
	 * sync
	 *
	 * SYNCHRONISES SUBSCRIBERS , SYNC DIRECTION : REMOTE -> SYSTEM
	 *
	 * Updates all unsubscribed users in current system, when the
	 * user profile is taken in 'edit' mode through admin or frontend
	 * interface.
	 * 
	 * constantContact, campaignMonitor, mailChimp
	 *
	 * @link /user/edit/
	 * @link /manage/user/edit/
	 * @param type $email
	 */
	public function sync($userID) 
	{
		$email 				= $this->getMailIdByUserID($userID);
		$campaign 			= $this->settings['campaign'];
		$oldCampaignListIDs = $this->getListIdByEmail($email);
		$dbCampaignListIDs 	= array();
		if (count($oldCampaignListIDs) > 0) 
		{// GET CAMPAIGN LIST IDS IN DB TO 1-D ARRAY
			$k 					= 0;
			foreach ($oldCampaignListIDs as $currentListIDs) 
			{
				$dbCampaignListIDs[$k]			= $currentListIDs['cityCampaignListID'];
				$k++;
			}
		}
		switch ($campaign) 
		{
			case 'constant_contact' :
			// CONSTANT CONTACT
				$this->syncConstantContact($email, $dbCampaignListIDs);
				break;
			case 'campaign_monitor' :
			// CAMPAIGN MONITOR
				$this->syncCampaignMonitor($email, $dbCampaignListIDs);
				break;
			case 'mail_chimp' :
			// MAIL CHIMP
				$this->syncMailChimp($email, $dbCampaignListIDs);
				break;
			default :
				break;
		}
	}

	/**
	 * syncConstantContact
	 *
	 * CONSTANT CONTACT SUBSCRIBER SYNCHRONISATION
	 *
	 * @uses Called from $this->sync()
	 * @param string $email
	 * @param array $dbCampaignListIDs
	 */
	private function syncConstantContact($email, $dbCampaignListIDs) 
	{
		$checkContact 		= $this -> ObjCampaign -> checkContact($email);
		$getContactDetails 	= $this -> ObjCampaign -> getContactDetails($checkContact['id']);
		$campaignListIDs 	= $getContactDetails['lists'];
		$newsLetterID 		= $this -> settings['newsletter_list_id'];
		$unsubscribeNewsletter = TRUE;
		if (@in_array($newsLetterID, $campaignListIDs)) 
		{
			$unsubscribeNewsletter = FALSE;
		}
		// UNSUBSCRIBED USERS NOT UPDATED IN DB
		$unsubscribeLists = @array_diff($dbCampaignListIDs, $campaignListIDs);
		if (count($unsubscribeLists) > 0) 
		{// CHANGE TO UNSUBSCRIBED STATUS
			foreach ($unsubscribeLists as $unsubscribeListID) 
			{
				$cityID = $this -> getCityIdFromListID($unsubscribeListID);
				$this -> unSubscribeUser($email, $cityID);
			}
		}
		$status=$this->getUserInfoForSubscription($email);
		if ($status[0]['userNewsletterSubscribeStatus']=='No' ) 
		{// UNSUBSCRIBE FROM NEWSLETTER
			$this -> updateNewsletterSubscription($email);
		}
	}

	/**
	 * syncCampaignMonitor
	 *
	 * CAMPAIGN MONITOR SUBSCRIBER SYNCHRONISATION
	 *
	 * @uses Called from $this->sync()
	 * @param string $email
	 * @param array $dbCampaignListIDs
	 */
	private function syncCampaignMonitor($email, $dbCampaignListIDs) 
	{
		// UNSUBSCRIBE FROM CITIES
		foreach ($dbCampaignListIDs as $campaignListID) 
		{
			$getUnsubscriber		= $this->ObjCampaign -> getUnsubscriberList($campaignListID);
			$subscribers			= $this->ObjCampaign -> getSubscriberList($campaignListID);
			$cityID 				= $this->getCityIdFromListID($campaignListID);
			
			
			if($getUnsubscriber->response->Results)
			{			
				foreach ($getUnsubscriber->response->Results as $response) 
				{
					if ($response->EmailAddress == $email) 
					{
						$this->unSubscribeUser($email, $cityID);
					}
				}
			}
			
			if($subscribers->response->Results)
			{			
				foreach ($subscribers->response->Results as $response) 
				{
					if ($response->EmailAddress == $email) 
					{
						$this->updateSubscribedStatusFromApiToSys($email, $cityID);
					}
				}
			}
			
			
		}
		// UNSUBSCRIBE FROM NEWSLETTER
		$getUnsubscriber	= $this->ObjCampaign->getUnsubscriberList($this->settings['newsletter_list_id']);
		// EXTD MAIL START		
		if($getUnsubscriber->response->Results)
		{
			foreach ($getUnsubscriber->response->Results as $response) 
			{
				if ($response -> EmailAddress == $email) 
				{
					$this -> updateNewsletterSubscription($email);
				}
			}
		}
		// EXTD MAIL END
		
				
		// UNSUBSCRIBE FROM NEWSLETTER
		$getSubscriber	= $this->ObjCampaign->getSubscriberList($this->settings['newsletter_list_id']);
		// EXTD MAIL START		
		if($getSubscriber->response->Results)
		{
			foreach ($getSubscriber->response->Results as $response) 
			{
				if ($response -> EmailAddress == $email) 
				{
					$this -> updateSubscribedStatusFromApiToSys($email);
				}
			}
		}
		// EXTD MAIL END		
		
	}

	/**
	 * syncMailChimp
	 *
	 * MAIL CHIMP SUBSCRIBER SYNCHRONISATION
	 *
	 * Updates all unsubscribed users in current system, when the user profile is taken
	 * in 'edit' mode through admin or frontend interface.
	 *
	 * @uses Called from $this->sync()
	 * @param string $email
	 * @param array  $dbCampaignListIDs
	 */
	private function syncMailChimp($email, $dbCampaignListIDs) 
	{
		
		// UNSUBSCRIBE FROM CITIES
		foreach ($dbCampaignListIDs as $campaignListID) 
		{
			$getUnsubscriber 	= $this->ObjCampaign->getUnsubscriberList($campaignListID);
			$subscribers		= $this->ObjCampaign ->getSubscriberList($campaignListID);
			$cityID 			= $this->getCityIdFromListID($campaignListID);
			
			if($getUnsubscriber)
			{
				foreach($getUnsubscriber as $response) 
				{
					if ($response['email'] == $email) 
					{
						$this->unSubscribeUser($email, $cityID);
					}
				}
			}
		}
		
		if($subscribers)
			{			
				foreach ($subscribers as $response) 
				{
					if ($response['email'] == $email) 
					{
						$this->updateSubscribedStatusFromApiToSys($email, $cityID);
					}
				}
			}
		// UNSUBSCRIBE FROM NEWSLETTER
		$getUnsubscriber	= $this->ObjCampaign->getUnsubscriberList($this -> settings['newsletter_list_id']);
		if($getUnsubscriber)
		{		
			foreach ($getUnsubscriber as $response) 
			{
				if ($response['email'] == $email) 
				{
					$this->updateNewsletterSubscription($email);
				}
			}
		}
		
		// UNSUBSCRIBE FROM NEWSLETTER
		$getSubscriber	= $this->ObjCampaign->getSubscriberList($this->settings['newsletter_list_id']);
		// EXTD MAIL START		
		if($getSubscriber)
		{
			foreach ($getSubscriber as $response) 
			{
				if ($response['email'] == $email) 
				{
					$this -> updateSubscribedStatusFromApiToSys($email);
				}
			}
		}
		
	}

	/**
	 * getMailIdByUserID
	 *
	 * @param type $userID
	 */
	private function getMailIdByUserID($userID) 
	{
		$sql	= " SELECT 
						userEmail 
					FROM 
						`" . DB_PREFIX . "users`
                  	WHERE 
                  		`userID` = '" . $userID . "'";
		$emailID = $this -> ObjDatabase -> readValue($sql);
		return $emailID['userEmail'];
	}

	/**
	 * getCityIdFromListID
	 *
	 * @param type $cityCampaignListID
	 * @return type
	 */
	private function getCityIdFromListID($cityCampaignListID) 
	{
		$sql	= " SELECT 
						cityID 
					FROM 
						`" . DB_PREFIX . "cities`
                    WHERE 
                    	`cityCampaignListID` = '" . $cityCampaignListID . "'";
		$listID = $this -> ObjDatabase -> readValue($sql);
		return $listID['cityID'];
	}

	/**
	 * doNotMailOptIn
	 *
	 * CONSTANT CONTACT DO NOT MAIL LIST RE-SUBSCRIPTION
	 *
	 * All users who unsubscribes normally through constant contact,
	 * will be set to 'Do Not Mail' list by default. Such users cannot
	 * be simply re-subscribed using API. They need to sign up through
	 * constant contact provided form.
	 *
	 * NOTE : THE RE-SUBSCRIBE FORM VARIES ACCORDING TO EACH CLIENT
	 *
	 * @param string $email
	 */
	private function doNotMailOptIn($email) 
	{
		$body		= $this -> getSettingsValue('campaign_optin_html');
		$fromEmail	= $this -> getSettingsValue('contact_email');
		$fromName	= $this -> getSettingsValue('site_name');
		$subject	= $this -> getSettingsValue('campaign_optin_subject');
		$headers	= "MIME-Version: 1.0" . "\r\n";
		$headers	.= "Content-type:text/html;charset=iso-8859-1" . "\r\n";
		$headers	.= 'From: '.$fromName.'<'.$fromEmail.'>' . "\r\n";
		mail($email,$subject,$body,$headers);
		$this -> subscribeStatus = 'DoNotMail';
		return TRUE;
	}
	/**
	 * debug
	 *
	 * FOR DEBUGGING PURPOSE ONLY
	 *
	 * @param $value
	 */
	public function debug($value) 
	{
		echo "<pre>";
		var_dump($value);
		exit ;
	}
	
// EXTD MAIL START
/*
	 * function createList Custom Fields and Segments
	 *
	 * 
	 * @param  $listID
	 * @package campaignMonitor
*/
	public function createDealTypeCustomeFieldsAndSegments($cityCampaignListID) 
	{
		$objDealType	= 	new DealtypeModel();
		$objLanguage	= 	new LanguageModel();
        $dealTypeKeysArr= 	$objDealType->listDistinctDealTypeKeys();
		$dealTypeKeys	=	array();
		for($i=0;$i<count($dealTypeKeysArr);$i++)
		{
			$dealTypeKeys[]	=	$dealTypeKeysArr[$i][0];	
		}		
		$fields			=	array(
								  'FieldName'=>'DealType',
								  'DataType'=>'MultiSelectMany',
								  'Options'=>$dealTypeKeys
								  );
		$this->ObjCampaign->createListCustomeFields($cityCampaignListID,$fields);
		$resLanguages    = $objLanguage->listLanguages("", "Active");
		for($i=0;$i<count($resLanguages);$i++)
		{
			$options[$i]=$resLanguages[$i][LanguageLCIDstring];
		}
		$fields			=	array(
						  'FieldName'=>'Language',
						  'DataType'=>'MultiSelectMany',
						  'Options'=>$options
						  );
	    $this->ObjCampaign->createListCustomeFields($cityCampaignListID,$fields);	
		for($i=0;$i<count($dealTypeKeys);$i++)
		{
			for($j=0;$j<count($options);$j++)
			{
			$segment_details['Title']		=	$dealTypeKeys[$i]."-".$options[$j];
			$segment_details['Rules']		=	array(
													  array(
													  		'Subject'=>'[DealType]',
															'Clauses'=>array('EQUALS '.$dealTypeKeys[$i])
													 		),
														array(
													  		'Subject'=>'[Language]',
															'Clauses'=>array('EQUALS '.$options[$j])
													 		)	
													 );
			$this->ObjCampaign->createSegments($cityCampaignListID,$segment_details);
			}
		}	
	}
/*
	 * function Update SubcribersCustom field for all city lists
	 *
	 * 
	 * @param  $email
	 * @param  $cityIDs
	 * @param  $subscriptionDealTypes	 	 
	 * @cityIDs
	 * @package campaignMonitor
*/
	public function thirdPartyUpdateCustomField($email,$cityIDs,$subscriptionDealTypes = '') 
	{	
		$ObjLanguage			= 	new LanguageModel();
		$languageLCIDstring     =   $ObjLanguage-> currentLanguageLCIDstring();
		$campaignlistID			= array();
		if(!empty($cityIDs))
		{
			foreach ($cityIDs as $cityID) 
				$campaignlistID[] = $this->getListIDByCityID($cityID);
		}
		foreach ($campaignlistID as $subscribedListID) 
		{
			
			$this->ObjCampaign->updateCustomField($email,$subscribedListID,$subscriptionDealTypes,$languageLCIDstring);
		}	
	}	
	function getUserInfoForSubscription($email)
    {
    	$sql	= " SELECT 
    					userNewsletterSubscribeStatus 
					FROM 
						`" . DB_PREFIX . "users` 
					WHERE 
						userEmail='" . $email . "'  
						AND userStatus='Active'";
        $resUserInfo = $this->ObjDatabase->readValue($sql);
        return $resUserInfo;
    }
	// EXTD MAIL END
	//Email tracking
	public function updateCampaigns()
	{
		$allCampaigns = $this->getAllCampaigns();
		if(count($allCampaigns)>0)
		{
			foreach ($allCampaigns as $campaign)
			{
				$currentCampaignId	= $campaign['thirdPartyCampaignID'];	
				$result = $this->ObjCampaign->updateCampaign($currentCampaignId);
				$result['openCount']			=	($result['openCount']=='') ? '0'  : $result['openCount'];
				$result['clickCount']			=	($result['clickCount']=='') ? '0'  : $result['clickCount'];
				$result['bounceCount']			=	($result['bounceCount']=='') ? '0'  : $result['bounceCount'];
				$result['uniqueOpenedCount']	=	($result['uniqueOpenedCount']=='') ? '0'  : $result['uniqueOpenedCount'];
				$result['unsubscribedCount']	=	($result['unsubscribedCount']=='') ? '0'  : $result['unsubscribedCount'];
				$result['forwardsCount']		=	($result['forwardsCount']=='') ? '0'  : $result['forwardsCount'];
				$sqlUpdateCampagain='';
				if(count($result)>0)
				{
				
					$sqlUpdateCampagain .= ($result['openCount'] > 0) ? " , openCount = '" . $result['openCount'] . "'" : "";
	            	$sqlUpdateCampagain .= ($result['clickCount'] > 0) ? " , clickCount = '" . $result['clickCount'] . "'" : "";
	            	$sqlUpdateCampagain .= ($result['bounceCount'] >0 ) ? " , bounceCount = '" . $result['bounceCount'] . "'" : "";
	            	$sqlUpdateCampagain .= ($result['uniqueOpenedCount'] >0 ) ? " , uniqueOpenedCount = '" . $result['uniqueOpenedCount'] . "'" : "";
	            	$sqlUpdateCampagain .= ($result['unsubscribedCount'] >0 ) ? " , unsubscribedCount = '" . $result['unsubscribedCount'] . "'" : "";
	            	$sqlUpdateCampagain .= ($result['forwardsCount'] >0 ) ? " , forwardsCount = '" . $result['forwardsCount'] . "'" : "";
					if($sqlUpdateCampagain!='')
					{
						$sql	= " UPDATE 
										`" . DB_PREFIX . "campaigns` 
									SET 
										campaignID=".$campaign['campaignID'].$sqlUpdateCampagain." 
									WHERE 
										campaignID=".$campaign['campaignID'];
						$resUpdateCampagain = $this->ObjDatabase->setQuery($sql);
					}
				}
			}
		}
		else
		{
			return 'No Campaigns Found';
		}
	}
	
	private function getAllCampaigns() 
	{
		$sql	= " SELECT 
						campaignID,
						thirdPartyCampaignID 
					FROM 
						`" . DB_PREFIX . "campaigns`";
		$resCampaigns = $this -> ObjDatabase -> readValues($sql);
		return $resCampaigns;
	}
	
	private function updateSubscribedStatusFromApiToSys($subscEmailID, $cityID=0) 
	{
		if($cityID >0)
		{
		$sql	= " UPDATE 
						`" . DB_PREFIX . "subscribed_cities` 
                    SET 
                    	subscStatus='Subscribed',
                    	subscribedDate=NOW() 
                    WHERE 
                    	subscID IN 
                               (
                               	SELECT 
                               		subscID 
                               	FROM 
                               		`" . DB_PREFIX . "subscribers` 
                               	WHERE 
                               		subscEmailID='" . $subscEmailID . "' 
                               	) ";
		if ($cityID != '') 
		{
			$sql	.= " AND cityID IN ('" . $cityID . "')  ";
		}
		$resUnsubscribeUser = $this->ObjDatabase->setQuery($sql);
		}
		else
		{
			$sql	= " UPDATE 
							`" . DB_PREFIX . "users` 
                        SET 
                        	userNewsletterSubscribeStatus='Yes'
                       	WHERE 
                       		userEmail = '".$subscEmailID."'";
			$resUnsubscribeUser = $this->ObjDatabase->setQuery($sql);				   
		}
		return $resUnsubscribeUser;
	}
	
	public function syncThirdPartyUnsubascribe($userIds)
	{
		$ObjThirdParty = new ThirdPartyMailModel();
		if(count($userIds)>0)
		{
			foreach ($userIds as $userId)
			{
				$sql	= " SELECT 
								userNewsletterSubscribeStatus,
								userEmail 
							FROM 
								" .DB_PREFIX."users 
							WHERE 
								userID='".$userId."'";
				$resUser = $this -> ObjDatabase -> readValue($sql);
				if($resUser['userNewsletterSubscribeStatus']=='Yes')
				{
					$this->thirdPartyUnsubscribe($resUser['userEmail']);
					$sql	= " UPDATE 
									" . DB_PREFIX . "users 
								SET 
									userNewsletterSubscribeStatus='No' 
								WHERE 
									userID ='".$userId."'";
					$resUnsubscribeUser = $this->ObjDatabase->setQuery($sql);
				}
				$sql	= " SELECT 
								cityCampaignListID,
								subCit.citySubscID 
							FROM 
								" .DB_PREFIX."cities cit 
							INNER JOIN 
								".DB_PREFIX."subscribed_cities as subCit 
								ON(subCit.cityID=cit.cityID 
								AND subCit.subscStatus='Subscribed') 
							INNER JOIN 
								".DB_PREFIX."subscribers as sub 
								ON(sub.subscID=subCit.subscID 
								AND sub.userID='".$userId."')";
				$resCities = $this -> ObjDatabase -> readValues($sql);
				foreach ($resCities as $city)
				{
					$this->thirdPartyUnsubscribe($resUser['userEmail'],'',$city['cityCampaignListID']);
					$sql	= " UPDATE 
									" . DB_PREFIX ."subscribed_cities 
								SET 
									subscStatus='Unsubscribed' 
								WHERE  
									citySubscID ='".$city['citySubscID']."'";
					$resUnsubscribeUser = $this->ObjDatabase->setQuery($sql);
				}
				
			}		
		}
	}
	/**
	 * createListBulkID
	 *
	 *
	 * campaignMonitor, constantContact
	 * @param string $bulkKey
	 * @return array $listID
	 */
	public function createListBulkID($bulkKey) 
	{
		if ($this -> settings['campaign'] == 'campaign_monitor') {
			$listID = $this -> ObjCampaign -> createList($bulkKey, array('clientID' =>'f34c015511c683e704a4039068b7030f' ));

			if ($listID->http_status_code == 201) 
			{
				$this->createDealTypeCustomeFieldsAndSegments($listID->response);
				$sql	= " SELECT 
								settingsValue 
							FROM 
								" . DB_PREFIX . "settings  
							WHERE 
								settingsKey = 'global_http_url' ";
				$resSettingValue 			= $this->ObjDatabase->readValue($sql);
				$this->ObjCampaign->createAndActivateWebhook($listID->response,$resSettingValue['settingsValue']);
			} 
			$listID = $listID -> response;
		} 
		elseif ($this -> settings['campaign'] == 'constant_contact') 
		{
				$listID = $this -> ObjCampaign -> createList($bulkKey);
		}
		return $listID;
	}
	//END : FUNCTION createListBulkID	
//End Email tracking
//START : FUNCTION to mail the imported users
	public function scheduleMailList($listID,$emailIDs,$options,$settings)
	{
		$responseReturn=array();
		$campaignDate=$settings['campaignDate'];
		$sub=(array)$this->ObjCampaign->batchSubscribe($listID, $emailIDs);
		if($sub['http_status_code']==201)
		{
			$currTimeZone 					= $settings['timezone'];
			$objTimeZone  					= new TimezoneModel();
			$timeZoneDiff 					= $objTimeZone->getTimezoneDetails($currTimeZone);
			$countShedulesCities			= 0;
				
		if($this -> settings['campaign'] == 'mail_chimp')
		{
			$errMessage						= '';
			$createResult                 	= $this->ObjCampaign->createCampaign($options);
			if ($createResult['status'] == 'success') 
			{
				$campaignID   				= $createResult['response'];
				$scheduleResult      		= $this->ObjCampaign->scheduleCampaign($campaignID, $campaignDate);
				$responseReturn['status']='success';		
			} 
			else 
			{
				$response		 = $createResult['response'];
				$errMessage    	.= 'Campaign not sheduled ';
				$errMessage 	.= $response->Code . ' : ' . $response->Message.' <br> ' ;
				$responseReturn['status']='';	
			}	
		}
		else if($this -> settings['campaign']=='campaign_monitor')
		{
			$errMessage		= '';
			$createResult	= $this->ObjCampaign->createCampaign($options); 
			if ($createResult['status'] == 'success') 
			{
				
				$campaignID					= $createResult['response'];
				$scheduleResult				= $this->ObjCampaign->scheduleCampaign($campaignID, $campaignDate);
				$responseReturn['status']	='success';	
			}
			else 
			{
				$response					= $createResult['response'];
				$errMessage					.= 'Campaign not created for '.$sheduleTo.' => ';
				$errMessage					.= $response->Code . ' : ' . $response->Message.' <br> ' ;
				$responseReturn['status']	='';	
			}
			$message=$errMessage;				
		}			
		else
		{
			$result		= $this->ObjCampaign->createCampaign($options);
			if ($result['status'] == 'success') 
			{
				$campaignID   					= $result['response'];
				$currTimeZone 					= $settings['timezone'];
				$timeZoneDiff 					=$settings['timeZoneDiff'];
				$res          					= $this->ObjCampaign->scheduleCampaign($campaignID, $campaignDate, $timeZoneDiff['timeZoneDiff']);
				if ($res['status'] == 'success') 
				{
					$POST['dealID']       			= $dealID;
					$POST['cityID']       			= $cityID;
					$POST['campaignDate'] 			= $campaignDate;
					$POST['dealTypeKey'] 			= $dealTypeKey;
					$ObjDeal->saveDealCampaign($POST);
					$message 		= "Campaign scheduled successfully";

				}
				else 
				{
					$response						= $res['response'];
					if ($response->Code == 303) 
					{
						$message 					= $response->Code . ' : Campaign already created for this deal';
					} 
					else 
					{
						$message 					= $response->Code . ' : ' . $response->Message;
					}

				}
				$responseReturn['status']='success';	
			} 
			else 
			{
				$response 						= $result['response'];
				if ($response->Code == 303) 
				{
					$message 						= $response->Code . ' : Campaign already created for this deal';
				} 
				else 
				{
				
					$message 						= $response->Code . ' : ' . $response->Message;
				}
				$responseReturn['status']='';	
			}				
		}
		
		}
		else
			$responseReturn['status']='';

		return $responseReturn;	
		
	}
}