<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
/**
 * Description of TimezoneModel
 *
 * @author sariyamol
 */
 //$Id: TimezoneModel.php, v 1.0 2013/03/18 16:10:00
//
class TimezoneModel extends Model
{
	//put your code here
	//FUNCTION TO LIST TIME ZONES
	function listTimezones($DeafaultTimeZone = '2')
	{
		$sql="(
			  SELECT 
				timeZoneID, 
				CONCAT(
				  timeZoneName, 
				  '( ', 
				  timeZoneDiff, 
				  ')'
				) AS timeZoneName, 
				priority, 
				dstStartDate, 
				dstEndDate 
			  FROM 
				`" . DB_PREFIX ."timezones` 
			  WHERE 
				timeZoneID = '$DeafaultTimeZone'
			) 
			UNION 
			  (
				SELECT 
				  timeZoneID, 
				  CONCAT(
					timeZoneName, 
					'( ', 
					timeZoneDiff, 
					')'
				  ) AS timeZoneName, 
				  priority, 
				  dstStartDate, 
				  dstEndDate 
				FROM 
				  `" . DB_PREFIX ."timezones` 
				WHERE 
				  timeZoneID != '$DeafaultTimeZone'
			  ) 
			ORDER BY 
			  priority ASC";
		$rsTimezones = $this->ObjDatabase->readValues($sql);
		return $rsTimezones;
	}
	//END OF FUNCTION
	//FUNCTION TO GET TIME ZONE DETAILS
	function getTimezoneDetails($DeafaultTimeZone,$fields='')
	{	
		$sql = "SELECT ";
		
		if($fields==''){
			$sql.="*";
		}
		else{
			$sql.=$fields;
		}
		
		$sql.="	FROM 
					" . DB_PREFIX . "timezones 
				WHERE 
					timeZoneID = '" . $DeafaultTimeZone . "' 
				LIMIT 1";
				
		$rsTimezones = $this->ObjDatabase->readValue($sql);
		return $rsTimezones;
	}
	//END OF FUNCTION
	//FUNCTION TO CONVERT TIME ZONE
	public function convert_tz($date_str, $tz, $date_format = "m/d/Y H:i")
	{
		$time   = strtotime($date_str);
		$tz_bak = getenv("TZ");
		putenv("TZ=$tz");
		$ret = date($date_format, $time);
		putenv("TZ" . ($tz_bak ? "=$tz_bak" : ""));
		return $ret;
	}
	//END OF FUNCTION
	//FUNCTION TO SET SERVER SESSION TIME ZONE
	public function setServerSessionTimeZone($defaultTimezoneID,$timeZoneDiff='')
	{
		if($timeZoneDiff!=''){
			$sql = "SET 
					  time_zone = '".$timeZoneDiff."'";
		}
		else{
			$sql = "SET 
					  time_zone = (
						SELECT 
						  timeZoneDiff 
						FROM 
						   " . DB_PREFIX . "timezones 
						WHERE
							timeZoneID='".$defaultTimezoneID."'
					  )";
		}
		$resUpdateSessionTimeZone = $this->ObjDatabase->setQuery($sql);
	}
	//END OF FUNCTION
	//FUNCTION TO GET CURRENT TIME
	public function getCurrentTime()
	{
		$sql = "SELECT 
				  NOW() AS currentTime";
		$resSelectCurrentTime = $this->ObjDatabase->readValue($sql);
		return $resSelectCurrentTime['currentTime'];
	}
	//END OF FUNCTION
	//FUNCTION TO CHANGE TIME ZONE DIFFERENT WITH DST
	public function changeTimeZoneDiffWithDST()
	{
		$currentTime  = $this->getCurrentTime();
		$currentTime  = date("F d H:i:s", strtotime($currentTime));
		$currentTime  = strtotime($currentTime);
		//echo '---'.strtotime("June 08 09:39:28");
		//echo '--'.strtotime("9 hours 39 minutes 28 seconds June 08");
		$resTimezones = $this->listTimezones();
		// Gets the month names
		$months		= array(
			"January",
			"February",
			"March",
			"April",
			"May",
			"June",
			"July",
			"August",
			"September",
			"October",
			"November",
			"December"
		);
		foreach ($resTimezones as $timeZones)
		{
			// search daylight start and end time with months
			for ($k = 0; $k < 12; $k++)
			{
				if (stristr($timeZones['dstStartDate'], $months[$k]) == TRUE)
				{
					$startMonth = $months[$k];
				}
				if (stristr($timeZones['dstEndDate'], $months[$k]) == TRUE)
				{
					$endMonth = $months[$k];
				}
			}
			// if start date is greater then end date then end date rounds to next year
			if (strtotime($startMonth) > strtotime($endMonth))
			{
				$timeZones['dstStartDate'] = $timeZones['dstStartDate'] . ' ' . date('Y');
				$nextYear                  = date('Y') + 1;
				$timeZones['dstEndDate']   = $timeZones['dstEndDate'] . ' ' . $nextYear;
			}
			$dstStartDate = strtotime($timeZones['dstStartDate']);
			$dstEndDate   = strtotime($timeZones['dstEndDate']);
			$timeZoneID   = $timeZones['timeZoneID'];
			if (($currentTime > $dstStartDate && $currentTime < $dstEndDate))
			{
				$sql = "UPDATE 
						  " . DB_PREFIX . "timezones 
						SET 
						  timeZoneDiff = timeZoneDiffDST 
						WHERE 
						  timeZoneID = '" . $timeZoneID . "'";
			}
			else
			{
				$sql = "UPDATE 
						  " . DB_PREFIX . "timezones 
						SET 
						  timeZoneDiff = timeZoneDiffDefault 
						WHERE 
						  timeZoneID = '" . $timeZoneID . "'";
			}
			$resUpdateTimeZone = $this->ObjDatabase->setQuery($sql);
		}
		return true;
	}
	//END OF FUNCTION
	//FUNCTION TO CONVERT TO SYSTEM TIME ZONE
	public function convertToSystemTimeZone($dateTime, $fromTimeZoneID)
	{
		$getTimezoneDetails = $this->getTimezoneDetails($fromTimeZoneID);
		$fromTimeZoneDiff   = $getTimezoneDetails['timeZoneDiff'];
		$sql = "SELECT 
				  CONVERT_TZ(
					'" . $dateTime . "', 
					'" . $fromTimeZoneDiff . "', 
					@@session.time_zone
				  ) AS convertedDateTime";
		$resConvertTimeZone = $this->ObjDatabase->readValue($sql);
		return $resConvertTimeZone['convertedDateTime'];
	}
	//END OF FUNCTION
	//FUNCTION TO GET ALL TIME ZONE DETAILS WITH DAYLIGHT SAVING
	function getDayLightSavingTimezones($timeZone = '')
	{
		$sql = "SELECT 
				  * 
				FROM 
				  `" . DB_PREFIX . "timezones` 
				WHERE 
				  `daylightSavingsDiff` = '+1'";
		if ($timeZone != '')
			$sql .= " AND timeZoneID='" . $timeZone . "'";
		return $this->ObjDatabase->readValues($sql);
	}
	//END OF FUNCTION
	//FUNCTION TO UPDATE TIMEZONE DST START AND END TIME
	function updateDayLightSavingTimezones($POST, $timezoneID)
	{
		($POST['dstStartDay'] != '') ? $dstStartDate = $POST['dstStartHrs'] . 'hours' . ' ' . $POST['dstStartDay'] . ' ' . $POST['dstStartMonth'] : '';
		($POST['dstEndDay'] != '') ? $dstEndDate = $POST['dstEndHrs'] . 'hours' . ' ' . $POST['dstEndDay'] . ' ' . $POST['dstEndMonth'] : '';
		$currentTime = $this->getCurrentTime();
		$currentTime = date("F d H:i:s", strtotime($currentTime));
		$currentTime = strtotime($currentTime);
		$timeZones	= $this->getDayLightSavingTimezones($timezoneID);
		$timeZones	= $timeZones[0];
		// Gets the month names
		$months      = array(
			"January",
			"February",
			"March",
			"April",
			"May",
			"June",
			"July",
			"August",
			"September",
			"October",
			"November",
			"December"
		);
		// search daylight start and end time with months
		for ($k = 0; $k < 12; $k++)
		{
			if (stristr($dstStartDate, $months[$k]) == TRUE)
			{
				$startMonth = $months[$k];
			}
			if (stristr($dstEndDate, $months[$k]) == TRUE)
			{
				$endMonth = $months[$k];
			}
		}
		$StartDate = $dstStartDate;
		$EndDate   = $dstEndDate;
		// if start date is greater then end date then end date rounds to next year	
		if (strtotime($startMonth) > strtotime($endMonth))
		{
			$StartDate = $dstStartDate . ' ' . date('Y');
			$nextYear  = date('Y') + 1;
			$EndDate   = $dstEndDate . ' ' . $nextYear;
		}
		$StartDate = strtotime($StartDate);
		$EndDate   = strtotime($EndDate);
		if (($currentTime > $StartDate && $currentTime < $EndDate))
		{
			$timeZoneDiff = $timeZones['timeZoneDiffDST'];
		}
		else
		{
			$timeZoneDiff = $timeZones['timeZoneDiffDefault'];
		}
		$sql = "UPDATE 
				  " . DB_PREFIX . "timezones 
				SET 
				  dstStartDate = '" . $dstStartDate . "', 
				  dstEndDate = '" . $dstEndDate . "', 
				  timeZoneDiff = '" . $timeZoneDiff . "' 
				WHERE 
				  timeZoneID = '" . $timezoneID . "'";
		return $this->ObjDatabase->setQuery($sql);
	}
	//END OF FUNCTION
}