<?php

class Cache {

	// ------------------------------------------------------------------------

	/**
	 * Constructor
	 *
	 * @param array
	 */
	public	$web_base_dir;
	public function __construct($driver = 'file')
	{
		$this->web_base_dir = str_replace('/', '_', WEB_BASE_DIR);
		$driver_loaded	= FALSE;
		if ($driver == 'memcache') {
			if(! extension_loaded('memcache')) {
				if(DEVELOPER_MODE)
					echo 'The Memcache Extension must be loaded to use Memcache.';
			}
			else {
				$options	= array('host' => CACHE_HOST, 'port' => CACHE_PORT);
				include_once (__LIBRARY_PATH.'/cache/drivers/Cache_memcache.php');
				$this->_adapter	= Cache_memcache::getInstance($options);
				$driver_loaded	= TRUE;
			}
		}
		else if ($driver == 'memcached') {
			if(! extension_loaded('memcached')) {
				if(DEVELOPER_MODE)
					echo 'The Memcached Extension must be loaded to use Memcached.';
			}
			else {
				$options	= array('host' => CACHE_HOST, 'port' => CACHE_PORT);
				include_once (__LIBRARY_PATH.'/cache/drivers/Cache_memcached.php');
				$this->_adapter	= Cache_memcached::getInstance($options);
				$driver_loaded	= TRUE;
			}
		}
		else if ($driver == 'apc') {
			if(! extension_loaded('apc')) {
				if(DEVELOPER_MODE)
					echo 'The APC Extension must be loaded to use APC Cache.';
			}
			else {
				include_once (__LIBRARY_PATH.'/cache/drivers/Cache_apc.php');
				$this->_adapter	= new Cache_apc();
				$driver_loaded	= TRUE;
			}
		}
		else if ($driver == 'file') {
				include_once (__LIBRARY_PATH.'/cache/drivers/Cache_file.php');
				$this->_adapter	= new Cache_file();
				$driver_loaded	= TRUE;
		}
		if(!$driver_loaded) {
				include_once (__LIBRARY_PATH.'/cache/drivers/Cache_dummy.php');
				$this->_adapter	= new Cache_dummy();
		}
	}

	// ------------------------------------------------------------------------

	/**
	 * Cache Set
	 *
	 * @param 	string		Unique Key
	 * @param 	mixed		Data to store
	 * @param 	int			Length of time (in seconds) to cache the data
	 *
	 * @return 	boolean		true on success/false on failure
	 */
	public function set($id, $data, $ttl = 60)
	{
		return $this->_adapter->set($this->web_base_dir.$id, $data, $ttl);
	}
	
	// ------------------------------------------------------------------------

	/**
	 * Get 
	 *
	 * Look for a value in the cache.  If it exists, return the data 
	 * if not, return FALSE
	 *
	 * @param 	string	
	 * @return 	mixed		value that is stored/FALSE on failure
	 */
	public function get($id)
	{	
		return $this->_adapter->get($this->web_base_dir.$id);
	}


	// ------------------------------------------------------------------------

	/**
	 * Delete from Cache
	 *
	 * @param 	mixed		unique identifier of the item in the cache
	 * @return 	boolean		true on success/false on failure
	 */
	public function delete($id)
	{
		return $this->_adapter->delete($this->web_base_dir.$id);
	}

	// ------------------------------------------------------------------------

	/**
	 * Clean the cache
	 *
	 * @return 	boolean		false on failure/true on success
	 */
	public function clean()
	{
		return $this->_adapter->clean();
	}

	// ------------------------------------------------------------------------

	/**
	 * Cache Info
	 *
	 * @param 	string		user/filehits
	 * @return 	mixed		array on success, false on failure	
	 */
	public function cache_info($type = 'user')
	{
		return $this->_adapter->cache_info($type);
	}

	// ------------------------------------------------------------------------
	
	/**
	 * Get Cache Metadata
	 *
	 * @param 	mixed		key to get cache metadata on
	 * @return 	mixed		return value from child method
	 */
	public function get_metadata($id)
	{
		return $this->_adapter->get_metadata($this->web_base_dir.$id);
	}
}
// End Class

/* End of file Cache.Class.php */
/* Location: ./libraries/cache/Cache.Class.php */