<?php
class Cache_memcache {

	private static $_memcache;	// Holds the memcache object

		 		
	public function __construct($options=null)
	{
		self::memcache_connect($options);
	}
	
	public static function getInstance($options=null)
    {
		if(!(self::$_memcache instanceof self))
		{
            self::$_memcache	= new self($options);
        }
        return self::$_memcache;
    }	

	// ------------------------------------------------------------------------	
	
	/**
	 * Connect to memcache server.
	 */
	public function memcache_connect($options)
	{
		$this->_memcache	= new Memcache();
		$this->_memcache->connect($options['host'], $options['port']);
	}
	
	// ------------------------------------------------------------------------

	/**
	 * Set
	 *
	 * @param 	string		unique identifier
	 * @param 	mixed		data being cached
	 * @param 	int			time to live
	 * @return 	boolean 	true on success, false on failure
	 */
	public function set($id, $data, $ttl = 60)
	{
		$compress = FALSE;
		return $this->_memcache->set($id, $data, $compress, $ttl);
	}
	
	/**
	 * Fetch from cache
	 *
	 * @param 	mixed		unique key id
	 * @return 	mixed		data on success/false on failure
	 */	
	public function get($id)
	{	
		return $this->_memcache->get($id);
	}


	// ------------------------------------------------------------------------
	
	/**
	 * Delete from Cache
	 *
	 * @param 	mixed		key to be deleted.
	 * @return 	boolean 	true on success, false on failure
	 */
	public function delete($id)
	{
		return $this->_memcache->delete($id);
	}

	// ------------------------------------------------------------------------
	
	/**
	 * Clean the Cache
	 *
	 * @return 	boolean		false on failure/true on success
	 */
	public function clean()
	{
		return $this->_memcache->flush();
	}

	// ------------------------------------------------------------------------

	/**
	 * Cache Info
	 *
	 * @param 	null		type not supported in memcache
	 * @return 	mixed 		array on success, false on failure
	 */
	public function cache_info($type = NULL)
	{
		return $this->_memcache->getStats();
	}

	// ------------------------------------------------------------------------
	
	/**
	 * Get Cache Metadata
	 *
	 * @param 	mixed		key to get cache metadata on
	 * @return 	mixed		FALSE on failure, array on success.
	 */
	public function get_metadata($id)
	{
		$stored = $this->_memcache->get($id);

		if (count($stored) !== 3)
		{
			return FALSE;
		}

		list($data, $time, $ttl) = $stored;

		return array(
			'expire'	=> $time + $ttl,
			'mtime'		=> $time,
			'data'		=> $data
		);
	}

}
// End Class

/* End of file Cache_memcache.php */
/* Location: ./libraries/Cache/drivers/Cache_memcache.php */