<?php
require_once('ctctWrapper.php');
class Schedule
{
	/**
	 * 
	 * Constructor
	 */
	public function __construct(){
		return $this;
	}
	/**
	 * 
	 * Public function scheduleCampaign schedules an email campaign for delivery
	 * @param Campaign $campaign [@param string $campaign]
	 * @param string $time
	 */
	public function scheduleCampaign($campaign, $time, $credentials)
	{
		$utility = new Utility($credentials);
		
		if(is_string($campaign))
		{ $campaignId = str_replace('http://', 'https://', $campaign); } 
		else { $campaignId = $utility->getApiPath().$campaign->getLink(); }
		
		$scheduleXml = $this->createScheduleXml($campaignId, $time);

		$response = $utility->httpPost($campaignId.'/schedules', $scheduleXml);
		return $response['info']['http_code'];
	}
	
	/**
	 * 
	 * Public function removeSchedule removes the schedule from a previously 'scheduled' campaign
	 * @param Campaign $campaign [@param string $campaign]
	 */
	public function removeSchedule($campaign)
	{
		$utility = new Utility($credentials);
		
		if(is_string($campaign))
		{ $campaignId = str_replace('http://', 'https://', $campaign); } 
		else { $campaignId = $utility->getApiPath().$campaign->getLink(); }
			
		$response = $utility->httpDelete($campaignId.'/schedules/1');
		return $response['info']['http_code'];
	}
	
	/**
	 * 
	 * Public function getSchedule will return an array containing schedule information for the
	 * provided campaign, or false if there is none.
	 * @param Campaign $campaign [@param string $campaign]
	 */
	public function getSchedule($campaign)
	{
		$utility = new Utility($credentials);
		
		if(is_string($campaign))
		{ $campaignId = str_replace('http://', 'https://', $campaign); } 
		else { $campaignId = $utility->getApiPath().$campaign->getLink(); }
		
		$responseXml = $utility->httpGet($campaignId.'/schedules');
		$parsedReturn = simplexml_load_string($responseXml['xml']);
		
		if (isset($parsedReturn->entry)){
			$schedule['link'] = (string) $parsedReturn->entry->link['href'];
			$schedule['id'] = (string) $parsedReturn->entry->id;
			$schedule['title'] = (string) $parsedReturn->entry->title;
			$schedule['updated'] = (string) $parsedReturn->entry->updated;
			$schedule['time'] = (string) $parsedReturn->entry->content->Schedule->ScheduledTime;
			return $schedule;
		} else { return False; }
	}
	
	/**
	 * 
	 * Private function createScheduleXml creates the necessary XML for scheduleing an email campaign
	 * @param string $campaignId
	 * @param string $time
	 */
	private function createScheduleXml($campaignId, $time)
	{
		$cLink = str_replace('https://api.constantcontact.com/', '', $campaignId);
		$Utility = new Utility($credentials);
		
		$xml = simplexml_load_string("<?xml version='1.0' encoding='UTF-8' standalone='yes'?><entry xmlns='http://www.w3.org/2005/Atom'/>");
		$linkNode = $xml->addChild("link");
		$link_href = $linkNode->addAttribute('href', $cLink.'/schedules/1');
		$link_rel = $linkNode->addAttribute('rel', 'edit');
		$id = $xml->addChild("id", $campaignId);
		$title = $xml->addChild("title", $time);
		$updated = $xml->addChild("updated", $time);
		$author = $xml->addChild("author");
		$name = $author->addChild("name", "ConstantContact");
		$content = $xml->addChild("content");
		$content->addAttribute("type", "application/vnd.ctct+xml");
		$schedule = $content->addChild("Schedule", "", 'http://ws.constantcontact.com/ns/1.0/');
		$schedule_id = $schedule->addAttribute("id", $cLink.'/schedules/1');
		$scheduleTime = $schedule->addChild("ScheduledTime", $time);
		
		$xmlReturn = $xml->asXML();
		return $xmlReturn;
	
	}
}