<?php
error_reporting(0);
/** 
 * TinyMCE WYSIWYG Editor PHP function
 *
 * @author Nikhil Ben Kuruvilla
   @modified by Shameer C
 * @date 02-11-2010
 * @package EcommerceGuruji
 * @link http://www.ispg.in
 */
 

/** 
 * Initialize TinyMce Editor.
 *
 * @param string $mode (advanced, simple, basic)
 * @param string $location location of toolbar (top, bottom)
 * @param string $align alignment of toolbar (left, center, right)
 * @param string $statusBar status bar location (top, bottom)
 * @param int $skin 
 */
function initEditor($param,$mode='',$skin='',$align='',$location='',$statusBar='',$id)
{
// Set default js directory path
define('GLOBAL_JS_DIRECTORY',$param['global_js_directory']);
define('GLOBAL_KC_DIRECTORY',$param['global_kc_directory']);
/**
 * Editor selector name, used to identify the textarea that
 * should be used as tinymce editor.
 *
 * Eg: <textarea class="tinymce"></textarea>
 */ 
$editor_selector = 'tinymce';
if ($skin == '') {
        $skin = $param['skin'];
}
if ($_REQUEST['mode']) {
	$mode = $_REQUEST['mode'];
}
// Select Lang
$defLang=$param['deflang'];
$lang = $param['lang'];
if($lang=='')
$lang=$defLang;
// Select Skin
switch ($skin)
	{
		case '3':
			$skin = "skin : \"o2k7\", skin_variant : \"black\",";
			break;
		case '2':
			$skin = "skin : \"o2k7\", skin_variant : \"silver\",";
			break;
		case '1':
			$skin = "skin : \"o2k7\",";
			break;
		case '0':
		default:
			$skin = "skin : \"default\",";
	}

// Set default mode
if ($mode == '') {
	$mode = $param['mode'];
}
$content_css    =   '';
/**
 * NOTE : For testing purpose 
 * Usage eg: append '?mode=advanced' to the url
 */
if ($_REQUEST['mode']) {
	$mode = $_REQUEST['mode'];
}

// Set default toolbar location
if ($location == '') {
	$location = $param['location'];
}

// Set default toolbar alignment
if ($align == '') {
	$align = $param['align'];
}

// Set default location for status bar
if ($statusBar == '') {
	$statusBar = $param['status_bar'];
}

// Set style sheet for content
if ($param['content_css'] != '' && $param['enable_css'] =='Yes') {
	$content_css =  "extraPlugins: 'stylesheetparser,xml',".'contentsCss : "'.$param['content_css'].'",stylesSet: [],';
}
else
$content_css =  "extraPlugins: 'xml',";
$relativUrls        =   $param['relative_urls'];
/**
 * Basic Configurations for plugins and button set.
 *
 * Prepare plugin array.
 */
$buttons1_add_before = $buttons1_add = array();
$buttons2_add_before = $buttons2_add = array();
$buttons3_add_before = $buttons3_add = array();
$buttons4 = array();
$plugins  = array();

// For advanced mode
if ($mode == 'advanced') {

	// fonts
	if ($param['fonts'] == 'TRUE') {
		$buttons1_add[]	= 'fontselect,fontsizeselect';
	}
	
	// paste
	if ($param['paste'] == 'TRUE') {
		$plugins[]	= 'paste';
		$buttons4[]	= 'pastetext';
		$buttons4[]	= 'pasteword';
		$buttons4[]	= 'selectall,|';
	}
	
	// search & replace
	if ($param['search_replace'] == 'TRUE') {
		$plugins[]	            = 'searchreplace';
		$buttons2_add_before[]	= 'search,replace,|';
	}
		
	// insert date and/or time plugin
	if ($param['insert_date'] == 'TRUE' || $param['insert_time'] == 'TRUE') {
		$plugins[]	    = 'insertdatetime';
		$buttons2_add[]	= 'insertdate';
		$buttons2_add[]	= 'inserttime';
	}
	
	// colors
	if ($param['colours'] == 'TRUE') {
		$buttons2_add[]	= 'forecolor,backcolor';
	}
		
	// table
	if ($param['table'] == 'TRUE') {
		$plugins[]				= 'table';
		$buttons3_add_before[]	= 'tablecontrols';
	}
		
	// emotions
	if ($param['smileys'] == 'TRUE') {
		$plugins[]	    = 'emotions';
		$buttons3_add[]	= 'emotions';
	}

	//media plugin
	if ($param['media'] == 'TRUE') {
		$plugins[]      = 'media';
		$buttons3_add[] = 'media';
	}
	
	// horizontal line
	if ($param['horizontal_rule'] == 'TRUE') {
		$plugins[]	    = 'advhr';
		$elements[]     = 'hr[id|title|alt|class|width|size|noshade|style]';
		$buttons3_add[]	= 'advhr';
	}
	
	// rtl/ltr buttons
	if ($param['directionality'] == 'TRUE') {
		$plugins[]      = 'directionality';
		$buttons3_add[] = 'ltr,rtl';
	}	

	// fullscreen
	if ($param['fullscreen'] == 'TRUE') {
		$plugins[]	    = 'fullscreen';
		$buttons2_add[]	= 'fullscreen';
	}
		
	// layer
	if ($param['layer'] == 'TRUE') {
		$plugins[]	= 'layer';
		$buttons4[]	= 'insertlayer';
		$buttons4[]	= 'moveforward';
		$buttons4[]	= 'movebackward';
		$buttons4[]	= 'absolute';
	}

	// style
	if ($param['style'] == 'TRUE') {
		$plugins[]	= 'style';
		$buttons4[]	= 'styleprops';
	}
	
	// XHTMLxtras
	if ($param['xhtml_extras'] == 'TRUE') {
		$plugins[]	= 'xhtmlxtras';
		$buttons4[]	= 'cite,abbr,acronym,ins,del,attribs';
	}
	
	// visualchars
	if ($param['visual_chars'] == 'TRUE') {
		$plugins[]	= 'visualchars';
		$buttons4[]	= 'visualchars';
	}
	
	// non-breaking
	if ($param['non_breaking'] == 'TRUE') {
		$plugins[]	= 'nonbreaking';
		$buttons4[]	= 'nonbreaking';
	}
	
	// blockquote
	if ($param['block_quote'] == 'TRUE') {
		//$plugins[]  = 'blockquote';
		$buttons4[] = 'blockquote';
	}
	
	// template
	if ($param['template'] == 'TRUE') {
		$plugins[]	= 'template';
		$buttons4[]	= 'template';
	}
		
	// advimage
	if ($param['adv_image'] == 'TRUE') {
		$plugins[]	= 'advimage';
		$elements[]	= 'img[class|src|border=0|alt|title|hspace|vspace|width|height|align|onmouseover|onmouseout|name|style]';
	}
		
	// advlink
	if ($param['adv_link'] == 'TRUE') {
		$plugins[]	= 'advlink';
		$elements[]	= 'a[id|class|name|href|target|title|onclick|rel|style]';
	}
	
	// autosave
	if ($param['auto_save'] == 'TRUE') {
		$plugins[]	= 'autosave';
	}
		
	// context menu
	if ($param['context_menu'] == 'TRUE') {
		$plugins[]	= 'contextmenu';
	}
	
	// inline popups
	if ($param['inline_popup'] == 'TRUE') {
		$plugins[]	= 'inlinepopups';
	}
	
	// Pagebreak
	$plugins[]	= 'pagebreak';
	$buttons4[]	= 'pagebreak';

	

}
 
/** 
 * Advanced - Full featured TinyMce Editor
 * Simple - TinyMce with minimum set of features
 * Basic - TinyMce in advanced mode, but limited features, Default !
 *
 * @param string $mode
 */   
switch($mode)
{
	
	case basic: 
		$return =  "<script type='text/javascript'>	
		var __CKEDITORDefaultLanguage = '".$defLang."';
		if (!CKEDITOR.lang.languages['".$defLang."'] )
		{
			var __CKEDITORDefaultLanguage = 'en';
		}	
		CKEDITOR.replace( '".$id."',
		{  

				 toolbar: [
						[ 'Bold', 'Italic', '-', 'NumberedList', 'BulletedList', '-', 'Link', 'Unlink' ],
						[ 'FontSize', 'TextColor', 'BGColor']
					 ],				          
			  language: '".$lang."',
			  defaultLanguage: __CKEDITORDefaultLanguage
		});
		
		</script>";	
	break;
	
	case simple:
		
		$return =  "<script type='text/javascript'>	
		var __CKEDITORDefaultLanguage = '".$defLang."';
		if (!CKEDITOR.lang.languages['".$defLang."'] )
		{
			var __CKEDITORDefaultLanguage = 'en';
		}
		CKEDITOR.replace( '".$id."',
		{
			  $content_css		
			toolbar: [
			{ name: 'document', items : ['Source','NewPage','Preview' ] },
			{ name: 'clipboard', items : [ 'Cut','Copy','Paste','PasteText','PasteFromWord','-','Undo','Redo' ] },
			{ name: 'editing', items : [ 'Find','Replace','-','SelectAll','-','Scayt' ] },
			{ name: 'insert', items : [ 'Image','Flash','Table','HorizontalRule','SpecialChar'] },
					'/',
			{ name: 'styles', items : [ 'Styles','Format' ] },
			{ name: 'basicstyles', items : [ 'Bold','Italic','Strike','-','RemoveFormat' ] },
			{ name: 'paragraph', items : [ 'NumberedList','BulletedList','-','Outdent','Indent','-','Blockquote' ] },
			{ name: 'links', items : [ 'Link','Unlink','Anchor' ] },
			{ name: 'tools', items : [ 'Maximize'] }
		],		 
			filebrowserBrowseUrl : '".GLOBAL_KC_DIRECTORY.'browse.php?type=files'."',
			filebrowserImageBrowseUrl : '".GLOBAL_KC_DIRECTORY.'browse.php?type=images'."',
			filebrowserFlashBrowseUrl : '".GLOBAL_KC_DIRECTORY.'browse.php?type=flash'."',
			filebrowserUploadUrl : '".GLOBAL_KC_DIRECTORY.'upload.php?type=files'."',
			filebrowserImageUploadUrl : '".GLOBAL_KC_DIRECTORY.'upload.php?type=images'."',
			filebrowserFlashUploadUrl : '".GLOBAL_KC_DIRECTORY.'upload.php?type=flash'."',		       
			language: '".$lang."',
			defaultLanguage: __CKEDITORDefaultLanguage,
			height: '300px',
			width: '97%'		
		});
	
	</script>";	
	break;	
		case advanced:
		$return =  "<script type='text/javascript'>					
		var __CKEDITORDefaultLanguage = '".$defLang."';
		if (!CKEDITOR.lang.languages['".$defLang."'] )
		{
			var __CKEDITORDefaultLanguage = 'en';
		}	
		CKEDITOR.replace( '".$id."',
		{	
			$content_css			
			fullPage: false,		   		  
			extraPlugins: 'wysiwygarea,mediaembed,xml',
			toolbarStartupExpanded: true,
			toolbarCanCollapse: false,
			toolbarLocation: 'top',
			startupShowBorders: false,
			forcePasteAsPlainText: true,
			filebrowserBrowseUrl : '".GLOBAL_KC_DIRECTORY.'browse.php?type=files'."',
			filebrowserImageBrowseUrl : '".GLOBAL_KC_DIRECTORY.'browse.php?type=images'."',
			filebrowserFlashBrowseUrl : '".GLOBAL_KC_DIRECTORY.'browse.php?type=flash'."',
			filebrowserUploadUrl : '".GLOBAL_KC_DIRECTORY.'upload.php?type=files'."',
			filebrowserImageUploadUrl : '".GLOBAL_KC_DIRECTORY.'upload.php?type=images'."',
			filebrowserFlashUploadUrl : '".GLOBAL_KC_DIRECTORY.'upload.php?type=flash'."',
			resize_enabled: 'true',
			resize_dir: 'vertical',
			height: '300px',
			width: '97%',          
			language: '".$lang."',
			defaultLanguage: __CKEDITORDefaultLanguage
		});			
		</script>";
	    break;
   
}
return $return;
}

/** 
 * Editor calling function, displays TinyMce editor.
 *
 * NOTE : To use this function TinyMce initializing function,
 * initEditor() should be called at first.
 * Usage : editor('name');
 *
 * @param string $name
 * @param text $content
 * @param int $width
 * @param int $height
 * @param int $col
 * @param int $row
 */
function editor($name, $content = '', $width = '', $height = '', $col = '', $row = '', $toggleMode = FALSE) 
{
	// To set width and height type
	if (is_numeric( $width )) {
			$width .= '';
		}
		if (is_numeric( $height )) {
			$height .= '';
		}
	
	// For toggling between modes	
	if ($_REQUEST['mode'] == 'simple') {
		$mode = 'basic';
	} elseif ($_REQUEST['mode'] == 'advanced') {
		$mode = 'simple';
	} else {
		$mode = 'advanced';
	}
	// convert <br /> tags so they are not visible when editing
 	$content = str_replace( '<br />', "\n", $content );
	
	$return = "<textarea id=\"$name\" name=\"$name\" cols=\"$col\" rows=\"$row\" style=\"width:{$width}%; height:{$height};\" class=\"ckeditor\">".$content."</textarea>"; 

		   // Enable 'toggle mode' option
		   if ($toggleMode == TRUE) {    
				$return .= "<a href=\"?mode={$mode}\">Toggle Editor</a>";
			}
	
	return $return;
}