<?php

/** This file is part of KCFinder project
  *
  *      @desc Base configuration file
  *   @package KCFinder
  *   @version 2.51
  *    @author Pavel Tzonkov <pavelc@users.sourceforge.net>
  * @copyright 2010, 2011 KCFinder Project
  *   @license http://www.opensource.org/licenses/gpl-2.0.php GPLv2
  *   @license http://www.opensource.org/licenses/lgpl-2.1.php LGPLv2
  *      @link http://kcfinder.sunhater.com
  */

// IMPORTANT!!! Do not remove uncommented settings in this file even if
// you are using session configuration.
// See http://kcfinder.sunhater.com/install for setting descriptions
$path		= realpath(dirname(__FILE__));
$path_ary	=	explode('library/ckeditor/kcfinder',$path);
 $root_path	=	$path_ary[0];
ini_set('session.save_path',$root_path .'public/uploads/ses');
ini_set('session.gc_probability', 1);
session_start();
if(isset($_COOKIE['instance'])) {
    $instance = $_COOKIE['instance'];
   $destFolder = isset($_SESSION['ck_upload'][$instance]) ? $_SESSION['ck_upload'][$instance] : null;
}

$ckbrowser['sessioncheck'] = 'auth_user'; //name of session variable to check

$ckbrowser['docroot'] = rtrim($_SERVER['DOCUMENT_ROOT'],'/');

$ckbrowser['path']['default_root'] = '/sreeja/deal/public/uploads/editor-images/';
// Folder permissions for Unix servers only
$ckbrowser['unixpermissions'] = 0777;
if(isset($destFolder)){
    $uploadRoot = $destFolder;
}
else {
    $destFolder = $ckbrowser['path']['default_root'];
}
$disabled=false;
if(session_id() != '')
	{
	if(!isset($_SESSION[$ckbrowser['sessioncheck']])) { $disabled=true; }
	}

$uploadURL="http://".$_SERVER['HTTP_HOST'].$destFolder;
$_CONFIG = array(

    'disabled' => $disabled,
    'denyZipDownload' => false,
    'denyUpdateCheck' => false,
    'denyExtensionRename' => false,

    'theme' => "oxygen",

    'uploadURL' => $uploadURL,
    'uploadDir' => "",

    'dirPerms' => 0755,
    'filePerms' => 0644,

    'access' => array(

        'files' => array(
            'upload' => true,
            'delete' => true,
            'copy' => true,
            'move' => true,
            'rename' => true
        ),

        'dirs' => array(
            'create' => true,
            'delete' => true,
            'rename' => true
        )
    ),

    'deniedExts' => "exe com msi bat php phps phtml php3 php4 cgi pl",

    'types' => array(

        // CKEditor & FCKEditor types
        'files'   =>  "",
        'flash'   =>  "swf",
        'images'  =>  "*img",

        // TinyMCE types
        'file'    =>  "",
        'media'   =>  "swf flv avi mpg mpeg qt mov wmv asf rm",
        'image'   =>  "*img",
    ),

    'filenameChangeChars' => array(/*
        ' ' => "_",
        ':' => "."
    */),

    'dirnameChangeChars' => array(/*
        ' ' => "_",
        ':' => "."
    */),

    'mime_magic' => "",

    'maxImageWidth' => 0,
    'maxImageHeight' => 0,

    'thumbWidth' => 100,
    'thumbHeight' => 100,

    'thumbsDir' => ".thumbs",

    'jpegQuality' => 90,

    'cookieDomain' => "",
    'cookiePath' => "",
    'cookiePrefix' => 'KCFINDER_',

    // THE FOLLOWING SETTINGS CANNOT BE OVERRIDED WITH SESSION CONFIGURATION
    '_check4htaccess' => true,
    //'_tinyMCEPath' => "/tiny_mce",

    '_sessionVar' => &$_SESSION['KCFINDER'],
    //'_sessionLifetime' => 30,
    //'_sessionDir' => "/full/directory/path",

    //'_sessionDomain' => ".mysite.com",
    //'_sessionPath' => "/my/path",
);

?>