<?php
/**
 * Class Flot 
 * 
 * Library that manages report/dash/analaytics/salesrep/business/affilate board graph
 * 
 * @author Nikhil
 * @package Deal
 * @link http://code.google.com/p/flot/
 * @example http://flot.googlecode.com/svn/trunk/API.txt
 * @Updated :- 06-11-2012 for Version 1.1
 */
class Flot
{
    private $placeholder = 'placeholder';
    private $timeFormat = '%b-%d';
    private $mode = 'time';
    private $graphType = 'line';
    private $graphArray;
    private $hoverable = true;
    private $enableTooltip = true;
    private $tooltipColor = "#ffffff";
    private $customDate;
    private $fill = true;
	private $legendHolder="null";
	private $graphLabels = array('Sales');
	private $legendColumns=1;
	private $enableSelection='true';
	private $filterCheckboxContainer='';
	private $filterCheckboxClass='';
	private $fillColor='';
	private $barWidth=36000000; // 60 * 60 * 10000 
	private $jitterForBarGraph=5000000;
	private $ticksForbarGraph=array();
	private $tooltipDecimalsY=0;
	private $currency='';
	private $currencyPosition='';
	private $graphTotalLabels = array();
	private $graphTotalHolder='';
	private $graphTotalHolderUlClass='';
	private $graphColors=array();
	private $ticksForLineGraph=array();
	private $horzontalBarGraph="false";
	private $tootlTipXLabel='';
	private $multiBar='false';
	private $xaxisTicks='';
    public $dateRange;
	
    /**
     * function init
     * 
     * @param string $graphArray
     * @param integer $customDate
     * @param array $settings
     * @return function getScript 
     */
    public function init($graphArray, $customDate, $settings = '')
    {		
        isset($settings['placeholder']) ? $this->placeholder = $settings['placeholder'] : '';
        isset($settings['timeFormat']) ? $this->timeFormat = $settings['timeFormat'] : '';
        isset($settings['mode']) ? $this->mode = $settings['mode'] : '';
        isset($settings['hoverable']) ? $this->hoverable = $settings['hoverable'] : '';
		$this->hoverable	=	isset($settings['hoverable']) ? $settings['hoverable']  : $this->hoverable;
        isset($settings['graphType']) ? $this->graphType = $settings['graphType'] : '';
        isset($settings['fill']) ? $this->fill = $settings['fill'] : '';
		$this->legendHolder = isset($settings['legendHolder']) ? '"#'.$settings['legendHolder'].'"'  : '';
		isset($settings['legendColumns']) ? $this->legendColumns = $settings['legendColumns'] : '';		
		isset($settings['enableSelection']) ? $this->enableSelection = $settings['enableSelection'] : '';
		if($this->graphType=='pie')
		{
			$settings['graphColors']=array("#66c947", "#f0f142", "#1999cf","#5dd3e8","#f07546","#e69b45");
		}
		$this->filterCheckboxContainer = isset($settings['filterCheckboxContainer']) ? $settings['filterCheckboxContainer']  : '';
		isset($settings['filterCheckboxClass']) ? $this->filterCheckboxClass = $settings['filterCheckboxClass'] : '';
		isset($settings['fillColor']) ? $this->fillColor = $settings['fillColor'] : '';
		isset($settings['barWidth']) ? $this->barWidth = $settings['barWidth'] : '';
		$this->tooltipDecimalsY	=	isset($settings['tooltipDecimalsY']) ? $settings['tooltipDecimalsY']  : '';		
		$this->currency	=	isset($settings['currency']) ? $settings['currency']  : '';
		$this->currencyPosition	=	isset($settings['currencyPosition']) ? $settings['currencyPosition']  : '';
		$this->graphLabels	=	isset($settings['graphLabels']) ? explode(",",$settings['graphLabels'])  : $this->graphLabels;		
		$this->graphTotalLabels = isset($settings['graphTotalLabels']) ? explode(",",$settings['graphTotalLabels'])  : array();
		
		$this->graphTotalHolder = isset($settings['graphTotalHolder']) ? $settings['graphTotalHolder']  : '';
		$this->graphTotalHolderUlClass=isset($settings['graphTotalHolderUlClass']) ? $settings['graphTotalHolderUlClass']  : 'clearfix';
		$this->graphColors=(count($settings['graphColors'])>0) ? $settings['graphColors']  : array("#f88f25", "#1999cf", "#0e8f05", "#ba084a", "#ff6868",'#A58BE9');
		isset($settings['horzontalBarGraph']) ? $this->horzontalBarGraph = $settings['horzontalBarGraph'] : '';
		$this->tootlTipXLabel	=	isset($settings['tootlTipXLabel']) ? $settings['tootlTipXLabel']  : '';
		$this->multiBar	=	((isset($settings['multiBar']))&&($settings['multiBar']=='true')) ? 'true'  : 'false';
		$this->ticksForbarGraph	=	((isset($settings['ticksForbarGraph'])) && (count($settings['ticksForbarGraph'])>0)) ? $settings['ticksForbarGraph']  : array();
		$this->ticksForLineGraph =((isset($settings['ticksForLineGraph'])) && (count($settings['ticksForLineGraph'])>0)) ? $settings['ticksForLineGraph']  : array();
		$this->javascriptPath	= isset($settings['javascript_path']) ? $settings['javascript_path']  : '';	
        $this->graphArray = $graphArray;
        $this->customDate = $customDate;
		$GLOBALS['FlotScriptIncluded']	=   isset($GLOBALS['FlotScriptIncluded']) ? $GLOBALS['FlotScriptIncluded'] : '';
		$GLOBALS['FlotScriptIncluded']	=	((isset($settings['includeScript'])) && ($settings['includeScript']=='false')) ? 'Yes'  : $GLOBALS['FlotScriptIncluded'];
						
		if($GLOBALS['FlotScriptIncluded']!='Yes')
		{			
			$includeScript	=	$this->includeFlotScripts();
			$settings['includeScript']	=   isset($settings['includeScript']) ? $settings['includeScript'] : '';
			$script	=	$includeScript.	$this->getScript($settings['includeScript']);
			return $script;
		}
		else
		{
        return $this->getScript($settings['includeScript']);
		}
    }
    /**
     * function getScript
     * 
     * Processes the javscript based on dynamic value.
     *
     * @return string $script
     */
    private function getScript($includeScript='')
    {
		$script = '';
		if($GLOBALS['FlotScriptIncluded']=='Yes' && $this->graphType=='pie' && $includeScript!='false')
		{
			$script ='<script language="javascript" type="text/javascript" src="'.$this->javascriptPath.'/flot/jquery.flot.pie.js"></script>';
		}
		if($this->graphType=='bar' && $this->multiBar=='true' && $GLOBALS['FlotScriptIncluded']=='Yes' && $includeScript!='false')
		{
		$script .='<script language="javascript" type="text/javascript" src="'.$this->javascriptPath.'/flot/jquery.flot.multi.js"></script>';	
		}
		
        $script .= '<script type="text/javascript">$(document).ready(function(){
		
		$(function()
		{
			var options=
			{
				';
				//Line Chart
				if($this->graphType=='line')
				{
					$script.='
					lines:
					{
						show:true,
						fill:' . $this->fill . ',
						fillColor:"'.$this->fillColor.'"
					},
					points:
					{
						show:true
					},';
					if(count($this->ticksForLineGraph)>0)
					{
						$script.='xaxis:
						{
						mode:"' . $this->mode . '",
						ticks:'.$this->generateTicksForLineGraph().',
						timeformat:"' . $this->timeFormat . '"
						},';
					}
					else
					{	
						$script.='xaxis:
						{
						mode:"' . $this->mode . '",
						ticks:6,
						timeformat:"' . $this->timeFormat . '"
						},';
					}
					$script.='selection: 
					{ 
						mode: "x" 
					},';
					
					if(count($this->ticksForLineGraph)>0)
					{
						$script.='xaxis:
						{
						mode:"' . $this->mode . '",
						ticks:'.$this->generateTicksForLineGraph().',
						timeformat:"' . $this->timeFormat . '"
						},';
					}
					else
					{	
						$script.='xaxis:
						{
						mode:"' . $this->mode . '",
						ticks:6,
						timeformat:"' . $this->timeFormat . '"
						},';
					}
				
				}
				elseif($this->graphType=='bar') //Bar Chart
				{
					
					$script.='
					bars: 
					{
						show: true,
						barWidth: '.$this->barWidth.',
						align: "center",
						fill: true,
						horizontal: '.$this->horzontalBarGraph.'
					},';
				if($this->multiBar=='true')
				{
				$script.='multiplebars: true,';
				}
				$script.='
					selection: 
					{ 
						mode: "null" 
					},';
					
					if(count($this->ticksForbarGraph)>0)
					{
						$script.='xaxis:
						{
						mode:"' . $this->mode . '",
						ticks:'.$this->generateTicksForBarGraph().',
						timeformat:"' . $this->timeFormat . '"
						},';
					}
					else
					{	
						$script.='xaxis:
						{
						mode:"' . $this->mode . '",
						ticks:6,
						timeformat:"' . $this->timeFormat . '"
						},';
					}	
					
				}
				elseif($this->graphType=='pie') //PIE Chart
				{
					
					$script.='
					series: 
					{
						pie: 
						{ 
							show: true
						}
					},colors:["#66c947", "#f0f142", "#1999cf","#5dd3e8","#f07546","#e69b45"],';	
					
					
				}
				if($this->graphType=='point')
				{
					$script.='series: {
								label:["Revenue"],
								bubble: true
							,points: { show: true, lineWidth: 2, radius: 8,fillColor:"#F88F25"}
							},yaxis:{tickFormatter:formatTickY},';
							
					if(count($this->ticksForLineGraph)>0)
					{
						$script.='xaxis:
						{
						mode:"' . $this->mode . '",
						ticks:'.$this->generateTicksForLineGraph().',
						timeformat:"' . $this->timeFormat . '"
						},';
					}
					else
					{	
						$script.='xaxis:
						{
						mode:"' . $this->mode . '",
						ticks:6,
						timeformat:"' . $this->timeFormat . '"
						},';
					}
				}
				
					
				$script.='
					grid:
					{						
						hoverable:' . $this->hoverable . ',
						borderColor:"rgb(222, 222, 222)"
					},';
			if($this->graphType=='pie')	
			{					
			$script.='legend:
					{				
						show: false	 
					}';
			}
			else
			{
			$script.='legend:
					{				
						show: false				
					}';	
			}
			
			
			$script.='};
			var dataSetArray=[' . $this->getData() . '];
			
			
			var placeholder=$("#' . $this->placeholder . '");';
			if($this->graphType=='point')
			{
			$script.='function formatTickY(val,axis) {
					var yTitle=new Array("","Sun","Mon","Tue","Wed","Thu","Fri","Sat","");  // PHASE2 FEATURE FIX
					var xTitle=new Array("Urban <br/>Screens","Event","Structure","Product","Non-material"); // PHASE2 FEATURE FIX
					return yTitle[val]; 
				}
				';
			}
			$script.='$.plot(placeholder,dataSetArray,options);';
			if($this->graphType!='pie' && $this->enableSelection!='false')
			{
				$script.='	
				placeholder.bind("plotselected", function (event, ranges) {			
						plot = $.plot(placeholder, dataSetArray,
									  $.extend(true, {}, options, {
										  xaxis: { min: ranges.xaxis.from, max: ranges.xaxis.to }
									  }));
				});
			
				placeholder.bind("plotunselected", function (event) {
					';
					if($this->filterCheckboxClass!='')
					{
						$script.='$(".'.$this->filterCheckboxClass.'").attr("checked","checked");';						
					}
					if(!empty($this->graphTotalLabels))
					{
						$script.='
						generateTotalLabels(dataSetArray);';
					
					}
					$script.=' $.plot(placeholder,dataSetArray,options);
				});';
				
			}
			
			$script.='
			var enableTooltip=' . $this->enableTooltip . ';
			var previousPoint=null;';
			
			if($this->graphType=='point')
			{
			$script.='
			function showTooltip(x,y,contents)
			{								
				$(\'<div id="tooltip" style="z-index:1000; font:11px arial;">\' + contents + \'</div>\').css( 
				{
					position: \'absolute\',
					display: \'none\',
					top: y + 2,
					left: x - 20,
					padding: \'2px\',
					\'color\': \'#000\',
					\'background-color\': \'#fff\',
					border: \'1px solid\',
					\'opacity\': \'1\',
					\'font-size\': \'12px\',
					\'z-index\': \'11\'
				}).appendTo("body").fadeIn(200)
			}
			placeholder.bind("plothover",function(event,pos,item)
			{
				if(enableTooltip==true)
				{
					if(item && item.datapoint[3] >0)
					{
						  var yTitle=new Array("","Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","");';
						  $string = "'".implode("','", $this->ticksForLineGraph)."'";
						  $script .= 'var hour = new Array('.$string.');';
						  $script.='if (previousPoint != item.datapoint) {
						  	previousPoint = item.datapoint;
						  	// hover tooltip
						  	$("#tooltip").remove();
						  	var x = item.datapoint[0],
							y = item.datapoint[1];';
							if(!empty($this->currency) && !empty($this->currencyPosition))
							{																		
									if($this->currency!='')
									{
										$appendCurrency = $this->currency;	
									}
									if($this->currencyPosition=='Left')
									{
										$script=$script.'cnt="'.$appendCurrency.'"+item.datapoint[3];';	
									}
									else
									{
										$script=$script.'cnt=item.datapoint[3]+"'.$appendCurrency.'";
										';	
									}
								}
						  	$script.='showTooltip(item.pageX, item.pageY+15,"Revenue : <b>"+ cnt + "</b><hr/><div>Hour : <b>"+hour[x]+"</b></div><div>Week Day : <b>"+yTitle[y]+"</b></div>");
						  }
					}
					else
					{
						$("#tooltip").remove();
						previousPoint=null
					}
			   }
		   
		   }';
			}
		   	else
			{
			$script.='
			function showTooltip(x,y,contents,color)
			{';
			if($this->graphType=='line')
			{
			$script.='								
				if(x+100 > $(window).width())
				{
					var left = 	($(window).width()-200);
				}
				else
				{
					var left = 	x - 40;
				}';
			}
			else
			{
				$script.=' var left = 	x - 40;';
			}	
			$script.=' $(\'<div id="tooltip" style="z-index:1000; font:11px arial;">\' + contents + \'</div>\').css( 
				{
					position: \'absolute\',
					display: \'none\',
					top: y - 65,
					left: left,
					border: \'1px solid\',
					padding: \'2px\',
					\'border-color\': \'+color+\',
					\'background-color\': \'' . $this->tooltipColor . '\',
					\'z-index\': \'11\'
				}).appendTo("body").fadeIn(200)
			}
			
			placeholder.bind("plothover",function(event,pos,item)
			{
				if(enableTooltip==true)
				{
					if(item)
					{						
						'						
						;						
						if($this->graphType!='pie')
						{														
							
							$script.='	
							//if(previousPoint!=item.dataIndex)
							//{
								previousPoint=item.dataIndex;							
								$("#tooltip").remove();
								var x=item.datapoint[0],y=item.datapoint[1].toFixed('.$this->tooltipDecimalsY.');								
								';
								
								$appendCurrency='';
								if(!empty($this->currency) && !empty($this->currencyPosition))
								{																		
									if($this->currency!='')
									{
										$appendCurrency = $this->currency;	
									}
									if($this->currencyPosition=='Left')
									{
										$script=$script.'y="'.$appendCurrency.'"+y;';	
									}
									else
									{
										$script=$script.'y=y+"'.$appendCurrency.'";
										';	
									}
								}
								
								if($this->mode=="time")
								{									
									$script.='
									var d=new Date(x);
									var month=new Array(12);
									month[0]="January";
									month[1]="February";
									month[2]="March";
									month[3]="April";
									month[4]="May";
									month[5]="June";
									month[6]="July";
									month[7]="August";
									month[8]="September";
									month[9]="October";
									month[10]="November";
									month[11]="December";
									var weekday=new Array(7);
									weekday[0]="Sunday";
									weekday[1]="Monday";
									weekday[2]="Tuesday";
									weekday[3]="Wednesday";
									weekday[4]="Thursday";
									weekday[5]="Friday";
									weekday[6]="Saturday";
									var tooltipContent="<strong>"+weekday[d.getDay()]+" , "+d.getDate()+" "+month[d.getMonth()]+" "+d.getFullYear()+"</strong><br>"+item.series.label+": <strong>"+y+"</strong>";';
									
								}
								else if($this->multiBar=='true')
								{
									$script.='var tooltipContent=""+item.series.label+": "+y+"['.$this->tootlTipXLabel.']";';
								}
								else if($this->tootlTipXLabel!='')
								{
									$script.='var tooltipContent=""+item.series.label+": "+y+" ['.$this->tootlTipXLabel.':"+x+"]";';										
								}
								else
								{
									$script.='var tooltipContent=""+item.series.label+": "+y+"";';				
								}
								
								$script.='
								
								showTooltip(item.pageX,item.pageY,tooltipContent,item.series.color)
							//}';
						
						}
						else
						{
							$script.='$("#tooltip").remove();
										var percent = parseFloat(item.series.percent).toFixed('.$this->tooltipDecimalsY.');
										var tooltipContent=""+item.series.label+": "+percent+"%";
										showTooltip(pos.pageX,pos.pageY,tooltipContent,item.series.color)';		
							
						}
						
						$script.='
					}
					else
					{
						$("#tooltip").remove();
						previousPoint=null
					}
			   }
		   
		   }';	
			}
			
			
		   $script.=')';
		   
		   if($this->filterCheckboxContainer!='' && $this->filterCheckboxClass!='')
		   {
				$appendFilter=$this->generateCheckboxFilters();  
				
				$script=$script."\n"."$('#".$this->filterCheckboxContainer."').html('".$appendFilter."');"; 
				
				$script.='
				
				$(".'.$this->filterCheckboxClass.'").live("click", function()
				{ 									 
				
					var dataNew = [];
					$(".'.$this->filterCheckboxClass.':checked").each(function () {
						var valInd = $(this).val();
						if (valInd && dataSetArray[valInd])
							dataNew.push(dataSetArray[valInd]);
					});
				
					if (dataNew.length > 0)
					{
						$.plot("#'.$this->placeholder.'",dataNew,options);';
						
						if(!empty($this->graphTotalLabels))
						{
							$script.='
						generateTotalLabels(dataNew);';
						
						}
						
						$script.='
					}
				
				});'; 
		   }
		   
		   if(!empty($this->graphTotalLabels))
		   {
				
				$script.=$this->generateTotalLabels();   
			   
		   }
		   
		   $script.='
		   
		   });});
			</script>';
			
        return $script;
    }
    /**
     * function getData
     * 
     * returns data for plotting
     * 
     * @return custom $data
     */
    private function getData()
    {

		$i=0;		
		$dataString='';
		$barGraph='';
		$totalLabels='';
		$graphColors='';		
		$jitterVar=count($this->graphArray)."<br>";
		if($jitterVar>0)
		{
			$jitterVar=$jitterVar-1;	
		}
		$jitterArray=array();
		
		if($this->graphType=='point')
		{
		$maxValue=0;
		foreach ($this->graphArray as $graph)
        {
			foreach ($graph as $graphInd)
			{
				$maxValue = ($graphInd['graphY']>$maxValue) ? $graphInd['graphY']  : $maxValue;	
			}
		}
		$percentArray[$maxValue]=10;
		
		foreach ($this->graphArray as $graph)
        {
			foreach ($graph as $graphInd)
			{
				if($graphInd['graphY']!=$maxValue)
				{
						if($graphInd['graphY'] >0)
						{
						$curValue = ($graphInd['graphY']/$maxValue)*100;
						$percentArray[$graphInd['graphY']]	=	($curValue>0) ? $curValue/10  : 1;
						if($percentArray[$graphInd['graphY']] < 2)
						{
							$percentArray[$graphInd['graphY']] = 2;
						}
						}
						else
						{
						$percentArray[$graphInd['graphY']]	= 1;	
						}
					}
			}
		}
		$data='';
		foreach ($this->graphArray as $graph)
        {
			foreach ($graph as $key => $graphInd)
			{
				$graphX  = $graphInd['graphX'];	
				$graphY  = $graphInd['graphY'];	
				$percent = $percentArray[$graphY];
				if($graphY==0)
				{
					$percent=0;
				}
				$data = $data . "[" . $graphX . "," . $key . ",".$percent."," . $graphY . "],";
			}
        }	
		$data = substr($data, 0, -1);
		$maxRadious = max($percentArray);
		$data = '{ data: ['.$data.']},';			
		$dataString = $dataString.$data;
		}
		else
		{
        foreach ($this->graphArray as $graph)
        {
            
			$data='';
			foreach ($graph as $graphInd)
			{
				if($this->mode=="time")
				{
					$graphX      = $this->getUnixTime($graphInd['graphX']);
					if($i==0)
					{
						$jitterArray[$graphInd['graphX']]=$jitterVar;
						//$jitterArray[$graphInd['graphX']]=0;
					}
					else
					{
						//$jitterArray[$graphInd['graphX']]=$jitterArray[$graphInd['graphX']]-1;
						$jitterArray[$graphInd['graphX']]=$jitterArray[$graphInd['graphX']]-2.22;
					}
					
					if($this->graphType=='bar')
					{
						
						$graphX	= $graphX."-".$this->jitterForBarGraph."*".$jitterArray[$graphInd['graphX']];		
							
					}
				}
				else
				{
					$graphX      = $graphInd['graphX'];	
				}
				$graphY = $graphInd['graphY'];				
				if ($graphY == "")
				{
					$graphY = 0;
				}
				
				$data = $data . "[" . $graphX . "," . $graphY . "],";
			}
			$data = substr($data, 0, -1);
			
			if($this->graphType=='bar')
			{
				
				$barGraph=', bars:{show: true,barWidth: '.$this->barWidth.',align: "left"}';
					
			}
			if(!empty($this->graphTotalLabels))
			{
				$totalLabels=',totalLabels: "'.$this->graphTotalLabels[$i].'"';
			}
			if(!empty($this->graphColors) && $this->graphType!='pie')
			{
				if($this->graphColors[$i]!='')
				{
					$graphColors=',color: "'.$this->graphColors[$i].'"';
				}	
			}
			$data = '{ data: ['.$data.'], label: "'.$this->graphLabels[$i].'"'.$barGraph.$totalLabels.$graphColors.'},';			
			$i++;
			
			
			$dataString = $dataString.$data;
			
			
        }
		}
		
		$dataString = substr($dataString, 0, -1);	
        return $dataString;
        
    }
    /**
     * function getUnixTime
     * 
     * get the javascript equivalent unix time.
     * NOTE : PHP UNIXTIME * 1000 EQ JAVASCRIPT UNIX TIME
     * 
     * @param date $time
     * @return integer $unixTime 
     */
    public function getUnixTime($time)
    {
        $unixTime = strtotime($time . " 00:00:00 GMT");
        $unixTime = ($unixTime * 1000); // javascript Unix Time
        return $unixTime;
    }
    /**
     * function getDates
     * 
     * get start and end date for the corresponding given value.
     * 
     * @param integer $value
     * @return array 
     */
    public function getDates($value, $toDate = '')
    {
        $toDate = date("d-m-Y", strtotime($toDate));
        switch ($value)
        {
            case 2: // Yesterday
                $fromDate = $toDate;
                break;
            case 3: // Last 7 days
                $fromDate = strtotime($toDate . "-7 day");
                $fromDate = date("d-m-Y", $fromDate);
                $toDate   = strtotime($toDate . "-1 day");
                $toDate   = date("d-m-Y", $toDate);
                break;
            case 4: // Last week
                $fromDate = strtotime('last monday');
                $fromDate = date('W', $fromDate) == date('W') ? $fromDate - 7 * 86400 + 7200 : $fromDate;
                $fromDate = date("d-m-Y", $fromDate);
                $toDate   = strtotime('last sunday');
                $toDate   = date("d-m-Y", $toDate);
                break;
            case 5: // Last 14 days
                $fromDate = strtotime($toDate . "-14 day");
                $fromDate = date("d-m-Y", $fromDate);
                $toDate   = strtotime($toDate . "-1 day");
                $toDate   = date("d-m-Y", $toDate);
                break;
            case 6: // This month
                $fromDate = date("d-m-Y", strtotime(date('m') . '/01/' . date('Y') . ' 00:00:00'));
                $toDate   = $toDate;
                break;
            case 7: // Last 30 days
                $fromDate = strtotime($toDate . "-30 day");
                $fromDate = date("d-m-Y", $fromDate);
                $toDate   = strtotime($toDate . "-1 day");
                $toDate   = date("d-m-Y", $toDate);
                break;
            case 8: // Last month
                $fromDate = $this->getFromDate(0, 1, 1);
                $toDate   = strtotime($toDate);
                if (date("m", $toDate) == 01)
                {
                    $PrevMonth = 12;
                }
                else
                {
                    $PrevMonth = date("m", $toDate) - 1;
                }
                if ($PrevMonth == 12)
                {
                    $Year = date("Y", $toDate) - 1;
                }
                else
                {
                    $Year = date("Y", $toDate);
                }
                $daysCount = cal_days_in_month(CAL_GREGORIAN, $PrevMonth, $Year);
                $toDate    = $this->getFromDate(0, 1, $daysCount);
                break;
            case 9: // Today
                $fromDate = $toDate;
                break;
            default:
                $fromDate = date("d-m-Y", strtotime(date('m') . '/01/' . date('Y') . ' 00:00:00'));
                break;
        }
        $this->dateRange = array(
            'fromDate' => $fromDate,
            'toDate' => $toDate
        );
        return $this->dateRange;
    }
    /**
     * function getFromDate
     *
     * @param integer $day
     * @param integer $month
     * @param integer $new_day
     * @return date $fromDate 
     */
    private function getFromDate($day = '', $month = '', $new_day = '')
    {
        if ($day > 0)
        {
            $new_day = date("d") - $day;
        }
        $fromDate = mktime(0, 0, 0, date("m") - $month, $new_day, date("Y"));
        $fromDate = date("d-m-Y", $fromDate);
        return $fromDate;
    }
    /**
     * function getDays Between
     * 
     * Return no of days between two given dates
     *
     * @param date $fromDate
     * @param date $toDate
     * @return integer  
     */
    public function getDaysBetween($fromDate, $toDate, $id = '')
    {
        //echo $daysCount= ceil(abs(strtotime($fromDate) - strtotime($toDate)) / 86400);
        $diff      = strtotime($toDate) - strtotime($fromDate);
        $daysCount = intval((floor($diff / 86400)));
        /*if($id){*/
        $daysCount = $daysCount + 1;
        /*}*/
        return $daysCount;
    }
    
    /**
     * function getTicks
     * 
     * Generates ticks in x-axis based on the data.
     * USAGE: "ticks : ['.$this->getTicks().']" in getScript() function.
     * OPTIONAL: NOT USED CURRENTLY.
     *
     * @return string $ticks
     */
    private function getTicks()
    {
        foreach ($this->graphArray as $graph)
        {
            $graphX = $this->getUnixTime($graph[graphX]);
            $orderDay  = date('M-d', strtotime($graph[graphX]));
            $ticks     = $ticks . "[" . $graphX . "," . '"' . $orderDay . '"' . "],";
        }
        // Generates sample data for corresponding period with null value
        if ($ticks == NULL)
        {
            $graphX = $this->getDates($this->customDate);
            $fromDate  = $this->getUnixTime($graphX['fromDate']);
            $toDate    = $this->getUnixTime($graphX['toDate']);
            $orderDay  = date('M-d', strtotime($graph[graphX]));
            $ticks     = "[" . $fromDate . "," . '"' . $orderDay . '"' . "],[" . $toDate . "," . '"' . $orderDay . '"' . "]";
        }
        return $ticks;
    }
    /**
     * function setDate
     * 
     * @param string $fromDate
     * @param string $toDate
     */
    public function setDate($fromDate, $toDate)
    {
        $this->dateRange = array(
            'fromDate' => $fromDate,
            'toDate' => $toDate
        );
    }
    /**
     * function generateDates
     * 
     * @param string $fromDate
     * @param string $toDate
     */
    public function generateDates($fromDate, $toDate)
    {
        # // Firstly, format the provided dates.  
        // to strtotime().  
        $fromDate    = date("Y-m-d", strtotime($fromDate));
        $toDate      = date("Y-m-d", strtotime($toDate));
        // Start the variable off with the start date  
        $days[]      = $fromDate;
        // Set a 'temp' variable, currentDate, with  
        // the start date - before beginning the loop  
        $currentDate = $fromDate;
        // While the current date is less than the end date  
        while ($currentDate < $toDate)
        {
            // Add a day to the current date  
            $currentDate = date("Y-m-d", strtotime("+1 day", strtotime($currentDate)));
            // Add this new day to the aDays array  
            $days[]      = $currentDate;
        }
        return $days;
    }
	
	//Function to generate checkbox list
	private function generateCheckboxFilters()
	{
		//echo '<pre>';print_r($this->graphLabels);exit;
		$append='';
		foreach ($this->graphLabels as $key => $val)
        {
        	  $append=$append.'<input class="'.$this->filterCheckboxClass.'" type="checkbox" name="'.$val.'" checked="checked" value="'.$key.'">&nbsp;'.$val.'<br /><br />';  
        }
		return $append;	
		
	}
	
	//Function to generate ticks for bar graph
	private function generateTicksForbarGraph()
	{
		
		$ticks='';
		if(empty($this->ticksForbarGraph))
		{
		
			$ticks="null";	
			
		}
		elseif (is_array($this->ticksForbarGraph))
		{
			foreach($this->ticksForbarGraph as $key => $val)
			{
				
				$ticks=$ticks.'['.$key.',"'.$val.'"],';	
				
			}
			$ticks = substr($ticks, 0, -1);
			$ticks='['.$ticks.']';
			
		}
			
		return $ticks;
	}
	
	//Function to generate ticks for Line graph
	private function generateTicksForLineGraph()
	{
		
		$ticks='';
		if(empty($this->ticksForLineGraph))
		{
		
			$ticks="null";	
			
		}
		elseif (is_array($this->ticksForLineGraph))
		{
			foreach($this->ticksForLineGraph as $key => $val)
			{
				
				$ticks=$ticks.'['.$key.',"'.$val.'"],';	
				
			}
			$ticks = substr($ticks, 0, -1);
			$ticks='['.$ticks.']';
			
		}
			
		return $ticks;
	}
	
	//Function to include javascripts
	private function includeFlotScripts()
	{
		
		$includeScript= '<!--[if lte IE 8]><script language="javascript" type="text/javascript" src="'.$this->javascriptPath.'/flot/excanvas.min.js"></script><![endif]-->
				<script language="javascript" type="text/javascript" src="'.$this->javascriptPath.'/flot/jquery.flot.js"></script>
				<script language="javascript" type="text/javascript" src="'.$this->javascriptPath.'/flot/jquery.flot.resize.js"></script>
				<script language="javascript" type="text/javascript" src="'.$this->javascriptPath.'/flot/jquery.flot.grow.js"></script>
				';
				
		if($this->graphType!='pie' && $this->enableSelection!='false')
		{		
			$includeScript.= '<script language="javascript" type="text/javascript" src="'.$this->javascriptPath.'/flot/jquery.flot.selection.js"></script>';	
		}
		$includeScript.= '<script language="javascript" type="text/javascript" src="'.$this->javascriptPath.'/flot/jquery.flot.pie.js"></script>';	
		$GLOBALS['FlotScriptIncluded']='Yes';
		return $includeScript;
	}

		
	//Function to generate total	
	private function generateTotalLabels()
	{
		
		$totalStr='
		generateTotalLabels(dataSetArray);		
		function generateTotalLabels(dataArray)
		{
			var colorarray=new Array;
			var dataTotal = []; var dataSum=0; var i=0 ; var totalLabelAppend="";'; 
			$colorArray = $this->graphColors;
			for($i=0;$i<count($colorArray); $i++)
                {
            		$totalStr.= "colorarray[$i]='".$colorArray[$i]."';\n";
        	}
			if(count($this->graphArray)>0)
			{
				foreach ($this->graphArray as $key => $graph)
				{
					$dataSum=0;
					foreach ($graph as $graphInd)
						{
							$dataSum=$dataSum + $graphInd['graphY'];
						}
				$totalStr.= "dataTotal[$key]='".$dataSum."';\n";		
				}
				
			}			
			$totalStr.=$this->getGraphTotalLabels();
			$totalStr.='
			
			//console.log(dataArray);	
			
			$.each(dataTotal, function(key, value) {
						var spanText = "<span class=\'color-box\' style=\'background-color:"+colorarray[key]+"\'></span>";
						totalLabelAppend = totalLabelAppend + "<li>"+ spanText + dataArray[key].totalLabels	+" : " + value +"</li>";
			
			});
			';
			if($this->graphTotalHolder!='')
			{
			$totalStr.='
			totalLabelAppend = "<ul class= '.$this->graphTotalHolderUlClass.'>"+ totalLabelAppend +"</ul>"
			$(".'.$this->graphTotalHolder.'").html(totalLabelAppend);
			$(".'.$this->graphTotalHolderUlClass.'").addClass("clearfix");
			';
			
			}
		$totalStr.='}';
				
		return $totalStr;
		
	}
	
	//get graph Total labels
	private function getGraphTotalLabels()
	{
		
		$graphTotals='var dataTotalLabels = [];';
		$i=0;
		$totalLabel='';
		if(!empty($this->graphTotalLabels))
		{
			foreach($this->graphTotalLabels as $val)
			{
				$totalLabel = $totalLabel.'dataTotalLabels['.$i.']="'.$val.'"; ';		
				$i++;
			}	
			
		}
		
		return $graphTotals.$totalLabel;
	}
		
}