<?php

class Geoip 
{
	// ------------------------------------------------------------------------
	/**
	* Constructor
	*
	* @param array
	*/
	public $provider_loaded=false;
	public $provider;
	public $apiKey;
	public function __construct($providerSettings = array())
	{
		
		$this ->provider	= $providerSettings['provider'];
		$this ->apiKey		= $providerSettings['apiKey'];
		if($this ->provider=='geoip')
		{
			if(self::isGeoipAvailable())
			{
				include_once (__LIBRARY_PATH.'/geoip/LocationProvider/Pecl.php');
				$this ->_provider = new Pecl();
				$this->provider_loaded=true;
			}
			else
			{
				$this->provider_loaded=false;
			}
		}
		else if($this ->provider=='maxmind')
		{
			if($this ->apiKey!='')
			{
				include_once (__LIBRARY_PATH.'/geoip/LocationProvider/MaxMind.php');
				$this ->_provider = new MaxMind($this ->apiKey);
				$this->provider_loaded=true;
			}
			else
			{
				$this->provider_loaded=false;
			}
		}
		else
		{
			if($this ->apiKey!='')
			{
				include_once (__LIBRARY_PATH.'/geoip/LocationProvider/Ipinfodb.php');
				$this ->_provider = new Ipinfodb($this ->apiKey);
				$this->provider_loaded=true;
			}
			else
			{
				$this->provider_loaded=false;
			}
		}
		
	}
	
	// ------------------------------------------------------------------------
	public function getCity($ip)
	{
		if($this->provider_loaded)
		{
			$result = $this->_provider-> getCity($ip);
			return $result;
		}
		else
		{
			return false;
		}
	}
	/**
     * Returns true if the PECL module is installed and loaded, false if otherwise.
     *
     * @return bool
     */
    public function isGeoipAvailable()
    {
        return function_exists('geoip_db_avail');
    }
	/**
     * Returns true if the PECL module can detect a city database.
     *
     * @return bool
     */
    public function isCityDatabaseAvailable()
    {
        return geoip_db_avail(GEOIP_CITY_EDITION_REV0)
            || geoip_db_avail(GEOIP_CITY_EDITION_REV1);
    }
	
}
// End Class

/* End of file Geoip.Class.php */
/* Location: ./libraries/geoip/Geoip.Class.php */