<?php
/*

Ref - http://dev.maxmind.com/geoip/legacy/web-services/#PHP
return data as a set of comma-separated fields. The ISP name, 
Organization name, and AS number fields are quoted, 
since they may contain a comma. The other fields 
are not escaped or quoted, but they will never contain a comma.
Return Order
	City/ISP/Org	
	Country code
	Region code
	City name
	Postal code
	Latitude
	Longitude
	Metro code
	Area code
	ISP name
	Organization name
	Error
*/
class MaxMind 
{
	###################### IP BASED CITY  ############################
	protected $service 	= 'https://geoip.maxmind.com/f?';
	protected $version 	= 'v1';
	protected $apiKey 	= '';	
	public function __construct($apiKey)
	{
		$this->apiKey=$apiKey;
	}
	public function getCity($hostIP) 
	{
		$params = getopt('l:i:');

		if (!isset($params['l'])) $params['l'] = $this->apiKey;
		if (!isset($params['i'])) $params['i'] = $hostIP;

		$query = $this->service.http_build_query($params);


		$curl = curl_init();
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);

		curl_setopt_array(
			$curl,
			array(
				CURLOPT_URL => $query,
				CURLOPT_USERAGENT => 'MaxMind PHP Sample',
				CURLOPT_RETURNTRANSFER => true
			)
		);
		curl_setopt($curl, CURLOPT_TIMEOUT,4);
		$resp = curl_exec($curl);

		$returnData = explode(",", $resp); 

		$result['countryName'] 		= $returnData[0];
		$result['region'] 			= $returnData[1];
		$result['cityName'] 		= utf8_encode($returnData[2]);
		$result['area_code'] 		= $returnData[7];
		$result['latitude'] 		= $returnData[4];
		$result['longitude'] 		= $returnData[5];
		$result['postal_code'] 		= $returnData[3];
		return $result;
	}
}