<?php
/*
A GeoIP database can be used to accurately determine the location of 
your visitors based on their IP address. A PECL (PHP Extension Community Library) 
extension will give you a very fast solution, compared to MaxMind's PHP API where 
the database has to be loaded for each request.
@version 0.1a
 */
class Pecl 
{
	###################### IP BASED CITY  ############################

	public function getCity($hostIP)
	{
		
		$result = array();
        // get location data
        if (self::isCityDatabaseAvailable()) 
		{
            // Must hide errors because missing IPV6:
            $location = @geoip_record_by_name($hostIP);
            if (!empty($location)) 
			{
                $result['countryName'] 				= $location['country_name'];
                $result['region'] 					= $location['region'];
                $result['cityName'] 				= utf8_encode($location['city']);
                $result['area_code'] 				= $location['area_code'];
                $result['latitude'] 				= $location['latitude'];
                $result['longitude'] 				= $location['longitude'];
                $result['postal_code'] 				= $location['postal_code'];
            }
			return $result;
        }
		else
		{
			return false;
		}	
	}
	/**
     * Returns true if the PECL module can detect a city database.
     *
     * @return bool
     */
    public static function isCityDatabaseAvailable()
    {
        return geoip_db_avail(GEOIP_CITY_EDITION_REV0)
            || geoip_db_avail(GEOIP_CITY_EDITION_REV1);
    }
	
}