<?php

class Mail {

    public $from;
    public $to;
    public $content;
    public $subject;
    public $mail;
    private $mailer = 'mail';

    public function  __construct($settings)
    {
        $this->setPHPMailer();
		$this->mail =  new PHPMailer();
        $this->mail->PluginDir = __LIBRARY_PATH.'/mail/';
        if(isset($settings['charset'])){
            $this->mail->set('CharSet', $settings['charset']);
        }
        else{
            $this->mail->set('CharSet', 'utf-8');
        }
        if(isset($settings['sendmail_engine']) && $settings['sendmail_engine']=='smtp') {
            $this->mail->IsSMTP();
            $this->setConnection($settings);
        }
        else{
            $this->mail->IsMail();
        }
    }
	
	public function setPHPMailer()
    {
		$mailer_class_file = __LIBRARY_PATH.'/mail/class.phpmailer.php';
		if(file_exists($mailer_class_file)) { 
            include_once($mailer_class_file);
        } else {
            return false;
        }
	
	}
    public function SendLocalEmail($to,$subject,$body) {
		$headers = "";
		$headers .= "From: \"ispg.in\" <mail@ispg.in>\n";
		$headers .= "Return-Path: {$from}\n";  
		$headers .= "Content-Type: text/html; charset=iso-8859-1\n"; 
		return mail($to, $subject, $body, $headers);
	}

    public function setConnection($settings)
    {
        $this->mail->set('Host' ,    $settings['smtp_host']);
        $this->mail->set('Port' ,    $settings['smtp_port']);
        $this->mail->set('Username', $settings['smtp_username']);
        $this->mail->set('Password', $settings['smtp_password']);
        if(!empty($settings['time_out']))
            $this->mail->set('Timeout',  $settings['time_out']);
        if(!empty($settings['smtp_security_settings']))
            $this->mail->set('SMTPSecure',$settings['smtp_security_settings']);
        return true;
    }

    public function sendMail($from,$to,$subject,$body,$send=false,$replyTo='')
    {
        
        if(is_array($from)) {
            $this->mail->SetFrom($from[0],$from[1]);
        }
        else {
            $this->mail->SetFrom($from[0]);
            //$this->mail->From = $from;
        }
        if(is_array($to)) {
            foreach($to as $id) {
                if(is_array($id))
                    $this->mail->AddAddress($id[0],$id[1]);
                else
                    $this->mail->AddAddress($id);
            }
        }
        else if($to !=''){
            $this->mail->AddAddress($to);
        }
		else if($replyTo !=''){
            $this->mail->AddReplyTo($replyTo);
        }
        else {
            throw new Exception("Please specify atleast one to address");
        }
        $this->mail->Subject = $subject;
        $this->mail->Body    = $body;
        $this->mail = $this->mail;
        if($send == true)
            return $this->mail->Send();
        else
            return true;
    }
    public function AddCC($address, $name = '')
    {
        return $this->mail->AddCC($address, $name = '');
    }

    public function AddBCC($address, $name = '')
    {
        return $this->mail->AddBCC($address, $name = '');
    }

    public function AddReplyTo($address, $name = '')
    {
        return $this->mail->AddReplyTo($address, $name = '');
    }

    public function Send()
    {
        //var_dump($this->mail); exit;
        return $this->mail->Send();
    }

    public function IsHTML($val=true)
    {
		return $this->mail->IsHTML($val);
    }
    public function ClearAddresses()
    {
        return $this->mail->ClearAddresses();
    }
    public function AddAttachment($path, $name = '', $encoding = 'base64', $type = 'application/octet-stream'){
        return $this->mail->AddAttachment($path, $name , $encoding , $type );
    }
}