<?php
class BeanstreamModel extends PaymentModel
 {
 	public $gwresponse = '';
  	public $commErrNo = 0;
 	public $commError = ''; 	
	public function process($order='',$orderItems='') 
	{ 
	//echo '<pre>';print_r($order);
			$ObjCurrency	= new CurrencyModel();
			$ObjCountry     = new CountryModel();
			$ObjState       = new StateModel();
			$languageIDs['Default']=1;
			$languageIDs['Current']=1;
			$countryCode 		= $ObjCountry->getCountryCode(
			$order['billingAddress']['billingCountry']);
			
			if ($order['billingAddress']['billingState'] >0)
            {
            $getStateDetails = $ObjState->getStateDetails($languageIDs, 
			$order['billingAddress']['billingState']);
            $stateCode       = $getStateDetails['stateShortName'];
            }
            else
            {
             	$stateCode = $order['billingAddress']['billingState'];
            }
		
			parent::listPaymentSettingsValues($order['paymentSettingsGroupID']);
			$payAmount				=	$order['orderTotalAmount'];
			$taxAmount				=	$order["orderTaxAmount"];
			$shippingAmount  		= 	$order["shippingAmount"];
			$serviceCharge   		= 	$order["orderOtherServiceCharge"];
			
			$paymentCurrency 		= 	$this->settingsVars["payment_currency"];
			if ($paymentCurrency != '')
        	{
            	$paymentCurrency = str_replace(", ", ",", $paymentCurrency);
            	$currencyArr     = explode(",", $paymentCurrency);
        	}
			if(count($currencyArr)<1)
			{
				$this->isError 		= true;
				$this->errorMessage	= "Currency not configured , Please contact the site admin";
				return false;
			}
			else
			{
				$currencyFlag = false;
				$purchasedCurrencyDetails = $ObjCurrency->getCurrencyByCurrencyID($order["purchasedCurrency"]);
				$systemCurrencies 		=	$ObjCurrency->listCurrencyCodes();
				if(!in_array($purchasedCurrencyDetails['currencyCode'],$currencyArr))
				{
					foreach ($systemCurrencies as $key => $currency)
        			{
						if(in_array($currency['currencyCode'],$currencyArr))
						{
							$currencyFlag = true;
							$supportedCurrencyCode 	= $currency['currencyCode'];	
							$supportedCurrencyID 	= $currency['currencyID'];
							break;
						}
					}
					if($currencyFlag==true)
					{
						$payAmount = $ObjCurrency->convertValueCustom($payAmount,$order["purchasedCurrency"],$supportedCurrencyID);
						$taxAmount = $ObjCurrency->convertValueCustom($taxAmount,$order["purchasedCurrency"],$supportedCurrencyID);
						$shippingAmount = $ObjCurrency->convertValueCustom($shippingAmount,$order["purchasedCurrency"],
						$supportedCurrencyID);
						$serviceCharge = $ObjCurrency->convertValueCustom($serviceCharge,$order["purchasedCurrency"],
						$supportedCurrencyID);
					}
					else
					{
						$this->isError 		= true;
						$this->errorMessage	= "Currency not configured , Please contact the site admin";
						return false;
					}
					
				}
			}
			
			if($payAmount<.01)
			{
				$this->isError 		= true;
				$this->errorMessage	= "Invalid amount , please use another method";
				return false;
			}
			
			if($order['authValue']=='Authorization') 
			{
				$authOnly			=	'AUTH_ONLY';
				$trnType 			=	'PA';			
			} 
			else 
			{				
				$authOnly			=	'AUTH_CAPTURE';	
				$trnType 			=	'P';	
			}	
			$customerid 			=   $order["userID"];
			
			$prods_data 			= array();
			$itemsAmount = 0;
			for ($i=0, $n=sizeof($orderItems); $i<$n; $i++) 
			{
				$fldName = ($order['orderType'] == 'deal') ? 'dealOptionName' : 'itemName';
				$j = $i + 1;
				if($currencyFlag==true)
				{
					$orderItemPrice = $ObjCurrency->convertValueCustom($orderItems[$i]['orderItemPrice'],
					$order["purchasedCurrency"],$supportedCurrencyID);
					
					$orderItemSubtotal = $ObjCurrency->convertValueCustom($orderItems[$i]['orderItemSubtotal'],
					$order["purchasedCurrency"],$supportedCurrencyID);
				}
				else
				{
					$orderItemPrice = $orderItems[$i]['orderItemPrice'];
					$orderItemSubtotal = $orderItems[$i]['orderItemSubtotal'];
				}
				$prods_data 			= array_merge($prods_data, array
																	(
																	 'prod_id_'.$j 		=> $j,
																	 'prod_name_'.$j 		=> $orderItems[$i][$fldName],
																	 'prod_quantity_'.$j  => $orderItems[$i]['orderItemQuantity'],
																	 'prod_cost_'.$j => number_format($orderItemPrice, 2, '.', '') 
																	 )
													  );
													  
				$itemsAmount += $orderItemSubtotal;									  
			}
			
			
    		$trans_data 			= 	array
										(
										 'trnType' 			=> $trnType,
										 'paymentMethod' 	=> 'CC',  // (or IO for Interac)
										 'trnOrderNumber'	=> 'ORD MSTR -'.$order["masterOrderID"].'-'.rand(1000,10000),
										 'trnCardOwner' 	=> $order['postData']['creditCardFirstName'].' '.
										 $order['postData']['creditCardLastName'],
										 'trnCardNumber' 	=> $order['postData']["creditCardNumber"],
										 'trnExpMonth' 		=> $order['postData']["expMonth"],
										 'trnExpYear' 		=> substr($order['postData']["expYear"],2,2),
										 'trnCardCvd' 		=> $order['postData']['securityCode'],
										 'trnAmount' 		=> number_format($payAmount, 2, '.', ''),
										 'ordItemPrice' 	=> number_format($itemsAmount, 2, '.', ''),
										 'ordTax1Price' 	=> number_format($taxAmount, 2, '.', ''),
										 'ordShippingPrice' => number_format($shippingAmount, 2, '.', ''),
										 'ordName' 			=> $order['billingAddress']['billingFirstName'] .
										  ' ' . $order['billingAddress']['billingLastName'],
										 'ordAddress1' 		=> $order['billingAddress']['billingAddress1'],
										 'ordAddress2' 		=> $order['billingAddress']['billingAddress2'],
										 'ordCity' 			=> $order['billingAddress']['billingCity'],
										 'ordProvince' 		=> $stateCode,
										 'ordPostalCode'	=> $order['billingAddress']['billingZip'],
										 'ordCountry' 		=> $countryCode,
										 'ordPhoneNumber' 	=> $order['billingAddress']['billingPhone'],
										 'ordEmailAddress' 	=> $order['billingAddress']['billingEmail'],
										 'shipName' 		=> $order['shippingAddress']['shippingFname'] .
										  ' ' . $order['shippingAddress']['shippingLname'],
										 'shipProvince' 	=> $stateCode,
										 'shipAddress1' 	=> $order['shippingAddress']['shippingAddress1'],
										 'shipAddress2' 	=> $order['shippingAddress']['shippingAddress2'],
										 'shipCity' 		=> $order['shippingAddress']['shippingCity'],
										 'shipPostalCode' 	=> $order['shippingAddress']['shippingZip'],
										 'shipCountry'	 	=> $countryCode
										 );	
										 		
			$submit_data = array_merge($trans_data,$prods_data);
			unset($response);
			//echo '<pre>';print_r($submit_data);exit;
    		$response = $this->sendRequest($submit_data);
			if($response['trnApproved'] == 1)
			{			
				$paymentMethodName			=	$this->settingsVars["payment_method_name"];	
				$replyText 					=   ''; 
				foreach($response as $key => $values)
				{
					$replyText  		   .= 	$key.' : '.$values."\n";	
				}			
				parent::createTransaction($order, $response['trnId'],$replyText , "", $authOnly,0,$paymentMethodName,$supportedCurrencyID,$payAmount);								
				if($order['store_cc_info']=='Yes') 
				{									
					parent::saveCCdata($order['postData'],$order["userID"]);
				}
				$this->isError = false;
				$this->errorMessage = "";
				return "Pending";					
			} 
			else
			{
				$this->isError 		= true;
				$this->errorMessage	= "An error occurred : ".urldecode($response['messageText']);		
			} 
			return !$this->isError;		
	}

	public function processCustom($order='') 
	{
			$ObjCurrency			= new CurrencyModel();
			parent::listPaymentSettingsValues($order['paymentSettingsGroupID']);
			$getPaymentTransactionDetails = parent::getPaymentTransactionDetails(0,
			$order["masterOrderID"]);	
			$this->isError = false;
			//check is transaction completed
			if ($order["paymentType"] != "AUTH_ONLY" || $order["paymentStatus"]=='Received' )
			{
				$this->isError 		= true;
				$this->errorMessage = "Transaction already completed";
				return false;
			}
			$capturedTotalAmount 	= $getPaymentTransactionDetails["convertedPaymentAmount"];
			$comp_amount 			= number_format($capturedTotalAmount, 2, '.', '');
			
			$transactionID			= $order["transactionID"];	
			$customerid 			= $order["userID"];
    		$trans_data 			= array
										(
										 'trnType' 			=> 'PAC',
										 'adjId'			=> $transactionID,
										 'trnAmount'		=> $comp_amount
										 );	
			unset($response);
    		$response = $this->sendRequest($trans_data);
			if($response['trnApproved'] == 1)
			{						
					$paymentMethodName			=	$this->settingsVars["payment_method_name"];
					$replyText 					=  ''; 
					foreach($response as $key => $values)
					{
						$replyText  		   .= 	$key.' : '.$values."\n";	
					}							
					parent::createTransaction($order,  $transactionID,"ORDER TYPE: PRIOR_AUTH_CAPTURE\n\n".$replyText, "", "AUTH_CAPTURE",0,$paymentMethodName,
					$getPaymentTransactionDetails["paymentCurrencyID"],$capturedTotalAmount);
					return "Success";								
			} 
			else
			{
					$this->logStart();
					$this->log($buffer,$this->settingsVars["payment_processor_id"]);
					$this->logFinish();
					$this->isError = true;
						$this->errorMessage = "We are sorry, but there has been an error processing this transaction.<br>Payment gateway response: ".urldecode($response['messageText']);

			} 				
			return !$this->isError;
	}	
	
	function sendRequest($submit_data) 
	{		
		// Populate an array that contains all of the data to be sent to the gateway
		$submit_data 				= array_merge(array
													(
													 'merchant_id' => $this->settingsVars["beanstream_Merchant_id"],
													 'username' => $this->settingsVars["transaction_user_name"],
													 'password' => $this->settingsVars["transaction_passwd"],
													 'RequestType' => 'BACKEND', // Force API mode
													 ), $submit_data);
		// set URL
		$url		 				= $this->settingsVars["payment_gateway_url"];
		// concatenate the submission data into $data variable after sanitizing
		$data 						= '';
		while(list($key, $value) 	= each($submit_data)) 
		{
		  $value 					= str_replace(array('"',"'",'&amp;','&', '='), '', $value);
		  $data 				   .= $key . '=' . urlencode($value) . '&';
		}
		// Remove the last "&" from the string
		$data 						= substr($data, 0, -1);
		// Post order info data to Beanstream via CURL - Requires that PHP has cURL support installed
		// Send CURL communication
		$ch 						= curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_VERBOSE, 0);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_TIMEOUT, 15);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE); /* compatibility for SSL communications on some Windows servers (IIS 5.0+) */
		$this->gwresponse 			= curl_exec($ch);
		$this->commError 			= curl_error($ch);
		$this->commErrNo 			= curl_errno($ch);
		$this->commInfo 			= @curl_getinfo($ch);
		curl_close ($ch);
		// if in 'echo' mode, dump the returned data to the browser and stop execution
		if ($this->settingsVars["payment_test"] == 'On') 
		{
		  echo $this->gwresponse . ($this->commErrNo != 0 ? '<br />' . $this->commErrNo . ' ' . $this->commError : '') . '<br />';
		  die('Press the BACK button in your browser to return to the previous page.');
		}
	
		// parse the data received back from the gateway
		$pairs						= explode('&', str_replace(array("\r\n","\n"), '', $this->gwresponse));
		$response 					= array();
		foreach ($pairs as $pair) 
		{
		  list($name, $value) 		= explode('=', $pair);
		  $response[$name] 			= $value;
		}			
		///// ERRORS ////
		/*
		 * errorType --- N=None, S=System-Error, U=User-Error
		 * errorMessage --- descriptive message of all errors in the transaction -- can be used to help customer correct mistakes and resubmit
		 * errorFields --- comma-separated list of all fields containing invalid data -- could be used for custom order-handling or to flag fields needing attention
		 * NOTE: errorMessage and errorFields are urlencoded.
		 */
		return $response;
	}			
}