<?php
/***************************************************************************
 *                                                                          *
 * Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
 *                                                                          *
 * This  is  commercial  software,  only  users  who have purchased a valid *
 * license  and  accept  to the terms of the  License Agreement can install *
 * and use this program.                                                    *
 *                                                                          *
 ****************************************************************************
 * PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
 * "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
 ****************************************************************************/
//
//$Id: eWayExpressCheckoutModel.php, v 1.0 2011/06/14 20:52:11

//
class EWayExpressCheckoutModel extends PaymentModel
{
    public function process($order = '',$orderItems = '')//payment processing
    {
		$ObjCurrency	= new CurrencyModel();
        $ObjSettings 	= new SettingsModel();
		$ObjCountry     = new CountryModel();
		$ObjState       = new StateModel();
		$languageIDs    =  $this->ObjView->languageIDs;
        parent::listPaymentSettingsValues($order['paymentSettingsGroupID']);
        $payAmount       = $order['orderTotalAmount'];
		$supportedCurrencyID	= $order["purchasedCurrency"];
		
        $paymentCurrency	=	$this->settingsVars["payment_currency"];
		$currencyArr		= '';
		$itemsArray  		= '';
		if ($paymentCurrency != '')
		{
			$paymentCurrency = str_replace(", ", ",", $paymentCurrency);
			$currencyArr     = explode(",", $paymentCurrency);
		}
		if(count($currencyArr)<1)
		{
			$this->isError 		= true;
			$this->errorMessage	= "Currency not configured , Please contact the site admin";
			return false;
		}
		else
		{
			$currencyFlag = false;
			$purchasedCurrencyDetails 	= $ObjCurrency->getCurrencyByCurrencyID($order["purchasedCurrency"]);
			$currencyCode				= $purchasedCurrencyDetails['currencyCode'];
			$systemCurrencies 			= $ObjCurrency->listCurrencyCodes();
			if(!in_array($purchasedCurrencyDetails['currencyCode'],$currencyArr))
			{
				foreach ($systemCurrencies as $key => $currency)
				{
					if(in_array($currency['currencyCode'],$currencyArr))
					{
						$currencyFlag = true;
						$supportedCurrencyCode 	= $currency['currencyCode'];	
						$supportedCurrencyID 	= $currency['currencyID'];
						break;
					}
				}
				if($currencyFlag==true)
				{
					$payAmount = $ObjCurrency->convertValueCustom($payAmount,$order["purchasedCurrency"],$supportedCurrencyID);
					$currencyCode		=	$supportedCurrencyCode;
				}
				else
				{
					$this->isError 		= true;
					$this->errorMessage	= "Currency not configured , Please contact the site admin";
					return false;
				}
				
			}
		}
		
		if($payAmount<.01)
		{
			$this->isError 		= true;
			$this->errorMessage	= "Invalid amount , please use another method";
			return false;
		}
		
		$paymentAmount = urlencode($payAmount);
        $currencyID    = urlencode($currencyCode);
        $paymentType   = urlencode($order['authValue']);  
        $itemsArray = '';
        $itemAmount = 0;
			if (!empty($orderItems))
			{
				foreach ($orderItems as $key => $ordItem)
				{
					$orderGiveAsGift = '';
					if ($ordItem['orderGiveAsGift'] == 'Yes')
					{
						$orderGiveAsGift = ' (As Gift)';
					}
					$fldName = ($order['orderType'] == 'deal') ? 'dealOptionName' : 'itemName';
					$itemsArray .= htmlspecialchars(substr($ordItem[$fldName], 0, 110) . $orderGiveAsGift . " Quantity - ". $ordItem['orderItemQuantity']." ");
				}
			}

		$languageIDs['Current']=1;
		$country 		= $ObjCountry->getCountryDetails($order['billingAddress']['billingCountry'],$languageIDs);
		$countryName 	= $country['countryName'];
		if ($order['billingAddress']['billingState'] >0)
		{
			$getStateDetails = $ObjState->getStateDetails($languageIDs,$order['billingAddress']['billingState']);
			$stateName       = $getStateDetails['stateShortName'];
		}
		else
		{
			$stateName = $order['billingAddress']['billingProvince'];
		}
		
		// supports 255 characters
		$invoiceDesc =	substr($itemsArray,0,255);	
        $totalAmount = ceil($payAmount);
        $totalAmount = number_format($totalAmount, 2, ".", "");
        $returnURL   = urlencode($order['returnURL']);
        $cancelURL   = urlencode($order['cancelURL']);
        //$siteDesc    = urlencode($postForm['siteDesc']);
		$siteDesc    = $order['siteDesc'];
        $ewayUrl .= "?CustomerID=" . $this->settingsVars["customer_id"];
        $ewayUrl .= "&UserName=" . $this->settingsVars["user_name"];
        $ewayUrl .= "&Amount=" . $totalAmount;
        $ewayUrl .= "&Currency=AUD";
        $ewayUrl .= "&PageTitle=" . $order['site_name'];
        $ewayUrl .= "&PageDescription=". $invoiceDesc;
        $ewayUrl .= "&PageFooter=".$order['site_name'];
		/*
		Supported langs
		English EN
		Spanish ES
		French FR
		German DE
		Dutch NL*/
		/*
		if($order['languageCode']!='')
		{
			$languageCode = strtoupper($order['languageCode']);
			$ewayLangs = array('EN','ES','FR','DE','NL');
			if (in_array($languageCode, $ewayLangs)) 
			{
				$ewayUrl .= "&Language=".$languageCode;
			}
		}*/
		$ewayUrl .= "&Language=EN";
        $ewayUrl .= "&CompanyName=" . $order['company_name'];
        $ewayUrl .= "&CustomerFirstName=" . $order['billingAddress']['billingFirstName'];
        $ewayUrl .= "&CustomerLastName=" . $order['billingAddress']['billingLastName'];
        $ewayUrl .= "&CustomerAddress=" . $order['billingAddress']['billingAddress1'];
        $ewayUrl .= "&CustomerCity=" . $order['billingAddress']['billingCity'];
        $ewayUrl .= "&CustomerState=" . $stateName;
        $ewayUrl .= "&CustomerPostCode=" . $order['billingAddress']['billingZip'];
        $ewayUrl .= "&CustomerCountry=".$countryName;
        $ewayUrl .= "&CustomerEmail=" . $order['billingAddress']['billingEmail'];
        $ewayUrl .= "&CustomerPhone=" . $order['billingAddress']['billingPhone'];
        $ewayUrl .= "&InvoiceDescription=" . $invoiceDesc;
        $ewayUrl .= "&CancelURL=" . $cancelURL;
        $ewayUrl .= "&ReturnUrl=" . $returnURL;
        $ewayUrl .= "&CompanyLogo=" . $order['companyLogo'];
        $ewayUrl .= "&PageBanner=";
        $ewayUrl .= "&MerchantReference=MSTRORD-" . $order['masterOrderID'];
        $ewayUrl .= "&MerchantInvoice=MSTRORD-" . $order['masterOrderID'];
        $ewayUrl .= "&MerchantOption1=";
        $ewayUrl .= "&MerchantOption2=";
        $ewayUrl .= "&MerchantOption3=";
        $ewayUrl .= "&ModifiableCustomerDetails=False";
        $spaceReplace = str_replace(" ", "%20", $ewayUrl);
        $postUrl      = $this->settingsVars["payment_gateway_url"] . "/Request/" . $spaceReplace;
        $ch           = curl_init();
        curl_setopt($ch, CURLOPT_URL, $postUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HEADER, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        if (CURL_PROXY_REQUIRED == 'True') {
            $proxyTunnelFlag = (defined('CURL_PROXY_TUNNEL_FLAG') && strtoupper(CURL_PROXY_TUNNEL_FLAG) == 'FALSE') ? false : true;
            curl_setopt($ch, CURLOPT_HTTPPROXYTUNNEL, $proxyTunnelFlag);
            curl_setopt($ch, CURLOPT_PROXYTYPE, CURLPROXY_HTTP);
            curl_setopt($ch, CURLOPT_PROXY, CURL_PROXY_SERVER_DETAILS);
        }
        $response = curl_exec($ch);
        if (!$response) {
            $this->errorMessage = curl_error($ch) . '(' . curl_errno($ch) . ')';
        }
        function fetchData($string, $startTag, $endTag)//featching data from xml response
        {
            $position      = stripos($string, $startTag);
            $str           = substr($string, $position);
            $strSecond     = substr($str, strlen($startTag));
            $secondPositon = stripos($strSecond, $endTag);
            $strThird      = substr($strSecond, 0, $secondPositon);
            $fetchData     = trim($strThird);
            return $fetchData;
        }
        $responseMode = fetchData($response, '<result>', '</result>');
        $responseUrl  = fetchData($response, '<uri>', '</uri>');
        if ($responseMode == "True") {
            $this->isError      = false;
            $this->errorMessage = "";
            header("location: " . $responseUrl);
            exit;
        } else {
            $responseError      = fetchData($response, '<error>', '</error>');
            $this->isError      = true;
            $this->errorMessage = $this->escape($responseError);
            return !$this->isError;
        }
    }
    
    public function response($accessPaymentCode, $order = '',$orderItems = '')//getting checkout response
    {
		$ObjCurrency	= new CurrencyModel();
        parent::listPaymentSettingsValues($order['paymentSettingsGroupID']);
		$amount = $order['orderTotalAmount'];
		$rescurrency = parent::getSupportingCurrencyDetails($order['purchasedCurrency'],
		$order['paymentSettingsGroupID']);	
		if($rescurrency['currencyID']>0)
		{
			$amount = $ObjCurrency->convertValueCustom($amount,$currency,
			$rescurrency['currencyID']);	
		}
        $ewayUrl .= "?CustomerID=" . $this->settingsVars["customer_id"];
        $ewayUrl .= "&UserName=" . $this->settingsVars["user_name"];
        $ewayUrl .= "&AccessPaymentCode=" . $accessPaymentCode;
        $spaceReplace = str_replace(" ", "%20", $ewayUrl);
        $postUrl      = $this->settingsVars["payment_gateway_url"] . "/Result/" . $spaceReplace;
        $ch           = curl_init();
        curl_setopt($ch, CURLOPT_URL, $postUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HEADER, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        if (CURL_PROXY_REQUIRED == 'True') {
            $proxyTunnelFlag = (defined('CURL_PROXY_TUNNEL_FLAG') && strtoupper(CURL_PROXY_TUNNEL_FLAG) == 'FALSE') ? false : true;
            curl_setopt($ch, CURLOPT_HTTPPROXYTUNNEL, $proxyTunnelFlag);
            curl_setopt($ch, CURLOPT_PROXYTYPE, CURLPROXY_HTTP);
            curl_setopt($ch, CURLOPT_PROXY, CURL_PROXY_SERVER_DETAILS);
        }
        function fetchData($string, $startTag, $endTag)//featching data from xml response
        {
            $position      = stripos($string, $startTag);
            $str           = substr($string, $position);
            $strSecond     = substr($str, strlen($startTag));
            $secondPositon = stripos($strSecond, $endTag);
            $strThird      = substr($strSecond, 0, $secondPositon);
            $fetchData     = trim($strThird);
            return $fetchData;
        }
        $response            = curl_exec($ch);
        $trxnNumber          = fetchData($response, '<trxnnumber>', '</trxnnumber>');
        $trxnStatus          = fetchData($response, '<trxnstatus>', '</trxnstatus>');
        $trxnResponseMessage = fetchData($response, '<trxnresponsemessage>', '</trxnresponsemessage>');
        $trxnStatus          = strtolower($trxnStatus);
        $merchantReference   = fetchData($response, '<merchantreference>', '</merchantreference>');
        $merchantInvoice     = fetchData($response, '<merchantinvoice>', '</merchantinvoice>');
        if ($trxnStatus == "true") {
            $response = "Success";
        } else {
            $response = "Failed";
        }
        $response .= " responsemessage : " . $trxnResponseMessage;
        $response .= " trxnnumber : " . $trxnNumber;
        $response .= " merchantreference : " . $merchantReference;
        $response .= " merchantinvoice : " . $merchantInvoice;
        if ($trxnStatus == "true") {
            parent::createTransaction($order, $trxnNumber, str_replace("~", "\n", $response), 
			"", 'AUTH_CAPTURE', $paymentGatewayCharge, $paymentMethodName,
			$rescurrency['currencyID'],number_format($amount, 2, ".", ""));
            $this->isError      = false;
            $this->errorMessage = "";
            return "Pending";
            
        } else {
            $this->isError      = true;
            $this->errorMessage = stripslashes($trxnResponseMessage);
            if ($this->isError && $this->errorMessage != '') {
                parent::createTransactionError($order, $trxnNumber, "ORDER TYPE: PRIOR_AUTH_CAPTURE\n\n" . str_replace("~", "\n", $httpResponse), "", "AUTH_CAPTURE", $paymentGatewayCharge, $paymentMethodName);
            }
            return !$this->isError;
        }
    }
    public function processRefund($order = '', $postValues = '', $orderItems = '')//payment refunding process
    {
        parent::listPaymentSettingsValues($postValues['paymentSettingsGroupID']);
		$paymentTxnDetails	= $this->getPaymentTransactionDetails('',$order['masterOrderID']);
		$refundAmount		= $order['orderTotalAmount'];
        $ObjRefund         = new RefundModel();
		$ObjCurrency		= new CurrencyModel();
		
		$supportedCurrencyID = $order["purchasedCurrency"];
		$paymentCurrency	 = $this->settingsVars["payment_currency"];
		
		if ($paymentCurrency != '')
		{
			$paymentCurrency = str_replace(", ", ",", $paymentCurrency);
			$currencyArr     = explode(",", $paymentCurrency);
		}
		if(count($currencyArr)<1)
		{
			$this->isError 		= true;
			$this->errorMessage	= "Currency not configured , Please contact the site admin";
			//return false;
		}
		else
		{
			$currencyFlag = false;
			$purchasedCurrencyDetails 	= $ObjCurrency->getCurrencyByCurrencyID($order["purchasedCurrency"]);
			$currencyCode				= $purchasedCurrencyDetails['currencyCode'];
			$systemCurrencies 			= $ObjCurrency->listCurrencyCodes();
			if(!in_array($purchasedCurrencyDetails['currencyCode'],$currencyArr))
			{
				foreach ($systemCurrencies as $key => $currency)
				{
					if(in_array($currency['currencyCode'],$currencyArr))
					{
						$currencyFlag = true;
						$supportedCurrencyCode 	= $currency['currencyCode'];	
						$supportedCurrencyID 	= $currency['currencyID'];
						break;
					}
				}
				if($currencyFlag==true)
				{
					$refundAmount = $ObjCurrency->convertValueCustom($refundAmount,$order["purchasedCurrency"],$supportedCurrencyID);
				}
				else
				{
					$this->isError 		= true;
					$this->errorMessage	= "Currency not configured , Please contact the site admin";
					//return false;
				}
				
			}
		}
		
		$ewayCustomerID    = urlencode($this->settingsVars["customer_id"]);
        $ewayPaymentMethod = 'REFUND';
        $useLive           = urlencode($this->settingsVars["payment_test"]);
        if ($useLive == "On") {
            $ewayUseLive   = false;
        } else {
            $ewayUseLive   = true;
        }
        //$ewayRefundPswd    = 'ewayref1';
		$ewayRefundPswd    = $this->settingsVars["refund_password"];
        define('EWAY_DEFAULT_CUSTOMER_ID', $ewayCustomerID);
        define('EWAY_DEFAULT_PAYMENT_METHOD', $ewayPaymentMethod);
        define('EWAY_DEFAULT_LIVE_GATEWAY', $ewayUseLive);
        define('EWAY_REFUND', 'https://www.eway.com.au/gateway/xmltest/refund_test.asp');
        define('EWAY_REFUND_TESTING_MODE', 'https://www.eway.com.au/gateway/xmltest/refund_test.asp');
		
		/*if (file_exists("EwaypaymentliveModel.php")) {*/
			include_once ("EwaypaymentliveModel.php");
			$eway       = new EwaypaymentliveModel($ewayCustomerID, $ewayPaymentMethod, $ewayUseLive);
		/*}
		else
		{
			$this->isError 		= true;
			$this->errorMessage	= "System Error , Please contact the site admin";
			return false;	
		}*/
		
        $eway->setTransactionData("OriginalTrxnNumber", $postValues['apiPaymentTransactionID']);
        $eway->setTransactionData("TotalAmount", $refundAmount * 100);
        $eway->setTransactionData("CardExpiryMonth", $postValues['expMonth']);
        $eway->setTransactionData("CardExpiryYear", $postValues['expYear']);
        $eway->setTransactionData("Option1", '');
        $eway->setTransactionData("Option2", '');
        $eway->setTransactionData("Option3", '');
        $eway->setTransactionData("RefundPassword", $ewayRefundPswd);
        $eway->setCurlPreferences(CURLOPT_SSL_VERIFYPEER, 0); // Require for Windows hosting
        $ewayResponseFields = $eway->doPayment();
        if (strtolower($ewayResponseFields["EWAYTRXNSTATUS"]) == "false") {
            $lblResult = " Result: " . $ewayResponseFields["EWAYTRXNSTATUS"] . "<br>";
            $lblResult .= " AuthCode: " . $ewayResponseFields["EWAYAUTHCODE"] . "<br>";
            $lblResult .= " Txn Ref: " . $ewayResponseFields["EWAYTRXNREFERENCE"] . "<br>";
            $lblResult .= " Error: " . $ewayResponseFields["EWAYTRXNERROR"] . "<br>";
            $lblResult .= " Amount: " . $ewayResponseFields["EWAYRETURNAMOUNT"]/100 . "<br>";
            $lblResult .= " Txn Number: " . $ewayResponseFields["EWAYTRXNNUMBER"] . "<br>";
            $lblResult .= " Option1: " . $ewayResponseFields["EWAYOPTION1"] . "<br>";
            $lblResult .= " Option2: " . $ewayResponseFields["EWAYOPTION2"] . "<br>";
            $lblResult .= " Option3: " . $ewayResponseFields["EWAYOPTION3"] . "<br>";
            $masterOrderID                    = $postValues['masterOrderID'];
            $refundTransactionID              = $postValues['keyRefundTransactionID'];
            $arrTxnResponse['transactionID']  = '';
            $arrTxnResponse['refundResponse'] = $lblResult;
            $arrTxnResponse['refundAmount']   = '';
            $resUpdateRefund                  = $ObjRefund->updateRefundTransaction('', $refundTransactionID, $arrTxnResponse,$masterOrderID);
            $this->isError                    = true;
            $this->errorMessage               = "This transaction has been declined.<br>
												Payment gateway response: ".$ewayResponseFields["EWAYTRXNERROR"];
            $refundStatus                     = 'Failure';
        } else if (strtolower($ewayResponseFields["EWAYTRXNSTATUS"]) == "true") {
            $lblResult = " Result: " . $ewayResponseFields["EWAYTRXNSTATUS"] . "<br>";
            $lblResult .= " AuthCode: " . $ewayResponseFields["EWAYAUTHCODE"] . "<br>";
            $lblResult .= " Txn Ref: " . $ewayResponseFields["EWAYTRXNREFERENCE"] . "<br>";
            $lblResult .= " Error: " . $ewayResponseFields["EWAYTRXNERROR"] . "<br>";
            $lblResult .= " Amount: " . $ewayResponseFields["EWAYRETURNAMOUNT"] . "<br>";
            $lblResult .= " Txn Number: " . $ewayResponseFields["EWAYTRXNNUMBER"] . "<br>";
            $lblResult .= " Option1: " . $ewayResponseFields["EWAYOPTION1"] . "<br>";
            $lblResult .= " Option2: " . $ewayResponseFields["EWAYOPTION2"] . "<br>";
            $lblResult .= " Option3: " . $ewayResponseFields["EWAYOPTION3"] . "<br>";
            $masterOrderID                    = $postValues['masterOrderID'];
            $refundTransactionID              = $postValues['keyRefundTransactionID'];
            $arrTxnResponse['transactionID']  = $ewayResponseFields["EWAYTRXNNUMBER"];
            $arrTxnResponse['refundResponse'] = $lblResult;
            $arrTxnResponse['refundAmount']   = $ewayResponseFields["EWAYRETURNAMOUNT"];
            $resUpdateRefund                  = $ObjRefund->updateRefundTransaction('', $refundTransactionID, $arrTxnResponse,$masterOrderID);
            $this->isError                    = false;
            $this->errorMessage               = "";
            $refundStatus                     = 'Pending';
        } else {
			$this->isError                    = true;
            $lblResult    					  = "Error: An invalid response was recieved from the payment gateway.";
            $refundStatus 					  = 'Failure';
        }
        return !$this->isError;
    }
}