<?php
/***************************************************************************
 *                                                                          *
 * Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
 *                                                                          *
 * This  is  commercial  software,  only  users  who have purchased a valid *
 * license  and  accept  to the terms of the  License Agreement can install *
 * and use this program.                                                    *
 *                                                                          *
 ****************************************************************************
 * PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
 * "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
 ****************************************************************************/
//
//$Id: MigsModel.php, v 1.0 2011/06/14 20:52:11
//
class MigsModel extends PaymentModel
{
    public function process($order = '',$orderItems = '')//payment collection processing
    {
		$ObjCurrency		= new CurrencyModel();
        parent::listPaymentSettingsValues($order['paymentSettingsGroupID']);
        
		$payAmount       = $order['orderTotalAmount'];       
		$paymentCurrency	=	$this->settingsVars["payment_currency"];
		$currencyArr	=	'';
		$itemsArray  	= '';
		if ($paymentCurrency != '')
		{
			$paymentCurrency = str_replace(", ", ",", $paymentCurrency);
			$currencyArr     = explode(",", $paymentCurrency);
		}
		if(count($currencyArr)<1)
		{
			$this->isError 		= true;
			$this->errorMessage	= "Currency not configured , Please contact the site admin";
			return false;
		}
		else
		{
			$currencyFlag = false;
			$purchasedCurrencyDetails 	= $ObjCurrency->getCurrencyByCurrencyID($order["purchasedCurrency"]);
			$currencyCode				= $purchasedCurrencyDetails['currencyCode'];
			$systemCurrencies 			= $ObjCurrency->listCurrencyCodes();
			if(!in_array($purchasedCurrencyDetails['currencyCode'],$currencyArr))
			{
				foreach ($systemCurrencies as $key => $currency)
				{
					if(in_array($currency['currencyCode'],$currencyArr))
					{
						$currencyFlag = true;
						$supportedCurrencyCode 	= $currency['currencyCode'];	
						$supportedCurrencyID 	= $currency['currencyID'];
						break;
					}
				}
				if($currencyFlag==true)
				{
					$payAmount = $ObjCurrency->convertValueCustom($payAmount,$order["purchasedCurrency"],$supportedCurrencyID);
					$currencyCode		=	$supportedCurrencyCode;
				}
				else
				{
					$this->isError 		= true;
					$this->errorMessage	= "Currency not configured , Please contact the site admin";
					return false;
				}
				
			}
		}
		
        $paymentType   = urlencode($order['authValue']);
        $totalAmount   = number_format($payAmount, 2);        
        $returnURL     = $order['returnURL'];
        $cancelURL     = $order['cancelURL'];
        $siteDesc      = urlencode($order['siteDesc']);
        $siteDesc      = substr($siteDesc, 0, 30);
        $apiEndpoint   = $this->settingsVars["payment_gateway_url"];
        $totalAmount   = str_replace(",", "", $totalAmount);
        $totalAmount   = ceil($totalAmount);
		// In cents
        $tamount                  = $totalAmount * 100;
		
        $secureSecret             = "1FD377A11ED6E7C3D58C819FF0762DF2";
        $vpcURL                   = $apiEndpoint . "?";
        $md5HashData              = $secureSecret;
        $array['Title']           = "PHP VPC 3-Party";
        $array['vpc_AccessCode']  = $this->settingsVars["merchant_access_code"];
        $array['vpc_Amount']      = $tamount;
        $array['vpc_Command']     = "pay";
        $array['vpc_Locale']      = "en";
        $array['vpc_MerchTxnRef'] = $order['masterOrderID'];
        $array['vpc_Merchant']    = $this->settingsVars["payment_login"];
        $array['vpc_OrderInfo']   = $siteDesc;
        $array['vpc_ReturnURL']   = $returnURL;
        $array['vpc_Version']     = "1";
        $appendAmp                = 0;
        foreach ($array as $key => $value) {
            if (strlen($value) > 0) {
                if ($appendAmp == 0) {
                    $vpcURL .= urlencode($key) . '=' . urlencode($value);
                    $appendAmp = 1;
                } else {
                    $vpcURL .= '&' . urlencode($key) . "=" . urlencode($value);
                }
                $md5HashData .= $value;
            }
        }
        if (strlen($secureSecret) > 0) {
            $vpcURL .= "&vpc_SecureHash=" . strtoupper(md5($md5HashData));
        }
        header("Location: " . $vpcURL);
		exit;
    }
    public function doExpressCheckout($order = '',$requestArray)//getting express checkout result
    {
        parent::listPaymentSettingsValues($order['paymentSettingsGroupID']);
		$_GET=$requestArray;
		$getPaymentTransactionDetails = parent::getPaymentTransactionDetails(0,
		$order["masterOrderID"]);
        $secureSecret = "EFB613F6AB16C49DCDB650642716C7A3";
        // set a flag to indicate if hash has been validated
        $errorExists  = false;
        if (strlen($secureSecret) > 0 && $_GET["vpc_TxnResponseCode"] != "7" && $_GET["vpc_TxnResponseCode"] != "No Value Returned") {
            $md5HashData     = $secureSecret;
            $amount          = $_GET["vpc_Amount"];
            $locale          = $_GET["vpc_Locale"];
            $batchNo         = $_GET["vpc_BatchNo"];
            $command         = $_GET["vpc_Command"];
            $message         = $_GET["vpc_Message"];
            $version         = $_GET["vpc_Version"];
            $cardType        = $_GET["vpc_Card"];
            $orderInfo       = $_GET["vpc_OrderInfo"];
            $receiptNo       = $_GET["vpc_ReceiptNo"];
            $merchantID      = $_GET["vpc_Merchant"];
            $authorizeID     = $_GET["vpc_AuthorizeId"];
            $merchTxnRef     = $_GET["vpc_MerchTxnRef"];
            $transactionNo   = $_GET["vpc_TransactionNo"];
            $acqResponseCode = $_GET["vpc_AcqResponseCode"];
            $txnResponseCode = $_GET["vpc_TxnResponseCode"];
			
			$html = "<table align='left' width='100%' style='FONT-SIZE: 10pt; FONT-FAMILY: Arial, Helvetica, sans-serif'>";
			$html .= "<tr><td>Merchant Reference: </td><td>$merchantID</td></tr>";
			$html .= "<tr><td>AuthCode: </td><td>$authorizeID</td></tr>";
			$html .= "<tr><td>Amount: </td><td>$amount*100</td></tr>";
			$html .= "<tr><td>Card Type: </td><td>$cardType</td></tr>";
			$html .= "<tr><td>Transaction No: </td><td>$transactionNo</td></tr>";
			$html .= "<tr><td>orderInfo: </td><td>$orderInfo</td></tr>";
			$html .= "</table>";
        }
        if ($message == "Approved") {
            $transactionID = $transactionNo;
            $paymentMethodName    = $this->settingsVars["payment_method_name"];
            if ($order['authValue'] == 'Authorization') {
                $authOnly = 'AUTH_ONLY';
            } else {
                $authOnly = 'AUTH_CAPTURE';
            }
            $authOnly = 'AUTH_CAPTURE';
            parent::createTransaction($order, $transactionID, str_replace("~", "\n", $html), "",
			$authOnly,$paymentGatewayCharge,$paymentMethodName,
			$getPaymentTransactionDetails["paymentCurrencyID"],$amount);
            $this->isError      = false;
            $this->errorMessage = "";
            return "Pending";
        } else {
            $this->isError = true;
            if (stripslashes($_GET["L_SHORTMESSAGE0"]) == stripslashes($_GET["L_LONGMESSAGE0"])) {
                $this->errorMessage = stripslashes($_GET["L_LONGMESSAGE0"]);
            } else {
                $this->errorMessage = stripslashes($_GET["L_SHORTMESSAGE0"]) . ". " . stripslashes($_GET["L_LONGMESSAGE0"]);
            }
        }
        if ($this->isError && $this->errorMessage != '') {
            parent::createTransactionError($order, $transactionID, "ORDER TYPE: PRIOR_AUTH_CAPTURE\n\n" . str_replace("~", "\n", $httpResponse), "", "AUTH_CAPTURE", $paymentGatewayCharge, $paymentMethodName);
        }
        return !$this->isError;
    }
    
    
    public function processRefund($order = '', $postValues = '', $orderItems = '')//payment refund processing
    {
        $ObjRefund 			 = new RefundModel();
        parent::listPaymentSettingsValues($postValues['paymentSettingsGroupID']);
        $apiEndpoint         = $this->settingsVars["payment_gateway_url"];
        $paymentCurrency     = $this->settingsVars["payment_currency"];
        $masterOrderID       = $postValues['masterOrderID'];
        $refundTransactionID = $postValues['keyRefundTransactionID'];
        $refundAmount        = $order['orderTotalAmount'];
        if ($paymentCurrency != '') {
            $paymentCurrency = str_replace(", ", ",", $paymentCurrency);
            $currencyArr     = explode(",", $paymentCurrency);
        }
        if (!empty($currencyArr) && !in_array($order['purchasedCurrency'], $currencyArr)) {
            $refundAmount = $refundAmount * $postValues['USDValue'];
        }
        $refundAmount                = number_format($refundAmount, 2) * 100;
        $arrReq['vpc_Version']       = "1";
        $arrReq['vpc_Command']       = "refund";
        $arrReq['vpc_MerchTxnRef']   = urlencode($masterOrderID);
        $arrReq['vpc_AccessCode']    = urlencode($this->settingsVars["merchant_access_code"]);
        $arrReq['vpc_Merchant']      = urlencode($this->settingsVars["payment_login"]);
        $arrReq['vpc_Amount']        = urlencode($refundAmount);
        $arrReq['vpc_transactionNo'] = urlencode($postValues['apiPaymentTransactionID']);
		$arrReq['vpc_User']			='amauser';
		$arrReq['vpc_Password']		='password12';
        foreach ($arrReq as $key => $val) {
            $vpc_Req .= $key . '=' . $val . '&';
        }
        $vpc_Req = substr($vpc_Req, 0, -1);
        // Set the curl parameters.
        $ch      = curl_init();
        curl_setopt($ch, CURLOPT_URL, $apiEndpoint);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $vpc_Req);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_VERBOSE, 1);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);
        // Turn off the server and peer verification (TrustManager Concept).
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        // Get response from the server.
        $httpResponse = curl_exec($ch);
        $responseInfo = curl_getinfo($ch);
        curl_close($ch);
        $responseText         = str_replace($httpResponse, '&', '<br/>');
        $httpResponseAr       = explode("&", $httpResponse);
        $httpParsedResponseAr = array();
        foreach ($httpResponseAr as $i => $value) {
            $tmpAr = explode("=", $value);
            if (sizeof($tmpAr) > 1) {
                $httpParsedResponseAr[$tmpAr[0]] = $tmpAr[1];
            }
        }
        if ('0' == $httpParsedResponseAr["vpc_TxnResponseCode"]) {
            $arrXnResponse['transactionID']  = $httpParsedResponseAr["vpc_transactionNo"];
            $arrXnResponse['refundResponse'] = $responseText;
            $arrXnResponse['refundAmount']   = $httpParsedResponseAr["vpc_RefundedAmount"];
            $resUpdateRefund                 = $ObjRefund->updateRefundTransaction('', $refundTransactionID, $arrXnResponse,$masterOrderID);
            $this->isError                   = false;
            $this->errorMessage              = "";
        } else {
            $arrXnResponse['transactionID']  = '';
            $arrXnResponse['refundResponse'] = $responseText;
            $arrXnResponse['refundAmount']   = '';
            $resUpdateRefund                 = $ObjRefund->updateRefundTransaction('', $refundTransactionID, $arrXnResponse,$masterOrderID);
            $this->isError                   = true;
            $this->errorMessage              = $httpParsedResponseAr["vpc_Message"];
        }
        return !$this->isError;
    }
    public function processCustom($order = '')
    {
        return "Success";
    }
}