<?php
/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/
 //
 //$Id: NetPayModel.php, v 1.0 2011/06/14 20:52:11
 //
class NetpayModel extends PaymentModel {  
	//Function to Process orders		
	public function process($order='', $postForm='',$orderItems='') {
		
			parent::listPaymentSettingsValues($postForm['paymentSettingsGroupID']);		
			$address       			= 	$postForm['billingAddress'];
        	$address       			.= 	($postForm['billingAddress1']!='') ? ', '.$postForm['billingAddress1'] : '';
			$payAmount				=	$order['orderTotalAmount'];
			$totalAmount = number_format($payAmount, 2, ".", "");
			$merchantId= $this->settingsVars["merchant_id"];
            $merchantKey = $this->settingsVars['merchant_key'];
            $masterOrderID=$order["masterOrderID"];
            $PaymentMethod=$postForm["netpayPaymentMethod"];
            $userEmail =$postForm["billingEmail"];
            $signature = md5($merchantId.$merchantKey.$masterOrderID.$PaymentMethod.$userEmail.$totalAmount); 
			$postArray['netpayPageUrl']=$this->settingsVars["netpay_page_url"];
			$postArray['merchantId']=$this->settingsVars["merchant_id"];
			$postArray['masterOrderID']=$order["masterOrderID"];
			$postArray['Amount']=$totalAmount;
			$postArray['ProdDesc']=$postForm['siteDesc'];
			$postArray['UserName']=$postForm["billingFirstName"]." ".$postForm["billingLastName"];
			$postArray['UserEmail']=$postForm["billingEmail"];
			$postArray['signature']=$signature;
			$postArray['FromController']=$postForm["FromController"];
			$postArray['Currency']=$postForm["currencyCode"];
			$postArray['ExtraInfo1']=$postForm["ExtraInfo1"];
			$postArray['PaymentMethod']=$postForm["netpayPaymentMethod"];
			$postArray['postUrl']=trim($this->settingsVars["payment_gateway_url"])==""?"https://www.netpay.my/web/payment/generalentry.aspx":trim($this->settingsVars["payment_gateway_url"]);
			$splitGM=explode("GM",$order["masterOrderID"]);
			$splitOrderID=explode("-",$splitGM[1]);
			$settingsArray=array();
			$settingsArray['paymentSettingsGroupID']=$postForm['paymentSettingsGroupID'];
			$settingsArray['netpayPaymentType']=$postForm["netpayPaymentMethod"];
			$settingsArray['netpayOrderID']=$order["masterOrderID"];
			$settingsArray['masterOrderID']=$splitOrderID[0];
			$this->updateNetPaySettings($settingsArray);
			$this->createForm($postArray,$postUrl);
	}
	
	
	public function processCron($order='', $postForm='',$orderItems='')
	{
		parent::listPaymentSettingsValues($postForm['paymentSettingsGroupID']);	
		$postArray['merchantId']=$this->settingsVars["merchant_id"];
		$postArray['masterOrderID']=$order["masterOrderID"];
		$postArray['PaymentMethod']=$postForm["netpayPaymentMethod"];
		$postArray['postUrl']=trim($this->settingsVars["payment_requery_url"])==""?"https://www.netpay.my/web/payment/npreq.aspx":trim($this->settingsVars["payment_requery_url"]);
		$postArray['Version']='1.0';
		$postArray['FunctionName']="GETPAYMENTSTATUS";	
		$postData="FunctionName=".$postArray['FunctionName']."&Version=".$postArray['Version']."&MerchantID=".$postArray['merchantId']."&OrderID=".$order["masterOrderID"]."&PaymentMethod=".$postArray['PaymentMethod'];
		$c = curl_init($postArray['postUrl']);
		curl_setopt($c, CURLOPT_VERBOSE, 0);
		curl_setopt($c, CURLOPT_HEADER, 0);
		curl_setopt($c, CURLOPT_POSTFIELDS, $postData);
		curl_setopt($c, CURLOPT_POST, 1);
		curl_setopt($c, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($c, CURLOPT_SSL_VERIFYPEER, 0);
		if (!ini_get('safe_mode')) set_time_limit(3000);
		$buffer = curl_exec($c);
		return $buffer;		  
	} 
	
	
	public function createForm($postData,$postUrl)
    {
		 extract($postData);
		 echo  '<html><body>
                      <FORM method="post" name="Netpay" action="'.$netpayPageUrl.'">
                      <INPUT type="hidden" name="MerchantID" value="'.$merchantId.'">
                      <INPUT type="hidden" name="PaymentMethod" value="'.$PaymentMethod.'">
                      <INPUT type="hidden" name="OrderID" value="'.$masterOrderID.'">
                      <INPUT type="hidden" name="Amount" value="'.$Amount.'">
                      <INPUT type="hidden" name="Currency" value="'.$Currency.'">
                      <INPUT type="hidden" name="ProdDesc" value="'.$ProdDesc.'">
                      <INPUT type="hidden" name="UserName" value="'.$UserName.'">
                      <INPUT type="hidden" name="UserEmail" value="'.$UserEmail.'">
                      <INPUT type="hidden" name="Signature" value="'.$signature.'">
                      <INPUT type="hidden" name="TransactionType" value="MP">
					  <INPUT type="hidden" name="postUrl" value="'.$postUrl.'">
					  <INPUT type="hidden" name="FromController" value="'.$FromController.'">
					  <INPUT type="hidden" name="ExtraInfo1" value="'.$ExtraInfo1.'">
                      </FORM>
					  <script language="javascript" type="text/javascript">
					 submitFn();
					function submitFn()
					{					
					 document.forms["Netpay"].submit();
					} 
				 </script>
				 </body></html>
					  ';  
			exit;		  
       }
	   
	//Selects all pending netpay orders which was created during the last 12 hours
	public function getPendingNetpayOrders()
	{
		$sql	= " SELECT 
						ord.orderID,
						ord.paymentSettingsGroupID,
						ord.netpayOrderID,
						ord.netpayPaymentType,
						ord.orderNumber,
						ord.orderTotalAmount 
					FROM 
						".DB_PREFIX."orders ord 
					WHERE 
						ord.netpayPaymentType IN 
						(
							SELECT 
								methodCode 
							FROM 
								".DB_PREFIX."netpay_payment_methods 
							WHERE 
								Bank='Yes'
						)						
						AND ord.paymentSettingsGroupID = 
						( 
							SELECT 
								paySetGroupID
							FROM 
								".DB_PREFIX."payment_settings_group
							WHERE 
								paySetGroupKey =  'Netpay'
						) 
						AND ord.orderCreatedDate > DATE_SUB(CURDATE(),INTERVAL 12 HOUR) 
						AND ((ord.orderStatus = 'Process'  &&  ord.paymentStatus = 'Error')
						OR (ord.orderStatus = 'New' && ord.paymentStatus = 'Pending'))
						AND ord.orderNumber>0";		
		$resGetPendingNetpayOrders =   $this->ObjDatabase->readValues($sql); 
  		return $resGetPendingNetpayOrders;  
	}
	
	
	public function updateNetPaySettings($settingsArray)
	{
		$sql	= " UPDATE 
						".DB_PREFIX."orders 
					SET 
						paymentSettingsGroupID='".$settingsArray['paymentSettingsGroupID']."', 
						netpayOrderID='".$settingsArray['netpayOrderID']."', 
						netpayPaymentType='".$settingsArray['netpayPaymentType']."' 
					WHERE 
						orderID=".$settingsArray["orderID"];

		$resUpdateOrder	=   $this->ObjDatabase->setQuery($sql);
	}
	
	public function updateNetpayOrderNumber($orderID,$orderNumber)
	{	 
	 $sql	= " UPDATE 
	 				".DB_PREFIX."orders 
	 			SET 
	 				orderNumber = '".$orderNumber."' 
	 			WHERE 
	 				orderID= '".$orderID."'";
	 $resCompleteOrder	=	$this->ObjDatabase->setQuery($sql);
	 return $orderNumber; 
  }
 }