<?php
/***************************************************************************
 *                                                                          *
 * Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
 *                                                                          *
 * This  is  commercial  software,  only  users  who have purchased a valid *
 * license  and  accept  to the terms of the  License Agreement can install *
 * and use this program. 
 *                                                                          *
 ****************************************************************************
 * PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
 * "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
 ****************************************************************************/ //
//$Id: OgoneModel.php, v 1.1 2012/12/02 12:52:11
//
class OgoneModel extends PaymentModel
{
    public function process($order = '',$orderItems = '')
    {
		$ObjCurrency		= new CurrencyModel();
        parent::listPaymentSettingsValues($order['paymentSettingsGroupID']);
        $payAmount       = $order['orderTotalAmount'];
        $taxAmount       = $order["orderTaxAmount"];
        $serviceCharge   = $order["orderOtherServiceCharge"];
		$shippingAmount 		= 	$order["shippingAmount"];
			
        $paymentCurrency			=	$this->settingsVars["payment_currency"];
		if ($paymentCurrency != '')
		{
			$paymentCurrency = str_replace(", ", ",", $paymentCurrency);
			$currencyArr     = explode(",", $paymentCurrency);
		}
		if(count($currencyArr)<1)
		{
			$this->isError 		= true;
			$this->errorMessage	= "Currency not configured , Please contact the site admin";
			return false;
		}
		else
		{
			$currencyFlag = false;
			$purchasedCurrencyDetails 	= $ObjCurrency->getCurrencyByCurrencyID($order["purchasedCurrency"]);
			$currencyCode				= $purchasedCurrencyDetails['currencyCode'];
			$systemCurrencies 			=	$ObjCurrency->listCurrencyCodes();
			if(!in_array($purchasedCurrencyDetails['currencyCode'],$currencyArr))
			{
				foreach ($systemCurrencies as $key => $currency)
				{
					if(in_array($currency['currencyCode'],$currencyArr))
					{
						$currencyFlag = true;
						$supportedCurrencyCode 	= $currency['currencyCode'];	
						$supportedCurrencyID 	= $currency['currencyID'];
						break;
					}
				}
				if($currencyFlag==true)
				{
					$payAmount = $ObjCurrency->convertValueCustom($payAmount,$order["purchasedCurrency"],$supportedCurrencyID);
					$taxAmount = $ObjCurrency->convertValueCustom($taxAmount,$order["purchasedCurrency"],$supportedCurrencyID);
					$shippingAmount = $ObjCurrency->convertValueCustom($shippingAmount,$order["purchasedCurrency"],
					$supportedCurrencyID);
					$serviceCharge = $ObjCurrency->convertValueCustom($serviceCharge,$order["purchasedCurrency"],
					$supportedCurrencyID);
					$currencyCode		=	$supportedCurrencyCode;
				}
				else
				{
					$this->isError 		= true;
					$this->errorMessage	= "Currency not configured , Please contact the site admin";
					return false;
				}
				
			}
		}
		
        $paymentAmount 	= urlencode($payAmount);
        $currencyID    	= urlencode($currencyCode);
        $paymentType   	= urlencode($order['authValue']);
        $totalAmount 	= number_format($paymentAmount, 2);        
        $returnURL     	= $order['returnURL'];
        $cancelURL     	= $order['cancelURL'];
        $siteDesc      	= urlencode($order['siteDesc']);
        if ($this->settingsVars["payment_test"] == 'On')
        {
            $url = "https://secure.ogone.com/ncol/test/orderstandard.asp";
        }
        elseif ($this->settingsVars["payment_test"] == 'Off')
        {
            $url = "https://secure.ogone.com/ncol/prod/orderstandard.asp";
        }
        $PSPID        = $this->settingsVars["payment_login"];
        $ORDERID      = $order['orderNumber'];
        $AMOUNT       = str_replace(",", "", $totalAmount) * 100;
        $CURRENCY     = $currencyCode;
        $PMLIST       = 'VISA;MasterCard;American Express;JCB';
        $LOGO         = $order['companyLogo'];       
        if ($order['authValue'] == 'Authorization')
        {
            $OPERATION = 'RES';
        }
        elseif ($order['authValue'] == 'Sale' || $order['orderType'] == 'coupon')
        {
            $OPERATION = 'SAL';
        }
		$LANGUAGE = 'en_US';
		$title     = urlencode($order['siteName']);
		$COMPLUS = 'CART';
		if($order['orderType'] == 'coupon')
		{
			$COMPLUS = 'GIFTCOUPON';
		}
		$SHAPassphrase = $this->settingsVars["payment_passphrase"];
		/*$forEncrypt = 'ACCEPTURL='.$returnURL.$SHAPassphrase.'AMOUNT='.$AMOUNT.$SHAPassphrase.'CANCELURL='.$cancelURL.$SHAPassphrase.'COM='.$siteDesc.$SHAPassphrase.'CURRENCY='.$CURRENCY.$SHAPassphrase.'LANGUAGE='.$LANGUAGE.$SHAPassphrase.'OPERATION='.$OPERATION.$SHAPassphrase.'ORDERID='.$ORDERID.$SHAPassphrase.'PMLIST='.$PMLIST.$SHAPassphrase.'PSPID='.$PSPID.$SHAPassphrase.'TITLE='.$title.$SHAPassphrase;*/
		
		$forEncrypt = 'ACCEPTURL='.$returnURL.$SHAPassphrase.'AMOUNT='.$AMOUNT.$SHAPassphrase.'CANCELURL='.$cancelURL.$SHAPassphrase.'COMPLUS='.$COMPLUS.$SHAPassphrase.'CURRENCY='.$CURRENCY.$SHAPassphrase.'LANGUAGE='.$LANGUAGE.$SHAPassphrase.'OPERATION='.$OPERATION.$SHAPassphrase.'ORDERID='.$ORDERID.$SHAPassphrase.'PSPID='.$PSPID.$SHAPassphrase;
		
		$CHECKSUM  = strtoupper(sha1($forEncrypt));

		/* echo $forEncrypt.'<br>'.$CHECKSUM;
		 exit;*/       
		 
       /* $gatewayURL          = $url . "?PSPID=" . $PSPID . "&ORDERID=" . $ORDERID . "&AMOUNT=" . $AMOUNT . "&CURRENCY=" . $CURRENCY . "&LANGUAGE=" . $LANGUAGE . "&SHASIGN=" . $CHECKSUM . "&CANCELURL=" . $cancelURL . "&ACCEPTURL=" . $returnURL . "&TITLE=" . $title . "&COM=" . $siteDesc . "&PMLIST=" . $PMLIST . "&OPERATION=" . $OPERATION . "";*/
	   
	    $gatewayURL          = $url . "?PSPID=" . $PSPID . "&ORDERID=" . $ORDERID . "&AMOUNT=" . $AMOUNT ."&CURRENCY=" . $CURRENCY . "&LANGUAGE=" . $LANGUAGE . "&SHASIGN=" . $CHECKSUM . "&CANCELURL=" . $cancelURL . "&ACCEPTURL=" . $returnURL . "&OPERATION=" . $OPERATION . "&COMPLUS=".$COMPLUS. "";
	   
        $this->isError      = false;
        $this->errorMessage = "";
        header("Location: $gatewayURL");
        exit;
    }
    public function processCustom($order = '', $postForm = '')
    {
		$ObjCurrency			= new CurrencyModel();
        parent::listPaymentSettingsValues($order['paymentSettingsGroupID']);
        $this->isError                = false;
        //check is transaction completed
        if ($order["paymentType"] != "AUTH_ONLY" || $order["paymentStatus"] == 'Received')
        {
            $this->isError      = true;
            $this->errorMessage = "Transaction already completed";
            return false;
        }
		$capturedTotalAmount = $order["orderTotalAmount"];
		$paymentCurrency 		= 	$this->settingsVars["payment_currency"];
		if ($paymentCurrency != '')
		{
			$paymentCurrency = str_replace(", ", ",", $paymentCurrency);
			$currencyArr     = explode(",", $paymentCurrency);
		}
		if(count($currencyArr)<1)
		{
			$this->isError 		= true;
			$this->errorMessage	= "Currency not configured , Please contact the site admin";
			return false;
		}
		else
		{
			$currencyFlag = false;
			$purchasedCurrencyDetails = $ObjCurrency->getCurrencyByCurrencyID($order["purchasedCurrency"]);
			$systemCurrencies 		=	$ObjCurrency->listCurrencyCodes();
			if(!in_array($purchasedCurrencyDetails['currencyCode'],$currencyArr))
			{
				foreach ($systemCurrencies as $key => $currency)
				{
					if(in_array($currency['currencyCode'],$currencyArr))
					{
						$currencyFlag = true;
						$supportedCurrencyCode 	= $currency['currencyCode'];	
						$supportedCurrencyID 	= $currency['currencyID'];
						break;
					}
				}
				if($currencyFlag==true)
				{
					$capturedTotalAmount = $ObjCurrency->convertValueCustom($capturedTotalAmount,$order["purchasedCurrency"],
					$supportedCurrencyID);
				}
				else
				{
					$this->isError 		= true;
					$this->errorMessage	= "Currency not configured , Please contact the site admin";
					return false;
				}
				
			}
		}
		
		$capturedTotalAmount = number_format($capturedTotalAmount, 2, ".", "");
        $capturedTotalAmount = str_replace(",", "", $capturedTotalAmount) * 100;
        $payAmount           = $capturedTotalAmount;
        $transactionID       = $order["transactionID"];
        $taxAmount           = $order["finalTaxAmount"];
        $masterOrderID             = $order['orderNumber'];
		$PSPID        		 = $this->settingsVars["payment_login"];
        $userID              = $this->settingsVars["payment_api_userid"]; 
        $pass                = $this->settingsVars["payment_api_user_password"]; 
        $operation           = 'SAS';
		if ($this->settingsVars["payment_test"] == 'On')
        {
            $url = "https://secure.ogone.com/ncol/test/maintenancedirect.asp";
        }
        elseif ($this->settingsVars["payment_test"] == 'Off')
        {
            $url = "https://secure.ogone.com/ncol/prod/maintenancedirect.asp";
        }
        $gatewayURL           = $url . "?PSPID=" . $PSPID . "&
									USERID=" . $userID . "&
									PSWD=" . $pass . "&
									PAYID=" . $transactionID . "&
									ORDERID=" . $masterOrderID . "&
									AMOUNT=" . $capturedTotalAmount . "&
									OPERATION=" . $operation; 
        $this->isError       = false;
        $this->errorMessage  = "";
        $ch                  = curl_init();
        curl_setopt($ch, CURLOPT_URL, $gatewayURL);
        curl_setopt($ch, CURLOPT_VERBOSE, 1);
        // turning off the server and peer verification(TrustManager Concept).
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        // getting response from server
        $httpResponse = curl_exec($ch);		
        curl_close($ch);
        $oXML    = new SimpleXMLElement($httpResponse);
        $xml     = json_decode(json_encode((array) simplexml_load_string($httpResponse)), 1);
        $respnse = $xml['@attributes'];
        // Extract the response details
        if ($transactionID == $respnse['PAYID'] && $respnse['NCERROR']==0)
        {
            $transactionID = $respnse['PAYID'];
            $paymentMethodName                  = $this->settingsVars["payment_method_name"];
			$responseString = "";
			foreach($respnse as $respnseKey => $respnseVal)
			{
				$responseString .=$respnseKey."~~".urlencode($respnseVal)."||"; 	
			}
            parent::createTransaction($order, $transactionID, $responseString, "", "AUTH_CAPTURE", $paymentGatewayCharge, $paymentMethodName, $supportedCurrencyID, $payAmount);
            $this->isError      = false;
            $this->errorMessage = "";
            return "Success";
        }
        elseif ($respnse['NCERROR']>0)
        {
            $this->isError = true;
			if($respnse["NCERRORPLUS"]!='')
			{
            	$this->errorMessage = stripslashes($respnse["NCERRORPLUS"]);
			}
			else
			{
				 $this->errorMessage = "Error in Transaction lookup";	
			}
        }
        else
        {
            $this->isError      = true;
            $this->errorMessage = "Incorrect params. Please contact site administartor.";
            //return false;
        }
        return !$this->isError;
    }
		    
}