<?php
/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/
//
//$Id: PaypalproModel.php, v 1.0 2011/06/14 20:52:11
//
class PaypalproModel extends PaymentModel{ 
//FUNCTION TO PROCESS		
	public function process($order='',$orderItems='') {
			//echo '<pre>';print_r($order);exit;
			$ObjCountry        	= new CountryModel();
        	$ObjState          	= new StateModel();
			$ObjCurrency		= new CurrencyModel();
			parent::listPaymentSettingsValues($order['paymentSettingsGroupID']);	
			$method					=	"DoDirectPayment";
			$version				=	'65.1';//57.0
			$payAmount				=	$order['orderTotalAmount'];
			$taxAmount				=	$order["orderTaxAmount"];
			$shippingAmount 		= 	$order["shippingAmount"];
			$serviceCharge   		= 	$order["orderOtherServiceCharge"];
			$orderPromoDiscountAmount 	= $order["orderPromoDiscountAmount"];
			$orderUserCreditAmount 		= $order["orderUserCreditAmount"];
			$masterOrderSubtotal 		= $order["orderSubtotal"];
			
			$supportedCurrencyID		= $order["purchasedCurrency"];
			
			$paymentCurrency			=	$this->settingsVars["payment_currency"];
			
			if ($paymentCurrency != '')
        	{
            	$paymentCurrency = str_replace(", ", ",", $paymentCurrency);
            	$currencyArr     = explode(",", $paymentCurrency);
        	}
			if(count($currencyArr)<1)
			{
				$this->isError 		= true;
				$this->errorMessage	= "Currency not configured , Please contact the site admin";
				return false;
			}
			else
			{
				$currencyFlag = false;
				$purchasedCurrencyDetails 	= $ObjCurrency->getCurrencyByCurrencyID($order["purchasedCurrency"]);
				$currencyCode				= $purchasedCurrencyDetails['currencyCode'];
				$systemCurrencies 			=	$ObjCurrency->listCurrencyCodes();
				if(!in_array($purchasedCurrencyDetails['currencyCode'],$currencyArr))
				{
					foreach ($systemCurrencies as $key => $currency)
        			{
						if(in_array($currency['currencyCode'],$currencyArr))
						{
							$currencyFlag = true;
							$supportedCurrencyCode 	= $currency['currencyCode'];	
							$supportedCurrencyID 	= $currency['currencyID'];
							break;
						}
					}
					if($currencyFlag==true)
					{
						$payAmount = $ObjCurrency->convertValueCustom($payAmount,$order["purchasedCurrency"],$supportedCurrencyID);
						$taxAmount = $ObjCurrency->convertValueCustom($taxAmount,$order["purchasedCurrency"],$supportedCurrencyID);
						$shippingAmount = $ObjCurrency->convertValueCustom($shippingAmount,$order["purchasedCurrency"],
						$supportedCurrencyID);
						$serviceCharge = $ObjCurrency->convertValueCustom($serviceCharge,$order["purchasedCurrency"],
						$supportedCurrencyID);
						$orderPromoDiscountAmount = $ObjCurrency->convertValueCustom($orderPromoDiscountAmount
						,$order["purchasedCurrency"],$supportedCurrencyID);
						$orderUserCreditAmount = $ObjCurrency->convertValueCustom($orderUserCreditAmount
						,$order["purchasedCurrency"],$supportedCurrencyID);
						$masterOrderSubtotal	= $ObjCurrency->convertValueCustom($masterOrderSubtotal
						,$order["purchasedCurrency"],$supportedCurrencyID);
						$currencyCode		=	$supportedCurrencyCode;
					}
					else
					{
						$this->isError 		= true;
						$this->errorMessage	= "Currency not configured , Please contact the site admin";
						return false;
					}
					
				}
			}
			
			if($payAmount<.01)
			{
				$this->isError 		= true;
				$this->errorMessage	= "Invalid amount , please use another method";
				return false;
			}
			
			$paymentAmount 	= urlencode($payAmount);
			$itemsArray  	= '';
			$itemAmount  	= 0;
			$itemsAmount 	= 0;
			$key         	= 0;
			$itemsAmount	= $itemsAmount-$discounts;
	
			$address       			 = $order['billingAddress']['billingAddress'];
        	$address       			.= ($order['billingAddress']['billingAddress1']!='') ? ', '.
										$order['billingAddress']['billingAddress1'] : '';
										
			$countryCode             = $ObjCountry->getCountryCode($order['billingAddress']['billingCountry']);
			$languageIDs['Default']=1;
			$languageIDs['Current']=1;
			if ($order['billingAddress']['billingState'] >0)
            {
				$getStateDetails = $ObjState->getStateDetails($languageIDs, 
				$order['billingAddress']['billingState']);
				$stateCode       = $getStateDetails['stateShortName'];
            }
            else
            {
             	$stateCode = $order['billingAddress']['billingState'];
            }
			$nvpReq 	="USER=".$this->settingsVars["payment_login"]."&PWD=".$this->settingsVars["payment_login_password"]."&SIGNATURE=".$this->settingsVars["payment_signature"]."&VERSION=".urlencode($version)."&BUTTONSOURCE=AngellFreeInc_USBSwiper_DP&METHOD=".$method."";
			
			$nvpStr		=$nvpReq."&PAYMENTACTION=".urlencode($order['authValue'])."&IPADDRESS=".urlencode($this->getIpAddress())."&AMT=".number_format($paymentAmount, 2, ".", "")."&CREDITCARDTYPE=".urlencode($order['postData']["creditCardType"])."&ACCT=".urlencode($order['postData']["creditCardNumber"])."&EXPDATE=".urlencode($order['postData']["expMonth"].$order['postData']["expYear"])."&CVV2=".urlencode($order['postData']["securityCode"])."&FIRSTNAME=".urlencode($order['postData']["creditCardFirstName"])."&LASTNAME=".urlencode($order['postData']["creditCardLastName"])."&STREET=".urlencode($address)."&CITY=".urlencode($order['billingAddress']["billingCity"]).""."&STATE=".urlencode($stateCode)."&ZIP=".urlencode($order['billingAddress']["billingZip"])."&CURRENCYCODE=".urlencode($currencyCode)."&COUNTRYCODE=".urlencode($countryCode);
			
			//post data to paypal
			$postUrl 			= 	trim($this->settingsVars["payment_gateway_url"])==""?"https://api-3t.paypal.com/nvp":
			trim($this->settingsVars["payment_gateway_url"]);
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL,$postUrl);
			curl_setopt($ch, CURLOPT_VERBOSE, 1);
	
			// turning off the server and peer verification(TrustManager Concept).
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $nvpStr);
			// getting response from server
			$httpResponse = curl_exec($ch);
			// Extract the RefundTransaction response details
			$httpResponseAr = explode("&", $httpResponse);
			$html = "<table align='center' width='200' style='FONT-SIZE: 10pt; FONT-FAMILY: Arial, Helvetica, sans-serif'>";
			$html .= "<BR><hr><BR>";
         	$httpParsedResponseAr = array();
			foreach ($httpResponseAr as $i => $value) {
				$tmpAr = explode("=", $value);
				if(sizeof($tmpAr) > 1) {
					$httpParsedResponseAr[$tmpAr[0]] = urldecode($tmpAr[1]);
					$html .= "<tr><td>".$tmpAr[0].": </td><td>".urldecode($tmpAr[1])."</td></tr>";
				}
			}
			$html .= "</table>";
		
			if($order['authValue']=='Authorization') {
				$authOnly	=	'AUTH_ONLY';	
			} else {				
				$authOnly	=	'AUTH_CAPTURE';		
			}
			if(("Success" == $httpParsedResponseAr["ACK"]) || 
			("SuccessWithWarning" == $httpParsedResponseAr["ACK"])) {		
				$transactionID	= 	$httpParsedResponseAr["TRANSACTIONID"];		
				$paymentMethodName			=	$this->settingsVars["payment_method_name"];
				parent::createTransaction($order,$transactionID,
				str_replace("~", "\n", $html), "", $authOnly,$paymentGatewayCharge,
				$paymentMethodName,$supportedCurrencyID,$payAmount);
				if($order['store_cc_info']=='Yes') {						
					parent::saveCCdata($order['postData'],$order["userID"]);
				}
				$this->isError = false;
				$this->errorMessage = "";
				return "Pending";
			} 
			elseif("Failure" == $httpParsedResponseAr["ACK"]) {
				$this->isError = true;
				if(stripslashes($httpParsedResponseAr["L_SHORTMESSAGE0"])==stripslashes($httpParsedResponseAr["L_LONGMESSAGE0"]))
					$this->errorMessage	= stripslashes($httpParsedResponseAr["L_LONGMESSAGE0"]);
				else
					$this->errorMessage	= stripslashes($httpParsedResponseAr["L_SHORTMESSAGE0"]).". ".stripslashes($httpParsedResponseAr["L_LONGMESSAGE0"]);
					
			} 
			else 
			{
				$this->isError = true;
				$this->errorMessage = "Incorrect form params. Please contact site administartor.";
				//return false;
			}
			return !$this->isError;
				
	}
//END OF FUNCTION 
//FUNCTION 	TO PROCESS TRANSACTION
	public function processCustom($order='') {
			$ObjCurrency			= new CurrencyModel();
			parent::listPaymentSettingsValues($order['paymentSettingsGroupID']);
			$getPaymentTransactionDetails = $this->getPaymentTransactionDetails(0,
			$order["masterOrderID"]);
			$purchasedCurrencyDetails = $ObjCurrency->getCurrencyByCurrencyID(
			$getPaymentTransactionDetails["paymentCurrencyID"]);
			$currencyCode			= $purchasedCurrencyDetails['currencyCode'];
			$this->isError = false;
			//check is transaction completed
			if ($order["paymentType"] != "AUTH_ONLY" || $order["paymentStatus"]=='Received' )
			{
				$this->isError 		= true;
				$this->errorMessage = "Transaction already completed";
				return false;
			}
			//get captured total amount & x_trans_id
			$capturedTotalAmount 	= $getPaymentTransactionDetails["convertedPaymentAmount"];
			$transactionID			= $getPaymentTransactionDetails["transactionID"];
			
			
			$version				=	'65.1';//57.0
			$method					=	"DoCapture";
			$nvpReq 				= 	"METHOD=".$method."&AUTHORIZATIONID=".urlencode($transactionID)."&AMT=".urlencode(number_format($capturedTotalAmount, 2, ".", ""))."&CURRENCYCODE=".urlencode($currencyCode)."&COMPLETETYPE=Complete";
										
			$API_UserName    = urlencode($this->settingsVars["payment_login"]);
            $API_Password    = urlencode($this->settingsVars["payment_login_password"]);
            $API_Signature   = urlencode($this->settingsVars["payment_signature"]);
            $nvpReq .= "&VERSION=$version&PWD=$API_Password&USER=$API_UserName&SIGNATURE=$API_Signature";
			//post data to paypal
			$postUrl 			= 	trim($this->settingsVars["payment_gateway_url"])==""?"https://api-3t.paypal.com/nvp":trim($this->settingsVars["payment_gateway_url"]);
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL,$postUrl);
			curl_setopt($ch, CURLOPT_VERBOSE, 1);
			// turning off the server and peer verification(TrustManager Concept).
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $nvpReq);
			// getting response from server
			$httpResponse = curl_exec($ch);
			// Extract the RefundTransaction response details
			$httpResponseAr = explode("&", $httpResponse);
			$httpParsedResponseAr = array();
			$html = "<table align='center' width='200' style='FONT-SIZE: 10pt; FONT-FAMILY: Arial, Helvetica, sans-serif'>";
			$html .= "<BR><hr><BR>";
			foreach ($httpResponseAr as $i => $value) {
				$tmpAr = explode("=", $value);
				if(sizeof($tmpAr) > 1) 
				{
					$httpParsedResponseAr[$tmpAr[0]] = urldecode($tmpAr[1]);
					$html .= "<tr><td>".$tmpAr[0].": </td><td>".urldecode($tmpAr[1])."</td></tr>";
				}
			}
			$html .= "</table>";
			if($transactionID == $httpParsedResponseAr["AUTHORIZATIONID"]) 
			{		
				$transactionID		= ($httpParsedResponseAr["TRANSACTIONID"] >0) ? $httpParsedResponseAr["TRANSACTIONID"] : $httpParsedResponseAr["AUTHORIZATIONID"];
				$paymentMethodName	= $this->settingsVars["payment_method_name"];
				$postForm['paymentSettingsGroupID']		=	$order['paymentSettingsGroupID'];	
				parent::createTransaction($order,  $transactionID,"ORDER TYPE: PRIOR_AUTH_CAPTURE\n\n".str_replace("~", "\n", $html), "", "AUTH_CAPTURE",$paymentGatewayCharge,$paymentMethodName,$getPaymentTransactionDetails["paymentCurrencyID"],$capturedTotalAmount);
				$this->isError = false;
				$this->errorMessage = "";
				return "Success";
							
			} 
			elseif("Failure" == $httpParsedResponseAr["ACK"]) 
			{
				$this->isError = true;
				if(stripslashes($httpParsedResponseAr["L_SHORTMESSAGE0"])==stripslashes($httpParsedResponseAr["L_LONGMESSAGE0"]))
					$this->errorMessage	= stripslashes($httpParsedResponseAr["L_LONGMESSAGE0"]);
				else
					$this->errorMessage	= stripslashes($httpParsedResponseAr["L_SHORTMESSAGE0"]).". ".stripslashes($httpParsedResponseAr["L_LONGMESSAGE0"]);
			} else {
				$this->isError = true;
				$this->errorMessage = "Incorrect form params. Please contact site administartor.";
				//return false;
			}
			if($this->isError) {
				$this->logStart();
				$this->log($httpResponse,$this->settingsVars["payment_processor_id"]);
				$this->logFinish();
				$this->isError = true;
			}
			return !$this->isError;
	}
	//END OF FUNCTION
	public function processRefund($order='', $postValues='',$orderItems=''){
		$ObjRefund			= new RefundModel();
		$ObjCurrency		= new CurrencyModel();
		parent::listPaymentSettingsValues($postValues['paymentSettingsGroupID']);
		
		$masterOrderID		= $postValues['masterOrderID'];
		$refundTransactionID= $postValues['keyRefundTransactionID'];
		$this->paySetGroupID= $postValues['paymentSettingsGroupID'];
		// Set request-specific fields.
		$transactionID		= urlencode($postValues['apiPaymentTransactionID']);
		$refundType			= urlencode('Partial');  // or 'Full'
		$amount				= number_format($order['orderTotalAmount'], 2, ".", "");	// required if Partial.
		$memo				= 'Order Refund - MASORDID-'.$order['orderNumber'];		// required if Partial.
		$currencyID 		=	urlencode('USD');   // or other currency ('GBP', 'EUR', 'JPY', 'CAD', 'AUD')
		// Add request-specific fields to the request string.
		
		$supportedCurrencyID = $order["purchasedCurrency"];
		$paymentCurrency	 = $this->settingsVars["payment_currency"];
		
		if ($paymentCurrency != '')
		{
			$paymentCurrency = str_replace(", ", ",", $paymentCurrency);
			$currencyArr     = explode(",", $paymentCurrency);
		}
		if(count($currencyArr)<1)
		{
			$this->isError 		= true;
			$this->errorMessage	= "Currency not configured , Please contact the site admin";
			//return false;
		}
		else
		{
			$currencyFlag = false;
			$purchasedCurrencyDetails 	= $ObjCurrency->getCurrencyByCurrencyID($order["purchasedCurrency"]);
			$currencyCode				= $purchasedCurrencyDetails['currencyCode'];
			$systemCurrencies 			= $ObjCurrency->listCurrencyCodes();
			if(!in_array($purchasedCurrencyDetails['currencyCode'],$currencyArr))
			{
				foreach ($systemCurrencies as $key => $currency)
				{
					if(in_array($currency['currencyCode'],$currencyArr))
					{
						$currencyFlag = true;
						$supportedCurrencyCode 	= $currency['currencyCode'];	
						$supportedCurrencyID 	= $currency['currencyID'];
						break;
					}
				}
				if($currencyFlag==true)
				{
					$amount = $ObjCurrency->convertValueCustom($amount,$order["purchasedCurrency"],$supportedCurrencyID);
				}
				else
				{
					$this->isError 		= true;
					$this->errorMessage	= "Currency not configured , Please contact the site admin";
					//return false;
				}
				
			}
		}
		
		$amount	= number_format($amount, 2, ".", "");
				
		if($amount<.01)
		{
			$this->isError 		= true;
			$this->errorMessage	= "Invalid amount , please use another method";
		}
		
		
		$nvpStr 			=	"&TRANSACTIONID=$transactionID&REFUNDTYPE=$refundType";	// &CURRENCYCODE=$currencyID
		if(isset($memo)) {
			$nvpStr .= "&NOTE=$memo";
		}
		if(strcasecmp($refundType, 'Partial') == 0) {
		    if(!isset($amount)) {
		     	$this->errorMessage	=	"Partial Refund Amount is not specified.";     
			} else {
		        $nvpStr = $nvpStr."&AMT=$amount";
		    }
		
		    if(!isset($memo)) {
		    	$this->errorMessage	=	"Partial Refund Memo is not specified.";     
			}
		}
		// Execute the API operation; see the PPHttpPost function.
		$httpParsedResponseAr		=	$this->PPHttpPost('RefundTransaction', $nvpStr);
		if("SUCCESS" == strtoupper($httpParsedResponseAr["ACK"]) || "SUCCESSWITHWARNING" == strtoupper($httpParsedResponseAr["ACK"])) {
			foreach($httpParsedResponseAr as $key=>$val){	$arrXnResponse['refundResponse']	.=	$key.'='.$val.'&';	}
			$arrXnResponse['transactionID']		= 	$httpParsedResponseAr["REFUNDTRANSACTIONID"];
			$arrXnResponse['refundResponse']	=	urldecode(substr($arrXnResponse['refundResponse'],0,-1));
			$arrXnResponse['refundResponse']	=	str_replace('&','<br/>',$arrXnResponse['refundResponse']);
			$arrXnResponse['refundAmount']		= 	$httpParsedResponseAr["GROSSREFUNDAMT"];		
			$resUpdateRefund	=	$ObjRefund->updateRefundTransaction('',$refundTransactionID,$arrXnResponse,$masterOrderID);
			$this->isError 		= 	false;
			$this->errorMessage = 	"";
		} else  {
			foreach($httpParsedResponseAr as $key=>$val){	$arrXnResponse['refundResponse']	.=	$key.'='.$val.'&';	}
			$arrXnResponse['transactionID']		= 	'';
			$arrXnResponse['refundResponse']	=	urldecode(substr($arrXnResponse['refundResponse'],0,-1));
			$arrXnResponse['refundResponse']	=	str_replace('&','<br/>',$arrXnResponse['refundResponse']);
			$arrXnResponse['refundAmount']		= 	'';		
			$resUpdateRefund	=	$ObjRefund->updateRefundTransaction('',$refundTransactionID,$arrXnResponse,$masterOrderID);
			$this->isError 		= 	true;
			if(stripslashes($httpParsedResponseAr["L_SHORTMESSAGE0"])==stripslashes($httpParsedResponseAr["L_LONGMESSAGE0"]))
				$this->errorMessage	= stripslashes($httpParsedResponseAr["L_LONGMESSAGE0"]);
			else
				$this->errorMessage	= stripslashes($httpParsedResponseAr["L_SHORTMESSAGE0"]).". ".stripslashes($httpParsedResponseAr["L_LONGMESSAGE0"]);
		}	
		return !$this->isError;
	}	
	
	
	public function PPHttpPost($methodName_, $nvpStr_) {
		parent::listPaymentSettingsValues($this->paySetGroupID);
		if($this->settingsVars["payment_test"] == 'On'){
	    	$environment = 'sandbox';     // or 'beta-sandbox' or 'live'
		} 
		// Set up your API credentials, PayPal end point, and API version.
	    $API_UserName	=	urlencode($this->settingsVars["payment_login"]);
	    $API_Password	=	urlencode($this->settingsVars["payment_login_password"]);
	    $API_Signature	=	urlencode($this->settingsVars["payment_signature"]);
	    $API_Endpoint	=	trim($this->settingsVars["payment_gateway_url"]);	
	    $version 		=	urlencode('51.0');
	     // Set the curl parameters.
	     $ch = curl_init();
	     curl_setopt($ch, CURLOPT_URL, $API_Endpoint);
	     curl_setopt($ch, CURLOPT_VERBOSE, 1);
	     // Turn off the server and peer verification (TrustManager Concept).
	     curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
	     curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
	     curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	     curl_setopt($ch, CURLOPT_POST, 1);
	     // Set the API operation, version, and API signature in the request.
	     $nvpreq = "METHOD=$methodName_&VERSION=$version&PWD=$API_Password&USER=$API_UserName&SIGNATURE=$API_Signature$nvpStr_";
	     // Set the request as a POST FIELD for curl.
	     curl_setopt($ch, CURLOPT_POSTFIELDS, $nvpreq);
	     // Get response from the server.
	     $httpResponse = curl_exec($ch);
	    if(!$httpResponse) {
	    	$this->errorMessage	= "$methodName_ failed: ".curl_error($ch).'('.curl_errno($ch).')'; 	
		}
	    // Extract the response details.
	    $httpResponseAr = explode("&", $httpResponse);
	    $httpParsedResponseAr = array();
	    foreach($httpResponseAr as $i => $value) {
	    	$tmpAr = explode("=", $value);
	        if(sizeof($tmpAr) > 1) {
	        	$httpParsedResponseAr[$tmpAr[0]] = $tmpAr[1];
	        }
	    }
	    if((0 == sizeof($httpParsedResponseAr)) || !array_key_exists('ACK', $httpParsedResponseAr)) {
	     	$this->isError = true;
			$this->errorMessage	="Invalid HTTP Response for POST request($nvpreq) to $API_Endpoint.";
	    }
	    return $httpParsedResponseAr;
	}
}
