
<?php
/***************************************************************************
 *                                                                          *
 * Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
 *                                                                          *
 * This  is  commercial  software,  only  users  who have purchased a valid *
 * license  and  accept  to the terms of the  License Agreement can install *
 * and use this program.                                                    *
 *                                                                          *
 ****************************************************************************
 * PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
 * "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
 ****************************************************************************/
//
//$Id: PsigateModel.php, v 1.0 2011/06/14 20:52:11

//
class PsigateModel extends PaymentModel
{
    //Function to Process to orders		
    public function process($order = '', $orderItems = '')
    {
        parent::listPaymentSettingsValues($order['paymentSettingsGroupID']);
		if ($order['authValue'] == 'Authorization') {
            $order['CardAction'] = '1';
        } else {
            $order['CardAction'] = '0';
        }
        $postData = "";
        list($postData,$supportedCurrencyID,$payAmount) = $this->createAuthXML(
		$order, $orderItems);
		if($postData==false)
		{
			$this->isError 		= true;
			$this->errorMessage	= "Currency not configured , Please contact the site admin";
			return false;
		}
		
		if($payAmount<.01)
		{
			$this->isError 		= true;
			$this->errorMessage	= "Invalid amount , please use another method";
			return false;
		}
		
		
        //post data to PSI Gate
        $postUrl  = trim($this->settingsVars["payment_gateway_url"]) == "" ? 
		"https://dev.psigate.com:7989/Messenger/XMLMessenger" : trim($this->settingsVars["payment_gateway_url"]);
        $buffer   = $this->processCurl($postData, $postUrl);
        if ($buffer) {
            $data = $this->parseXml($buffer);
            // Approved
            if ($data[RESULT]['APPROVED'] == "APPROVED") {
                $transactionID = $data[RESULT]['ORDERID'];
                $paymentMethodName    = $this->settingsVars["payment_method_name"];
                $paramstore           = serialize($data);
                if ($order['authValue'] == 'Authorization') {
                    $authOnly = 'AUTH_ONLY';
                } else {
                    $authOnly = 'AUTH_CAPTURE';
                }
                parent::createTransaction($order, $transactionID, 
				$data[RESULT]['RETURNCODE'], $paramstore, $authOnly, 
				$paymentGatewayCharge, $paymentMethodName,$supportedCurrencyID,$payAmount);
                if ($order['store_cc_info'] == 'Yes') {
                    parent::saveCCdata($order['postData'], $order["userID"]);
                }
                $this->isError      = false;
                $this->errorMessage = "";
                return "Pending";
            } else {
                $this->isError      = true;
                $this->errorMessage = "We are sorry, but this transaction has been declined.<br>Payment gateway response: " . $data[RESULT]['ERRMSG'];
            }
        } else {
            $this->isError      = true;
            $this->errorMessage = "Incorrect form params. Please contact site administartor.";
            //return false;
        }
        return !$this->isError;
    }
    //End of function
    public function processCustom($order = '', $postForm = '')//complete the auth only transaction using cron or manage orders
    {
		$ObjCurrency			= new CurrencyModel();
        parent::listPaymentSettingsValues($order['paymentSettingsGroupID']);
        $getPaymentTransactionDetails = $this->getPaymentTransactionDetails(0,
		$order["masterOrderID"]);
        $this->isError                = false;
        //check is transaction completed
        if ($order["paymentType"] != "AUTH_ONLY" || $order["paymentStatus"] == 'Received') {
            $this->isError      = true;
            $this->errorMessage = "Transaction already completed";
            return false;
        }
        //get captured total amount & x_trans_id
        $capturedTotalAmount     = $getPaymentTransactionDetails["convertedPaymentAmount"];
		
        $payAmount               = $capturedTotalAmount;
        $transactionID           = $getPaymentTransactionDetails["transactionID"];
        $store_id    = $this->settingsVars["store_id"];
        $pass_phrase = $this->settingsVars["pass_phrase"];
        $paymentDetails          = unserialize($getPaymentTransactionDetails['extra']);
        //process transaction
        $postData                = '';
        $postData                = '
									<Order>
										<StoreID>'.$store_id.'</StoreID>
										<Passphrase>'.$pass_phrase.'</Passphrase>
										<PaymentType>CC</PaymentType>
										<CardAction>2</CardAction>
										<OrderID>'.
										urlencode($paymentDetails[RESULT]['ORDERID']).'</OrderID>
									</Order>';
        $postUrl                 = trim($this->settingsVars["payment_gateway_url"]) == "" ? "https://dev.psigate.com:7989/Messenger/XMLMessenger" : trim($this->settingsVars["payment_gateway_url"]);
        $buffer                  = $this->processCurl($postData, $postUrl);
        if ($buffer) {
            $data = $this->parseXml($buffer);
            // Approved
            if ($data[RESULT]['APPROVED'] == "APPROVED") {
                $transactionID = $data[RESULT]['ORDERID'];
                $paymentMethodName                  = $this->settingsVars["payment_method_name"];
                $paramstore                         = serialize($data);
                $order['orderStatus']               = 'Completed';
                parent::createTransaction($order, $transactionID, "ORDER TYPE: PRIOR_AUTH_CAPTURE\n\n" . $data[RESULT]['RETURNCODE'], $paramstore, "AUTH_CAPTURE", $paymentGatewayCharge, $paymentMethodName,$getPaymentTransactionDetails["paymentCurrencyID"],$payAmount);
                return "Success";
            } else {
                $this->logStart();
                $this->log($buffer, $this->settingsVars["payment_processor_id"]);
                $this->logFinish();
                $this->isError      = true;
                $this->errorMessage = "We are sorry, but this transaction has been declined.<br>Payment gateway response: " . $data[RESULT]['ERRMSG'];
                
            }
        }
        return !$this->isError;
    }
    public function processRefund($order = '', $postValues = '', $orderItems = '')//payment refunding process
    {
        $ObjRefund 		 = new RefundModel();
		$ObjCurrency	 = new CurrencyModel();
        parent::listPaymentSettingsValues($postValues['paymentSettingsGroupID']);
        $storeId         = $this->settingsVars["store_id"];
        $passPhrase      = $this->settingsVars["pass_phrase"];
        $cardAction      = '3';
        $paymentCurrency = $this->settingsVars["payment_currency"];
        $refundAmount    = $order['orderTotalAmount'];
        
		$supportedCurrencyID = $order["purchasedCurrency"];
		$paymentCurrency	 = $this->settingsVars["payment_currency"];
		
		if ($paymentCurrency != '')
		{
			$paymentCurrency = str_replace(", ", ",", $paymentCurrency);
			$currencyArr     = explode(",", $paymentCurrency);
		}
		if(count($currencyArr)<1)
		{
			$this->isError 		= true;
			$this->errorMessage	= "Currency not configured , Please contact the site admin";
			//return false;
		}
		else
		{
			$currencyFlag = false;
			$purchasedCurrencyDetails 	= $ObjCurrency->getCurrencyByCurrencyID($order["purchasedCurrency"]);
			$currencyCode				= $purchasedCurrencyDetails['currencyCode'];
			$systemCurrencies 			= $ObjCurrency->listCurrencyCodes();
			if(!in_array($purchasedCurrencyDetails['currencyCode'],$currencyArr))
			{
				foreach ($systemCurrencies as $key => $currency)
				{
					if(in_array($currency['currencyCode'],$currencyArr))
					{
						$currencyFlag = true;
						$supportedCurrencyCode 	= $currency['currencyCode'];	
						$supportedCurrencyID 	= $currency['currencyID'];
						break;
					}
				}
				if($currencyFlag==true)
				{
					$refundAmount = $ObjCurrency->convertValueCustom($refundAmount,$order["purchasedCurrency"],$supportedCurrencyID);
				}
				else
				{
					$this->isError 		= true;
					$this->errorMessage	= "Currency not configured , Please contact the site admin";
					//return false;
				}
				
			}
		}
        
        $txnId               = $postValues['apiPaymentTransactionID'];
        $orderID             = $postValues['orderID'];
        $refundTransactionID = $postValues['keyRefundTransactionID'];
        $postData            = '<Order>
										<StoreID>' . $storeId . '</StoreID>
										<Passphrase>' . $passPhrase . '</Passphrase>
										<PaymentType>CC</PaymentType>
										<CardAction>' . $cardAction . '</CardAction>
										<OrderID>' . $txnId . '</OrderID>
										<Subtotal>' . number_format($refundAmount, 2, ".", "") . '</Subtotal>
								</Order>';
								//echo '<pre>'.$postData; exit;
        $postUrl             = trim($this->settingsVars["payment_gateway_url"]) == "" ? "https://dev.psigate.com:7989/Messenger/XMLMessenger" : trim($this->settingsVars["payment_gateway_url"]);
        $buffer              = $this->processCurl($postData, $postUrl);
        if ($buffer) {
            $arrResponse = $this->parseXml($buffer);
            foreach ($arrResponse['RESULT'] as $key => $val) {
                $responseText .= $key . '=' . $val . '<br/>';
            }
            if ($arrResponse[RESULT]['APPROVED'] == "APPROVED") {
                $arrXnResponse['transactionID']  = $arrResponse[RESULT]['TRANSREFNUMBER'];
                $arrXnResponse['refundResponse'] = $responseText;
                $arrXnResponse['refundAmount']   = $arrResponse[RESULT]['FULLTOTAL'];
                $resUpdateRefund                 = $ObjRefund->updateRefundTransaction($orderID, $refundTransactionID, $arrXnResponse);
                $this->isError                   = false;
                $this->errorMessage              = "";
            } else {
                $arrXnResponse['transactionID']  = '';
                $arrXnResponse['refundResponse'] = $responseText;
                $arrXnResponse['refundAmount']   = '';
                $resUpdateRefund                 = $ObjRefund->updateRefundTransaction($orderID, $refundTransactionID, $arrXnResponse);
                $this->isError                   = true;
                $this->errorMessage              = "This transaction has been declined.<br>Payment gateway response: " . $arrResponse[RESULT]['ERRMSG'];
            }
        } else {
            $this->isError      = true;
            $this->errorMessage = "Incorrect form params. Please contact site administartor.";
        }
        return !$this->isError;
    }
    public function createAuthXML($order = '',$orderItems='')//creating xml for pass to the payment gateway
    {
       	$ObjCountry     = new CountryModel();
        $ObjState       = new StateModel();
		$ObjCurrency	= new CurrencyModel();
		
		
		$payAmount      = $order['orderTotalAmount'];
        $shippingAmount = $order["shippingAmount"];
        $taxAmount      = $order["orderTaxAmount"];
        $serviceCharge  = $order["orderOtherServiceCharge"];
		$orderPromoDiscountAmount	= $order['orderPromoDiscountAmount'];
		$orderUserCreditAmount		= $order['orderUserCreditAmount'];
		$supportedCurrencyID		= $order["purchasedCurrency"];
        
		$paymentCurrency= $this->settingsVars["payment_currency"];
		$currencyArr	=	'';
        if ($paymentCurrency != '')
		{
			$paymentCurrency = str_replace(", ", ",", $paymentCurrency);
			$currencyArr     = explode(",", $paymentCurrency);
		}
		if(count($currencyArr)<1)
		{
			$this->isError 		= true;
			$this->errorMessage	= "Currency not configured , Please contact the site admin";
			return false;
		}
		else
		{
			$currencyFlag = false;
			$purchasedCurrencyDetails 	= $ObjCurrency->getCurrencyByCurrencyID($order["purchasedCurrency"]);
			$currencyCode				= $purchasedCurrencyDetails['currencyCode'];
			$systemCurrencies 			= $ObjCurrency->listCurrencyCodes();
			if(!in_array($purchasedCurrencyDetails['currencyCode'],$currencyArr))
			{
				foreach ($systemCurrencies as $key => $currency)
				{
					if(in_array($currency['currencyCode'],$currencyArr))
					{
						$currencyFlag = true;
						$supportedCurrencyCode 	= $currency['currencyCode'];	
						$supportedCurrencyID 	= $currency['currencyID'];
						break;
					}
				}
				if($currencyFlag==true)
				{
					$payAmount = $ObjCurrency->convertValueCustom($payAmount,$order["purchasedCurrency"],$supportedCurrencyID);
					$taxAmount = $ObjCurrency->convertValueCustom($taxAmount,$order["purchasedCurrency"],$supportedCurrencyID);
					$shippingAmount = $ObjCurrency->convertValueCustom($shippingAmount,$order["purchasedCurrency"],
					$supportedCurrencyID);
					$serviceCharge = $ObjCurrency->convertValueCustom($serviceCharge,$order["purchasedCurrency"],
					$supportedCurrencyID);
					$orderPromoDiscountAmount = $ObjCurrency->convertValueCustom($orderPromoDiscountAmount,
					$order["purchasedCurrency"],$supportedCurrencyID);
					$orderUserCreditAmount = $ObjCurrency->convertValueCustom($orderUserCreditAmount,
					$order["purchasedCurrency"],$supportedCurrencyID);
					$currencyCode		=	$supportedCurrencyCode;
				}
				else
				{
					$this->isError 		= true;
					$this->errorMessage	= "Currency not configured , Please contact the site admin";
					return false;
				}
				
			}
		}
		
		$languageIDs['Current']=1;
		$country 		= $ObjCountry->getCountryDetails($order['billingAddress']['billingCountry'],$languageIDs);
		$countryName 	= $country['countryName'];
		if ($order['billingAddress']['billingState'] >0)
		{
			$getStateDetails = $ObjState->getStateDetails($languageIDs,$order['billingAddress']['billingState']);
			$stateName       = $getStateDetails['stateShortName'];
		}
		else
		{
			$stateName = $order['billingAddress']['billingProvince'];
		}

		$postData = '';
        $postData = '
										<Order>
											<StoreID>' . $this->settingsVars["store_id"] . '</StoreID>
											<Passphrase>' . $this->settingsVars["pass_phrase"] . '</Passphrase>
											<Bname>'.urlencode($order['postData']["creditCardFirstName"]).' ' . 
											urlencode($order['postData']["creditCardLastName"]) . '</Bname>
											<Bcompany>'.$order['siteDesc'].'</Bcompany>
											<Baddress1>' .$order['billingAddress']['billingAddress1'] . '</Baddress1>
											<Baddress2>' . urlencode($order['billingAddress']['billingAddress2']) . '</Baddress2>
											<Bcity>' . $order['billingAddress']["billingCity"] . '</Bcity>
											<Bprovince>'.$stateName.'</Bprovince>
											<Bpostalcode>' . urlencode($order['billingAddress']["billingZip"]) . '</Bpostalcode>
											<Bcountry>'.$countryName.'</Bcountry>';
											
			if($order['shippingAddress']['shippingCountryID'] >0)
			{	
				$languageIDs['Current']=1;	
				$sCountry 		= $ObjCountry->getCountryDetails($order['shippingAddress']['shippingCountryID'],$languageIDs);
				$sCountryName 	= $sCountry['countryName'];
				if ($order['shippingAddress']['shippingStateID'] >0)
				{
					$getStateDetails = $ObjState->getStateDetails($languageIDs,$order['shippingAddress']['shippingStateID']);
					$stateName       = $getStateDetails['stateShortName'];
				}
				else
				{
					$stateName = $order['shippingAddress']['shippingProvince'];
				}
				
				$sCountryName 	= $sCountry['countryName'];	
				
								$postData .='<Sname>'.$order['shippingAddress']['shippingFname'].' '.
											$order['shippingAddress']['shippingLname'].'</Sname>
											<Scompany>'.$order['siteDesc'].'</Scompany>
											<Saddress1>'.$order['shippingAddress']['shippingAddress1'].'</Saddress1>
											<Scity>'.$order['shippingAddress']['shippingCity'].'</Scity>
											<Sprovince>'.$stateName.'</Sprovince>
											<Scountry>'.$sCountryName.'</Scountry>
											<Spostalcode>'.$order['shippingAddress']['shippingZip'].'</Spostalcode>';
			}
								$postData .='<Email>' . $order['billingAddress']["billingEmail"] . '</Email>
											 <Phone>' . $order['billingAddress']["billingPhone"] . '</Phone>';
			if (!empty($orderItems))
			{
				foreach ($orderItems as $key => $ordItem)
				{
					$key++;
					$orderGiveAsGift = '';
					if ($ordItem['orderGiveAsGift'] == 'Yes')
					{
						$orderGiveAsGift = ' (As Gift)';
					}
					$fldName = ($order['orderType'] == 'deal') ? 'dealOptionName' : 'itemName';
					$itemsArray = htmlspecialchars(substr($ordItem[$fldName], 0, 180)) . $orderGiveAsGift;
					if($currencyFlag==true) 
					{
						$ordItem['orderItemPrice']	=	$ObjCurrency->convertValueCustom(
						$ordItem['orderItemPrice'],
						$order["purchasedCurrency"],$supportedCurrencyID);
					}
					$postData .='<Item>
								<ItemID>'.$key.'</ItemID>
								<ItemDescription>'.$itemsArray.'</ItemDescription>
								<ItemQty>'.$ordItem['orderItemQuantity'].'</ItemQty>
								<ItemPrice>'.urlencode(number_format($ordItem['orderItemPrice'], 2, ".", "")).'</ItemPrice>
								</Item>';
				}
			}
			if($serviceCharge >0)
			{
				$key++;
					$postData .='<Item>
								<ItemID>'.$key.'</ItemID>
								<ItemDescription>Service Charge</ItemDescription>
								<ItemQty>1</ItemQty>
								<ItemPrice>'.urlencode(number_format($serviceCharge, 2, ".", "")).'</ItemPrice>
								</Item>';
			}
			if($orderPromoDiscountAmount >0)
			{
				$key++;
					$postData .='<Item>
								<ItemID>'.$key.'</ItemID>
								<ItemDescription>Promo DiscountAmount</ItemDescription>
								<ItemQty>1</ItemQty>
								<ItemPrice>-'.urlencode(number_format($orderPromoDiscountAmount, 2, ".", "")).'</ItemPrice>
								</Item>';				
				
			}
			if($orderUserCreditAmount >0)
			{
				$key++;
					$postData .='<Item>
								<ItemID>'.$key.'</ItemID>
								<ItemDescription>User Credit Amount</ItemDescription>
								<ItemQty>1</ItemQty>
								<ItemPrice>-'.urlencode(number_format($orderUserCreditAmount, 2, ".", "")).'</ItemPrice>
								</Item>';				
				
			}			
			$postData .= 		'<Tax1>' . urlencode(number_format($taxAmount, 2, ".", "")) . '</Tax1>
								<ShippingTotal>' . urlencode(number_format($shippingAmount, 2, ".", "")).'</ShippingTotal>
								<PaymentType>CC</PaymentType>
								<CardAction>' . $order['CardAction'] . '</CardAction>
								<CardNumber>' . urlencode($order['postData']["creditCardNumber"]) . '</CardNumber>
								<CardExpMonth>' . urlencode($order['postData']["expMonth"]) . '</CardExpMonth>
								<CardExpYear>' . urlencode(substr($order['postData']["expYear"], -2)) . '</CardExpYear>
								<CardIDNumber>' . urlencode($order['postData']["securityCode"]) . '</CardIDNumber>
							</Order>';
							
        return array($postData,$supportedCurrencyID,$payAmount);
    }
    //Function to Process curl
    public function processCurl($postData, $postUrl)//processing curl request
    {
        $c = curl_init($postUrl);
        curl_setopt($c, CURLOPT_VERBOSE, 0);
        curl_setopt($c, CURLOPT_HEADER, 0);
        curl_setopt($c, CURLOPT_HTTPHEADER, array(
            "Content-Type: text/xml"
        ));
        curl_setopt($c, CURLOPT_POSTFIELDS, $postData);
        curl_setopt($c, CURLOPT_POST, 1);
        curl_setopt($c, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($c, CURLOPT_SSL_VERIFYPEER, 1);
        if (!ini_get('safe_mode')) {
            set_time_limit(3000);
        }
        $buffer = curl_exec($c);
        if (curl_errno($c) > 0) {
            $this->isError      = true;
            $this->errorMessage = curl_error($c);
            return false;
        }
        return !$buffer ? false : $buffer;
    }
    //End of function	
    function parseXml($data)//parsing xml response
    {
        $xmlParser = xml_parser_create();
        xml_parse_into_struct($xmlParser, $data, $vals, $index);
        xml_parser_free($xmlParser);
        $params = array();
        $level  = array();
        foreach ($vals as $xmlElem) {
            if ($xmlElem['type'] == 'open') {
                if (array_key_exists('attributes', $xmlElem)) {
                    list($level[$xmlElem['level']], $extra) = array_values($xmlElem['attributes']);
                } else {
                    $level[$xmlElem['level']] = $xmlElem['tag'];
                }
            }
            if ($xmlElem['type'] == 'complete') {
                $startLevel = 1;
                $phpStmt    = '$params';
                while ($startLevel < $xmlElem['level']) {
                    $phpStmt .= '[$level[' . $startLevel . ']]';
                    $startLevel++;
                }
                $phpStmt .= '[$xmlElem[\'tag\']] = $xmlElem[\'value\'];';
                eval($phpStmt);
            }
        }
        return $params;
    }
}