<?php
/***************************************************************************
 *                                                                          *
 * Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
 *                                                                          *
 * This  is  commercial  software,  only  users  who have purchased a valid *
 * license  and  accept  to the terms of the  License Agreement can install *
 * and use this program.                                                    *
 *                                                                          *
 ****************************************************************************
 * PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
 * "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
 ****************************************************************************/
//
//$Id: PxpaypostModel.php, v 1.0 2011/06/14 20:52:11

//
class PxpaypostModel extends PaymentModel
{
    var $PxPayKey;
    var $PxPayUrl;
    var $PxPayUserid;
    var $PxPayUserName;
    var $PxPayPassword;
    public function process($order = '',$orderItems = '')
    {
		$ObjCurrency		  = new CurrencyModel();
		parent::listPaymentSettingsValues($order['paymentSettingsGroupID']);
        $key                  = $this->settingsVars["pay_key"];
        $url                  = $this->settingsVars["payment_gateway_url"];
        $userId               = $this->settingsVars["pay_userid"];
        $userName             = $this->settingsVars["post_username"];
        $password             = $this->settingsVars["post_password"];
        $payAmount            = $order['orderTotalAmount'];
		$supportedCurrencyID  = $order["purchasedCurrency"];
        $paymentCurrency      = $this->settingsVars["payment_currency"];
        $currencyArr          = '';
		
		if ($paymentCurrency != '')
		{
			$paymentCurrency = str_replace(", ", ",", $paymentCurrency);
			$currencyArr     = explode(",", $paymentCurrency);
		}
		if(count($currencyArr)<1)
		{
			$this->isError 		= true;
			$this->errorMessage	= "Currency not configured , Please contact the site admin";
			return false;
		}
		else
		{
			$currencyFlag = false;
			$purchasedCurrencyDetails 	= $ObjCurrency->getCurrencyByCurrencyID($order["purchasedCurrency"]);
			$currencyCode				= $purchasedCurrencyDetails['currencyCode'];
			$systemCurrencies 			=	$ObjCurrency->listCurrencyCodes();
			if(!in_array($purchasedCurrencyDetails['currencyCode'],$currencyArr))
			{
				foreach ($systemCurrencies as $key => $currency)
				{
					if(in_array($currency['currencyCode'],$currencyArr))
					{
						$currencyFlag = true;
						$supportedCurrencyCode 	= $currency['currencyCode'];	
						$supportedCurrencyID 	= $currency['currencyID'];
						break;
					}
				}
				//echo '<pre>';print_r($systemCurrencies);print_r($currencyArr);echo $order["purchasedCurrency"];exit;
				if($currencyFlag==true)
				{
					$payAmount = $ObjCurrency->convertValueCustom($payAmount,$order["purchasedCurrency"],$supportedCurrencyID);
					$currencyCode		=	$supportedCurrencyCode;
				}
				else
				{
					$this->isError 		= true;
					$this->errorMessage	= "Currency not configured , Please contact the site admin";
					return false;
				}
				
			}
		}
		
		if($payAmount<.01)
		{
			$this->isError 		= true;
			$this->errorMessage	= "Invalid amount , please use another method";
			return false;
		}
		
        $billingAddress1 = ($order['billingAddress']['billingAddress1'] != '') ? $order['billingAddress']['billingAddress1'] : '';
        /* Payment Express Process */
        $httpHost        = getenv("HTTP_HOST");
        $requestUri      = getenv("SCRIPT_NAME");
        $serverUrl       = "http://$httpHost";
        $scriptUrl       = (version_compare(PHP_VERSION, "4.3.4", ">=")) ? "$serverUrl$requestUri" : "$serverUrl/$requestUri";
        $txnId           = uniqid("ID");
        $amountInput     = number_format($payAmount, 2, ".", "");
        if ($order['authValue'] == 'Authorization') {
            $txntypes = 'Auth';
        } else {
            $txntypes = 'Purchase';
        }
		$txtInvDesc     = "Payment From " . $order['postData']['creditCardFirstName'] ."(ORD- ".$order['masterOrderID'].")";
        $cmdDoTxnTransaction = '';
        $cmdDoTxnTransaction .= "<Txn>";
        $cmdDoTxnTransaction .= "<PostUsername>" . $userName . "</PostUsername>"; #Insert your DPS Username here
        $cmdDoTxnTransaction .= "<PostPassword>" . $password . "</PostPassword>"; #Insert your DPS Password here
        $cmdDoTxnTransaction .= "<CardHolderName>" . $order['postData']['creditCardFirstName'] . "</CardHolderName>";
        $cmdDoTxnTransaction .= "<CardNumber>" . $order['postData']['creditCardNumber'] . "</CardNumber>";
        $cmdDoTxnTransaction .= "<Amount>" . $amountInput . "</Amount>";
        $cmdDoTxnTransaction .= "<DateExpiry>12" . $order['postData']['expMonth'] . "</DateExpiry>";
        $cmdDoTxnTransaction .= "<Cvc2>" . $order['postData']["securityCode"] . "</Cvc2>";
        $cmdDoTxnTransaction .= "<InputCurrency>" . $currencyCode . "</InputCurrency>";
        $cmdDoTxnTransaction .= "<TxnType>" . $txntypes . "</TxnType>";
        $cmdDoTxnTransaction .= "<MerchantReference>" . $txtInvDesc . "</MerchantReference>";
        $cmdDoTxnTransaction .= "</Txn>";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: text/xml"
        ));
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $cmdDoTxnTransaction);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0); //Needs to be included if no *.crt is available to verify SSL certificates
        curl_setopt($ch, CURLOPT_SSLVERSION, 3);
        $result = curl_exec($ch);
        curl_close($ch);
        $params     = $this->parseXml($result);
		$paramstore           = serialize($params);
		$success = $params[TXN][SUCCESS];

   		if ($success == 0) {
			$this->isError      = true;
            $this->errorMessage = "We are sorry, but this transaction has been declined.<br>Payment gateway response: " . $params[TXN][$success][MERCHANTRESPONSETEXT];
            $paymentStatus      = 'Failure';
		}
		else if($success == 1) {
			$merchantReference = $params[TXN][$success][MERCHANTREFERENCE];
			$cardHolderName	= $params[TXN][$success][CARDHOLDERNAME];
			$authCode = $params[TXN][$success][AUTHCODE];
			$amount	= $params[TXN][$success][AMOUNT];
			$currencyName = $params[TXN][$success][CURRENCYNAME];
			$txnType = $params[TXN][$success][TXNTYPE];
			$cardNumber	= $params[TXN][$success][CARDNUMBER];
			$dateExpiry	= $params[TXN][$success][DATEEXPIRY];
			$cardHolderResponseText	= $params[TXN][$success][CARDHOLDERRESPONSETEXT];
			$cardHolderResponseDescription = $params[TXN][$success][CARDHOLDERRESPONSEDESCRIPTION];
			$merchantResponseText = $params[TXN][$success][MERCHANTRESPONSETEXT];
			$dPSTxnRef = $params[TXN][$success][DPSTXNREF];
					
			$html = "<table align='center' width='200' style='FONT-SIZE: 10pt; FONT-FAMILY: Arial, Helvetica, sans-serif'>";
			$html .= "<BR><hr><BR>";
			$html .= "<tr><td>Merchant Reference: </td><td>$merchantReference</td></tr>";
			$html .= "<tr><td>CardHolderName: </td><td>$cardHolderName</td></tr>";
			$html .= "<tr><td>AuthCode: </td><td>$authCode</td></tr>";
			$html .= "<tr><td>Amount: </td><td>$amount</td></tr>";
			$html .= "<tr><td>CurrencyName: </td><td>$currencyName</td></tr>";
			$html .= "<tr><td>DateExpiry: </td><td>$dateExpiry</td></tr>";
			$html .= "<tr><td>CardHolderResponseText: </td><td>$cardHOlderResponseText</td></tr>";
			$html .= "<tr><td>CardHolderResponseDescription: </td><td>$cardHolderResponseDescription</td></tr>";
			$html .= "<tr><td>MerchantResponseText: </td><td>$merchantResponseText</td></tr>";
			$html .= "<tr><td>TxnType: </td><td>$txnType</td></tr>";
			$html .= "<tr><td>DPSTxnRef: </td><td>$dPSTxnRef</td></tr>";
			$html .= "</table>";
			$transactionID        = $dPSTxnRef;
            $paymentGatewayCharge = 0;
			$paymentMethodName    = $this->settingsVars["payment_method_name"];
			if ($postForm['authValue'] == 'Authorization') {
                    $authOnly = 'AUTH_ONLY';
            } else {
                    $authOnly = 'AUTH_CAPTURE';
            }
			parent::createTransaction($order, $transactionID, $html, $paramstore, $authOnly, $paymentGatewayCharge, $paymentMethodName,$supportedCurrencyID,$payAmount);
            if ($order['store_cc_info'] == 'Yes') {
                parent::saveCCdata($order['postData'], $order["userID"]);
            }
            $this->isError      = false;
            $this->errorMessage = "";
            $paymentStatus      = 'Pending';
		}
		else{
			$this->isError      = true;
			$this->errorMessage     = "Error: An invalid response was recieved from the payment gateway.";
            $paymentStatus = 'Failure';
		}
		return $paymentStatus;
        #Parse output XML
    }
    public function processCustom($order = '')
    {
        $ObjCurrency			= new CurrencyModel();
        $this->isError         = false;
		parent::listPaymentSettingsValues($order['paymentSettingsGroupID']);
		$getPaymentTransactionDetails =  parent::getPaymentTransactionDetails(0,
		$order["masterOrderID"]);
		$purchasedCurrencyDetails = $ObjCurrency->getCurrencyByCurrencyID(
		$getPaymentTransactionDetails["paymentCurrencyID"]);
		$currencyCode			= $purchasedCurrencyDetails['currencyCode'];
        //check is transaction completed
        if ($order["paymentType"] != "AUTH_ONLY" || $order["paymentStatus"] == 'Received') {
            $this->isError      = true;
            $this->errorMessage = "Transaction already completed";
            return false;
        }
        //get captured total amount & x_trans_id
        $capturedTotalAmount 	= $getPaymentTransactionDetails["convertedPaymentAmount"];
        $payAmount           = number_format($capturedTotalAmount, 2, ".", "");
        $transactionID       = $getPaymentTransactionDetails["transactionID"];
       	$paymentResponse     = unserialize($getPaymentTransactionDetails['extra']);
        $dpsTxnRef           = $getPaymentTransactionDetails['transactionID'];
        $cmdDoTxnTransaction = '';
        $cmdDoTxnTransaction .= "<Txn>";
        $cmdDoTxnTransaction .= "<PostUsername>" . 
		$this->settingsVars["post_username"] . "</PostUsername>"; #Insert your DPS Username here
        $cmdDoTxnTransaction .= "<PostPassword>" . 
		$this->settingsVars["post_password"] . "</PostPassword>"; #Insert your DPS Password here
        $cmdDoTxnTransaction .= "<Amount>" . $payAmount . "</Amount>";
        $cmdDoTxnTransaction .= "<InputCurrency>" . $currencyCode . "</InputCurrency>";
        $cmdDoTxnTransaction .= "<DpsTxnRef>" . $dpsTxnRef . "</DpsTxnRef>";
        $cmdDoTxnTransaction .= "<TxnType>Complete</TxnType>";
        $cmdDoTxnTransaction .= "</Txn>";
        $url = "sec.paymentexpress.com/pxpost.aspx";
        $ch  = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://" . $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: text/xml"
        ));
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $cmdDoTxnTransaction);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0); 
		//Needs to be included if no *.crt is available to verify SSL certificates
        curl_setopt($ch, CURLOPT_SSLVERSION, 3);
        $result = curl_exec($ch);
		
        curl_close($ch);
        $params     = $this->parseXml($result);
        $paramstore = serialize($params);
        $success    = $params[TXN][SUCCESS];
		$merchantResponseText = $params[TXN][$success][MERCHANTRESPONSETEXT];
        if ($success == '1') {
            $paymentGatewayCharge               = '';
            $paymentMethodName                  = $this->settingsVars["payment_method_name"];
            $postForm['paymentSettingsGroupID'] = $order['paymentSettingsGroupID'];
            $order['orderStatus']               = 'Completed';
            parent::createTransaction($order, $transactionID, 
			"ORDER TYPE: PRIOR_AUTH_CAPTURE\n\n: Success", $paramstore, 
			"AUTH_CAPTURE", $paymentGatewayCharge, $paymentMethodName,
			$getPaymentTransactionDetails["paymentCurrencyID"],$payAmount);
            
            $this->isError      = false;
            $this->errorMessage = "";
            return "Success";
        } else {
            $this->isError      = true;
            $this->errorMessage = $merchantResponseText;
        }
        if ($this->isError) {
            $this->logStart();
            $this->log($merchantResponseText, $this->settingsVars["payment_processor_id"]);
            $this->logFinish();
            $this->isError = true;
        }
        return !$this->isError;
    }
	public function processRefund($order = '', $postValues = '', $orderItems = '')//payment refunding process
    {
        $ObjPayment 	= new PaymentModel();
        $ObjRefund  	= new RefundModel();
		$ObjCurrency	= new CurrencyModel();
        $pxPay      	= $ObjPayment->listPaymentSettingsValues($postValues['paymentSettingsGroupID']);
        $dpsTxnRef  	= urlencode($postValues['apiPaymentTransactionID']);
        $merchRef   	= $order['orderNumber'];
        $refundAmt  	= number_format($order['orderTotalAmount'], 2, ".", "");
        
		$supportedCurrencyID = $order["purchasedCurrency"];
		$paymentCurrency	 = $pxPay->settingsVars["payment_currency"];
		
		if ($paymentCurrency != '')
		{
			$paymentCurrency = str_replace(", ", ",", $paymentCurrency);
			$currencyArr     = explode(",", $paymentCurrency);
		}
		if(count($currencyArr)<1)
		{
			$this->isError 		= true;
			$this->errorMessage	= "Currency not configured , Please contact the site admin";
			//return false;
		}
		else
		{
			$currencyFlag = false;
			$purchasedCurrencyDetails 	= $ObjCurrency->getCurrencyByCurrencyID($order["purchasedCurrency"]);
			$currencyCode				= $purchasedCurrencyDetails['currencyCode'];
			$systemCurrencies 			= $ObjCurrency->listCurrencyCodes();
			if(!in_array($purchasedCurrencyDetails['currencyCode'],$currencyArr))
			{
				foreach ($systemCurrencies as $key => $currency)
				{
					if(in_array($currency['currencyCode'],$currencyArr))
					{
						$currencyFlag = true;
						$supportedCurrencyCode 	= $currency['currencyCode'];	
						$supportedCurrencyID 	= $currency['currencyID'];
						break;
					}
				}
				if($currencyFlag==true)
				{
					$refundAmt = $ObjCurrency->convertValueCustom($refundAmt,$order["purchasedCurrency"],$supportedCurrencyID);
				}
				else
				{
					$this->isError 		= true;
					$this->errorMessage	= "Currency not configured , Please contact the site admin";
					//return false;
				}
				
			}
		}
		$refundAmt  = number_format($refundAmt, 2, ".", "");
		
		$txnType    = 'Refund';
        $postUrl    = "https://sec.paymentexpress.com/pxpost.aspx";
        $postXml    = "<Txn>
							<PostUsername>" . $pxPay->settingsVars["post_username"] . "</PostUsername>
							<PostPassword>" . $pxPay->settingsVars["post_password"] . "</PostPassword>
							<Amount>" . $refundAmt . "</Amount>
							<TxnType>" . $txnType . "</TxnType>
							<DpsTxnRef>" . $dpsTxnRef . "</DpsTxnRef>
							<MerchantReference>" . $merchRef . "</MerchantReference>
						</Txn>";
        $ch         = curl_init();
        curl_setopt($ch, CURLOPT_URL, $postUrl);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "Content-Type: text/xml"
        ));
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postXml);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0); //Needs to be included if no *.crt is available to verify SSL certificates
        curl_setopt($ch, CURLOPT_SSLVERSION, 3);
        $result 	= curl_exec($ch);
        curl_close($ch);
        $params              = $this->parseXml($result);
        $pxResponse          = 'RESPONSETEXT=' . $params[TXN][RESPONSETEXT] . '<br/>HELPTEXT=' . $params[TXN][HELPTEXT] . '<br/>DPSTXNREF=' . $params[TXN][DPSTXNREF];
        $success             = $params[TXN][SUCCESS];
        $masterOrderID             = $postValues['masterOrderID'];
        $refundTransactionID = $postValues['keyRefundTransactionID'];
        if ($success == '1') {
            $arrXnResponse['transactionID']  = $params[TXN][DPSTXNREF];
            $arrXnResponse['refundResponse'] = $pxResponse;
            $arrXnResponse['refundAmount']   = $params[TXN][1][AMOUNT];
            $resUpdateRefund                 = $ObjRefund->updateRefundTransaction('', $refundTransactionID, $arrXnResponse,$masterOrderID);
            $this->isError                   = false;
            $this->errorMessage              = "";
        } else {
            $arrXnResponse['transactionID']  = '';
            $arrXnResponse['refundResponse'] = $pxResponse;
            $arrXnResponse['refundAmount']   = '';
            $resUpdateRefund                 = $ObjRefund->updateRefundTransaction('', $refundTransactionID, $arrXnResponse,$masterOrderID);
            $this->isError                   = true;
            $this->errorMessage              = $ResponseText;
        }
        return !$this->isError;
    }
    function parseXml($data)
    {
        $xmlParser = xml_parser_create();
        xml_parse_into_struct($xmlParser, $data, $vals, $index);
        xml_parser_free($xmlParser);
        $params = array();
        $level  = array();
        foreach ($vals as $xmlElem) {
            if ($xmlElem['type'] == 'open') {
                if (array_key_exists('attributes', $xmlElem)) {
                    list($level[$xmlElem['level']], $extra) = array_values($xmlElem['attributes']);
                } else {
                    $level[$xmlElem['level']] = $xmlElem['tag'];
                }
            }
            if ($xmlElem['type'] == 'complete') {
                $startLevel = 1;
                $phpStmt    = '$params';
                
                while ($startLevel < $xmlElem['level']) {
                    $phpStmt .= '[$level[' . $startLevel . ']]';
                    $startLevel++;
                }
                $phpStmt .= '[$xmlElem[\'tag\']] = $xmlElem[\'value\'];';
                eval($phpStmt);
            }
        }
        return $params;
    }
}