<?php
/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/
 //
 //$Id: vtnModel.php, v 1.0 2011/06/14 20:52:11
 //
class VtnModel extends PaymentModel 
{
	var $fields = array();           // array holds the fields to submit to vtn
	function addField($field, $value) 
	{
		// adds a key=>value pair to the fields array, which is what will be 
		// sent to vtn as POST variables.  If the value is already in the 
		// array, it will be overwritten.
		$this->fields["$field"] = $value;
	}
	function process($order = '',$orderItems = '') //payment gate way processing
	{
		$ObjCurrency		= new CurrencyModel();
		parent::listPaymentSettingsValues($order['paymentSettingsGroupID']);
		$this->addField('merchant_email_id', $this->settingsVars["merchant_email_id"]);
		$this->addField('callback_id', $this->settingsVars['call_back_id']);
		$this->addField('payment_gateway_url', $this->settingsVars['payment_gateway_url']);
		$paymentCurrency	=	$this->settingsVars["payment_currency"];
		$payAmount      	= $order['orderTotalAmount'];
		if ($paymentCurrency != '')
		{
			$paymentCurrency = str_replace(", ", ",", $paymentCurrency);
			$currencyArr     = explode(",", $paymentCurrency);
		}
		if(count($currencyArr)<1)
		{
			$this->isError 		= true;
			$this->errorMessage	= "Currency not configured , Please contact the site admin";
			return false;
		}
		else
		{
			$currencyFlag = false;
			$purchasedCurrencyDetails 	= $ObjCurrency->getCurrencyByCurrencyID($order["purchasedCurrency"]);
			$currencyCode				= $purchasedCurrencyDetails['currencyCode'];
			$systemCurrencies 			=	$ObjCurrency->listCurrencyCodes();
			if(!in_array($purchasedCurrencyDetails['currencyCode'],$currencyArr))
			{
				foreach ($systemCurrencies as $key => $currency)
				{
					if(in_array($currency['currencyCode'],$currencyArr))
					{
						$currencyFlag = true;
						$supportedCurrencyCode 	= $currency['currencyCode'];	
						$supportedCurrencyID 	= $currency['currencyID'];
						break;
					}
				}
				if($currencyFlag==true)
				{
					$payAmount = $ObjCurrency->convertValueCustom($payAmount,$order["purchasedCurrency"],$supportedCurrencyID);
					$currencyCode		=	$supportedCurrencyCode;
				}
				else
				{
					$this->isError 		= true;
					$this->errorMessage	= "Currency not configured , Please contact the site admin";
					return false;
				}
				
			}
		}
		
		$userPayAmount  = ceil($payAmount);
		//transactions which have less than 100 total amount cant be proceed with vtn
		if($userPayAmount <100)
		$this->addField('amount', '101');
		else
		$this->addField('amount', $userPayAmount);
		
		if (!empty($orderItems))
			{
				foreach ($orderItems as $key => $ordItem)
				{
					$orderGiveAsGift = '';
					if ($ordItem['orderGiveAsGift'] == 'Yes')
					{
						$orderGiveAsGift = ' (As Gift)';
					}
					$fldName = ($order['orderType'] == 'deal') ? 'dealOptionName' : 'itemName';
					$itemsArray .= htmlspecialchars(substr($ordItem[$fldName], 0, 110)) . $orderGiveAsGift . " Quantity - ". $ordItem['orderItemQuantity']." ";
				}
			}
		$this->addField('item_name', $itemsArray);
		$this->addField('return_url', $order['returnURL']);
		$this->addField('cancel_url', $order['cancelURL']);
		$this->addField('custom_remarks', $order['masterOrderID']);
		$this->addField('currency_id', 'NGN');
		$this->addField('currency_id', $currencyCode);
		$url = $this->fields["payment_gateway_url"];
		echo "<html>\n";
		echo "<head><title>Processing Payment...</title></head>\n";
		echo "<body onLoad=\"document.form.submit();\">\n";
		echo "<center><h3>Please wait, your order is being processed...</h3></center>\n";
		echo "<form name=\"frmsendpaymentrequest\" method=\"post\" name=\"form\" action=\"".$url."\">\n";
		foreach ($this->fields as $name => $value) 
		{
			echo "<input type=\"hidden\" name=\"$name\" value=\"$value\">";
      	}
      	echo "</form>\n";
      	echo "</body></html>\n";
		echo "<script>document.frmsendpaymentrequest.submit();</script>";
		exit;
   	}
}