<?php
/**
 * Class Profiler
 *
 * Includes profiling for
 * 1) queries
 *
 * @author Sijo Kurian <sijo_tk@ispg.in>
 * @package Oorjit Deals
 * @license Please read 'copyright.txt', proprietary License
 * @copyright Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.
 * @version Profiles.class.PHP, v 1.0 2012/06/1 10:52:11 
 */
class Profiler 
{
	public static $enable_profiler		= FALSE;
	public static $_profiler_sections 	= array();
/*	protected $_available_sections = array(
										'benchmarks',
										'get',
										'memory_usage',
										'post',
										'uri_string',
										'controller_info',
										'queries',
										'http_headers',
										'session_data',
										'config'
										);*/
	protected $_available_sections = array(
										'benchmarks',
										'memory_usage',
										'post',
										'queries'
											);
	public function __construct($config = array())
	{

	}

	/**
	 * Compile Queries
	 *
	 * @return	string
	 */
	protected function _compile_queries()
	{
		$ObjDatabase 			= Registry::getInstance('Database');
		$highlight = array('SELECT', 'DISTINCT', 'FROM', 'WHERE', 'AND', 'LEFT&nbsp;JOIN', 'ORDER&nbsp;BY', 'GROUP&nbsp;BY', 'LIMIT', 'INSERT', 'INTO', 'VALUES', 'UPDATE', 'OR&nbsp;', 'HAVING', 'OFFSET', 'NOT&nbsp;IN', 'IN', 'LIKE', 'NOT&nbsp;LIKE', 'COUNT', 'MAX', 'MIN', 'ON', 'AS', 'AVG', 'SUM', '(', ')');
		$totalTime = 0;
		if (count($ObjDatabase->queries) == 0)
		{
			$outputQueryRow .= "<tr><td style='width:100%;color:#0000FF;font-weight:normal;background-color:#eee;padding:5px;'>profiler_no_querie</td></tr>\n";
		}
		else
		{
			foreach ($ObjDatabase->queries as $key => $val)
			{
				$time = number_format($ObjDatabase->query_times[$key], 4);

				$val = $this->highlight_code($val, ENT_QUOTES);

				foreach ($highlight as $bold)
				{
					$val = str_replace($bold, '<strong>'.$bold.'</strong>', $val);
				}

				$outputQueryRow .= "<tr><td style='padding:5px; vertical-align: top;width:1%;color:#900;font-weight:normal;background-color:#ddd;'>".$time."&nbsp;&nbsp;</td><td style='padding:5px; color:#000;font-weight:normal;background-color:#ddd;'>".$val."</td></tr>\n";
				$totalTime		+= $time;
			}
		}
		$output  = "\n\n";
		$count = 0;
		$output  = "\n\n";
			$output .= '<fieldset style="border:1px solid #0000FF;padding:6px 10px 10px 10px;margin:20px 0 20px 0;background-color:#eee">';
			$output .= "\n";
			$output .= '<legend style="color:#0000FF;">&nbsp;&nbsp;DATABASE PROFILER - &nbsp;&nbsp;&nbsp; NUMBER OF QUERIES : <b>'.count($ObjDatabase->queries).'</b> ('.number_format($totalTime,4).'&nbsp;Sec)&nbsp;&nbsp;</legend>';
			$output .= "\n";
			$output .= "\n\n<table style='width:100%;' id='oorjit_profiler_queries_db'>\n";		
		$output .= $outputQueryRow;
		$output .= "</table>\n";
		$output .= "</fieldset>";
		return $output;
	}

	// --------------------------------------------------------------------

	/**
	 * Compile $_POST Data
	 *
	 * @return	string
	 */
	protected function _compile_post()
	{
		$output  = "\n\n";
		$output .= '<fieldset id="oorjit_profiler_post" style="border:1px solid #009900;padding:6px 10px 10px 10px;margin:20px 0 20px 0;background-color:#eee">';
		$output .= "\n";
		$output .= '<legend style="color:#009900;">&nbsp;&nbsp;POST DATA&nbsp;&nbsp;</legend>';
		$output .= "\n";

		if (count($_POST) == 0)
		{
			$output .= "<div style='color:#009900;font-weight:normal;padding:4px 0 4px 0'>NO POST DATA</div>";
		}
		else
		{
			$output .= "\n\n<table style='width:100%'>\n";

			foreach ($_POST as $key => $val)
			{
				if ( ! is_numeric($key))
				{
					$key = "'".$key."'";
				}

				$output .= "<tr><td style='width:50%;padding:5px;color:#000;background-color:#ddd;'>&#36;_POST[".$key."]&nbsp;&nbsp; </td><td style='width:50%;padding:5px;color:#009900;font-weight:normal;background-color:#ddd;'>";
				if (is_array($val))
				{
					$output .= "<pre>" . htmlspecialchars_decode(stripslashes(print_r($val, TRUE))) . "</pre>";
				}
				else
				{
					$output .= htmlspecialchars_decode(stripslashes($val));
				}
				$output .= "</td></tr>\n";
			}

			$output .= "</table>\n";
		}
		$output .= "</fieldset>";

		return $output;
	}

	/**
	 * Compile memory usage
	 *
	 * Display total used memory
	 *
	 * @return	string
	 */
	protected function _compile_memory_usage()
	{
		$output  = "\n\n";
		$output .= '<fieldset id="ci_profiler_memory_usage" style="border:1px solid #5a0099;padding:6px 10px 10px 10px;margin:20px 0 20px 0;background-color:#eee">';
		$output .= "\n";
		$output .= '<legend style="color:#5a0099;">&nbsp;&nbsp;MEMORY USAGE&nbsp;&nbsp;</legend>';
		$output .= "\n";

		if (function_exists('memory_get_usage') && ($usage = memory_get_usage()) != '')
		{
			$output .= "<div style='color:#5a0099;font-weight:normal;padding:4px 0 4px 0'>".number_format($usage).' bytes</div>';
		}
		else
		{
			$output .= "<div style='color:#5a0099;font-weight:normal;padding:4px 0 4px 0'>NO MEMORY USAGE</div>";
		}

		$output .= "</fieldset>";

		return $output;
	}

	protected function _compile_benchmarks()
	{
		$output  = "\n\n";
		$output .= '<fieldset id="ci_profiler_memory_usage" style="border:1px solid #5a0099;padding:6px 10px 10px 10px;margin:20px 0 20px 0;background-color:#eee">';
		$output .= "\n";
		$output .= '<legend style="color:#5a0099;">&nbsp;&nbsp;BENCHMARKS&nbsp;&nbsp;</legend>';
		$output .= "\n";
		list($system_sm, $system_ss) = explode(' ', PAGE_PARSE_START_TIME);
		$system_start_time	= $system_sm+$system_ss;
		list($system_em, $system_es) = explode(' ', microtime());
		$system_end_time	= $system_em+$system_es;
		$page_render_time	= number_format($system_end_time - $system_start_time,6);
		$output .= "<div style='color:#5a0099;font-weight:normal;padding:4px 0 4px 0'>Page rendered in &nbsp; : &nbsp;<b>".$page_render_time.' Sec </b></div>';
		$output .= "</fieldset>";
		return $output;
	}		

	public function run()
	{
		$output = "<div id='oorjit_profiler' style='clear:both;background-color:#fff;padding:10px;'>";
		$fields_displayed = 0;
		foreach ($this->_available_sections as $section)
		{
			if (Profiler::$_profiler_sections[$section] !== FALSE)
			{
				$func = "_compile_{$section}";
				$output .= $this->{$func}();
				$fields_displayed++;
			}
		}

		if ($fields_displayed == 0)
		{
			$output .= '<p style="border:1px solid #5a0099;padding:10px;margin:20px 0;background-color:#eee">NO POFILERS ARE ENABLED</p>';
		}

		$output .= '</div>';

		return $output;
	}
	public function highlight_code($str)
	{
		// The highlight string function encodes and highlights
		// brackets so we need them to start raw
		$str = str_replace(array('&lt;', '&gt;'), array('<', '>'), $str);

		// Replace any existing PHP tags to temporary markers so they don't accidentally
		// break the string out of PHP, and thus, thwart the highlighting.

		$str = str_replace(array('<?', '?>', '<%', '%>', '\\', '</script>'),
							array('phptagopen', 'phptagclose', 'asptagopen', 'asptagclose', 'backslashtmp', 'scriptclose'), $str);

		// The highlight_string function requires that the text be surrounded
		// by PHP tags, which we will remove later
		$str = '<?php '.$str.' ?>'; // <?

		// All the magic happens here, baby!
		$str = highlight_string($str, TRUE);

		// Prior to PHP 5, the highligh function used icky <font> tags
		// so we'll replace them with <span> tags.

		if (abs(PHP_VERSION) < 5)
		{
			$str = str_replace(array('<font ', '</font>'), array('<span ', '</span>'), $str);
			$str = preg_replace('#color="(.*?)"#', 'style="color: \\1"', $str);
		}

		// Remove our artificially added PHP, and the syntax highlighting that came with it
		$str = preg_replace('/<span style="color: #([A-Z0-9]+)">&lt;\?php(&nbsp;| )/i', '<span style="color: #$1">', $str);
		$str = preg_replace('/(<span style="color: #[A-Z0-9]+">.*?)\?&gt;<\/span>\n<\/span>\n<\/code>/is', "$1</span>\n</span>\n</code>", $str);
		$str = preg_replace('/<span style="color: #[A-Z0-9]+"\><\/span>/i', '', $str);

		// Replace our markers back to PHP tags.
		$str = str_replace(array('phptagopen', 'phptagclose', 'asptagopen', 'asptagclose', 'backslashtmp', 'scriptclose'),
							array('&lt;?', '?&gt;', '&lt;%', '%&gt;', '\\', '&lt;/script&gt;'), $str);

		return $str;
	}	
}
// END Profiler class
/* End of file Profiles.class.PHP */