<?php
 Class Rest{
	public  function sendResponse($status = 200, $body = '',$request="", $content_type = 'application/xml')
	{
		ob_end_clean();
		$status_header = 'HTTP/1.1 ' .$status. ' ' . $this->getStatusCodeMessage($status);
		// set the status
		header($status_header);
		$fileName		=	$this->file_name.'.'.$this->http_accept;
		if($this->http_accept=='json')
		header('Content-Disposition: inline; filename='.$fileName);

		// set the content type
		header('Content-type: '.$content_type);
			// pages with body are easy
		
		if($body != '')
		{
			// send the body
			echo $body;
			exit;
		}
		// we need to create the body if none is passed 
		else
		{
			// create some body messages
			$message = '';

			// this is purely optional, but makes the pages a little nicer to read
			// for your users.  Since you won't likely send a lot of different status codes,
			// this also shouldn't be too ponderous to maintain
			switch($status)
			{
				case 401:
					$message = "'".$request."'  is required as a URL parameter; Example: /".$request." /[your ".$request." ]/";
					break;
				case 400:
					$message = " Invalid '".$request."' ";
					break;
				case 404:
					$message = 'The requested URL ' . $_SERVER['REQUEST_URI'] . ' was not found.';
					break;
				case 500:
					$message = 'The server encountered an error processing your request.';
					break;
				case 501:
					$message = "No such $request available";
					break;
				case 503:
					$message = "API access Unavailable";
					break;
				case 420:
					$message = "Your access limit is exceeded per $request";
					break;			
			}

			// this should be templatized in a real-world solution
			$body		=	'<?xml version="1.0" encoding="UTF-8"?><error><message>'.$message.'</message> <httpCode>'.$status.'</httpCode></error>';
			header("Content-Type: text/xml;charset=iso-8859-1");
echo $body;

			exit;
		}
	}
	//Fetch cache file
	function fechCacheFile() {
		$action			=	$this->action;
		$fileName		=	$this->file_name;
		$format		=	$this->http_accept;
		$apiKey			=	$this->request_apikey;
		$fileName		=   md5($fileName."_".$apiKey);
		$body="";
		$cache_filename = "./public/apicache/$action/$fileName.$format";
		 if(file_exists($cache_filename)){
		 $time_expire = time() - 15*60; // Expire Time (15 min)
		// Check file change time
		if(filectime($cache_filename) >= $time_expire) {
			 $fh = fopen($cache_filename, 'r') or die("can't open file");
			 $body = file_get_contents($cache_filename);
			// $body = mb_convert_encoding($body, 'UTF-8', mb_detect_encoding($xml, 'UTF-8, ISO-8859-1', true)); 
			 fclose($fh);
			 //header("Content-Type: text/xml;charset=iso-8859-1");
			 $this->sendResponse($status = 200, $body,'',"application/$format");
			 
		 }
		}
		return true;
	}
	//Set cache file  if data retriewed from db
	function setCacheFile($content) {
			$action			=	$this->action;
			$fileName		=	$this->file_name;
			$format			=	$this->http_accept;
		    $apiKey			=	$this->request_apikey;
			$fileName		=   md5($fileName."_".$apiKey);
			$cache_filename = "./public/apicache/$action/$fileName.$format";
			if(file_exists($cache_filename)){
				unlink($cache_filename);
			}
			$cache_filename = fopen($cache_filename, 'w') or die("can't open file");
			fwrite($cache_filename, print_r($content,true));
			fclose($cache_filename);
	
    return true;
}
	
	public  function getStatusCodeMessage($status)
	 {
		// these could be stored in a .ini file and loaded
		// via parse_ini_file()... however, this will suffice
		// for an example
		$codes = Array(
		    100 => 'Continue',
		    101 => 'Switching Protocols',
		    200 => 'OK',
		    201 => 'Created',
		    202 => 'Accepted',
		    203 => 'Non-Authoritative Information',
		    204 => 'No Content',
		    205 => 'Reset Content',
		    206 => 'Partial Content',
		    300 => 'Multiple Choices',
		    301 => 'Moved Permanently',
		    302 => 'Found',
		    303 => 'See Other',
		    304 => 'Not Modified',
		    305 => 'Use Proxy',
		    306 => '(Unused)',
		    307 => 'Temporary Redirect',
		    400 => 'Bad Request',
		    401 => 'Unauthorized',
		    402 => 'Payment Required',
		    403 => 'Forbidden',
		    404 => 'Not Found',
		    405 => 'Method Not Allowed',
		    406 => 'Not Acceptable',
		    407 => 'Proxy Authentication Required',
		    408 => 'Request Timeout',
		    409 => 'Conflict',
		    410 => 'Gone',
		    411 => 'Length Required',
		    412 => 'Precondition Failed',
		    413 => 'Request Entity Too Large',
		    414 => 'Request-URI Too Long',
		    415 => 'Unsupported Media Type',
		    416 => 'Requested Range Not Satisfiable',
		    417 => 'Expectation Failed',
		    500 => 'Internal Server Error',
		    501 => 'Not Implemented',
		    502 => 'Bad Gateway',
		    503 => 'Service Unavailable',
		    504 => 'Gateway Timeout',
		    505 => 'HTTP Version Not Supported'
		);

		return (isset($codes[$status])) ? $codes[$status] : '';
	}
}