var ObjValid = new Validation();
$.fn.validate = function (options) {
    var $this = $(this);
    var defaults = {
        form: "formNews",
        field: $this.attr("id"),
        key: "required",
        error: "Enter value",
        group: "",
        row: "",
        inline: "0"
    };
    var custom_options = $.extend(defaults, options);
    var curr_form = custom_options.form;
    var curr_field = custom_options.field;
    var curr_value = $this.val();
    var curr_key = custom_options.key;
    var curr_error = custom_options.error;
    var curr_group = custom_options.group;
    var curr_row = custom_options.row;
    var curr_inline = custom_options.inline;
    var curr_error_div = "div_err_" + curr_form + "_" + curr_field;
    var curr_error_field = "hid_err_" + curr_form + "_" + curr_field;
    var checked_count = 0;
    var checked_started = 0;
    var curr_field_class = "";
    var curr_field_name = $this.attr("name");
    if (curr_group != "" && curr_row != "") //Check whether row deleted
    {
        var is_delete_field = curr_group + '_' + curr_row + '_is_delete';        
		if ($("#" + is_delete_field).val() == '1') {
		$("#" + curr_error_field).val(0);
		return true;
		}
    }
    var curr_error_field_value = $("#" + curr_error_field).val();
    curr_value = (checked_count == 0 && checked_started > 0) ? "" : curr_value;
    curr_value = (curr_value == null) ? "" : curr_value;
    var data = validate_element(curr_form, curr_field, curr_value, curr_key, curr_error);
    if (data == "") {
        if (curr_inline == 1) {
            $("#" + curr_error_div).addClass("hide");
        }
        var curr_height = $("#" + curr_error_div).height();
        $("#" + curr_error_field).val(0);
        return true;
    } else {
        $("#" + curr_error_div).html('<span>' + data + '</span>');
        if (curr_inline == 1) {
            $("#" + curr_error_div).removeClass("hide");
        }
        $("#" + curr_error_field).val(1);
        $('#' + curr_form + '_errors').val(1);
        return false;
    }
};
$.fn.validateForm = function (options) {
    var defaults = {
        form: "formNews"
    };
    var custom_options = $.extend(defaults, options);
    var curr_form = custom_options.form;
    var curr_form_result = 0;
    var curr_field_value = "";
    $('.hid_err_' + curr_form + '_validations').each(function () {
        curr_field_value = $(this).val();
        if (parseInt(curr_field_value) == 1) {
            var curr_error_div = $(this).attr("rel");
            $("#" + curr_error_div).removeClass("hide");
        }
        if (parseInt(curr_field_value) == 1 && curr_form_result == 0) {
            curr_form_result = 1;
        }
    });
    if (curr_form_result == 0) {
        $('#' + curr_form + '_errors').val(0);
        return true;
    } else return false;
}

function substr_count(string, substring, start, length) {
    var c = 0;
    if (start) {
        string = string.substr(start);
    }
    if (length) {
        string = string.substr(0, length);
    }
    for (var i = 0; i < string.length; i++) {
        if (substring == string.substr(i, substring.length)) c++;
    }
    return c;
}

function is_string(op) {
    return typeof op == 'string';
}

function validateReset(curr_form, curr_field) {
    var dataArray = new Array();
    dataArray[0] = curr_form;
    dataArray[1] = curr_field;
    var curr_error_div = "div_err_" + curr_form + "_" + curr_field;
    var curr_error_field = "hid_err_" + curr_form + "_" + curr_field;
    $.ajax({
        url: GLOBAL_BASE_PATH + "/validate/destroy/",
        type: "POST",
        cache: false,
        async: false,
        global: false,
        data: {
            ajax_request: dataArray
        },
        success: function (data) {
            $("#" + curr_error_div).addClass("hide");
            $("#" + curr_error_field).val(0);
        }
    });
}

function validate_element(params_form_name, params_field_name, params_curr_value, sessionRuleSet, sessionErrorSet) {
    var FormsBaseSeparator = "~*";
    var FormsSubSeparator = "->";
    var fieldDetailsArray = {};
    var params_form_name = params_form_name;
    var params_field_name = params_field_name;
    var params_curr_value = $.trim(params_curr_value);
    var sessionRuleSet = sessionRuleSet;
    var sessionErrorSet = sessionErrorSet;
    var params_curr_field = params_field_name;
    fieldDetailsArray['field1'] = params_field_name;
    fieldDetailsArray['currField'] = params_field_name;
	fieldDetailsArray['currValue'] = $.getValue(params_field_name);
    fieldDetailsArray['error'] = sessionErrorSet;
    fieldDetailsArray['result'] = 0;
    var $params_curr_message = "";
    var params_curr_result = true;

    var ruleArray = (substr_count(sessionRuleSet, FormsBaseSeparator) > 0) ? sessionRuleSet.split(FormsBaseSeparator) : [""];
    var ruleConstructArray = (substr_count(sessionRuleSet, FormsSubSeparator) > 0) ? sessionRuleSet.split(FormsSubSeparator) : [""];
    if (sessionRuleSet != "") {
        if ((!$.isArray(ruleArray) || ruleArray[0] == '') && (!$.isArray(ruleConstructArray) || ruleConstructArray[0] == '')) { 
			fieldDetailsArray['value1'] = $.getValue(params_field_name);
			if (substr_count(sessionRuleSet, 'callback_')) {
                var sessionRuleSet = (sessionRuleSet).replace('callback_', '');
                if ($.isFunction(window[sessionRuleSet])) {
                    params_curr_result = window[sessionRuleSet]( fieldDetailsArray);
                } else {
                    params_curr_result = true;
                    console.warn('Custom Error Message: Callback validation function "' + sessionRuleSet + '" not found in your *.js! Form: ' + params_form_name + ' , Element: ' + params_field_name);
                }
            } else if ($.isFunction(window['ObjValid'][sessionRuleSet])) {
                params_curr_result = window['ObjValid'][sessionRuleSet]( fieldDetailsArray);
            } else {
                params_curr_result = true;
                console.warn('Custom Error Message: Function "' + sessionRuleSet + '" not found in validate plugin(validate.plugin.js)!')
            }
        } else {
            var sessionErrorSet_array = (substr_count(sessionErrorSet, FormsBaseSeparator) > 0) ? sessionErrorSet.split(FormsBaseSeparator) : sessionErrorSet;
			var condition1			= true;
            for (var validate_i = 0; validate_i < ruleArray.length; validate_i++) {
                if (condition1 && params_curr_result && !is_string(params_curr_result)) {
                    params_curr_field_array_sub = (ruleArray.length == 1) ? sessionRuleSet : ruleArray[validate_i];
                    ruleConstructArray = (substr_count(params_curr_field_array_sub, FormsSubSeparator) > 0) ? params_curr_field_array_sub.split(FormsSubSeparator) : "";

                    operandName1 = $.isArray(ruleConstructArray) ? $.trim(ruleConstructArray[0]) : params_curr_field;
					var params_curr_value_array = $.isArray(ruleConstructArray) ? $.trim($.getValue(ruleConstructArray[0])) : $.trim(params_curr_value);
                    if ($.isArray(ruleConstructArray) && (ruleConstructArray[2] != '') && ruleConstructArray[1] != 'isequal' && ruleConstructArray[1] != 'isnotequal' && ruleConstructArray[1] != 'compare' && ruleConstructArray[1] != 'value') operandName2 = $.trim(ruleConstructArray[2]);
                    else operandName2 = "";
                    operandPostDate2 = (operandName2 != "") ? $.trim($("#" + ruleConstructArray[0]).val()) : "";
                    expectedResult = (operandName2 != "") ? $.trim(ruleConstructArray[3]) : "";
                    fieldDetailsArray['field1'] = operandName1;
					fieldDetailsArray['value1'] = $.getValue(operandName1);
                    fieldDetailsArray['field2'] = operandName2;
					if(operandName2!=''){
						fieldDetailsArray['value2'] = $.getValue(operandName2);
                    	fieldDetailsArray['result'] = expectedResult;
					}
                    var sessionConstructFieldRule = $.isArray(ruleConstructArray) ? $.trim(ruleConstructArray[1]) : ruleArray[validate_i];
                    if ($.trim(sessionConstructFieldRule) == '') {
                        continue;
                    } 
					else if (sessionConstructFieldRule.toLowerCase() == "value" || sessionConstructFieldRule.toLowerCase() == "isnotequal" || sessionConstructFieldRule.toLowerCase() == "isequal") {
                        if (params_curr_value_array == $.trim(ruleConstructArray[2])) {
							if (sessionConstructFieldRule.toLowerCase() == "isequal")
								condition1			= true;
                            else if (sessionConstructFieldRule.toLowerCase() == "isnotequal")
								condition1			= false;
                            else
                                params_curr_result = true;
                        } else {
							if (sessionConstructFieldRule.toLowerCase() == "isequal")
								condition1			= false;
                            else if (sessionConstructFieldRule.toLowerCase() == "isnotequal")
								condition1			= true;
                            else
                                params_curr_result = false;
                        }
                    } else if ($.trim(sessionConstructFieldRule.toLowerCase()) != "") {
                        fieldDetailsArray['options'] = (ruleConstructArray.length) ? ruleConstructArray[2] : "";
                        if (substr_count(sessionConstructFieldRule, 'callback_')) {
                            var sessionConstructFieldRule = (sessionConstructFieldRule).replace('callback_', '');
                            if ($.isFunction(window[sessionConstructFieldRule])) {
                                params_curr_result = window[sessionConstructFieldRule]( fieldDetailsArray);
                            } else {
                                params_curr_result = true;
                                console.warn('Custom Error Message: Callback validation function "' + sessionConstructFieldRule + '" not found in your *.js! Form: ' + params_form_name + ' , Element: ' + params_field_name);

                            }
                        } else if ($.isFunction(window['ObjValid'][sessionConstructFieldRule])) {
                            params_curr_result = window['ObjValid'][sessionConstructFieldRule]( fieldDetailsArray);
                        } else {
                            params_curr_result = true;
                            console.warn('Custom Error Message: Function "' + sessionConstructFieldRule + '" not found in validate plugin!')
                        }
                    }
                    if (sessionErrorSet_array.length == 1) {
                        var sessionErrorSet_array_curr = fieldDetailsArray['error'];
                    } else {
                        var sessionErrorSet_array_curr = ($.isArray(sessionErrorSet_array)) ? sessionErrorSet_array[validate_i] : sessionErrorSet_array;
                    }
                    sessionErrorSet = (params_curr_result == "") ? sessionErrorSet_array_curr : params_curr_result;
                }
            }
        }
    }
    if (!params_curr_result || is_string(params_curr_result)) {
        $params_curr_message = (params_curr_result == "") ? sessionErrorSet : params_curr_result;
        $params_curr_message = ($params_curr_message == "") ? +"Error found in form element '" + fieldDetailsArray : $params_curr_message;
    }
    return $params_curr_message;
}

function Validation() {
    this.required = function (params) {
        var form_fields_value = params['value1'];
        if ($.trim(form_fields_value) == "") {
            return false;
        } else {
            return true;
        }
    }

 this.compare = function (params) {
        var form_fields_value = params['value1'];
		var currValue = params['currValue'];
        if (currValue == form_fields_value) {
            return true;
        } else {
            return false;
        }
    }
    this.email = function (params) {
        var form_fields_value = params['value1'];
        var reg = /^[A-Z0-9._%+-]+@(?:[A-Z0-9-]+\.)+[A-Z]{2,4}$/i;
        if ((form_fields_value == "") || reg.test(form_fields_value)) {
            return true;
        } else {
            return false;
        }
    }

    this.isMultipleEmail = function (params) {
        var value = params['value1'];
        var emails = value.split(/[,]+/);
        var valid = true;
        var reg = /^[A-Z0-9._%+-]+@(?:[A-Z0-9-]+\.)+[A-Z]{2,4}$/i;
        for (var i in emails) {
            singleEmail = emails[i];
            if ((singleEmail == "") || reg.test(singleEmail)) isValidSingleEmail = true
            else isValidSingleEmail = false
            valid = valid && isValidSingleEmail;
        }
        return valid;
    }
    this.isDuplicateEmail = function (params) {
        var value = params['value1'];
        var emails = value.split(/[,]+/);
		var prevEmails =emails.length;
		var emails = $.unique(emails);
		if(emails.length == prevEmails)	{
			return true;
		} else {
            return false;
        }
    }
    this.isUrl = function (params) {
        var value = params['value1'];
        var regex = /(?:(?:https?|ftp):\/\/|www\.)[a-z0-9-+&@#\/%?=~_|!:,.;]+(\.[\w\_]+)[a-z0-9+&@#\/%=~_|]/;
        return value == "" || regex.test(value);
    }

    this.isLoginName = function (params) {
        var value = params['value1'];
		if(value=='') return false;
        var regexp1 = /^[^0-9][A-z0-9_]+([.][A-z0-9_]+)*[@][A-z0-9_]+([.][A-z0-9_]+)*[.][A-z]{2,4}$/;
        var regexp2 = /^[a-zA-Z\d_.]{5,20}$/;
        return value == "" || regexp1.test(value) || regexp2.test(value);
    }

    this.isPassword = function (params) {
        var value = params['value1'];
        var regex = /^.*(?=.{8,})(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).*$/;
        return value == "" || regex.test(value);
    }

    this.isPrice = function (params) {
        var value =params['value1'];
        var value = (value.substring(0, 1) == ".") ? "0" + value : value;
        var regex = /^\d+(\.\d{1,5})?$/;
        return value == "" || regex.test(value);
    }

    this.isPhone = function (params) {
        var value = params['value1'];
        return value == "" || !isNaN(value) && (value.length == 10 || value.length == 12);
    }

    this.isKey = function (params) {
        var value = params['value1'];
        var regex = /^[a-zA-Z0-9_\-]+$/;
        return value == "" || regex.test(value);
    }

    this.isUrlKey = function (params) {
        var value = params['value1'];
        var sysKeysArr = sysKeys.split(',');
        if($.inArray(value,sysKeysArr)>=0)
            return false;
        var regex = /^[a-zA-Z0-9.\-\_]+$/;
        return value == "" || regex.test(value);
    }
	
	this.isCityKey = function (params) {
        var value = params['value1'];
        var regex = /^[a-zA-Z0-9\-]+$/;
        return value == "" || regex.test(value);
    }

    this.isFloat = function (params) {
        var value = params['value1'];
        var regex = /^[-+]?[0-9]*\.?[0-9]+$/;
        return value == "" || regex.test(value);
    }
	this.isPositiveFloat = function (params) {
        var value = params['value1'];
        var regex = /^[-+]?[0-9]*\.?[0-9]+$/;
        return value == "" || regex.test(value);
    }
    this.isNumber = function (params) {
        var value = params['value1'];
        return value == "" || (!isNaN(parseFloat(value)) && isFinite(value));
    }

    this.isInteger = function (params) {
        var value = params['value1'];
        var integerRegex = /^\-?[0-9]+$/;
        return value == "" || (integerRegex.test(value));
    }

    this.isWholeNumber = function (params) {
        var value = params['value1'];
        var wholeNumberRegex = /^[0-9]+$/i;
        return value == "" || (wholeNumberRegex.test(value));
    }

    this.isWholeNumberWithZero = function (params) {
        var value = params['value1'];
        var wholeNumberRegex = /^[0-9]+$/i;
        return value == "" || (wholeNumberRegex.test(value));
    }

    this.isWholeNumberWithOutZero = function (params) {
        var value = params['value1'];
        var wholeNumberNonZeroRegex = /^[1-9][0-9]*$/i;
        return value == "" || (wholeNumberNonZeroRegex.test(value));
    }

    this.isPercentage = function (params) {
        var value = params['value1'];
        var regex = /^\d{0,2}(\.\d{0,2})?$|^100(\.0{1,2})?$/;
        return regex.test(value);
    }

    this.isAlphaNumeric = function (params) {
        var value = params['value1'];
        var regex = /^[a-zA-Z0-9]+$/;
        return value == "" || regex.test(value);
    }

	this.isAlpha = function (params) {
        var value = params['value1'];
        var regex = /^[a-zA-Z]+$/;
        return value == "" || regex.test(value);
    }
	
    this.isAlpha2 = function (params) {
        var value = params['value1'];
        var regex = /^[a-zA-Z]{2}$/;
        return value == "" || regex.test(value);
    }

    this.isAlpha3 = function (params) {
        var value = params['value1'];
        var regex = /^[a-zA-Z]{3}$/;
        return value == "" || regex.test(value);
    }

    this.isAlphaCapsNumeric = function (params) {
        var value = params['value1'];
        var regex = /^[A-Z0-9]+$/;
        return value == "" || regex.test(value);
    }
	this.isAlphaNumericWithSpace = function (params) {
        var value = params['value1'];
        var regex = /^[ a-zA-Z0-9]+$/;
        return value == "" || regex.test(value);
    }
    this.isLCIDString = function (params) {
        var value = params['value1'];
        var regex = /^[a-zA-Z0-9-]+$/;
        return value == "" || regex.test(value);
    }

    this.isCurrency = function (params) {
        var value = params['value1'];
        var regex = /^\d+(\.\d{1,5})?$/;
        return value == "" || regex.test(value);
    }

    this.isTag = function (params) {
        var value = params['value1'];
        var regex = /([\<])([^\>]{1,})*([\>])/i;
        return value == "" || !regex.test(value);
    }

    this.isISO = function (params) {
        var value = params['value1'];
        var regex = /^[0-9]{0,4}$/;
        return value == "" || regex.test(value);
    }

    this.isZipCode = function (params) {
        var value = params['value1'];
        var regex = /^[a-zA-Z\d]+(([\- ][a-zA-Z\d ])?[a-zA-Z\d]*)*[a-zA-Z\d]{1}$/;
        return value == "" || regex.test(value);
    }

    this.isNumberLimit = function (params) {
        var value = params['value1'];
        var form_fields_options = params['options'].split(",");
        var from_number = parseInt(form_fields_options[0]);
        var to_number = parseInt(form_fields_options[1]);
        if ((isNaN(from_number)) || (isNaN(to_number))) {
            return false;
        }
        if ((from_number && to_number && value >= from_number && value <= to_number) || (!from_number && to_number && value <= to_number) || (!to_number && from_number && value >= from_number) || value == '') {
            return true;
        } else {
            return false;
        }
    }
	
	this.isFileType = function (params) {
        var value = params['value1'];
		if(value!='')
		{
			var form_fields_options = params['options'].split(",");
			var value_extention 	= (((value.split(".")).reverse())[0]).toLowerCase();
			if($.inArray(value_extention,form_fields_options)>=0)
			return true;
			else
			return false;
		}
		return true;	
    }
	
	this.isFloatWithoutZero = function (params) {
        var value = params['value1'];
        var regex = (/(^\d+$)|(^\d+.\d+$)|[,.]/);
        return value == "" || (regex.test(value) && value>=1) ;
    }
     this.isValidSuffix = function (params) {
        var value = params['value1'];
        var regex = /^\.[a-z]+$/;
        return value == "" || regex.test(value);
    }
    this.isRequestPath = function (params) {
        var value = params['value1'];
       
        if(value.substring(value.length-1, value.length)==="/"){
        var value=value.substring(0, value.length-1);
        }
        var sysKeysArr = sysKeys.split(',');
        var length = sysKeysArr.length
        for (var i = 0; i < length; i++) {
          element = sysKeysArr[i];
          if(substr_count(value, element+'/') > 0)
            return false;
        }
      //  if($.inArray(value,sysKeysArr)>=0)
       //     return false;
        var regex = /^[a-zA-Z0-9.\-\_/]+$/;
        return value == "" || regex.test(value);
    }
    /* ==================== New  Binary Operators with result checking ======================== */
    this.eq = function (params) {
        var value1 = params['value1'];
        var value2 = params['value2'];
        if (value1 == "" && value2 == "") return true;
        value1 = parseFloat(value1);
        value2 = parseFloat(value2);
        return value1 == value2;
    }

    this.neq = function (params) {
        var value1 = params['value1'];
        var value2 = params['value2'];
        if (value1 == "" && value2 == "") return true;
        value1 = parseFloat(value1);
        value2 = parseFloat(value2);
        return value1 != value2;
    }

    this.gt = function (params) {
        var value1 = params['value1'];
        var value2 = params['value2'];
        if (value1 == "" && value2 == "") return true;
        value1 = parseFloat(value1);
        value2 = parseFloat(value2);
        return value1 > value2;
    }

    this.gteq = function (params) {
        var value1 = params['value1'];
        var value2 = params['value2'];
        if (value1 == "" && value2 == "") return true;
        value1 = parseFloat(value1);
        value2 = parseFloat(value2);
        return value1 >= value2;
    }

    this.lt = function (params) {
        var value1 = params['value1'];
        var value2 = params['value2'];
        if (value1 == "" && value2 == "") return true;
        value1 = parseFloat(value1);
        value2 = parseFloat(value2);
        return value1 < value2;
    }

    this.lteq = function (params) {
        var value1 = params['value1'];
        var value2 = params['value2'];
        if (value1 == "" && value2 == "") return true;
        value1 = parseFloat(value1);
        value2 = parseFloat(value2);
        return value1 <= value2;
    }

    /* ==================== New  Binary Operators with result checking ======================== */
    this.plus = function (params) {
        var value1 = params['value1'];
        var value2 = params['value2'];
        if (value1 == "" && value2 == "") return true;
        value1 = parseFloat(value1);
        value2 = parseFloat(value2);
        var expectedResult = parseFloat(params['result']);
        var result = value1 + value2;
        return result == expectedResult;
    }

    this.minus = function (params) {
        var value1 = params['value1'];
        var value2 = params['value2'];
        if (value1 == "" && value2 == "") return true;
        value1 = parseFloat(value1);
        value2 = parseFloat(value2);
        var expectedResult = parseFloat(params['result']);
        var result = value1 - value2;
        return result == expectedResult;
    }

    this.multiply = function (params) {
        var value1 = params['value1'];
        var value2 = params['value2'];
        if (value1 == "" && value2 == "") return true;
        value1 = parseFloat(value1);
        value2 = parseFloat(value2);
        var expectedResult = parseFloat(params['result']);
        var result = value1 * value2;
        return result == expectedResult;
    }

    this.divide = function (params) {
        var value1 = params['value1'];
        var value2 = params['value2'];
        if (value1 == "" && value2 == "") return true;
        value1 = parseFloat(value1);
        value2 = parseFloat(value2);
        var expectedResult = parseFloat(params['result']);
        if (value2 != 0) {
            var result = value1 / value2;
        } else {
            result = 0;
        }
        return result == expectedResult;
    }

    this.mod = function (params) {
        var value1 = params['value1'];
        var value2 = params['value2'];
        if (value1 == "" && value2 == "") return true;
        value1 = parseFloat(value1);
        value2 = parseFloat(value2);
        var expectedResult = parseFloat(params['result']);
        var result = value1 % value2;
        return result == expectedResult;
    }		
}
$.extend({
	getValue:function(objDiv){	    
		var objDiv =  objDiv.replace(/([ #;&,.+*~\':"!^$[\]()=>|\/@])/g,'\\$1') ;
		var objName=$("#"+objDiv).prop('name');
		switch($("[name='"+objName+"']").prop('type')){
			case 'radio':
				return $("[name='"+objName+"']:checked").val();
				break;
			case 'checkbox':
				return $("[name='"+objName+"']:checked").length>0?1:'';
				break;	
			case 'text':
			case 'select':
			case 'file':
			case 'select-one':
			case 'password':
			case 'hidden':
					return $("#"+objDiv).val();
					break;
			case 'textarea':			
					if($('#'+objDiv).hasClass('ckeditor')){ if(CKEDITOR.instances[objDiv].getData()!='')
							return CKEDITOR.instances[objDiv].getData();
					}else{
						return $("#"+objDiv).val();
					}
					break;
			default:
				if($("[name='"+objName+"[]']").prop('type')=='checkbox'){
					return ($("[name='"+objName+"[]']:checked").length>0)?1:'';
				}
				else if($("[name='"+objName+"[]']").prop('type')=='select-multiple'){
					return ($("[name='"+objName+"[]']").val().length>0)?1:'';
				}
				else{
					return $("#"+objDiv).val();
				}
		}
	},
	scrollToDiv:function(className){
			if($(className+"[value=1]").length>0 && typeof NO_VALIDATION_SCROLL=='undefined'){
					var scrollTop=$(className+"[value=1]:first").closest('div:visible').position().top;
			 $('html,body').animate({scrollTop:scrollTop},'slow');	
			 return false;
		}
		else{
			return true;
		}
	}
});
(function($) {
	$.extend($.fn, {
		bindLast: function(event, cbFunc){
			return this.each(function(){
				var highIndex = 200;
				var eventData = event.split('.');
				var eventName = eventData[0];
				$(this).bind(event, cbFunc);
				var events = $._data(this,'events'),
					ourIndex = false,
					usedIndicies = {};
				$.each(events[eventName], function(index, func){
					if(func.handler === cbFunc){
						ourIndex = index;
					}
					usedIndicies[index] = 1;
				});
				if(ourIndex !== false){
					while(usedIndicies[highIndex] == 1){
						highIndex++;
					}
					events[eventName][highIndex] = events[eventName][ourIndex];
					$(this).data('events', events);
				}
			});
		}
	});
})(jQuery);

(function($) {
	$.extend($.fn, {
		bindFirst: function(type, fn){
			type = type.split(/\s+/);
			this.each(function() {
				var len = type.length;
				while( len-- ) {
					$(this).bind(type[len], fn);
					var evt = $._data(this, 'events')[type[len]];
					evt.splice(0, 0, evt.pop());
				}
			});
		}
	});
})(jQuery);

