$(document).ready(function(){
	makeSortable();
	function makeSortable(){
	$( '#sort1.connectedSortable,#sort1 .connectedSortable' ).sortable({
			connectWith: ".connectedSortable",
			placeholder: "dd-placeholder",
			cursor: "move",
			helper:"clone",
			update:function(event,ui){
				var uiItem					=	ui.item;
				var closestLi				=	uiItem.parent().closest('li');
				var closestLiLang			=	closestLi.data('lang');
				if((closestLiLang!=null)){
					var closestLiLanguages 	= 	closestLiLang.toString().split(",");
					var uiLanguages			=	uiItem.data('lang').toString().split(",");
				}
				else{
					var closestLiLanguages	=	[];
					var uiLanguages			=	[];
				}
				if($.intersect(closestLiLanguages,uiLanguages).length == uiLanguages.length || closestLiLang==null || closestLiLang=='0'){
					$("#sort1 li").each(function(){
						var obj=$(this);
						var ulCount=obj.find('ul').length;
						var liCount=obj.find('li').not('.addNew').length;
						if(!obj.hasClass('addNew')){
							var level=parseInt(obj.parents('ul').length)-1;
							obj.attr('data-level',level);
						}
						if(!ulCount  && (obj.attr('data-modulekey') != 'seperator') ){
							obj.append(' <ul class="connectedSortable  addOn"><li class="addNew"></li></ul>');
						}
						else{
							obj.find('.addNew').remove();
						}
						if(liCount>0){
							obj.find('.expand').removeClass('hide');
						}
						else{
							obj.find('.expand').addClass('hide');
						}
					});
					$("#sort1 li .addOn").each(function(){
						if($.trim($(this).html())==''){
							$(this).html('<li class="addNew"></li>');
						}
					});
				}
				
				closestLi.find('.expand:first').addClass('minus').text("-");
				makeSortable();
			},
			over:function(event,ui){
				var currheight=ui.helper.css('height');
				$('.dd-placeholder').css('height',currheight);
			},
			receive:function(event,ui){
				var uiItem					=	ui.item;
				var closestLi				=	uiItem.parent().closest('li');
				var closestLiLang			=	closestLi.data('lang');
				if((closestLiLang!=null)){
					var closestLiLanguages 	= 	closestLiLang.toString().split(",");
					var uiLanguages			=	uiItem.data('lang').toString().split(",");
				}
				else{
					var closestLiLanguages	=	[];
					var uiLanguages			=	[];
				}
				$('#sort1').css('min-height',(parseInt($('#sort1').css('height'))+12.5)+"px");
				uiItem.find('.changeItemStatus').remove();
				uiItem.find('.edit00').remove();
				if($.intersect(closestLiLanguages,uiLanguages).length != uiLanguages.length && closestLiLang!=null && closestLiLang!='0'){
					$(ui.sender).sortable( "option", "revert", false );
					jNotifyShow(languageMismatchRollback, "common_message","message_info");
				} 
			},
			beforeStop:function(event,ui){
				var uiItem				=	ui.item;
				var closestLi			=	uiItem.parent().closest('li');
				var closestLiLang		=	closestLi.data('lang');
				if((closestLiLang!=null)){
					var closestLiLanguages 	= 	closestLiLang.toString().split(",");
					var uiLanguages			=	uiItem.data('lang').toString().split(",");
				}
				else{
					var closestLiLanguages	=	[];
					var uiLanguages			=	[];
				}
				if($.intersect(closestLiLanguages,uiLanguages).length != uiLanguages.length && closestLiLang!=null && closestLiLang!='0'){
					if($.inArray("sort2",$.makeArray(ui.helper.parents('ul').attr('id')))>=0){
						uiItem.remove();
						jNotifyShow(languageMismatch, "common_message","message_info");
					}
				}
				
			},
			stop:function(event,ui){
				var uiItem				=	ui.item;
				var closestLi			=	uiItem.parent().closest('li');
				var closestLiLang		=	closestLi.data('lang');
				if((closestLiLang!=null)){
					var closestLiLanguages 	= 	closestLiLang.toString().split(",");
					var uiLanguages			=	uiItem.data('lang').toString().split(",");
				}
				else{
					var closestLiLanguages	=	[];
					var uiLanguages			=	[];
				}
				if($.intersect(closestLiLanguages,uiLanguages).length != uiLanguages.length && closestLiLang!=null && closestLiLang!='0'){
					$(this).sortable('cancel');
				}
			}
		}).disableSelection();
	}
	
	$("#sort2.connectedSortable li,#sort2 .connectedSortable li").draggable({
		connectToSortable: "#sort1.connectedSortable",
		helper: function(){
			return $(this).clone();
		}
	})
	$('#sort1').css('min-height',(parseInt($('#sort1').css('height'))+25)+"px");
	$("#sort1 li:not([data-modulekey='seperator'])").each(function(){
		if(!$(this).find('ul').length){
			$(this).append(' <ul class="connectedSortable  addOn"><li class="addNew"></li></ul>');
		}
		makeSortable();
	});
	$( '#sort1.connectedSortable li,#sort1 .connectedSortable li' ).each(function(){
			var key=parseInt($(this).parents('ul').length);
			$(this).find('.chk-bx').css('left',key*(-25)+"px");
		});
	
	$(document).on('click',"#sort1 .delete00",function(){
		if(!$(this).hasClass('noremove')) {
		var height=$(this).closest('li').css('height');
		$('#sort1').css('min-height',(parseInt($('#sort1').css('height'))-parseInt(height))+"px");
		$(this).closest('li').remove();
		$("#sort1 li").each(function(){
					var obj=$(this);
					var ulCount=obj.find('ul').length;
					var liCount=obj.find('li').not('.addNew').length;
					
					if(!ulCount && (obj.attr('data-modulekey') != 'seperator') ){
						obj.append(' <ul class="connectedSortable  addOn"><li class="addNew"></li></ul>');
					}
					else{
						obj.find('.addNew').remove();
					}
					
					if(liCount>0){
						obj.find('.expand').removeClass('hide');
					}
					else{
						obj.find('.expand').addClass('hide');
					}
				});
				$("#sort1 li .addOn").each(function(){
					if($.trim($(this).html())==''){
						$(this).html('<li class="addNew"></li>');
					}
				});
		}
				makeSortable();
	});
	$(document).on('click',".expand",function(){
		
		if($(this).hasClass('minus')){
			$(this).closest('.group').siblings('ul').addClass('hide');
			$(this).toggleClass('minus').text('+');
		}
		else{
			$(this).closest('.group').siblings('ul').removeClass('hide');
			$(this).toggleClass('minus').text('-');;
		}
	makeSortable();
	});
	
});

function parseTree(ul,val,preKey){
	var tags = [];
	ul.children("li").each(function(key,value){
		if(!$(this).hasClass('addNew')){
		var subtree =	$(this).children("ul");
		if(subtree.size() > 0){
			var obj		=	{};
			obj.id		=	$(this).data("id");
			if(typeof $(this).data("orderid")!='undefined')
				obj.orderID	=	$(this).data("orderid");
			else
				obj.orderID	=	'';
			if(typeof $(this).data("level")!='undefined')
				obj.level	=	$(this).data("level");
			else
				obj.level	=	'';
			var count = parseTree(subtree,++val,key);
			if(count.length != 0)
				tags.push([obj, count]);
			else tags.push([obj]);
		}
		else{
			var obj		=	{};
			obj.id		=	$(this).data("id");
			if(typeof $(this).data("orderid")!='undefined')
				obj.orderID	=	$(this).data("orderid");
			else
				obj.orderID	=	'';
			if(typeof $(this).data("level")!='undefined')
				obj.level	=	$(this).data("level");
			else
				obj.level	=	'';
			tags.push([obj]);
		}
		}
	});
	return tags;
}