<?php 

class Cache
{

	private static $_options;
	public  static $_instance;
		 		
	public function __construct($options=null)
	{
		self::connect();
	}
	
	public static function getInstance($options=null)
    {
		if(!(self::$_instance instanceof self))
		{
            self::$_instance	= new self($options);
			self::$_instance->connect();
        }
        return self::$_instance;
    }	
	
	public function connect()
	{   
		$ObjConfig 		= Registry::getInstance('Config');
		$this->memcache	= new Memcache();
		$this->memcache->connect($ObjConfig->cache_host, $ObjConfig->cache_port);
	} 
	
	public function close()	
	{		
		$this->memcache->close();				
	} 
	
	public function clear()	
	{		
		$this->memcache->flush();				
	} 
	
	public function set($key, $val, $compress=false, $expire)
	{
		$cacheStatus	= $this->memcache->set($key, $val, $compress, $expire);
		return $cacheStatus;
	} 
	
	public function get($key)
	{
		$cacheResult	= $this->memcache->get($key);
		return $cacheResult;
	}
	
	public function delete($key)
	{
		$this->memcache->delete($key);
	}

} 