<?php 

class Database
{
	private $mysqli; 
	public	$ErrorInfo;
	private static $_options;
	public  static $_instance;
	public  static $queries		= array();
	public  static $query_times	= array();
		 		
	public function __construct($options=null)
	{
		self::dbConnect();
	}
	
	public static function getInstance($options=null)
    {
		if( ! (self::$_instance instanceof self) ) {
            self::$_instance = new self($options);
			self::$_instance->dbConnect();
        }
        return self::$_instance;
    }	
		
	public function dbConnect()
	{   
		$ObjConfig = Registry::getInstance('Config');
		$this->mysqli 	= 	new mysqli($ObjConfig->db_host, $ObjConfig->db_user, $ObjConfig->db_password, $ObjConfig->db_name);
		if(!$this->mysqli) { 
			$this->ErrorInfo	=	mysqli_connect_error();
			return FALSE;
		} else {
			$this->mysqli->set_charset("utf8");
			return TRUE;
		}
	} 
	
	public function dbClose()	
	{		
		$this->mysqli->close();				
	} 
	
	public function setQuery($Query,$aggregate=true)
	{
		$ExecStatus		=	$this->runQuery($Query,$aggregate);
		if($ExecStatus	===	FALSE) 
		{
			$this->ErrorInfo	=	$this->mysqli->error;
			$this->showError($this->ErrorInfo,$Query);
			return FALSE;
		} 
		else 
		{
			return $ExecStatus;
		} 
	} 
		
	public function numberOfRecords($Query)
	{
		$RowCount	=	0;
		$ResultSet	=	$this->runQuery($Query);
		if($ResultSet) {
			$RowCount	=	 $ResultSet->num_rows;
			$ResultSet	->	free();
			return $RowCount;
		} 
		else 
		{
			$this->ErrorInfo	=	$this->mysqli->error;
			$this->showError($this->ErrorInfo,$Query);
			return $RowCount;
		}
	} 
	
	public function readValues($Query,$ResultType=MYSQL_BOTH)
	{
		$ResultData		=	array();
		$ResultSet		=	$this->runQuery($Query);
		if($ResultSet) {
			$RowCount		=	$ResultSet->num_rows;
			for($i=0; $i<$RowCount; $i++)
				$ResultData[$i]	=	$ResultSet->fetch_array($ResultType); 	
			$ResultSet	->	free();
			return $ResultData;
		} 
		else 
		{
			$this->ErrorInfo	=	$this->mysqli->error;
			$this->showError($this->ErrorInfo,$Query);
			return $ResultData;
		}	
	}
	
	public function readValue($Query,$ResultType=MYSQL_BOTH)
	{
		$ResultData		=	array();
		$ResultSet		=	$this->runQuery($Query);
		
		if($ResultSet) {
			$ResultData[0]	=	$ResultSet->fetch_array($ResultType); 	
			$ResultSet	->	free();
			return $ResultData[0];
		} 
		else 
		{
			$this->ErrorInfo	=	$this->mysqli->error;
			$this->showError($this->ErrorInfo,$Query);
			return $ResultData;
		}		
	} 
	public function readValuesObject($Query,$ResultType=MYSQL_BOTH)
	{
		$ResultData		=	array();
		$ResultSet		=	$this->runQuery($Query);
		if($ResultSet) 
		{
			return $ResultSet;
		} else {
			$this->ErrorInfo	=	$this->mysqli->error;
			$this->showError($this->ErrorInfo,$Query);
			return $ResultData;
		}	
	}
	
	public function getInsertId()
	{
		return $this->mysqli->insert_id;
	}
	
	
	public function readField($Query)
	{
		$ResultData		=	array();
		$ResultSet		=	$this->runQuery($Query);
		
		if($ResultSet) {
			$ResultData[0]	=	$ResultSet->fetch_array(); 	
			$ResultSet	->	free();
			return $ResultData[0];
		} else {
			$this->ErrorInfo	=	$this->mysqli->error;
			return $ResultData;
		}		
	} 

	public function execProc($qry)
	{
		$result	= array();
		$result = $this->runQuery($qry);
		if($result) {
			$row = $result->fetch_array();
			return $row;
			$result->free();
		} else { 
			$this->ErrorInfo	=	$this->mysqli->error;
			return $result;
		}
	}
	
	public function execProcOne($qry)
	{
		$result	= array();
		$res	= array();
		$result = $this->runQuery($qry);
		if($result) {
			while ($row = $result->fetch_array()) {
				$res[]	= $row;
			}
			return $res;
			$result->free();
		} else { 
			$this->ErrorInfo	=	$this->mysqli->error;
			return $result;
		}
	}
	
	public function setProc($Query)
	{
		$ExecStatus		=	$this->runQuery($Query);
		if($ExecStatus	===	FALSE) 
		{
			$this->ErrorInfo	=	$this->mysqli->error;
			return FALSE;
		} else {
			return $ExecStatus;
		} 
	}
	public function getRecordCount($rs)
	{
		if($rs && $rs->num_rows>0)	{
			$result_count	=	 $rs->num_rows;
		} else {
			$result_count	=	0;
		}
		return $result_count;
	}
	
	public function getRecordMaxCount()
	{
		$ExecMaxLimit		=	$this->readValue("SELECT FOUND_ROWS()");
		return $ExecMaxLimit[0];
	}
	
	public function checkExist($tableName,$fieldName,$fieldValue,$customQuery='')
	{
	    $Query		=	"SELECT count(*) as cnt FROM ".DB_PREFIX.$tableName." WHERE $fieldName='".$this->escape($fieldValue)."'";
		if($customQuery!="") {
				$Query   .=	" AND ".$customQuery;
		}
	   	$ResultData	=	$this->readValue($Query);
		   if($ResultData['cnt']>0) {
		   		return  "YES";
		   } else {
		   		return  "NO";
		   }
	 }
	 
	public function escape($valueString)
	{
		return  $this->mysqli->real_escape_string(trim(stripslashes($valueString)));
		//return  $this->mysqli->real_escape_string(trim($valueString));
	}
	public function showError($ErrorInfo,$Query)
	{
		if(DEVELOPER_MODE == TRUE && $ErrorInfo)
		{
			echo ' <br><div style="background-color:#f2201e;position:fixed;z-index:100;"> MYSQL ERROR : '.$ErrorInfo.' <br>Query : '.$Query.'<br></div><br>';
		} 
	}
	
	public function runQuery($query,$aggregate=true)
	{
		if(DEVELOPER_MODE == TRUE)
		{
			// Start the Query Timer
			$time_start = list($sm, $ss) = explode(' ', microtime());
			$result  =$this->mysqli->query($query);	
			// Stop and aggregate the query time results
			if($aggregate)
			{
				$time_end = list($em, $es) = explode(' ', microtime());
				$query_times = ($em + $es) - ($sm + $ss);
				$this->queries[]			= $query.$this->get_callstack();
				$this->query_times[]		= number_format($query_times,6);
			}	
       	}
		else
		{
			$result  =$this->mysqli->query($query);
		}		
		return $result;
	}
	public function get_callstack()
	{
		$dt = debug_backtrace();
		$cs = "\n/*\n";
		foreach ($dt as $t) {
			if(strpos($t['file'],'application/core/')) {
				$file	= substr($t['file'],strpos($t['file'],'application/core/')+17,strlen($t['file']));
				$cs .=  $file. ' line ' . $t['line'] . ' function ' . $t['function'] . "()\n";
			}
		}
		$cs .= "*/";
		return $cs;
	}	
	//Set Auto Commit
	public function setAutoCommit($mode=true)
	{
		$this->mysqli->autocommit($mode);	
	}
	//Commit Changes
	public function commit()
	{
		return $this->mysqli->commit();
	}
	//Rollback
	public function rollback()
	{
		return $this->mysqli->rollback();
	}
	//New FUNCTIONS
	/**
	* Execute Multi query
	*/
	public function setMultiQuery($Query)
	{
		if(DEVELOPER_MODE == TRUE)
		{
			// Start the Query Timer
			$time_start = list($sm, $ss) = explode(' ', microtime());
			$result  =$this->mysqli->multi_query($query);	
			// Stop and aggregate the query time results
			$time_end = list($em, $es) = explode(' ', microtime());
			$query_times = ($em + $es) - ($sm + $ss);
			$this->queries[]			= $query.$this->get_callstack();
			$this->query_times[]		= number_format($query_times,6);
       	}
		else
		{
			$result  =$this->mysqli->multi_query($query);	
		}		
		return $result;
	}
	public function getField($query)
	{
		$resultData		=	array();
		$resultSet		=	$this->runQuery($query);
		if($resultSet)
		$resultData 	= $resultSet->fetch_row();
		return (isset($resultData) && is_array($resultData)) ? $resultData[0] : NULL;
	}
	/**
	 * Execute query and format result as set of first column from all rows
	 * @return array structured data
	 */
	public function getFields($query)
	{
		$resultData		=	array();
		$resultSet		=	$this->runQuery($query);		
		if($resultSet) {
			while ($arr = $resultSet->fetch_array(MYSQLI_NUM)) {
				$resultData[] = $arr[0];
			}
			$resultSet	->	free();
		} 	
		return $resultData;
	}
	/**
	 * Execute query and format result as associative array with column names as keys and index as defined field
	 * @return array structured data
	 */
	public function getHashArray($query, $field)
	{		
		$resultData		=	array();
		$resultSet		=	$this->runQuery($query);
		if($resultSet) {
			while ($arr = $resultSet->fetch_array(MYSQLI_ASSOC)) {
				if (isset($arr[$field])) {
					$resultData[$arr[$field]] = $arr;
				}	
			}
			$resultSet	->	free();
		} 	
		return $resultData;
	}
	/**
	 * Execute query and format result as one of: field => array(field2 => value), field => array(field2 => row_data), field => array([n] => row_data)
	 *
	 * @param string $query unparsed query
	 * @param array $params array with 3 elements (field, field2, value)
	 * @return array structured data
	 */
	public function getHashMultiArray($query, $params)
	{
		@list($field, $field2, $value) = $params;		
		$resultData		=	array();
		$resultSet		=	$this->runQuery($query);
		if($resultSet) {
			while ($arr = $resultSet->fetch_array(MYSQLI_ASSOC)) {
				if (!empty($field2)) {
					$resultData[$arr[$field]][$arr[$field2]] = !empty($value) ? $arr[$value] : $arr;
				} else {
					$resultData[$arr[$field]][] = $arr;
				}
			}
			$resultSet	->	free();
		} 	
		return $resultData;
	}
	/**
	 * Execute query and format result as key => value array
	 *
	 * @param string $query unparsed query
	 * @param array $params array with 2 elements (key, value)
	 * @return array structured data
	 */
	public function getHashSingleArray($query, $params)
	{
		@list($key, $value) = $params;
		$resultData		=	array();
		$resultSet		=	$this->runQuery($query);
		if($resultSet) {
			while ($arr = $resultSet->fetch_array(MYSQLI_ASSOC)) {
				$resultData[$arr[$key]] = $arr[$value];
			}
			$resultSet	->	free();
		} 	
		return $resultData;
	}
}
