<?php
/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/

//
//$Id: controller.engine.php,v 1.0 2011/06/14 20:52:11
//Controller - Controller Engine for Oorjit Deal System
//

class Controller 
{
 
	public $ObjDatabase;
	public $ObjView;
	public $ObjValidate;
	public $ObjForm;
	public $load;

	//Constructor for Controller class
	public function __construct () 
	{
		$this->init();
	}

	//Initializing Object
	public function init()  
	{
	
		$this->ObjDatabase = Registry::getInstance('Database');
		$ObjSession        = new SessionHandler54($this->ObjDatabase);
		$this->ObjForm 	   = new Form();
		$this->ObjView     = new View($this->ObjForm);
		$this->load        = Registry::getInstance('Load'); // To load helpers
		$this->ObjSession  = Registry::getInstance('Session');
		$this->ObjSession  = Registry::getInstance('Session');
		$this->ObjCookie   = Registry::getInstance('Cookie');
		if(DEVELOPER_MODE == TRUE)
			$this->setDeveloperMode();		
		$this->setToolsPlugin();
		$this->ObjView->ObjCommon = $this->setCommonController();
	}

	//Setting CommonController
	public function setCommonController()  
	{
		return $this->ObjCommon	= new CommonController($this->ObjView,$this->ObjSession,$this->ObjCookie);
	}

	//To get the value of the query string from the url
	public function getRequestValue($queryStringKey=0)  
	{
		$ObjRewrite 	= Registry::getInstance('Rewrite');
		if(is_integer($queryStringKey))	
		{
			return (trim($ObjRewrite->_queryString[$queryStringKey]));
		} 
		else 
		{
			$queryStringKeyNumber = (array_search($queryStringKey, $ObjRewrite->_queryString)+1);
			return ($queryStringKeyNumber>1)?trim($ObjRewrite->_queryString[$queryStringKeyNumber]):"";
		}
	}

	//To Set the Alert message
	public function setAlert($msg,$title='Alert !')
	{  
		$messages_script 	 = $this->ObjView->getTemplateVars("messages_script");
		$messages_script 	.= "\njAlert('".$msg."','".$title."');";
		$this->ObjView->assign("messages_script",$messages_script);
	}

	//To set the info, error, success, warning and no record messages
	public function setMessage($msg_string,$div_class="message_info",$section='',$div_id='common_message')
	{
		if(substr_count($msg_string,"language.")>0) 
		{
			$msg_key_array  	= explode("language.",$msg_string);
			$msg_key		   	= $msg_key_array[1];
			$msg_string	   	= $this->getLanguageValue($msg_key);
		}
		$div_class 			= ($div_class==1 || $div_class=="info")?"message_info":$div_class;
		$div_class 			= ($div_class==2 || $div_class=="warning")?"message_warning":$div_class;
		$div_class 			= ($div_class==3 || $div_class=="success")?"message_success":$div_class;
		$div_class 			= ($div_class==4 || $div_class=="error")?"message_error":$div_class;
		$div_class 			= ($div_class==5 || $div_class=="norecord")?"message_norecord":$div_class;
		
		$messages_script 	= $this->ObjView->getTemplateVars("messages_script");
		$messages_script   .= "\njNotify('".$msg_string."', '".$div_id."','".$div_class."');";
		$_controller 		=  ($section=="")?(strtolower($this->ObjView->_controller)):$section;
		$this->ObjCookie->setCookie($_controller."_".$div_id."_class", $div_class, "", "/");
		$this->ObjCookie->setCookie($_controller."_".$div_id."_message", $msg_string, "", "/");
		$this->ObjView->assign("messages_script",$messages_script);
	}

	//To unset the message
	public function unsetMessage($section='',$div_id='common_message')
	{
		if(substr_count($msg_string,"language.")>0) 
		{
		   $msg_key_array  	= explode("language.",$msg_string);
		   $msg_key		   	= $msg_key_array[1];
		   $msg_string	   	= $this->getLanguageValue($msg_key);
		}
		$messages_script 	= $this->ObjView->assign("messages_script","");
		$_controller 		=  ($section=="")?(strtolower($this->getRequestValue(0))):$section;
		$this->ObjCookie->unsetCookie($_controller."_".$div_id."_class");
		$this->ObjCookie->unsetCookie($_controller."_".$div_id."_message");
		$this->ObjView->assign("messages_script","");
	}
	
	//To set notification messages  
	public function setNotification($msg)
	{
		$messages_script 	= $this->ObjView->getTemplateVars("messages_script");
		$messages_script   .= "\njGrowl('".$msg."','true');";
		$this->ObjView->assign("messages_script",$messages_script);
	}

	//To Redirect the url
	public function setRedirect($location_url='',$dynamic_url="Yes")
	{
		if($dynamic_url=="Yes") 
		{
			if($location_url == '')
			{
				$ObjRewrite  	= 	Registry::getInstance('Rewrite');
				$_queryString	= 	array_map(array($this, 'encodeUrlString') , $ObjRewrite->_queryString);
				$location_url   = 	implode($ObjRewrite->_queryDelimiter,$_queryString);
			}
			$location_url 		=  	$this->ObjView->_base_path.'/'.ltrim($location_url,'/');	
		} 
		header("Location:$location_url");
		exit;
	} 
   
	//To get the Language Value	   
	public function getLanguageValue($languageString)  
	{
		return $this->ObjView->_languageXML[$languageString];
	}
	
	//To get the LanguageID
	public function getLanguageID()  
	{
		return 1;
	}

	//To get the settings value  
	public function getSettingValue($keyGroupID,$keyID="")  
	{
        $_settings     = Registry::getInstance('_settings');
		$_settings[$keyGroupID] = isset($_settings[$keyGroupID]) ? $_settings[$keyGroupID]  : '';
		$_settings[$keyGroupID][$keyID] = isset($_settings[$keyGroupID][$keyID]) ? $_settings[$keyGroupID][$keyID]  : '';
        $setting_value = ((empty($keyID)) ? ($_settings[$keyGroupID]) : ($_settings[$keyGroupID][$keyID]));
        // $setting_value=utf8_decode($setting_value);
        return $setting_value;
	}
	
	//To get the previous URL
	public function getPreviousURL($historyID="")  
	{
		return $this->ObjSession->getSession('PREVIOUS_URL'.$this->ObjView->_section.$historyID);
	}
	
	//To get the referal url
	public function getRefererURL()  
	{
		$RefererPrevURL  = $this->ObjSession->getSession('REFERER_URL');
		if((isset($_POST) && $RefererPrevURL=="") || !(isset($_POST))) 
		{ 
			$ServerURL  		= (!empty($_SERVER['HTTPS'])) ? "https://".$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'] : "http://".$_SERVER['HTTP_HOST']."/";
			$RefererURL 		= $_SERVER['HTTP_REFERER'];
	    	$RefererURL 		= str_replace($ServerURL,"",$RefererURL);
			$RefererURL 		= substr($RefererURL,strpos($RefererURL,"/"));
			$RefererSessionURL  = $this->ObjSession->setSession('REFERER_URL',$RefererURL);
		} 
		else 
		{
			$RefererURL  		= $RefererPrevURL;
		}
		return $RefererURL;
	}
	
	//To get the history url   
	public function getHistoryURL($back=0)  
	{
		$BrowserHistoryURL  = $this->ObjSession->getSession($this->ObjView->_section.'COMMON_BROWSER_HISTORY_URL');
		return  $BrowserHistoryURL[$back];
	}

	//To get page settings  
	public function getPageSettings($pageKey="page",$rows_per_page=10)  
	{
		$this->ObjView->assign("paginate_rows_per_page_".$pageKey,$rows_per_page);
		$currPage		= $this->getRequestValue($pageKey);
		$currLimitFrom	= ($currPage-1)*$rows_per_page;
		$currLimitFrom	= ($currLimitFrom>0)?$currLimitFrom:0;
		$currLimitTo    =  $rows_per_page;
		return array($currLimitFrom,$rows_per_page);
	}

	//To encode Url  
	public function encodeUrlString($urlString)  
	{
		$ObjTool  					=  Registry::getInstance('Tool');
		return $encodedUrlString	=  $ObjTool->encodeUrlString($urlString);
	}

	//To decode Url  
	public function decodeUrlString($urlString)  
	{
		$ObjTool  					=  Registry::getInstance('Tool');
		return $decodedUrlString	=  $ObjTool->decodeUrlString($urlString); 
	}
  
	//To encode string  
	public function encodeString($input,$key=__ENCRYPTION_KEY)
	{
		$ObjTool  					=  Registry::getInstance('Tool');
		return $encodedString		=  $ObjTool->encodeString($input,$key);
	}
  
	//To decode string 
  	public function decodeString($input,$key=__ENCRYPTION_KEY)
  	{
		$ObjTool  					=  Registry::getInstance('Tool');
		return $decodedString		=  $ObjTool->decodeString($input,$key);
	}

	//To check is file exist  
	public function isFileExist($fileSource)
	{
		$ObjTool  					=  Registry::getInstance('Tool');
		return $decodedString		=  $ObjTool->isFileExist($fileSource);
	}

	//To set tools plugin  
	public function setToolsPlugin()
	{
		$ObjTool  					=  Registry::getInstance('Tool');
		$this->ObjView->registerPlugin("modifier","isUploaded", array($ObjTool, "isUploaded"));
	}

	//Set pages count
	public function setPagesCount($pageKey="page")  
	{
		$RecordMaxCount 		= $this->ObjDatabase->getRecordMaxCount();
		$params_limit 			=  $this->ObjView->getTemplateVars("paginate_rows_per_page_".$pageKey);
		$params_limit 			=  (empty($params_limit))?10:$params_limit; /////////////
		$params_pages 			=  floor($RecordMaxCount/$params_limit)+ (($RecordMaxCount%$params_limit>0)?1:0);
		$queryStringKeyNumber 	= (array_search($pageKey, $this->ObjView->_views_url_array)+1);
		$params_page			= ($queryStringKeyNumber>1)?trim($this->ObjView->_views_url_array[$queryStringKeyNumber]):"";
		$params_page 			=  (empty($params_page))?"1":trim($params_page);
		if($params_page>$params_pages && $params_page!=1) 
		{		
			$ObjRewrite  			=  Registry::getInstance('Rewrite');
			$_queryStringArray     =  $ObjRewrite->_queryString;   
			$_queryStringArray[$queryStringKeyNumber] = $params_pages;
			$location_url    		= implode($ObjRewrite->_queryDelimiter,$_queryStringArray);	
			if($location_url) 
			{
				$header_location	= $this->ObjView->_base_path;
				$slash_required		= 0;
				$slash_required		= (substr($header_location,strlen($header_location)-2,strlen($header_location))=="..")?1:$slash_required;
				$slash_required		= (substr($location_url,0,1)!="/")?($slash_required+1):$slash_required;
				$header_location 	= ($slash_required>0)?($header_location."/"):$header_location;
		   		$header_location   .= $location_url; 
		 	} 
			else 
			{
				$header_location	= $this->ObjView->_base_path;
				$location_url    	= implode($ObjRewrite->_queryDelimiter,$ObjRewrite->_queryString);
				$header_location    = $header_location.$ObjRewrite->_queryDelimiter.$location_url;
		 	}
			header("Location:$header_location");
			exit;
		}		
		$this->ObjView->assign("paginate_total_pages_".$pageKey,$RecordMaxCount);
		return $RecordMaxCount;
	}
	
	//function for converting to sql compactable date
	public function convertDateForSQL($date,$assignedDateformat)
  	{
		$ObjTool  				=  Registry::getInstance('Tool');
		return $returnvalue		=  $ObjTool->convertDateForSQL($date,$assignedDateformat);
  	}
	
	//set or get date when passing to url or retrieving from url for escaping from '/' in date format
	public function urlDate($date,$mode='set',$assignedDateformat)
  	{
		$ObjTool  				=  Registry::getInstance('Tool');
		return $returnvalue		=  $ObjTool->urlDate($date,$mode,$assignedDateformat);
	}
	
	public function escape($valueString,$xss_filter=TRUE) 
	{          

	if ($xss_filter == TRUE)
	{
	   $ObjXss  					=  Registry::getInstance('Xss');
	   $valueString                 =$ObjXss->xss_clean($valueString);
	}
		return $valueString;
	}

	//To decode HTML special characters  
	public function decodeSplChar($str)
	{
		$ObjTool  					=  Registry::getInstance('Tool');
		return($ObjTool->decodeSplChar($str));
	} 
	//To encode HTML special characters  
	public function encodeSplChar($str)
	{
		$ObjTool  					=  Registry::getInstance('Tool');
		return($ObjTool->encodeSplChar($str));
	} 
	// Enable developer mode section	
	public function setDeveloperMode()
	{
		$enableProfiler	= $this->getRequestValue('profiler');
		if($enableProfiler == 'enable')
		{
			Profiler::$enable_profiler = TRUE;
		}
	} 	
	public function getCurrentURL()
	{
	  $pageURL = (@$_SERVER["HTTPS"] == "on") ? "https://" : "http://";
	  $pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
	  return $pageURL;
		
	}
	public function getFile($filename,$filepath)
	{
		$fd = @fopen($filepath, 'rb');
		if ($fd) 
		{
			$fsize = filesize($filepath);
			$ftime = date('D, d M Y H:i:s T', filemtime($filepath)); // get last modified time
			header("Content-disposition: attachment; filename=\"$filename\"");
			header('Content-type: ' . $this->getMimeContentType($filepath));
			header('Last-Modified: ' . $ftime);
			header('Accept-Ranges: bytes');
			header('Content-Length: ' . $fsize);
			header('Pragma: public');
			header('Expires: 0');
			header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
			header('Cache-Control: private', false);
			header("Content-Transfer-Encoding:  binary");
			header('Connection: close');
			readfile($filepath);
		}	
	}
	private function getMimeContentType($filename, $check_by_extension = true, $not_available_result = 'application/octet-stream')
	{
		$type = '';
		if (class_exists('finfo')) 
		{
			$finfo_handler = @finfo_open(FILEINFO_MIME);
			if ($finfo_handler !== false) {
				$type = @finfo_file($finfo_handler, $filename);
				list($type) = explode(';', $type);
				@finfo_close($finfo_handler);
			}
		}

		if (empty($type) && function_exists('mime_content_type')) {
			$type = @mime_content_type($filename);
		}

		if (empty($type) && $check_by_extension && strpos($filename, '.') !== false) {
			$type = getFileType($filename, $not_available_result);
		}

		return !empty($type) ? $type : $not_available_result;
	}
	function getFileType($filename, $not_available_result = 'application/octet-stream')
	{
		$file_type = $not_available_result;

		static $types = array (
			'zip' => 'application/zip',
			'tgz' => 'application/tgz',
			'rar' => 'application/rar',

			'exe' => 'application/exe',
			'com' => 'application/com',
			'bat' => 'application/bat',

			'png' => 'image/png',
			'jpg' => 'image/jpeg',
			'jpeg' => 'jpeg',
			'gif' => 'image/gif',
			'bmp' => 'image/bmp',
			'swf' => 'application/x-shockwave-flash',

			'csv' => 'text/csv',
			'txt' => 'text/plain',
			'doc' => 'application/msword',
			'xls' => 'application/vnd.ms-excel',
			'ppt' => 'application/vnd.ms-powerpoint',
			'pdf' => 'application/pdf'
		);

		$ext = getFileExt($filename);

		if (!empty($types[$ext])) {
			$file_type = $types[$ext];
		}

		return $file_type;
	}
	function getFileExt($filename)
	{
		$i = strrpos($filename, '.');
		if ($i === false) {
			return '';
		}
		return substr($filename, $i + 1);
	}
	public function getFormattedDate($date)
	{
		$preferedDateFormat = $this->getSettingValue("site_settings", "date_format");
		switch ($preferedDateFormat) {
			case '%Y-%m-%d': {
				$returnDateFormat = 'Y-m-d';
			}
				break;
			case '%m/%d/%Y': {
				$returnDateFormat = 'm/d/Y';
			}
				break;
			case '%d-%m-%Y': {
				$returnDateFormat = 'd-m-Y';
			}
				break;
			default:
				$returnDateFormat = 'm/d/Y';
		}
		$returnValue = date($returnDateFormat, strtotime($date));
		return $returnValue;
	}
	//Retrieve Client IP Address
	public function getIpAddress()  
	{
		$ObjTool =  Registry::getInstance('Tool');
		return $ObjTool->getIpAddress(); 
	}	
	//Get File Upload Limit
	public function getFileUploadLimit()
	{
		return round((FILE_UPLOAD_LIMIT/1024000),1).'MB';
	}
	//To generate Combination Hash	
	public function makeHAsh($Str)
	{
	  $ObjTool  		=  Registry::getInstance('Tool');
	  return $hash		=  $ObjTool->makeHAsh($Str);
	}
} //End of class