<?php
/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/

//
//$Id: html.engine.php,v 1.0 2011/06/14 20:52:11
//Html - Html Engine for Oorjit Deal System
//

class Html 
{
	protected $HtmlBaseSeparator;
	protected $HtmlSubSeparator;

	public function __construct () 
	{
		$this->HtmlBaseSeparator	= "~*";
		$this->HtmlSubSeparator		= "->";
	}
  
	//GENERATE ANCHOR TAG
	public function anchor($params, $ObjView) 
	{			
		$params_exclude_keys = array('caption','href','image','alt','title','content','image_width','image_class','image_height','confirm','priv_href');
		$params_caption		 = (empty($params['caption']) && $params['caption']!="0")?"":trim($params['caption']);
		$params_href		 = (empty($params['href']))?"":trim($params['href']);
		$params_priv_href	 = (empty($params['priv_href']))?"":trim($params['priv_href']); // For Privilege
		$params_image		 = (empty($params['image']))?"":trim($params['image']);
		$params_image_width	 = (empty($params['image_width']))?"":'width="'.trim($params['image_width']).'"';
		$params_image_height = (empty($params['image_height']))?"":'height="'.trim($params['image_height']).'"';
		$params_image_class  = (empty($params['image_class']))?"":'class="'.trim($params['image_class']).'"';
		$params_alt		 	 = (empty($params['alt']))?"":trim($params['alt']);
		$params_title		 = (empty($params['title']))?$params_alt:trim($params['title']);
		$params_title		 = (empty($params_title))?'':'title="'.$params_title.'"';
		$params_content		 = (empty($params['content']))?"":trim($params['content']);
		$params_confirm		 = (empty($params['confirm']))?"":trim($params['confirm']);
		$params_confirm_head = (empty($params['confirm_head']))?"Delete":trim($params['confirm_head']);
		$params_history		 = (empty($params['history']))?"":trim($params['history']);
		$params_alert		 = (empty($params['alert']))?"":trim($params['alert']);
		$params_target		 = (empty($params['target']))?"":trim($params['target']);
		$params_href_custom	 = (empty($params['href_custom']))?"":trim($params['href_custom']);
		//For Privilege	
		$accessChecking      = true;
		//For Manage Section & Only if user type is not Administrator
		if( $ObjView->_section=='manage' && $ObjView->ObjCommon->mangeUserTypeID>1)
		{
			if(!empty($params_priv_href))
			{
				$params_priv_href_array  	= explode("/",$params_priv_href);	
				if($params_priv_href_array[0]!="")
				{
					$url						=	$params_priv_href;	
				}
				else
				{			
					$url						=	substr($params_priv_href, 1);
				}
				$accessChecking				=	$ObjView->ObjCommon->hasPrivilege($url); 
			}	
		}
		if(isset($params_href_access)) {
		$params_href_access 		= trim($params_href_access,"/");
		$params_href_access 		= "/".$params_href_access."/";
		
		}
		$params_image				= (empty($params_image))?"":'<img src="'.$params_image.'" '.$params_image_class.'  '.$params_image_width.' '.$params_image_height.' alt="'.$params_alt.'" '.$params_title.' />';
		list($params_string,$params_list,$params_exclude) = $this->setHtmlAtribute($params, $ObjView, $params_exclude_keys);		
		$curr_url_path  	 		=  $ObjView->_views_url_path;
		$params_href		 		=  ($params_href!="")?$curr_url_path.ltrim($params_href,"/"):"Javascript:void(0);";
		if($params_confirm!="")	
		{
			$params_confirm_script='Javascript:jConfirm(\''.$params_confirm.'\', \''.$params_confirm_head.'\', function(r) {
									if(r==true) { window.location.href=\''.$params_href.'\'; };});'; // JUST FOR TESTING
			$params_href 		  =  $params_confirm_script;
		}		
		if($params_alert!="")	
		{
			$params_alert_script  ='Javascript:jAlert(\''.$params_alert.'\');';
			$params_href 		  =  $params_alert_script;
		}				
		if($params_history)	
		{
		     $ObjSession  		= Registry::getInstance('Session');
			 $params_history 	= (strtolower($params_history)=="yes")?"":$params_history;
			 $_queryStringArray = $this->encodeQueryStringArray($ObjView->_views_url_array);
			 $currentURL    	= implode('/',$_queryStringArray);   
			 $ObjSession->setSession("PREVIOUS_URL".$ObjView->_section.$params_history,$currentURL) ;
		}	
		if($params_target=="_blank")
		{
			if($this->isCompleteUrl($params_href)) 
			{
				$params_href= (empty($params['href']))?"":$this->getQualifiedUrl(trim($params['href']));
			}
		}		
		if(isset($params['secureURL']))
		{
			$params_href= (empty($params['secureURL']))?"":trim($params['secureURL']);
		}
		else if($params_href_custom!="") 
		{
			$params_href= (empty($params['href']))?"":trim($params['href']);
		}		
		
	   if($accessChecking)
	   {
			echo '<a href="'.$params_href.'" '.$params_string.' '.$params_title.' >'.$params_image.''.$params_caption.''.$params_content.'</a>';
	   }
	   else
	   {
			$params_string='';	
			//echo $params_caption.''.$params_content; 
	   }
	}	
  
  /**
   * Function to check if the href parameter is a valid url
   *
   * @param mixed $param_href url to be checked
   * @return bool true or false 
   */
	private function isCompleteUrl($param_href)
	{
		$regexp= '/\b(?:(?:https?|ftp):\/\/|www\.)[a-z0-9+&@#\/%?=~_|!:,.;]+(\.[\w\_]+)[a-z0-9+&@#\/%=~_|]/i';
		if (!empty($param_href) && !preg_match($regexp, $param_href)) 
		{
			return false;
		} 
		else 
		{
			return true;
		}
	}
  
  /**
   * Function to return fully qualified url
   * If its complete url, will remain intact
   * @param string $url url to be checked
   * @return complete url 
   */
	function getQualifiedUrl($url)
	{
		$regex = '/\b(?:(?:https?|ftp):\/\/)/i';
		if (!empty($url) && !preg_match($regex, $url)) 
		{
			return 'http://'.$url;
		} 
		else 
		{
			return $url;
		}
	}

	//GENERATE HTML ATRIBUTE
	public function setHtmlAtribute($params, $ObjView,$params_exclude_keys=array()) 
	{
		$params_keys 			= 	array_keys($params); 
	 	$params_string    	  	= 	"";
		$params_list  	  	  	= 	array();
		$params_exclude         = 	array();
		$params_exclude_default = 	array('validate','error');
		$params_exclude_keys 	=   array_merge($params_exclude_default,$params_exclude_keys); 
		$params_value_found     =  0; 
		$params_value_key_found =  0; 		
		for($attr_i=0;$attr_i<count($params_keys);$attr_i++)
		{
			if(!@in_array($params_keys[$attr_i],$params_exclude_keys)) 
			{
				$params_attribute   = $params_keys[$attr_i].'="'.trim($params[$params_keys[$attr_i]]).'"';
				$params_string    	=	$params_string." ".$params_attribute;
			}
		}
		return array($params_string,$params,$params_exclude);
	}

	//Function to paginate  
	public function paginate($params, $ObjView)
	{   
		$params_count 			=  (empty($params['count']))?"":trim($params['count']);
		$params_perpage 		=  (empty($params['perpage']))?"":trim($params['perpage']);
		$params_page 			=  (empty($params['page']))?"":trim($params['page']);
		$params_class 			=  (empty($params['class']))?"":trim($params['class']);
		$params_class_prev 		=  (empty($params['class_prev']))?"":trim($params['class_prev']);
		$params_class_next 		=  (empty($params['class_next']))?"":trim($params['class_next']);
		$params_class_active 	=  (empty($params['class_active']))?"":trim($params['class_active']);
		$params_class_inactive 	=  (empty($params['class_inactive']))?"":trim($params['class_inactive']);
		$params_caption_prev 	=  (empty($params['caption_prev']))?"":trim($params['caption_prev']);
		$params_caption_next 	=  (empty($params['caption_next']))?"":trim($params['caption_next']);
	}

	//To set the message script   
	public function messages_script($params, $ObjView)
	{	
		$params_name 			=  (empty($params['name']))?"":trim($params['name']);
	    $params_id 				=  (empty($params['id']))?$params_name:trim($params['id']);
		$params_class 			=  (empty($params['class']))?"":trim($params['class']);
		$params_section 		=  (empty($params['section']))?"":trim($params['section']);
		$_controller 		    =  (empty($params_section))?strtolower($ObjView->_controller):$params_section;
		$ObjCookie   			= Registry::getInstance('Cookie');
		$params_message    		= $ObjCookie->getCookie($_controller."_".$params_id."_message");
		$params_message_class	= $ObjCookie->getCookie($_controller."_".$params_id."_class");		
		echo '<script type="text/javascript">';
		echo "\n$(document).ready(function(){ \n";
		echo ($params_id!="")?"$('#".$params_id."').hide();":"";
		
		echo $ObjView->getTemplateVars("messages_script");
		echo $messages_script 	= "\n".'jNotifyShow("'.$params_message.'", "'.$params_id.'","'.$params_message_class.'");';
		echo "});";
		echo "</script>";		
		//setcookie($_controller."_".$params_id."_class", "", time()-3600, "/");
		//setcookie($_controller."_".$params_id."_message","", time()-3600, "/");
		//$ObjCookie->setCookie($_controller."_".$params_id."_class", "", time()-3600, "/");
		//$ObjCookie->setCookie($_controller."_".$params_id."_message","", time()-3600, "/");
		$ObjCookie->distroyCookie($_controller."_".$params_id."_class",3600);
		$ObjCookie->distroyCookie($_controller."_".$params_id."_message",3600);
		//$ObjCookie->unsetCookie($_controller."_".$params_id."_class");
		//$ObjCookie->unsetCookie($_controller."_".$params_id."_message");
		
	}	
 	public function encodeQueryStringArray($queryStringArray)
	{
	 	foreach ($queryStringArray as $key => $val)
	 		$queryStringArray[$key]		= urlencode($val);
		return($queryStringArray);
	}
}