<?php
/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/

//
//$Id: load.engine.php,v11 2013/09/24 20:52:11
//

class Load 
{
	/**
	 * List of loaded helpers
	 *
	 * @var array
	 * @access protected
	 */
	protected $_loaded_helpers			= array();
	 
	 /**
	 * Load Helper
	 *
	 * This function loads the specified helper file.
	 *
	 * @param	mixed
	 * @return	void
	 */
	public function helper($helper_array = array())
	{
		if ( ! is_array($helper_array)) { 
			$helper_array	= array($helper_array);
		}
		foreach ($helper_array as $helper) {
			$helper			= strtolower($helper).'_helper';
			if (isset($this->_loaded_helpers[$helper])) { // is already loaded?
				continue;
			}
			$helper_path = __SYSTEM_PATH.'/helpers/'.$helper.'.php';
			if ( ! file_exists($helper_path)) {
					echo 'Unable to load the requested file: '.__SYSTEM_PATH.'/helpers/'.$helper.'.php';
					exit();
			}
			include_once($helper_path);
			$this->_loaded_helpers[$helper] = TRUE;
		}
	}
} 
//End of class