<?php
/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/

//
//$Id: rewrite.engine.php,v 1.0 2011/06/14 20:52:11
//Rewrite - Rewrite Engine for Oorjit Deal System
//
class Rewrite {

  public static  $_requestUrl;
  public static  $_requestFile;
  public static  $_requestHost;
  public static  $_outputUrl;
  public static  $_queryString;
  public static  $_queryDelimiter;
  public static  $_htaccessVariable;
  public static  $_frontendURLBase;
  public static  $_manageURLBase;
  public static  $_manageURLFile;
  public static  $_mobileURLBase;
  public static  $_mobileURLFile;
  public static  $_businessURLBase;
  public static  $_businessURLFile;
  public static  $_affiliateURLBase;
  public static  $_affiliateURLFile;
  public static  $_salesrepURLBase;
  public static  $_salesrepURLFile;
  public static  $_mobilappURLBase;
  public static  $_mobilappURLFile;
  public static  $_manageDIR;
  public static  $_manageLayout;
  public static  $_frontendDIR;
  public static  $_mobileDIR;
  public static  $_mobileLayout;
  public static  $_affiliateDIR;
  public static  $_affiliateLayout;
  public static  $_salesrepDIR;
  public static  $_salesrepLayout;
  public static  $_businessDIR;
  public static  $_businessLayout;
  public static  $_mobilappDIR;
  public static  $_mobilappLayout;
  public static  $_publicURLBase;
  public static  $_publicURLfile;
  public static  $_publicDIR;
  public static  $_publicLayout;
  public static  $_publicManageDIR;
  public static  $_publicFrontendDIR;
  public static  $_publicFrontendCommonDIR;
  public static  $_publicMobileDIR;
  public static  $_publicBusinessDIR;
  public static  $_publicAffiliateDIR;
  public static  $_publicSalesrepDIR;
  public static  $_publicmobilappDIR;
  public static  $_multisiteURLBase;
  public static  $_multisiteURLfile;
  public static  $_multisiteDIR;
  public static  $_multisiteLayout;
  public static  $_languageDIR;
  public static  $_rewriteKey;
  public static  $_rewriteStatus;
  public static  $_multisite;
  public static  $_section;
  public static  $_sub_section;
  public static  $_controller;
  public static  $_controllerAction;
  private static $_options;
  //Constructor for Rewrite class
  public function __construct ($options=null) 
  {
		$this->_requestUrl			=	$_SERVER['QUERY_STRING'];
		$this->_requestFile			=	"";
		$this->_requestDIR			=	"";
		$this->_outputUrl			=	"";
		$this->_requestPage			=	"";
		$this->_queryString			=	array();
        $this->_languageInURL       =   '';
        $this->_languageString      =   '';
		$this->_queryDelimiter		=	"/";
		$this->_htaccessVariable	=	"q=";
		$this->_frontendURLBase		=	"frontend";
		$this->_manageURLBase		=	"manage";
		$this->_manageURLFile		=	"index.php";
		$this->_mobileURLBase		=	"mobile";
		$this->_mobileURLFile		=	"index.php";
		$this->_businessURLBase		=	"business";
		$this->_businessURLFile		=	"index.php";
		$this->_affiliateURLBase	=	"affiliate";
		$this->_affiliateURLFile	=	"index.php";
		$this->_salesrepURLBase		=	"salesrep";
		$this->_salesrepURLFile		=	"index.php";
		$this->_mobilappURLBase		=	"mobilapp";
		$this->_mobilappURLFile		=	"index.php";
		$this->_manageDIR			=	__DIR_MANAGE;
		$this->_manageLayout		=	__LAYOUT_MANAGE;
		$this->_frontendDIR			=	__DIR_FRONTEND;
		$this->_mobileDIR			=	__DIR_MOBILE;
		$this->_mobileLayout		=	__LAYOUT_MOBILE;
		$this->_businessDIR			=	__DIR_BUSINESS;
		$this->_businessLayout		=	__LAYOUT_BUSINESS;
		$this->_affiliateDIR		=	__DIR_AFFILIATE;
		$this->_affiliateLayout		=	__LAYOUT_AFFILIATE;
		$this->_salesrepDIR			=	__DIR_SALESREP;
		$this->_salesrepLayout		=	__LAYOUT_SALESREP;
		$this->_mobilappDIR			=	'__DIR_mobilapp'; 
		$this->_publicURLBase		=	"index";
		$this->_publicURLfile		=	"index.php";
		$this->_publicDIR			=	__DIR_PUBLIC;
		$this->_publicLayout		=	__LAYOUT_FRONTEND;
		$this->_publicManageDIR		=	__CORE_PUBLIC_MANAGE_PATH;
		$this->_publicFrontendDIR	=	__CORE_PUBLIC_FRONTEND_PATH;
		$this->_publicFrontendCommonDIR	=	__CORE_PUBLIC_COMMON_FRONTEND_PATH;
		$this->_publicMobileDIR		=	__CORE_PUBLIC_MOBILE_PATH;
		$this->_publicBusinessDIR	=	__CORE_PUBLIC_BUSINESS_PATH;
		$this->_publicAffiliateDIR	=	__CORE_PUBLIC_AFFILIATE_PATH;
		$this->_publicSalesrepDIR	=	__CORE_PUBLIC_SALESREP_PATH;
		$this->_publicmobilappDIR	=	'__CORE_PUBLIC_mobilapp_PATH';
		$this->_multisiteURLBase	=	"sites";
		$this->_multisiteURLfile	=	"index.php";
		$this->_multisite			=	"";
		$this->_multisiteLayout		=	__LAYOUT_MULTISITE;
		$this->_languageDIR			=	__DIR_LANGUAGE;
		$this->_section				=	$this->_frontendURLBase;
		$this->_multisiteDIR		=	__DIR_MULTISITE;
		$this->_rewriteKey			=	__URL_REWRITE_KEY;
		$this->_rewriteStatus		=	__URL_REWRITE_STATUS;
		$this->_sub_section			= "";
		$this->setOptions($options);
		$this->setSettings();
                $this->init();              
  }
  //To initialize object
  public function init()  
  {  
      
	 if($this->_rewriteStatus==1) {
     		$this->_outputUrl    	=  	$this->revertSecureUrl($this->_requestUrl,$this->_rewriteKey);
	 } else {
	 		$this->_outputUrl   	= 	$this->_requestUrl;
	 }
	 $this->_outputUrl   		   .=   (substr($this->_outputUrl,(strlen($this->_outputUrl)-1),strlen($this->_outputUrl))=="/")?"":"/";
	 $this->_requestDIR 				= str_replace($_SERVER['DOCUMENT_ROOT'],"",__ROOT_PATH);
	 $requestServerUrl                      =    $_SERVER["HTTP_HOST"] . $_SERVER['REQUEST_URI'];
        //MOBILE WEB SETTINGS
         //$mobileHttpUrl        =   str_replace("http://","",$this->getSettingValue('mobileweb_settings', 'global_http_url_mobile')); 
         //$mobileHttpsUrl        =  str_replace("https://","", $this->getSettingValue('mobileweb_settings', 'global_https_url_mobile')); 
	 if(substr_count($this->_outputUrl,$this->_htaccessVariable.$this->_manageURLBase)) {
			$this->_requestFile	 	= 	$this->_manageURLFile;
			$this->_requestPage  	= 	str_replace($this->_htaccessVariable.$this->_manageURLBase,"",$this->_outputUrl);
			$this->_queryString  	= 	explode($this->_queryDelimiter,$this->_requestPage);
			$resetQueryString    	=   empty($this->_queryString[0])?array_shift($this->_queryString):$this->_queryString;
			$this->_section		 	=	$this->_manageURLBase;
	 } 
	 elseif(substr_count($this->_outputUrl,$this->_htaccessVariable.$this->_businessURLBase)) {  
			$this->_requestFile	 	= 	$this->_businessURLFile; 
			$this->_requestPage  	= 	str_replace($this->_htaccessVariable.$this->_businessURLBase,"",$this->_outputUrl); 
			$this->_queryString  	= 	explode($this->_queryDelimiter,$this->_requestPage);
			$resetQueryString    	=   empty($this->_queryString[0])?array_shift($this->_queryString):$this->_queryString;
			$this->_section		 	=	$this->_businessURLBase; 
	 }
	 elseif(substr_count($this->_outputUrl,$this->_htaccessVariable.$this->_affiliateURLBase) && __AFFILIATE_MODULE) {  
			$this->_requestFile	 	= 	$this->_affiliateURLFile; 
			$this->_requestPage  	= 	str_replace($this->_htaccessVariable.$this->_affiliateURLBase,"",$this->_outputUrl); 
			$this->_queryString  	= 	explode($this->_queryDelimiter,$this->_requestPage);
			$resetQueryString    	=   empty($this->_queryString[0])?array_shift($this->_queryString):$this->_queryString;
			$this->_section		 	=	$this->_affiliateURLBase; 
	 }
	 elseif(substr_count($this->_outputUrl,$this->_htaccessVariable.$this->_salesrepURLBase) && __SALESREP_MODULE) {  
			$this->_requestFile	 	= 	$this->_salesrepURLFile; 
			$this->_requestPage  	= 	str_replace($this->_htaccessVariable.$this->_salesrepURLBase,"",$this->_outputUrl); 
			$this->_queryString  	= 	explode($this->_queryDelimiter,$this->_requestPage);
			$resetQueryString    	=   empty($this->_queryString[0])?array_shift($this->_queryString):$this->_queryString;
			$this->_section		 	=	$this->_salesrepURLBase; 
	 }
	 elseif($mobileHttpUrl && (substr_count($requestServerUrl,$mobileHttpUrl) || substr_count($requestServerUrl,$mobileHttpsUrl))&& __MOBILE_WEB_MODULE) { 
			$this->_requestFile	 	= 	$this->_mobileURLFile;
			$this->_requestPage  	= 	str_replace($this->_htaccessVariable.$this->_mobileURLBase,"",$this->_outputUrl);
			$this->_queryString  	= 	explode($this->_queryDelimiter,$this->_requestPage);
			$resetQueryString    	=   empty($this->_queryString[0])?array_shift($this->_queryString):$this->_queryString;
			$this->_section		 	=	$this->_mobileURLBase;
	 }	 
	 elseif(substr_count($this->_outputUrl,$this->_htaccessVariable.$this->_mobilappURLBase) && __MOBILE_APP_MODULE) { 
			$this->_requestFile	 	= 	$this->_mobilappURLFile;
			$this->_requestPage  	= 	str_replace($this->_htaccessVariable.$this->_mobilappURLBase,"",$this->_outputUrl);
			$this->_queryString  	= 	explode($this->_queryDelimiter,$this->_requestPage);
			$resetQueryString    	=   empty($this->_queryString[0])?array_shift($this->_queryString):$this->_queryString;
			$this->_section		 	=	$this->_mobilappURLBase;
	 }
	 elseif (substr_count($this->_outputUrl,$this->_htaccessVariable.$this->_multisiteURLBase)) { 
			$this->_requestFile	 	= 	$this->_multisiteURLfile;
			$this->_requestPage     = 	str_replace($this->_htaccessVariable.$this->_multisiteURLBase,"",$this->_outputUrl);
			$this->_queryString  	= 	explode($this->_queryDelimiter,$this->_requestPage);
			$resetQueryString    	=   empty($this->_queryString[0])?array_shift($this->_queryString):$this->_queryString;
			$this->_multisite	 	=   $this->_queryString[0];
			$resetQueryString    	=   !empty($this->_queryString[0])?array_shift($this->_queryString):$this->_queryString;
			$this->_section		 	=	$this->_multisiteURLBase;
	 } else { 
			$this->_requestFile		= 	$this->_publicURLfile;
			$this->_requestPage  	=	str_replace($this->_htaccessVariable,"",$this->_outputUrl);
			$this->_queryString  	=	explode($this->_queryDelimiter,$this->_requestPage);
			$resetQueryString    	=   empty($this->_queryString[0])?array_shift($this->_queryString):$this->_queryString;
// Sub sections
			if($this->_queryString[0] == 'api')
				$this->_sub_section		= 'api';
			else if($this->_queryString[0] == 'coupon' && __COUPON_MODULE)
				$this->_sub_section		= 'coupon';
                        //URL REWRITE CHNAGES
                       $this->_languageInURL        =   $this->getSettingValue('seo_settings', 'language_in_url'); 
                       //REMOVE END SLASH IF suffix exists
					   $this->_queryString[sizeof($this->_queryString) - 2] = isset($this->_queryString[sizeof($this->_queryString) - 2]) ? $this->_queryString[sizeof($this->_queryString) - 2]  : '';
                       $this->_requestPage=(strpos($this->_queryString[sizeof($this->_queryString) - 2],"."))?rtrim($this->_requestPage,"/"):$this->_requestPage;
                       $this->_languageString = $this->_queryString[0];
                 
                       $ObjCook 	=   Registry::getInstance('Cookie');    
                       if($ObjCook->getCookie($this->_section.'_LanguageLCIDstring')==$this->_queryString[0]){
                                array_shift($this->_queryString);    
                                $this->_requestPage  	=	substr($this->_requestPage,strlen($this->_languageString));                                
                       }                        
                             
	 }
	 if($this->_sub_section)
	 {
		$this->_controller				= isset($this->_queryString[1]) ? $this->_queryString[1]  : '';
		$this->_controllerAction		= isset($this->_queryString[2]) ? $this->_queryString[2]  : '';
	 }
	 else
	 {
		$this->_controller				= isset($this->_queryString[0]) ? $this->_queryString[0]  : '';
		$this->_controllerAction		= isset($this->_queryString[1]) ? $this->_queryString[1]  : '';	
	 }
	  $this->_requestPage   	=   (substr($this->_requestPage,0,1)=="/")?substr($this->_requestPage,1,strlen($this->_requestPage)):$this->_requestPage;
	  $endstring	=	(strpos($this->_requestPage,'&')>0)?strpos($this->_requestPage,'&'):strlen($this->_requestPage);	 
	  $requestHost = (!empty($_SERVER['HTTPS'])) ? "https://".$_SERVER['HTTP_HOST']: "http://".$_SERVER['HTTP_HOST'];
	  if($this->_requestDIR!="") {
			$requestHost .= $_SERVER['REQUEST_URI'];
			$requestHostArray   = @explode($this->_requestDIR,$requestHost);  
			$this->_requestHost = $requestHostArray[0].$this->_requestDIR;
			
	  } else {
	  		$this->_requestHost = rtrim($requestHost,"/");
	  }
  }
  //To get the settings value  
    public function getSettingValue($keyGroupID, $keyID = "")
    {
        $_settings     = Registry::getInstance('_settings');
		$_settings[$keyGroupID] = isset($_settings[$keyGroupID]) ? $_settings[$keyGroupID]  : '';
		$_settings[$keyGroupID][$keyID] = isset($_settings[$keyGroupID][$keyID]) ? $_settings[$keyGroupID][$keyID]  : '';
        $setting_value = ((empty($keyID)) ? ($_settings[$keyGroupID]) : ($_settings[$keyGroupID][$keyID]));
        // $setting_value=utf8_decode($setting_value);
        return $setting_value;
    }
        //To load settings xml
	public function setSettings()  
	{
		if(@is_file(__CORE_PUBLIC_PATH . '/cache/'   . 'settings.xml'))
			$settingsXmlFile	= __CORE_PUBLIC_PATH . '/cache/'   . 'settings.xml';
		else
			$settingsXmlFile	= __SYSTEM_PATH . '/cache/'   . 'settings.xml';
		$ObjSettingsXml 		= simplexml_load_file($settingsXmlFile);
		$settingsArray 			= $this->settingsXmlToArray($ObjSettingsXml);			
		$test = Registry::setInstance('_settings',$settingsArray);
	}
        //Settings XML to array
	public function settingsXmlToArray($object,$maximum_step=4,$curr_step=1) 
	{ 
		$return = NULL; 
		$curr_step++;
		if(is_array($object)) { 
			foreach($object as $key => $value) {
            	$return[$key]	= $this->settingsXmlToArray($value,$maximum_step,$curr_step); 
			}
		} else {  
			$var = @get_object_vars($object); 
			if($var) { 
				foreach($var as $key => $value) { 
					if($maximum_step>$curr_step) {
						$return[$key] = ($key && !$value) ? NULL : $this->settingsXmlToArray($value,$maximum_step,$curr_step); 
					} else {
						$return[$key] = ($key && !$value) ? NULL : $value; 
					}
				}
			} else {
			   return $object; 
			}
		} 
    	return $return; 
	} 
  //To set options
  private function setOptions($options)  
  {
	  return $this->_options =	$options;
  }
  //To revert secure url
  public function revertSecureUrl($query_string="",$key="")
   {
	  	$query_string		 = 	str_replace($this->_htaccessVariable.$this->_manageURLBase.$this->_queryDelimiter,"",$query_string);
	  	$result_string		 = 	$this->revertString(trim($query_string),$key);
	 	return $result_string;
   }
   //To convert url
   public function convertUrl($query_string="")
   {
          return explode($query_string);
   }
   //To revert url
   public function revertUrl($query_string="")
   {
        if(substr_count($query_string,"?")>0){
			$query_string_array = explode("?",$query_string);
			$query_string = $query_string_array[1];
		}
		
		$query_string_result_array = array();
	
		if(substr_count($query_string,"&")>0) {
		
			$query_string_key_temp = explode("&",$query_string);
			foreach($query_string_key_temp as $query_string_key_value_temp)
			{
				$query_string_key_value= explode("=",$query_string_key_value_temp);
				$query_string_result_array[$query_string_key_value[0]] = $query_string_key_value[1];
			}
				
		} else {
				$query_string_key_value= explode("=",$query_string);
				$query_string_result_array[$query_string_key_value[0]] = $query_string_key_value[1];
		}
		return $query_string_result_array;
   }
  //To convert string  
  public function convertString($input,$key)
  {
		$key = substr(md5($key),0,24);
		$td = mcrypt_module_open ('tripledes', '', 'ecb', '');
		$iv = mcrypt_create_iv (mcrypt_enc_get_iv_size ($td), MCRYPT_RAND);
		mcrypt_generic_init ($td, $key, $iv);
		$encrypted_data = mcrypt_generic ($td, $input);
		mcrypt_generic_deinit ($td);
		mcrypt_module_close ($td);
		$result= trim(chop($this->urlBase64Encode($encrypted_data)));
		return $result;
  }
  //To revert string
  public function revertString($input,$key)
  {
		$input = trim(chop($this->urlBase64Decode($input)));
		$td = mcrypt_module_open ('tripledes', '', 'ecb', '');
		$key = substr(md5($key),0,24);
		$iv = mcrypt_create_iv (mcrypt_enc_get_iv_size ($td), MCRYPT_RAND);
		mcrypt_generic_init ($td, $key, $iv);
		$decrypted_data = mdecrypt_generic ($td, $input);
		mcrypt_generic_deinit ($td);
		mcrypt_module_close ($td);
		$result= trim(chop($decrypted_data));
		return $result;
  }
  //To encode url using base64
  private function urlBase64Encode($str) {
		
		return strtr(base64_encode($str),
		array(
		'+' => '.',
		'=' => '-',
		'/' => '~'
		)
		);
  }
  //To decode url using base64
  private function urlBase64Decode($str) {
	
		return base64_decode(strtr($str,
		array(
		'.' => '+',
		'-' => '=',
		'~' => '/'
		)
		));
 }  
}