<?php
/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/

//
//$Id: router.engine.php,v 1.0 2011/06/14 20:52:11
//Router - Router Engine for Oorjit Deal System
//
class Router {
	protected $ObjModel;
  	protected $_controller;
  	protected $_controllerDIR;
  	protected $_controllerAction;
  	protected $_model;
  	protected $_sub_section;
  	public static $controllerInstance;
  	
	//Constructor of Router class
  	public function __construct () 
  	{		
		$this->_modelDIR  		=       __CORE_MODELS_PATH;
                $this->_seoModules              =       __SYSTEM_SEO_MODULES;
		$this->init();	
  	}
  
  	//To inistialize objects
  	private function init()  
  	{
		$ObjRewrite	  				= Registry::getInstance('Rewrite');
		$ObjConfig	  				= Registry::getInstance('Config');
		$this->_sub_section			= $ObjRewrite->_sub_section;
		$this->_controller  	 	= ((empty($ObjRewrite->_controller))?"Index":ucfirst($ObjRewrite->_controller))."Controller";
		$this->_controllerAction 	= ((empty($ObjRewrite->_controllerAction))?"Index":ucfirst(trim($ObjRewrite->_controllerAction)));
		if($ObjRewrite->_section == $ObjRewrite->_manageURLBase)
			$this->_controllerDIR  	= __CORE_MANAGE_CONTROLLERS_PATH;
		else if($ObjRewrite->_section == $ObjRewrite->_mobileURLBase) 
			$this->_controllerDIR  	= __CORE_MOBILE_CONTROLLERS_PATH;
		else if($ObjRewrite->_section == $ObjRewrite->_businessURLBase)
		    $this->_controllerDIR  	= __CORE_BUSINESS_CONTROLLERS_PATH;
		else if($ObjRewrite->_section == $ObjRewrite->_affiliateURLBase)
		    $this->_controllerDIR  	= __CORE_AFFILIATE_CONTROLLERS_PATH;
		else if($ObjRewrite->_section == $ObjRewrite->_salesrepURLBase)
		    $this->_controllerDIR  	= __CORE_SALESREP_CONTROLLERS_PATH;
		else if($ObjRewrite->_section == $ObjRewrite->_mobilappURLBase)
		    $this->_controllerDIR  	= __CORE_MOBILAPP_CONTROLLERS_PATH;
		else
		  	 $this->_controllerDIR  = __CORE_FRONTEND_CONTROLLERS_PATH;
		$this->registerModelAutoLoader();
                //URL REWITE PATH
               // echo $ObjRewrite->_requestPage;
                if($this->_controllerDIR==__CORE_FRONTEND_CONTROLLERS_PATH ){                
                     $this->sefRouter($ObjRewrite);           
                 }                  
                //    //URL REWITE PATH ENDS
		$this->registerControllerAutoLoader();
		$this->setControllerAction($ObjRewrite);
  	} 
    public function sefRouter($ObjRewrite)
    {
        $ObjLanguage        =   new LanguageModel();
        $ObjCook 	=   Registry::getInstance('Cookie');                
        if($ObjCook->getCookie($ObjRewrite->_section.'_LanguageLCIDstring')!=$ObjRewrite->_languageString && ($ObjRewrite->_languageString!=''))
		{
            $languageIDs['Current']=$ObjLanguage->setLanguageFromURL($ObjRewrite->_languageString);
            $ObjRewrite->_languageString = ($languageIDs['Current']>0)?$ObjRewrite->_languageString:'';
            if($ObjRewrite->_languageString==$ObjRewrite->_queryString[0])
			{
                array_shift($ObjRewrite->_queryString);                   
                $ObjRewrite->_requestPage  	=	ltrim(substr($ObjRewrite->_requestPage,strlen($ObjRewrite->_languageString)), '/');                   
            }
        }
		else
		{
            $languageIDs['Current'] 	=   $ObjCook->getCookie($ObjRewrite->_section.'_CurrentLanguageID');          
        }
		if($ObjRewrite->_requestPage!='')
		{
			$ObjURLRewrite 	=   new UrlrewriteModel();           
			$languageIDs['Current']  =  ($languageIDs['Current']=='')? $ObjLanguage->getDefaultLanguageID():$languageIDs['Current'];    //CHECk FOR     
			$requestCases        =   $this->rewritePath($ObjRewrite->_requestPage);                   
			$addQryStrng         =   $requestCases[0];
			array_shift($requestCases);
			$resTargetPath   	= $ObjURLRewrite->getTargetPath($requestCases,$languageIDs); 
			$TargetPathRes		= $resTargetPath['targetPath'];
		 
			//echo $TargetPathRes;
			if($TargetPathRes!='')
			{
                $res= explode("/",$TargetPathRes);
                if(strtolower($res[0])==$ObjRewrite->_affiliateURLBase || strtolower($res[0])==$ObjRewrite->_salesrepURLBase || strtolower($res[0])==$ObjRewrite->_businessURLBase)
				{
                    $location_url 			=  @rtrim($ObjRewrite->_requestHost,"/").'/'.strtolower($res[0]).'/';
                    header("Location:$location_url");
                }
				else 
				{
                    $this->_controller=ucfirst($res[0])."Controller";
                    $this->_controllerAction=ucfirst($res[1]);
                    $TargetPathRes  .=$addQryStrng;
                    $ObjRewrite->_queryString  	= explode($ObjRewrite->_queryDelimiter,$TargetPathRes);
					$ObjRewrite->_targetPath  	= $resTargetPath['targetPath'];
					$ObjRewrite->_targetPathType= $resTargetPath['type'];
                }
			}
		}
    }
    public function rewritePath($pathInfo)
    {
            /**
         * We have two cases of incoming paths - with and without slashes at the end ("/somepath/" and "/somepath").
         * Each of them matches two url rewrite request paths - with and without slashes at the end ("/somepath/" and "/somepath").
         * Choose any matched rewrite, but in priority order that depends on same presence of slash and query params.
         */
        $pathInfo = addslashes($pathInfo);
        $requestCases = array();       
        $origSlash = (substr($pathInfo, -1) == '/') ? '/' : '';
        $requestPath = trim($pathInfo, '/');
        $requestpathArr =   explode("&",$pathInfo);              
        // If there were final slash - add nothing to less priority paths. And vice versa.
        $altSlash = $origSlash ? '' : '/';
        $requestPath  = $requestpathArr[0];
        array_shift($requestpathArr);
        $result = $this->_getQueryString($requestpathArr); // Query params in request, matching "path + query" has more priority
        $queryString = $result[0];
        $requestCases[] = $result[1];
        if ($queryString) {
            $requestCases[] = "'".$requestPath . $origSlash . '?' . $queryString."'";
            $requestCases[] = "'".$requestPath . $altSlash . '?' . $queryString."'";           
        }
        $requestCases[] = "'".$requestPath . $origSlash."'";
        $requestCases[] ="'". $requestPath . $altSlash."'";        
        return $requestCases;
    }
    public function _getQueryString($requestpath)
    {       
        if (!empty($requestpath)) {
            $queryParams = array();             
            $requestpath=implode("&",$requestpath);          
            parse_str($requestpath, $queryParams);
            $hasChanges = false;
            $qryStrng=  '';
            foreach ($queryParams as $key=>$value) {               
                if (substr($key, 0, 3) === '___') {
                    unset($queryParams[$key]);
                    $hasChanges = true;
                }
                $qryStrng  .= $key.'/'.$value.'/';
            } 
            $result=Array(http_build_query($queryParams),$qryStrng);
            
             return $result;
        }
        return false;
    }
  	// To register Model autoload function
  	private function registerModelAutoLoader()
  	{
		spl_autoload_register(array($this,'setModelClass'));
  	}
 
  	// To register Controller autoload function
  	private function registerControllerAutoLoader()
  	{
		spl_autoload_register(array($this,'setControllerClass'));
  	}
    
  	// Callback function To Autoload Model class
  	private function setModelClass($class)
  	{
        $autoload_include_path 	= $this->_modelDIR."/";
        $autoload_extension   	= '.php' ;
        $autoload_class_file	= $autoload_include_path.$class.$autoload_extension;
		if (trim($autoload_class_file)!="" && (substr_count($class,"Model")>0)){
		    if(file_exists($autoload_class_file))
				include_once($autoload_class_file);
			else
				return false;
		} 
		else
			return false;
  	}

  	//To set autoloading of the controller class
  	private function setControllerClass($class)
  	{  
  		if($this->_sub_section)
        	$autoload_include_path 	= $this->_controllerDIR."/".$this->_sub_section."/";
		else
			$autoload_include_path 	= $this->_controllerDIR."/";
        $autoload_extension   	= '.php' ;
        $autoload_class_file	= $autoload_include_path.$class.$autoload_extension;   
		if (trim($autoload_class_file)!="" && (substr_count($class,"Controller")>0)){
                  
		    if(file_exists($autoload_class_file)){				
                                include_once($autoload_class_file);
			}else{                           
			  	$autoload_class_file	= $autoload_include_path."IndexController".$autoload_extension;
			  	include_once($autoload_class_file);
			}
		} 
		else
			return false;
  	}
  	//To set controller class
  	private function setControllerAction($ObjRewrite)
  	{
         $controllerClassName 	= $this->_controller ;
	   if (class_exists($controllerClassName)) {              
    		$ObjControllerClass = new $controllerClassName();
	   } else {
			$ObjControllerClass = new IndexController();
			$this->_controller  ="IndexController";
	   }
	   self::$controllerInstance = $ObjControllerClass;
	   $controllerAction   		= ((trim($this->_controllerAction)=="")?"index":(trim($this->_controllerAction)))."Action";      
	   if((method_exists($ObjControllerClass, $controllerAction))) {
	  		 $ObjControllerClass->$controllerAction();
	   } else {			
			//Access Restriction in Manage Section : Required not prevent access if action is not present
			if(strtolower($ObjRewrite->_section)==strtolower($ObjRewrite->_manageURLBase))
			{
				$location_url 			=  @rtrim($ObjRewrite->_requestHost,"/").'/'.strtolower($ObjRewrite->_manageURLBase).'/'.$ObjRewrite->_controller.'/index/';
				header("Location:$location_url");
				exit;
			}
			$ObjControllerClass->IndexAction();
			
	   		//$exception_error_message = "<br /><b>Application Error 451 </b>: Error found in <b>".$this->_controller."</b> Controler . ";
	   	  	//$exception_error_message .= "function <b>".$controllerAction."</b> not defined in this Controler.<br />";
			//echo $exception_error_message;
			//throw new ExceptionHandler($exception_error_message);
	   }
  	}

  	public static function getControllerInstance()
  	{
    	return self::$controllerInstance;	
  	}   
}