<?php
/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/

//
//$Id: view.engine.php,v 1.0 2011/06/14 20:52:11
//View - View Engine for Oorjit Deal System
//
class View extends SmartyBC {
	protected $ObjConfig;
	public $ObjLanguage;
	public $languageIDs;
        public $languageIDsList;
	public $_languageXML;
	public $_views_path;
	public $_views_url;
	public $_views_url_array;
	public $_views_url_path;
	public $_views_request_url;
	public $_root_path;
	public $_public_path;
	public $_base_path;
	public $_base_directory;
	public $_views_host;
	public $_styles_path;
	public $_javascript_path;
	public $_images_path;
	public $_section;
	public $_controller;
	public $_action;
	public $_access;
	public $_common_frontend_js_path;
	public $_common_js_path;
	public $_common_frontend_css_path;
	public $_currencies;
	public $_defaultCurrency;
    public $_views_host_share;
    public $_sefurls;
	public $ObjCommon;
	
	public function __construct ($ObjForm) {
		parent::__construct();
		$this->setConfig($ObjForm);
	}
	public function display($template = null, $cache_id = null, $compile_id = null, $parent = null)
	{
		parent::display($template,$cache_id,$compile_id,$parent);
		//echo 'this section will exicute after tpl render';
	}
	public function setAccess($access) {
		return $this->_access = $access;
	}

	public function getAccess($ObjForm) {
		return  $this->_access;
	}

  	public function setConfig($ObjForm) {
		$ObjRewrite		= Registry::getInstance('Rewrite');
		$ObjConfig		= Registry::getInstance('Config');
		$ObjHtml		= Registry::getInstance('Html');
		$ObjPaginate	= Registry::getInstance('Paginate');
		$this->_section = $ObjRewrite->_section;
		if($ObjRewrite->_section == $ObjRewrite->_manageURLBase) {// Admin web section
			$template_dir			= substr(__CORE_MANAGE_VIEWS_PATH,(strrpos(__CORE_MANAGE_VIEWS_PATH,"\\")+1),strlen(__CORE_MANAGE_VIEWS_PATH));
			$template_compile_dir	= __CORE_PUBLIC_MANAGE_COMPILE_PATH."/";
			$template_cache_dir		= __CORE_PUBLIC_MANAGE_CACHE_PATH."/";
			$this->_views_path 		= str_replace(__ROOT_PATH."/","",$ObjRewrite->_publicManageDIR); 
	    }
		else if($ObjRewrite->_section == $ObjRewrite->_businessURLBase) {// Business web section
			$template_dir 			=  substr(__CORE_BUSINESS_VIEWS_PATH,(strrpos(__CORE_BUSINESS_VIEWS_PATH,"\\")+1),strlen(__CORE_BUSINESS_VIEWS_PATH));
			$template_compile_dir	=  __CORE_PUBLIC_BUSINESS_COMPILE_PATH."/";
			$template_cache_dir		=  __CORE_PUBLIC_BUSINESS_CACHE_PATH."/";
			$this->_views_path		= str_replace(__ROOT_PATH."/","",$ObjRewrite->_publicBusinessDIR);
		}
		else if($ObjRewrite->_section == $ObjRewrite->_affiliateURLBase) { // Affiliate web section
			$template_dir 			=  substr(__CORE_AFFILIATE_VIEWS_PATH,(strrpos(__CORE_AFFILIATE_VIEWS_PATH,"\\")+1),strlen(__CORE_AFFILIATE_VIEWS_PATH));
			$template_compile_dir	=  __CORE_PUBLIC_AFFILIATE_COMPILE_PATH."/";
			$template_cache_dir		=  __CORE_PUBLIC_AFFILIATE_CACHE_PATH."/";
			$this->_views_path		= str_replace(__ROOT_PATH."/","",$ObjRewrite->_publicAffiliateDIR);
		}
		else if($ObjRewrite->_section == $ObjRewrite->_salesrepURLBase) { // Salesrep web section
			$template_dir 			=  substr(__CORE_SALESREP_VIEWS_PATH,(strrpos(__CORE_SALESREP_VIEWS_PATH,"\\")+1),strlen(__CORE_SALESREP_VIEWS_PATH));
			$template_compile_dir	=  __CORE_PUBLIC_SALESREP_COMPILE_PATH."/";
			$template_cache_dir		=  __CORE_PUBLIC_SALESREP_CACHE_PATH."/";
			$this->_views_path		= str_replace(__ROOT_PATH."/","",$ObjRewrite->_publicSalesrepDIR);
		}				
		else if($ObjRewrite->_section == $ObjRewrite->_mobileURLBase) { // Mobile web section
			$template_dir 			=  substr(__CORE_MOBILE_VIEWS_PATH,(strrpos(__CORE_MOBILE_VIEWS_PATH,"\\")+1),strlen(__CORE_MOBILE_VIEWS_PATH));
			$template_compile_dir	=  __CORE_PUBLIC_MOBILE_COMPILE_PATH."/";
			$template_cache_dir		=  __CORE_PUBLIC_MOBILE_CACHE_PATH."/";
			$this->_views_path		= str_replace(__ROOT_PATH."/","",$ObjRewrite->_publicMobileDIR);
		}		
		else if($ObjRewrite->_section == $ObjRewrite->_mobilappURLBase) { // Mobile app section
			$template_dir 			=  substr(__CORE_MOBILAPP_VIEWS_PATH,(strrpos(__CORE_MOBILAPP_VIEWS_PATH,"\\")+1),strlen(__CORE_MOBILAPP_VIEWS_PATH));
			$template_compile_dir	=  __CORE_PUBLIC_MOBILAPP_COMPILE_PATH."/";
			$template_cache_dir		=  __CORE_PUBLIC_MOBILAPP_CACHE_PATH."/";
			$this->_views_path 		= str_replace(__ROOT_PATH."/","",$ObjRewrite->_publicMobilappDIR);
		}
		else {// Front end default
			$template_dir			=  substr(__CORE_FRONTEND_VIEWS_PATH,(strrpos(__CORE_FRONTEND_VIEWS_PATH,"\\")+1),strlen(__CORE_FRONTEND_VIEWS_PATH));
			$template_compile_dir	=  __CORE_PUBLIC_FRONTEND_COMPILE_PATH."/";
			$template_cache_dir		=  __CORE_PUBLIC_FRONTEND_CACHE_PATH."/";
			$this->_views_path		= str_replace(__ROOT_PATH."/","",$ObjRewrite->_publicFrontendDIR);
		}
		if($ObjRewrite->_section==$ObjRewrite->_multisiteURLBase)
			$this->_views_path = $ObjRewrite->_publicDIR."/".$ObjRewrite->_multisiteDIR."/".$ObjRewrite->_multisite."/".$ObjRewrite->_frontendDIR."/".$ObjRewrite->_publicLayout."/";		
		$this->_views_path 		=	WEB_BASE_DIR.$this->_views_path;
		$this->_views_url_array = $ObjRewrite->_queryString;
		$this->_controller 		= ((empty($ObjRewrite->_controller))?"Index":ucfirst($ObjRewrite->_controller))."";
		$this->_action 			= ((empty($ObjRewrite->_controllerAction))?"Index":ucfirst($ObjRewrite->_controllerAction))."";
		$this->_views_host 		= @rtrim($ObjRewrite->_requestHost,"/");
		//URL REWRITE
		if($ObjRewrite->_languageInURL=='Yes'){
			$ObjCook 	=   Registry::getInstance('Cookie');                        
			$LCIDString     =   $ObjRewrite->_languageString?$ObjRewrite->_languageString:$ObjCook->getCookie($this->_section.'_LanguageLCIDstring');
		}  
		$this->_views_host_share        =      (isset($LCIDString))? $this->_views_host.'/'.$LCIDString:$this->_views_host;
		$LCIDString = isset($LCIDString) ? $LCIDString  : '';
		// Smarty Settings begin		
		$this->setTemplateDir($template_dir);
		$this->setCompileDir($template_compile_dir);
		$this->setCacheDir($template_cache_dir);
		$this->force_compile 	= false;
		$this->debugging 		= false;
		$this->caching 			= false;
// Smarty Settings end				
		//$this->cache_lifetime 	= 120;
// Register objects 		
		$this->registerObject('form',$ObjForm);
		$this->registerObject('html',$ObjHtml);
		$this->registerObject('paginate',$ObjPaginate);
		$this->_images_path = $this->_views_path."/images";
		$this->_javascript_path = $this->_views_path."/javascript";
		$this->_styles_path = $this->_views_path."/styles";
		$this->_common_frontend_js_path	=	$this->getPublicPath($ObjRewrite).'/'.__DIR_PUBLIC_CORE."/".__DIR_FRONTEND."/". __DIR_COMMON_FRONTEND ."/javascript";
		$this->_common_js_path	=	$this->getPublicPath($ObjRewrite).'/'.__DIR_PUBLIC_CORE. '/'.__DIR_COMMON ."/javascript";
		$this->_common_frontend_css_path	=	$this->getPublicPath($ObjRewrite).'/'.__DIR_PUBLIC_CORE."/".__DIR_FRONTEND."/". __DIR_COMMON_FRONTEND ."/styles";
		$this->assign("view_host",$this->_views_host);
                $this->assign("views_host_share",$this->_views_host_share);
		$this->assign("view_root_path",$this->getRootPath($ObjRewrite));
		$this->assign("view_base_path",$this->getBasePath($ObjRewrite));
		$this->assign("view_public_path",$this->getPublicPath($ObjRewrite));
		$this->assign("view_base_directory",$this->getBaseDirectory($ObjRewrite));
		$this->assign("view_url",$this->getCurrentURL($ObjRewrite));
		$this->assign("view_url_path",$this->getUrlPath($ObjRewrite,$LCIDString));
		$this->assign("view_javascript",$this->_javascript_path);
		$this->assign("view_styles",$this->_styles_path);
		$this->assign("view_images",$this->_images_path);
		$this->assign("common_frontend_js",$this->_common_frontend_js_path);
		$this->assign("common_frontend_css",$this->_common_frontend_css_path);
		$this->assign("common_js",$this->_common_js_path);
		// Sub sections		
		$this->assign("view_coupon_path",__COUPON_PATH);
	}

	public function getUrlPath($ObjRewrite,$LCIDString) {
		if($ObjRewrite->_section==$ObjRewrite->_frontendURLBase){
                    //URL REWRITE CHNAGES                  
                   if($ObjRewrite->_languageInURL=='Yes' && $LCIDString!='')
			$currsSction = $LCIDString.'/';
                   else
                       $currsSction = '';                        
                }
		else
			$currsSction = $ObjRewrite->_section.'/';
		return $this->_views_url_path = WEB_BASE_DIR.$currsSction;
	}

	public function getRootPath($ObjRewrite) {
		$this->_root_path = rtrim(WEB_BASE_DIR,"/");
		@define("__VIEW_ROOT_PATH",$this->_root_path);
		return  $this->_root_path;
	}

	public function getPublicPath($ObjRewrite) {
		$curr_root_path		= $this->getRootPath($ObjRewrite);
		$this->_public_path =  $curr_root_path."/".__DIR_PUBLIC;
		return  $this->_public_path;
	}

	public function getBasePath($ObjRewrite) {
		if($ObjRewrite->_section==$ObjRewrite->_frontendURLBase)
			$this->_base_path = rtrim(WEB_BASE_DIR,"/");
		else
			$this->_base_path = WEB_BASE_DIR.$ObjRewrite->_section;
		define("__VIEW_BASE_PATH",$this->_base_path); 
		return $this->_base_path;
	}

	public function getBaseDirectory($ObjRewrite) {
		$this->_base_directory   = $ObjRewrite->_requestDIR;
		define("__VIEW_BASE_DIRECTORY",$this->_base_directory); 
		return $this->_base_path;
	}

	public function getCurrentURL($ObjRewrite) {
		$this->_views_request_url = $ObjRewrite->_requestUrl;
		$this->_views_url   = $ObjRewrite->_requestPage;
		define("__VIEW_URL",$this->_views_url); 
		return $this->_views_url;
	}

	public function assignValues($Rows) {
		$RowsNewArray = @array_keys($Rows);
		$RowsNewArrayCount = count($RowsNewArray);
		for($fi=0;$fi<$RowsNewArrayCount;$fi++) {
			if (!is_int($RowsNewArray[$fi])) {
				$setToView		=	$this->assign($RowsNewArray[$fi], $Rows[$RowsNewArray[$fi]]);
			}
		}
	}

	/* Enable/disable Profiler
	*
	* @access	public
	* @param	bool
	* @return	void
	*/
	function enable_profiler($val = TRUE) {
		Profiler::$enable_profiler = (is_bool($val)) ? $val : TRUE;
	}

	// --------------------------------------------------------------------
	/**
	* Set Profiler Sections
	*
	* Allows override of default / config settings for Profiler section display
	*
	* @access	public
	* @param	array
	* @return	void
	*/
	function set_profiler_sections($sections) {
		foreach ($sections as $section => $enable) {
			Profiler::$_profiler_sections[$section] = ($enable !== FALSE) ? TRUE : FALSE;
		}
		return $this;
	}
	public function getFormattedCurrency($originalPrice,$decimalType="Rounded",$from=0,$to=0)
	{
		$decimalType      = ($decimalType=='') ? 'Rounded' : $decimalType;
		if($from>0 && $to>0 && $originalPrice>0)
		{
			if($from==$to)
			{
				$originalPrice =  $originalPrice;
			}
			else
			{
				$defaultCurrency 	= $this->_currencies[$this->_defaultCurrency];
				if($defaultCurrency['CurrencyID']==$to)
				{
					$fromCurrencyDetails  = $this->_currencies[$from];
					if($defaultCurrency['currencyValue']<=0)
					{
						$originalPrice= 0;
					}
					else if($fromCurrencyDetails['currencyValue']<=0)
					{
						$originalPrice= 0;
					}
					else
					{
						$originalPrice= $originalPrice/$fromCurrencyDetails['currencyValue'];
					}
				}
				else if($defaultCurrency['CurrencyID']==$from)
				{
					$toCurrencyDetails  = $this->_currencies[$to];
					$originalPrice= $originalPrice*$toCurrencyDetails['currencyValue'];
				}
				else
				{
					$fromCurrencyDetails  = $this->_currencies[$from];
					$defaultCurValue = $originalPrice/$fromCurrencyDetails['currencyValue'];
					$toCurrencyDetails  = $this->_currencies[$to];
					$originalPrice = $defaultCurValue*$toCurrencyDetails['currencyValue'];
				}
			}
		}
		unset($defaultCurrency);
		if($to >0)
		{
			$defaultCurrency = $this->_currencies[$to];
			if(count($defaultCurrency)<1)
			{
				$defaultCurrency = $this->_currencies[$this->_defaultCurrency];	
			}
		}
		else
		{
			$defaultCurrency = $this->_currencies[$this->_defaultCurrency];
		}
		if(($decimalType=="Rounded")) 
		{
			$currencyDecimalPlaces= (($defaultCurrency['currencyDecimalPlaces'])>0)?
			($defaultCurrency['currencyDecimalPlaces']):0;
			$originalPrice          = round($originalPrice,$currencyDecimalPlaces);
			$originalPriceArray     = explode(".",$originalPrice);
			$originalPriceDecimal   = isset($originalPriceArray[1]) ? $originalPriceArray[1] : '';
			$originalPriceDecimalLength = strlen($originalPriceDecimal);
			
			if($originalPriceDecimalLength<$currencyDecimalPlaces&&$originalPriceDecimal!="") 
			{
				$originalPriceDecimalBalanceLength = $currencyDecimalPlaces-
				$originalPriceDecimalLength;
				$originalPrice =$originalPrice.str_repeat("0",
				$originalPriceDecimalBalanceLength);
			}				
		}
		elseif(($decimalType=="Full")) 
		{
			$currencyDecimalPlaces= (($defaultCurrency['currencyDecimalPlaces'])>0)?
			($defaultCurrency['currencyDecimalPlaces']):0;
			$originalPrice         =   number_format($originalPrice,$currencyDecimalPlaces,'.','');
		}
		if($defaultCurrency['currencySymbolLeft']!='') 
		{
			$originalPrice=$defaultCurrency['currencySymbolLeft'].$originalPrice;
		}
		elseif($defaultCurrency['currencySymbolRight']!='') 
		{
			$originalPrice=$originalPrice.$defaultCurrency['currencySymbolRight'];
		} 
		else 
		{
			$originalPrice=$originalPrice.$defaultCurrency['currencyCode'];
		}
		return $originalPrice;	
	}
	public function convertValueCustom($price = 0, $from = 0, $to = 0)
	{
		if ($price > 0 && $from > 0 && $to > 0)
		{
			if ($from == $to)
			{
				return $price;
			}
			else
			{
				$resDefaultCurrency = $this->_currencies[$this->_defaultCurrency];
				if ($resDefaultCurrency['CurrencyID'] == $to)
				{
					$resSelectCurrency = $this->_currencies[$from];
					if ($resDefaultCurrency['currencyValue'] <= 0)
					{
						return 0;
					}
					else if ($resSelectCurrency['currencyValue'] <= 0)
					{
						return 0;
					}
					else
					{
						$decimalPlace = $resDefaultCurrency['currencyDecimalPlaces'];
						$returnPrice  = $price / $resSelectCurrency['currencyValue'];
						return number_format($returnPrice,$decimalPlace, '.', '');
					}
				}
				else if ($resDefaultCurrency['CurrencyID'] == $from)
				{
					$resSelectCurrency = $this->_currencies[$to];
					$decimalPlace = $resSelectCurrency['currencyDecimalPlaces'];
					$returnPrice  = $price * $resSelectCurrency['currencyValue'];
					return number_format($returnPrice,$decimalPlace, '.', '');
				}
				else
				{
					$resSelectCurrency = $this->_currencies[$from];
					$defaultCurValue   = $price / $resSelectCurrency['currencyValue'];
					$resSelectCurrency = $this->_currencies[$to];
					$decimalPlace = $resSelectCurrency['currencyDecimalPlaces'];
					$returnPrice  = $defaultCurValue * $resSelectCurrency['currencyValue'];
					return number_format($returnPrice,$decimalPlace, '.', '');
				}
			}
		}
		else
		{
			return $price;
		}
	}
    public function getSefRequestPath($objectID, $type,$parent=0, $isSystem=1)
    {
        $idPath     =   $type.'/'.$objectID.'/'.(($parent>0)?$parent.'/':'');
        if($parent>0)
            $idPathDef     = $type.'/'.$objectID.'/';
        $url = $this->_sefurls[$idPath]['requestPath'];
        if($url)
            return $url;
        else 
            return $this->_sefurls[$idPathDef]['requestPath'];
    }
}