<?php
/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/	//
	//$Id: AdminlogController.php, v 1.0 2014/07/28 02:24:11
class AdminlogController extends Controller
{
	/* Adminlog Action List */
	public function indexAction()  
	{
		$ObjAdminlog		= new AdminlogModel();
		$languageIDs		= $this->ObjView->languageIDs;	
		$adminId			= $this->ObjCommon->manageUserID; 
		$this->ObjView->assign("editPrivilege",$this->ObjCommon->hasPrivilege('adminuser/edit/'));
		$deletePrivilege	= $this->ObjCommon->hasPrivilege('adminuser/destroy/');
		$this->ObjView->assign("deletePrivilege",$deletePrivilege);
		$settingsDateFormat = $this->getSettingValue("site_settings", "date_format");
		$settingsTimeFormat = $this->getSettingValue("site_settings", "time_format");
		
		$link	=	'adminlog/index/';
		if(isset($_POST['cleanLog']))
		{
			$rescleanAdminlog	= $ObjAdminlog->cleanAdminLog();
		}
		if (isset($_POST['search']))
		{			
			if ($_POST['user'] != ""){
				$link .= "user/" . $this->encodeUrlString($_POST['user']) . "/";
			}			
			if ($_POST['actionStatus'] != ""){
				$link .= "actionStatus/" . $this->encodeUrlString($_POST['actionStatus']) . "/";
			}	
			if ($_POST['actionObject'] != ""){
				$link .= "actionObject/" . $this->encodeUrlString($_POST['actionObject']) . "/";
			}			
			if ($_POST['actionType'] != ""){
				$link .= "actionType/" . $this->encodeUrlString($_POST['actionType']) . "/";
			}				
			if ($_POST['activityDate'] != ""){
				list($fromDate, $toDate) = split(' - ', $_POST['activityDate']);
				$link .= (($fromDate != "") ? "from/" . $this->urlDate($fromDate, 'set', $settingsDateFormat) . "/" :"");
				$link .= (($toDate != "") ? "to/" . $this->urlDate($toDate, 'set', $settingsDateFormat) . "/" :"");
			}	
			$this->setRedirect($link);
		}
		else
		{
			$sortby		=	$this->getRequestValue("sortby");
			$orderby	=	($this->getRequestValue("orderby")=="")?"asc":$this->getRequestValue("orderby");
					
			if($this->getRequestValue('user')){
				$user		= 	$this->decodeUrlString($this->getRequestValue('user'));
				$link.="/user/".$user;
			}			
			if($this->getRequestValue('actionStatus')){
				$actionStatus		= 	$this->decodeUrlString($this->getRequestValue('actionStatus'));
				$link.="/actionStatus/".$actionStatus;
			}	
			if($this->getRequestValue('actionObject')){
				$actionObject		= 	$this->decodeUrlString($this->getRequestValue('actionObject'));
				$link.="/actionObject/".$actionObject;
			}			
			if($this->getRequestValue('actionType')){
				$actionType		= 	$this->decodeUrlString($this->getRequestValue('actionType'));
				$link.="/actionType/".$actionType;
			}				
			if($this->getRequestValue('from')){
				$fromDate 		= $this->urlDate($this->getRequestValue('from'), 'get', $settingsDateFormat);
				$link .= (($fromDate != "") ? "from/" . $this->urlDate($fromDate, 'set', $settingsDateFormat) . "/" :"");
			}
			if($this->getRequestValue('to')){
				$toDate 		= $this->urlDate($this->getRequestValue('to'), 'get', $settingsDateFormat);
				$link .= (($toDate != "") ? "to/" . $this->urlDate($toDate, 'set', $settingsDateFormat) . "/" :	"");
			}		
		}
		list($limitFrom, $limitTo) = $this->getPageSettings($key = 'page', $rows = 10);
		/*assigning from and to values for search*/
		$assignFromDate =  $fromDate; 
        $assignToDate = $toDate;
        if (!$toDate && $fromDate){
           	 $toDate   = $fromDate; 
       	}
		$fromDate	= $this->convertDateForSQL($fromDate, $settingsDateFormat);
		$toDate		= $this->convertDateForSQL($toDate, $settingsDateFormat);
        /*assigning from and to values for search*/
		
		$params =array(
			'limitFrom'=>$limitFrom,
			'limitTo'=>$limitTo,
			'languageIDs'=>$languageIDs,
			'sortby'=>$sortby,
			'orderby'=>$orderby,'user'=>$user ,'actionStatus'=>$actionStatus,'actionObject'=>$actionObject ,'actionType'=>$actionType,'fromDate'=>$fromDate , 'toDate'=>$toDate
		);
		$resListAdminlog	= $ObjAdminlog->listAdminLog($params);
		
		$resPagesCount	= $this->setPagesCount($key = 'page');
		$this->ObjView->assign("page", $page);	
		$this->ObjView->assign("sortby", $sortby); $this->ObjView->assign("orderby", ($orderby=="asc")?'desc':'asc'); $this->ObjView->assign("user", $user); $this->ObjView->assign("actionStatus", $actionStatus); $this->ObjView->assign("actionObject", $actionObject); $this->ObjView->assign("actionType", $actionType);
		if($assignFromDate && $assignToDate==''){
			$this->ObjView->assign('activityDate', $assignFromDate);
		}else if($assignFromDate && $assignToDate){
			$this->ObjView->assign('activityDate', $assignFromDate.' - '.$assignToDate);
		}else{
			$this->ObjView->assign('activityDate','');
		}
		$this->ObjView->assign('resListAdminlog', $resListAdminlog);
		$this->ObjView->assign('settingsDateFormat', $settingsDateFormat);
		$this->ObjView->assign('settingsTimeFormat', $settingsTimeFormat);
		$this->ObjView->assign("link", $link);
		$this->ObjView->display('AdminlogList.tpl');
		
	}
	
	/* To Show the Admin */
	public function viewAction()    
	{
		$adminLogID  		= $this->getRequestValue('adminLogID');
		$ObjAdminlog    	= new AdminlogModel();
		$languageIDs        = $this->ObjView->languageIDs;
		$params=array(
			'adminLogID'=>$adminLogID   
		);
		$getAdminlogDetails	= $ObjAdminlog->getAdminlogDetails($params);
		
		$getAdminlogDetails['adminActionData'] = $this->encryptDecrypt("decrypt",$getAdminlogDetails['adminActionData']);
		$adminActionData	= unserialize($getAdminlogDetails['adminActionData']);
		$this->ObjView->assign('getAdminlogDetails', $getAdminlogDetails);
		$this->ObjView->assign('adminActionData', $adminActionData);
		$this->ObjView->display('AdminlogView.tpl');
		
	}
	
}