<?php
/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/
//
//$Id: AjaxController.php, v 1.0 2011/06/14 20:52:11
//
class AjaxController extends Controller
{
 
	public function __construct () 
	{
		$this->init();
	}
	//DISPLAY STATES USING AJAX
	public function statesAjaxAction()
	{
		$countryID	=	$_POST['countryID'];
		$objAjax = new StateModel();
		$languageIDs  = $this->ObjView->languageIDs;
		$statesList	=	$objAjax->listAjaxStates($languageIDs,$countryID);
		$this->ObjView->assign('statesList', $statesList);
		$this->ObjView->display('statesAjax.tpl');
		$this->ObjView->display('statesAjax.tpl');
	}
	//END OF FUNCTION
	//AJAX ACTION FOR CATALOG LINK GENERATION
	public function generateCatalogLinkAction()
	{
		$ObjDealCategory    = new DealCategoryModel();	
		$ObjProductList		= new ProductListModel();
		$languageIDs    	= $this->ObjView->languageIDs;
		$importDomElementEnabled = 0;
		//For binding URL to a DOM Element From Parent
		if($_GET["id"])
		{
			$importDomElement		 = $_GET["id"];
			$importDomElementType	 = "id";
			$importDomElementEnabled = 1;
		}
		elseif($_GET["class"])
		{
			$importDomElement		 = $_GET["class"];
			$importDomElementType	 = "class";
			$importDomElementEnabled = 1;
		}
		$resCategories		= $ObjDealCategory->listDealCategoryItems($languageIDs,0,'','','user');		
		if(is_array($resCategories))
		{
			array_shift($resCategories);
		}
		$this->ObjView->assign("importDomElementEnabled", $importDomElementEnabled);
		$this->ObjView->assign("importDomElement", $importDomElement);
		$this->ObjView->assign("importDomElementType", $importDomElementType);
		$this->ObjView->assign("resCategories", $resCategories);
		$this->ObjView->assign('listDiscountSchema', $ObjProductList->listDiscountSchema());
		$this->ObjView->assign('catalogUrlSeperatorSchema', json_encode($ObjProductList->getCatalogUrlSeperatorSchema()));
		$this->ObjView->assign('siteUrl',rtrim($this->getSettingValue('site_settings', 'global_http_url'),"/")."/catalog/id/");
		$this->ObjView->display('AjaxGenerateCatalogLink.tpl'); 		
	}
	//AJAX ACTION FOR LISTING ATTRIBUTES
	public function listAttributesAction()
	{
		echo json_encode($this->listAttributesForOption());
	}
	//Generate Attribute Array
	private function listAttributesForOption()
	{
		$ObjAttribute = new AttributeModel();	
		$languageIDs    = $this->ObjView->languageIDs;
		$params				= array
								(
									'isFilterable'	    => "Yes"
								);	
		$resAttributes  = $ObjAttribute->listAttributesWithOptions($languageIDs,$params);
		$i=0;
		$attrCheckArray = array();
		foreach($resAttributes as $attributes)
		{
			if($attributes['attrOptionID']>0)
			$attrOptionArray[$attributes['attributeID']][$attributes['attrOptionID']] = $attributes['attrOptName'];
			
			if(in_array($attributes['attributeID'],$attrCheckArray))
			continue;
			
			$attrCheckArray[] = $attributes['attributeID'];
			
			$attributeArray[$i]['attributeID'] = $attributes['attributeID'];
			$attributeArray[$i]['attrName'] = $attributes['attrName']."[ ".$attributes['attributeKey']." ]";
			$attributeArray[$i]['attrInputType'] = $attributes['attrInputType'];			
			$attributeArray[$i]['attributeKey'] = $attributes['attributeKey'];			
			$i++;
		}
		$attrData['attributeArray'] = $attributeArray;
		$attrData['attrOptionArray'] = $attrOptionArray;		
		return $attrData;
	}
}