<?php
/***************************************************************************
 *                                                                          *
 * Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
 *                                                                          *
 * This  is  commercial  software,  only  users  who have purchased a valid *
 * license  and  accept  to the terms of the  License Agreement can install *
 * and use this program.                                                    *
 *                                                                          *
 ****************************************************************************
 * PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
 * "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
 ****************************************************************************/ //
//$Id: CommonController.php, v 1.0 2011/06/14 20:52:11
//
class CommonController
{
    public $assignedDateFormat;
	public $ObjView;
	public $ObjSession;
	public $ObjCookie;
	//Admin User Details
	public $manageUserID;
	public $mangeUserTypeID;
	public $manageUserName;
	public $manageBranchCode;
	public $transSession;
	//Privilege
	public $fullPrivilegeList;
	public $userPrivilegeList;
    //CONSTRUCTOR
    public function __construct($ObjView, $ObjSession, $ObjCookie)
    {
		$this->ObjView		= $ObjView;
		$this->ObjSession	= $ObjSession;
		$this->ObjCookie	= $ObjCookie;		
		//Admin User Details
		$manageSessionID      	= $this->ObjSession->getSessionID();
        $this->manageUserID    	= $this->ObjSession->getSession("MANAGE_USER_ID".$manageSessionID);
        $this->mangeUserTypeID 	= $this->ObjSession->getSession("MANAGE_USER_TYPE_ID".$manageSessionID);
        $this->manageUserName  	= $this->ObjSession->getSession("MANAGE_USER_NAME".$manageSessionID);
		$this->manageBranchCode	= $this->ObjSession->getSession("MANAGE_BRANCH_CODE".$manageSessionID);
		$this->transSession		= $this->ObjSession->getSession("MANAGE_TRANS_USER".$manageSessionID);

		$this->objCache	= new Cache("file");
		$this->setCommonSettings();
		$this->isAjax = $this->isAjaxRequest();
		$this->setLanguage();
        $this->checkSettingsTimeout();
        $this->setHistoryURL();
        $this->setManageAccess();
        $this->setAddressFormatPlugin();
        $this->setCustomDateWithFormat();
		$this->checkTransPass();		
        if (!$this->isAjax)
        {
			$this->setManageRoles();
            $this->setMenu();          
			//For tracking Admin User's Activities
			//@Usage=>Analytics Module
			/* if(__ANALYTICS_MODULE)
			{
				$this->logTracking();
			} */
        }		
    }
	
	private function setCommonSettings()
	{
		/*
		setManageCurrentServerTimeZone
		setHeader
		datePickerDate
		
		setServerSessionTimeZone	- 	To set the Mysql server timezone 
		date_default_timezone_set	-	To set the PHP server timezone 
			
		*/
		$ObjTimeZone 				= 	new TimezoneModel();
		$defaultTimezone 			=	$this->getSettingValue('site_settings', 'default_timezone');
		$resTimeZone 				=	$ObjTimeZone->getTimezoneDetails($defaultTimezone,'timeZoneDetail,timeZoneAbbreviation,timeZoneDiff');
		date_default_timezone_set($resTimeZone['timeZoneDetail']);
		$ObjTimeZone->setServerSessionTimeZone('',$resTimeZone['timeZoneDiff']);
		$dateFormat 				=	$this->getSettingValue('site_settings','date_format');
		$timeFormat 				=	$this->getSettingValue('site_settings', 'time_format');
		$settingsFacebookPage 		=	$this->getSettingValue('facebook_settings', 'facebook_page');
        $settingsTwitterPage  		=	$this->getSettingValue('twitter_settings', 'twitter_page');
		$siteName 					=	trim($this->getSettingValue('site_settings', 'site_name'));
		$viewCommonSiteName 		=	trim($this->getSettingValue('site_settings', 'site_name')) . " ";
		
        switch ($dateFormat){
            case '%Y-%m-%d':$returnDateFormat = 'yy-mm-dd';break;
            case '%m/%d/%Y':$returnDateFormat = 'mm/dd/yy';break;
            case '%d-%m-%Y':$returnDateFormat = 'dd-mm-yy';break;
            default:$returnDateFormat = 'mm/dd/yy';
        }
		$adminColorTheme=$this->getSettingValue('site_settings', 'admin_color_theme');
        if ($adminColorTheme != "" && $adminColorTheme != "Default"){
            $this->ObjView->assign("view_common_theme_css", "theme_" . strtolower($adminColorTheme));
        }

        $siteNameStrPos        		=	strpos($viewCommonSiteName, " ");
        $siteNameStrLeft       		=	substr(stripslashes($siteName), 0, $siteNameStrPos);
        $siteNameStrRight      		=	substr(stripslashes($siteName), $siteNameStrPos);
        $viewCommonLogoCaption 		=	$siteNameStrLeft . "<em>" . $siteNameStrRight . "</em>";

		$this->ObjView->assign("view_common_site_name", $siteName);
        $this->ObjView->assign("view_common_logo_caption", $viewCommonLogoCaption);
        $this->ObjView->assign('settingsDateFormat', $dateFormat);
        $this->ObjView->assign('settingsTimeFormat', $timeFormat);
		$this->ObjView->assign("datePickerDateFormat", $returnDateFormat);
		$this->ObjView->assign("date_format", $dateFormat);
        $this->ObjView->assign("common_admin_timezone", $resTimeZone['timeZoneAbbreviation']);
        $this->ObjView->assign("timeZoneAbbreviation", $resTimeZone['timeZoneAbbreviation']);
		$this->ObjView->assign("settingsFacebookPage", $settingsFacebookPage);
        $this->ObjView->assign("settingsTwitterPage", $settingsTwitterPage);
		$this->ObjView->assign("time_format", $timeFormat);
		$this->ObjView->assign("commonSiteName", $siteName);
		$this->ObjView->assign("commonYear", date("Y"));
       
	}
		
    //TO SET MANAGE ACCESS
    public function setManageAccess()
    {
        $managePublicPages = explode(',', MANAGE_PUBLIC_ACCESS_PAGES);
        $managePublicPages = @array_merge($managePublicPages, array(
            "Validate"
        ));
        $manageUserID      = $this->manageUserID;
        $mangeUserTypeID      = $this->mangeUserTypeID;
		if($manageUserID)
		{
			$ObjAdminusers   = new AdminuserModel();
			if (!$ObjAdminusers->checkAdminUser($manageUserID,$mangeUserTypeID) && strtolower($this->ObjView->_controller)!='adminuser' && strtolower($this->ObjView->_action)!='logout')
			{	
				$this->setRedirect("adminuser/logout/");	
			}
		}
        if (substr($this->ObjView->_views_request_url, -1) != '/')
        {
        }
        if (substr($this->ObjView->_views_request_url, (strlen($this->ObjView->_views_request_url) - 6), strlen($this->ObjView->_views_request_url)) == $this->ObjView->_section)
        {
            $this->setRedirect("manage/index/");
        }
		//Issue with  loading login page on  ajax request page while clearing cookies or session logout
		if(!$manageUserID && $this->isAjax){
			echo "AJAX_OORJIT_MANAGE_TIMEOUT";
			exit;
		}
        if (!$manageUserID && !in_array($this->ObjView->_controller, $managePublicPages))
        {
            if (substr($this->ObjView->_views_request_url, (strlen($this->ObjView->_views_request_url) - 1), strlen($this->ObjView->_views_request_url)) == "/")
            {
                $this->setRedirect("login/");
            }
            else
            {
                $this->setRedirect("manage/login/");
            }
        }
        else
        {
			//Issue with pop up loading login page while clearing cookies or session logout
			if($this->ObjView->_controller=='Login'){
				echo '<script type="text/javascript">
					if(window.parent.document.getElementById("colorbox")){
						window.parent.location = window.parent.location.href;
						parent.$.colorbox.close();} </script>';
			}
            $this->ObjView->assign("view_common_manageUserID", $manageUserID);
            $this->ObjView->assign("view_common_manageUserTypeID", $this->mangeUserTypeID);
            $this->ObjView->assign("view_common_manageUserName", $this->manageUserName);
        }
		$this->ObjView->assign("profileEditPrivilege", $this->hasPrivilege('adminuser/profileedit/'));
    }
    //END OF FUNCTION
	
	//TO SET TRANSACTION PASSWORD CHECK
    public function checkTransPass()
    { 
		$success 			= $this->getRequestValue("success");
        $transCheckPages	= explode(',', TRANS_PASS_CHECK_PAGES);
		//Controller +  Action
		$action = strtolower($this->ObjView->_action);
		$queryarray = $this->ObjView->_views_url_array;
		$querylen	= count($queryarray);
		if($action=='')
		{
			$action = 'index';
		}
		$urlToCheck = strtolower($this->ObjView->_controller)."/".$action."/";
		
		$urlback	= "";
		for($i=0;$i<($querylen-1);$i++)
		{
			$urlback	.= $queryarray[$i];
			if($i==($querylen-2))
			{
				$urlback	.= "/";
			}
			else
			{
				$urlback	.= "_";
			}
		}
		//$manageSessionID= $this->ObjSession->getSessionID();
		//$transSession	= $this->ObjSession->getSession("MANAGE_TRANS_USER" . $manageSessionID);
		//$adminId		= $this->ObjSession->getSession("MANAGE_USER_ID" . $manageSessionID);
		$this->ObjView->assign("istransSession", $this->transSession);
		$this->ObjView->assign("isadminId", $this->manageUserID);
		if(in_array($urlToCheck, $transCheckPages))
		{
			if(($success!="yes") || ($transSession!=$adminId))
			{ 
				$this->setRedirect("adminuser/transPwd/urlback/".$urlback);
			}
		}
        
    }
    //END OF FUNCTION
	
    //TO SET HISTORY URL
    public function setHistoryURL()
    {
        $PrevHistoryURL = $this->ObjSession->getSession('COMMON_BROWSER_HISTORY_URL');
        $HistoryURL     = array();
        if (count($PrevHistoryURL) < 1)
        {
            $HistoryURL[0] = $this->ObjView->_views_url;
        }
        else if (($PrevHistoryURL[1]) != ($this->ObjView->_views_url))
        {
            $HistoryURL[0] = (empty($this->ObjView->_views_url)) ? "Index/" : $this->ObjView->_views_url;
            $HistoryURL[1] = (empty($PrevHistoryURL[0])) ? $HistoryURL[0] : $PrevHistoryURL[0];
            $HistoryURL[2] = (empty($PrevHistoryURL[1])) ? $HistoryURL[1] : $PrevHistoryURL[1];
            $HistoryURL[3] = (empty($PrevHistoryURL[2])) ? $HistoryURL[2] : $PrevHistoryURL[2];
            $HistoryURL[4] = (empty($PrevHistoryURL[3])) ? $HistoryURL[3] : $PrevHistoryURL[3];
        }
        else
        {
            $HistoryURL = $PrevHistoryURL;
        }
        $SessionHistoryURL = $this->ObjSession->unsetSession('COMMON_BROWSER_HISTORY_URL');
        $SessionHistoryURL = $this->ObjSession->setSession('COMMON_BROWSER_HISTORY_URL', $HistoryURL);
    }
    //END OF FUNCTION  
    //TO SET AJAX SECTIONS
    public function isAjaxRequest()
    {
        $managaeAjaxSections = "Validate,AjaxUploadImage,Ajax";
        //AJAX CONTROLLERS
        $managaeAjaxSections = explode(',', $managaeAjaxSections);
        if (@in_array($this->ObjView->_controller, $managaeAjaxSections) || (substr_count(strtolower($this->ObjView->_action), "ajax") > 0))
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    //END OF FUNCTION  
    //FUNCTION  TO SET ADDRESS FORMAT PLUGIN
    public function setAddressFormatPlugin()
    {
        $ObjCountry = new CountryModel();
        $this->ObjView->registerPlugin("modifier", "address_format", array(
            $ObjCountry,
            "getFormattedAddress"
        ));
        //return $addressOut;
		return;
    }
    //END OF FUNCTION
    //date modifier for getting the custom date with system assigned format
    public function setCustomDateWithFormat()
    {
        $ObjSettings = new SettingsModel();
        $this->ObjView->registerPlugin("modifier", "customDate", array(
            $ObjSettings,
            "getFormattedDate"
        ));
       // return $customDate;
	   return;
    }

    //TO GET SETTING VALUE
    public function getSettingValue($keyGroupID, $keyID = "")
    {
        $_settings     = Registry::getInstance('_settings');
		$_settings[$keyGroupID] = isset($_settings[$keyGroupID]) ? $_settings[$keyGroupID]  : '';
		$_settings[$keyGroupID][$keyID] = isset($_settings[$keyGroupID][$keyID]) ? $_settings[$keyGroupID][$keyID]  : '';
        $setting_value = ((empty($keyID)) ? ($_settings[$keyGroupID]) : ($_settings[$keyGroupID][$keyID]));
        // $setting_value=utf8_decode($setting_value);
        return $setting_value;
    }
    //END OF FUNCTION
    //TO SET LANGUAGE 
    public function setLanguage()
    {
        $ObjLanguage      	  = new LanguageModel();
        $resListLanguages 	  = $ObjLanguage->listLanguages();		
        $cookieLanguageID 	  = $this->ObjCookie->getCookie($this->ObjView->_section . '_CurrentLanguageID');
        $cookieLanguageStatus = false;
        $langArray			  = array();
        foreach ($resListLanguages as $language)
        {
            if ($language['languageDefault'] == 'Yes')
            {
                $this->languageIDs['Default'] = $language['languageID'];
                $defaultLanguageDetails       = $language;
				$defaultLCID				  = $language['LanguageLCIDstring'];
            }
            if ($language['languageID'] == $cookieLanguageID && $language['languageStatus']=='Active'){
                $cookieLanguageStatus= true;
                $currentLanguageDetails = $language;
            }
            //Active Languages Only
            if($language['languageStatus']=='Active')
            {
                    $this->languageIDs['All'][] = $language['languageID'];
                    $activeLanguages[] =  $language;
            }
            //All languages including Inactive	   
            $this->languageIDs['AllList'][] = $language['languageID'];
            $langArray[$language['languageID']] = $language;
        }
        if ($cookieLanguageID > 0 && $cookieLanguageStatus)
		{
            $this->languageIDs['Current'] = $cookieLanguageID;
		}
		else 
		{
            $this->languageIDs['Current'] = $this->languageIDs['Default'];
            $currentLanguageDetails       = $defaultLanguageDetails;
        }
		//Content Language ID
		$contentlanguageID	   = $ObjLanguage->getContentlanguageID($this->languageIDs['Default'],$this->languageIDs);
		$resContentLanguages   = $langArray[$contentlanguageID];
		//Content Language to $this->languageIDs
		$this->languageIDs['Content'] = $contentlanguageID;
        $this->ObjView->languageIDs  = $this->languageIDs;	
		$this->ObjView->languageIDsList  = $resListLanguages;
		$this->ObjView->_languageXML = $ObjLanguage->loadLanguageXMLtoArray(__CORE_PUBLIC_MANAGE_PATH . '/' . __DIR_LANGUAGE . '/' . $currentLanguageDetails['LanguageLCIDstring'] . '.xml');
		$this->ObjView->assign('language', $this->ObjView->_languageXML);
		$this->ObjView->assign('currentLanguageID', $this->languageIDs['Current']);						
		$this->ObjSession->setSession($ObjLanguage->getSection().'_ContentDefaultLCID',$defaultLCID) ;			
		$this->ObjView->assign('languageIDs', $this->languageIDs);
		$this->ObjView->assign('AjaxCurrLanguage', $currentLanguageDetails['LanguageLCIDstring']);
		$this->ObjView->assign('view_common_languages', $activeLanguages);
		$this->ObjView->assign("view_common_languageName", $currentLanguageDetails['languageName']);
		$this->ObjView->assign("view_common_languageImage", $currentLanguageDetails['languageImage']);		
		$this->ObjView->assign("view_content_languageName", $resContentLanguages['languageName']);
		$this->ObjView->assign("view_content_languageImage", $resContentLanguages['languageImage']);
    }
    //END OF FUNCTION 
    //TO SET MENU
    public function setMenu()
    {
        $ObjMenu            = 	new MenuModel();
        $curr_url_path      = 	$this->ObjView->_views_url_path;
        $manageUserID       = 	$this->manageUserID;
        $userTypeID        	= 	$this->mangeUserTypeID;		
		/*file caching for menus*/
		if ($userTypeID>0 && ! $view_common_top_menu = $this->objCache->get('m_menu_list_'.$userTypeID.'_'.$this->ObjView->languageIDs['Current'])) 
		{
			$campignEnable		=	$this->getSettingValue("third_paty_mail_settings", "campaign_api_key");	
			$params	= array
						(
							'languageXml' 	=> $this->ObjView->_languageXML,								
							'campignEnable' => $campignEnable,			
							'userTypeID' 	=> $userTypeID,			
							'manageUserID' 	=> $manageUserID,
							'_url_path'		=> $curr_url_path,
							'privilegeData'	=> $this->userPrivilegeList
						);
			$view_common_top_menu = $ObjMenu->setAdminMenu($params);
			$this->objCache->set('m_menu_list_'.$userTypeID.'_'.$this->ObjView->languageIDs['Current'],$view_common_top_menu,CACHE_TTL_LEVEL_1);
		} 
		/*file caching for menus*/
        $this->ObjView->assign("view_common_top_menu", $view_common_top_menu);
    }
    //END OF FUNCTION

    //END OF FUNCTION
    //FUNCTION TO REDIRECT URL 
    public function setRedirect($location_url = '',$ObjView='', $dynamic_url = "Yes")
    {
        if ($dynamic_url == "Yes")
        {
            if ($location_url == '')
            {
                $ObjRewrite   = Registry::getInstance('Rewrite');
                $location_url = implode($ObjRewrite->_queryDelimiter, $ObjRewrite->_queryString);
            }
            $location_url = $this->ObjView->_base_path . '/' . ltrim($location_url, '/'); 
        }
        header("Location:$location_url");
        exit;
    }
    //END OF FUNCTION  
    //FUNCTION TO SET ROLES
    public function setManageRoles()
    {
		//Controller +  Action
		$action = strtolower($this->ObjView->_action);
		if($action=='')
		{
			$action = 'index';
		}
		$urlToCheck = strtolower($this->ObjView->_controller)."/".$action."/";
		$this->askPrivilege($urlToCheck);
    }
    //END OF FUNCTION 
    //FUNCTION  TO CHECK SETTINGS TIME OUT
    public function checkSettingsTimeout()
    {
        $curr_url        = strtolower($this->ObjView->_controller . '/' . $this->ObjView->_action . '/');
        $ajaxKeyword     = 'ajax';
        $_settings       = Registry::getInstance('_settings');
        $timeOut         = $_settings['security_settings']['security_admin_timeout'];
        $manageSessionID = $this->ObjSession->getSessionID();
        if ($this->ObjSession->getSession("TIMEOUT" . $manageSessionID))
        {
            $userTimeout  = $this->ObjSession->getSession("TIMEOUT" . $manageSessionID);
            $session_life = time() - $userTimeout;
            if ($session_life > $timeOut && $timeOut != '')
            {
                $SessionDestroy = $this->ObjSession->unsetSession('TIMEOUT' . $manageSessionID);
                $this->setRedirect("adminuser/logout/");
            }
        }
        $this->ObjSession->setSession("TIMEOUT" . $manageSessionID, time());
    }
    //END OF FUNCTION  
    public function getEmailCommonBottom($languageIDs='')
    {
        if($languageIDs=='')
		{
			$languageIDs	 = $this->languageIDs;
		}	
		$ObjEmail        = new EmailtemplateModel();
        $siteName        = $this->getSettingValue('site_settings', 'site_name');
        $contactEmail    = $this->getSettingValue('site_settings', 'contact_email');
        $httpURL         = rtrim($this->getSettingValue('site_settings', 'global_http_url'), '/') . '/';
        $resCommonBottom = $ObjEmail->getEmailTempSection($languageIDs, 'email_bottom');
        $emailBottom     = $resCommonBottom['sectionContent'];
        $emailBottom     = str_replace('{$siteName}', $siteName, $emailBottom);
        $emailBottom     = str_replace('{$contactEmailAdress}', $contactEmail, $emailBottom);
        $emailBottom     = str_replace('{$siteURL}', $httpURL, $emailBottom);
        $this->ObjView->assign("emailBottom", $emailBottom);
    }
	public function fetch($layoutTemplate,$languageIDsOthers = "")
	{
		$this->getEmailCommonBottom($languageIDsOthers);
		$body	= $this->ObjView->fetch($layoutTemplate);
		return $body;
	}
    //FUNCTION FOR TRACKING VISITORS URL
    public function logTracking()
    {
	   $settingsSiteUrl ='';
        $ObjLog         		=	new LogModel();
        $userType      			=	"manage";
		$sslEnable				=	0;//Counter For Checking Whether SSL is enabled or not	
        $visitorID      		=	$this->ObjCookie->getCookie("AD_VISITORID");
        $visitorType    		=	$this->ObjCookie->getCookie("AD_VISITORTYPE");
        $controllerName 		=	$this->ObjView->_controller;
        if(@$_SERVER["HTTPS"] == "on")
		$sslEnable				=	1;	
		$httpUrl				=	$this->getSettingValue('site_settings', 'global_http_url');
		$httpsURL				=	$this->getSettingValue('site_settings', 'global_https_url');
       
        $currentURL        = $ObjLog->getCurrentUrl($httpUrl,$httpsURL); //fetching Current URL	
        $httpReferer       = $ObjLog->getCurrentReferrer($httpUrl,$httpsURL,'',$sslEnable);
        $bannedURLs        = array(
            "validate",
            "ajax",
            "dealCatKeyExists",
            "dealCategoryExits",
            "dealCatKeyExists",
            "checkName",
            "linkexists",
            "/destroy",
            "checkdealTypeExists",
            "statesAjax",
            "Ajax",
            "samplecsv",
            "remarketingID",
            "conversionID",
            "businessTypeExits",
            "mssg",
			"task"
        );
        $traverseBannedURL = 0;
        foreach ($bannedURLs as $key)
        {
            if (strpos(strtolower($currentURL), strtolower($key)) != false)
            {
                $traverseBannedURL = 1;
                break;
            }
            else
            {
                $traverseBannedURL = 0;
            }
        }
        $currentURLSession  = $this->ObjSession->getSession("CURRENT_URL");
        $httpRefererSession = $this->ObjSession->getSession("REFERRER_URL");
        if (!$visitorID)
        {
            $isDirect  = $ObjLog->getCurrentReferrer($settingsSiteUrl, $checkDirect = 1);
            $visitorID = $ObjLog->saveVisitorDetails($userType, $currentURL, $isDirect); //Save Visitors Basic Details
            $this->ObjCookie->setCookie("AD_VISITORID", $visitorID, 1800, "/"); //Setting Of VisitorId Cookie
            $this->ObjCookie->setCookie("AD_VISITORTYPE", $userType, 1800, "/"); //setting Of Visitor Type Cookie
        }
        if ($visitorID)
        {
            if ($traverseBannedURL == 0)
            {
                //TO SKIP DUPLICATE URL IN CASE IF THE SAME URL ATTACHED WITH INDEX ACTION
                $indexInCurrentURL = strpos($currentURL, "/index");
                if (!$indexInCurrentURL || $indexInCurrentURL == '')
                {
                    $checkCurrentURl = $currentURL . "index/";
                }
                else
                {
                    $checkCurrentURl = $currentURL;
                }
                $indexInCurrentSession = strpos($currentURLSession, "/index");
                if (!$indexInCurrentSession || $indexInCurrentSession == '')
                {
                    $checkCurrenttSession = $currentURLSession . "index/";
                }
                else
                {
                    $checkCurrenttSession = $currentURLSession;
                }
                //SKIPING URLS ATTACH WITH INDEX ACTION ENDS HERE
				$siteURL = isset($siteURL) ? $siteURL  : '';
                if (($currentURL != $currentURLSession) && ($currentURL != $siteURL) && $checkCurrentURl != $checkCurrenttSession)
                {
                    $ObjLog->saveURLInfo($visitorID, $currentURL, '', $httpReferer,$userType); //for saving each and every Urls
                    $this->ObjCookie->setCookie("AD_VISITORID", $visitorID, 1800, "/"); //Setting Of VisitorId Cookie
                    $this->ObjCookie->setCookie("AD_VISITORTYPE", $userType, 1800, "/"); //setting Of Visitor Type Cookie
                    $this->ObjSession->setSession("CURRENT_URL", $currentURL);
                    $this->ObjSession->setSession("REFERRER_URL", $httpReferer);
                }
            }
        }
    }
   	
	public function generateKey($section = "", $name, $objectID = "", $type = "")
	{
	  if ($name != '') {
		$key 	= 	str_replace(" ", "-", trim($name)); // Replaces all spaces with hyphens.
		$key 	= 	preg_replace('/[^A-Za-z0-9\-]/', '-', $key); // Removes special chars.
		$key 	= 	preg_replace('/-+/', '-', $key); // Removes continuous hypens with a single hypen.
		if($section == "cms")
			$key	=	trim($key, "-");
		
		if($type == "unique") {
			$ObjUrlrewrite 	= new UrlrewriteModel();
			switch($section) {
				case "cms" :
					$tableDtls = array("fieldIdNme"=>"contentID", "fieldKeyNme"=>"contentUrlKey", "tbleName"=>"content_pages");
					break;
				case "menuitem" :
					$tableDtls = array("fieldIdNme"=>"menuItemID", "fieldKeyNme"=>"menuItemKey", "tbleName"=>"menu_item");
					break;
				case "catalog" :
					$tableDtls = array("fieldIdNme"=>"dealCategoryID", "fieldKeyNme"=>"dealCategoryKey", "tbleName"=> "deal_categories");
					break;
                                case "blog" :
                                        $tableDtls = array("fieldIdNme"=>"blogID", "fieldKeyNme"=>"blogUrlKey", "tbleName"=> "blog_posts");
					break;
                                  case "business" :
                                        $tableDtls = array("fieldIdNme"=>"businessID", "fieldKeyNme"=>"businessKey", "tbleName"=> "business");
					break;
                                  case "blogCategory" :
                                        $tableDtls = array("fieldIdNme"=>"blogCategoryID", "fieldKeyNme"=>"blogCategoryKey", "tbleName"=> "blog_categories");
					break;  
 			}
			$tableDtls["key"] 	   = $key;
			$tableDtls["objectID"] = $objectID;
			
			$key = $ObjUrlrewrite->checkKeyExists($tableDtls);
			//echo "<pre>";print_R($tableDtls);echo $exists;exit;
		}
      }
	  return strtolower($key);
	}
	//Read privilege File
	public function getPrivilegeData()
	{				
		if(!empty($this->userPrivilegeList))
		{
			$privilegeArrayUrl   = $this->userPrivilegeList;
		}
		else
		{
			$ObjRoles        	 = new RolesModel();
			$privilegeArrayUrl   = $ObjRoles->getPrivilageFile($this->mangeUserTypeID);
			$this->userPrivilegeList = $privilegeArrayUrl;
		}	
		return $privilegeArrayUrl;
	}
	//Check User privilege
	public function hasPrivilege($urlToCheck)
	{			
		$manageUserTypeID 			 	= $this->mangeUserTypeID;
		$accessprivilage = true;
		if ($manageUserTypeID != 1 && $manageUserTypeID>1)
        {            	           
			$urlToCheck = strtolower($urlToCheck);
			if (strpos($urlToCheck, 'ajax') == false)
            {				
				//PRIVILEGE_ARRAY = roles data of a particular user type
				$privilegeArray   = $this->getPrivilegeData(); 				
				$accessprivilage = false;
				//Checks whether URL exists in PRIVILEGE_ARRAY
                if ($privilegeArray && in_array($urlToCheck, $privilegeArray))
                {
                    $accessprivilage = true;                   
                }
                else //Checking if it is a Privileged URL 
				{					
					//PRIVILEGE_FULL_ARRAY = Get Full privilege URLs
					$privilegeFullArray = $this->listRolesData();
					//if URL not exists in PRIVILEGE_FULL_ARRAY , Access Permitted
					if (!in_array($urlToCheck, $privilegeFullArray))
					{
						$accessprivilage = true;
					}	
				}
            }
        }
		return $accessprivilage;
	}
	//List Roles Data
	private function listRolesData()
	{				
		//Check in Common Controller Variable
		if(!empty($this->fullPrivilegeList))
		{
			$roles = $this->fullPrivilegeList;
		}
		elseif(!$roles = $this->objCache->get('m_full_roles_list'))  //Check in Cache
		{
			$ObjRoles             = new RolesModel();
			//Roles Schema
			$schemaRoles = $ObjRoles->includeRolesSchema();
			$params		= array
							(
								'schemaData' 	=> $schemaRoles['permissions'],
								'rolesStr' 		=> ''
							);
			$roles =  explode("~*",$this->listRolesItems($params));
			$this->objCache->set('m_full_roles_list',$roles,CACHE_TTL_LEVEL_1);
			//Assign to Common Controller Variable
			$this->fullPrivilegeList = $roles;
		}
		return $roles;
	}
	//List Roles Items
	private function listRolesItems($params)
	{
		extract($params);
		$rolesStr = '';
		if(!empty($schemaData))
		{
			foreach($schemaData as $arrayKey => $schema)	
			{
				$currRoleKey					= $schema['adminModuleURLKey'];			
				$resSubRolesCount 				= count($schema['adminSubMenu']);
				if($currRoleKey!='')
				{					
					$rolesStr.= $currRoleKey."~*";	
				}	
				if($resSubRolesCount>0)
				{																				
					$params	= array
								(
									'schemaData' 		=> $schema['adminSubMenu'],
									'rolesSubArray' 	=> $rolesSubArray
								);
					
					$rolesStr.=$this->listRolesItems($params);					
				}				
			}			
		}
		return $rolesStr;
	}
	//Ask privilege : to be used for checking privilege & redirect 
	public function askPrivilege($urlToCheck='')
	{		
		if($urlToCheck!='' && !$this->hasPrivilege($urlToCheck)) 
		{ 
			$redirectUrl = 'privilege/';
			$this->setRedirect($redirectUrl);
		}
	}
	
	//To get the value of the query string from the url
	public function getRequestValue($queryStringKey=0)  
	{
		$ObjRewrite 	= Registry::getInstance('Rewrite');
		if(is_integer($queryStringKey))	
		{
			return (trim($ObjRewrite->_queryString[$queryStringKey]));
		} 
		else 
		{
			$queryStringKeyNumber = (array_search($queryStringKey, $ObjRewrite->_queryString)+1);
			return ($queryStringKeyNumber>1)?trim($ObjRewrite->_queryString[$queryStringKeyNumber]):"";
		}
	}
	
	/**** To Get ClientIP ****/
	public function getClientIP() 
	{
		$ipaddress = '';
		if (isset($_SERVER['HTTP_CLIENT_IP']))
			$ipaddress = $_SERVER['HTTP_CLIENT_IP'];
		else if(isset($_SERVER['HTTP_X_FORWARDED_FOR']))
			$ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
		else if(isset($_SERVER['HTTP_X_FORWARDED']))
			$ipaddress = $_SERVER['HTTP_X_FORWARDED'];
		else if(isset($_SERVER['HTTP_FORWARDED_FOR']))
			$ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
		else if(isset($_SERVER['HTTP_FORWARDED']))
			$ipaddress = $_SERVER['HTTP_FORWARDED'];
		else if(isset($_SERVER['REMOTE_ADDR']))
			$ipaddress = $_SERVER['REMOTE_ADDR'];
		else
			$ipaddress = 'UNKNOWN';

		return $ipaddress; 
	}
	/**** End To Get ClientIP ****/
}
