<?php
	/***************************************************************************
*                                                                          *
* Copyright (c) 2005 ISPG Technologies (I) Pvt Ltd. All rights reserved.   *
*                                                                          *
* This  is  commercial  software,  only  users  who have purchased a valid *
* license  and  accept  to the terms of the  License Agreement can install *
* and use this program.                                                    *
*                                                                          *
****************************************************************************
* PLEASE READ THE FULL TEXT  OF THE SOFTWARE  LICENSE   AGREEMENT  IN  THE *
* "copyright.txt" FILE PROVIDED WITH THIS DISTRIBUTION PACKAGE.            *
****************************************************************************/	//
	//$Id: CountryController.php, v 1.0 2011/06/14 20:52:11
	//
	class CountryController extends Controller{
		public function indexAction()  {
			$ObjCountry                =new CountryModel();
			$languageIDs				= $this->ObjView->languageIDs;
			$languageIDs['Current'] =	$languageIDs['Content'];
			$keyword =$this->getRequestValue("keyword");
			$resListCountryAlphabets   =$ObjCountry->listCountryAlphabets($languageIDs);
			list($limitFrom,$limitTo)   =   $this->getPageSettings($key='page',$rows=10);
			$resListCountries   =$ObjCountry->listCountries($languageIDs,"",$limitFrom,$limitTo,'ASC',$keyword,$stateCount="Yes",$addressFormat="Yes");
			$resPagesCount   =$this->setPagesCount($key='page');
			$ObjAdminlog		= new AdminlogModel();
			$adminId			= $this->ObjCommon->manageUserID;			
			if(isset($_POST['submitBulkStatus']) && count($_POST['countryBulkStatus'])!=0){
				$countryNames	= array();
				$countryIDs		= array();
				$status			= $_POST['countryStatus'];
				foreach($_POST['countryBulkStatus'] as $key=>$countryValues)
				{
					$countryNames[]	= $key;
					$countryIDs[]	= $countryValues[0];
				}
				$resCountryStatus   = $ObjCountry->changeCountryStatus($countryIDs,$status);
				$this->setMessage("language.msgStatus",3);
				/* Adminlog */
				$adminAccessIP						= $this->ObjCommon->getClientIP();
				$i									= 0;
				$adminActionData					= array();
				$adminActionData[$i]['status']		= "Updated The Status";
				$adminActionData[$i]['response']	= "Country Bulk Status Updated Successfully";
				$adminActionData[$i]['message']		= "Updated Status of Countries<br/>";
				$adminActionData[$i]['message']		.= "<div class='grid_table00'>
			<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>CountryID</td><td width='50%' height='15%' align='left'>Country Name</td><td width='30%' height='15%' align='left'>Country Available</td></tr>";
				for($s=0;$s<count($countryIDs);$s++)
				{
					$adminActionData[$i]['message']		.= "<tr><td align='left'><b>".$countryIDs[$s]."</b></td><td align='left'><b>".$countryNames[$s]."</b></td><td align='left'><b>".$status."</b></td></tr>";
				}
				$adminActionData[$i]['message']		.= "</table></div><br/>";
				$i++;
					
				$adminActionDataStr					= serialize($adminActionData);

				$params =array(
				'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Bulk Status', 'adminActionObject'=>'Country', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
				);
				$ObjAdminlog->insertAdminlog($params);
				/* End Adminlog */
				$this->setRedirect();
			}
			$this->ObjView->assign('keyword', $keyword);
			$this->ObjView->assign('resListCountryAlphabets', $resListCountryAlphabets);
			$this->ObjView->assign('resListCountries', $resListCountries);
			$this->ObjView->assign("editPrivilege",$this->ObjCommon->hasPrivilege('country/edit/'));
			$this->ObjView->assign("stateprivilage",$this->ObjCommon->hasPrivilege('state/index/'));
			$this->ObjView->display('Country.tpl');
		}
		
		public function editAction()  {
			$ObjCountry                 = new CountryModel();
			$languageIDs				= $this->ObjView->languageIDs;
			$languageIDs['Current'] 	= $languageIDs['Content'];
			$countryID					= $this->getRequestValue("id");
			$ObjAdminlog				= new AdminlogModel();
			$adminId					= $this->ObjCommon->manageUserID;
			$resCountry					= $ObjCountry->getCountryDetails($countryID,$languageIDs);
			$resListAddresFormat 		= $ObjCountry->listCountryAddressFormat();
			 if($this->ObjForm->isValid('formCountrySubmit', 'submitCountryEdit')){
				$resSaveCountry = $ObjCountry->saveCountry($languageIDs,$_POST,$countryID);
				/* Adminlog */
				$adminAccessIP						= $this->ObjCommon->getClientIP();
				$i									= 0;
				$adminActionData					= array();
				$adminActionData[$i]['status']		= "Updated";
				$adminActionData[$i]['response']	= "Successfully Updated The Country: <b>".$resCountry['countryName']."</b>";
				$i++;
				if($resCountry['countryName']!=$_POST['countryName'])
				{
					$adminActionData[$i]['field']	= "CountryName";
					$adminActionData[$i]['Old']		= $resCountry['countryName'];
					$adminActionData[$i]['New']		= $_POST['countryName'];
					$i++;
				}
				if($resCountry['countryIsoA2']!=$_POST['countryIsoA2'])
				{
					$adminActionData[$i]['field']	= "CountryIsoA2";
					$adminActionData[$i]['Old']		= $resCountry['countryIsoA2'];
					$adminActionData[$i]['New']		= $_POST['countryIsoA2'];
					$i++;
				}
				if($resCountry['countryIsoA3']!=$_POST['countryIsoA3'])
				{
					$adminActionData[$i]['field']	= "CountryIsoA3";
					$adminActionData[$i]['Old']		= $resCountry['countryIsoA3'];
					$adminActionData[$i]['New']		= $_POST['countryIsoA3'];
					$i++;
				}
				if($resCountry['countryIsoNumber']!=$_POST['countryIsoNumber'])
				{
					$adminActionData[$i]['field']	= "CountryIsoNumber";
					$adminActionData[$i]['Old']		= $resCountry['countryIsoNumber'];
					$adminActionData[$i]['New']		= $_POST['countryIsoNumber'];
					$i++;
				}
				if($resCountry['countryAvailable']!=$_POST['countryAvailable'])
				{
					$adminActionData[$i]['field']	= "CountryAvailable";
					$adminActionData[$i]['Old']		= $resCountry['countryAvailable'];
					$adminActionData[$i]['New']		= $_POST['countryAvailable'];
					$i++;
				}
				
				if(count($adminActionData)==1)
				{
					$adminActionData[0]['message']	= "No Changes for Form Elements OR Minor Changes";
				}
				$adminActionDataStr					= serialize($adminActionData);

				$params =array(
				'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Edit', 'adminActionObject'=>'Country', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
				);
				$ObjAdminlog->insertAdminlog($params);
				/* End Adminlog */
				echo '<script type="text/javascript">window.parent.location = window.parent.location.href;parent.$.colorbox.close(); </script>';
				$this->setMessage("language.msgCountry",3);
				exit;
			}
			else
			{
				if(isset($_POST['submitCountryEdit']))
				{
					if(!$this->ObjForm->isValid('formCountrySubmit','submitCountryEdit'))
					{
						/* Adminlog */
						$adminAccessIP		= $this->ObjCommon->getClientIP();
						$i									= 0;
						$adminActionData					= array();
						$adminActionData[$i]['status']		= "Update Failed";
						$adminActionData[$i]['response']	= "Error found in form element";
						$adminActionData[$i]['message']		= "Country: <b>".$resCountry['countryName']."</b> Cannot Be Updated";
						$i++;
						$adminActionDataStr					= serialize($adminActionData);
						$params =array(
						'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Edit', 'adminActionObject'=>'Country', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Failure', 'adminUserID'=>$adminId 
						);
						$ObjAdminlog->insertAdminlog($params);
						/* End Adminlog */
					}
				}
			}
			$this->ObjView->assign('contentlanguageID', $languageIDs['Current']);
			$this->ObjView->assign('countryID', $countryID);
			//$this->ObjView->assign('resListCountryAlphabets', $resListCountryAlphabets);
			$this->ObjView->assign('resListAddresFormat', $resListAddresFormat);
			$this->ObjView->assign($resCountry);
			$this->ObjView->display('CountryEdit.tpl');
		}
		//TO SET PRIORITY
		public function priorityAction()  {
			$ObjCountry               = new CountryModel();
			$languageIDs = $this->ObjView->languageIDs;
			$languageIDs['Current'] 	= $languageIDs['Content'];
			$ObjAdminlog		= new AdminlogModel();
			$adminId			= $this->ObjCommon->manageUserID;
			$resListCountryLeft = $ObjCountry->listCountries($languageIDs,"Yes",$limitFrom,$limitTo,'ASC',$keyword,$stateCount=                                       "No",$addressFormat="No",$priorityType="NotAssined");
			$resListCountryRight = $ObjCountry->listCountries($languageIDs,"Yes",$limitFrom,$limitTo,'ASC',$keyword,$stateCount=                                       "No",$addressFormat="No",$priorityType="Assined");
			$this->ObjView->assign('resListCountryLeft', $resListCountryLeft);
			$this->ObjView->assign('resListCountryRight', $resListCountryRight);
			$this->ObjView->display('CountryPriority.tpl');
		}
		//END OF FUNCTION
		//TO SET PRIORITY  USING AJAX
		public function ajaxPriorityAction()  {
			$ObjCountry                 =   new CountryModel();
			$priorityString=$this->decodeSplChar($this->escape($_POST['ajax_request'][0],TRUE,FALSE));
			$resPriorityCountry=  $ObjCountry->changeCountryPriority($priorityString);
		}

		//END OF FUNCTION
		//FUNCTION TO CHECK COUNTRY EXISTS
		public function ajaxCountryExistAction()  {
			$ObjCountry               = new CountryModel();
			$languageIDs        =   $this->ObjView->languageIDs;
			$countryID  =   $_POST['countryID'];
			$countryName     =   $_POST['countryName'];
			$countryIsoA2       =   $_POST['countryIsoA2'];
			$countryIsoA3    =   $_POST['countryIsoA3'];
			$countryIsoNumber   =   $_POST['countryIsoNumber'];
			$check     =   $ObjCountry->getCountryCount($languageIDs, $countryID, $countryName, $countryIsoA2, $countryIsoA3,$countryIsoNumber);
			return $check;
		}

		//END OF FUNCTION
		public function ajaxstatusAction()
		{
			$ObjCountry			= new CountryModel();
			$history 			= $this->getPreviousURL();
			$countryIDs			= array($_POST['id']);
			$status				= $_POST['newstatus'];	
			$name				= $_POST['name'];
			$ObjAdminlog		= new AdminlogModel();
			$adminId			= $this->ObjCommon->manageUserID;
			$resCountryStatus   = $ObjCountry->changeCountryStatus($countryIDs,$status);
			$this->setMessage("language.msgStatus",3);
			/* Adminlog */
			$adminAccessIP						= $this->ObjCommon->getClientIP();
			$i									= 0;
			$adminActionData					= array();
			$adminActionData[$i]['status']		= "Updated The Status";
			$adminActionData[$i]['response']	= "Country Status Updated Successfully";
			$adminActionData[$i]['message']		= "Updated Status of Countries<br/>";
			$adminActionData[$i]['message']		.= "<div class='grid_table00'>
			<table width='100%' border='0' cellspacing='0' cellpadding='0'><tr><td width='20%' height='15%' align='left'>CountryID</td><td width='50%' height='15%' align='left'>Country Name</td><td width='30%' height='15%' align='left'>Country Available</td></tr><tr><td align='left'><b>".$_POST['id']."</b></td><td align='left'><b>".$name."</b></td><td align='left'><b>".$status."</b></td></tr></table></div><br/>";

			$i++;
			$adminActionDataStr					= serialize($adminActionData);

			$params =array(
			'adminActionData'=>$adminActionDataStr, 'adminActionType'=>'Status', 'adminActionObject'=>'Country', 'adminAccessIP'=>$adminAccessIP, 'adminActionStatus'=>'Success', 'adminUserID'=>$adminId 
			);
			$ObjAdminlog->insertAdminlog($params);
			/* End Adminlog */
			if($resCountryStatus)
				echo 1;
		}
		
	}